/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.table.gui;

import oracle.dss.gridView.ConditionElement;
import oracle.dss.gridView.UIFormat;
import oracle.dss.gridView.UIGridView;
import oracle.dss.gridView.gui.FormatsPanel;
import oracle.dss.gridView.gui.RulesPanel;
import oracle.dss.rules.discriminator.Discriminator;
import oracle.dss.table.Table;
import oracle.dss.table.TableFormatUtil;
import oracle.dss.table.UITable;
import oracle.dss.table.gui.TableConditionalFormatPanel;
import oracle.dss.table.gui.TableRulesPanel;

public class TableFormatsPanel
extends FormatsPanel {
    private static final long serialVersionUID = 1L;
    private TableRulesPanel m_rulesPanel = null;

    public TableFormatsPanel(UITable table) {
        super(table);
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        if (this.m_rulesPanel != null) {
            this.m_rulesPanel.cleanUp();
            this.m_rulesPanel = null;
        }
    }

    @Override
    protected RulesPanel getRulesPanel(UIGridView gridView) {
        return this.getRulesPanel(gridView, false);
    }

    @Override
    protected RulesPanel getRulesPanel(UIGridView gridView, boolean header) {
        if (this.m_rulesPanel == null) {
            this.m_rulesPanel = new TableRulesPanel(gridView, header);
        } else {
            this.m_rulesPanel.setGridView(gridView, header);
        }
        return this.m_rulesPanel;
    }

    @Override
    protected RulesPanel getRulesPanel(UIGridView gridView, Discriminator disc, ConditionElement valueCondition, boolean header) {
        if (this.m_rulesPanel == null) {
            this.m_rulesPanel = new TableRulesPanel(gridView, disc, header);
        }
        this.m_rulesPanel.setGridView(gridView, disc, null, header);
        return this.m_rulesPanel;
    }

    @Override
    protected RulesPanel getStoplightRulesPanel(UIGridView gridView, Discriminator disc) {
        if (disc == null) {
            return new TableRulesPanel(gridView, false);
        }
        return new TableRulesPanel(gridView, disc, false);
    }

    @Override
    protected Discriminator getSelectionDisc() {
        try {
            TableFormatUtil util = new TableFormatUtil(this.m_gridView, this.m_gridView.getSelectedObject());
            return util.getDiscriminator();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void invokeConditonalFormat(UIFormat format) {
        boolean edit = format != null;
        TableConditionalFormatPanel tmpPanel = new TableConditionalFormatPanel((Table)this.m_gridView, format);
        FormatsPanel.PanelDialog tmpDialog = this.createPanelDialog(this.rBundle.getString("Edit Data"), true, tmpPanel, this.m_bHelpEnabled, 1, null, this.getHelpProvider());
        tmpDialog.show();
        if (this.m_ok) {
            if (edit) {
                tmpPanel.editApplyFormat();
                this.m_formatsTableModel.setFormatAt(tmpPanel.getUIFormat(), this.m_formatsTable.getSelectedRow());
            } else {
                tmpPanel.applyFormat();
                this.m_formatsTableModel.addFormat(tmpPanel.getUIFormat());
            }
        }
    }
}

