/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.table;

import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.BeanInfo;
import java.util.Dictionary;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.event.EventListenerList;
import oracle.bali.ewt.geometry.GeneralGeometryManager;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.bigCell.BigCellTwoDModel;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.model.OneDModel;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.pivot.CollapseEvent;
import oracle.bali.ewt.pivot.CollapseListener;
import oracle.bali.ewt.pivot.DrillEvent;
import oracle.bali.ewt.pivot.DrillListener;
import oracle.bali.ewt.pivot.PagingPivotEvent;
import oracle.bali.ewt.pivot.PagingPivotListener;
import oracle.bali.ewt.table.SpreadTable;
import oracle.dss.gridView.GridViewTable;
import oracle.dss.table.ColHeader;
import oracle.dss.table.ColHeaderData;
import oracle.dss.table.HeaderData;
import oracle.dss.table.RowHeader;
import oracle.dss.table.RowHeaderData;
import oracle.dss.table.Table;
import oracle.dss.table.TableData;
import oracle.dss.table.TableDatabody;
import oracle.dss.table.TableDefaultValues;
import oracle.dss.table.TableHeader;
import oracle.dss.table.TableTips;
import oracle.dss.util.Range;

public class TableSpreadTable
extends SpreadTable
implements GridViewTable {
    private static final long serialVersionUID = 1L;
    protected TableDatabody grid = null;
    protected ColHeader colHeader = null;
    protected RowHeader rowHeader = null;
    protected transient Table table;
    protected JLabel nodatalabel;
    protected TableTips tips = null;
    protected EventListenerList listenerList = new EventListenerList();
    protected transient int[] m_calculatedRowHeights;
    protected transient int[] m_calculatedColWidths;
    protected transient boolean[] m_sizedRowFlags;
    protected transient boolean[] m_sizedColFlags;
    protected transient int m_calculatedRowCount = 0;
    protected transient int m_accumulatedCalculatedRowHeight = 0;
    protected transient int m_calculatedColCount = 0;
    protected transient int m_accumulatedCalculatedColWidth = 0;
    protected boolean m_bCheckingRowHeights = false;
    protected boolean m_bCheckingColWidths = false;
    protected boolean canPaint = true;
    protected boolean m_bIncrementalFetchRowVisible = false;
    private boolean m_bSwapAllowed = TableDefaultValues.isSwapAllowed();
    private int m_freezeLevel = 0;
    private static final String m_method_firecollapse = "fireCollapse (int orientation, int column, int row)";
    private static final String m_method_firedrillevent = "fireDrillEvent (int orientation, int column, int row, Object info)";
    private static final String m_method_fireheadercelldrillrequest = "fireHeaderCellDrillRequest (int orientation, int column, int row)";
    private static final String m_method_firepivotevent = "firePivotEvent (Object source, int sourceIndex, Object destination, int destinationIndex)";
    private static final String m_method_fireswapevent = "fireSwapEvent (Object source, int sourceIndex, Object destination, int destinationIndex)";
    private static final String m_method_checkResizeRowHeights = "protected void checkResizeRowHeights()";
    private static final String m_method_checkResizeColumnWidths = "protected void checkResizeColumnWidths()";

    public TableSpreadTable(TableData _gridModel, ColHeaderData _colHeaderModel, RowHeaderData _rowHeaderModel) {
        super((TwoDModel)_gridModel, (OneDModel)_colHeaderModel, (OneDModel)_rowHeaderModel);
        ((GeneralGeometryManager)this.getColumnGeometryManager()).setDefaultMinimumItemSize(0);
        ((GeneralGeometryManager)this.getRowGeometryManager()).setDefaultMinimumItemSize(0);
    }

    public void init(Table t) {
        this.grid = (TableDatabody)this.getGrid();
        this.colHeader = (ColHeader)this.getColumnHeader();
        this.rowHeader = (RowHeader)this.getRowHeader();
        this.table = t;
        this.nodatalabel = new JLabel(ResourceBundle.getBundle("oracle.dss.util.resource.UtilBundle").getString("af_dvt_util.NO_DATA"), 0);
        this.nodatalabel.setVerticalAlignment(0);
        this.nodatalabel.setOpaque(true);
        this.add(this.nodatalabel);
        this.grid.init(t);
        this.colHeader.init(t);
        this.rowHeader.init(t);
        this.clearRowHeightsCache();
        this.clearColumnWidthsCache();
    }

    public void setHorizontalSeparatorsVisible(boolean visible) {
        if (this.grid.getBigCellHorizontalSeparatorsVisible() != visible) {
            this.grid.setBigCellHorizontalSeparatorsVisible(visible);
        }
    }

    public boolean getHorizontalSeparatorsVisible() {
        return this.grid.getBigCellHorizontalSeparatorsVisible();
    }

    public void setVerticalSeparatorsVisible(boolean visible) {
        if (this.grid.getBigCellVerticalSeparatorsVisible() != visible) {
            this.grid.setBigCellVerticalSeparatorsVisible(visible);
        }
    }

    public boolean getVerticalSeparatorsVisible() {
        return this.grid.getBigCellVerticalSeparatorsVisible();
    }

    @Override
    public int getType() {
        return 1;
    }

    protected void paintChildren(Graphics g) {
        if (!this.canPaint) {
            return;
        }
        if (!this._isRepaintFrozen()) {
            if (this.table.canResizeWidths) {
                this.checkResizeColumnWidths();
            }
            if (this.table.canResizeHeights) {
                this.checkResizeRowHeights();
            }
            super.paintChildren(g);
        }
    }

    protected void clearRowHeightsCache() {
        int gridRows = this.getGrid().getModel().getRowCount();
        if (!this.table.isIncrementalFetchEnabled() || !this.isIncrementalFetchRowVisible()) {
            ++gridRows;
        }
        if (gridRows == 0) {
            this.m_calculatedRowHeights = null;
        } else {
            this.m_calculatedRowHeights = new int[gridRows];
            for (int i = 0; i < this.m_calculatedRowHeights.length; ++i) {
                this.m_calculatedRowHeights[i] = -1;
            }
        }
        this.m_calculatedRowCount = 0;
        this.m_accumulatedCalculatedRowHeight = 0;
        this.clearSizedRowFlags();
    }

    protected void clearColumnWidthsCache() {
        int gridCols = this.getGrid().getModel().getColumnCount();
        if (gridCols == 0) {
            this.m_calculatedColWidths = null;
        } else {
            this.m_calculatedColWidths = new int[gridCols];
            for (int i = 0; i < this.m_calculatedColWidths.length; ++i) {
                this.m_calculatedColWidths[i] = -1;
            }
        }
        this.m_calculatedColCount = 0;
        this.m_accumulatedCalculatedColWidth = 0;
        this.clearSizedColumnFlags();
    }

    protected void clearSizedRowFlags() {
        int gridRows = this.getGrid().getModel().getRowCount();
        if (!this.table.isIncrementalFetchEnabled() || !this.isIncrementalFetchRowVisible()) {
            ++gridRows;
        }
        if (gridRows == 0) {
            this.m_sizedRowFlags = null;
        } else {
            this.m_sizedRowFlags = new boolean[gridRows];
            for (int i = 0; i < this.m_sizedRowFlags.length; ++i) {
                this.m_sizedRowFlags[i] = false;
            }
        }
    }

    protected void clearSizedColumnFlags() {
        int gridCols = this.getGrid().getModel().getColumnCount();
        if (gridCols == 0) {
            this.m_sizedColFlags = null;
        } else {
            this.m_sizedColFlags = new boolean[gridCols];
            for (int i = 0; i < gridCols; ++i) {
                this.m_sizedColFlags[i] = false;
            }
        }
    }

    protected void checkResizeRowHeights() {
        int gridRows;
        if (this.m_sizedRowFlags == null) {
            return;
        }
        boolean bCalcRowHeights = (this.table.getAutoFitScope() & 1) > 0;
        int cacheLength = gridRows = this.getGrid().getModel().getRowCount();
        if (!this.table.isIncrementalFetchEnabled() || !this.isIncrementalFetchRowVisible()) {
            ++cacheLength;
        }
        if (this.m_sizedRowFlags.length != cacheLength) {
            return;
        }
        boolean resize = false;
        int startRow = this.getFirstRowOnScreen();
        if (startRow != -1) {
            int lastRowOnScreen = this.getOnScreenRowCount() + startRow - 1;
            int firstRowToSize = startRow;
            if (bCalcRowHeights) {
                this.m_bCheckingRowHeights = true;
                int totalRowsHt = 0;
                PaintContext pc = this.getGrid().getPaintContext();
                int sepHeight = 0;
                if (this.getHorizontalSeparatorsVisible()) {
                    sepHeight = this.getHorizontalSeparatorPainter().getPreferredSize((PaintContext)pc).height;
                }
                for (int i = startRow; i <= lastRowOnScreen; ++i) {
                    if (this.m_calculatedRowHeights[i] == -1) {
                        resize = true;
                        firstRowToSize = i;
                        break;
                    }
                    totalRowsHt += this.getRowHeight(i) + sepHeight;
                }
                if (resize) {
                    int curRow;
                    this.canPaint = false;
                    int y1 = this.getGrid().getRowPosition(firstRowToSize);
                    int y2 = this.getGrid().getRowPosition(lastRowOnScreen) + this.getRowHeight(lastRowOnScreen) + sepHeight;
                    int visibleCanvasHeight = y2 - y1;
                    boolean done = false;
                    boolean upward = false;
                    int beginRow = curRow = firstRowToSize;
                    int endRow = curRow;
                    Range range = this.table.getAutoFitColumnRange();
                    int endCol = range.end;
                    int startCol = range.begin;
                    if (endCol < startCol) {
                        this.table.getErrorHandler().log("invalid column range", this.getClass().getName(), m_method_checkResizeRowHeights);
                        this.m_bCheckingRowHeights = false;
                        return;
                    }
                    while (!done) {
                        int rowHt = this.table.resizeRowHeight(curRow, startCol, endCol);
                        if ((totalRowsHt += rowHt + sepHeight) >= visibleCanvasHeight) {
                            done = true;
                            continue;
                        }
                        if (!upward && gridRows - curRow > 1) {
                            endRow = ++curRow;
                            continue;
                        }
                        if (!upward) {
                            curRow = startRow - 1;
                        }
                        beginRow = --curRow;
                        upward = true;
                        if (curRow >= 0) continue;
                        done = true;
                        beginRow = 0;
                    }
                    if (this.table.getAutoFitColumnRangeCallback() != null) {
                        this.table.getAutoFitColumnRangeCallback().endAutoFit();
                    }
                    for (int i = beginRow; i <= endRow; ++i) {
                        this.table.getTableSizingManager().setCalculatedRowHeight(i, this.m_calculatedRowHeights[i]);
                        if (this.m_accumulatedCalculatedRowHeight >= Integer.MAX_VALUE - this.m_calculatedRowHeights[i]) continue;
                        ++this.m_calculatedRowCount;
                        this.m_accumulatedCalculatedRowHeight += this.m_calculatedRowHeights[i];
                    }
                    if (this.m_calculatedRowCount > 0) {
                        int defHeight = this.m_accumulatedCalculatedRowHeight / this.m_calculatedRowCount;
                        this.table.getTableSizingManager().setDefaultRowHeight(defHeight);
                    }
                    this.table.sizeRowHeights(beginRow, endRow);
                    this.canPaint = true;
                }
                this.m_bCheckingRowHeights = false;
            }
            resize = false;
            firstRowToSize = startRow;
            for (int i = startRow; i <= lastRowOnScreen; ++i) {
                if (this.m_sizedRowFlags[i]) continue;
                resize = true;
                firstRowToSize = i;
                break;
            }
            if (resize) {
                int lastRowToSize = firstRowToSize;
                for (int i = lastRowOnScreen; i >= firstRowToSize; --i) {
                    if (this.m_sizedRowFlags[i]) continue;
                    lastRowToSize = i;
                    break;
                }
                this.table.sizeRowHeights(firstRowToSize, lastRowToSize);
            }
        }
    }

    protected void checkResizeColumnWidths() {
        if (this.m_sizedColFlags == null) {
            return;
        }
        boolean bCalcColWidths = (this.table.getAutoFitScope() & 2) > 0;
        int gridCols = this.getGrid().getModel().getColumnCount();
        int cacheLength = gridCols;
        if (this.m_sizedColFlags.length != cacheLength) {
            return;
        }
        boolean resize = false;
        int startCol = this.getFirstColumnOnScreen();
        if (startCol != -1) {
            int lastColOnScreen = this.getOnScreenColumnCount() + startCol - 1;
            int firstColToSize = startCol;
            if (bCalcColWidths) {
                this.m_bCheckingColWidths = true;
                int totalColsWd = 0;
                PaintContext pc = this.getGrid().getPaintContext();
                int sepWidth = 0;
                if (this.getVerticalSeparatorsVisible()) {
                    sepWidth = this.getVerticalSeparatorPainter().getPreferredSize((PaintContext)pc).width;
                }
                for (int i = startCol; i <= lastColOnScreen; ++i) {
                    if (this.m_calculatedColWidths[i] == -1) {
                        resize = true;
                        firstColToSize = i;
                        break;
                    }
                    totalColsWd += this.getColumnWidth(i) + sepWidth;
                }
                if (resize) {
                    int curCol;
                    this.canPaint = false;
                    int x1 = this.getGrid().getColumnPosition(firstColToSize);
                    int x2 = this.getGrid().getColumnPosition(lastColOnScreen) + this.getColumnWidth(lastColOnScreen) + sepWidth;
                    int visibleCanvasWidth = x2 - x1;
                    boolean done = false;
                    boolean backward = false;
                    int beginCol = curCol = firstColToSize;
                    int endCol = curCol;
                    Range range = this.table.getAutoFitRowRange();
                    int endRow = range.end;
                    int startRow = range.begin;
                    if (endRow < startRow) {
                        this.table.getErrorHandler().log("invalid row range", this.getClass().getName(), m_method_checkResizeColumnWidths);
                        this.m_bCheckingColWidths = false;
                        return;
                    }
                    while (!done) {
                        int colWd = this.table.resizeColumnWidth(curCol, startRow, endRow);
                        if ((totalColsWd += colWd + sepWidth) >= visibleCanvasWidth) {
                            done = true;
                            continue;
                        }
                        if (!backward && gridCols - curCol > 1) {
                            endCol = ++curCol;
                            continue;
                        }
                        if (!backward) {
                            curCol = startCol - 1;
                        }
                        beginCol = --curCol;
                        backward = true;
                        if (curCol >= 0) continue;
                        done = true;
                        beginCol = 0;
                    }
                    if (this.table.getAutoFitRowRangeCallback() != null) {
                        this.table.getAutoFitRowRangeCallback().endAutoFit();
                    }
                    for (int i = beginCol; i <= endCol; ++i) {
                        this.table.getTableSizingManager().setCalculatedColumnWidth(i, this.m_calculatedColWidths[i]);
                        if (this.m_accumulatedCalculatedColWidth + this.m_calculatedColWidths[i] >= Integer.MAX_VALUE) continue;
                        ++this.m_calculatedColCount;
                        this.m_accumulatedCalculatedColWidth += this.m_calculatedColWidths[i];
                    }
                    if (this.m_calculatedColCount > 0) {
                        int defWidth = this.m_accumulatedCalculatedColWidth / this.m_calculatedColCount;
                        this.table.getTableSizingManager().setDefaultColumnWidth(defWidth);
                    }
                    this.table.sizeColumnWidths(beginCol, endCol);
                    this.canPaint = true;
                }
                this.m_bCheckingColWidths = false;
            }
            resize = false;
            firstColToSize = startCol;
            for (int i = startCol; i <= lastColOnScreen; ++i) {
                if (this.m_sizedColFlags[i]) continue;
                resize = true;
                firstColToSize = i;
                break;
            }
            if (resize) {
                int lastColToSize = firstColToSize;
                for (int i = lastColOnScreen; i >= firstColToSize; --i) {
                    if (this.m_sizedColFlags[i]) continue;
                    lastColToSize = i;
                    break;
                }
                this.table.sizeColumnWidths(firstColToSize, lastColToSize);
            }
        }
    }

    protected Grid createGrid(TwoDModel model) {
        return new TableDatabody((TableData)model);
    }

    protected Header createColumnHeader(OneDModel ds) {
        return new ColHeader((ColHeaderData)ds);
    }

    protected Header createRowHeader(OneDModel ds) {
        return new RowHeader((RowHeaderData)ds);
    }

    protected TableDatabody getTableDatabody() {
        return this.grid;
    }

    protected TableHeader getTableColumnHeader() {
        return this.colHeader;
    }

    protected TableHeader getTableRowHeader() {
        return this.rowHeader;
    }

    @Override
    public int getID() {
        return 21;
    }

    @Override
    public String getComponentName() {
        return "Table";
    }

    @Override
    public BeanInfo getBeanInfo() {
        return null;
    }

    Table getTable() {
        return this.table;
    }

    public void setModels(TwoDModel databodyDataSource, OneDModel colHeaderDataSource, OneDModel rowHeaderDataSource) {
        super.setModels(databodyDataSource, colHeaderDataSource, rowHeaderDataSource);
    }

    public void paint(Graphics g) {
        super.paint(g);
        Rectangle bounds = this.nodatalabel.getBounds();
        if (bounds.width > 0 && bounds.height > 0) {
            this.nodatalabel.paint(g);
        }
    }

    public void doLayout() {
        super.doLayout();
        if (this.getGrid().getModel().getColumnCount() == 0 || this.getGrid().getModel().getRowCount() == 0) {
            this.nodatalabel.setBounds(this.getBounds());
            this.getGrid().setBounds(0, 0, 0, 0);
        } else {
            this.nodatalabel.setBounds(0, 0, 0, 0);
        }
    }

    public void printPage(PaintContext context, Dictionary printProperties, Graphics g) {
        if (this.getGrid().getModel().getColumnCount() == 0 || this.getGrid().getModel().getRowCount() == 0) {
            FontMetrics fm = g.getFontMetrics();
            int stringWidth = fm.stringWidth(this.nodatalabel.getText());
            int stringHeight = fm.getHeight();
            Rectangle clipBounds = g.getClipBounds();
            int printX = clipBounds.width / 2 - stringWidth / 2;
            int printY = clipBounds.height / 2 - stringHeight / 2;
            g.drawString(this.nodatalabel.getText(), printX, printY);
        }
        super.printPage(context, printProperties, g);
    }

    protected boolean addIncrementalFetchRow() {
        BigCellTwoDModel bctdm = null;
        HeaderData hd = null;
        if (!(this.getTableDatabody().getModel() instanceof BigCellTwoDModel) || !(this.getTableRowHeader().getModel() instanceof HeaderData)) {
            return false;
        }
        bctdm = (BigCellTwoDModel)this.getTableDatabody().getModel();
        hd = (HeaderData)this.getTableRowHeader().getModel();
        if (hd != null && bctdm != null) {
            hd.addItems(hd.getItemCount(), 1);
            bctdm.addRows(1);
            bctdm.setBigCellData(0, bctdm.getColumnCount(), bctdm.getRowCount(), 1, (Object)new String(this.table.getFetchMessage()));
            this.getTableRowHeader().clearAppliedStyleFlag(hd.getItemCount() - 1);
            return true;
        }
        return false;
    }

    protected void setFetchMessageInBottomRow(String msg) {
        BigCellTwoDModel bctdm = null;
        if (!(this.getTableDatabody().getModel() instanceof BigCellTwoDModel)) {
            return;
        }
        bctdm = (BigCellTwoDModel)this.getTableDatabody().getModel();
        bctdm.setBigCellData(0, bctdm.getColumnCount(), bctdm.getRowCount() - 1, 1, (Object)new String(msg));
    }

    protected boolean removeIncrementalFetchRow() {
        BigCellTwoDModel bctdm = null;
        HeaderData hd = null;
        if (!(this.getTableDatabody().getModel() instanceof BigCellTwoDModel) || !(this.getTableRowHeader().getModel() instanceof HeaderData)) {
            return false;
        }
        bctdm = (BigCellTwoDModel)this.getTableDatabody().getModel();
        hd = (HeaderData)this.getTableRowHeader().getModel();
        if (hd != null && bctdm != null) {
            hd.removeItems(hd.getItemCount() - 1, 1);
            bctdm.removeRows(1);
            this.getTableRowHeader().clearAppliedStyleFlag(hd.getItemCount());
            return true;
        }
        return false;
    }

    public void firePivotEvent(Object source, int sourceIndex, Object destination, int destinationIndex) {
        if (destinationIndex < 0) {
            this.table.getErrorHandler().log("invalid destination index", this.getClass().getName(), m_method_firepivotevent);
            return;
        }
        if (sourceIndex < 0) {
            this.table.getErrorHandler().log("invalid source index", this.getClass().getName(), m_method_firepivotevent);
            return;
        }
        PagingPivotEvent e = new PagingPivotEvent(source, 2001, destination, sourceIndex, destinationIndex);
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != PagingPivotListener.class) continue;
            ((PagingPivotListener)listeners[i + 1]).pivot(e);
        }
    }

    public void fireDrillEvent(int orientation, int column, int row, Object info) {
        if (orientation != 0 && orientation != 1) {
            this.table.getErrorHandler().log("invalid orientation", this.getClass().getName(), m_method_firedrillevent);
            return;
        }
        if (column < 0) {
            this.table.getErrorHandler().log("invalid column index", this.getClass().getName(), m_method_firedrillevent);
            return;
        }
        if (row < 0) {
            this.table.getErrorHandler().log("invalid row index", this.getClass().getName(), m_method_firedrillevent);
            return;
        }
        int id = 2002;
        DrillEvent e = new DrillEvent((Object)this, id, orientation, column, row, info);
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DrillListener.class) continue;
            ((DrillListener)listeners[i + 1]).headerCellDrill(e);
        }
    }

    public void fireHeaderCellDrillRequest(int orientation, int column, int row) {
        if (orientation != 0 && orientation != 1) {
            this.table.getErrorHandler().log("invalid orientation", this.getClass().getName(), m_method_fireheadercelldrillrequest);
            return;
        }
        if (column < 0) {
            this.table.getErrorHandler().log("invalid column index", this.getClass().getName(), m_method_fireheadercelldrillrequest);
            return;
        }
        if (row < 0) {
            this.table.getErrorHandler().log("invalid row index", this.getClass().getName(), m_method_fireheadercelldrillrequest);
            return;
        }
        int id = 2001;
        DrillEvent e = new DrillEvent((Object)this, id, orientation, column, row);
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DrillListener.class) continue;
            ((DrillListener)listeners[i + 1]).headerCellDrillRequest(e);
        }
    }

    public void fireCollapse(int orientation, int column, int row) {
        if (orientation != 0 && orientation != 1) {
            this.table.getErrorHandler().log("invalid orientation", this.getClass().getName(), m_method_firecollapse);
            return;
        }
        if (column < 0) {
            this.table.getErrorHandler().log("invalid column index", this.getClass().getName(), m_method_firecollapse);
            return;
        }
        if (row < 0) {
            this.table.getErrorHandler().log("invalid row index", this.getClass().getName(), m_method_firecollapse);
            return;
        }
        int id = 2001;
        CollapseEvent e = new CollapseEvent((Object)this, id, orientation, column, row);
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CollapseListener.class) continue;
            ((CollapseListener)listeners[i + 1]).collapse(e);
        }
    }

    public final void fireSwapEvent(Object source, int sourceIndex, Object destination, int destinationIndex) {
        if (destinationIndex < 0) {
            this.table.getErrorHandler().log("invalid destination index", this.getClass().getName(), m_method_fireswapevent);
            return;
        }
        if (sourceIndex < 0) {
            this.table.getErrorHandler().log("invalid source index", this.getClass().getName(), m_method_fireswapevent);
            return;
        }
        PagingPivotEvent e = new PagingPivotEvent(source, 2002, destination, sourceIndex, destinationIndex);
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != PagingPivotListener.class) continue;
            ((PagingPivotListener)listeners[i + 1]).swap(e);
        }
    }

    public void addPivotListener(PagingPivotListener l) {
        this.listenerList.add(PagingPivotListener.class, l);
    }

    public void removePivotListener(PagingPivotListener l) {
        this.listenerList.remove(PagingPivotListener.class, l);
    }

    public void addDrillListener(DrillListener l) {
        this.listenerList.add(DrillListener.class, l);
    }

    public void removeDrillListener(DrillListener l) {
        this.listenerList.remove(DrillListener.class, l);
    }

    public void addCollapseListener(CollapseListener l) {
        this.listenerList.add(CollapseListener.class, l);
    }

    public void removeCollapseListener(CollapseListener l) {
        this.listenerList.remove(CollapseListener.class, l);
    }

    @Override
    public void setSwapAllowed(boolean swap) {
        this.m_bSwapAllowed = swap;
    }

    @Override
    public boolean isSwapAllowed() {
        return this.m_bSwapAllowed;
    }

    protected void setIncrementalFetchRowVisible(boolean b) {
        this.m_bIncrementalFetchRowVisible = b;
    }

    public boolean isIncrementalFetchRowVisible() {
        return this.m_bIncrementalFetchRowVisible;
    }

    public void freezeRepaints() {
        ++this.m_freezeLevel;
        super.freezeRepaints();
    }

    public void unfreezeRepaints() {
        if (this.m_freezeLevel > 0) {
            --this.m_freezeLevel;
        }
        super.unfreezeRepaints();
    }

    private boolean _isRepaintFrozen() {
        return this.m_freezeLevel > 0;
    }

    protected void freezeSpreadTableRepaints() {
        this.freezeRepaints();
        if (this.getTableDatabody() != null) {
            this.getTableDatabody().freezeRepaints();
        }
        if (this.getColumnHeader() != null) {
            this.getColumnHeader().freezeRepaints();
        }
        if (this.getRowHeader() != null) {
            this.getRowHeader().freezeRepaints();
        }
    }

    protected void unfreezeSpreadTableRepaints() {
        if (this.getRowHeader() != null) {
            this.getRowHeader().unfreezeRepaints();
        }
        if (this.getColumnHeader() != null) {
            this.getColumnHeader().unfreezeRepaints();
        }
        if (this.getTableDatabody() != null) {
            this.getTableDatabody().unfreezeRepaints();
        }
        this.unfreezeRepaints();
    }

    protected boolean isSelectAllEnabled() {
        return super.isSelectAllEnabled();
    }
}

