/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.table;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.PrintJob;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.print.PrinterGraphics;
import java.beans.PropertyVetoException;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JFrame;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.print.PrinterGraphics2DProxy;
import oracle.bali.ewt.print.PrinterUtils;
import oracle.bali.ewt.scrolling.EWTScrollPane;
import oracle.bali.ewt.selection.OneDSelection;
import oracle.bali.ewt.selection.TwoDSelection;
import oracle.dss.dataView.DataSubsetRecord;
import oracle.dss.dataView.DataviewUtils;
import oracle.dss.dataView.PaginationRecord;
import oracle.dss.dataView.managers.ViewStyle;
import oracle.dss.gridView.GridViewAppearanceMgr;
import oracle.dss.gridView.GridViewPrinter;
import oracle.dss.table.Table;
import oracle.dss.table.TableSpreadTable;
import oracle.dss.util.DataAccess;
import oracle.dss.util.DataException;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.Range;

public class TablePrinter
extends GridViewPrinter {
    private int totalCols;
    private int totalRows;
    private int spreadTableHeight;
    private int index = 0;
    private int currX = 0;
    private int currY = 0;
    private int currentOuter = 0;
    private int currentInner = 0;
    private int outerLoop = 0;
    private int innerLoop = 0;
    private int pageNum = 0;
    private int firstColOnScreen;
    private int firstRowOnScreen;
    private int zoomFactor = 100;
    private int totalColWidth;
    private int totalRowHeight;
    private int m_selectedIndex = 0;
    private boolean m_insuffSapce = false;
    private boolean tableRemoved = false;
    private boolean selectionRemoved = false;
    private boolean line3D = false;
    private boolean pagingSp = false;
    private boolean titleSp = false;
    private boolean subtitleSp = false;
    private boolean textPaneSp = false;
    private boolean footnoteSp = false;
    private boolean newLogPageIsNext = false;
    private boolean turnedOffHGrid = false;
    private boolean turnedOffVGrid = false;
    private boolean m_resetZoomFactor = false;
    private boolean m_bIncrementalFetchRowEnabled = false;
    private JFrame m_frame = null;
    private Dimension documentSize = null;
    private Hashtable printProperties;
    private PrintJob job;
    private Rectangle newPageBounds;
    private Hashtable hashTable = null;
    private Vector v = null;
    private EWTScrollPane scrollBox = null;
    private Table table = null;
    private TableSpreadTable spreadTable = null;
    private Component cornerComp = null;
    private TwoDSelection selection = null;
    private OneDSelection colSelection = null;
    private OneDSelection rowSelection = null;
    private ResourceBundle rBundle = null;
    private static final String m_method_resizerowheights = "resizeRowHeights(int firstCol, int lastCol, int firstRow, int lastRow)";
    private static final String m_method_resizeColumnWidths = "protected boolean resizeColumnWidths(int firstCol, int lastCol, int firstRow, int lastRow)";
    private static final String m_method_calcpagebounds = "calcPageBounds(DataSubsetRecord record)";
    private static final String m_method_endPrint = "endPrint()";
    private static final String m_method_printPage = "public boolean printPage(Graphics g, DataSubsetRecord record)";

    public TablePrinter(Table c) {
        super(c);
        this.table = c;
        this.updateResourceBundle(this.table.getLocale());
        this.spreadTable = this.table.getTable();
    }

    @Override
    public int getViewPrinterType() {
        return 1;
    }

    private void updateResourceBundle(Locale loc) {
        this.rBundle = loc != null ? ResourceBundle.getBundle("oracle.dss.table.resource.TableBundle", loc) : ResourceBundle.getBundle("oracle.dss.table.resource.TableBundle");
    }

    @Override
    public boolean startPrint() {
        return this.startPrint(false);
    }

    @Override
    public boolean startPrint(boolean bPreviewMode) {
        if (this.table.isDataUnavailable()) {
            this.table.getErrorHandler().log("data is unavailable to print", this.getClass().getName(), "startPrint");
            return false;
        }
        if (this.table.getParent() == null) {
            this.table.setSize(400, 400);
            this.m_frame = new JFrame();
            this.m_frame.getContentPane().add(this.table);
            this.m_frame.pack();
        }
        if (this.paperHeight - (this.topMargin + this.bottomMargin) < 20 || this.paperWidth - (this.leftMargin + this.rightMargin) < 20) {
            this.logInsuffMsg("startPrint");
            return false;
        }
        this.m_insuffSapce = false;
        try {
            this.table.firePrintBegin(this.table);
            this.currLogPage.setHPos(this.table.getTableModel().getDataAccess().getEdgeCurrentHPos(2));
            this.table.setPrintOrPreviewMode(true);
            this.m_bIncrementalFetchRowEnabled = this.table.getTableModel().isIncrementalFetchEnabled();
            if (this.m_bIncrementalFetchRowEnabled) {
                this.table.getTableModel().setIncrementalFetchEnabled(false);
            }
            this.line3D = this.table.isGrid3D();
            if (this.line3D) {
                this.table.setGrid3D(false);
                this.spreadTable.validate();
            }
            this.saveAdornmentsSize();
            this.pagingControlBounds = new Rectangle(0, 0, 0, 0);
            this.saveTitlesFocus();
            this.saveCellSelection();
            this.resize = true;
            this.firstRowOnScreen = this.spreadTable.getFirstRowOnScreen();
            this.firstColOnScreen = this.spreadTable.getFirstColumnOnScreen();
            this.table.autoFit();
            this.table.getTableColumnHeader().clearAppliedStylesFlags();
            this.table.getTableRowHeader().clearAppliedStylesFlags();
            if (!this.m_gridlinesVisible) {
                if (this.table.isHGridVisible()) {
                    this.turnedOffHGrid = true;
                    this.table.setHGridVisible(false);
                }
                if (this.table.isVGridVisible()) {
                    this.turnedOffVGrid = true;
                    this.table.setVGridVisible(false);
                }
            }
            this.m_resetZoomFactor = false;
            if (this.m_gridViewPrintScaleType == 2) {
                this.zoomFactor = this.table.getZoomFactor();
                this.table.setZoomFactor(100);
                int scaledZoomFactor = this.calcZoomFactor();
                if (scaledZoomFactor == -1) {
                    return false;
                }
                if (scaledZoomFactor > this.zoomFactor) {
                    this.table.setZoomFactor(100);
                } else {
                    this.table.setZoomFactor(scaledZoomFactor);
                }
                this.m_resetZoomFactor = true;
            } else if (this.m_gridViewPrintScaleType == 1) {
                this.zoomFactor = this.table.getZoomFactor();
                this.table.setZoomFactor(this.printZoomFactor);
                this.m_resetZoomFactor = true;
            } else if (this.table.getZoomFactor() != 100) {
                this.m_resetZoomFactor = true;
                this.zoomFactor = this.table.getZoomFactor();
                this.table.setZoomFactor(100);
            }
            this.printProperties = new Hashtable();
            this.printProperties.put(TableSpreadTable.PRINT_RAISED, Boolean.FALSE);
            this.printProperties.put(Grid.DISPLAY_FOCUS_CELL, Boolean.FALSE);
            this.printProperties.put(Header.DISPLAY_FOCUS_ITEM, Boolean.FALSE);
            if (this.isRepeatComponent(1)) {
                this.printProperties.put(TableSpreadTable.DUPLICATE_COLUMN_HEADERS, Boolean.TRUE);
            } else {
                this.printProperties.put(TableSpreadTable.DUPLICATE_COLUMN_HEADERS, Boolean.FALSE);
            }
            if (this.isRepeatComponent(2)) {
                this.printProperties.put(TableSpreadTable.DUPLICATE_ROW_HEADERS, Boolean.TRUE);
            } else {
                this.printProperties.put(TableSpreadTable.DUPLICATE_ROW_HEADERS, Boolean.FALSE);
            }
        }
        catch (EdgeOutOfRangeException e) {
            this.table.getErrorHandler().error((Throwable)e, this.getClass().getName(), "startPrint");
        }
        this.m_selectedIndex = 0;
        this.m_seqPageNumber = 0;
        this.pIndex = -1;
        this.m_bPreviewMode = bPreviewMode;
        return true;
    }

    @Override
    public void endPrint() {
        if (this.m_bIncrementalFetchRowEnabled) {
            this.table.getTableModel().setIncrementalFetchEnabled(true);
        }
        this.m_insuffSapce = false;
        try {
            int maxLayerSpecified = -1;
            if (this.currLogPage.getHPos() != null) {
                maxLayerSpecified = this.currLogPage.getHPos().length - 1;
            }
            this.changePageEdgeCurrentHPos(this.currLogPage.getHPos(), maxLayerSpecified);
        }
        catch (DataException e) {
            this.table.getErrorHandler().error((Throwable)e, this.getClass().getName(), m_method_endPrint);
        }
        if (this.m_resetZoomFactor) {
            this.table.setZoomFactor(this.zoomFactor);
        }
        if (!this.m_gridlinesVisible) {
            if (this.turnedOffHGrid) {
                this.turnedOffHGrid = false;
                this.table.setHGridVisible(true);
            }
            if (this.turnedOffVGrid) {
                this.turnedOffVGrid = false;
                this.table.setVGridVisible(true);
            }
        }
        if (this.line3D) {
            this.table.setGrid3D(true);
        }
        if (this.tempFrame != null) {
            this.tempFrame.dispose();
            this.tempFrame = null;
        }
        this.table.getTableColumnHeader().clearAppliedStylesFlags();
        this.table.getTableRowHeader().clearAppliedStylesFlags();
        this.restoreTitlesFocus();
        if (this.selectionRemoved) {
            try {
                this.spreadTable.setSelection(this.selection);
                TwoDSelection sel = this.spreadTable.getSelection();
                this.spreadTable.getColumnHeader().setSelection(this.colSelection);
                this.spreadTable.getRowHeader().setSelection(this.rowSelection);
            }
            catch (PropertyVetoException e) {
                this.table.getErrorHandler().log("can't set selection", this.getClass().getName(), m_method_endPrint);
            }
            this.selectionRemoved = false;
        }
        this.resetAdornmentsSize();
        if (this.m_rowHeightsCache != null) {
            this.m_rowHeightsCache.clear();
            this.m_rowHeightsCache = null;
        }
        if (this.m_colWidthsCache != null) {
            this.m_colWidthsCache.clear();
            this.m_colWidthsCache = null;
        }
        this.m_rowHeights = null;
        this.m_colWidths = null;
        this.m_dirtyRowHeights = null;
        this.m_dirtyColWidths = null;
        this.m_bUpdateRowHeightsCache = false;
        this.m_bUpdateColWidthsCache = false;
        this.m_bPreviewMode = false;
        this.pIndex = -1;
        this.table.setPrintOrPreviewMode(false);
        this.table.autoFit();
        if (this.firstRowOnScreen >= 0 && this.firstRowOnScreen < this.spreadTable.getGrid().getRowCount()) {
            this.spreadTable.setFirstRowOnScreen(this.firstRowOnScreen);
        }
        if (this.firstColOnScreen >= 0 && this.firstColOnScreen < this.spreadTable.getGrid().getColumnCount()) {
            this.spreadTable.setFirstColumnOnScreen(this.firstColOnScreen);
        }
        this.table.validate();
        this.table.repaint();
        this.table.firePrintEnd(this.table);
        if (this.m_frame != null) {
            this.m_frame.remove(this.table);
        }
        this.m_frame = null;
    }

    @Override
    public boolean isFirstPhysicalPage() {
        return this.index == 0;
    }

    @Override
    public boolean isLastPhysicalPage() {
        if (this.v != null) {
            if (this.index < this.v.size() - 1) {
                return false;
            }
            if (this.hashTable.get(new Integer(this.viewLogPageNum + 1)) != null) {
                return true;
            }
            return this.currentOuter > this.outerLoop;
        }
        return false;
    }

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
        this.gridView = table;
        this.setDataview(table);
    }

    public boolean calcPageBounds(DataSubsetRecord record) {
        if (this.table.isDataUnavailable()) {
            this.table.getErrorHandler().log("data is unavailable to print", this.getClass().getName(), "calcPageBounds");
            return false;
        }
        if (record == null) {
            this.table.getErrorHandler().log("invalid data subset record", this.getClass().getName(), m_method_calcpagebounds);
            return false;
        }
        if (this.resize) {
            this.resizeGridView();
            this.table.validate();
            this.resize = false;
        }
        this.subSetRecord = record;
        int yVal = this.spreadTable.getGrid().getRowPosition(this.subSetRecord.firstRow);
        int xVal = this.subSetRecord.x1 >= 0 ? this.subSetRecord.x1 : this.spreadTable.getGrid().getColumnPosition(this.subSetRecord.firstColumn);
        int height = this.viewDim.height;
        this.calcAdornmentsDimension(this.viewDim.width);
        if (this.isRepeatHeaders()) {
            height -= this.totalAdornHeight;
        }
        if (!this.isRepeatHeaders() && yVal == 0) {
            height -= this.totalAdornHeight;
        } else if (!this.isRepeatHeaders() && yVal != 0) {
            height -= this.repeatAdornHeight;
        }
        if (height < 20 || this.viewDim.width < 20) {
            this.logInsuffMsg("calcPageBounds");
            return false;
        }
        Rectangle pageBounds = this.getPageBounds(xVal, yVal, this.viewDim.width, height);
        this.documentSize = this.spreadTable.getDocumentSize(this.spreadTable.getPaintContext(), this.printProperties);
        this.adjustForPageBreak(yVal, this.subSetRecord, pageBounds);
        this.table.setFirstPrintedRow(this.subSetRecord.firstRow);
        this.subSetRecord.lastRow = this.spreadTable.getGrid().getRowAt(pageBounds.y + yVal);
        if (this.subSetRecord.lastRow != this.subSetRecord.firstRow) {
            --this.subSetRecord.lastRow;
        }
        if (this.subSetRecord.lastRow < 0) {
            this.subSetRecord.lastRow = this.spreadTable.getGrid().getRowCount() - 1;
        }
        this.subSetRecord.lastColumn = this.spreadTable.getGrid().getColumnAt(pageBounds.x + xVal);
        if (this.subSetRecord.lastColumn == this.subSetRecord.firstColumn) {
            this.subSetRecord.x1 = xVal;
            this.subSetRecord.x2 = pageBounds.x + xVal;
        } else {
            --this.subSetRecord.lastColumn;
            this.subSetRecord.x1 = -1;
            this.subSetRecord.x2 = -1;
        }
        if (this.subSetRecord.lastColumn < 0) {
            this.subSetRecord.lastColumn = this.spreadTable.getGrid().getColumnCount() - 1;
        }
        this.subSetRecord.x = xVal;
        this.subSetRecord.y = yVal;
        this.subSetRecord.width = pageBounds.width;
        this.subSetRecord.height = pageBounds.height;
        return true;
    }

    public boolean printPage(Graphics g) {
        if (this.table.isDataUnavailable()) {
            this.table.getErrorHandler().log("data is unavailable to print", this.getClass().getName(), "printPage");
            return false;
        }
        int oldLeftM = this.leftMargin;
        int oldTopM = this.topMargin;
        this.leftMargin = 0;
        this.topMargin = 0;
        this.printableWidth = this.viewDim.width;
        this.printableHeight = this.viewDim.height;
        this.printToGraphics(g, this.subSetRecord);
        this.leftMargin = oldLeftM;
        this.topMargin = oldTopM;
        return true;
    }

    public boolean printPage(Graphics g, DataSubsetRecord record) {
        if (this.table.isDataUnavailable()) {
            this.table.getErrorHandler().log("data is unavailable to print", this.getClass().getName(), "printPage");
            return false;
        }
        try {
            if (record.needsRecalc) {
                int rowHeaderWidth;
                int columnHeaderHeight;
                if (this.logicalPage == null) {
                    this.setLogicalPage(this.table.getTableModel().getDataAccess().getEdgeCurrentHPos(2));
                }
                this.fetchRowBlock(record.firstRow, record.lastRow);
                int startRow = -1;
                int endRow = -1;
                if ((this.table.getAutoFitScope() & 2) > 0) {
                    Range rowRange = this.table.getAutoFitRowRange(record.firstRow);
                    startRow = rowRange.begin;
                    endRow = rowRange.end;
                }
                if (endRow < startRow) {
                    this.table.getErrorHandler().log("invalid row range", this.getClass().getName(), m_method_printPage);
                }
                this.resizeColumnWidths(record.firstColumn, record.lastColumn, startRow, endRow);
                if ((this.table.getAutoFitScope() & 2) > 0 && this.table.getAutoFitRowRangeCallback() != null) {
                    this.table.getAutoFitRowRangeCallback().endAutoFit();
                }
                int startCol = -1;
                int endCol = -1;
                if ((this.table.getAutoFitScope() & 1) > 0) {
                    Range colRange = this.table.getAutoFitColumnRange(record.firstColumn);
                    startCol = colRange.begin;
                    endCol = colRange.end;
                }
                if (endCol < startCol) {
                    this.table.getErrorHandler().log("invalid column range", this.getClass().getName(), m_method_printPage);
                }
                this.resizeRowHeights(startCol, endCol, record.firstRow, record.lastRow);
                if ((this.table.getAutoFitScope() & 1) > 0 && this.table.getAutoFitColumnRangeCallback() != null) {
                    this.table.getAutoFitColumnRangeCallback().endAutoFit();
                }
                this.table.validate();
                record.x = record.x1 == -1 ? this.spreadTable.getGrid().getColumnPosition(record.firstColumn) : record.x1;
                record.y = this.spreadTable.getGrid().getRowPosition(record.firstRow);
                int lastRowEndPos = 0;
                if (record.lastRow < this.spreadTable.getGrid().getRowCount() - 1) {
                    lastRowEndPos = this.spreadTable.getGrid().getRowPosition(record.lastRow + 1);
                } else {
                    this.documentSize = this.spreadTable.getDocumentSize(this.spreadTable.getPaintContext(), this.printProperties);
                    lastRowEndPos = this.documentSize.height;
                }
                record.height = lastRowEndPos - record.y;
                int height = this.viewDim.height;
                this.calcAdornmentsDimension(this.viewDim.width);
                if (this.isRepeatHeaders()) {
                    height -= this.totalAdornHeight;
                }
                if (!this.isRepeatHeaders() && record.y == 0) {
                    height -= this.totalAdornHeight;
                } else if (!this.isRepeatHeaders() && record.y != 0) {
                    height -= this.repeatAdornHeight;
                }
                if (height < 20 || this.viewDim.width < 20) {
                    this.logInsuffMsg("printPage");
                    return false;
                }
                boolean showColHeader = record.y == 0 || this.isRepeatComponent(1);
                int n = columnHeaderHeight = showColHeader && this.spreadTable.isColumnHeaderVisible() ? this.spreadTable.getColumnHeader().getSize().height : 0;
                if (columnHeaderHeight >= height) {
                    int temp = height / 8;
                    columnHeaderHeight = height - temp;
                }
                record.height += columnHeaderHeight;
                int lastColumnEndPos = 0;
                lastColumnEndPos = record.x2 != -1 ? record.x2 : (record.lastColumn < this.spreadTable.getGrid().getColumnCount() - 1 ? this.spreadTable.getGrid().getColumnPosition(record.lastColumn + 1) : this.documentSize.width);
                record.width = lastColumnEndPos - record.x;
                boolean showRowHeader = record.x == 0 || this.isRepeatComponent(2);
                int n2 = rowHeaderWidth = showRowHeader && this.spreadTable.isRowHeaderVisible() ? this.spreadTable.getRowHeader().getSize().width : 0;
                if (rowHeaderWidth >= this.viewDim.width) {
                    int temp = this.viewDim.width / 8;
                    rowHeaderWidth = this.viewDim.width - temp;
                }
                record.width += rowHeaderWidth;
            }
            this.subSetRecord = record;
            this.printPage(g);
        }
        catch (DataException exception) {
            this.table.getErrorHandler().error((Throwable)exception, this.getClass().getName(), "printPage");
        }
        return true;
    }

    @Override
    protected void printPages(PrintJob pjob, boolean currentLogPage) {
        try {
            int pageNum = 1;
            this.printableWidth = this.dimension.width - (this.leftMargin + this.rightMargin);
            if (this.printableWidth < 20) {
                this.logInsuffMsg("printPages");
                return;
            }
            this.currentLogicalPage = currentLogPage;
            boolean first = true;
            int[] hPos = null;
            if (currentLogPage) {
                hPos = this.currLogPage.getHPos();
            } else if (this.rangeType == 1) {
                hPos = this.table.getTableModel().getDataAccess().getFirstHPos(2);
            } else if (this.m_selectedHPos != null && this.m_selectedHPos.size() > 0) {
                hPos = (int[])this.m_selectedHPos.elementAt(0);
            }
            if (hPos == null) {
                hPos = new int[]{};
            }
            while (hPos != null) {
                DataAccess access = this.table.getTableModel().getDataAccess();
                if (!currentLogPage) {
                    this.changePageEdgeCurrentHPos(hPos, hPos.length - 1);
                }
                this.initCache();
                if (access.getEdgeExtent(1) != 0 && access.getEdgeExtent(0) != 0) {
                    this.resizeGridView();
                    this.table.validate();
                    this.calcAdornmentsDimension(this.printableWidth);
                    first = true;
                    Dimension documentSize = this.spreadTable.getDocumentSize(this.spreadTable.getPaintContext(), this.printProperties);
                    int outerLoopEnd = documentSize.height;
                    int innerLoopEnd = documentSize.width;
                    if (!this.printByColumns) {
                        outerLoopEnd = documentSize.width;
                        innerLoopEnd = documentSize.height;
                    }
                    int curX = 0;
                    int curY = 0;
                    int currOuter = 0;
                    while (currOuter <= outerLoopEnd) {
                        int currInner = 0;
                        Rectangle newPageBounds = null;
                        while (currInner <= innerLoopEnd) {
                            Graphics g = pjob.getGraphics();
                            this.record = new PaginationRecord();
                            this.record.pageNum = pageNum++;
                            ++this.m_seqPageNumber;
                            this.viewLogPage.setHPos(hPos);
                            this.calcMargins(g);
                            this.printableHeight = this.dimension.height - (this.topMargin + this.bottomMargin);
                            if (first) {
                                if (this.isRepeatHeaders()) {
                                    this.spreadTableHeight = this.printableHeight - this.totalAdornHeight;
                                }
                                first = false;
                            }
                            if (!this.isRepeatHeaders() && curY == 0) {
                                this.spreadTableHeight = this.printableHeight - this.totalAdornHeight;
                            } else if (!this.isRepeatHeaders() && curY != 0) {
                                this.spreadTableHeight = this.printableHeight - this.repeatAdornHeight;
                            }
                            if (this.spreadTableHeight < 20) {
                                this.logInsuffMsg("printPages");
                                break;
                            }
                            newPageBounds = this.getPageBounds(curX, curY, this.printableWidth, this.spreadTableHeight);
                            documentSize = this.spreadTable.getDocumentSize(this.spreadTable.getPaintContext(), this.printProperties);
                            if (this.printByColumns) {
                                outerLoopEnd = documentSize.height;
                                innerLoopEnd = documentSize.width;
                            } else {
                                outerLoopEnd = documentSize.width;
                                innerLoopEnd = documentSize.height;
                            }
                            this.record.y = curY;
                            this.record.x = curX;
                            this.record.height = newPageBounds.height;
                            this.record.width = newPageBounds.width;
                            this.record.firstRow = this.spreadTable.getGrid().getRowAt(curY);
                            this.record.lastRow = this.spreadTable.getGrid().getRowAt(curY + newPageBounds.y - 1);
                            this.record.firstColumn = this.spreadTable.getGrid().getColumnAt(curX);
                            this.record.lastColumn = this.spreadTable.getGrid().getColumnAt(curX + newPageBounds.x - 1);
                            if (this.record.lastRow < 0) {
                                this.record.lastRow = this.spreadTable.getGrid().getRowCount() - 1;
                            }
                            if (this.record.lastColumn < 0) {
                                this.record.lastColumn = this.spreadTable.getGrid().getColumnCount() - 1;
                            }
                            this.adjustForPageBreak(curY, this.record, newPageBounds);
                            this.table.setFirstPrintedRow(this.record.firstRow);
                            this.printToGraphics(g, this.record);
                            this.printHeaderAndFooter(g);
                            g.dispose();
                            if (this.printByColumns) {
                                currInner = curX += newPageBounds.x;
                                continue;
                            }
                            currInner = curY += newPageBounds.y;
                        }
                        if (this.printByColumns) {
                            curX = 0;
                            currOuter = curY += newPageBounds.y;
                            continue;
                        }
                        curY = 0;
                        currOuter = curX += newPageBounds.x;
                    }
                }
                if (!currentLogPage) {
                    if (this.rangeType == 1) {
                        hPos = this.table.getTableModel().getDataAccess().getNextHPos(2, hPos);
                        continue;
                    }
                    ++this.m_selectedIndex;
                    if (this.m_selectedHPos != null && this.m_selectedHPos.size() > this.m_selectedIndex) {
                        hPos = (int[])this.m_selectedHPos.elementAt(this.m_selectedIndex);
                        continue;
                    }
                    hPos = null;
                    continue;
                }
                hPos = null;
            }
            if (this.tempFrame != null) {
                this.tempFrame.dispose();
                this.tempFrame = null;
            }
        }
        catch (DataException exception) {
            this.table.getErrorHandler().error((Throwable)exception, this.getClass().getName(), "printPages");
        }
    }

    @Override
    protected void printToGraphics(Graphics g2, PaginationRecord record) {
        int i;
        int x;
        PaintContext printContext;
        Graphics g = g2 instanceof PrinterGraphics2DProxy || !(g2 instanceof PrinterGraphics) ? g2 : PrinterUtils.getIntegerPrintGraphics((PrinterGraphics)((PrinterGraphics)((Object)g2)));
        Shape savedBounds = g.getClip();
        this.pagingSp = false;
        this.titleSp = false;
        this.subtitleSp = false;
        this.textPaneSp = false;
        this.footnoteSp = false;
        int pageDims = 0;
        try {
            pageDims = this.gridView.getGridViewModel().getDataAccess().getLayerCount(2);
        }
        catch (EdgeOutOfRangeException e) {
            // empty catch block
        }
        this.saveAdornmentsSize();
        int prefWidth = 0;
        int prefHeight = 0;
        int translatedWidth = this.leftMargin;
        int translatedHeight = this.topMargin;
        g.translate(this.leftMargin, this.topMargin);
        if (this.m_topFormattedText != null && (this.isRepeatComponent(64) || record.x == 0 && record.y == 0)) {
            g.setClip(0, 0, this.printableWidth, this.topFTAHeight);
            this.m_topFormattedText.print(new Dimension(this.printableWidth, this.topFTAHeight), g);
            g.translate(0, this.topFTAHeight);
            translatedHeight += this.topFTAHeight;
            this.textPaneSp = true;
        } else if (this.m_topFormattedText != null && (this.isRepeatComponent(64) || record.y == 0)) {
            g.translate(0, this.topFTAHeight);
            translatedHeight += this.topFTAHeight;
            this.textPaneSp = true;
        }
        if (this.table.isPagingControlVisible() && pageDims > 0 && this.table.getPagingControlPosition() == 0 && (this.isRepeatComponent(4) || record.x == 0 && record.y == 0)) {
            g.setClip(0, 0, this.pagingControlBounds.width, this.pagingControlBounds.height);
            this.table.getPagingControl().getPagingComponent().validate();
            printContext = this.table.getPagingControl().getPagingComponent().getPrintPaintContext(g);
            this.table.getPagingControl().getPagingComponent().printPage(printContext, null, g);
            g.translate(0, this.pagingControlBounds.height);
            translatedHeight += this.pagingControlBounds.height;
            this.pagingSp = true;
        } else if (this.table.isPagingControlVisible() && pageDims > 0 && this.table.getPagingControlPosition() == 0 && !this.isRepeatComponent(4) && record.y == 0) {
            g.translate(0, this.pagingControlBounds.height);
            translatedHeight += this.pagingControlBounds.height;
            this.pagingSp = true;
        }
        if (this.title.isVisible()) {
            this.title.setSize(this.printableWidth, this.title.getPreferredSize().height);
            prefHeight = this.title.getPreferredSize().height;
            prefWidth = this.title.getPreferredSize().width;
            if (prefWidth > this.printableWidth) {
                prefWidth = this.printableWidth;
            }
            this.title.setSize(prefWidth, prefHeight);
        }
        if (this.title.isVisible() && (this.isRepeatComponent(8) || record.x == 0 && record.y == 0)) {
            this.titleHeight = prefHeight;
            g.setClip(0, 0, this.printableWidth, this.titleHeight);
            x = 0;
            if (this.title.getHorizontalAlignment() == 0) {
                if (this.printableWidth > prefWidth) {
                    x += (this.printableWidth - prefWidth) / 2;
                }
            } else if (this.title.getHorizontalAlignment() == 4) {
                x += this.printableWidth - prefWidth;
            }
            g.translate(x, 0);
            this.title.print(g);
            g.translate(-x, this.titleHeight);
            translatedHeight += this.titleHeight;
            this.titleSp = true;
        } else if (this.title.isVisible() && (this.isRepeatComponent(8) || record.y == 0)) {
            this.titleHeight = prefHeight;
            g.translate(0, this.titleHeight);
            translatedHeight += this.titleHeight;
            this.titleSp = true;
        }
        if (this.title.isVisible()) {
            this.title.setSize(this.oldTitleSize);
        }
        if (this.subtitle.isVisible()) {
            this.subtitle.setSize(this.printableWidth, this.subtitle.getPreferredSize().height);
            prefHeight = this.subtitle.getPreferredSize().height;
            prefWidth = this.subtitle.getPreferredSize().width;
            if (prefWidth > this.printableWidth) {
                prefWidth = this.printableWidth;
            }
            this.subtitle.setSize(prefWidth, prefHeight);
        }
        if (this.subtitle.isVisible() && (this.isRepeatComponent(16) || record.x == 0 && record.y == 0)) {
            this.subtitleHeight = prefHeight;
            g.setClip(0, 0, this.printableWidth, this.subtitleHeight);
            x = 0;
            if (this.subtitle.getHorizontalAlignment() == 0) {
                if (this.printableWidth > prefWidth) {
                    x += (this.printableWidth - prefWidth) / 2;
                }
            } else if (this.subtitle.getHorizontalAlignment() == 4) {
                x += this.printableWidth - prefWidth;
            }
            g.translate(x, 0);
            this.subtitle.print(g);
            g.translate(-x, this.subtitleHeight);
            translatedHeight += this.subtitleHeight;
            this.subtitleSp = true;
        } else if (this.subtitle.isVisible() && (this.isRepeatComponent(16) || record.y == 0)) {
            this.subtitleHeight = prefHeight;
            g.translate(0, this.subtitleHeight);
            translatedHeight += this.subtitleHeight;
            this.subtitleSp = true;
        }
        if (this.subtitle.isVisible()) {
            this.subtitle.setSize(this.oldSubtitleSize);
        }
        if (this.table.isPagingControlVisible() && pageDims > 0 && this.table.getPagingControlPosition() == 1 && (this.isRepeatComponent(4) || record.x == 0 && record.y == 0)) {
            g.setClip(0, 0, this.pagingControlBounds.width, this.pagingControlBounds.height);
            this.table.getPagingControl().getPagingComponent().validate();
            printContext = this.table.getPagingControl().getPagingComponent().getPrintPaintContext(g);
            this.table.getPagingControl().getPagingComponent().printPage(printContext, null, g);
            g.translate(0, this.pagingControlBounds.height);
            translatedHeight += this.pagingControlBounds.height;
            this.pagingSp = true;
        } else if (this.table.isPagingControlVisible() && pageDims > 0 && this.table.getPagingControlPosition() == 1 && !this.isRepeatComponent(4) && record.y == 0) {
            g.translate(0, this.pagingControlBounds.height);
            translatedHeight += this.pagingControlBounds.height;
            this.pagingSp = true;
        }
        for (i = record.firstColumn; i <= record.lastColumn; ++i) {
            this.table.getTableColumnHeader().clearAppliedStyleFlag(i);
        }
        for (i = record.firstRow; i <= record.lastRow; ++i) {
            this.table.getTableRowHeader().clearAppliedStyleFlag(i);
        }
        this.table.getTableColumnHeader().refreshHeaderStyle(record.firstColumn, record.lastColumn);
        this.table.getTableRowHeader().refreshHeaderStyle(record.firstRow, record.lastRow);
        printContext = this.spreadTable.getPrintPaintContext(g);
        g.setClip(0, 0, record.width, record.height);
        g.translate(-record.x, -record.y);
        this.spreadTable.printPage(printContext, this.printProperties, g);
        g.translate(record.x, record.y);
        g.setClip(null);
        if (this.footnote.isVisible()) {
            this.footnote.setSize(this.printableWidth, this.footnote.getPreferredSize().height);
            prefHeight = this.footnote.getPreferredSize().height;
            prefWidth = this.footnote.getPreferredSize().width;
            if (prefWidth > this.printableWidth) {
                prefWidth = this.printableWidth;
            }
            this.footnote.setSize(prefWidth, prefHeight);
        }
        if (this.footnote.isVisible() && (this.isRepeatComponent(32) || record.y + record.height >= this.documentSize.height && record.x + record.width >= this.documentSize.width)) {
            int footnoteStart = this.printableHeight - this.footnote.getPreferredSize().height;
            if (this.pagingSp) {
                footnoteStart -= this.pagingControlBounds.height;
            }
            if (this.titleSp) {
                footnoteStart -= this.titleHeight;
            }
            if (this.subtitleSp) {
                footnoteStart -= this.subtitleHeight;
            }
            if (this.textPaneSp) {
                footnoteStart -= this.topFTAHeight;
            }
            if (this.m_bottomFormattedText != null) {
                footnoteStart -= this.bottomFTAHeight;
            }
            this.footnoteSp = true;
            g.translate(0, footnoteStart);
            translatedHeight += footnoteStart;
            g.setClip(0, 0, this.printableWidth, this.footnote.getPreferredSize().height);
            int x2 = 0;
            if (this.footnote.getHorizontalAlignment() == 0) {
                if (this.printableWidth > prefWidth) {
                    x2 += (this.printableWidth - prefWidth) / 2;
                }
            } else if (this.footnote.getHorizontalAlignment() == 4) {
                x2 += this.printableWidth - prefWidth;
            }
            g.translate(x2, 0);
            this.footnote.print(g);
            g.translate(-x2, 0);
            g.translate(0, this.footnote.getPreferredSize().height);
            translatedHeight += this.footnote.getPreferredSize().height;
        }
        if (this.footnote.isVisible()) {
            this.footnote.setSize(this.oldFootnoteSize);
        }
        if (this.m_bottomFormattedText != null && (this.isRepeatComponent(128) || record.y + record.height >= this.documentSize.height && record.x + record.width >= this.documentSize.width)) {
            if (!this.footnoteSp) {
                int bottomFTAStart = this.printableHeight - this.bottomFTAHeight;
                if (this.pagingSp) {
                    bottomFTAStart -= this.pagingControlBounds.height;
                }
                if (this.titleSp) {
                    bottomFTAStart -= this.titleHeight;
                }
                if (this.subtitleSp) {
                    bottomFTAStart -= this.subtitleHeight;
                }
                if (this.textPaneSp) {
                    bottomFTAStart -= this.topFTAHeight;
                }
                g.translate(0, bottomFTAStart);
                translatedHeight += bottomFTAStart;
            }
            g.setClip(0, 0, this.printableWidth, this.bottomFTAHeight);
            this.m_bottomFormattedText.print(new Dimension(this.printableWidth, this.bottomFTAHeight), g);
            g.translate(0, this.bottomFTAHeight);
            translatedHeight += this.bottomFTAHeight;
        }
        g.translate(-translatedWidth, -translatedHeight);
        g.setClip(savedBounds);
        this.table.repaint();
    }

    @Override
    public boolean goToFirstPage() {
        return this.prepareFirstPage(null);
    }

    @Override
    public boolean prepareFirstPage(Graphics g) {
        if (this.table.isDataUnavailable()) {
            this.table.getErrorHandler().log("data is unavailable to print", this.getClass().getName(), "prepareFirstPage");
            return false;
        }
        try {
            this.hashTable = new Hashtable();
            this.pageNum = 0;
            this.m_seqPageNumber = 0;
            if (this.rangeType == 1) {
                this.viewLogPage.setHPos(this.table.getTableModel().getDataAccess().getFirstHPos(2));
                this.viewLogPageNum = 0;
            } else if (this.rangeType == 0) {
                this.viewLogPage.setHPos(this.currLogPage.getHPos());
                this.viewLogPageNum = 0;
            } else if (this.m_selectedHPos != null && this.m_selectedHPos.size() > this.m_selectedIndex) {
                this.viewLogPage.setHPos((int[])this.m_selectedHPos.elementAt(this.m_selectedIndex));
                this.viewLogPageNum = 0;
            } else {
                return false;
            }
            this.checkDataSourceLogPage();
            this.initCache();
            this.printableWidth = this.paperWidth - (this.leftMargin + this.rightMargin);
            this.record = new PaginationRecord();
            this.record.pageNum = ++this.pageNum;
            ++this.m_seqPageNumber;
            this.calcMargins(g);
            this.printableHeight = this.paperHeight - (this.topMargin + this.bottomMargin);
            this.resizeGridView();
            this.table.validate();
            this.calcAdornmentsDimension(this.printableWidth);
            this.spreadTableHeight = this.printableHeight - this.totalAdornHeight;
            this.currX = 0;
            this.currY = 0;
            this.currentOuter = 0;
            this.currentInner = 0;
            if (this.isRepeatHeaders()) {
                this.spreadTableHeight = this.printableHeight - this.totalAdornHeight;
            }
            if (!this.isRepeatHeaders() && this.currY == 0) {
                this.spreadTableHeight = this.printableHeight - this.totalAdornHeight;
            } else if (!this.isRepeatHeaders() && this.currY != 0) {
                this.spreadTableHeight = this.printableHeight - this.repeatAdornHeight;
            }
            if (this.spreadTableHeight < 20 || this.printableWidth < 20) {
                this.logInsuffMsg("prepareFirstPage");
                this.m_insuffSapce = true;
                return false;
            }
            this.newPageBounds = this.getPageBounds(this.currX, this.currY, this.printableWidth, this.spreadTableHeight);
            this.documentSize = this.spreadTable.getDocumentSize(this.spreadTable.getPaintContext(), this.printProperties);
            if (this.printByColumns) {
                this.outerLoop = this.documentSize.height;
                this.innerLoop = this.documentSize.width;
            } else {
                this.outerLoop = this.documentSize.width;
                this.innerLoop = this.documentSize.height;
            }
            this.record.y = this.currY;
            this.record.x = this.currX;
            this.record.height = this.newPageBounds.height;
            this.record.width = this.newPageBounds.width;
            this.record.firstRow = this.spreadTable.getGrid().getRowAt(this.currY);
            this.record.lastRow = this.spreadTable.getGrid().getRowAt(this.currY + this.newPageBounds.y - 1);
            this.record.firstColumn = this.spreadTable.getGrid().getColumnAt(this.currX);
            this.record.lastColumn = this.spreadTable.getGrid().getColumnAt(this.currX + this.newPageBounds.x - 1);
            if (this.record.lastRow < 0) {
                this.record.lastRow = this.spreadTable.getGrid().getRowCount() - 1;
            }
            if (this.record.lastColumn < 0) {
                this.record.lastColumn = this.spreadTable.getGrid().getColumnCount() - 1;
            }
            this.adjustForPageBreak(this.currY, this.record, this.newPageBounds);
            this.table.setFirstPrintedRow(this.record.firstRow);
            this.v = new Vector();
            Vector firstVector = this.v;
            this.v.addElement(this.record);
            this.index = 0;
            this.hashTable.put(new Integer(this.viewLogPageNum), firstVector);
            if (this.printByColumns) {
                this.currX += this.newPageBounds.x;
                this.currentInner = this.currX;
            } else {
                this.currY += this.newPageBounds.y;
                this.currentInner = this.currY;
            }
            if (this.currentInner >= this.innerLoop) {
                if (this.printByColumns) {
                    this.currX = 0;
                    this.currY += this.newPageBounds.y;
                    this.currentOuter = this.currY;
                } else {
                    this.currY = 0;
                    this.currX += this.newPageBounds.x;
                    this.currentOuter = this.currX;
                }
            }
        }
        catch (EdgeOutOfRangeException e) {
            this.table.getErrorHandler().error((Throwable)e, this.getClass().getName(), "prepareFirstPage");
        }
        return true;
    }

    @Override
    public boolean hasNextPage() {
        if (this.m_insuffSapce) {
            return false;
        }
        if (this.table.isDataUnavailable()) {
            this.table.getErrorHandler().log("data is unavailable to print", this.getClass().getName(), "hasNextPage");
            return false;
        }
        if (this.record != null && this.record.pageNum < this.pageNum) {
            return true;
        }
        if (this.currentInner < this.innerLoop && this.currentInner != 0) {
            return true;
        }
        if (this.currentOuter < this.outerLoop && this.currentOuter != 0) {
            return true;
        }
        try {
            if (this.rangeType == 1 && this.table.getTableModel().getDataAccess().getNextHPos(2, this.viewLogPage.getHPos()) != null) {
                this.newLogPageIsNext = true;
                return true;
            }
            if (this.rangeType == 2 && this.m_selectedHPos != null && this.m_selectedHPos.size() > this.m_selectedIndex + 1) {
                this.newLogPageIsNext = true;
                return true;
            }
        }
        catch (DataException e) {
            this.table.getErrorHandler().error((Throwable)e, this.getClass().getName(), "hasNextPage");
        }
        return false;
    }

    @Override
    public boolean goToNextPage() {
        return this.prepareNextPage(null);
    }

    @Override
    public boolean prepareNextPage(Graphics g) {
        if (this.table.isDataUnavailable()) {
            this.table.getErrorHandler().log("data is unavailable to print", this.getClass().getName(), "prepareNextPage");
            return false;
        }
        if (this.record != null && this.record.pageNum < this.pageNum) {
            if (this.index < this.v.size() - 1) {
                ++this.index;
                this.record = (PaginationRecord)this.v.elementAt(this.index);
                ++this.m_seqPageNumber;
                this.calcMargins(g);
                this.printableHeight = this.paperHeight - (this.topMargin + this.bottomMargin);
                if (this.checkDataSourceLogPage()) {
                    this.fetchRowBlock(this.record.firstRow, this.record.lastRow);
                    this.resizeColumnWidths(this.record.firstColumn, this.record.lastColumn, -1, -1);
                    this.resizeRowHeights(-1, -1, this.record.firstRow, this.record.lastRow);
                } else {
                    this.resetCurrentLogicalPage();
                }
                this.table.setFirstPrintedRow(this.record.firstRow);
            } else {
                int[] nextHPos = null;
                try {
                    if (this.rangeType == 1) {
                        nextHPos = this.table.getTableModel().getDataAccess().getNextHPos(2, this.viewLogPage.getHPos());
                    } else if (this.rangeType == 2 && this.m_selectedHPos != null && this.m_selectedHPos.size() > this.m_selectedIndex + 1) {
                        nextHPos = (int[])this.m_selectedHPos.elementAt(++this.m_selectedIndex);
                    }
                }
                catch (DataException e) {
                    this.table.getErrorHandler().error((Throwable)e, this.getClass().getName(), "prepareNextPage");
                }
                if (nextHPos != null) {
                    this.updateCache();
                    this.viewLogPage.setHPos(nextHPos);
                    ++this.viewLogPageNum;
                    try {
                        this.changePageEdgeCurrentHPos(this.viewLogPage.getHPos(), this.viewLogPage.getHPos().length - 1);
                    }
                    catch (DataException e) {
                        this.table.getErrorHandler().error((Throwable)e, this.getClass().getName(), "prepareNextPage");
                    }
                    this.initCache();
                    if (this.checkForNoData()) {
                        return false;
                    }
                    this.v = (Vector)this.hashTable.get(new Integer(this.viewLogPageNum));
                    this.index = 0;
                    this.calcAdornmentsDimension(this.printableWidth);
                    this.resizeGridView();
                    this.table.validate();
                }
                this.record = (PaginationRecord)this.v.elementAt(this.index);
                ++this.m_seqPageNumber;
                this.calcMargins(g);
                this.printableHeight = this.paperHeight - (this.topMargin + this.bottomMargin);
                this.fetchRowBlock(this.record.firstRow, this.record.lastRow);
                this.resizeColumnWidths(this.record.firstColumn, this.record.lastColumn, -1, -1);
                this.resizeRowHeights(-1, -1, this.record.firstRow, this.record.lastRow);
                this.table.setFirstPrintedRow(this.record.firstRow);
            }
        } else {
            if (this.currentOuter > this.outerLoop || this.newLogPageIsNext) {
                this.newLogPageIsNext = false;
                this.index = -1;
                this.currX = 0;
                this.currY = 0;
                this.currentOuter = 0;
                this.currentInner = 0;
                int[] nextHPos = null;
                try {
                    if (this.rangeType == 1) {
                        nextHPos = this.table.getTableModel().getDataAccess().getNextHPos(2, this.viewLogPage.getHPos());
                    } else if (this.rangeType == 2 && this.m_selectedHPos != null && this.m_selectedHPos.size() > this.m_selectedIndex + 1) {
                        nextHPos = (int[])this.m_selectedHPos.elementAt(++this.m_selectedIndex);
                    }
                }
                catch (DataException e) {
                    this.table.getErrorHandler().error((Throwable)e, this.getClass().getName(), "prepareNextPage");
                }
                if (nextHPos != null) {
                    this.updateCache();
                    try {
                        this.viewLogPage.setHPos(nextHPos);
                        ++this.viewLogPageNum;
                        this.changePageEdgeCurrentHPos(this.viewLogPage.getHPos(), this.viewLogPage.getHPos().length - 1);
                    }
                    catch (DataException e) {
                        this.table.getErrorHandler().error((Throwable)e, this.getClass().getName(), "prepareNextPage");
                    }
                    this.initCache();
                }
                if (this.checkForNoData()) {
                    return false;
                }
                this.resizeGridView();
                this.table.validate();
                this.calcAdornmentsDimension(this.printableWidth);
                this.record = new PaginationRecord();
                this.record.pageNum = ++this.pageNum;
                ++this.m_seqPageNumber;
                this.calcMargins(g);
                this.printableHeight = this.paperHeight - (this.topMargin + this.bottomMargin);
                this.spreadTableHeight = this.printableHeight - this.totalAdornHeight;
                this.documentSize = this.spreadTable.getDocumentSize(this.spreadTable.getPaintContext(), this.printProperties);
                this.outerLoop = this.documentSize.height;
                this.innerLoop = this.documentSize.width;
                if (!this.printByColumns) {
                    this.outerLoop = this.documentSize.width;
                    this.innerLoop = this.documentSize.height;
                }
                this.v = new Vector();
                Vector nexVector = this.v;
                this.hashTable.put(new Integer(this.viewLogPageNum), nexVector);
            } else {
                this.record = new PaginationRecord();
                this.record.pageNum = ++this.pageNum;
                ++this.m_seqPageNumber;
                this.calcMargins(g);
                this.printableHeight = this.paperHeight - (this.topMargin + this.bottomMargin);
            }
            if (this.isRepeatHeaders()) {
                this.spreadTableHeight = this.printableHeight - this.totalAdornHeight;
            }
            if (!this.isRepeatHeaders() && this.currY == 0) {
                this.spreadTableHeight = this.printableHeight - this.totalAdornHeight;
            } else if (!this.isRepeatHeaders() && this.currY != 0) {
                this.spreadTableHeight = this.printableHeight - this.repeatAdornHeight;
            }
            this.printableWidth = this.paperWidth - (this.leftMargin + this.rightMargin);
            if (this.spreadTableHeight < 20 || this.printableWidth < 20) {
                this.logInsuffMsg("prepareNextPage");
                this.m_insuffSapce = true;
                return false;
            }
            this.newPageBounds = this.getPageBounds(this.currX, this.currY, this.printableWidth, this.spreadTableHeight);
            this.documentSize = this.spreadTable.getDocumentSize(this.spreadTable.getPaintContext(), this.printProperties);
            if (this.printByColumns) {
                this.outerLoop = this.documentSize.height;
                this.innerLoop = this.documentSize.width;
            } else {
                this.outerLoop = this.documentSize.width;
                this.innerLoop = this.documentSize.height;
            }
            this.record.y = this.currY;
            this.record.x = this.currX;
            this.record.height = this.newPageBounds.height;
            this.record.width = this.newPageBounds.width;
            this.record.firstRow = this.spreadTable.getGrid().getRowAt(this.currY);
            this.record.lastRow = this.spreadTable.getGrid().getRowAt(this.currY + this.newPageBounds.y - 1);
            this.record.firstColumn = this.spreadTable.getGrid().getColumnAt(this.currX);
            this.record.lastColumn = this.spreadTable.getGrid().getColumnAt(this.currX + this.newPageBounds.x - 1);
            if (this.record.lastRow < 0) {
                this.record.lastRow = this.spreadTable.getGrid().getRowCount() - 1;
            }
            if (this.record.lastColumn < 0) {
                this.record.lastColumn = this.spreadTable.getGrid().getColumnCount() - 1;
            }
            this.adjustForPageBreak(this.currY, this.record, this.newPageBounds);
            this.table.setFirstPrintedRow(this.record.firstRow);
            ++this.index;
            if (this.v == null) {
                this.v = new Vector();
            }
            this.v.addElement(this.record);
            if (this.printByColumns) {
                this.currX += this.newPageBounds.x;
                this.currentInner = this.currX;
            } else {
                this.currY += this.newPageBounds.y;
                this.currentInner = this.currY;
            }
            if (this.currentInner >= this.innerLoop) {
                if (this.printByColumns) {
                    this.currX = 0;
                    this.currY += this.newPageBounds.y;
                    this.currentOuter = this.currY;
                } else {
                    this.currY = 0;
                    this.currX += this.newPageBounds.x;
                    this.currentOuter = this.currX;
                }
            }
        }
        return true;
    }

    @Override
    protected void resizeGridView() {
        this.table.sizeRowHeaderColumnWidths();
        this.table.updateColumnHeaderRowHeights();
    }

    @Override
    protected boolean resizeRowHeights(int firstCol, int lastCol, int firstRow, int lastRow) {
        boolean returnVal = false;
        if (firstRow < 0 || lastRow < 0) {
            this.table.getErrorHandler().log("invalid row index", this.getClass().getName(), m_method_resizerowheights);
            return false;
        }
        int rowHeight = 0;
        for (int row = firstRow; row <= lastRow; ++row) {
            if (!this.m_dirtyRowHeights[row]) continue;
            rowHeight = this.m_rowHeights[row];
            if (rowHeight < 0) {
                if ((this.table.getAutoFitScope() & 1) > 0) {
                    rowHeight = this.table.calcAutoFitRowHeights(firstCol, lastCol, row, row)[0];
                    this.table.getTableSizingManager().setCalculatedRowHeight(row, rowHeight);
                }
                this.table.sizeRowHeights(row, row);
                this.m_rowHeights[row] = this.spreadTable.getRowHeight(row);
                if (this.m_bPreviewMode) {
                    this.m_bUpdateRowHeightsCache = true;
                }
            } else {
                this.spreadTable.setRowHeight(row, rowHeight);
            }
            this.m_dirtyRowHeights[row] = false;
            returnVal = true;
        }
        return returnVal;
    }

    @Override
    protected boolean resizeColumnWidths(int firstCol, int lastCol, int firstRow, int lastRow) {
        if (firstCol < 0 || lastCol < 0) {
            this.table.getErrorHandler().log("invalid column index", this.getClass().getName(), m_method_resizeColumnWidths);
            return false;
        }
        boolean returnVal = false;
        int colWidth = 0;
        for (int col = firstCol; col <= lastCol; ++col) {
            if (!this.m_dirtyColWidths[col]) continue;
            colWidth = this.m_colWidths[col];
            if (colWidth < 0) {
                if ((this.table.getAutoFitScope() & 2) > 0) {
                    colWidth = this.table.calcAutoFitColumnWidths(col, col, firstRow, lastRow)[0];
                    this.table.getTableSizingManager().setCalculatedColumnWidth(col, colWidth);
                }
                this.table.sizeColumnWidths(col, col);
                this.m_colWidths[col] = this.spreadTable.getColumnWidth(col);
                if (this.m_bPreviewMode) {
                    this.m_bUpdateColWidthsCache = true;
                }
            } else {
                this.spreadTable.setColumnWidth(col, colWidth);
            }
            this.m_dirtyColWidths[col] = false;
            returnVal = true;
        }
        return returnVal;
    }

    protected Rectangle getPageBounds(int curX, int curY, int printableWidth, int spreadHeight) {
        Rectangle newPageBounds = this.spreadTable.getPageBounds(null, this.printProperties, curX, curY, printableWidth, spreadHeight);
        int firstRowOnPage = this.spreadTable.getGrid().getRowAt(curY);
        int firstColOnPage = this.spreadTable.getGrid().getColumnAt(curX);
        boolean bPageFilled = false;
        int nextRowToBeResized = firstRowOnPage;
        int lastRow = -1;
        int lastCol = -1;
        int startCol = -1;
        int endCol = -1;
        if ((this.table.getAutoFitScope() & 1) > 0) {
            Range colRange = this.table.getAutoFitColumnRange(firstColOnPage);
            startCol = colRange.begin;
            endCol = colRange.end;
        }
        if (endCol < startCol) {
            this.table.getErrorHandler().log("invalid column range", this.getClass().getName(), "getPageBounds");
        }
        while (!bPageFilled) {
            int lastRowOnPage = this.spreadTable.getGrid().getRowAt(curY + newPageBounds.y - 1);
            try {
                lastRow = this.table.getTableModel().getDataAccess().getEdgeExtent(1) - 1;
            }
            catch (DataException de) {
                this.table.getErrorHandler().error((Throwable)de, this.getClass().getName(), "getPageBounds");
                lastRow = firstRowOnPage;
            }
            if (lastRowOnPage < 0 || lastRowOnPage > lastRow) {
                lastRowOnPage = lastRow;
            }
            int lastFetchedRow = this.fetchRowBlock(firstRowOnPage, this.getLastRowToFetch(firstRowOnPage, lastRowOnPage));
            for (int row = nextRowToBeResized; row <= lastFetchedRow; ++row) {
                if (this.resizeRowHeights(startCol, endCol, row, row)) {
                    newPageBounds = this.spreadTable.getPageBounds(null, this.printProperties, curX, curY, printableWidth, spreadHeight);
                }
                if ((lastRowOnPage = this.spreadTable.getGrid().getRowAt(curY + newPageBounds.y - 1)) < 0 || lastRowOnPage > lastRow) {
                    lastRowOnPage = lastRow;
                }
                if ((lastRowOnPage <= -1 || lastRowOnPage >= row) && row != lastRow) continue;
                bPageFilled = true;
                break;
            }
            if (bPageFilled) continue;
            nextRowToBeResized = lastFetchedRow + 1;
        }
        if ((this.table.getAutoFitScope() & 1) > 0 && this.table.getAutoFitColumnRangeCallback() != null) {
            this.table.getAutoFitColumnRangeCallback().endAutoFit();
        }
        int startRow = -1;
        int endRow = -1;
        if ((this.table.getAutoFitScope() & 2) > 0) {
            Range rowRange = this.table.getAutoFitRowRange(firstRowOnPage);
            startRow = rowRange.begin;
            endRow = rowRange.end;
        }
        if (endRow < startRow) {
            this.table.getErrorHandler().log("invalid row range", this.getClass().getName(), "getPageBounds");
        }
        int lastColOnPage = this.spreadTable.getGrid().getColumnAt(curX + newPageBounds.x - 1);
        try {
            lastCol = this.table.getTableModel().getDataAccess().getEdgeExtent(0) - 1;
        }
        catch (DataException de) {
            this.table.getErrorHandler().error((Throwable)de, this.getClass().getName(), "getPageBounds");
            lastCol = firstColOnPage;
        }
        if (lastColOnPage < 0 || lastColOnPage > lastCol) {
            lastColOnPage = lastCol;
        }
        for (int col = firstColOnPage; col <= lastColOnPage + 1 && col <= lastCol; ++col) {
            if (this.resizeColumnWidths(col, col, startRow, endRow)) {
                newPageBounds = this.spreadTable.getPageBounds(null, this.printProperties, curX, curY, printableWidth, spreadHeight);
            }
            if ((lastColOnPage = this.spreadTable.getGrid().getColumnAt(curX + newPageBounds.x - 1)) < 0 || lastColOnPage > lastCol) {
                lastColOnPage = lastCol;
            }
            if (lastColOnPage > -1 && lastColOnPage < col || col == lastCol) break;
        }
        if ((this.table.getAutoFitScope() & 2) > 0 && this.table.getAutoFitRowRangeCallback() != null) {
            this.table.getAutoFitRowRangeCallback().endAutoFit();
        }
        return newPageBounds;
    }

    @Override
    public boolean hasPrevPage() {
        if (this.table.isDataUnavailable()) {
            this.table.getErrorHandler().log("data is unavailable to print", this.getClass().getName(), "hasPrevPage");
            return false;
        }
        if (this.index > 0) {
            return true;
        }
        try {
            if (this.rangeType == 1 && this.table.getTableModel().getDataAccess().getPrevHPos(2, this.viewLogPage.getHPos()) != null) {
                return true;
            }
            if (this.rangeType == 2 && this.m_selectedHPos != null && this.m_selectedIndex > 0) {
                this.newLogPageIsNext = true;
                return true;
            }
        }
        catch (DataException e) {
            this.table.getErrorHandler().error((Throwable)e, this.getClass().getName(), "hasPrevPage");
        }
        return false;
    }

    @Override
    public boolean goToPrevPage() {
        return this.preparePrevPage(null);
    }

    @Override
    public boolean preparePrevPage(Graphics g) {
        if (this.table.isDataUnavailable()) {
            this.table.getErrorHandler().log("data is unavailable to print", this.getClass().getName(), "preparePrevPage");
            return false;
        }
        if (this.index > 0) {
            --this.index;
            this.record = (PaginationRecord)this.v.elementAt(this.index);
            --this.m_seqPageNumber;
            if (this.checkDataSourceLogPage()) {
                this.fetchRowBlock(this.record.firstRow, this.record.lastRow);
                this.resizeColumnWidths(this.record.firstColumn, this.record.lastColumn, -1, -1);
                this.resizeRowHeights(-1, -1, this.record.firstRow, this.record.lastRow);
            } else {
                this.resetCurrentLogicalPage();
            }
            this.table.setFirstPrintedRow(this.record.firstRow);
        } else {
            int[] previous = null;
            try {
                if (this.rangeType == 1) {
                    previous = this.table.getTableModel().getDataAccess().getPrevHPos(2, this.viewLogPage.getHPos());
                } else if (this.rangeType == 2 && this.m_selectedHPos != null && this.m_selectedIndex > 0) {
                    previous = (int[])this.m_selectedHPos.elementAt(--this.m_selectedIndex);
                }
            }
            catch (DataException e) {
                this.table.getErrorHandler().error((Throwable)e, this.getClass().getName(), "preparePrevPage");
            }
            if (previous != null) {
                this.updateCache();
                try {
                    this.viewLogPage.setHPos(previous);
                    --this.viewLogPageNum;
                    this.changePageEdgeCurrentHPos(this.viewLogPage.getHPos(), this.viewLogPage.getHPos().length - 1);
                }
                catch (DataException e) {
                    this.table.getErrorHandler().error((Throwable)e, this.getClass().getName(), "preparePrevPage");
                }
                this.initCache();
                if (this.checkForNoData()) {
                    return false;
                }
                this.v = (Vector)this.hashTable.get(new Integer(this.viewLogPageNum));
                this.index = this.v.size() - 1;
                --this.m_seqPageNumber;
                this.calcAdornmentsDimension(this.printableWidth);
                this.resizeGridView();
                this.table.validate();
                this.record = (PaginationRecord)this.v.elementAt(this.index);
                this.fetchRowBlock(this.record.firstRow, this.record.lastRow);
                this.resizeColumnWidths(0, this.record.lastColumn, -1, -1);
                this.resizeRowHeights(-1, -1, 0, this.record.lastRow);
                this.table.setFirstPrintedRow(this.record.firstRow);
            }
        }
        this.calcMargins(g);
        this.printableHeight = this.paperHeight - (this.topMargin + this.bottomMargin);
        return true;
    }

    private int calcZoomFactor() {
        int zoomFactorDown;
        int zoomFactorAcross;
        block8: {
            int columnHeaderHeight;
            int singlePageHeight;
            block7: {
                int singlePageWidth = this.dimension.width - (this.leftMargin + this.rightMargin);
                int allPagesWidth = singlePageWidth * this.fitToNumPagesWide;
                singlePageHeight = this.dimension.height - (this.topMargin + this.bottomMargin);
                int allPagesHeight = singlePageHeight * this.fitToNumPagesTall;
                this.calcAdornmentsDimension(singlePageWidth);
                int tableWidth = this.spreadTable.getGrid().getColumnGeometryManager().getTotalSize();
                int rowHeaderWidth = 0;
                if (this.spreadTable.getRowHeader().isVisible()) {
                    rowHeaderWidth = this.spreadTable.getRowHeader().getCanvasWidth();
                    tableWidth = this.isRepeatComponent(2) ? (tableWidth += rowHeaderWidth * this.fitToNumPagesWide) : (tableWidth += rowHeaderWidth);
                }
                int tableHeight = this.spreadTable.getGrid().getRowGeometryManager().getTotalSize();
                columnHeaderHeight = 0;
                if (this.spreadTable.getRowHeader().isVisible()) {
                    columnHeaderHeight = this.spreadTable.getColumnHeader().getCanvasHeight();
                    tableHeight = this.isRepeatComponent(1) ? (tableHeight += columnHeaderHeight * this.fitToNumPagesTall) : (tableHeight += columnHeaderHeight);
                }
                tableHeight = this.isRepeatComponent(64) ? (tableHeight += this.topFTAHeight * this.fitToNumPagesTall) : (tableHeight += this.topFTAHeight);
                tableHeight = this.isRepeatComponent(8) ? (tableHeight += this.titleHeight * this.fitToNumPagesTall) : (tableHeight += this.titleHeight);
                tableHeight = this.isRepeatComponent(16) ? (tableHeight += this.subtitleHeight * this.fitToNumPagesTall) : (tableHeight += this.subtitleHeight);
                tableHeight = this.isRepeatComponent(4) ? (tableHeight += this.pagingControlBounds.height * this.fitToNumPagesTall) : (tableHeight += this.pagingControlBounds.height);
                zoomFactorAcross = 100 * allPagesWidth / tableWidth;
                zoomFactorDown = 100 * allPagesHeight / (tableHeight += (this.bottomFTAHeight + this.footnoteHeight) * this.fitToNumPagesTall);
                int tmpZoomFactor = Math.min(zoomFactorAcross, zoomFactorDown);
                if (singlePageHeight - DataviewUtils.scaleByZoom(this.totalAdornHeight, tmpZoomFactor) < DataviewUtils.scaleByZoom(columnHeaderHeight, tmpZoomFactor) || singlePageWidth < DataviewUtils.scaleByZoom(rowHeaderWidth, tmpZoomFactor)) {
                    this.logInsuffMsg("calcZoomFactor");
                    return -1;
                }
                if (zoomFactorAcross > zoomFactorDown) break block7;
                int pages = this.fitToNumPagesWide + 1;
                while (pages > this.fitToNumPagesWide && (pages = this.getTotalPagesAcross(rowHeaderWidth, zoomFactorAcross)) > this.fitToNumPagesWide) {
                    int diff = pages - this.fitToNumPagesWide;
                    int extraSpace = (diff - 1) * singlePageWidth + this.totalColWidth;
                    int additionalPerc = (int)((float)extraSpace / (float)(pages * singlePageWidth) * 100.0f);
                    if (additionalPerc == 0) {
                        additionalPerc = 1;
                    }
                    zoomFactorAcross -= additionalPerc;
                }
                break block8;
            }
            if (zoomFactorDown >= zoomFactorAcross) break block8;
            int pages = this.fitToNumPagesTall + 1;
            while (pages > this.fitToNumPagesTall && (pages = this.getTotalPagesDown(columnHeaderHeight, zoomFactorDown)) > this.fitToNumPagesTall) {
                int diff = pages - this.fitToNumPagesTall;
                int extraSpace = (diff - 1) * singlePageHeight + this.totalRowHeight;
                int additionalPerc = (int)((float)extraSpace / (float)(pages * singlePageHeight) * 100.0f);
                if (additionalPerc == 0) {
                    additionalPerc = 1;
                }
                zoomFactorDown -= additionalPerc;
            }
        }
        return Math.min(zoomFactorAcross, zoomFactorDown);
    }

    private int getTotalPagesDown(int columnHeaderHeight, int zoomFactorDown) {
        boolean adornHeight = false;
        int scaledColumnHeaderHeight = DataviewUtils.scaleByZoom(columnHeaderHeight, zoomFactorDown);
        int gridHt = 0;
        int rowCount = this.spreadTable.getGrid().getModel().getRowCount();
        int currRow = 0;
        int sepHeight = 0;
        if (this.spreadTable.getHorizontalSeparatorsVisible()) {
            sepHeight = this.table.isGrid3D() ? 2 : 1;
        }
        int downPages = 0;
        block0: while (currRow < rowCount) {
            if (this.isRepeatHeaders()) {
                gridHt = this.dimension.height - (this.topMargin + this.bottomMargin) - scaledColumnHeaderHeight - (this.topFTAHeight + DataviewUtils.scaleByZoom(this.titleHeight, zoomFactorDown) + DataviewUtils.scaleByZoom(this.subtitleHeight, zoomFactorDown) + DataviewUtils.scaleByZoom(this.footnoteHeight, zoomFactorDown) + DataviewUtils.scaleByZoom(this.pagingControlBounds.height, zoomFactorDown) + this.bottomFTAHeight);
            } else if (currRow == 0) {
                gridHt = this.dimension.height - (this.topMargin + this.bottomMargin) - scaledColumnHeaderHeight - (this.topFTAHeight + DataviewUtils.scaleByZoom(this.titleHeight, zoomFactorDown) + DataviewUtils.scaleByZoom(this.subtitleHeight, zoomFactorDown) + DataviewUtils.scaleByZoom(this.footnoteHeight, zoomFactorDown) + DataviewUtils.scaleByZoom(this.pagingControlBounds.height, zoomFactorDown) + this.bottomFTAHeight);
            } else {
                gridHt = this.dimension.height - (this.topMargin + this.bottomMargin) - (DataviewUtils.scaleByZoom(this.footnoteHeight, zoomFactorDown) + this.bottomFTAHeight);
                if (this.isRepeatComponent(8)) {
                    gridHt -= DataviewUtils.scaleByZoom(this.titleHeight, zoomFactorDown);
                }
                if (this.isRepeatComponent(16)) {
                    gridHt -= DataviewUtils.scaleByZoom(this.subtitleHeight, zoomFactorDown);
                }
                if (this.isRepeatComponent(4)) {
                    gridHt -= DataviewUtils.scaleByZoom(this.pagingControlBounds.height, zoomFactorDown);
                }
            }
            int rowHeight = 0;
            boolean done = false;
            this.totalRowHeight = 0;
            while (this.totalRowHeight <= gridHt && !done) {
                if (rowHeight > gridHt) {
                    this.totalRowHeight = gridHt;
                    rowHeight -= gridHt;
                    done = true;
                    ++downPages;
                    continue block0;
                }
                int currRowHeight = DataviewUtils.scaleByZoom(this.spreadTable.getRowHeight(currRow++), zoomFactorDown);
                if (rowHeight > 0 && rowHeight + (currRowHeight += sepHeight) > gridHt) {
                    done = true;
                    --currRow;
                    this.totalRowHeight = rowHeight;
                    rowHeight = 0;
                    ++downPages;
                    continue block0;
                }
                if (rowHeight == 0 && currRowHeight > gridHt) {
                    this.totalRowHeight = gridHt;
                    rowHeight = currRowHeight - gridHt;
                    ++downPages;
                    done = true;
                    continue block0;
                }
                this.totalRowHeight += rowHeight + currRowHeight;
                rowHeight = 0;
                if (this.totalRowHeight > gridHt) {
                    ++downPages;
                    --currRow;
                }
                if (currRow < rowCount) continue;
                ++downPages;
                done = true;
            }
        }
        return downPages;
    }

    private int getTotalPagesAcross(int rowHeaderWidth, int zoomFactorAcross) {
        boolean adornHeight = false;
        int scaledRowHeaderWidth = DataviewUtils.scaleByZoom(rowHeaderWidth, zoomFactorAcross);
        int gridWd = 0;
        int colCount = this.spreadTable.getGrid().getModel().getColumnCount();
        int currCol = 0;
        int sepWidth = 0;
        if (this.spreadTable.getVerticalSeparatorsVisible()) {
            sepWidth = this.table.isGrid3D() ? 2 : 1;
        }
        int acrossPages = 0;
        block0: while (currCol < colCount) {
            gridWd = this.isRepeatComponent(2) ? this.dimension.width - (this.leftMargin + this.rightMargin) - scaledRowHeaderWidth : (currCol == 0 ? this.dimension.width - (this.leftMargin + this.rightMargin) - scaledRowHeaderWidth : this.dimension.width - (this.leftMargin + this.rightMargin));
            int columnWidth = 0;
            boolean done = false;
            this.totalColWidth = 0;
            while (this.totalColWidth <= gridWd && !done) {
                if (columnWidth > gridWd) {
                    this.totalColWidth = gridWd;
                    columnWidth -= gridWd;
                    done = true;
                    ++acrossPages;
                    continue block0;
                }
                int currColWidth = DataviewUtils.scaleByZoom(this.spreadTable.getColumnWidth(currCol++), zoomFactorAcross);
                if (columnWidth > 0 && columnWidth + (currColWidth += sepWidth) > gridWd) {
                    done = true;
                    --currCol;
                    this.totalColWidth = columnWidth;
                    columnWidth = 0;
                    ++acrossPages;
                    continue block0;
                }
                if (columnWidth == 0 && currColWidth > gridWd) {
                    this.totalColWidth = gridWd;
                    columnWidth = currColWidth - gridWd;
                    ++acrossPages;
                    done = true;
                    continue block0;
                }
                this.totalColWidth += columnWidth + currColWidth;
                columnWidth = 0;
                if (this.totalColWidth > gridWd) {
                    ++acrossPages;
                    --currCol;
                }
                if (currCol < colCount) continue;
                ++acrossPages;
                done = true;
            }
        }
        return acrossPages;
    }

    private void adjustForPageBreak(int curY, PaginationRecord record, Rectangle newPageBounds) {
        GridViewAppearanceMgr appMgr = (GridViewAppearanceMgr)this.table.getTableDatabody().getAppearanceManager();
        int startRow = this.spreadTable.getGrid().getRowAt(curY);
        int lastRow = this.spreadTable.getGrid().getRowAt(newPageBounds.y + curY - 1);
        if (lastRow == -1) {
            lastRow = this.spreadTable.getGrid().getRowCount() - 1;
        }
        int pageBreakRow = -1;
        for (int row = startRow; row < lastRow; ++row) {
            ViewStyle style = appMgr.getCellAppearance(0, row);
            if (!style.isHPageBreak()) continue;
            pageBreakRow = row;
            break;
        }
        if (pageBreakRow != -1) {
            int columnHeaderHeight;
            newPageBounds.y = record.height = this.spreadTable.getGrid().getRowPosition(pageBreakRow + 1) - this.spreadTable.getGrid().getRowPosition(startRow);
            boolean showColHeader = curY == 0 || this.isRepeatComponent(1);
            int n = columnHeaderHeight = showColHeader && this.spreadTable.isColumnHeaderVisible() ? this.spreadTable.getColumnHeader().getSize().height : 0;
            if (columnHeaderHeight >= this.spreadTableHeight) {
                int temp = this.spreadTableHeight / 8;
                columnHeaderHeight = this.spreadTableHeight - temp;
            }
            record.height += columnHeaderHeight;
        }
    }

    private void saveCellSelection() {
        this.colSelection = this.spreadTable.getColumnHeader().getSelection();
        this.rowSelection = this.spreadTable.getRowHeader().getSelection();
        this.selection = this.spreadTable.getSelection();
        OneDSelection rsel = new OneDSelection();
        OneDSelection csel = new OneDSelection();
        TwoDSelection gsel = new TwoDSelection();
        try {
            this.spreadTable.setSelection(gsel);
            this.spreadTable.getColumnHeader().setSelection(csel);
            this.spreadTable.getRowHeader().setSelection(rsel);
        }
        catch (PropertyVetoException e) {
            this.table.getErrorHandler().log("can't set selection", this.getClass().getName(), "saveCellSelection");
        }
        this.selectionRemoved = true;
    }

    private void logInsuffMsg(String method) {
        this.table.getErrorHandler().log("Insufficient space to print the View", this.getClass().getName(), method);
    }
}

