/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.table;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.beans.PropertyVetoException;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.header.HeaderItemInputHandler;
import oracle.bali.ewt.selection.OneDSelection;
import oracle.dss.table.RowHeader;
import oracle.dss.table.Table;
import oracle.dss.table.TableEdgeComponentInfo;
import oracle.dss.table.TableHeader;
import oracle.dss.table.TableHeaderCell;
import oracle.dss.table.TableModel;
import oracle.dss.util.ComponentInfo;

public class TableHeaderInputHandler
implements HeaderItemInputHandler {
    private TableModel _tablemodel = null;
    protected Table m_table = null;
    protected Cursor headerCursor = null;
    private static final String m_method_mousepressed = "mousePressed (MouseEvent e, Header header, int itemIndex)";
    private static final String m_method_mousereleased = "mouseReleased (MouseEvent e, Header header, int itemIndex)";
    private static final String m_method_mousemoved = "mouseMoved (MouseEvent e, Header header, int itemIndex)";

    public TableHeaderInputHandler(Table tbl) {
        this.m_table = tbl;
        this._tablemodel = tbl.getTableModel();
    }

    public void mouseClicked(MouseEvent e, Header header, int itemIndex) {
    }

    public void mousePressed(MouseEvent e, Header header, int itemIndex) {
        if (itemIndex < 0) {
            this.m_table.getErrorHandler().log("invalid item index", this.getClass().getName(), m_method_mousepressed);
            return;
        }
        boolean drillable = false;
        boolean collapsable = false;
        int column = 0;
        int row = 0;
        if (e.isConsumed()) {
            return;
        }
        if (header instanceof RowHeader && this.m_table.getTable() != null && this.m_table.isIncrementalFetchEnabled() && this.m_table.getTable().isIncrementalFetchRowVisible() && itemIndex >= this.m_table.getTableModel().getTableDataSource().getRowCount() - 1) {
            TableHeader tableHeader = (TableHeader)header;
            int layer = tableHeader.getFocusItem();
            int edge = tableHeader.isHorizontal() ? 0 : 1;
            TableEdgeComponentInfo focusCell = new TableEdgeComponentInfo(edge, layer);
            tableHeader.setIncFetchFocusCell((ComponentInfo)focusCell);
            e.consume();
            this.m_table.getTableModel().getTableControllerActions().incrementalFetchGestureHappened(header, this.m_table.getTableModel().getTableDataSource().getRowCount() - 1, this.m_table.getFetchIncrement());
            return;
        }
        boolean left = SwingUtilities.isLeftMouseButton(e);
        if (left) {
            int orientation;
            TableHeaderCell cell = (TableHeaderCell)header.getModel().getData(itemIndex);
            int drillState = cell.getDrillState();
            if (drillState == 1) {
                drillable = true;
            } else if (drillState == 2) {
                collapsable = true;
            }
            if (header.getOrientation() == 0) {
                orientation = 0;
                column = itemIndex;
            } else {
                orientation = 1;
                row = itemIndex;
            }
            if (((TableHeader)header).isDrill(itemIndex, e.getX(), e.getY())) {
                if (drillable || collapsable) {
                    if (!((TableHeader)header).table.isDrillingEnabled() || !((TableHeader)header).table.isEnabled()) {
                        return;
                    }
                    if (drillable) {
                        ((TableHeader)header).table.getTable().fireHeaderCellDrillRequest(orientation, column, row);
                    } else {
                        ((TableHeader)header).table.getTable().fireCollapse(orientation, column, row);
                    }
                    e.consume();
                }
            } else if (((TableHeader)header).isDrillOut(itemIndex, e.getX(), e.getY())) {
                int type = 1;
                int imageIndex = ((TableHeader)header).getStyle(itemIndex).getGraphicImageIndex();
                int edge = header.getOrientation() == 0 ? 0 : 1;
                this.getTableModel().getGridViewControllerActions().headerDrillOutGestureHappened(this.m_table, edge, itemIndex, 0, type, imageIndex);
            }
        }
        if (!left) {
            ((TableHeader)header).setItemPaintState(true, itemIndex);
            ((TableHeader)header).repaint();
            OneDSelection selection = header.getSelection();
            if (!selection.contains(itemIndex)) {
                try {
                    header.deselectAll();
                    OneDSelection sel = new OneDSelection(itemIndex);
                    header.setSelection(sel);
                }
                catch (PropertyVetoException ex) {
                    // empty catch block
                }
            }
        }
    }

    public void mouseDragged(MouseEvent e, Header header, int itemIndex) {
    }

    public void mouseReleased(MouseEvent e, Header header, int itemIndex) {
        if (itemIndex < 0) {
            this.m_table.getErrorHandler().log("invalid item index", this.getClass().getName(), m_method_mousereleased);
            return;
        }
        ((TableHeader)header).setItemPaintState(false, itemIndex);
        ((TableHeader)header).repaint();
    }

    public void mouseEntered(MouseEvent e, Header header, int itemIndex) {
    }

    public void mouseExited(MouseEvent e, Header header, int itemIndex) {
    }

    public void mouseMoved(MouseEvent e, Header header, int itemIndex) {
        Cursor newCursor;
        if (itemIndex < 0) {
            this.m_table.getErrorHandler().log("invalid item index", this.getClass().getName(), m_method_mousemoved);
            return;
        }
        if (e.isConsumed()) {
            return;
        }
        Cursor oldCursor = ((TableHeader)header).getCursor();
        if (oldCursor != (newCursor = ((TableHeader)header).isDrill(itemIndex, e.getX(), e.getY()) || ((TableHeader)header).isDrillOut(itemIndex, e.getX(), e.getY()) ? this.m_table.getGridViewController().getCursorType(13) : this.m_table.getGridViewController().getCursorType(0))) {
            ((TableHeader)header).setCursor(newCursor);
            e.consume();
        }
    }

    public TableModel getTableModel() {
        return this._tablemodel;
    }
}

