/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.table;

import oracle.dss.dataView.EdgeComponentHandle;
import oracle.dss.dataView.managers.ViewStyle;
import oracle.dss.gridView.CSSStyle;
import oracle.dss.gridView.GridViewExcelHTMLExport;
import oracle.dss.table.TableCommon;
import oracle.dss.util.DataAccess;
import oracle.dss.util.DataException;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.LayerOutOfRangeException;
import oracle.dss.util.SliceOutOfRangeException;
import oracle.dss.util.WaitData;

public class TableExcelHTMLExport
extends GridViewExcelHTMLExport {
    protected TableCommon m_table;
    private boolean m_bGroupSortExported = false;

    public TableExcelHTMLExport(TableCommon table) {
        super(table);
        this.m_table = table;
    }

    public void setGroupSortExported(boolean b) {
        this.m_bGroupSortExported = b;
    }

    public boolean isGroupSortExported() {
        return this.m_bGroupSortExported;
    }

    @Override
    protected boolean isDataSuppressed(int col, int row) {
        int groupSortData;
        return this.isGroupSortExported() && ((groupSortData = this.getGroupSortData(col, row)) == 2 || groupSortData == 3);
    }

    @Override
    protected int getColumnHeaderRowCount() {
        return 1;
    }

    @Override
    protected int getRowHeaderColumnCount() {
        return 1;
    }

    @Override
    protected void exportColumnHeaderRow(int row, int startCol, int endCol) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        DataAccess dataAccess = this.m_gridView.getModel().getDataAccess();
        StringBuffer rowSB = new StringBuffer(2048);
        for (int col = startCol; col <= endCol; ++col) {
            String s;
            EdgeComponentHandle handle;
            CSSStyle style;
            ViewStyle initStyle;
            ViewStyle viewStyle;
            rowSB.append("    <td");
            rowSB.append(" class=\"" + this.getStyleClass("bibch") + "\"");
            Object metadata = null;
            String memberLabelType = this.m_gridView.getMemberMetadataLabelType(0);
            if (this.m_gridView.isMemberMetadataLabelTypeSupported(memberLabelType)) {
                metadata = dataAccess.getMemberMetadata(0, col, 0, memberLabelType);
            }
            if ((viewStyle = this.m_headerStyleMgr.getMetadataStyle(this.m_gridView, metadata, initStyle = this.getClearColumnHeaderViewStyle(), 0, col, 0)) != null && viewStyle.isAnythingOverridden() && (style = this.convertViewStyleToCSSStyle(viewStyle, handle = new EdgeComponentHandle(10, "ColumnHeader", this.m_gridView, 0, col, 0))) != null) {
                rowSB.append(" style='" + style.toInlineString() + "'");
            }
            rowSB.append(">");
            if (metadata != null && (s = metadata.toString()) != null) {
                if ((s = this.filterChars(s)).length() > TableExcelHTMLExport.getMaxCellContentLength()) {
                    s = s.substring(0, TableExcelHTMLExport.getMaxCellContentLength());
                    this.m_eh.log("maximum cell content length exceeded - truncating", this.getClass().getName(), "exportColumnHeaderRow");
                }
                rowSB.append(s);
            }
            rowSB.append("</td>\n");
        }
        this.out(rowSB.toString());
    }

    @Override
    protected void exportRowHeaderRow(int row, int startRow, int endRow, int rowHeaderColCount) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        String s;
        EdgeComponentHandle handle;
        CSSStyle style;
        ViewStyle initStyle;
        ViewStyle viewStyle;
        DataAccess dataAccess = this.m_gridView.getModel().getDataAccess();
        StringBuffer rowSB = new StringBuffer(2048);
        rowSB.append("    <td");
        rowSB.append(" class=\"" + this.getStyleClass("bibrh") + "\"");
        Object metadata = null;
        String memberLabelType = this.m_gridView.getMemberMetadataLabelType(1);
        if (this.m_gridView.isMemberMetadataLabelTypeSupported(memberLabelType)) {
            metadata = dataAccess.getMemberMetadata(1, row, 0, memberLabelType);
        }
        if ((viewStyle = this.m_headerStyleMgr.getMetadataStyle(this.m_gridView, metadata, initStyle = this.getClearRowHeaderViewStyle(), 1, row, 0)) != null && viewStyle.isAnythingOverridden() && (style = this.convertViewStyleToCSSStyle(viewStyle, handle = new EdgeComponentHandle(11, "RowHeader", this.m_gridView, 1, row, 0))) != null) {
            rowSB.append(" style='" + style.toInlineString() + "'");
        }
        rowSB.append(">");
        if (metadata != null && (s = metadata.toString()) != null) {
            if ((s = this.filterChars(s)).length() > TableExcelHTMLExport.getMaxCellContentLength()) {
                s = s.substring(0, TableExcelHTMLExport.getMaxCellContentLength());
                this.m_eh.log("maximum cell content length exceeded - truncating", this.getClass().getName(), "exportRowHeaderRow");
            }
            rowSB.append(s);
        }
        rowSB.append("</td>\n");
        this.out(rowSB.toString());
    }

    protected int getGroupSortData(int column, int row) {
        Object groupSort = null;
        if (this.m_table.isDataGroupsortSupported()) {
            try {
                groupSort = this.m_gridView.getModel().getDataAccess().getValue(row, column, "dataGroupSort");
            }
            catch (DataException e) {
                this.m_eh.log("could not get DataMap.DATA_GROUPSORT data", this.getClass().getName(), "getGroupSortData");
                return 0;
            }
        } else {
            return 0;
        }
        if (groupSort == null) {
            this.m_eh.log("DataMap.DATA_GROUPSORT value null", this.getClass().getName(), "getGroupSortData");
            return 0;
        }
        if (groupSort instanceof WaitData) {
            return 0;
        }
        if (!(groupSort instanceof Integer)) {
            this.m_eh.log("non-Integer DataMap.DATA_GROUPSORT value", this.getClass().getName(), "getGroupSortData");
            return 0;
        }
        int groupSortVal = (Integer)groupSort;
        if (groupSortVal < 0 || groupSortVal > 3) {
            this.m_eh.log("DataMap.DATA_GROUPSORT value out of range", this.getClass().getName(), "getGroupSortData");
            return 0;
        }
        return groupSortVal;
    }
}

