/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.table;

import java.io.Serializable;
import java.util.Hashtable;
import oracle.bali.ewt.grid.bigCell.BigCellTwoDModel;
import oracle.dss.dataView.DataComponentHandle;
import oracle.dss.gridView.GridViewData;
import oracle.dss.table.Table;
import oracle.dss.table.TableModel;
import oracle.dss.util.DataAccess;
import oracle.dss.util.DataComponentInfo;
import oracle.dss.util.DataException;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.WaitData;

public class TableData
extends BigCellTwoDModel
implements GridViewData,
Serializable {
    private static final long serialVersionUID = 1L;
    protected DataAccess dataAccess = null;
    private TableModel tableModel;
    protected transient Hashtable valueCache = null;
    protected transient Hashtable m_annotationsCache = null;
    protected transient DataComponentInfo info = new DataComponentInfo(0, 0);
    protected Table table = null;
    private static final String m_method_setdata = "setData(int columnIndex, int rowIndex, Object data)";
    private static final String m_method_getdata = "getData(int columnIndex, int rowIndex)";
    private static final String m_method_getrawdata = "getRawData(int columnIndex, int rowIndex)";
    private static final String m_method_getAnnotation = "getAnnotation(int column, int row)";

    public TableData(TableModel tm, Table t) throws EdgeOutOfRangeException {
        super(tm.getTableFromDataColumnCount(tm.getDataAccess().getEdgeExtent(0)), tm.getTableFromDataRowCount(tm.getDataAccess().getEdgeExtent(1)));
        this.valueCache = new Hashtable();
        this.m_annotationsCache = new Hashtable();
        this.table = t;
        this.tableModel = tm;
        this.dataAccess = this.tableModel.getDataAccess();
    }

    public int getColumnCount() {
        try {
            return this.tableModel.getTableFromDataColumnCount(this.dataAccess.getEdgeExtent(0));
        }
        catch (EdgeOutOfRangeException e) {
            return 0;
        }
    }

    public int getRowCount() {
        try {
            int rowCount = this.tableModel.getTableFromDataRowCount(this.dataAccess.getEdgeExtent(1));
            if (this.table != null && this.table.getTable() != null && this.table.isIncrementalFetchEnabled() && this.table.getTable().isIncrementalFetchRowVisible()) {
                ++rowCount;
            }
            return rowCount;
        }
        catch (EdgeOutOfRangeException e) {
            return 0;
        }
    }

    public Object getData(int columnIndex, int rowIndex) {
        if (columnIndex < 0) {
            this.table.getErrorHandler().log("invalid column index", this.getClass().getName(), m_method_getdata);
            return null;
        }
        if (rowIndex < 0) {
            this.table.getErrorHandler().log("invalid row index", this.getClass().getName(), m_method_getdata);
            return null;
        }
        try {
            Object object;
            int col = this.tableModel.getDataFromTableCol(columnIndex);
            int row = this.tableModel.getDataFromTableRow(rowIndex);
            this.info.setRowCol(row, col);
            if (this.table.isIncrementalFetchEnabled() && (this.table.getTable().isIncrementalFetchRowVisible() && row >= this.getRowCount() - 1 || !this.table.getTable().isIncrementalFetchRowVisible() && row >= this.getRowCount())) {
                return super.getData(columnIndex, rowIndex);
            }
            int groupSortData = this.getGroupSortData(col, row);
            Object dataValue = null;
            if (this.table.isPrintOrPreviewMode() && this.table.getFirstPrintedRow() == rowIndex && (groupSortData == 2 || groupSortData == 3)) {
                this.table.getTable().m_calculatedRowHeights[rowIndex] = -1;
                if (this.table.isDataFormattedSupported() && (dataValue = this.table.getValueFromDataAccess(col, row, "dataFormattedValue", this.dataAccess)) != null) {
                    return dataValue.toString();
                }
                if (this.table.isDataUnformattedSupported()) {
                    dataValue = this.table.getValueFromDataAccess(col, row, "dataValue", this.dataAccess);
                }
                if (dataValue == null) {
                    dataValue = new String("");
                }
                Object object2 = this.tableModel.getGridViewFormatManager().formatDataValue(this.table, dataValue, col, row, this.dataAccess.getEdgeCurrentHPos(2), this.tableModel.getViewFormat());
                String prevVal = null;
                prevVal = object2 != null ? object2.toString() : "";
                return prevVal;
            }
            String prevVal = null;
            prevVal = (String)this.valueCache.get(this.info);
            if (prevVal != null) {
                return prevVal;
            }
            WaitData waitData = null;
            if (this.table.getWaitDataForRow(row) != null) {
                waitData = this.table.getWaitDataForRow(row);
                return waitData.getCellMessage();
            }
            boolean bFormatted = false;
            if (this.table.isDataFormattedSupported() && (dataValue = this.dataAccess.getValue(row, col, "dataFormattedValue")) != null) {
                bFormatted = true;
            }
            if (!bFormatted && this.table.isDataUnformattedSupported()) {
                dataValue = this.dataAccess.getValue(row, col, "dataValue");
            }
            if (dataValue instanceof WaitData) {
                waitData = (WaitData)dataValue;
                this.table.setWaitDataForRow(row, waitData);
                return waitData.getCellMessage();
            }
            if (groupSortData == 2 || groupSortData == 3) {
                dataValue = null;
            }
            if (dataValue == null) {
                dataValue = new String("");
            }
            prevVal = bFormatted ? dataValue.toString() : ((object = this.tableModel.getGridViewFormatManager().formatDataValue(this.table, dataValue, col, row, this.dataAccess.getEdgeCurrentHPos(2), this.tableModel.getViewFormat())) != null ? object.toString() : "");
            this.valueCache.put(this.info.clone(), prevVal);
            return prevVal;
        }
        catch (DataException e) {
            this.tableModel.getErrorHandler().error((Throwable)e, this.getClass().getName(), "getData");
            return null;
        }
    }

    @Override
    public Object getRawData(int columnIndex, int rowIndex) {
        if (columnIndex < 0) {
            this.table.getErrorHandler().log("invalid column index", this.getClass().getName(), m_method_getrawdata);
            return null;
        }
        if (rowIndex < 0) {
            this.table.getErrorHandler().log("invalid row index", this.getClass().getName(), m_method_getrawdata);
            return null;
        }
        try {
            int col = this.tableModel.getDataFromTableCol(columnIndex);
            int row = this.tableModel.getDataFromTableRow(rowIndex);
            if (this.table.isIncrementalFetchEnabled() && this.table.getTable().isIncrementalFetchRowVisible() && row >= this.getRowCount() - 1) {
                return super.getRealData(columnIndex, rowIndex);
            }
            Object dataValue = null;
            WaitData waitData = null;
            if (this.table.getWaitDataForRow(rowIndex) != null) {
                waitData = this.table.getWaitDataForRow(rowIndex);
                return waitData;
            }
            if (this.table.isDataUnformattedSupported() && (dataValue = this.table.getValueFromDataAccess(col, row, "dataValue", this.dataAccess)) instanceof WaitData) {
                waitData = (WaitData)dataValue;
                this.table.setWaitDataForRow(rowIndex, waitData);
                return waitData;
            }
            if (dataValue == null) {
                dataValue = "";
            }
            return dataValue;
        }
        catch (DataException e) {
            this.tableModel.getErrorHandler().error((Throwable)e, this.getClass().getName(), "getRawData");
            return null;
        }
    }

    public void setData(int columnIndex, int rowIndex, Object data) {
        if (columnIndex < 0) {
            this.table.getErrorHandler().log("invalid column index", this.getClass().getName(), m_method_setdata);
            return;
        }
        if (rowIndex < 0) {
            this.table.getErrorHandler().log("invalid row index", this.getClass().getName(), m_method_setdata);
            return;
        }
        try {
            this.clearCache();
            this.tableModel.getGridViewFormatManager().valueFormatChanged();
            this.tableModel.getGridViewDatabodyStyleManager().dataStyleChanged();
            this.dataAccess.setValue(data, this.tableModel.getDataFromTableRow(rowIndex), this.tableModel.getDataFromTableCol(columnIndex), "dataValue");
        }
        catch (DataException e) {
            this.tableModel.getErrorHandler().error((Throwable)e, this.getClass().getName(), "setData");
        }
    }

    @Override
    public void clearCache() {
        if (this.valueCache != null) {
            this.valueCache.clear();
        }
        if (this.m_annotationsCache != null) {
            this.m_annotationsCache.clear();
        }
    }

    @Override
    public Object getAnnotation(int column, int row) {
        if (column < 0) {
            this.table.getErrorHandler().log("invalid column index", this.getClass().getName(), m_method_getAnnotation);
            return null;
        }
        if (row < 0) {
            this.table.getErrorHandler().log("invalid row index", this.getClass().getName(), m_method_getAnnotation);
            return null;
        }
        try {
            int iCol = this.tableModel.getDataFromTableCol(column);
            int iRow = this.tableModel.getDataFromTableRow(row);
            this.info.setRowCol(iRow, iCol);
            if (this.table.isIncrementalFetchEnabled() && (this.table.getTable().isIncrementalFetchRowVisible() && iRow >= this.getRowCount() - 1 || !this.table.getTable().isIncrementalFetchRowVisible() && iRow >= this.getRowCount())) {
                return null;
            }
            int groupSortData = this.getGroupSortData(iCol, iRow);
            Object dataValue = null;
            if (this.table.isPrintOrPreviewMode()) {
                return null;
            }
            String[] prevVal = null;
            prevVal = (String[])this.m_annotationsCache.get(this.info);
            if (prevVal != null) {
                return prevVal;
            }
            WaitData waitData = null;
            if (this.table.getWaitDataForRow(iRow) != null) {
                return null;
            }
            if (this.table.isDataAnnotationSupported()) {
                dataValue = this.dataAccess.getValue(iRow, iCol, "dataAnnotation");
            }
            if (dataValue instanceof WaitData) {
                waitData = (WaitData)dataValue;
                this.table.setWaitDataForRow(iRow, waitData);
                return null;
            }
            if (groupSortData == 2 || groupSortData == 3) {
                dataValue = null;
            }
            if (dataValue != null && this.table.getCustomAnnotationCallback() != null) {
                DataComponentHandle componentHandle = new DataComponentHandle(12, this.table.getNameFromID(12), (Object)this.table, row, column);
                dataValue = this.table.getCustomAnnotationCallback().getAnnotation(dataValue, componentHandle);
            }
            if (dataValue != null) {
                if (dataValue instanceof String[]) {
                    boolean bNonNull = false;
                    prevVal = (String[])dataValue;
                    for (int i = 0; i < prevVal.length; ++i) {
                        if (prevVal[i] == null) continue;
                        bNonNull = true;
                        break;
                    }
                    if (!bNonNull) {
                        prevVal = null;
                        this.tableModel.getErrorHandler().log("all lines in annotation null", this.getClass().getName(), m_method_getAnnotation);
                    }
                } else {
                    if (!(dataValue instanceof String)) {
                        this.tableModel.getErrorHandler().log("annotation not String or String[]", this.getClass().getName(), m_method_getAnnotation);
                    }
                    prevVal = new String[]{dataValue.toString()};
                }
            }
            if (prevVal != null) {
                this.m_annotationsCache.put(this.info.clone(), prevVal);
            }
            return prevVal;
        }
        catch (DataException e) {
            this.tableModel.getErrorHandler().log("could not get annotation from data source", this.getClass().getName(), m_method_getAnnotation);
            return null;
        }
    }

    protected int getGroupSortData(int column, int row) {
        Object groupSort = null;
        if (this.table.getWaitDataForRow(row) != null) {
            return 0;
        }
        if (this.table.isDataGroupsortSupported()) {
            try {
                groupSort = this.table.getValueFromDataAccess(column, row, "dataGroupSort", this.dataAccess);
            }
            catch (DataException e) {
                this.table.getErrorHandler().error((Throwable)e, this.getClass().getName(), "getGroupSortData");
                return 0;
            }
        } else {
            return 0;
        }
        if (groupSort == null) {
            this.table.getErrorHandler().log("DataMap.DATA_GROUPSORT value null", this.getClass().getName(), "getGroupSortData");
            return 0;
        }
        if (groupSort instanceof WaitData) {
            this.table.setWaitDataForRow(row, (WaitData)groupSort);
            return 0;
        }
        if (!(groupSort instanceof Integer)) {
            this.table.getErrorHandler().log("non-Integer DataMap.DATA_GROUPSORT value", this.getClass().getName(), "getGroupSortData");
            return 0;
        }
        int groupSortVal = (Integer)groupSort;
        if (groupSortVal < 0 || groupSortVal > 3) {
            this.table.getErrorHandler().log("DataMap.DATA_GROUPSORT value out of range", this.getClass().getName(), "getGroupSortData");
            return 0;
        }
        return groupSortVal;
    }

    protected void clearAnnotationCache() {
        if (this.m_annotationsCache != null) {
            this.m_annotationsCache.clear();
        }
    }

    void invalidateData() {
        this.fireModelEvent(2007, 0, this.getColumnCount(), 0, this.getRowCount());
    }

    void invalidateRows() {
        this.fireModelEvent(2006, 0, this.getRowCount());
    }

    void invalidateColumns() {
        this.fireModelEvent(2003, 0, this.getColumnCount());
    }
}

