/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.table;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.io.Serializable;
import oracle.bali.ewt.painter.ImagePainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.painter.TextPainter;
import oracle.bali.ewt.util.ImmInsets;
import oracle.dss.dataView.BaseTitle;
import oracle.dss.dataView.managers.ViewStyle;
import oracle.dss.gridView.GridViewWrappingTextPainter;
import oracle.dss.table.TableHeader;
import oracle.dss.table.TableHeaderCell;
import oracle.dss.table.TableUtils;

public class HeaderPainter
extends GridViewWrappingTextPainter
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected TableHeader header = null;
    protected Painter painter = null;
    private ImmInsets insets;
    private TruncTextPainter truncPainter;
    private GraphicImagePainter imagePainter;

    public HeaderPainter(TableHeader h) {
        this.header = h;
        this.insets = new ImmInsets(0, 1, 0, 1);
        this.truncPainter = new TruncTextPainter();
        this.imagePainter = new GraphicImagePainter();
    }

    public Dimension getMinimumSize(PaintContext context) {
        if (this._shouldWrap(this._convertContextToStyle(context))) {
            return super.getMinimumSize(context);
        }
        return this.truncPainter.getMinimumSize(context);
    }

    @Override
    public void paint(PaintContext context, Graphics g, int x, int y, int width, int height) {
        Image gim;
        int drillImageOffsetWidth;
        Object o = context.getPaintData((Object)"Cell");
        TableHeaderCell cell = (TableHeaderCell)o;
        int index = cell.getIndex();
        ViewStyle style = this.header.getStyle(index);
        int topInset = style.getInsets().top;
        Font f = style.getFont();
        int fontSize = 0;
        if (f == null) {
            f = this.header.getFont();
        }
        if (f != null) {
            fontSize = this.header.getFontMetrics(f).getHeight();
        }
        int temp = height;
        if (height < fontSize) {
            temp = fontSize;
        }
        boolean l2r = true;
        Image im = this.header.getDrillImage(index);
        if (this.header.table.getZoomFactor() < 60) {
            y -= topInset;
        }
        if (this.header.isDrilledOrDrillable(index) && im != null && !this.header.table.isPrintOrPreviewMode()) {
            this.imagePainter.setImage(im);
            Dimension d = this.imagePainter.getPreferredSize(context);
            int savedY = y;
            float align = context.getInteriorAlignmentY();
            y = (int)((float)y + (float)(temp - fontSize) * align + (float)((fontSize - d.height) / 2));
            if (l2r) {
                this.imagePainter.paint(context, g, x, y, d.width, height);
                x += d.width;
                width -= d.width;
            } else {
                this.imagePainter.paint(context, g, x + width - d.width, y, d.width, height);
                width -= d.width;
            }
            y = savedY;
        }
        x += this.insets.left;
        y += this.insets.top;
        width -= this.insets.left + this.insets.right;
        height -= this.insets.top + this.insets.bottom;
        Image blankImage = this.header.getScaledBlankImage();
        if (this.header.isDrilledOrDrillable(index) && blankImage != null && im != null && !this.header.table.isPrintOrPreviewMode() && (drillImageOffsetWidth = blankImage.getWidth(null) - im.getWidth(null)) > 0) {
            if (l2r) {
                x += drillImageOffsetWidth;
                width -= drillImageOffsetWidth;
            } else {
                width -= drillImageOffsetWidth;
            }
        }
        if ((gim = this.header.getGraphicImage(index)) != null && !this.header.table.isPrintOrPreviewMode()) {
            this.imagePainter.setImage(gim);
            Dimension d = this.imagePainter.getPreferredSize(context);
            int savedY = y;
            float align = context.getInteriorAlignmentY();
            y = (int)((float)y + (float)(temp - fontSize) * align + (float)((fontSize - d.height) / 2));
            if (l2r) {
                this.imagePainter.paint(context, g, x, y, d.width, height);
                x += d.width;
                width -= d.width;
            } else {
                this.imagePainter.paint(context, g, x + width - d.width, y, d.width, height);
                width -= d.width;
            }
            y = savedY;
            x += this.insets.right;
            width -= this.insets.right;
        }
        if (this._shouldWrap(style)) {
            super.paint(context, g, x, y, width, height);
        } else {
            this.truncPainter.paint(context, g, x, y, width, height);
        }
    }

    protected String getStringData(PaintContext context) {
        Object o = context.getPaintData(this.getDataKey());
        TableHeaderCell headerCell = (TableHeaderCell)o;
        return (String)headerCell.getData();
    }

    protected void drawEnhancedFont(ViewStyle style, PaintContext context, Graphics g, FontMetrics metrics, String text, int x, int y, int availableWidth, float alignmentX) {
        boolean underline = false;
        boolean doubleunderline = false;
        boolean strikethrough = false;
        if (style != null) {
            underline = style.isUnderline();
            doubleunderline = style.isDoubleUnderline();
            strikethrough = style.isStrikeThrough();
        }
        if (underline || doubleunderline || strikethrough) {
            int stringWidth;
            Object o = context.getPaintData((Object)"Cell");
            TableHeaderCell cell = (TableHeaderCell)o;
            int index = cell.getIndex();
            String newString = TableUtils.leftTrim(text);
            int bump = (text.length() - newString.length()) * metrics.stringWidth(" ");
            if (alignmentX != 0.0f && (stringWidth = metrics.stringWidth(text)) < availableWidth) {
                x = (int)((float)x + (float)(availableWidth - stringWidth) * alignmentX);
            }
            BaseTitle.drawEnhancedAdornments(metrics, g, x + bump, y, metrics.stringWidth(newString), underline, doubleunderline, strikethrough);
        }
    }

    protected int paintText(PaintContext context, Graphics g, FontMetrics metrics, String text, int x, int y, int availableWidth, float alignmentX, int mnemonicIndex) {
        ViewStyle style = this._convertContextToStyle(context);
        int retVal = this._shouldWrap(style) ? super.paintText(context, g, metrics, text, x, y, availableWidth, alignmentX, mnemonicIndex) : this.truncPainter.paintText(context, g, metrics, text, x, y, availableWidth, alignmentX, mnemonicIndex);
        if (text.trim().length() == 0) {
            return retVal;
        }
        this.drawEnhancedFont(style, context, g, metrics, text, x, y, availableWidth, alignmentX);
        return retVal;
    }

    ViewStyle _convertContextToStyle(PaintContext context) {
        if (context != null) {
            Object o = context.getPaintData((Object)"Cell");
            TableHeaderCell cell = (TableHeaderCell)o;
            int index = cell.getIndex();
            return this.header.getStyle(index);
        }
        return null;
    }

    private boolean _shouldWrap(ViewStyle style) {
        return style == null ? this.header.getViewStyle().isWordWrapEnabled() : style.isWordWrapEnabled();
    }

    private class GraphicImagePainter
    extends ImagePainter {
        private Image image;

        public GraphicImagePainter() {
            super(0);
        }

        public void setImage(Image ig) {
            this.image = ig;
        }

        protected Image getImageData(PaintContext context) {
            return this.image;
        }
    }

    private class TruncTextPainter
    extends TextPainter {
        protected int paintText(PaintContext context, Graphics g, FontMetrics metrics, String text, int x, int y, int availableWidth, float alignmentX, int mnemonicIndex) {
            ViewStyle style = HeaderPainter.this._convertContextToStyle(context);
            int retVal = super.paintText(context, g, metrics, text, x, y, availableWidth, alignmentX, mnemonicIndex);
            HeaderPainter.this.drawEnhancedFont(style, context, g, metrics, text, x, y, availableWidth, alignmentX);
            return retVal;
        }

        protected String getStringData(PaintContext context) {
            Object o = context.getPaintData(this.getDataKey());
            TableHeaderCell headerCell = (TableHeaderCell)o;
            return (String)headerCell.getData();
        }
    }
}

