/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.table;

import java.io.Serializable;
import oracle.bali.ewt.model.ArrayOneDModel;
import oracle.dss.table.ColHeaderCell;
import oracle.dss.table.RowHeaderCell;
import oracle.dss.table.Table;
import oracle.dss.table.TableModel;
import oracle.dss.util.DataAccess;

abstract class HeaderData
extends ArrayOneDModel
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected DataAccess dataAccess = null;
    protected TableModel model = null;
    private boolean calculating = false;
    protected Table table = null;
    private static final String m_method_getdata = "getData(int index)";

    HeaderData(Table t) {
        super(0);
        this.table = t;
        this.model = t.getTableModel();
        this.dataAccess = this.model.getDataAccess();
    }

    public void setData(int index, Object data) {
    }

    protected abstract boolean isRowHeader();

    public Object getData(int index) {
        if (index < 0) {
            this.table.getErrorHandler().log("invalid column index", this.getClass().getName(), m_method_getdata);
            return null;
        }
        Object data = super.getData(index);
        if (this.isCalculating()) {
            return data;
        }
        return data != null ? data : this.calculateCell(index);
    }

    void invalidateHeader() {
        this.fireModelEvent(2003, 0, this.getItemCount());
    }

    protected abstract Object calculateCell(int var1);

    protected Object calculateCell(int column, int row) {
        this.setCalculating(true);
        if (this.isRowHeader()) {
            Object c = this._setCellSize(row);
            this.setCalculating(false);
            return c;
        }
        Object c = this._setCellSize(column);
        this.setCalculating(false);
        return c;
    }

    private Object _setCellSize(int depth) {
        if (!this.isRowHeader()) {
            ColHeaderCell c = new ColHeaderCell(this.table, depth);
            return c;
        }
        RowHeaderCell c = new RowHeaderCell(this.table, depth);
        return c;
    }

    protected void setCalculating(boolean calc) {
        this.calculating = calc;
    }

    protected boolean isCalculating() {
        return this.calculating;
    }
}

