/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.table;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyVetoException;
import javax.swing.JComponent;
import oracle.bali.ewt.dnd.DropTargetDragEvent;
import oracle.bali.ewt.elaf.EWTPivotHeaderUI;
import oracle.bali.ewt.graphics.Appearance;
import oracle.bali.ewt.model.OneDModel;
import oracle.bali.ewt.pivot.PivotHeader;
import oracle.bali.ewt.util.ImmInsets;
import oracle.dss.dataView.managers.ViewStyle;
import oracle.dss.table.AutoScroller;
import oracle.dss.table.ColHeaderData;
import oracle.dss.table.ColHeaderDragDropAdapter;
import oracle.dss.table.Table;
import oracle.dss.table.TableHeader;

public class ColHeader
extends TableHeader {
    private static final long serialVersionUID = 1L;
    int _dropIndex = -1;
    int _dragIndex = -1;
    boolean _swapping;
    int _swapItem = -1;
    private int m_lastSwapDropIndex = -1;
    private static final int _PIVOT_FEEDBACK_SIZE = 5;
    private static final int _PIVOT_SIZE = 10;
    private static final String m_method_paintoverchildren = "paintOverChildren (Graphics g)";

    public ColHeader(ColHeaderData model) {
        super((OneDModel)model, 0);
        this.setCanMoveItems(false);
    }

    @Override
    public void init(Table t) {
        super.init(t);
        ColHeaderDragDropAdapter dummy = new ColHeaderDragDropAdapter(t, this);
    }

    @Override
    public int getID() {
        return 10;
    }

    @Override
    public String getComponentName() {
        return "ColumnHeader";
    }

    @Override
    ViewStyle getStyle(int index) {
        this.info.setRowCol(0, index);
        ViewStyle style = super.getStyle(index);
        if (this._swapItem == -1) {
            return style;
        }
        if (this._swapItem == index) {
            ViewStyle newApp = (ViewStyle)style.copy();
            PivotHeader _pivotHeader = new PivotHeader();
            EWTPivotHeaderUI ui = _pivotHeader.getPivotHeaderUI();
            Color color = ui.getSwapForegroundColor((JComponent)_pivotHeader, (Appearance)style);
            newApp.setForeground(color);
            newApp.setSelectForeground(color);
            color = ui.getSwapBackgroundColor((JComponent)_pivotHeader, (Appearance)style);
            newApp.setBackground(color);
            newApp.setSelectBackground(color);
            style = newApp;
        }
        return style;
    }

    @Override
    protected int getEdge() {
        return 0;
    }

    @Override
    protected int getDepth(int column, int row) {
        return column;
    }

    @Override
    protected int getIndex(int column, int row) {
        return row;
    }

    protected boolean isSwap(Point p) {
        if (this.table.getTable() == null || !this.table.getTable().isSwapAllowed()) {
            return false;
        }
        int index = -1;
        index = this.getItemAt(p.x, p.y);
        if (index == -1) {
            return false;
        }
        if (this.getCanPivot(index) == 0) {
            return false;
        }
        int position = this.getItemPosition(index);
        int size = this.getItemSize(index);
        if (p.x < position + 10) {
            return false;
        }
        return p.x <= position + size - 10;
    }

    protected void paintOverChildren(Graphics g) {
        if (g == null) {
            this.table.getErrorHandler().log("invalid Graphics object", this.getClass().toString(), m_method_paintoverchildren);
            return;
        }
        if (this._swapping && this._swapItem != -1) {
            return;
        }
        if (this._dropIndex < 0) {
            return;
        }
        ImmInsets insets = this.getBorderInsets();
        Rectangle rect = new Rectangle(insets.left, insets.top, this.getWidth() - (insets.left + insets.right), this.getHeight() - (insets.top + insets.bottom));
        Dimension bounds = this.getCanvasSize();
        boolean l2r = this.getActualReadingDirection() == 1;
        Color oldColor = g.getColor();
        g.setColor(Color.black);
        int count = this.getItemCount();
        int position = this._dropIndex < count ? this.getItemPosition(this._dropIndex) : (this._dropIndex == count && count != 0 ? this.getItemPosition(this._dropIndex - 1) + this.getItemSize(this._dropIndex - 1) : 0);
        int x = l2r ? position - 2 : (count != 0 ? (this._dropIndex == count ? this.getItemPosition(this._dropIndex - 1) - 2 : this.getItemSize(this._dropIndex) + this.getItemPosition(this._dropIndex) - 2) : 0);
        if (x < rect.x) {
            x = rect.x;
        }
        if (x + 5 > rect.width) {
            x = rect.width - 5;
        }
        if (bounds.height < rect.height && count != 0) {
            rect.height = bounds.height;
        }
        g.fillRect(x, rect.y, 5, rect.height);
        if (oldColor != null) {
            g.setColor(oldColor);
        }
    }

    protected int getCanPivot(int index) {
        int iCanPivot = 1;
        if (this.getModel() instanceof ColHeaderData) {
            iCanPivot = ((ColHeaderData)this.getModel()).getCanPivot(index);
        }
        return iCanPivot;
    }

    void clearLastSwapDropIndex() {
        this.m_lastSwapDropIndex = -1;
    }

    void setDropLocation(int index, boolean isSwap) {
        if (this._dropIndex != index || this._swapping != isSwap) {
            int swapIndex = !isSwap ? -1 : (index == -1 ? -1 : (index == this._dragIndex ? -1 : index));
            this.setSwapItem(swapIndex);
            this._swapping = isSwap;
            if (this.m_lastSwapDropIndex != -1) {
                this.clearAppliedStyleFlag(this.m_lastSwapDropIndex);
            }
            if (index == -1 || this._dragIndex == -1 || this._swapping && this._dragIndex != index) {
                if (this._swapping) {
                    if (index != -1) {
                        this.clearAppliedStyleFlag(index);
                    }
                    this.m_lastSwapDropIndex = index;
                }
                this._dropIndex = index;
                this.repaintFeedback();
            } else {
                if (this._dragIndex != -1 && (this._dragIndex == index || this._dragIndex == index - 1)) {
                    index = -1;
                }
                this._dropIndex = index;
                this.repaintFeedback();
            }
        }
    }

    void setSwapItem(int item) {
        this._swapItem = item;
    }

    void setDragItem(int item, boolean deselectAll) {
        try {
            if (this._dragIndex != -1 && deselectAll) {
                this.deselectAll();
            }
            this._dragIndex = item;
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.repaintFeedback();
    }

    Image getDragImage(int index) {
        Dimension d = this.getSize();
        Image image = this.createImage(this.getItemSize(index), d.height);
        if (image != null) {
            Graphics g = image.getGraphics();
            int xOffset = this.getItemPosition(index);
            g.translate(-xOffset, 0);
            this.paint(g);
        }
        return image;
    }

    private void repaintFeedback() {
        this.paintImmediateInterior();
    }

    @Override
    public int getColumnCount() {
        return this.getItemCount();
    }

    @Override
    public int getRowCount() {
        return 1;
    }

    public void removeNotify() {
        AutoScroller.getAutoScroller().cancel(this);
        super.removeNotify();
    }

    protected void cancelScroller() {
        AutoScroller.getAutoScroller().cancel();
    }

    protected void checkScroller(DropTargetDragEvent e) {
        this._checkScroller(AutoScroller.getAutoScroller(), e);
    }

    private void _checkScroller(AutoScroller autoScroller, DropTargetDragEvent e) {
        Point location = e.getLocation();
        int pointToCheck = location.x + this.getCanvasOriginX();
        int max = this.getInnerSize().width;
        if (this.getItemCount() == 0) {
            return;
        }
        int averageItemSize = this.getGeometryManager().getTotalSize() / this.getItemCount();
        if (pointToCheck < (averageItemSize /= 2)) {
            autoScroller.schedule(this, true);
        } else if (pointToCheck > max - averageItemSize) {
            autoScroller.schedule(this, false);
        } else {
            autoScroller.cancel();
        }
    }
}

