/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.pagingControl;

import oracle.bali.ewt.model.OneDModel;
import oracle.bali.ewt.model.OneDModelListener;
import oracle.dss.dataView.Model;
import oracle.dss.pagingControl.PagingControl;
import oracle.dss.util.DataException;

public class PageItemModel
implements OneDModel {
    protected int[] m_depthIndex;
    protected int m_depth;
    protected Model m_model;
    protected PagingControl m_pagingControl;
    private int _itemCount = 0;
    private Object[] _members;
    private boolean[] _membersCached;
    private static String _method_PageItemModel = "public PageItemModel(PagingControl pc, int[] depthIndex, int depth)";

    public PageItemModel(PagingControl pc, int[] depthIndex, int depth) {
        this.m_pagingControl = pc;
        this.m_model = pc.getModel();
        this.m_depthIndex = depthIndex;
        this.m_depth = depth;
        if (this.m_depthIndex[this.m_depth] != -1) {
            try {
                this._itemCount = this.m_model.getDataAccess().getMemberSiblingCount(2, this.m_depthIndex, this.m_depth);
            }
            catch (DataException e) {
                this.m_model.getErrorHandler().log("could not get MemberSiblingCount for page layer " + this.m_depth, this.getClass().getName(), _method_PageItemModel);
            }
        }
        if (this._itemCount < 0) {
            this._itemCount = 0;
        }
        this._members = new Object[this._itemCount];
        this._membersCached = new boolean[this._itemCount];
        for (int i = 0; i < this._itemCount; ++i) {
            this._members[i] = null;
            this._membersCached[i] = false;
        }
    }

    public int getItemCount() {
        return this._itemCount;
    }

    public Object getData(int index) {
        Object obj = null;
        if (this.m_depthIndex[this.m_depth] != -1 && this._membersCached != null && this._membersCached.length > 0) {
            if (index >= 0 && index < this._membersCached.length && this._membersCached[index]) {
                obj = this._members[index];
            } else {
                try {
                    String memberLabelType = this.m_pagingControl.getMemberMetadataLabelType(2);
                    if (this.m_pagingControl.isMemberMetadataLabelTypeSupported(memberLabelType)) {
                        obj = this.m_model.getDataAccess().getMemberMetadata(2, this.m_depthIndex, this.m_depth, index, memberLabelType);
                    }
                }
                catch (DataException e) {
                    this.m_model.getErrorHandler().error((Throwable)e, this.getClass().getName(), "getData");
                }
                if (index >= 0 && index < this._membersCached.length) {
                    this._members[index] = obj;
                    this._membersCached[index] = true;
                }
            }
        }
        return obj;
    }

    public void setData(int index, Object data) {
    }

    public void addModelListener(OneDModelListener listener) {
    }

    public void removeModelListener(OneDModelListener listener) {
    }
}

