/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.legend;

import java.util.ArrayList;
import java.util.List;
import oracle.dss.legend.LegendItem;
import oracle.dss.legend.LegendOrientation;
import oracle.dss.legend.LegendPosition;
import oracle.dss.legend.LegendScrolling;
import oracle.dss.legend.impl.LegendText;

public abstract class LegendSection
extends LegendItem {
    protected LegendText m_title;
    protected List<LegendItem> m_items = new ArrayList<LegendItem>();
    protected int m_maxItems;
    protected LegendOrientation m_orientation;
    protected LegendScrolling m_scrolling = LegendScrolling.NONE;
    protected LegendPosition m_align;
    public static int ITEM_GAP = 2;
    public static int DBL_ITEM_GAP = 2 * ITEM_GAP;
    public static int SECTION_GAP = 4;
    public static int DBL_SECTION_GAP = SECTION_GAP * 2;
    public static int DIFF_GAP = SECTION_GAP - ITEM_GAP;
    protected int m_itemGap = ITEM_GAP;
    protected int m_sectionGap = SECTION_GAP;

    public void setLayoutOrientation(LegendOrientation layout) {
        this.m_orientation = layout;
    }

    public void setScrolling(LegendScrolling scrolling) {
        this.m_scrolling = scrolling;
    }

    public void setItemsAlignment(LegendPosition align) {
        this.m_align = align;
    }

    public void setMaxItems(int maxItems) {
        this.m_maxItems = maxItems;
    }

    public void setTitle(LegendText title) {
        this.m_title = title;
    }

    public void addItem(LegendItem item) {
        this.m_items.add(item);
    }

    public LegendItem getItem(int index) {
        if (index > -1 && index < this.m_items.size()) {
            return this.m_items.get(index);
        }
        return null;
    }
}

