/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.gridView.managers;

import oracle.dss.dataView.managers.ViewSizing;
import oracle.dss.gridView.GridViewCommon;
import oracle.dss.gridView.GridViewDefaultValues;
import oracle.dss.gridView.GridViewSizingManager;
import oracle.dss.rules.RuleBundle;
import oracle.dss.util.ColumnComponentInfo;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.RowComponentInfo;

public abstract class GridViewRuleSizing
implements GridViewSizingManager,
Cloneable {
    protected static final int NO_CACHED_SIZE = -2;
    protected transient GridViewCommon m_gridView = null;
    protected transient RowComponentInfo rci = null;
    protected transient ColumnComponentInfo cci = null;
    protected ViewSizing m_defaultDatabodySizes;
    protected ViewSizing m_defaultHeaderSizes;
    protected transient int[] m_calculatedRowHeights = null;
    protected transient int[] m_calculatedColumnWidths = null;
    protected RuleBundle m_preferredRowHeights = null;
    protected RuleBundle m_preferredColumnWidths = null;
    protected transient int[] m_preferredColumnWidthsCache = null;
    protected transient int[] m_preferredRowHeightsCache = null;
    protected static final String a_defaultColumnWidth = "defColW";
    protected static final String a_defaultRowHeight = "defRowH";
    protected static final String a_defaultColumnHeaderRowHeight = "defColHdrRowH";
    protected static final String a_defaultRowHeaderColumnWidth = "defRowHdrColW";
    protected static final String a_columnWidth = "columnWidth";
    protected static final String a_columnWidthUsed = "columnWidthUsed";
    protected static final String a_rowHeight = "rowHeight";
    protected static final String a_rowHeightUsed = "rowHeightUsed";
    protected static final String COLUMN_BUNDLE_NAME = "ColBundle";
    protected static final String ROW_BUNDLE_NAME = "RowBundle";
    protected static final String DISCRIMINATOR_RULE_SIZING = "SizingDiscRule";
    protected static final String ROW_HEIGHT_NAME = "RowH";
    protected static final String COLUMN_WIDTH_NAME = "ColW";
    protected int d_defaultColumnWidth = GridViewDefaultValues.getSizingMgrDefaultColumnWidth();
    protected int d_defaultRowHeight = GridViewDefaultValues.getSizingMgrDefaultRowHeight();
    protected int d_defaultColumnHeaderRowHeight = GridViewDefaultValues.getSizingMgrDefaultColHeaderRowHeight();
    protected int d_defaultRowHeaderColumnWidth = GridViewDefaultValues.getSizingMgrDefaultRowHeaderColWidth();
    private static final String m_method_setDefaultRowHeight = "setDefaultRowHeight(int height)";
    private static final String m_method_setDefaultColumnWidth = "setDefaultColumnWidth(int width)";
    private static final String m_method_setCalculatedRowHeight = "setCalculatedRowHeight(int row, int height)";
    private static final String m_method_getCalculatedRowHeight = "getCalculatedRowHeight(int row)";
    private static final String m_method_setCalculatedColumnWidth = "setCalculatedColumnWidth(int column, int width)";
    private static final String m_method_getCalculatedColumnWidth = "getCalculatedColumnWidth(int column)";

    public GridViewRuleSizing(GridViewCommon gv) {
        this.m_gridView = gv;
        this.m_defaultDatabodySizes = new ViewSizing(this.d_defaultRowHeight, this.d_defaultColumnWidth);
        this.m_defaultHeaderSizes = new ViewSizing(this.d_defaultColumnHeaderRowHeight, this.d_defaultRowHeaderColumnWidth);
    }

    @Override
    public void dataSourceChanged() {
        this.clearCalculatedSizes();
        this.clearPreferredRowHeightsCache();
        this.clearPreferredColumnWidthsCache();
    }

    @Override
    public void setDefaultRowHeight(int height) {
        if (height < 0) {
            this.m_gridView.getErrorHandler().log("invalid height", this.getClass().getName(), m_method_setDefaultRowHeight);
            return;
        }
        this.m_defaultDatabodySizes.setRowHeight(height);
        this.m_gridView.updateSizes(0);
    }

    @Override
    public int getDefaultRowHeight() {
        return this.m_defaultDatabodySizes.getRowHeight();
    }

    @Override
    public void setDefaultColumnWidth(int width) {
        if (width < 0) {
            this.m_gridView.getErrorHandler().log("invalid width", this.getClass().getName(), m_method_setDefaultColumnWidth);
            return;
        }
        this.m_defaultDatabodySizes.setColumnWidth(width);
        this.m_gridView.updateSizes(1);
    }

    @Override
    public int getDefaultColumnWidth() {
        return this.m_defaultDatabodySizes.getColumnWidth();
    }

    @Override
    public void setCalculatedRowHeight(int row, int height) {
        if (this.m_calculatedRowHeights == null) {
            this.createCalculatedRowHeightsArray();
        }
        if (row < 0 || row > this.m_calculatedRowHeights.length - 1) {
            this.m_gridView.getErrorHandler().log("row out of range", this.getClass().getName(), m_method_setCalculatedRowHeight);
            return;
        }
        if (height < 0 && height != -1) {
            this.m_gridView.getErrorHandler().log("height out of range", this.getClass().getName(), m_method_setCalculatedRowHeight);
            return;
        }
        this.m_calculatedRowHeights[row] = height;
    }

    @Override
    public int getCalculatedRowHeight(int row) {
        if (this.m_calculatedRowHeights == null) {
            return -1;
        }
        if (row < 0 || row > this.m_calculatedRowHeights.length - 1) {
            this.m_gridView.getErrorHandler().log("row out of range", this.getClass().getName(), m_method_getCalculatedRowHeight);
            return -1;
        }
        return this.m_calculatedRowHeights[row];
    }

    @Override
    public void setCalculatedColumnWidth(int column, int width) {
        if (this.m_calculatedColumnWidths == null) {
            int colCount = 0;
            try {
                colCount = this.m_gridView.getModel().getDataAccess().getEdgeExtent(0);
            }
            catch (EdgeOutOfRangeException e) {
                colCount = 0;
            }
            this.m_calculatedColumnWidths = new int[colCount];
            for (int i = 0; i < this.m_calculatedColumnWidths.length; ++i) {
                this.m_calculatedColumnWidths[i] = -1;
            }
        }
        if (column < 0 || column > this.m_calculatedColumnWidths.length - 1) {
            this.m_gridView.getErrorHandler().log("column out of range", this.getClass().getName(), m_method_setCalculatedColumnWidth);
            return;
        }
        if (width < 0 && width != -1) {
            this.m_gridView.getErrorHandler().log("width out of range", this.getClass().getName(), m_method_setCalculatedColumnWidth);
            return;
        }
        this.m_calculatedColumnWidths[column] = width;
    }

    @Override
    public int getCalculatedColumnWidth(int column) {
        if (this.m_calculatedColumnWidths == null) {
            return -1;
        }
        if (column < 0 || column > this.m_calculatedColumnWidths.length - 1) {
            this.m_gridView.getErrorHandler().log("column out of range", this.getClass().getName(), m_method_getCalculatedColumnWidth);
            return -1;
        }
        return this.m_calculatedColumnWidths[column];
    }

    @Override
    public abstract void setPreferredRowHeight(int var1, int var2);

    @Override
    public abstract int getPreferredRowHeight(int var1);

    @Override
    public abstract void setPreferredColumnWidth(int var1, int var2);

    @Override
    public abstract int getPreferredColumnWidth(int var1);

    @Override
    public int getRowHeight(int row) {
        int desiredHeight = this.getPreferredRowHeight(row);
        if (desiredHeight == -1 && (desiredHeight = this.getCalculatedRowHeight(row)) == -1) {
            desiredHeight = this.getDefaultRowHeight();
        }
        if (desiredHeight < this.m_gridView.getCellMinHeight()) {
            desiredHeight = this.m_gridView.getCellMinHeight();
        }
        if (desiredHeight > this.m_gridView.getCellMaxHeight()) {
            desiredHeight = this.m_gridView.getCellMaxHeight();
        }
        return desiredHeight;
    }

    @Override
    public int getColumnWidth(int column) {
        int desiredWidth = this.getPreferredColumnWidth(column);
        if (desiredWidth == -1 && (desiredWidth = this.getCalculatedColumnWidth(column)) == -1) {
            desiredWidth = this.getDefaultColumnWidth();
        }
        if (desiredWidth < this.m_gridView.getCellMinWidth()) {
            desiredWidth = this.m_gridView.getCellMinWidth();
        }
        if (desiredWidth > this.m_gridView.getCellMaxWidth()) {
            desiredWidth = this.m_gridView.getCellMaxWidth();
        }
        return desiredWidth;
    }

    @Override
    public void setDefaultRowHeaderColumnWidth(int width) {
        this.m_defaultHeaderSizes.setColumnWidth(width);
        this.m_gridView.updateSizes(3);
    }

    @Override
    public int getDefaultRowHeaderColumnWidth() {
        return this.m_defaultHeaderSizes.getColumnWidth();
    }

    @Override
    public void setDefaultColumnHeaderRowHeight(int height) {
        this.m_defaultHeaderSizes.setRowHeight(height);
        this.m_gridView.updateSizes(2);
    }

    @Override
    public int getDefaultColumnHeaderRowHeight() {
        return this.m_defaultHeaderSizes.getRowHeight();
    }

    @Override
    public void clearCalculatedSizes() {
        this.m_calculatedRowHeights = null;
        this.m_calculatedColumnWidths = null;
    }

    @Override
    public void clearPreferredSizes() {
        this.m_preferredRowHeights = null;
        this.m_preferredColumnWidths = null;
        this.clearPreferredRowHeightsCache();
        this.clearPreferredColumnWidthsCache();
    }

    @Override
    public void reset() {
        this.clearCalculatedSizes();
        this.clearPreferredSizes();
        this.m_defaultDatabodySizes = new ViewSizing(this.d_defaultRowHeight, this.d_defaultColumnWidth);
        this.m_defaultHeaderSizes = new ViewSizing(this.d_defaultColumnHeaderRowHeight, this.d_defaultRowHeaderColumnWidth);
    }

    @Override
    public void dataChanged() {
        this.clearCalculatedSizes();
        this.clearPreferredRowHeightsCache();
        this.clearPreferredColumnWidthsCache();
    }

    @Override
    public abstract Object clone() throws CloneNotSupportedException;

    protected static void copyMembersForClone(GridViewRuleSizing from, GridViewRuleSizing to) {
        to.m_defaultDatabodySizes = (ViewSizing)from.m_defaultDatabodySizes.clone();
        to.m_defaultHeaderSizes = (ViewSizing)from.m_defaultHeaderSizes.clone();
        if (from.m_preferredRowHeights != null) {
            to.m_preferredRowHeights = (RuleBundle)from.m_preferredRowHeights.clone();
        }
        if (from.m_preferredColumnWidths != null) {
            to.m_preferredColumnWidths = (RuleBundle)from.m_preferredColumnWidths.clone();
        }
    }

    protected RuleBundle getPreferredColumnWidths() {
        if (this.m_preferredColumnWidths == null) {
            this.m_preferredColumnWidths = new RuleBundle();
        }
        return this.m_preferredColumnWidths;
    }

    protected RuleBundle getPreferredRowHeights() {
        if (this.m_preferredRowHeights == null) {
            this.m_preferredRowHeights = new RuleBundle();
        }
        return this.m_preferredRowHeights;
    }

    protected int[] getPreferredColumnWidthsCache() {
        if (this.m_preferredColumnWidthsCache == null) {
            this.createPreferredColumnWidthsCache();
        }
        return this.m_preferredColumnWidthsCache;
    }

    protected void createPreferredColumnWidthsCache() {
        int colCount = 0;
        try {
            colCount = this.m_gridView.getModel().getDataAccess().getEdgeExtent(0);
        }
        catch (EdgeOutOfRangeException e) {
            colCount = 0;
        }
        this.m_preferredColumnWidthsCache = new int[colCount];
        for (int i = 0; i < colCount; ++i) {
            this.m_preferredColumnWidthsCache[i] = -2;
        }
    }

    protected void clearPreferredColumnWidthsCache() {
        this.m_preferredColumnWidthsCache = null;
    }

    protected int[] getPreferredRowHeightsCache() {
        if (this.m_preferredRowHeightsCache == null) {
            this.createPreferredRowHeightsCache();
        }
        return this.m_preferredRowHeightsCache;
    }

    protected void createPreferredRowHeightsCache() {
        int rowCount = 0;
        try {
            rowCount = this.m_gridView.getModel().getDataAccess().getEdgeExtent(1);
        }
        catch (EdgeOutOfRangeException e) {
            rowCount = 0;
        }
        this.m_preferredRowHeightsCache = new int[rowCount];
        for (int i = 0; i < rowCount; ++i) {
            this.m_preferredRowHeightsCache[i] = -2;
        }
    }

    protected void clearPreferredRowHeightsCache() {
        this.m_preferredRowHeightsCache = null;
    }

    protected void createCalculatedRowHeightsArray() {
        int rowCount = 0;
        try {
            rowCount = this.m_gridView.getModel().getDataAccess().getEdgeExtent(1);
        }
        catch (EdgeOutOfRangeException e) {
            rowCount = 0;
        }
        this.m_calculatedRowHeights = new int[rowCount];
        for (int i = 0; i < this.m_calculatedRowHeights.length; ++i) {
            this.m_calculatedRowHeights[i] = -1;
        }
    }
}

