/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.gridView.gui;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.olaf.OracleLookAndFeel;
import oracle.dss.dataView.ComponentHandle;
import oracle.dss.dataView.ControllerEvent;
import oracle.dss.dataView.GridViewAttribute;
import oracle.dss.dataView.UIView;
import oracle.dss.dataView.gui.DataviewTool;
import oracle.dss.dataView.gui.DataviewToolbarRollover;
import oracle.dss.dataView.gui.ToolBar;
import oracle.dss.dataView.managers.ViewStyle;

public class WrapTool
extends JToggleButton
implements DataviewToolbarRollover,
DataviewTool,
ActionListener {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_WRAP_ENABLED = "WrapEnabled";
    protected Object m_selectedObject = null;
    protected ComponentHandle m_selectedComponentHandle = null;
    protected UIView m_currentDataview = null;
    private static final Insets insets0 = new Insets(0, 0, 0, 0);
    private ResourceBundle rBundle = null;
    private MouseListener m_mouseListener;
    protected boolean m_enable = true;
    protected boolean m_bRolloverIconEnabled = false;

    public WrapTool() {
        this.setMargin(insets0);
        this.addActionListener(this);
        this.setSelected(false);
        this.setEnabled(false);
        this.setIcon(this.makeImage("images/WrapText_18t.gif"));
        this.setDisabledIcon(new ImageIcon(ImageUtils.createDisabledImage((Image)((ImageIcon)this.getIcon()).getImage())));
        this.setBorderPainted(false);
        this.updateResourceBundle(Locale.getDefault());
        this.setToolTipText(this.rBundle.getString("Wrap"));
        if (!(UIManager.getLookAndFeel() instanceof OracleLookAndFeel)) {
            this.setPreferredSize(new Dimension(24, 24));
            this.setMinimumSize(this.getPreferredSize());
            this.setMaximumSize(this.getPreferredSize());
            this.m_mouseListener = new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    if (!WrapTool.this.isRolloverIconEnabled()) {
                        WrapTool.this.setBorderPainted(true);
                    }
                    if (!WrapTool.this.isEnabled()) {
                        WrapTool.this.setBorderPainted(WrapTool.this.isSelected());
                    }
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    if (!WrapTool.this.isRolloverIconEnabled()) {
                        WrapTool.this.setBorderPainted(WrapTool.this.isSelected());
                    }
                }
            };
            this.addMouseListener(this.m_mouseListener);
        }
    }

    @Override
    public void setLocale(Locale loc) {
        super.setLocale(loc);
        this.updateResourceBundle(loc);
        this.setToolTipText(this.rBundle.getString("Wrap"));
    }

    @Override
    public void selectedAction(ControllerEvent e, UIView currentDataView, ToolBar toolBar) {
        if (currentDataView == null) {
            return;
        }
        this.m_currentDataview = currentDataView;
        if (e == null) {
            return;
        }
        if (e.getComponentHandle() == null) {
            this.m_selectedObject = null;
            this.m_selectedComponentHandle = null;
            this.setEnabled(false);
            return;
        }
        Object selectedObject = e.getComponentHandle().getComponent();
        if (this.isEnabled(e.getComponentHandle())) {
            this.m_selectedObject = selectedObject;
            this.m_selectedComponentHandle = e.getComponentHandle();
            this.setEnabled(true);
            this.m_enable = false;
            if (this.getWrap()) {
                this.setSelected(true);
            } else {
                this.setSelected(false);
            }
            this.setBorderPainted(this.isSelected());
            this.m_enable = true;
        } else {
            this.setEnabled(false);
            this.m_selectedObject = null;
            this.m_selectedComponentHandle = null;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e == null || !this.m_enable) {
            return;
        }
        if (e.getSource() == this) {
            this.setWrap(this.isSelected());
            this.setBorderPainted(this.isSelected());
        }
    }

    private void updateResourceBundle(Locale loc) {
        this.rBundle = loc != null ? ResourceBundle.getBundle("oracle.dss.dataView.gui.resource.DataviewGUIBundle", loc) : ResourceBundle.getBundle("oracle.dss.dataView.gui.resource.DataviewGUIBundle");
    }

    @Override
    public void setRolloverIconEnabled(boolean bEnabled) {
        this.m_bRolloverIconEnabled = bEnabled;
        if (bEnabled) {
            this.setIcon(this.makeImage("images/WrapText.gif"));
            this.setRolloverIcon(this.makeImage("images/l_WrapText.gif"));
        } else {
            this.setIcon(this.makeImage("images/WrapText_18t.gif"));
            this.setRolloverIcon(null);
        }
        this.setDisabledIcon(new ImageIcon(ImageUtils.createDisabledImage((Image)((ImageIcon)this.getIcon()).getImage())));
    }

    @Override
    public boolean isRolloverIconEnabled() {
        return this.m_bRolloverIconEnabled;
    }

    @Override
    public void update() {
    }

    @Override
    public void cleanUp() {
        this.removeMouseListener(this.m_mouseListener);
        this.removeActionListener(this);
    }

    private boolean isEnabled(ComponentHandle selectedComponentHandle) {
        return this.m_currentDataview instanceof GridViewAttribute && ((GridViewAttribute)((Object)this.m_currentDataview)).getComponentViewStyle(selectedComponentHandle) != null;
    }

    private boolean getWrap() {
        if (this.m_currentDataview instanceof GridViewAttribute) {
            ViewStyle viewStyle = ((GridViewAttribute)((Object)this.m_currentDataview)).getComponentViewStyle(this.m_selectedComponentHandle);
            return viewStyle.isWordWrapEnabled();
        }
        return false;
    }

    private void setWrap(boolean wrap) {
        if (this.m_currentDataview instanceof GridViewAttribute) {
            ViewStyle viewStyle = new ViewStyle();
            viewStyle.setWordWrapEnabled(wrap);
            ((GridViewAttribute)((Object)this.m_currentDataview)).applyViewStyle(this.m_selectedComponentHandle, viewStyle);
            this.firePropertyChange(PROPERTY_WRAP_ENABLED, !wrap, wrap);
        }
    }

    private ImageIcon makeImage(String fileName) {
        return new ImageIcon(ImageUtils.getImageResource(WrapTool.class, (String)fileName));
    }
}

