/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.gridView.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.sql.Date;
import java.text.MessageFormat;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableModel;
import oracle.bali.ewt.button.DialogButtonBar;
import oracle.bali.ewt.help.HelpProvider;
import oracle.bali.ewt.help.HelpUnavailableException;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.ewt.olaf.ColorScheme;
import oracle.bali.ewt.olaf.OracleLookAndFeel;
import oracle.bali.share.nls.StringUtils;
import oracle.dss.dataView.gui.BaseConditionalFormatPanel;
import oracle.dss.dataView.managers.ViewFormat;
import oracle.dss.dataView.managers.ViewStyle;
import oracle.dss.gridView.ConditionElement;
import oracle.dss.gridView.GridView;
import oracle.dss.gridView.UIFormat;
import oracle.dss.gridView.UIGridView;
import oracle.dss.gridView.gui.DatePanel;
import oracle.dss.gridView.gui.FontPanel;
import oracle.dss.gridView.gui.FormatGeneralPanel;
import oracle.dss.gridView.gui.NumberFormatPanel;
import oracle.dss.gridView.gui.SamplePanel;
import oracle.dss.rules.Mergeable;
import oracle.dss.rules.discriminator.Discriminator;
import oracle.dss.util.help.HelpContext;

public class GridviewConditionalFormatPanel
extends BaseConditionalFormatPanel {
    private static final long serialVersionUID = 1L;
    protected Vector m_numberCustomList = null;
    protected Vector m_dateCustomList = null;
    public static final int CUSTOM_NUMBER = 0;
    public static final int CUSTOM_DATE = 1;
    private static String HEAD_CURR_DEFAULT_STR = "L999G999G999";
    private static String TAIL_CURR_DEFAULT_STR = "999G999G999L";
    private String m_numberFormatString = HEAD_CURR_DEFAULT_STR;
    private String m_dateFormatString = "";
    private boolean m_numberFormatSet = false;
    private boolean m_dateFormatSet = false;
    protected FormatGeneralPanel m_formatGeneralPanel = null;
    protected FontPanel m_fontPanel = null;
    protected NumberFormatPanel m_numberFormatPanel = null;
    protected DatePanel m_datePanel = null;
    protected ViewStyle m_gridViewStyle;
    protected ViewFormat m_gridViewFormat;
    protected UIGridView m_gridView = (GridView)this.m_view;
    protected ResourceBundle grBundle = null;
    private static final int DEFAULT_NONE = 15;
    protected PanelDialog m_editFormatDialog;
    protected JPanel m_panel;
    protected JTabbedPane m_tabbedPane;
    protected boolean isDate = false;
    protected boolean isNumber = false;
    protected SamplePanel m_samplePanel = null;
    protected UIFormat m_format = null;

    public GridviewConditionalFormatPanel(GridView gridview) {
        this(gridview, null);
    }

    public GridviewConditionalFormatPanel(GridView gridview, UIFormat format) {
        super(gridview);
        this.m_format = format;
        this.constructPanel();
    }

    @Override
    public void constructPanel() {
        this.updateResourceBundle(this.m_gridView.getLocale());
        if (this.m_format != null) {
            this.editDataFormat();
        } else {
            this.createDataFormat(false);
        }
        super.constructPanel();
        if (this.m_format != null) {
            this.m_nameField.setText(this.m_format.getName());
            this.m_nameField.setEnabled(true);
            this.m_nameBox.setSelected(false);
        }
        this.m_formatSample = this.getFormatSampleTable();
        this.m_tmpPanel.add((Component)this.m_formatSample, "Center");
    }

    public void updateTable() {
        TableModel model = this.m_applyToTable.getModel();
        for (int i = 0; i < model.getRowCount(); ++i) {
            model.setValueAt((String)this.m_dimensionVector.elementAt(i), i, 0);
            model.setValueAt(this.m_memberVector.elementAt(i).toString(), i, 1);
        }
    }

    public JTable getFormatSampleTable() {
        SamplePanel samplePanel = null;
        if (this.m_numberFormatPanel != null && this.m_datePanel != null) {
            samplePanel = new SamplePanel(this.m_formatGeneralPanel, this.m_fontPanel, (oracle.dss.dataView.gui.NumberFormatPanel)this.m_numberFormatPanel, this.m_datePanel);
        } else if (this.m_numberFormatPanel != null) {
            samplePanel = new SamplePanel(this.m_formatGeneralPanel, this.m_fontPanel, this.m_numberFormatPanel);
        } else if (this.m_datePanel != null) {
            samplePanel = new SamplePanel(this.m_formatGeneralPanel, this.m_fontPanel, this.m_datePanel);
        }
        if (samplePanel != null) {
            samplePanel.removeListeners();
        }
        return samplePanel.getSampleTable();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        if (e.getSource() == this.m_editFormat) {
            this.m_editFormatDialog.show();
            if (this.m_format == null) {
                this.applyFormat();
            } else {
                this.editApplyFormat();
            }
            if (this.m_editFormatDialog.isOK()) {
                String str = this.getAttributeLabel();
                if (!str.equals(this.m_description.getText())) {
                    this.m_description.setText(str);
                }
                this.m_tmpPanel.remove(this.m_formatSample);
                this.m_formatSample = this.getFormatSampleTable();
                this.m_tmpPanel.add((Component)this.m_formatSample, "Center");
            }
        }
    }

    protected static String toHexString(Color c) {
        if (c == null) {
            return "Transparent";
        }
        int value = c.getRGB();
        String hexStr = Integer.toHexString(value & 0xFFFFFF);
        String poundStr = "#";
        StringBuffer buff = new StringBuffer(poundStr);
        buff.append(hexStr);
        return buff.toString();
    }

    @Override
    public String getAttributeLabel() {
        String subString;
        ViewFormat vf;
        String Sep = ",";
        String string = "";
        ViewStyle vs = this.m_gridViewStyle;
        if (vs != null) {
            if (vs.isFontUsed()) {
                string = string + this.grBundle.getString("Font") + " : ";
            }
            if (vs.isFontNameUsed()) {
                string = string + vs.getFontName() + Sep;
            }
            if (vs.isFontSizeUsed()) {
                string = string + vs.getFontSize() + this.grBundle.getString("pt") + Sep;
            }
            if (vs.isFontBoldUsed() && vs.isFontBold()) {
                string = string + this.grBundle.getString(this.grBundle.getString("Bold")) + Sep;
            }
            if (vs.isFontItalicUsed() && vs.isFontItalic()) {
                string = string + this.grBundle.getString(this.grBundle.getString("Italic")) + Sep;
            }
            if (vs.isUnderlineUsed()) {
                string = string + this.grBundle.getString("Underline") + Sep;
            }
            if (vs.isStrikeThroughUsed()) {
                string = string + this.grBundle.getString("StrikeThrough") + Sep;
            }
            if (vs.isHorizontalAlignmentUsed()) {
                string = string + this.grBundle.getString("HorizontalAlignment") + " : " + vs.getHorizontalAlignment();
            }
            if (vs.isForegroundUsed()) {
                string = string + GridviewConditionalFormatPanel.toHexString(vs.getForeground());
            }
            if (vs.isBackgroundUsed()) {
                string = string + this.grBundle.getString("Background") + " : " + GridviewConditionalFormatPanel.toHexString(vs.getBackground());
            }
        }
        if ((vf = this.m_gridViewFormat) != null) {
            if (vf.isCurrencySymbolUsed() || vf.isDecimalDigitUsed() || vf.isDecimalSeparatorUsed() || vf.isNegCurFmtUsed() || vf.isNegNumFmtUsed() || vf.isNumberTypeUsed() || vf.isPercentUsed() || vf.isPosCurFmtUsed() || vf.isPosNumFmtUsed() || vf.isScaleDownBillionsUsed() || vf.isScaleDownMillionsUsed() || vf.isScaleDownQuadrillionsUsed() || vf.isScaleDownTrillionsUsed() || vf.isScaleDownThousandsUsed() || vf.isScaleFactorUsed()) {
                String tmp = vf.DoubleToString(1234567.0);
                string = string + MessageFormat.format(this.grBundle.getString("Number:"), tmp) + Sep;
            }
            if (vf.isOracleDateFormatUsed()) {
                GregorianCalendar cal = new GregorianCalendar();
                cal.set(2000, 2, 21, 15, 15);
                Date date = new Date(cal.getTime().getTime());
                String tmp = vf.DateToString(date);
                string = string + MessageFormat.format(this.grBundle.getString("Date:"), tmp);
            }
        }
        if (string == "" && vs != null && vs.isForegroundUsed()) {
            string = this.grBundle.getString("FontColor");
        }
        if (string.indexOf(Sep) != -1 && (subString = string.substring(string.length() - 1, string.length())) != "" && subString.equals(Sep)) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    @Override
    protected void updateResourceBundle(Locale loc) {
        super.updateResourceBundle(loc);
        this.grBundle = loc != null ? ResourceBundle.getBundle("oracle.dss.gridView.gui.resource.GridviewGUIBundle", loc) : ResourceBundle.getBundle("oracle.dss.gridView.gui.resource.GridviewGUIBundle");
    }

    public void editDataFormat() {
        int type = this.m_format.getFormatType();
        boolean selected = this.m_format.isSelected();
        String label = this.m_format.getName();
        Discriminator discriminator = this.m_format.getDiscriminator();
        boolean negativeRed = this.m_format.isNegativeRed();
        int numberOrDate = this.m_format.getNumberOrDateCategory();
        String patternString = this.m_format.getNumberOrDateFormatString();
        this.m_valueCondition = this.m_format.getValueCondition();
        ViewStyle vs = this.m_format.getViewStyle();
        if (vs == null) {
            vs = new ViewStyle();
        }
        ViewFormat vf = this.m_format.getViewFormat();
        this.m_formatGeneralPanel = new FormatGeneralPanel(vs);
        this.m_formatGeneralPanel.setCustomColorsEnabled(this.m_gridView.isCustomColorsEnabled());
        boolean visible = false;
        if (this.m_gridView.getModel() != null && this.m_gridView.getModel().getDataDirector() != null && this.m_gridView.getModel().getDataDirector().getSupportedDataMap() != null) {
            visible = this.m_gridView.getModel().getDataDirector().getSupportedDataMap().contains((Object)"dataRatio");
        }
        this.m_formatGeneralPanel.setDataBarOptionVisible(visible);
        this.m_formatGeneralPanel.setLocale(super.getLocale());
        this.m_fontPanel = new FontPanel(vs);
        int numberCategory = numberOrDate >> 4;
        int dateCategory = numberOrDate & 0xF;
        if (vf == null) {
            vf = new ViewFormat();
            vf.setLocale(this.getLocale());
        }
        this.m_formatGeneralPanel.setFormatName(label);
        if (dateCategory != 15) {
            this.m_datePanel = new DatePanel(vf);
            this.m_datePanel.setLocale(super.getLocale());
            this.m_datePanel.setCategoryType(dateCategory);
            this.m_datePanel.setErrorHandler(this.getErrorHandler());
            this.m_datePanel.setCustomList(this.m_dateCustomList);
        }
        if (numberCategory != 15) {
            this.m_numberFormatPanel = new NumberFormatPanel(vf);
            this.m_numberFormatPanel.setLocale(super.getLocale());
            this.m_numberFormatPanel.setNegativeRed(negativeRed);
            this.m_numberFormatPanel.setFormatType(numberCategory);
            this.m_numberFormatPanel.setCustomPatternStringList(this.m_numberCustomList);
            if (numberCategory == 5) {
                this.m_numberFormatPanel.setCurrentCustomPatternString(patternString);
            }
        }
        if (this.m_numberFormatPanel != null && this.m_numberFormatSet) {
            this.m_numberFormatPanel.setDefaultFormat(this.getDefaultNumberFormatString());
        }
        if (this.m_datePanel != null && this.m_dateFormatSet) {
            this.m_datePanel.setDefaultDateFormatString(this.getDefaultDateFormatString());
        }
        this.m_tabbedPane = new JTabbedPane();
        String tabText = this.grBundle.getString("TabGeneral");
        this.m_tabbedPane.add(tabText, this.m_formatGeneralPanel);
        tabText = this.grBundle.getString("TabFont");
        this.m_tabbedPane.add(tabText, this.m_fontPanel);
        if (this.m_numberFormatPanel != null && this.m_datePanel != null) {
            tabText = this.grBundle.getString("TabNumber");
            this.m_tabbedPane.add(tabText, this.m_numberFormatPanel);
            tabText = this.grBundle.getString("TabDate");
            this.m_tabbedPane.add(tabText, this.m_datePanel);
            this.m_samplePanel = new SamplePanel(this.m_formatGeneralPanel, this.m_fontPanel, (oracle.dss.dataView.gui.NumberFormatPanel)this.m_numberFormatPanel, this.m_datePanel);
        } else if (this.m_numberFormatPanel != null) {
            tabText = this.grBundle.getString("TabNumber");
            this.m_tabbedPane.add(tabText, this.m_numberFormatPanel);
            this.m_samplePanel = new SamplePanel(this.m_formatGeneralPanel, this.m_fontPanel, this.m_numberFormatPanel);
        } else if (this.m_datePanel != null) {
            tabText = this.grBundle.getString("TabDate");
            this.m_tabbedPane.add(tabText, this.m_datePanel);
            this.m_samplePanel = new SamplePanel(this.m_formatGeneralPanel, this.m_fontPanel, this.m_datePanel);
        }
        this.initFromDisc(discriminator, this.m_valueCondition);
        this.m_fontPanel.addPropertyChangeListener(this.m_formatGeneralPanel);
        this.m_formatGeneralPanel.addPropertyChangeListener(this.m_fontPanel);
        this.m_tabbedPane.setLocale(super.getLocale());
        this.m_fontPanel.setLocale(super.getLocale());
        this.m_samplePanel.setLocale(super.getLocale());
        this.m_panel = new JPanel();
        if (UIManager.getLookAndFeel() instanceof OracleLookAndFeel) {
            this.m_panel.setBackground(UIManager.getColor(ColorScheme.DARK_LOOK));
        }
        this.m_panel.setLayout(new BoxLayout(this.m_panel, 1));
        this.m_panel.add(this.m_tabbedPane);
        this.m_panel.add(this.m_samplePanel);
        this.m_tabbedPane.setAlignmentX(0.0f);
        this.m_samplePanel.setAlignmentX(0.0f);
        this.m_gridViewStyle = vs;
        this.m_gridViewFormat = vf;
        this.m_editFormatDialog = this.createPanelDialog(this.grBundle.getString("Edit Data"), true, this.m_panel, 1, this.m_tabbedPane, this.getHelpProvider());
    }

    @Override
    protected String getDefaultConditionName() {
        String name = super.getDefaultConditionName();
        return name;
    }

    protected void createDataFormat(boolean b) {
        this.m_formatGeneralPanel = new FormatGeneralPanel(new ViewStyle());
        this.m_formatGeneralPanel.setCustomColorsEnabled(this.m_gridView.isCustomColorsEnabled());
        boolean visible = false;
        if (this.m_gridView.getModel() != null && this.m_gridView.getModel().getDataDirector() != null && this.m_gridView.getModel().getDataDirector().getSupportedDataMap() != null) {
            visible = this.m_gridView.getModel().getDataDirector().getSupportedDataMap().contains((Object)"dataRatio");
        }
        this.m_formatGeneralPanel.setDataBarOptionVisible(visible);
        this.m_gridViewStyle = new ViewStyle();
        this.m_fontPanel = new FontPanel(this.m_gridViewStyle);
        this.m_fontPanel.setCustomColorsEnabled(this.m_gridView.isCustomColorsEnabled());
        this.m_gridView.setUIFormatCount(this.m_gridView.getUIFormatCount() + 1);
        String translatedText = MessageFormat.format(this.grBundle.getString("CellFormat"), String.valueOf(this.m_gridView.getUIFormatCount()));
        this.m_formatGeneralPanel.setFormatName(translatedText);
        this.m_gridViewFormat = new ViewFormat();
        this.m_gridViewFormat.setLocale(this.m_gridView.getLocale());
        this.m_numberFormatPanel = new NumberFormatPanel(this.m_gridViewFormat);
        this.m_numberFormatPanel.setLocale(this.m_gridView.getLocale());
        this.m_numberFormatPanel.setCustomPatternStringList(this.m_numberCustomList);
        this.m_datePanel = new DatePanel(null);
        this.m_datePanel.setLocale(super.getLocale());
        this.m_datePanel.setErrorHandler(this.getErrorHandler());
        this.m_datePanel.setCustomList(this.m_dateCustomList);
        this.setDefaultConditions();
        this.m_tabbedPane = new JTabbedPane();
        String tabText = this.grBundle.getString("TabGeneral");
        this.m_tabbedPane.add(tabText, this.m_formatGeneralPanel);
        tabText = this.grBundle.getString("TabFont");
        this.m_tabbedPane.add(tabText, this.m_fontPanel);
        tabText = this.grBundle.getString("TabNumber");
        this.m_tabbedPane.add(tabText, this.m_numberFormatPanel);
        tabText = this.grBundle.getString("TabDate");
        this.m_tabbedPane.add(tabText, this.m_datePanel);
        this.m_samplePanel = new SamplePanel(this.m_formatGeneralPanel, this.m_fontPanel, (oracle.dss.dataView.gui.NumberFormatPanel)this.m_numberFormatPanel, this.m_datePanel);
        this.m_tabbedPane.setMinimumSize(this.m_tabbedPane.getPreferredSize());
        this.m_fontPanel.addPropertyChangeListener(this.m_formatGeneralPanel);
        this.m_formatGeneralPanel.addPropertyChangeListener(this.m_fontPanel);
        this.m_panel = new JPanel();
        if (UIManager.getLookAndFeel() instanceof OracleLookAndFeel) {
            this.m_panel.setBackground(UIManager.getColor(ColorScheme.DARK_LOOK));
        }
        this.m_panel.setLayout(new BoxLayout(this.m_panel, 1));
        this.m_panel.add(this.m_tabbedPane);
        this.m_panel.add(this.m_samplePanel);
        this.m_tabbedPane.setAlignmentX(0.0f);
        this.m_samplePanel.setAlignmentX(0.0f);
        this.m_editFormatDialog = this.createPanelDialog(this.grBundle.getString("Format Data"), true, this.m_panel, 1, this.m_tabbedPane, this.getHelpProvider());
        this.m_tabbedPane.setLocale(super.getLocale());
        this.m_fontPanel.setLocale(super.getLocale());
        this.m_samplePanel.setLocale(super.getLocale());
        this.m_formatGeneralPanel.setLocale(super.getLocale());
    }

    private PanelDialog createPanelDialog(String title, boolean modal, JPanel p, int action, JTabbedPane tabbedPane, HelpProvider helpProvider) {
        boolean bHelpEnabled = false;
        Container owner = this;
        while (owner != null) {
            if (owner instanceof Dialog) {
                return new PanelDialog((Dialog)owner, title, modal, p, bHelpEnabled, action, tabbedPane, helpProvider);
            }
            if (owner instanceof Frame) {
                return new PanelDialog((Frame)owner, title, modal, p, bHelpEnabled, action, tabbedPane, helpProvider);
            }
            owner = SwingUtilities.getWindowAncestor(owner);
        }
        if (owner == null) {
            return new PanelDialog((Frame)null, title, modal, p, bHelpEnabled, action, tabbedPane, helpProvider);
        }
        return null;
    }

    public void editApplyFormat() {
        int numberOrDate = this.m_format.getNumberOrDateCategory();
        int numberCategory = numberOrDate >> 4;
        String patternString = this.m_format.getNumberOrDateFormatString();
        ViewStyle vs = this.m_format.getViewStyle();
        if (vs == null) {
            vs = new ViewStyle();
        }
        ViewFormat vf = this.m_format.getViewFormat();
        int group = this.m_format.getGroup();
        if (this.m_editFormatDialog.isOK()) {
            if (this.m_numberFormatPanel != null) {
                numberCategory = this.m_numberFormatPanel.getFormatType();
                numberOrDate = numberCategory << 4;
                this.m_numberCustomList = this.m_numberFormatPanel.getCustomPatternStringList();
            } else {
                numberOrDate = 240;
            }
            if (this.m_datePanel != null) {
                int dateCategory = this.m_datePanel.getCategoryType();
                numberOrDate |= dateCategory;
                this.m_dateCustomList = this.m_datePanel.getCustomList();
            } else {
                numberOrDate |= 0xF;
            }
            if (numberCategory == 5) {
                patternString = this.m_numberFormatPanel.getCurrentCustomPatternString();
            }
            this.m_formatGeneralPanel.apply(vs);
            this.m_fontPanel.apply();
            ViewFormat viewFormat = null;
            if (this.m_numberFormatPanel != null && this.m_datePanel != null) {
                this.m_numberFormatPanel.apply();
                this.m_datePanel.apply();
                viewFormat = this.m_datePanel.getViewFormat();
                String dateFormat = null;
                if (viewFormat != null) {
                    dateFormat = viewFormat.getOracleDateFormat();
                }
                ViewFormat v1 = this.m_numberFormatPanel.getViewFormat();
                if (viewFormat != null && v1 != null) {
                    viewFormat.merge((Mergeable)((ViewFormat)((Object)v1.clone())));
                } else if (viewFormat == null) {
                    viewFormat = v1;
                }
                if (dateFormat != null) {
                    viewFormat.setOracleDateFormat(dateFormat);
                }
            } else if (this.m_datePanel != null) {
                this.m_datePanel.apply();
                if (this.m_datePanel.getViewFormat() != null) {
                    viewFormat = (ViewFormat)((Object)this.m_datePanel.getViewFormat().clone());
                }
            } else if (this.m_numberFormatPanel != null) {
                viewFormat = this.m_numberFormatPanel.apply();
            }
            this.m_format.setViewStyle(vs);
            this.m_format.setViewFormat(viewFormat);
            this.m_format.setNumberOrDateCategory(numberOrDate);
            this.m_format.setNumberOrDateFormatString(patternString);
            if (group == 4) {
                int mergeabletype = viewFormat == null ? 1 : 3;
                this.m_format.setMergeableType(mergeabletype);
            }
            if (this.m_numberFormatPanel != null) {
                this.m_format.setNegativeRed(this.m_numberFormatPanel.isNegativeRed());
            }
        }
        this.m_format.setName(this.getDefaultConditionName());
        if (group == 4) {
            this.m_format.setDiscriminator(this.getDiscriminator());
        }
        if (this.m_valueCondition != null) {
            if (this.m_valueCondition instanceof oracle.dss.dataView.ConditionElement) {
                this.m_format.setValueCondition(ConditionElement.copy(this.m_valueCondition));
            } else if (this.m_valueCondition instanceof ConditionElement) {
                this.m_format.setValueCondition((ConditionElement)this.m_valueCondition);
            }
        }
    }

    public void cleanUp() {
        this.m_tabbedPane.removeAll();
        this.m_panel.remove(this.m_samplePanel);
        this.m_fontPanel.removePropertyChangeListener(this.m_formatGeneralPanel);
        this.m_formatGeneralPanel.removePropertyChangeListener(this.m_fontPanel);
        this.m_fontPanel.cleanUp();
        this.m_fontPanel = null;
        this.m_formatGeneralPanel.cleanUp();
        this.m_formatGeneralPanel = null;
        if (this.m_datePanel != null) {
            this.m_datePanel.cleanUp();
            this.m_datePanel = null;
        }
        if (this.m_numberFormatPanel != null) {
            this.m_numberFormatPanel.cleanUp();
            this.m_numberFormatPanel = null;
        }
        this.m_samplePanel.cleanUp();
        this.m_samplePanel = null;
    }

    public void applyFormat() {
        if (this.m_editFormatDialog.isOK()) {
            Discriminator discriminator = this.getDiscriminator();
            ViewFormat m_gridViewFormat = null;
            if (this.isNumber && !this.isDate) {
                m_gridViewFormat = this.m_numberFormatPanel.apply();
            } else if (!this.isNumber && this.isDate) {
                this.m_datePanel.apply();
                m_gridViewFormat = (ViewFormat)((Object)this.m_datePanel.getViewFormat().clone());
            } else {
                ViewFormat v1 = this.m_numberFormatPanel.apply();
                this.m_datePanel.apply();
                if (this.m_datePanel.getViewFormat() != null) {
                    m_gridViewFormat = (ViewFormat)((Object)this.m_datePanel.getViewFormat().clone());
                    if (v1 != null) {
                        m_gridViewFormat.merge((Mergeable)v1);
                    }
                } else if (v1 != null) {
                    m_gridViewFormat = v1;
                }
            }
            String patternString = "";
            this.m_fontPanel.apply();
            this.m_formatGeneralPanel.apply(this.m_gridViewStyle);
            boolean negativeRed = false;
            negativeRed = this.m_numberFormatPanel.isNegativeRed();
            int numberOrDate = 0;
            if (this.m_numberFormatPanel != null) {
                if (this.m_numberFormatPanel.getFormatType() == 5) {
                    patternString = this.m_numberFormatPanel.getCurrentCustomPatternString();
                }
                numberOrDate = this.m_numberFormatPanel.getFormatType() << 4;
            } else {
                numberOrDate = 240;
            }
            numberOrDate = this.m_datePanel != null ? (numberOrDate |= this.m_datePanel.getCategoryType()) : (numberOrDate |= 0xF);
            int type = m_gridViewFormat == null ? 1 : 3;
            this.m_format = new UIFormat(this.getDefaultConditionName(), type, 3, 4, discriminator, this.m_gridViewStyle, m_gridViewFormat, negativeRed, numberOrDate, patternString);
            if (this.m_valueCondition != null && this.m_valueCondition instanceof oracle.dss.dataView.ConditionElement) {
                this.m_format.setValueCondition(ConditionElement.copy(this.m_valueCondition));
            }
            this.m_numberCustomList = this.m_numberFormatPanel.getCustomPatternStringList();
            this.m_dateCustomList = this.m_datePanel.getCustomList();
        }
    }

    public UIFormat getUIFormat() {
        return this.m_format;
    }

    public void setDefaultDateFormatString(String dateFormat) {
        this.m_dateFormatString = dateFormat;
        this.m_dateFormatSet = true;
    }

    public String getDefaultDateFormatString() {
        return this.m_dateFormatString;
    }

    public void setDefaultNumberFormatString(String numberFormat) {
        this.m_numberFormatString = numberFormat;
        this.m_numberFormatSet = true;
    }

    public String getDefaultNumberFormatString() {
        return this.m_numberFormatString;
    }

    public void setCustomFormatList(Vector list, int type) {
        if (type == 0) {
            this.m_numberCustomList = list;
        } else if (type == 1) {
            this.m_dateCustomList = list;
        }
    }

    public Vector getCustomFormatList(int type) {
        if (type == 0) {
            return this.m_numberCustomList;
        }
        if (type == 1) {
            return this.m_dateCustomList;
        }
        return null;
    }

    protected class PanelDialog
    extends JDialog
    implements ActionListener,
    HelpContext {
        private static final long serialVersionUID = 1L;
        private ResourceBundle rBundle;
        protected boolean m_ok;
        private int m_initialWidth;
        private int m_initialHeight;
        private boolean m_bHelpEnabled;
        protected HelpProvider m_helpProvider;
        private JTabbedPane m_tabbedPane;
        private String m_strHelpContextID;
        private JButton okButton;
        private JButton cancelButton;
        private JButton helpButton;
        protected JPanel m_panel;
        protected int m_action;
        private final Border _sBorder;
        private final Border _sBorderButtons;

        public PanelDialog(Frame parentFrame, String title, boolean modal, JPanel p, boolean bHelpEnabled, int action, JTabbedPane tabbedPane, HelpProvider helpProvider) {
            super(parentFrame);
            this.rBundle = null;
            this.m_ok = false;
            this.m_initialWidth = -1;
            this.m_initialHeight = -1;
            this.m_bHelpEnabled = true;
            this._sBorder = new EmptyBorder(6, 6, 8, 5);
            this._sBorderButtons = new EmptyBorder(8, 10, 0, 10);
            this._initDialog(title, modal, p, bHelpEnabled, action, tabbedPane, helpProvider);
        }

        public PanelDialog(Dialog owner, String title, boolean modal, JPanel p, boolean bHelpEnabled, int action, JTabbedPane tabbedPane, HelpProvider helpProvider) {
            super(owner);
            this.rBundle = null;
            this.m_ok = false;
            this.m_initialWidth = -1;
            this.m_initialHeight = -1;
            this.m_bHelpEnabled = true;
            this._sBorder = new EmptyBorder(6, 6, 8, 5);
            this._sBorderButtons = new EmptyBorder(8, 10, 0, 10);
            this._initDialog(title, modal, p, bHelpEnabled, action, tabbedPane, helpProvider);
        }

        protected void updateResourceBundle(Locale loc) {
            this.rBundle = loc != null ? ResourceBundle.getBundle("oracle.dss.gridView.gui.resource.GridviewGUIBundle", loc) : ResourceBundle.getBundle("oracle.dss.gridView.gui.resource.GridviewGUIBundle");
        }

        private void _initDialog(String title, boolean modal, JPanel p, boolean bHelpEnabled, int action, JTabbedPane tabbedPane, HelpProvider helpProvider) {
            this.updateResourceBundle(null);
            this.m_bHelpEnabled = bHelpEnabled;
            this.m_tabbedPane = tabbedPane;
            this.setHelpProvider(helpProvider);
            this.setTitle(title);
            this.setModal(modal);
            this.m_panel = p;
            this.m_action = action;
            this.setHelpEnabled(true);
            this.init();
            this.pack();
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension frameSize = this.getSize();
            if (frameSize.height > screenSize.height) {
                frameSize.height = screenSize.height;
            }
            if (frameSize.width > screenSize.width) {
                frameSize.width = screenSize.width;
            }
            this.setLocation((screenSize.width - frameSize.height) / 2, (screenSize.height - frameSize.width) / 2);
            this.m_initialWidth = this.getWidth();
            this.m_initialHeight = this.getHeight();
        }

        public String getHelpContextID() {
            String strReturn = "";
            Component tmpComponent = this.m_tabbedPane.getSelectedComponent();
            if (tmpComponent instanceof HelpContext) {
                strReturn = ((HelpContext)tmpComponent).getHelpContextID();
            }
            tmpComponent = null;
            return strReturn;
        }

        public void cleanUp() {
            this.getContentPane().remove(this.m_panel);
            this.m_tabbedPane = null;
            this.m_panel.removeAll();
            this.m_panel = null;
        }

        public void setHelpContextID(String strHelpContextID) {
            this.m_strHelpContextID = strHelpContextID;
        }

        public void setHelpProvider(HelpProvider helpProvider) {
            this.m_helpProvider = helpProvider;
        }

        public HelpProvider getHelpProvider() {
            return this.m_helpProvider;
        }

        public void setHelpEnabled(boolean bValue) {
            this.m_bHelpEnabled = bValue;
        }

        public boolean isHelpEnabled() {
            return this.m_bHelpEnabled;
        }

        private void init() {
            this.m_initialWidth = -1;
            this.m_initialHeight = -1;
            JComponent content = (JComponent)this.getContentPane();
            content.setLayout(new BoxLayout(content, 1));
            content.setBorder(this._sBorder);
            content.add(this.m_panel);
            if (UIManager.getLookAndFeel() instanceof OracleLookAndFeel) {
                content.setBackground(UIManager.getColor(ColorScheme.DARK_LOOK));
            }
            DialogButtonBar buttonPanel = new DialogButtonBar();
            buttonPanel.setBorder(this._sBorderButtons);
            if (this.m_bHelpEnabled) {
                String translatedText = this.rBundle.getString("Help");
                this.helpButton = new JButton(StringUtils.stripMnemonic((String)translatedText));
                this.helpButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
                buttonPanel.add((Component)this.helpButton, DialogButtonBar.CONSTRAINT_HELP);
                this.helpButton.addActionListener(this);
                this.helpButton.registerKeyboardAction(this, KeyStroke.getKeyStroke(112, 0), 2);
            }
            JPanel buttonPanel_east = new JPanel();
            String translatedText = this.rBundle.getString("OK");
            this.okButton = new JButton(StringUtils.stripMnemonic((String)translatedText));
            this.okButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
            buttonPanel.add((Component)this.okButton, DialogButtonBar.CONSTRAINT_YES);
            this.okButton.addActionListener(this);
            this.getRootPane().setDefaultButton(this.okButton);
            translatedText = this.rBundle.getString("Cancel");
            this.cancelButton = new JButton(StringUtils.stripMnemonic((String)translatedText));
            this.cancelButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
            buttonPanel.add((Component)this.cancelButton, DialogButtonBar.CONSTRAINT_CANCEL);
            this.cancelButton.addActionListener(this);
            this.cancelButton.registerKeyboardAction(this, KeyStroke.getKeyStroke(27, 0), 2);
            this.getContentPane().add((Component)buttonPanel);
            this.setResizable(true);
            this.m_panel.setAlignmentX(0.0f);
            buttonPanel.setAlignmentX(0.0f);
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    int originalHeight;
                    int originalWidth;
                    int width = originalWidth = PanelDialog.this.getWidth();
                    int height = originalHeight = PanelDialog.this.getHeight();
                    if (PanelDialog.this.m_initialWidth != -1) {
                        width = Math.max(PanelDialog.this.m_initialWidth, width);
                    }
                    if (PanelDialog.this.m_initialHeight != -1) {
                        height = Math.max(PanelDialog.this.m_initialHeight, height);
                    }
                    if (originalWidth != width || originalHeight != height) {
                        PanelDialog.this.setSize(width, height);
                    }
                    PanelDialog.this.validate();
                }
            });
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.cancelButton) {
                this.setVisible(false);
                this.dispose();
                this.getParent().repaint();
                this.m_ok = false;
            } else if (e.getSource() == this.okButton) {
                boolean ret = true;
                if (ret) {
                    this.m_ok = true;
                    this.setVisible(false);
                    this.dispose();
                } else {
                    this.m_ok = false;
                }
            } else if (e.getSource() == this.helpButton) {
                try {
                    if (this.getHelpProvider() != null) {
                        this.getHelpProvider().showHelp((Component)this);
                    } else if (HelpUtils.getDefaultHelpProvider() != null) {
                        HelpUtils.getDefaultHelpProvider().showHelp((Component)this);
                    }
                }
                catch (HelpUnavailableException helpUnavailableException) {
                    // empty catch block
                }
            }
        }

        public boolean isOK() {
            return this.m_ok;
        }
    }
}

