/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.gridView.gui;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.olaf.OracleLookAndFeel;
import oracle.dss.dataView.ControllerEvent;
import oracle.dss.dataView.GridViewAttribute;
import oracle.dss.dataView.UIView;
import oracle.dss.dataView.gui.DataviewTool;
import oracle.dss.dataView.gui.DataviewToolbarRollover;
import oracle.dss.dataView.gui.ToolBar;
import oracle.dss.gridView.UIGridView;

public class DataBarTool
extends JToggleButton
implements DataviewToolbarRollover,
DataviewTool,
ActionListener {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_DATABAR_VISIBLE = "DataBarVisible";
    Object m_currentDataView = null;
    private static final Insets insets0 = new Insets(0, 0, 0, 0);
    private ResourceBundle rBundle = null;
    private boolean m_enable = true;
    protected boolean m_bRolloverIconEnabled = false;
    private MouseListener m_mouseListener;

    public DataBarTool() {
        this.setEnabled(false);
        this.setIcon(this.makeImage("images/GridLines_18t.gif"));
        this.setDisabledIcon(new ImageIcon(ImageUtils.createDisabledImage((Image)((ImageIcon)this.getIcon()).getImage())));
        this.addActionListener(this);
        this.setBorderPainted(false);
        this.updateResourceBundle(Locale.getDefault());
        this.setToolTipText(this.rBundle.getString("DataBar"));
        if (!(UIManager.getLookAndFeel() instanceof OracleLookAndFeel)) {
            this.setPreferredSize(new Dimension(24, 24));
            this.setMinimumSize(this.getPreferredSize());
            this.setMaximumSize(this.getPreferredSize());
            this.m_mouseListener = new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    if (!DataBarTool.this.isRolloverIconEnabled()) {
                        DataBarTool.this.setBorderPainted(true);
                    }
                    if (!DataBarTool.this.isEnabled()) {
                        DataBarTool.this.setBorderPainted(DataBarTool.this.isSelected());
                    }
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    if (!DataBarTool.this.isRolloverIconEnabled()) {
                        DataBarTool.this.setBorderPainted(DataBarTool.this.isSelected());
                    }
                }
            };
            this.addMouseListener(this.m_mouseListener);
        }
    }

    @Override
    public void setLocale(Locale loc) {
        super.setLocale(loc);
        this.updateResourceBundle(loc);
        this.setToolTipText(this.rBundle.getString("DataBar"));
    }

    @Override
    public void selectedAction(ControllerEvent e, UIView currentDataView, ToolBar toolBar) {
        this.m_enable = false;
        if (currentDataView instanceof UIGridView) {
            this.setSelected(((UIGridView)currentDataView).getDatabody().getViewStyle().isGraphicBarVisible());
            this.setEnabled(true);
            this.setBorderPainted(this.isSelected());
            this.m_currentDataView = currentDataView;
        } else {
            this.m_currentDataView = null;
        }
        this.m_enable = true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e == null || !this.m_enable) {
            return;
        }
        if (this.m_currentDataView instanceof GridViewAttribute) {
            ((UIGridView)this.m_currentDataView).getDatabody().getViewStyle().setGraphicBarVisible(this.isSelected());
            this.setBorderPainted(this.isSelected());
            this.firePropertyChange(PROPERTY_DATABAR_VISIBLE, !this.isSelected(), this.isSelected());
        }
    }

    @Override
    public void setRolloverIconEnabled(boolean bEnabled) {
        this.m_bRolloverIconEnabled = bEnabled;
        if (bEnabled) {
            this.setIcon(this.makeImage("images/GridLines.gif"));
            this.setRolloverIcon(this.makeImage("images/l_GridLines.gif"));
            this.setRolloverSelectedIcon(this.makeImage("images/l_GridLines.gif"));
        } else {
            this.setIcon(this.makeImage("images/GridLines_18t.gif"));
            this.setRolloverIcon(null);
            this.setRolloverSelectedIcon(null);
        }
        this.setDisabledIcon(new ImageIcon(ImageUtils.createDisabledImage((Image)((ImageIcon)this.getIcon()).getImage())));
    }

    @Override
    public boolean isRolloverIconEnabled() {
        return this.m_bRolloverIconEnabled;
    }

    @Override
    public void update() {
        if (this.m_currentDataView == null) {
            return;
        }
        if (this.m_currentDataView instanceof UIGridView) {
            this.setEnabled(true);
            this.setSelected(((UIGridView)this.m_currentDataView).getDatabody().getViewStyle().isGraphicBarVisible());
        } else {
            this.setSelected(false);
            this.setEnabled(false);
        }
    }

    private ImageIcon makeImage(String fileName) {
        return new ImageIcon(ImageUtils.getImageResource(DataBarTool.class, (String)fileName));
    }

    private void updateResourceBundle(Locale loc) {
        this.rBundle = loc != null ? ResourceBundle.getBundle("oracle.dss.dataView.gui.resource.DataviewGUIBundle", loc) : ResourceBundle.getBundle("oracle.dss.dataView.gui.resource.DataviewGUIBundle");
    }

    @Override
    public void cleanUp() {
        this.removeActionListener(this);
        this.removeMouseListener(this.m_mouseListener);
    }
}

