/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.gridView;

import java.util.Hashtable;
import oracle.dss.dataView.managers.ViewFormat;
import oracle.dss.dataView.managers.ViewStyle;
import oracle.dss.gridView.UIFormatAttributes;
import oracle.dss.rules.discriminator.CompositeDiscriminator;
import oracle.dss.rules.discriminator.DateValueDiscriminator;
import oracle.dss.rules.discriminator.Discriminator;
import oracle.dss.rules.discriminator.DiscriminatorXML;
import oracle.dss.rules.discriminator.NumberValueDiscriminator;
import oracle.dss.rules.discriminator.QDRDiscriminator;
import oracle.dss.rules.discriminator.StringValueDiscriminator;
import oracle.dss.rules.discriminator.TotalsDiscriminator;
import oracle.dss.util.persistence.BIPersistenceException;
import oracle.dss.util.xml.BIIOException;
import oracle.dss.util.xml.BaseObjectNode;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;
import oracle.dss.util.xml.XMLObjectReader;
import oracle.dss.util.xml.XMLObjectWriter;

public class UIFormatXML {
    private static final String UI_FORMAT = "UIFormat";
    private static final String a_name = "name";
    private static final String a_automaticName = "autoName";
    private static final String a_id = "id";
    private static final String a_mergeableType = "mergeType";
    private static final String a_group = "group";
    private static final String a_formatType = "fmtType";
    private static final String a_negativeRed = "negRed";
    private static final String a_numberOrDate = "numOrDate";
    private static final String a_numberFormatString = "fmtStr";
    private static final String a_discriminator = "disc";
    private static final String a_viewStyle = "viewStyle";
    private static final String a_viewFormat = "viewFormat";
    private static final String a_condition = "valueCond";
    private static final String a_type = "type";
    private static final String a_selected = "selected";
    private transient UIFormatAttributes m_format = null;
    private Hashtable m_context = null;
    private static final boolean SAVE_DISCRIMINATOR_AND_MERGEABLE = false;

    public UIFormatXML(UIFormatAttributes format) {
        this.m_format = format;
    }

    public UIFormatXML(UIFormatAttributes format, Hashtable context) {
        this.m_format = format;
        this.m_context = context;
    }

    public void setContext(Hashtable context) {
        this.m_context = context;
    }

    public String getXMLAsString() {
        XMLObjectWriter writer = new XMLObjectWriter();
        try {
            writer.setIndentMode(1);
            writer.writeObjectNode((BaseObjectNode)this.getObjectNode());
            return writer.toString();
        }
        catch (BIIOException biioe) {
            return null;
        }
    }

    public ObjectNode getObjectNode() {
        return this.getObjectNode(true);
    }

    public ObjectNode getObjectNode(boolean allProperties) {
        ObjectNode node = new ObjectNode(UI_FORMAT);
        node.addProperty(a_name, this.m_format.getName());
        if (this.m_format.getGroup() == 5) {
            node.addProperty(a_automaticName, this.m_format.isAutomaticName());
        }
        node.addProperty(a_id, this.m_format.getID());
        node.addProperty(a_mergeableType, this.m_format.getMergeableType());
        node.addProperty(a_group, this.m_format.getGroup());
        node.addProperty(a_formatType, this.m_format.getFormatType());
        node.addProperty(a_negativeRed, this.m_format.isNegativeRed());
        node.addProperty(a_numberOrDate, this.m_format.getNumberOrDateCategory());
        node.addProperty(a_numberFormatString, this.m_format.getNumberOrDateFormatString());
        node.addProperty(a_selected, this.m_format.isSelected());
        ObjectNode conditionNode = this.m_format.getConditionNode();
        if (conditionNode != null) {
            node.addProperty(a_condition, conditionNode);
        }
        if (!this.m_format.isSelected() || allProperties) {
            Discriminator discriminator;
            ObjectNode viewFormatNode;
            ObjectNode viewStyleNode;
            if (this.m_format.getViewStyle() != null && (viewStyleNode = this.m_format.getViewStyle().getXML(allProperties)) != null) {
                node.addProperty(a_viewStyle, viewStyleNode);
            }
            if (this.m_format.getViewFormat() != null && (viewFormatNode = this.m_format.getViewFormat().getXML(allProperties)) != null) {
                node.addProperty(a_viewFormat, viewFormatNode);
            }
            if ((discriminator = this.m_format.getDiscriminator()) instanceof DiscriminatorXML) {
                ObjectNode disc;
                if (this.m_context != null) {
                    if (discriminator instanceof QDRDiscriminator) {
                        ((QDRDiscriminator)discriminator).setContext(this.m_context);
                    } else if (discriminator instanceof CompositeDiscriminator) {
                        ((CompositeDiscriminator)discriminator).setContext(this.m_context);
                    }
                }
                if ((disc = ((DiscriminatorXML)discriminator).getXML(true, null, false)) != null) {
                    node.addProperty(a_discriminator, disc);
                }
            }
        }
        return node;
    }

    public boolean setXMLAsString(String xml) throws BIPersistenceException {
        XMLObjectReader reader = new XMLObjectReader(xml);
        ObjectNode node = null;
        try {
            node = reader.readObjectNode();
        }
        catch (Exception XMLException) {
            return false;
        }
        return this.setXML(node);
    }

    public boolean setXML(ObjectNode node) {
        ObjectNode vfNode;
        ObjectNode vsNode;
        ObjectNode discriminator;
        ObjectNode conditionNode;
        if (!node.getName().equals(UI_FORMAT)) {
            return false;
        }
        PropertyNode pNode = null;
        pNode = node.getProperty(a_group);
        if (pNode != null) {
            int group = pNode.getValueAsInteger();
            if (this.m_context != null && this.m_context.containsKey(a_group)) {
                this.m_context.put(a_group, new Integer(group));
                this.m_format.setContext(this.m_context);
            }
            this.m_format.setGroup(group);
        }
        if ((pNode = node.getProperty(a_name)) != null) {
            this.m_format.setName(pNode.getValueAsString());
        }
        if ((pNode = node.getProperty(a_automaticName)) != null) {
            this.m_format.setAutomaticName(pNode.getValueAsBoolean());
        }
        if ((pNode = node.getProperty(a_id)) != null) {
            this.m_format.setID(pNode.getValueAsLong());
        }
        if ((pNode = node.getProperty(a_mergeableType)) != null) {
            this.m_format.setMergeableType(pNode.getValueAsInteger());
        }
        if ((pNode = node.getProperty(a_formatType)) != null) {
            this.m_format.setFormatType(pNode.getValueAsInteger());
        }
        if ((pNode = node.getProperty(a_negativeRed)) != null) {
            this.m_format.setNegativeRed(pNode.getValueAsBoolean());
        }
        if ((pNode = node.getProperty(a_numberOrDate)) != null) {
            this.m_format.setNumberOrDateCategory(pNode.getValueAsInteger());
        }
        if ((pNode = node.getProperty(a_numberFormatString)) != null) {
            this.m_format.setNumberOrDateFormatString(pNode.getValueAsString());
        }
        if ((pNode = node.getProperty(a_selected)) != null) {
            this.m_format.setSelected(pNode.getValueAsBoolean());
        }
        if ((conditionNode = node.getPropertyValueAsObjectNode(a_condition, true)) != null) {
            this.m_format.setConditionNode(conditionNode);
        }
        if ((discriminator = node.getPropertyValueAsObjectNode(a_discriminator, true)) != null) {
            if ((discriminator = discriminator.getPropertyValueAsObjectNode()).getName().equals("ComposDisc")) {
                CompositeDiscriminator cDisc = new CompositeDiscriminator();
                if (this.m_context != null) {
                    cDisc.setContext(this.m_context);
                }
                boolean result = cDisc.setXML(discriminator, null, null, 2);
                this.m_format.setDiscriminator((Discriminator)cDisc);
            } else if (discriminator.getName().equals("NumValDisc")) {
                NumberValueDiscriminator nvd = new NumberValueDiscriminator();
                boolean result = nvd.setXML(discriminator, null, null, 2);
                this.m_format.setDiscriminator((Discriminator)nvd);
            } else if (discriminator.getName().equals("DateValDisc")) {
                DateValueDiscriminator dvd = new DateValueDiscriminator();
                boolean result = dvd.setXML(discriminator, null, null, 2);
                this.m_format.setDiscriminator((Discriminator)dvd);
            } else if (discriminator.getName().equals("QDRDisc")) {
                QDRDiscriminator qdrd = new QDRDiscriminator();
                if (this.m_context != null) {
                    qdrd.setContext(this.m_context);
                }
                boolean result = qdrd.setXML(discriminator, null, null, 2);
                this.m_format.setDiscriminator((Discriminator)qdrd);
            } else if (discriminator.getName().equals("StrValDisc")) {
                StringValueDiscriminator svd = new StringValueDiscriminator();
                boolean result = svd.setXML(discriminator, null, null, 2);
                this.m_format.setDiscriminator((Discriminator)svd);
            } else if (discriminator.getName().equals("TotDisc")) {
                TotalsDiscriminator td = new TotalsDiscriminator();
                boolean result = td.setXML(discriminator, null, null, 2);
                this.m_format.setDiscriminator((Discriminator)td);
            } else {
                pNode = discriminator.getProperty(a_type);
                if (pNode == null) {
                    return true;
                }
                String undefinedDiscriminatorPath = pNode.getValueAsString();
                try {
                    Class<?> undefinedDiscriminatorClass = Class.forName(undefinedDiscriminatorPath);
                    DiscriminatorXML undefinedDiscriminator = (DiscriminatorXML)undefinedDiscriminatorClass.newInstance();
                    boolean result = undefinedDiscriminator.setXML(discriminator, null, null, 2);
                    this.m_format.setDiscriminator((Discriminator)undefinedDiscriminator);
                }
                catch (Exception exception) {
                    return true;
                }
            }
        }
        if ((vsNode = node.getPropertyValueAsObjectNode(a_viewStyle)) != null) {
            ViewStyle vs = new ViewStyle();
            vs.setXML(vsNode, "", 2);
            this.m_format.setViewStyle(vs);
        }
        if ((vfNode = node.getPropertyValueAsObjectNode(a_viewFormat)) != null) {
            ViewFormat vf = new ViewFormat();
            vf.setXML(vfNode, "", 2);
            this.m_format.setViewFormat(vf);
        }
        return true;
    }
}

