/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.model3d;

import oracle.dss.graph.pfj.GroupsEnumerator;
import oracle.dss.graph.pfj.JChart_3D;
import oracle.dss.graph.pfj.JGraphType;
import oracle.dss.graph.pfj.PfjAssert;
import oracle.dss.graph.pfj.SeriesEnumerator;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.graph.pfj.model3d.Model3DFlatFace;
import oracle.dss.graph.pfj.model3d.Point3d;

public class Model3DSurface
extends Model3DFlatFace {
    private static final long serialVersionUID = 1L;
    public static final int FRONT_BACK = 0;
    public static final int LEFT_RIGHT = 1;
    public static final int TOP = 2;
    public static final int BOTTOM = 3;
    public static final double BY_ANGLE_SCALE = 1.0;
    private static int[][] m_myfacesFront = new int[][]{{0, 1, 4, 3}, {1, 2, 5, 4}, {3, 4, 5}, {2, 1, 0}};
    private static int[][] m_myfacesBack = new int[][]{{2, 1, 4, 5}, {1, 0, 3, 4}, {3, 5, 4}, {0, 1, 2}};
    private boolean m_bShowSides;
    private boolean m_bShowTop;
    private int m_s;
    private int m_sNext;
    private int m_sFirst;
    private int m_sLast;
    private int m_g;
    private int m_gNext;
    private int m_gFirst;
    private int m_gLast;
    private boolean m_bFrontTriangle;

    public Model3DSurface(JChart_3D chart, IdentObj id, BlackBoxIF bb, Point3d[] vertices, boolean bShowSides, boolean bShowTop, SeriesEnumerator sEnum, GroupsEnumerator gEnum, boolean[][] bGridStatus, boolean bFrontTriangle, boolean bAutoshading) {
        super(chart, id, bb, 4, 6, bGridStatus, bAutoshading);
        this.m_faces = bFrontTriangle ? m_myfacesFront : m_myfacesBack;
        this.m_bShowSides = bShowSides;
        this.m_bShowTop = bShowTop;
        this.m_s = id.getSeriesID();
        this.m_sNext = sEnum.peekAtSeriesAfter(this.m_s);
        this.m_sFirst = sEnum.getFirstSeries();
        this.m_sLast = sEnum.getLastSeries();
        PfjAssert.pfjAssert(this.m_sFirst >= 0 && this.m_sLast >= 0);
        this.m_g = id.getGroupID();
        this.m_gNext = gEnum.peekAtGroupAfter(this.m_g);
        this.m_gFirst = gEnum.getFirstGroup();
        this.m_gLast = gEnum.getLastGroup();
        PfjAssert.pfjAssert(this.m_gFirst >= 0 && this.m_gLast >= 0);
        this.m_bFrontTriangle = bFrontTriangle;
        for (int i = 0; i < 6; ++i) {
            this.m_vertices[i] = new Point3d(vertices[i].x, vertices[i].y, vertices[i].z);
        }
    }

    @Override
    protected Point3d getCenter() {
        return new Point3d(this.m_vertices[0].x + (this.m_vertices[1].x - this.m_vertices[0].x) * 2.0 / 3.0, this.m_vertices[0].y, this.m_vertices[2].z + (this.m_vertices[1].z - this.m_vertices[2].z) * 2.0 / 3.0);
    }

    @Override
    protected Point3d getGridLineEnd(int nAxis, int nFace, double d) {
        switch (nAxis) {
            case 0: {
                double dx = (d - this.m_vertices[0].x) / (this.m_vertices[2].x - this.m_vertices[0].x);
                switch (nFace) {
                    case 0: {
                        if (this.m_bFrontTriangle) {
                            return new Point3d(d, this.m_vertices[3].y + dx * (this.m_vertices[4].y - this.m_vertices[3].y), this.m_vertices[0].z);
                        }
                        return new Point3d(d, this.m_vertices[4].y + dx * (this.m_vertices[5].y - this.m_vertices[4].y), this.m_vertices[2].z);
                    }
                    case 2: {
                        if (this.m_bFrontTriangle) {
                            return new Point3d(d, this.m_vertices[3].y + dx * (this.m_vertices[5].y - this.m_vertices[3].y), this.m_vertices[3].z - dx * (this.m_vertices[3].z - this.m_vertices[5].z));
                        }
                        return new Point3d(d, this.m_vertices[3].y + dx * (this.m_vertices[5].y - this.m_vertices[3].y), this.m_vertices[3].z - dx * (this.m_vertices[3].z - this.m_vertices[5].z));
                    }
                    case 3: {
                        return new Point3d(d, this.m_vertices[0].y, this.m_vertices[3].z - dx * (this.m_vertices[3].z - this.m_vertices[5].z));
                    }
                }
                break;
            }
            case 1: {
                switch (nFace) {
                    case 0: {
                        if (this.m_bFrontTriangle) {
                            if (d < this.m_vertices[4].y) {
                                return new Point3d(this.m_vertices[2].x, d, this.m_vertices[0].z);
                            }
                            double dy = (d - this.m_vertices[4].y) / (this.m_vertices[3].y - this.m_vertices[4].y);
                            return new Point3d(this.m_vertices[4].x + dy * (this.m_vertices[3].x - this.m_vertices[4].x), d, this.m_vertices[0].z);
                        }
                        if (d < this.m_vertices[4].y) {
                            return new Point3d(this.m_vertices[0].x, d, this.m_vertices[2].z);
                        }
                        double dy = (d - this.m_vertices[4].y) / (this.m_vertices[5].y - this.m_vertices[4].y);
                        return new Point3d(this.m_vertices[4].x + dy * (this.m_vertices[5].x - this.m_vertices[4].x), d, this.m_vertices[2].z);
                    }
                    case 1: {
                        if (this.m_bFrontTriangle) {
                            if (d < this.m_vertices[5].y) {
                                return new Point3d(this.m_vertices[2].x, d, this.m_vertices[2].z);
                            }
                            double dy = (d - this.m_vertices[5].y) / (this.m_vertices[4].y - this.m_vertices[5].y);
                            return new Point3d(this.m_vertices[2].x, d, this.m_vertices[5].z + dy * (this.m_vertices[4].z - this.m_vertices[5].z));
                        }
                        if (d < this.m_vertices[4].y) {
                            return new Point3d(this.m_vertices[0].x, d, this.m_vertices[2].z);
                        }
                        double dy = (d - this.m_vertices[4].y) / (this.m_vertices[3].y - this.m_vertices[4].y);
                        return new Point3d(this.m_vertices[0].x, d, this.m_vertices[4].z + dy * (this.m_vertices[3].z - this.m_vertices[4].z));
                    }
                    case 2: {
                        boolean v5_over;
                        boolean v3_over = this.m_vertices[3].y > d;
                        boolean v4_over = this.m_vertices[4].y > d;
                        boolean bl = v5_over = this.m_vertices[5].y > d;
                        if (v3_over == v4_over && v3_over == v5_over) {
                            return null;
                        }
                        if (v3_over != v5_over) {
                            double dy = (d - this.m_vertices[3].y) / (this.m_vertices[5].y - this.m_vertices[3].y);
                            return new Point3d(this.m_vertices[3].x + dy * (this.m_vertices[5].x - this.m_vertices[3].x), d, this.m_vertices[3].z + dy * (this.m_vertices[5].z - this.m_vertices[3].z));
                        }
                        if (this.m_bFrontTriangle) {
                            double dy = (d - this.m_vertices[5].y) / (this.m_vertices[4].y - this.m_vertices[5].y);
                            return new Point3d(this.m_vertices[2].x, d, this.m_vertices[5].z + dy * (this.m_vertices[4].z - this.m_vertices[5].z));
                        }
                        double dy = (d - this.m_vertices[4].y) / (this.m_vertices[5].y - this.m_vertices[4].y);
                        return new Point3d(this.m_vertices[4].x + dy * (this.m_vertices[5].x - this.m_vertices[4].x), d, this.m_vertices[2].z);
                    }
                    case 3: {
                        return null;
                    }
                }
                break;
            }
            case 2: {
                double dz = (d - this.m_vertices[2].z) / (this.m_vertices[0].z - this.m_vertices[2].z);
                switch (nFace) {
                    case 1: {
                        if (this.m_bFrontTriangle) {
                            return new Point3d(this.m_vertices[2].x, this.m_vertices[5].y + dz * (this.m_vertices[4].y - this.m_vertices[5].y), d);
                        }
                        return new Point3d(this.m_vertices[0].x, this.m_vertices[4].y + dz * (this.m_vertices[3].y - this.m_vertices[4].y), d);
                    }
                    case 2: {
                        return new Point3d(this.m_vertices[2].x + dz * (this.m_vertices[0].x - this.m_vertices[2].x), this.m_vertices[5].y + dz * (this.m_vertices[3].y - this.m_vertices[5].y), d);
                    }
                    case 3: {
                        return new Point3d(this.m_vertices[2].x + dz * (this.m_vertices[0].x - this.m_vertices[2].x), this.m_vertices[0].y, d);
                    }
                }
            }
        }
        return null;
    }

    @Override
    protected Point3d getGridLineStart(int nAxis, int nFace, double d) {
        switch (nAxis) {
            case 0: {
                double dx = (d - this.m_vertices[0].x) / (this.m_vertices[2].x - this.m_vertices[0].x);
                switch (nFace) {
                    case 0: {
                        if (this.m_bFrontTriangle) {
                            return new Point3d(d, this.m_vertices[0].y, this.m_vertices[0].z);
                        }
                        return new Point3d(d, this.m_vertices[0].y, this.m_vertices[2].z);
                    }
                    case 2: {
                        if (this.m_bFrontTriangle) {
                            return new Point3d(d, this.m_vertices[3].y + dx * (this.m_vertices[4].y - this.m_vertices[3].y), this.m_vertices[0].z);
                        }
                        return new Point3d(d, this.m_vertices[4].y + (1.0 - dx) * (this.m_vertices[5].y - this.m_vertices[4].y), this.m_vertices[2].z);
                    }
                    case 3: {
                        if (this.m_bFrontTriangle) {
                            return new Point3d(d, this.m_vertices[0].y, this.m_vertices[0].z);
                        }
                        return new Point3d(d, this.m_vertices[0].y, this.m_vertices[2].z);
                    }
                }
                break;
            }
            case 1: {
                switch (nFace) {
                    case 0: {
                        if (this.m_bFrontTriangle) {
                            if (d < this.m_vertices[3].y) {
                                return new Point3d(this.m_vertices[0].x, d, this.m_vertices[0].z);
                            }
                            double dy = (d - this.m_vertices[3].y) / (this.m_vertices[4].y - this.m_vertices[3].y);
                            return new Point3d(this.m_vertices[3].x + dy * (this.m_vertices[4].x - this.m_vertices[3].x), d, this.m_vertices[0].z);
                        }
                        if (d < this.m_vertices[5].y) {
                            return new Point3d(this.m_vertices[2].x, d, this.m_vertices[2].z);
                        }
                        double dy = (d - this.m_vertices[5].y) / (this.m_vertices[4].y - this.m_vertices[5].y);
                        return new Point3d(this.m_vertices[5].x - dy * (this.m_vertices[5].x - this.m_vertices[4].x), d, this.m_vertices[2].z);
                    }
                    case 1: {
                        if (this.m_bFrontTriangle) {
                            if (d < this.m_vertices[4].y) {
                                return new Point3d(this.m_vertices[2].x, d, this.m_vertices[0].z);
                            }
                            double dy = (d - this.m_vertices[4].y) / (this.m_vertices[5].y - this.m_vertices[4].y);
                            return new Point3d(this.m_vertices[2].x, d, this.m_vertices[4].z - dy * (this.m_vertices[4].z - this.m_vertices[5].z));
                        }
                        if (d < this.m_vertices[3].y) {
                            return new Point3d(this.m_vertices[0].x, d, this.m_vertices[0].z);
                        }
                        double dy = (d - this.m_vertices[3].y) / (this.m_vertices[4].y - this.m_vertices[3].y);
                        return new Point3d(this.m_vertices[0].x, d, this.m_vertices[3].z + dy * (this.m_vertices[4].z - this.m_vertices[3].z));
                    }
                    case 2: {
                        boolean v5_over;
                        boolean v3_over = this.m_vertices[3].y > d;
                        boolean v4_over = this.m_vertices[4].y > d;
                        boolean bl = v5_over = this.m_vertices[5].y > d;
                        if (v3_over == v4_over && v3_over == v5_over) {
                            return null;
                        }
                        if (this.m_bFrontTriangle) {
                            if (v3_over != v4_over) {
                                double dy = (d - this.m_vertices[4].y) / (this.m_vertices[3].y - this.m_vertices[4].y);
                                return new Point3d(this.m_vertices[4].x + dy * (this.m_vertices[3].x - this.m_vertices[4].x), d, this.m_vertices[0].z);
                            }
                            double dy = (d - this.m_vertices[5].y) / (this.m_vertices[4].y - this.m_vertices[5].y);
                            return new Point3d(this.m_vertices[2].x, d, this.m_vertices[5].z + dy * (this.m_vertices[4].z - this.m_vertices[5].z));
                        }
                        if (v3_over != v4_over) {
                            double dy = (d - this.m_vertices[4].y) / (this.m_vertices[3].y - this.m_vertices[4].y);
                            return new Point3d(this.m_vertices[0].x, d, this.m_vertices[4].z + dy * (this.m_vertices[3].z - this.m_vertices[4].z));
                        }
                        double dy = (d - this.m_vertices[4].y) / (this.m_vertices[5].y - this.m_vertices[4].y);
                        return new Point3d(this.m_vertices[4].x + dy * (this.m_vertices[5].x - this.m_vertices[4].x), d, this.m_vertices[2].z);
                    }
                }
                break;
            }
            case 2: {
                double dz = (d - this.m_vertices[2].z) / (this.m_vertices[0].z - this.m_vertices[2].z);
                switch (nFace) {
                    case 1: {
                        if (this.m_bFrontTriangle) {
                            return new Point3d(this.m_vertices[1].x, this.m_vertices[0].y, d);
                        }
                        return new Point3d(this.m_vertices[0].x, this.m_vertices[0].y, d);
                    }
                    case 2: {
                        if (this.m_bFrontTriangle) {
                            return new Point3d(this.m_vertices[2].x, this.m_vertices[5].y + dz * (this.m_vertices[4].y - this.m_vertices[5].y), d);
                        }
                        return new Point3d(this.m_vertices[0].x, this.m_vertices[4].y + dz * (this.m_vertices[3].y - this.m_vertices[4].y), d);
                    }
                    case 3: {
                        if (this.m_bFrontTriangle) {
                            return new Point3d(this.m_vertices[1].x, this.m_vertices[0].y, d);
                        }
                        return new Point3d(this.m_vertices[0].x, this.m_vertices[0].y, d);
                    }
                }
            }
        }
        return null;
    }

    @Override
    public int getNumPtsPerFace(int f) {
        if (f == 2 || f == 3) {
            return 3;
        }
        return 4;
    }

    @Override
    public double visibility(int f) {
        JGraphType gt = this.m_chart.getPerspective().getJGraphType();
        if (gt.isHoneyComb()) {
            if (f == 2 || f == 3) {
                return -1.0;
            }
            return 1.0;
        }
        if (gt.isSurfaceWithSides()) {
            boolean bVisible = false;
            switch (f) {
                case 0: {
                    if ((!this.m_bFrontTriangle || this.m_g != this.m_gFirst) && (this.m_bFrontTriangle || this.m_gNext == -1 || this.m_gNext != this.m_gLast)) break;
                    bVisible = true;
                    break;
                }
                case 1: {
                    if ((this.m_bFrontTriangle || this.m_s != this.m_sFirst) && (!this.m_bFrontTriangle || this.m_sNext == -1 || this.m_sNext != this.m_sLast)) break;
                    bVisible = true;
                    break;
                }
                case 2: 
                case 3: {
                    if (!this.m_bShowTop) break;
                    bVisible = true;
                }
            }
            double fVis = !bVisible ? -1.0 : super.visibility(f);
            return fVis;
        }
        if (f == 2) {
            return 1.0;
        }
        return -1.0;
    }
}

