/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.math;

import oracle.dss.graph.pfj.AssertionException;
import oracle.dss.graph.pfj.PfjAssert;
import oracle.dss.graph.pfj.math.CurveFitIF;
import oracle.dss.graph.pfj.math.FP;

public final class SVD {
    public static final double TOL = 1.0E-65;

    private static void backsub(double[][] u, double[] w, double[][] v, int m, int n, double[] b, double[] x) {
        double s;
        int j;
        PfjAssert.pfjAssert(u.length == m + 1);
        PfjAssert.pfjAssert(u[0].length == n + 1);
        PfjAssert.pfjAssert(w.length == n + 1);
        PfjAssert.pfjAssert(v.length == n + 1);
        PfjAssert.pfjAssert(v[0].length == n + 1);
        PfjAssert.pfjAssert(b.length == m + 1);
        PfjAssert.pfjAssert(x.length == n + 1);
        double[] tmp = new double[n + 1];
        for (j = 1; j <= n; ++j) {
            s = 0.0;
            if (w[j] != 0.0) {
                for (int i = 1; i <= m; ++i) {
                    s += u[i][j] * b[i];
                }
                s /= w[j];
            }
            tmp[j] = s;
        }
        for (j = 1; j <= n; ++j) {
            s = 0.0;
            for (int jj = 1; jj <= n; ++jj) {
                s += v[j][jj] * tmp[jj];
            }
            x[j] = s;
        }
    }

    private static void decomp(double[][] a, int m, int n, double[] w, double[][] v) throws AssertionException {
        int j;
        double h;
        double f;
        int k;
        double s;
        int i;
        int nm = 0;
        double anorm = 0.0;
        double g = 0.0;
        double scale = 0.0;
        PfjAssert.pfjAssert(a.length == m + 1);
        PfjAssert.pfjAssert(a[0].length == n + 1);
        PfjAssert.pfjAssert(w.length == n + 1);
        PfjAssert.pfjAssert(v.length == n + 1);
        PfjAssert.pfjAssert(v[0].length == n + 1);
        if (n < 1) {
            return;
        }
        int l = 0;
        double[] rv1 = new double[n + 1];
        for (i = 1; i <= n; ++i) {
            l = i + 1;
            rv1[i] = scale * g;
            scale = 0.0;
            s = 0.0;
            g = 0.0;
            if (i <= m) {
                for (k = i; k <= m; ++k) {
                    scale += Math.abs(a[k][i]);
                }
                if (scale != 0.0) {
                    for (k = i; k <= m; ++k) {
                        double[] dArray = a[k];
                        int n2 = i;
                        dArray[n2] = dArray[n2] / scale;
                        s += a[k][i] * a[k][i];
                    }
                    f = a[i][i];
                    g = Math.sqrt(s);
                    if (f >= 0.0) {
                        g *= -1.0;
                    }
                    h = f * g - s;
                    a[i][i] = f - g;
                    if (i != n) {
                        for (j = l; j <= n; ++j) {
                            s = 0.0;
                            for (k = i; k <= m; ++k) {
                                s += a[k][i] * a[k][j];
                            }
                            f = s / h;
                            for (k = i; k <= m; ++k) {
                                double[] dArray = a[k];
                                int n3 = j;
                                dArray[n3] = dArray[n3] + f * a[k][i];
                            }
                        }
                    }
                    for (k = i; k <= m; ++k) {
                        double[] dArray = a[k];
                        int n4 = i;
                        dArray[n4] = dArray[n4] * scale;
                    }
                }
            }
            w[i] = scale * g;
            g = 0.0;
            s = 0.0;
            scale = 0.0;
            if (i <= m && i != n) {
                for (k = l; k <= n; ++k) {
                    scale += Math.abs(a[i][k]);
                }
                if (scale != 0.0) {
                    for (k = l; k <= n; ++k) {
                        double[] dArray = a[i];
                        int n5 = k;
                        dArray[n5] = dArray[n5] / scale;
                        s += a[i][k] * a[i][k];
                    }
                    f = a[i][l];
                    g = Math.sqrt(s);
                    if (f >= 0.0) {
                        g *= -1.0;
                    }
                    h = f * g - s;
                    a[i][l] = f - g;
                    for (k = l; k <= n; ++k) {
                        rv1[k] = a[i][k] / h;
                    }
                    if (i != m) {
                        for (j = l; j <= m; ++j) {
                            s = 0.0;
                            for (k = l; k <= n; ++k) {
                                s += a[j][k] * a[i][k];
                            }
                            for (k = l; k <= n; ++k) {
                                double[] dArray = a[j];
                                int n6 = k;
                                dArray[n6] = dArray[n6] + s * rv1[k];
                            }
                        }
                    }
                    k = l;
                    while (k <= n) {
                        double[] dArray = a[i];
                        int n7 = k++;
                        dArray[n7] = dArray[n7] * scale;
                    }
                }
            }
            anorm = Math.max(anorm, Math.abs(w[i]) + Math.abs(rv1[i]));
        }
        i = n;
        while (i >= 1) {
            if (i < n) {
                if (g != 0.0) {
                    for (j = l; j <= n; ++j) {
                        v[j][i] = a[i][j] / a[i][l] / g;
                    }
                    for (j = l; j <= n; ++j) {
                        s = 0.0;
                        for (k = l; k <= n; ++k) {
                            s += a[i][k] * v[k][j];
                        }
                        for (k = l; k <= n; ++k) {
                            double[] dArray = v[k];
                            int n8 = j;
                            dArray[n8] = dArray[n8] + s * v[k][i];
                        }
                    }
                }
                for (j = l; j <= n; ++j) {
                    v[j][i] = 0.0;
                    v[i][j] = 0.0;
                }
            }
            v[i][i] = 1.0;
            g = rv1[i];
            l = i--;
        }
        i = n;
        while (i >= 1) {
            l = i + 1;
            g = w[i];
            if (i < n) {
                for (j = l; j <= n; ++j) {
                    a[i][j] = 0.0;
                }
            }
            if (g != 0.0) {
                g = 1.0 / g;
                if (i != n) {
                    for (j = l; j <= n; ++j) {
                        s = 0.0;
                        for (k = l; k <= m; ++k) {
                            s += a[k][i] * a[k][j];
                        }
                        f = s / a[i][i] * g;
                        for (k = i; k <= m; ++k) {
                            double[] dArray = a[k];
                            int n9 = j;
                            dArray[n9] = dArray[n9] + f * a[k][i];
                        }
                    }
                }
                for (j = i; j <= m; ++j) {
                    double[] dArray = a[j];
                    int n10 = i;
                    dArray[n10] = dArray[n10] * g;
                }
            } else {
                for (j = i; j <= m; ++j) {
                    a[j][i] = 0.0;
                }
            }
            double[] dArray = a[i];
            int n11 = i--;
            dArray[n11] = dArray[n11] + 1.0;
        }
        block27: for (k = n; k >= 1; --k) {
            for (int its = 1; its <= 30; ++its) {
                double z;
                double y;
                double c;
                boolean bFlag = true;
                for (l = k; l >= 1; --l) {
                    nm = l - 1;
                    if (Math.abs(rv1[l]) + anorm == anorm) {
                        bFlag = false;
                        break;
                    }
                    if (Math.abs(w[nm]) + anorm == anorm) break;
                }
                if (bFlag) {
                    c = 0.0;
                    s = 1.0;
                    for (i = l; i <= k; ++i) {
                        f = s * rv1[i];
                        rv1[i] = c * rv1[i];
                        if (Math.abs(f) + anorm == anorm) break;
                        g = w[i];
                        w[i] = h = FP.pythag(f, g);
                        h = 1.0 / h;
                        c = g * h;
                        s = -f * h;
                        for (j = 1; j <= m; ++j) {
                            y = a[j][nm];
                            z = a[j][i];
                            a[j][nm] = y * c + z * s;
                            a[j][i] = z * c - y * s;
                        }
                    }
                }
                z = w[k];
                if (l == k) {
                    if (!(z < 0.0)) continue block27;
                    w[k] = -z;
                    for (j = 1; j <= n; ++j) {
                        v[j][k] = -v[j][k];
                    }
                    continue block27;
                }
                if (its == 30) {
                    throw new AssertionException("SVD did not converge");
                }
                double x = w[l];
                nm = k - 1;
                y = w[nm];
                g = rv1[nm];
                h = rv1[k];
                f = ((y - z) * (y + z) + (g - h) * (g + h)) / (2.0 * h * y);
                g = FP.pythag(f, 1.0);
                double temp = f >= 0.0 ? g : -g;
                f = ((x - z) * (x + z) + h * (y / (f + temp) - h)) / x;
                s = 1.0;
                c = 1.0;
                for (j = l; j <= nm; ++j) {
                    int jj;
                    i = j + 1;
                    g = rv1[i];
                    y = w[i];
                    h = s * g;
                    g = c * g;
                    rv1[j] = z = FP.pythag(f, h);
                    c = f / z;
                    s = h / z;
                    f = x * c + g * s;
                    g = g * c - x * s;
                    h = y * s;
                    y *= c;
                    for (jj = 1; jj <= n; ++jj) {
                        x = v[jj][j];
                        z = v[jj][i];
                        v[jj][j] = x * c + z * s;
                        v[jj][i] = z * c - x * s;
                    }
                    w[j] = z = FP.pythag(f, h);
                    if (z != 0.0) {
                        z = 1.0 / z;
                        c = f * z;
                        s = h * z;
                    }
                    f = c * g + s * y;
                    x = c * y - s * g;
                    for (jj = 1; jj <= m; ++jj) {
                        y = a[jj][j];
                        z = a[jj][i];
                        a[jj][j] = y * c + z * s;
                        a[jj][i] = z * c - y * s;
                    }
                }
                rv1[l] = 0.0;
                rv1[k] = f;
                w[k] = x;
            }
        }
    }

    public static void fit(CurveFitIF curve, double[] xRaw, double[] yRaw, double[] sig, int nData, double[] a, double[] chisq) throws AssertionException {
        int j;
        double tmp;
        int i;
        int nCoeffs = curve.numCoeffs();
        PfjAssert.pfjAssert(nCoeffs > 0);
        PfjAssert.pfjAssert(xRaw.length >= nData + 1);
        PfjAssert.pfjAssert(yRaw.length >= nData + 1);
        if (sig != null) {
            PfjAssert.pfjAssert(sig.length >= nData + 1);
        }
        PfjAssert.pfjAssert(a.length == nCoeffs + 1);
        double[] afunc = new double[nCoeffs + 1];
        double[] xTemp = new double[nData + 1];
        double[] yTemp = new double[nData + 1];
        int iPoint = 0;
        for (i = 1; i <= nData; ++i) {
            try {
                curve.eval(xRaw[i], afunc);
                double yTemp2 = curve.transformY(yRaw[i]);
                if (Double.isNaN(yTemp2)) {
                    throw new Exception();
                }
                xTemp[++iPoint] = xRaw[i];
                yTemp[iPoint] = yTemp2;
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        int nValid = iPoint;
        if (nValid < nCoeffs) {
            throw new AssertionException("Too few valid data points = " + iPoint);
        }
        double[] x = new double[nValid + 1];
        double[] y = new double[nValid + 1];
        for (i = 1; i <= nValid; ++i) {
            x[i] = xTemp[i];
            y[i] = yTemp[i];
        }
        double[] b = new double[nValid + 1];
        double[][] u = new double[nValid + 1][nCoeffs + 1];
        double[][] v = new double[nCoeffs + 1][nCoeffs + 1];
        double[] w = new double[nCoeffs + 1];
        for (i = 1; i <= nValid; ++i) {
            curve.eval(x[i], afunc);
            tmp = sig == null ? 1.0 : 1.0 / sig[i];
            for (j = 1; j <= nCoeffs; ++j) {
                u[i][j] = afunc[j] * tmp;
            }
            b[i] = y[i] * tmp;
        }
        SVD.decomp(u, nValid, nCoeffs, w, v);
        double wMax = 0.0;
        for (j = 1; j <= nCoeffs; ++j) {
            if (!(w[j] > wMax)) continue;
            wMax = w[j];
        }
        SVD.backsub(u, w, v, nValid, nCoeffs, b, a);
        chisq[0] = 0.0;
        for (i = 1; i <= nValid; ++i) {
            curve.eval(x[i], afunc);
            double sum = 0.0;
            for (j = 1; j <= nCoeffs; ++j) {
                sum += a[j] * afunc[j];
            }
            tmp = y[i] - sum;
            if (sig != null) {
                tmp /= sig[i];
            }
            chisq[0] = chisq[0] + tmp * tmp;
        }
        for (j = 1; j <= nCoeffs; ++j) {
            a[j] = curve.invTransformCoeff(j, a[j]);
        }
    }
}

