/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.io.Serializable;
import oracle.dss.graph.pfj.AssertionException;
import oracle.dss.graph.pfj.AxisDescriptor;
import oracle.dss.graph.pfj.MinMaxObj;
import oracle.dss.graph.pfj.OrdinalAxisFragment;

public class ZoomState
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final ZoomState UNZOOMED = new ZoomState();
    protected boolean m_bZoomed = false;
    protected AxisDescriptor m_AxisDescriptor;
    protected double m_fMin_X1;
    protected double m_fMax_X1;
    protected double m_fMin_Y1;
    protected double m_fMax_Y1;
    protected double m_fMin_Y2;
    protected double m_fMax_Y2;
    protected boolean m_bAutoMin_X1 = false;
    protected boolean m_bAutoMax_X1 = false;
    protected boolean m_bAutoMin_Y1 = false;
    protected boolean m_bAutoMax_Y1 = false;
    protected boolean m_bAutoMin_Y2 = false;
    protected boolean m_bAutoMax_Y2 = false;
    protected static final int AXIS_X1 = 1;
    protected static final int AXIS_Y1 = 2;
    protected static final int AXIS_Y2 = 4;
    protected static final int AXIS_O1 = 8;
    protected static final int AXIS_ALL = 255;
    protected int m_zoomedAxes = 255;
    protected int m_nViewGroups;
    protected int m_nGroupOffset;
    protected int m_nViewSeries;
    protected int m_nSeriesOffset;

    public void ChartFrame(double fMin_X1, double fMax_X1, double fMin_Y1, double fMax_Y1, double fMin_Y2, double fMax_Y2, int nViewGroups, int nGroupOffset, int nViewSeries, int nSeriesOffset, AxisDescriptor axisDescriptor) {
        this.m_bZoomed = true;
        this.m_AxisDescriptor = axisDescriptor;
        this.m_fMin_X1 = fMin_X1;
        this.m_fMax_X1 = fMax_X1;
        this.m_fMin_Y1 = fMin_Y1;
        this.m_fMax_Y1 = fMax_Y1;
        this.m_fMin_Y2 = fMin_Y2;
        this.m_fMax_Y2 = fMax_Y2;
        this.m_nViewGroups = nViewGroups;
        this.m_nGroupOffset = nGroupOffset;
        this.m_nViewSeries = nViewSeries;
        this.m_nSeriesOffset = nSeriesOffset;
    }

    public void ChartFrame(double fMin_X1, double fMax_X1, double fMin_Y1, double fMax_Y1, double fMin_Y2, double fMax_Y2, int nViewGroups, int nGroupOffset, int nViewSeries, int nSeriesOffset, AxisDescriptor axisDescriptor, boolean bAutoMinX1, boolean bAutoMaxX1, boolean bAutoMinY1, boolean bAutoMaxY1, boolean bAutoMinY2, boolean bAutoMaxY2, int zoomedAxes) {
        this.m_bZoomed = true;
        this.m_AxisDescriptor = axisDescriptor;
        this.m_fMin_X1 = fMin_X1;
        this.m_fMax_X1 = fMax_X1;
        this.m_fMin_Y1 = fMin_Y1;
        this.m_fMax_Y1 = fMax_Y1;
        this.m_fMin_Y2 = fMin_Y2;
        this.m_fMax_Y2 = fMax_Y2;
        this.m_nViewGroups = nViewGroups;
        this.m_nGroupOffset = nGroupOffset;
        this.m_nViewSeries = nViewSeries;
        this.m_nSeriesOffset = nSeriesOffset;
        this.m_bAutoMin_X1 = bAutoMinX1;
        this.m_bAutoMax_X1 = bAutoMaxX1;
        this.m_bAutoMin_Y1 = bAutoMinY1;
        this.m_bAutoMax_Y1 = bAutoMaxY1;
        this.m_bAutoMin_Y2 = bAutoMinY2;
        this.m_bAutoMax_Y2 = bAutoMaxY2;
        this.m_zoomedAxes = zoomedAxes;
    }

    public OrdinalAxisFragment getOrdinalAxisFragment(int axisID) {
        OrdinalAxisFragment oafZoom = null;
        if (!this.m_bZoomed) {
            throw new AssertionException("UNZOOMED can't respond to getOrdinalAxisFragment");
        }
        switch (axisID) {
            case 5: {
                if (!this.m_AxisDescriptor.hasO1() || (this.getZoomedAxes() & 8) <= 0) break;
                oafZoom = new OrdinalAxisFragment(this.m_nViewGroups, this.m_nGroupOffset);
                break;
            }
            case 6: {
                if (!this.m_AxisDescriptor.hasO2()) break;
                oafZoom = new OrdinalAxisFragment(this.m_nViewSeries, this.m_nSeriesOffset);
                break;
            }
            default: {
                throw new AssertionException("ZoomState.getOrdinalAxisFragment: Unknown axis ID = " + axisID);
            }
        }
        return oafZoom;
    }

    public MinMaxObj getScaleMinMax(int axisID) {
        MinMaxObj mmZoom = null;
        if (!this.m_bZoomed) {
            throw new AssertionException("UNZOOMED can't respond to getScaleMin");
        }
        switch (axisID) {
            case 7: {
                if (!this.m_AxisDescriptor.hasX1() && !this.m_AxisDescriptor.hasO1() || (this.getZoomedAxes() & 1) <= 0) break;
                mmZoom = new MinMaxObj(this.m_fMin_X1, this.m_fMax_X1);
                break;
            }
            case 0: {
                if (!this.m_AxisDescriptor.hasY1() || (this.getZoomedAxes() & 2) <= 0) break;
                mmZoom = new MinMaxObj(this.m_fMin_Y1, this.m_fMax_Y1);
                break;
            }
            case 1: {
                if (!this.m_AxisDescriptor.hasY2() || (this.getZoomedAxes() & 4) <= 0) break;
                mmZoom = new MinMaxObj(this.m_fMin_Y2, this.m_fMax_Y2);
                break;
            }
            default: {
                throw new AssertionException("ZoomState.getScaleMin: Unknown axis ID = " + axisID);
            }
        }
        if (mmZoom != null) {
            mmZoom.setDataDerived(false);
        }
        return mmZoom;
    }

    public boolean isZoomed() {
        return this.m_bZoomed;
    }

    public boolean isAutoMin(int axisID) {
        switch (axisID) {
            case 7: {
                if (!this.m_AxisDescriptor.hasX1() && !this.m_AxisDescriptor.hasO1()) break;
                return this.m_bAutoMin_X1;
            }
            case 0: {
                if (!this.m_AxisDescriptor.hasY1()) break;
                return this.m_bAutoMin_Y1;
            }
            case 1: {
                if (!this.m_AxisDescriptor.hasY2()) break;
                return this.m_bAutoMin_Y2;
            }
            default: {
                throw new AssertionException("ZoomState.isAutoMin: Unknown axis ID = " + axisID);
            }
        }
        return false;
    }

    public boolean isAutoMax(int axisID) {
        switch (axisID) {
            case 7: {
                if (!this.m_AxisDescriptor.hasX1() && !this.m_AxisDescriptor.hasO1()) break;
                return this.m_bAutoMax_X1;
            }
            case 0: {
                if (!this.m_AxisDescriptor.hasY1()) break;
                return this.m_bAutoMax_Y1;
            }
            case 1: {
                if (!this.m_AxisDescriptor.hasY2()) break;
                return this.m_bAutoMax_Y2;
            }
            default: {
                throw new AssertionException("ZoomState.isAutoMax: Unknown axis ID = " + axisID);
            }
        }
        return false;
    }

    public int getZoomedAxes() {
        return this.m_zoomedAxes;
    }

    public String toString() {
        if (this.m_bZoomed) {
            return "[X1: (" + this.m_fMin_X1 + ", " + this.m_fMax_X1 + "), Y1: (" + this.m_fMin_Y1 + ", " + this.m_fMax_Y1 + ")]";
        }
        return "UNZOOMED state";
    }
}

