/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.awt.Color;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import oracle.dss.graph.GraphConstants;
import oracle.dss.graph.pfj.AssertionException;
import oracle.dss.graph.pfj.Attr;
import oracle.dss.graph.pfj.BackgroundObj;
import oracle.dss.graph.pfj.JChart_2D_BLA;
import oracle.dss.graph.pfj.JChart_2D_Funnel;
import oracle.dss.graph.pfj.JChart_2D_Scat;
import oracle.dss.graph.pfj.JChart_Base;
import oracle.dss.graph.pfj.LookKeyObj;
import oracle.dss.graph.pfj.TDGNestedLabel;
import oracle.dss.graph.pfj.ThickPFJ;
import oracle.dss.graph.pfj.TitleObj;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.graph.pfj.draw.SelList;
import oracle.dss.graph.pfj.event.TDGEventManager;
import oracle.dss.graph.pfj.event.TDGListener;

public class PerspectiveBase {
    protected static final int CALC_TO_BEGIN = 0;
    protected static final int CALC_COMPLETE = 1;
    protected static final int CHART_COMPLETE = 2;
    public static final int MAX_EXCEPTIONAL_RISERS = 256;
    public static final int NUM_PRESET_SERIES = 64;
    protected transient BackgroundObj m_background = null;
    protected transient JChart_Base m_chart = null;
    protected transient TitleObj m_title = null;
    protected transient TitleObj m_subtitle = null;
    protected transient TitleObj m_footnote = null;
    private static final int DEFAULT_CAPACITY = 50;
    private static final int DEFAULT_CAPACITY_NO_XML = 25;
    private HashMap m_cssLook = null;
    private HashMap m_stylesLook = null;
    private HashMap m_userLook = null;
    private HashMap m_userLookNoXML = null;
    private HashMap m_calcLook = null;
    private HashMap m_tempLook = null;
    private int m_putPropsMode = 3;
    private int m_getPropsMode = 3;
    private boolean m_NoXmlMode = false;
    protected boolean m_removeKeysMode = false;
    protected TDGEventManager m_EventManager = null;
    protected TDGNestedLabel m_O1LabelCallback = null;
    protected SelList m_selList = null;
    protected int m_nChartState = 0;
    protected List m_groupLabels = new ArrayList(100);
    protected List m_seriesLabels = new ArrayList(100);
    protected int[] m_seriesGradientEffect = null;
    protected int[] m_seriesPatternEffect = null;
    protected ThickPFJ m_thickPFJ = null;
    protected boolean m_repaints = true;
    protected static final IdentObj s_identObjGlobal = IdentObj.GLOBAL;
    protected final IdentObj m_identObj = new IdentObj(2000);
    private LookKeyObj m_sharedLookKeyObj = new LookKeyObj();
    private Boolean m_cachedToolTipMode;
    private int m_cachedSeriesLooping = -1;
    private int m_markerSizeUniqueness = 0;
    private boolean m_bUseRangeSlider = true;

    public PerspectiveBase() {
        int i;
        this.m_seriesGradientEffect = new int[((Integer)Attr.SeriesLooping.getDefault()).intValue()];
        for (i = 0; i < this.m_seriesGradientEffect.length; ++i) {
            this.m_seriesGradientEffect[i] = 0;
        }
        this.m_seriesPatternEffect = new int[((Integer)Attr.SeriesLooping.getDefault()).intValue()];
        for (i = 0; i < this.m_seriesPatternEffect.length; ++i) {
            this.m_seriesPatternEffect[i] = 0;
        }
        this.m_userLook = new HashMap(50);
    }

    void sync3DPresetParameters(int newValue) {
    }

    Object getFromLook(Attr AttrID) {
        return this.getFromLook(AttrID, 0);
    }

    Object getFromLook(Attr AttrID, int lookGetType) {
        IdentObj id = this.m_selList.firstElement();
        if (this.m_selList.hasMoreElements()) {
            IdentObj newId;
            switch (lookGetType) {
                case 1: {
                    newId = new IdentObj(-3, id.getSeriesID());
                    break;
                }
                case 2: {
                    newId = new IdentObj(-3, -3, id.getGroupID());
                    break;
                }
                case 3: {
                    newId = new IdentObj(-3, id.getSeriesID(), id.getGroupID());
                    break;
                }
                default: {
                    newId = id;
                }
            }
            return this.getFromLook(newId, AttrID);
        }
        return AttrID.getDefault();
    }

    public void removeKeysMode(boolean mode) {
        this.m_removeKeysMode = mode;
    }

    public void setGetPropertiesMode(int propsMode) {
        this.m_getPropsMode = propsMode;
    }

    public int getGetPropertiesMode() {
        return this.m_getPropsMode;
    }

    public void setPutPropertiesMode(int propsMode) {
        this.m_putPropsMode = propsMode;
    }

    public int getPutPropertiesMode() {
        return this.m_putPropsMode;
    }

    Object getFromLook(IdentObj id, Attr AttrID) {
        return this.getFromLook(id, AttrID, true);
    }

    public Object getFromLook2(IdentObj id, Attr AttrID) {
        return this.getFromHashMap(AttrID, id, false);
    }

    Object getFromLookSimple(IdentObj id, Attr AttrID) {
        return this.getFromHashMap(AttrID, id, true);
    }

    Object getFromLookSimple(IdentObj id, Attr AttrID, boolean useDefault) {
        return this.getFromHashMap(AttrID, id, useDefault);
    }

    Object getFromHashMap(Object key, boolean useDefault) {
        Object val = null;
        if (this.m_calcLook != null && (val = (Object)this.m_calcLook.get(key)) != null) {
            return val;
        }
        if (this.m_tempLook != null && (val = (Object)this.m_tempLook.get(key)) != null) {
            return val;
        }
        switch (this.getGetPropertiesMode()) {
            case 3: {
                val = this.m_userLook.get(key);
                if (val != null) {
                    return val;
                }
                val = this._getFromMap(this.m_userLookNoXML, key);
                if (val != null) {
                    return val;
                }
                val = this._getFromMap(this.m_stylesLook, key);
                if (val != null) {
                    return val;
                }
                val = this._getFromMap(this.m_cssLook, key);
                if (val != null) {
                    return val;
                }
                if (useDefault && key instanceof LookKeyObj) {
                    return ((LookKeyObj)key).getAttr().getDefault();
                }
                return null;
            }
            case 0: {
                return this.m_userLook.get(key);
            }
            case 1: {
                return this._getFromMap(this.m_stylesLook, key);
            }
            case 2: {
                return this._getFromMap(this.m_cssLook, key);
            }
        }
        return null;
    }

    Object getFromHashMap(Attr attr, IdentObj id, boolean useDefault) {
        LookKeyObj key = LookKeyObj.getGetInstance(attr, id, this, this.m_sharedLookKeyObj);
        return this.getFromHashMap(key, useDefault);
    }

    Object getFromLook(IdentObj id, Attr AttrID, boolean useDefault) {
        Object obj = null;
        obj = this.getFromHashMap(AttrID, id, false);
        if (obj != null) {
            return obj;
        }
        if (!id.isSERIES_NA() && !id.isGROUP_NA() && (obj = this.getFromHashMap(AttrID, this.getIdentObj(-3, id.getSeriesID(), id.getGroupID()), false)) != null) {
            return obj;
        }
        if (!id.isSERIES_NA() && (obj = this.getFromHashMap(AttrID, this.getIdentObj(-3, id.getSeriesID(), -3), false)) != null) {
            return obj;
        }
        if (!id.isGROUP_NA() && (obj = this.getFromHashMap(AttrID, this.getIdentObj(-3, -3, id.getGroupID()), false)) != null) {
            return obj;
        }
        if (!id.isOBJECT_NA() && (obj = this.getFromHashMap(AttrID, this.getIdentObj(id.getObjectID(), -3, -3), useDefault)) != null) {
            return obj;
        }
        if (useDefault && this.getGetPropertiesMode() == 3) {
            return AttrID.getDefault();
        }
        return null;
    }

    protected void destroyCalcLook() {
        this.m_calcLook = null;
    }

    public void createTempLook() {
        this.m_tempLook = new HashMap();
    }

    public void destroyTempLook() {
        this.m_tempLook = null;
    }

    protected void putToLook(Attr AttrID, Object newValue) throws AssertionException {
        this.putToLook(AttrID, newValue, 0);
    }

    protected void putToLook(Attr AttrID, Object newValue, int lookPutType) throws AssertionException {
        IdentObj id = this.m_selList.firstElement();
        while (this.m_selList.hasMoreElements()) {
            IdentObj newId;
            switch (lookPutType) {
                case 1: {
                    newId = new IdentObj(-3, id.getSeriesID());
                    break;
                }
                case 2: {
                    newId = new IdentObj(-3, -3, id.getGroupID());
                    break;
                }
                case 3: {
                    newId = new IdentObj(-3, id.getSeriesID(), id.getGroupID());
                    break;
                }
                default: {
                    newId = id;
                }
            }
            this.putToLook(newId, AttrID, newValue);
            id = this.m_selList.nextElement();
        }
    }

    protected void putToLook2(IdentObj id, Attr AttrID, Object newValue) throws AssertionException {
        this.putToHashMap(LookKeyObj.newSetInstance(AttrID, id), newValue);
    }

    protected void putToHashMap(Object key, Object newValue) throws AssertionException {
        if (this.m_removeKeysMode) {
            this.m_userLook.remove(key);
            this._removeFromMap(this.m_userLookNoXML, key);
            this._removeFromMap(this.m_stylesLook, key);
            this._removeFromMap(this.m_cssLook, key);
            return;
        }
        switch (this.getPutPropertiesMode()) {
            case 0: 
            case 3: {
                if (this.isNoXMLMode()) {
                    if (this.m_userLookNoXML == null) {
                        this.m_userLookNoXML = new HashMap(25);
                    }
                    this.m_userLookNoXML.put(key, newValue);
                    this.m_userLook.remove(key);
                    break;
                }
                this.m_userLook.put(key, newValue);
                this._removeFromMap(this.m_userLookNoXML, key);
                break;
            }
            case 1: {
                if (this.m_stylesLook == null) {
                    this.m_stylesLook = new HashMap(50);
                }
                this.m_stylesLook.put(key, newValue);
                break;
            }
            case 2: {
                if (this.m_cssLook == null) {
                    this.m_cssLook = new HashMap(50);
                }
                this.m_cssLook.put(key, newValue);
                break;
            }
            case 4: {
                this.m_tempLook.put(key, newValue);
            }
        }
    }

    protected void putToLook(IdentObj id, Attr AttrID, Object newValue) throws AssertionException {
        if (AttrID == null) {
            return;
        }
        AttrID.rangeCheckIfPossible(newValue);
        this.putToHashMap(LookKeyObj.newSetInstance(AttrID, id), newValue);
        this.m_nChartState = 0;
    }

    public void putToLookNoCalc(IdentObj id, Attr AttrID, Object newValue) {
        this.putToLookNoCalc(id, AttrID, newValue, false);
    }

    public void putToLookNoCalc(IdentObj id, Attr AttrID, Object newValue, boolean isCalcLook) {
        if (isCalcLook) {
            if (this.m_calcLook == null) {
                this.m_calcLook = new HashMap();
            }
            this.m_calcLook.put(LookKeyObj.newSetInstance(AttrID, id), newValue);
        } else {
            this.putToHashMap(LookKeyObj.newSetInstance(AttrID, id), newValue);
        }
    }

    protected void putToLookAndRepaint(IdentObj id, Attr AttrID, Object newValue) throws AssertionException {
        this.putToLook(id, AttrID, newValue);
        if (!this.getManualRedraw() && this.m_thickPFJ != null && this.m_repaints) {
            this.m_thickPFJ.repaint();
        }
    }

    protected void putToLookAndRepaint(Attr AttrID, Object newValue) throws AssertionException {
        this.putToLookAndRepaint(AttrID, newValue, 0);
    }

    protected void putToLookAndRepaint(Attr AttrID, Object newValue, int lookPutType) throws AssertionException {
        this.putToLook(AttrID, newValue, lookPutType);
        if (!this.getManualRedraw() && this.m_thickPFJ != null && this.m_repaints) {
            this.m_thickPFJ.repaint();
        }
    }

    public void stopRepaints() {
        this.m_repaints = false;
    }

    public void resumeRepaints() {
        this.m_repaints = true;
    }

    void removeFromHashMap(Object key) {
        if (this.m_removeKeysMode) {
            this.m_userLook.remove(key);
            this._removeFromMap(this.m_userLookNoXML, key);
            return;
        }
        switch (this.getPutPropertiesMode()) {
            case 0: {
                this.m_userLook.remove(key);
                this._removeFromMap(this.m_userLookNoXML, key);
            }
            case 1: {
                this._removeFromMap(this.m_stylesLook, key);
            }
            case 2: {
                this._removeFromMap(this.m_cssLook, key);
            }
            case 3: {
                this.m_userLook.remove(key);
                this._removeFromMap(this.m_userLookNoXML, key);
                this._removeFromMap(this.m_stylesLook, key);
                this._removeFromMap(this.m_cssLook, key);
            }
        }
    }

    void removeFromLook(Attr attr) {
        this.removeFromLook(attr, 0);
    }

    void removeFromLook(Attr attr, int lookRemoveType) {
        IdentObj id = this.m_selList.firstElement();
        while (this.m_selList.hasMoreElements()) {
            IdentObj newId;
            switch (lookRemoveType) {
                case 1: {
                    newId = new IdentObj(-3, id.getSeriesID());
                    break;
                }
                case 2: {
                    newId = new IdentObj(-3, -3, id.getGroupID());
                    break;
                }
                case 3: {
                    newId = new IdentObj(-3, id.getSeriesID(), id.getGroupID());
                    break;
                }
                default: {
                    newId = id;
                }
            }
            this.removeFromLook(newId, attr);
            id = this.m_selList.nextElement();
        }
    }

    void removeFromLook2(IdentObj id, Attr attr) {
        this.removeFromHashMap(LookKeyObj.getSetInstance(attr, id, this.m_sharedLookKeyObj));
    }

    void removeFromLook(IdentObj id, Attr attr) {
        IdentObj NewId;
        this.removeFromHashMap(LookKeyObj.getSetInstance(attr, id, this.m_sharedLookKeyObj));
        if (!id.isSERIES_NA() && !id.isGROUP_NA()) {
            NewId = new IdentObj(-3, id.getSeriesID(), id.getGroupID());
            this.removeFromHashMap(LookKeyObj.getSetInstance(attr, NewId, this.m_sharedLookKeyObj));
        }
        if (!id.isSERIES_NA()) {
            NewId = new IdentObj(-3, id.getSeriesID());
            this.removeFromHashMap(LookKeyObj.getSetInstance(attr, NewId, this.m_sharedLookKeyObj));
        }
        if (!id.isGROUP_NA()) {
            NewId = new IdentObj(-3, -3, id.getGroupID());
            this.removeFromHashMap(LookKeyObj.getSetInstance(attr, NewId, this.m_sharedLookKeyObj));
        }
        if (!id.isOBJECT_NA()) {
            NewId = new IdentObj(id.getObjectID());
            this.removeFromHashMap(LookKeyObj.getSetInstance(attr, NewId, this.m_sharedLookKeyObj));
        }
    }

    public void setNoXMLMode(boolean mode) {
        this.m_NoXmlMode = mode;
    }

    public boolean isNoXMLMode() {
        return this.m_NoXmlMode;
    }

    void DeleteAttribute(int seriesID, int groupID, Attr AttrID) {
        IdentObj id = new IdentObj(-3, seriesID, groupID);
        this.removeFromLook(id, AttrID);
    }

    void DeleteAttribute(int seriesID, Attr AttrID) {
        IdentObj id = new IdentObj(-3, seriesID, -3);
        this.removeFromLook(id, AttrID);
    }

    void DeleteAttribute(Attr AttrID) {
        this.removeFromLook(AttrID);
    }

    void DeleteAttribute(IdentObj id, Attr AttrID) {
        this.removeFromLook(id, AttrID);
    }

    public boolean getManualRedraw() {
        Boolean m_Obj = (Boolean)this.getFromLook(IdentObj.GLOBAL, Attr.ManualRedraw);
        return m_Obj;
    }

    public void setManualRedraw(boolean newValue) {
        if (newValue) {
            this.putToLook(IdentObj.GLOBAL, Attr.ManualRedraw, newValue);
        } else {
            this.putToLookAndRepaint(IdentObj.GLOBAL, Attr.ManualRedraw, newValue);
        }
    }

    static Attr GraphCategory_3D_Attr_Resolution(int AttrID) {
        return null;
    }

    static Attr GraphCategory_BLA_Attr_Resolution(int AttrID) {
        return null;
    }

    static Attr GraphCategory_PIE_Attr_Resolution(int AttrID) {
        return null;
    }

    static Attr GraphCategory_SCATTER_Attr_Resolution(int AttrID) {
        return null;
    }

    static Attr GraphCategory_HILO_Attr_Resolution(int AttrID) {
        return null;
    }

    static Attr GraphCategory_MISC_Attr_Resolution(int AttrID) {
        return null;
    }

    public boolean getUseOffScreen() {
        Boolean m_Obj = (Boolean)this.getFromLook(IdentObj.GLOBAL, Attr.UseOffScreen);
        return m_Obj;
    }

    public void setUseOffScreen(boolean newValue) {
        this.putToLook(IdentObj.GLOBAL, Attr.UseOffScreen, newValue);
    }

    public void addPerspectiveListener(TDGListener Listener) {
        this.m_EventManager.addPerspectiveListener(Listener);
    }

    public void removePerspectiveListener(TDGListener Listener) {
        this.m_EventManager.removePerspectiveListener(Listener);
    }

    public boolean getConnectLineMarkers() {
        Boolean m_Obj = (Boolean)this.getObjProp(Attr.ConnectLineMarkers);
        return m_Obj;
    }

    public void setConnectLineMarkers(boolean newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.ConnectLineMarkers, newValue);
    }

    public GraphConstants.ScatterLineType getScatterLineType() {
        GraphConstants.ScatterLineType m_Obj = (GraphConstants.ScatterLineType)((Object)this.getObjProp(Attr.ScatterLineType));
        return m_Obj;
    }

    public void setScatterLineType(GraphConstants.ScatterLineType type) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.ScatterLineType, (Object)type);
    }

    public GraphConstants.BubbleMarkerSizing getBubbleMarkerSizing() {
        return (GraphConstants.BubbleMarkerSizing)((Object)this.getObjProp(Attr.BubbleMarkerSizing));
    }

    public void setBubbleMarkerSizing(GraphConstants.BubbleMarkerSizing type) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.BubbleMarkerSizing, (Object)type);
    }

    public double getCubeFocusFactor() {
        Double m_Obj = (Double)this.getFromLookSimple(s_identObjGlobal, Attr.CubeFocusFactor);
        return m_Obj;
    }

    public void setCubeFocusFactor(double newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.CubeFocusFactor, new Double(newValue));
    }

    public void setO1LabelCallback(TDGNestedLabel cb) {
        this.m_O1LabelCallback = cb;
    }

    public TDGNestedLabel getO1LabelCallBack() {
        return this.m_O1LabelCallback;
    }

    public double getCubeSizeX() {
        Double m_Obj = (Double)this.getFromLookSimple(s_identObjGlobal, Attr.CubeSizeX);
        return m_Obj;
    }

    public void setCubeSizeX(double newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.CubeSizeX, new Double(newValue));
    }

    public double getCubeSizeY() {
        Double m_Obj = (Double)this.getFromLookSimple(s_identObjGlobal, Attr.CubeSizeY);
        return m_Obj;
    }

    public void setCubeSizeY(double newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.CubeSizeY, new Double(newValue));
    }

    public double getCubeSizeZ() {
        Double m_Obj = (Double)this.getFromLookSimple(s_identObjGlobal, Attr.CubeSizeZ);
        return m_Obj;
    }

    public void setCubeSizeZ(double newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.CubeSizeZ, new Double(newValue));
    }

    public double getCubeTranslationX() {
        Double m_Obj = (Double)this.getFromLookSimple(s_identObjGlobal, Attr.CubeTranslationX);
        return m_Obj;
    }

    public void setCubeTranslationX(double newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.CubeTranslationX, new Double(newValue));
    }

    public double getCubeTranslationY() {
        Double m_Obj = (Double)this.getFromLookSimple(s_identObjGlobal, Attr.CubeTranslationY);
        return m_Obj;
    }

    public void setCubeTranslationY(double newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.CubeTranslationY, new Double(newValue));
    }

    public double getCubeTranslationZ() {
        Double m_Obj = (Double)this.getFromLookSimple(s_identObjGlobal, Attr.CubeTranslationZ);
        return m_Obj;
    }

    public void setCubeTranslationZ(double newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.CubeTranslationZ, new Double(newValue));
    }

    public double getCubeViewerX() {
        Double m_Obj = (Double)this.getFromLookSimple(s_identObjGlobal, Attr.CubeViewerX);
        return m_Obj;
    }

    public void setCubeViewerX(double newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.CubeViewerX, new Double(newValue));
    }

    public double getCubeViewerY() {
        Double m_Obj = (Double)this.getFromLookSimple(s_identObjGlobal, Attr.CubeViewerY);
        return m_Obj;
    }

    public void setCubeViewerY(double newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.CubeViewerY, new Double(newValue));
    }

    public double getCubeViewerZ() {
        Double m_Obj = (Double)this.getFromLookSimple(s_identObjGlobal, Attr.CubeViewerZ);
        return m_Obj;
    }

    public void setCubeViewerZ(double newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.CubeViewerZ, new Double(newValue));
    }

    public boolean getCubeIsometricProjection() {
        Boolean m_Obj = (Boolean)this.getFromLookSimple(s_identObjGlobal, Attr.CubeIsometricProjection);
        return m_Obj;
    }

    public void setCubeIsometricProjection(boolean newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.CubeIsometricProjection, newValue);
    }

    public boolean getSquareMarkers() {
        Boolean m_Obj = (Boolean)this.getFromLookSimple(s_identObjGlobal, Attr.SquareMarkers);
        return m_Obj;
    }

    public void setSquareMarkers(boolean newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.SquareMarkers, newValue);
    }

    public boolean getCubeSquareRisers() {
        Boolean m_Obj = (Boolean)this.getFromLookSimple(s_identObjGlobal, Attr.CubeSquareRisers);
        return m_Obj;
    }

    public void setCubeSquareRisers(boolean newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.CubeSquareRisers, newValue);
    }

    public int getColorMode() {
        Integer m_Obj = (Integer)this.getObjProp(Attr.ColorMode);
        return m_Obj;
    }

    public void setColorMode(int newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.ColorMode, new Integer(newValue));
    }

    public boolean getAutoshading() {
        Boolean m_Obj = (Boolean)this.getFromLookSimple(s_identObjGlobal, Attr.Autoshading);
        return m_Obj;
    }

    public void setAutoshading(boolean newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.Autoshading, newValue);
    }

    public double getCubeWallThickX() {
        Double m_Obj = (Double)this.getFromLookSimple(s_identObjGlobal, Attr.CubeWallThickX);
        return m_Obj;
    }

    public void setCubeWallThickX(double newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.CubeWallThickX, new Double(newValue));
    }

    public double getCubeWallThickY() {
        Double m_Obj = (Double)this.getFromLookSimple(s_identObjGlobal, Attr.CubeWallThickY);
        return m_Obj;
    }

    public void setCubeWallThickY(double newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.CubeWallThickY, new Double(newValue));
    }

    public double getCubeWallThickZ() {
        Double m_Obj = (Double)this.getFromLookSimple(s_identObjGlobal, Attr.CubeWallThickZ);
        return m_Obj;
    }

    public void setCubeWallThickZ(double newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.CubeWallThickZ, new Double(newValue));
    }

    public double getCubeZoomFactor() {
        Double m_Obj = (Double)this.getFromLookSimple(s_identObjGlobal, Attr.CubeZoomFactor);
        return m_Obj;
    }

    public void setCubeZoomFactor(double newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.CubeZoomFactor, new Double(newValue));
    }

    public boolean getDataItemsAlongSeries() {
        Boolean m_Obj = (Boolean)this.getFromLookSimple(s_identObjGlobal, Attr.DataItemsAlongSeries);
        return m_Obj;
    }

    public void setDataItemsAlongSeries(boolean newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.DataItemsAlongSeries, newValue);
    }

    public int getDataTextFormat() {
        return this.getTextFormatPreset(s_identObjGlobal);
    }

    public void setDataTextFormat(int newValue) {
        this.setTextFormatPreset(s_identObjGlobal, newValue);
    }

    public int getDataTextAngleDefault() {
        return this.getDataTextAngle(s_identObjGlobal);
    }

    public void setDataTextAngleDefault(int newValue) {
        this.setDataTextAngle(s_identObjGlobal, newValue);
    }

    public boolean getDataTextDisplay() {
        return this.getDisplay(new IdentObj(260));
    }

    public void setDataTextDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(260), newValue);
    }

    public int getDataTextRadiusDefault() {
        return this.getDataTextRadius(s_identObjGlobal);
    }

    public void setDataTextRadiusDefault(int newValue) {
        this.setDataTextRadius(s_identObjGlobal, newValue);
    }

    public int getDepthAngle() {
        Integer m_Obj = (Integer)this.getObjProp(Attr.DepthAngle);
        return m_Obj;
    }

    public void setDepthAngle(int newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.DepthAngle, new Integer(newValue));
    }

    public int getDepthRadius() {
        Integer m_Obj = (Integer)this.getObjProp(Attr.DepthRadius);
        return m_Obj;
    }

    public void setDepthRadius(int newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.DepthRadius, new Integer(newValue));
    }

    public boolean getDisplay3DFloor() {
        return this.getDisplay(new IdentObj(603));
    }

    public void setDisplay3DFloor(boolean newValue) {
        this.setDisplay(new IdentObj(603), newValue);
    }

    public boolean getDisplay3DLeftWall() {
        return this.getDisplay(new IdentObj(604));
    }

    public void setDisplay3DLeftWall(boolean newValue) {
        this.setDisplay(new IdentObj(604), newValue);
    }

    public boolean getDisplay3DRightWall() {
        return this.getDisplay(new IdentObj(605));
    }

    public void setDisplay3DRightWall(boolean newValue) {
        this.setDisplay(new IdentObj(605), newValue);
    }

    public int getDualAxisSplitPosition() {
        Integer m_Obj = (Integer)this.getFromLookSimple(s_identObjGlobal, Attr.DualAxisSplitPosition);
        return m_Obj;
    }

    public void setDualAxisSplitPosition(int newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.DualAxisSplitPosition, new Integer(newValue));
    }

    public boolean getFootnoteAutofit() {
        return this.getAutofit(new IdentObj(3));
    }

    public void setFootnoteAutofit(boolean newValue) {
        this.setAutofit(new IdentObj(3), newValue);
    }

    public boolean getFootnoteDisplay() {
        return this.getDisplay(new IdentObj(3));
    }

    public void setFootnoteDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(3), newValue);
    }

    public String getFootnoteString() {
        return this.getTextString(new IdentObj(3));
    }

    public void setFootnoteString(String newValue) {
        this.setTextString(new IdentObj(3), newValue);
    }

    public boolean getFrameDisplay() {
        return this.getDisplay(new IdentObj(2));
    }

    public void setFrameDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(2), newValue);
    }

    public boolean getGrid3DFloorDisplayX() {
        return this.getDisplay(new IdentObj(614));
    }

    public void setGrid3DFloorDisplayX(boolean newValue) {
        this.setDisplay(new IdentObj(614), newValue);
    }

    public boolean getGrid3DFloorDisplayZ() {
        return this.getDisplay(new IdentObj(615));
    }

    public void setGrid3DFloorDisplayZ(boolean newValue) {
        this.setDisplay(new IdentObj(615), newValue);
    }

    public boolean getGrid3DLeftWallDisplayY() {
        return this.getDisplay(new IdentObj(616));
    }

    public void setGrid3DLeftWallDisplayY(boolean newValue) {
        this.setDisplay(new IdentObj(616), newValue);
    }

    public boolean getGrid3DLeftWallDisplayZ() {
        return this.getDisplay(new IdentObj(617));
    }

    public void setGrid3DLeftWallDisplayZ(boolean newValue) {
        this.setDisplay(new IdentObj(617), newValue);
    }

    public boolean getGrid3DRightWallDisplayX() {
        return this.getDisplay(new IdentObj(618));
    }

    public void setGrid3DRightWallDisplayX(boolean newValue) {
        this.setDisplay(new IdentObj(618), newValue);
    }

    public boolean getGrid3DRightWallDisplayY() {
        return this.getDisplay(new IdentObj(619));
    }

    public void setGrid3DRightWallDisplayY(boolean newValue) {
        this.setDisplay(new IdentObj(619), newValue);
    }

    public boolean getGrid3DRiserDisplayX() {
        return this.getDisplay(new IdentObj(607));
    }

    public void setGrid3DRiserDisplayX(boolean newValue) {
        this.setDisplay(new IdentObj(607), newValue);
    }

    public boolean getGrid3DRiserDisplayY() {
        return this.getDisplay(new IdentObj(608));
    }

    public void setGrid3DRiserDisplayY(boolean newValue) {
        this.setDisplay(new IdentObj(608), newValue);
    }

    public boolean getGrid3DRiserDisplayZ() {
        return this.getDisplay(new IdentObj(609));
    }

    public void setGrid3DRiserDisplayZ(boolean newValue) {
        this.setDisplay(new IdentObj(609), newValue);
    }

    public boolean getLegendAutomatic() {
        Boolean m_Obj = (Boolean)this.getFromLookSimple(s_identObjGlobal, Attr.LegendAutomatic);
        return m_Obj;
    }

    public void setLegendAutomatic(boolean newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.LegendAutomatic, newValue);
    }

    public boolean getLegendDisplay() {
        return this.getDisplay(new IdentObj(12));
    }

    public void setLegendDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(12), newValue);
    }

    public int getLegendMarkerPosition() {
        Integer m_Obj = (Integer)this.getFromLookSimple(s_identObjGlobal, Attr.LegendMarkerPosition);
        return m_Obj;
    }

    public void setLegendMarkerPosition(int newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.LegendMarkerPosition, new Integer(newValue));
    }

    public boolean getLegendTextAutofit() {
        return this.getAutofit(new IdentObj(14));
    }

    public void setLegendTextAutofit(boolean newValue) {
        this.setAutofit(new IdentObj(14), newValue);
    }

    public boolean getMarkerDisplay() {
        Boolean m_Obj = (Boolean)this.getMarkerDisplayObj();
        return m_Obj;
    }

    public Object getMarkerDisplayObj() {
        return this.getFromLookSimple(s_identObjGlobal, Attr.MarkerDisplay);
    }

    public void setMarkerDisplay(boolean newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.MarkerDisplay, newValue);
    }

    public int getMarkerSizeDefault() {
        Integer m_Obj = (Integer)this.getFromLookSimple(s_identObjGlobal, Attr.MarkerSize);
        return m_Obj;
    }

    public void setMarkerSizeDefault(int newValue) {
        this.setMarkerSize(s_identObjGlobal, newValue);
    }

    protected int getMarkerSizeUniqueness() {
        return this.m_markerSizeUniqueness;
    }

    public int getO1AxisSide() {
        return this.getAxisSide(new IdentObj(2001));
    }

    public void setO1AxisSide(int newValue) {
        this.setAxisSide(new IdentObj(2001), newValue);
    }

    public boolean getO1ExcludeMaxLabel() {
        return this.getExcludeMaxLabel(this.getO1Label());
    }

    public void setO1ExcludeMaxLabel(boolean newValue) {
        this.setExcludeMaxLabel(this.getO1Label(), newValue);
    }

    public boolean getO1ExcludeMinLabel() {
        return this.getExcludeMinLabel(this.getO1Label());
    }

    public void setO1ExcludeMinLabel(boolean newValue) {
        this.setExcludeMinLabel(this.getO1Label(), newValue);
    }

    public boolean getO1LabelAutofit() {
        return this.getAutofit(this.getO1Label());
    }

    public void setO1LabelAutofit(boolean newValue) {
        this.setAutofit(this.getO1Label(), newValue);
    }

    public boolean getO1LabelDisplay() {
        return this.getDisplay(this.getO1Label());
    }

    public void setO1LabelDisplay(boolean newValue) {
        this.setDisplay(this.getO1Label(), newValue);
    }

    public boolean getO1LabelStagger() {
        return this.getLabelStagger(this.getO1Label());
    }

    public void setO1LabelStagger(boolean newValue) {
        this.setLabelStagger(this.getO1Label(), newValue);
    }

    public boolean getO1LabelWrap() {
        return this.getTextWrap(this.getO1Label());
    }

    public void setO1LabelWrap(boolean newValue) {
        this.setTextWrap(this.getO1Label(), newValue);
    }

    public boolean getO1MajorGridDisplay() {
        return this.getDisplay(new IdentObj(271));
    }

    public void setO1MajorGridDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(271), newValue);
    }

    public int getO1MajorGridStyle() {
        return this.getGridStyle(new IdentObj(271));
    }

    public void setO1MajorGridStyle(int newValue) {
        this.setGridStyle(new IdentObj(271), newValue);
    }

    public boolean getO1MinorGridDisplay() {
        return this.getDisplay(new IdentObj(272));
    }

    public void setO1MinorGridDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(272), newValue);
    }

    public int getO1MinorGridStyle() {
        return this.getGridStyle(new IdentObj(272));
    }

    public void setO1MinorGridStyle(int newValue) {
        this.setGridStyle(new IdentObj(272), newValue);
    }

    public boolean getO1TitleAutofit() {
        return this.getAutofit(new IdentObj(8));
    }

    public void setO1TitleAutofit(boolean newValue) {
        this.setAutofit(new IdentObj(8), newValue);
    }

    public boolean getO1TitleDisplay() {
        return this.getDisplay(new IdentObj(8));
    }

    public void setO1TitleDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(8), newValue);
    }

    public String getO1TitleString() {
        return this.getTextString(new IdentObj(8));
    }

    public void setO1TitleString(String newValue) {
        this.setTextString(new IdentObj(8), newValue);
    }

    public boolean getO2ExcludeMaxLabel() {
        return this.getExcludeMaxLabel(this.getO2Label());
    }

    public void setO2ExcludeMaxLabel(boolean newValue) {
        this.setExcludeMaxLabel(this.getO2Label(), newValue);
    }

    public boolean getO2ExcludeMinLabel() {
        return this.getExcludeMinLabel(this.getO2Label());
    }

    public void setO2ExcludeMinLabel(boolean newValue) {
        this.setExcludeMinLabel(this.getO2Label(), newValue);
    }

    public boolean getO2LabelAutofit() {
        return this.getAutofit(this.getO2Label());
    }

    public void setO2LabelAutofit(boolean newValue) {
        this.setAutofit(this.getO2Label(), newValue);
    }

    public boolean getO2LabelDisplay() {
        return this.getDisplay(this.getO2Label());
    }

    public void setO2LabelDisplay(boolean newValue) {
        this.setDisplay(this.getO2Label(), newValue);
    }

    public boolean getStockCloseTicksDisplay() {
        return this.getDisplay(new IdentObj(307));
    }

    public void setStockCloseTicksDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(307), newValue);
    }

    public boolean getStockOpenTicksDisplay() {
        return this.getDisplay(new IdentObj(308));
    }

    public void setStockOpenTicksDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(308), newValue);
    }

    public boolean getStockCloseSplitDisplay() {
        return this.getDisplay(new IdentObj(306));
    }

    public void setStockCloseSplitDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(306), newValue);
    }

    public boolean getO2LabelWrap() {
        return this.getTextWrap(this.getO2Label());
    }

    public void setO2LabelWrap(boolean newValue) {
        this.setTextWrap(this.getO2Label(), newValue);
    }

    public boolean getO2TitleAutofit() {
        return this.getAutofit(new IdentObj(9));
    }

    public void setO2TitleAutofit(boolean newValue) {
        this.setAutofit(new IdentObj(9), newValue);
    }

    public boolean getO2TitleDisplay() {
        return this.getDisplay(new IdentObj(9));
    }

    public void setO2TitleDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(9), newValue);
    }

    public String getO2TitleString() {
        return this.getTextString(new IdentObj(9));
    }

    public void setO2TitleString(String newValue) {
        this.setTextString(new IdentObj(9), newValue);
    }

    public double getCubePanX() {
        Double m_Obj = (Double)this.getFromLookSimple(s_identObjGlobal, Attr.CubePanX);
        return m_Obj;
    }

    public void setCubePanX(double newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.CubePanX, new Double(newValue));
    }

    public double getCubePanY() {
        Double m_Obj = (Double)this.getFromLookSimple(s_identObjGlobal, Attr.CubePanY);
        return m_Obj;
    }

    public void setCubePanY(double newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.CubePanY, new Double(newValue));
    }

    public int getPieDepth() {
        Integer m_Obj = (Integer)this.getObjProp(Attr.PieDepth);
        return m_Obj;
    }

    public void setPieDepth(int newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.PieDepth, new Integer(newValue));
    }

    public int getPieFeelerTextDisplay() {
        Integer m_Obj = (Integer)this.getFromLookSimple(s_identObjGlobal, Attr.PieFeelerTextDisplay);
        return m_Obj;
    }

    public void setPieFeelerTextDisplay(int newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.PieFeelerTextDisplay, new Integer(newValue));
    }

    public int getPieFeelerTextFormat() {
        return this.getTextFormatPreset(new IdentObj(295));
    }

    public void setPieFeelerTextFormat(int newValue) {
        this.setTextFormatPreset(new IdentObj(295), newValue);
    }

    public int getPieLabelDisplay() {
        Integer m_Obj = (Integer)this.getFromLookSimple(s_identObjGlobal, Attr.PieLabelDisplay);
        return m_Obj;
    }

    public void setPieLabelDisplay(int newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.PieLabelDisplay, new Integer(newValue));
    }

    public int getFunnelLabelDisplay() {
        Integer m_Obj = (Integer)this.getFromLookSimple(s_identObjGlobal, Attr.FunnelLabelDisplay);
        return m_Obj;
    }

    public void setFunnelLabelDisplay(int newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.FunnelLabelDisplay, new Integer(newValue));
    }

    public double getFunnelViewAngle() {
        Double m_Obj = (Double)this.getFromLookSimple(s_identObjGlobal, Attr.FunnelViewAngle);
        return m_Obj;
    }

    public void setFunnelViewAngle(double newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.FunnelViewAngle, new Double(newValue));
    }

    public double getFunnelRotateAngle() {
        Double m_Obj = (Double)this.getFromLookSimple(s_identObjGlobal, Attr.FunnelRotateAngle);
        return m_Obj;
    }

    public void setFunnelRotateAngle(double newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.FunnelRotateAngle, new Double(newValue));
    }

    public void setFlashAnimation(boolean yesNo) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.FlashAnimation, yesNo);
    }

    public boolean isFlashAnimationOn() {
        Boolean m_Obj = (Boolean)this.getFromLookSimple(s_identObjGlobal, Attr.FlashAnimation);
        return m_Obj;
    }

    public double getFunnelHeightRatio() {
        Double m_Obj = (Double)this.getFromLookSimple(s_identObjGlobal, Attr.FunnelHeightRatio);
        return m_Obj;
    }

    public void setFunnelHeightRatio(double newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.FunnelHeightRatio, new Double(newValue));
    }

    public boolean isStandardShapeAndWidth() {
        Boolean m_Obj = (Boolean)this.getFromLookSimple(s_identObjGlobal, Attr.StandardShapeAndWidth);
        return m_Obj;
    }

    public boolean isLastStageOnly() {
        Boolean m_Obj = (Boolean)this.getFromLookSimple(s_identObjGlobal, Attr.LastStageOnly);
        return m_Obj;
    }

    public int getThresholdCount() {
        Integer m_Obj = (Integer)this.getObjProp(Attr.ThresholdCount);
        if (m_Obj != null) {
            return m_Obj;
        }
        return (Integer)Attr.ThresholdCount.getDefault();
    }

    public void setThresholdCount(int newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.ThresholdCount, new Integer(newValue));
    }

    public IdentObj getFunnelLines() {
        IdentObj identObj = new IdentObj(626);
        identObj.setMiscID(624);
        return identObj;
    }

    public IdentObj getFunnelLeftSurface() {
        IdentObj identObj = new IdentObj(626);
        identObj.setMiscID(623);
        return identObj;
    }

    public IdentObj getFunnelFrame() {
        return new IdentObj(620);
    }

    public IdentObj getFunnelSkeleton() {
        return new IdentObj(626);
    }

    public int getFunnelTextDisplay() {
        Integer m_Obj = (Integer)this.getFromLookSimple(s_identObjGlobal, Attr.FunnelTextDisplay);
        return m_Obj;
    }

    public void setFunnelTextDisplay(int newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.FunnelTextDisplay, new Integer(newValue));
    }

    public IdentObj getFunnelSlice() {
        return new IdentObj(621);
    }

    public int getFunnelTextFormat() {
        return this.getTextFormatPreset(new IdentObj(622));
    }

    public void setFunnelTextFormat(int newValue) {
        this.setTextFormatPreset(new IdentObj(622), newValue);
    }

    public IdentObj getFunnelSliceLabel(int g) {
        return new IdentObj(622, g);
    }

    public IdentObj getFunnelSliceLabel() {
        return new IdentObj(622);
    }

    public String getFunnelTextFormatPattern() {
        return this.getTextFormatPattern(new IdentObj(622));
    }

    public void setFunnelTextFormatPattern(String newValue) {
        this.setTextFormatPattern(new IdentObj(622), newValue);
    }

    public IdentObj getThreshold(int nThreshold) {
        IdentObj id = new IdentObj(517, nThreshold);
        id.setMiscID(nThreshold);
        return id;
    }

    public int getPieRingSize() {
        Integer m_Obj = (Integer)this.getFromLookSimple(s_identObjGlobal, Attr.PieRingSize);
        return m_Obj;
    }

    public void setPieRingSize(int newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.PieRingSize, new Integer(newValue));
    }

    public boolean getPieRingTotalDisplay() {
        return this.getDisplay(new IdentObj(297));
    }

    public void setPieRingTotalDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(297), newValue);
    }

    public int getPieRotate() {
        Integer m_Obj = (Integer)this.getObjProp(Attr.PieRotate);
        return m_Obj;
    }

    public void setPieRotate(int newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.PieRotate, new Integer(newValue));
    }

    public int getPiesPerRow() {
        Integer m_Obj = (Integer)this.getFromLookSimple(s_identObjGlobal, Attr.PiesPerRow);
        return m_Obj;
    }

    public void setPiesPerRow(int newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.PiesPerRow, new Integer(newValue));
    }

    public int getPieTilt() {
        Integer m_Obj = (Integer)this.getObjProp(Attr.PieTilt);
        return m_Obj;
    }

    public void setPieTilt(int newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.PieTilt, new Integer(newValue));
    }

    public boolean getReshapeEnable() {
        Boolean m_Obj = (Boolean)this.getFromLookSimple(s_identObjGlobal, Attr.ReshapeEnable);
        return m_Obj;
    }

    public void setReshapeEnable(boolean newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.ReshapeEnable, newValue);
    }

    public boolean getResizeBarMode() {
        Boolean m_Obj = (Boolean)this.getFromLookSimple(s_identObjGlobal, Attr.ResizeBarMode);
        return m_Obj;
    }

    public void setResizeBarMode(boolean newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.ResizeBarMode, newValue);
    }

    public int getGridCount() {
        Integer m_Obj = (Integer)this.getFromLook(Attr.GridCount);
        return m_Obj;
    }

    public int getGridCount(IdentObj id) {
        Integer m_Obj = (Integer)this.getFromLook(id, Attr.GridCount);
        return m_Obj;
    }

    public int getGridCount(int objectID) {
        return this.getGridCount(new IdentObj(objectID));
    }

    public void setGridCount(int newValue) {
        this.putToLookAndRepaint(Attr.GridCount, new Integer(newValue));
    }

    public void setGridCount(IdentObj id, int newValue) {
        this.putToLookAndRepaint(id, Attr.GridCount, new Integer(newValue));
    }

    public void setGridCount(int objectID, int newValue) {
        this.setGridCount(new IdentObj(objectID), newValue);
    }

    public double getStock52WeekHighValue() {
        Double m_Obj = (Double)this.getFromLookSimple(s_identObjGlobal, Attr.Stock52WeekHighValue);
        return m_Obj;
    }

    public void setStock52WeekHighValue(double newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.Stock52WeekHighValue, new Double(newValue));
    }

    public boolean getReverseGroups() {
        Boolean m_Obj = (Boolean)this.getFromLookSimple(s_identObjGlobal, Attr.ReverseGroups);
        return m_Obj;
    }

    public void setReverseGroups(boolean newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.ReverseGroups, newValue);
    }

    public boolean getReverseSeries() {
        Boolean m_Obj = (Boolean)this.getFromLookSimple(s_identObjGlobal, Attr.ReverseSeries);
        return m_Obj;
    }

    public void setReverseSeries(boolean newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.ReverseSeries, newValue);
    }

    public int getRiser3DThicknessY() {
        Integer m_Obj = (Integer)this.getFromLookSimple(s_identObjGlobal, Attr.Riser3DThicknessY);
        return m_Obj;
    }

    public void setRiser3DThicknessY(int newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.Riser3DThicknessY, new Integer(newValue));
    }

    public int getRiserBarGroupSpacing() {
        Integer m_Obj = (Integer)this.getFromLookSimple(s_identObjGlobal, Attr.RiserBarGroupSpacing);
        return m_Obj;
    }

    public void setRiserBarGroupSpacing(int newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.RiserBarGroupSpacing, new Integer(newValue));
    }

    public int getRiserWidth() {
        Integer m_Obj = (Integer)this.getFromLookSimple(s_identObjGlobal, Attr.RiserWidth);
        return m_Obj;
    }

    public void setRiserWidth(int newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.RiserWidth, new Integer(newValue));
    }

    public boolean getScaleFromZero() {
        Boolean m_Obj = (Boolean)this.getFromLookSimple(s_identObjGlobal, Attr.ScaleFromZero);
        return m_Obj;
    }

    public void setScaleFromZero(boolean newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.ScaleFromZero, newValue);
    }

    public int getSelectionEnable() {
        Integer m_Obj = (Integer)this.getObjProp(Attr.SelectionEnable);
        return m_Obj;
    }

    public void setSelectionEnable(int newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.SelectionEnable, new Integer(newValue));
    }

    public boolean getSelectionEnableMove() {
        Boolean m_Obj = (Boolean)this.getObjProp(Attr.SelectionEnableMove);
        return m_Obj;
    }

    public void setSelectionEnableMove(boolean newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.SelectionEnableMove, newValue);
    }

    public int getShadowXOffsetDefault() {
        Integer m_Obj = (Integer)this.getFromLookSimple(s_identObjGlobal, Attr.ShadowXOffsetDefault);
        return m_Obj;
    }

    public void setShadowXOffsetDefault(int newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.ShadowXOffsetDefault, new Integer(newValue));
    }

    public int getShadowYOffsetDefault() {
        Integer m_Obj = (Integer)this.getFromLookSimple(s_identObjGlobal, Attr.ShadowYOffsetDefault);
        return m_Obj;
    }

    public void setShadowYOffsetDefault(int newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.ShadowYOffsetDefault, new Integer(newValue));
    }

    public boolean getStock52WeekHighDisplay() {
        return this.getDisplay(new IdentObj(304));
    }

    public void setStock52WeekHighDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(304), newValue);
    }

    public boolean getStock52WeekLowDisplay() {
        return this.getDisplay(new IdentObj(305));
    }

    public void setStock52WeekLowDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(305), newValue);
    }

    public boolean getStockMovingAverageDisplay() {
        return this.getDisplay(new IdentObj(309));
    }

    public void setStockMovingAverageDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(309), newValue);
    }

    public int getStockTickLength() {
        Integer m_Obj = (Integer)this.getFromLookSimple(s_identObjGlobal, Attr.StockTickLength);
        return m_Obj;
    }

    public void setStockTickLength(int newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.StockTickLength, new Integer(newValue));
    }

    public boolean getSubtitleAutofit() {
        return this.getAutofit(new IdentObj(4));
    }

    public void setSubtitleAutofit(boolean newValue) {
        this.setAutofit(new IdentObj(4), newValue);
    }

    public boolean getSubtitleDisplay() {
        return this.getDisplay(new IdentObj(4));
    }

    public void setSubtitleDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(4), newValue);
    }

    public String getSubtitleString() {
        return this.getTextString(new IdentObj(4));
    }

    public void setSubtitleString(String newValue) {
        this.setTextString(new IdentObj(4), newValue);
    }

    public boolean getTitleAutofit() {
        return this.getAutofit(new IdentObj(5));
    }

    public void setTitleAutofit(boolean newValue) {
        this.setAutofit(new IdentObj(5), newValue);
    }

    public boolean getTitleDisplay() {
        return this.getDisplay(new IdentObj(5));
    }

    public void setTitleDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(5), newValue);
    }

    public String getTitleString() {
        return this.getTextString(new IdentObj(5));
    }

    public void setTitleString(String newValue) {
        this.setTextString(new IdentObj(5), newValue);
    }

    public boolean getToolTipDisplay() {
        Boolean m_Obj = (Boolean)this.getFromLookSimple(s_identObjGlobal, Attr.ToolTipDisplay);
        return m_Obj;
    }

    public void setToolTipDisplay(boolean newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.ToolTipDisplay, newValue);
    }

    public boolean getToolTipMode() {
        if (this.m_cachedToolTipMode == null) {
            this.m_cachedToolTipMode = (Boolean)this.getFromLookSimple(s_identObjGlobal, Attr.ToolTipMode);
        }
        return this.m_cachedToolTipMode;
    }

    public void setToolTipMode(boolean newValue) {
        this.m_cachedToolTipMode = null;
        this.putToLookAndRepaint(s_identObjGlobal, Attr.ToolTipMode, newValue);
    }

    public int getUseSeriesShapes() {
        Integer m_Obj = (Integer)this.getObjProp(Attr.UseSeriesShapes);
        return m_Obj;
    }

    public void setUseSeriesShapes(int newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.UseSeriesShapes, new Integer(newValue));
    }

    public int getViewing3DAnglePreset() {
        Integer m_Obj = (Integer)this.getFromLookSimple(s_identObjGlobal, Attr.Viewing3DAnglePreset);
        return m_Obj;
    }

    public void setViewing3DAnglePreset(int newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.Viewing3DAnglePreset, new Integer(newValue));
    }

    public boolean getX1AxisDescending() {
        return this.getAxisDescending(new IdentObj(2003));
    }

    public void setX1AxisDescending(boolean newValue) {
        this.setAxisDescending(new IdentObj(2003), newValue);
    }

    public int getX1AxisSide() {
        return this.getAxisSide(new IdentObj(2003));
    }

    public void setX1AxisSide(int newValue) {
        this.setAxisSide(new IdentObj(2003), newValue);
    }

    public boolean getX1OffScaleDisplay() {
        return this.getDisplayOffScale(new IdentObj(2003));
    }

    public void setX1OffScaleDisplay(boolean newValue) {
        this.setDisplayOffScale(new IdentObj(2003), newValue);
    }

    public boolean getX1ExcludeMaxLabel() {
        return this.getExcludeMaxLabel(new IdentObj(280));
    }

    public void setX1ExcludeMaxLabel(boolean newValue) {
        this.setExcludeMaxLabel(new IdentObj(280), newValue);
    }

    public boolean getX1ExcludeMinLabel() {
        return this.getExcludeMinLabel(new IdentObj(280));
    }

    public void setX1ExcludeMinLabel(boolean newValue) {
        this.setExcludeMinLabel(new IdentObj(280), newValue);
    }

    public boolean getX1LabelAutofit() {
        return this.getAutofit(new IdentObj(280));
    }

    public void setX1LabelAutofit(boolean newValue) {
        this.setAutofit(new IdentObj(280), newValue);
    }

    public boolean getY2TitleDisplay() {
        return this.getDisplay(new IdentObj(7));
    }

    public void setY2TitleDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(7), newValue);
    }

    public boolean getX1LabelDisplay() {
        return this.getDisplay(new IdentObj(280));
    }

    public void setX1LabelDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(280), newValue);
    }

    public int getX1LabelFormat() {
        return this.getTextFormatPreset(new IdentObj(280));
    }

    public void setX1LabelFormat(int newValue) {
        this.setTextFormatPreset(new IdentObj(280), newValue);
    }

    public boolean getX1LabelStagger() {
        return this.getLabelStagger(new IdentObj(280));
    }

    public void setX1LabelStagger(boolean newValue) {
        this.setLabelStagger(new IdentObj(280), newValue);
    }

    public boolean getX1LogScale() {
        return this.getLogScale(new IdentObj(2003));
    }

    public void setX1LogScale(boolean newValue) {
        this.setLogScale(new IdentObj(2003), newValue);
    }

    public boolean getX1MajorGridDisplay() {
        return this.getDisplay(new IdentObj(281));
    }

    public void setX1MajorGridDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(281), newValue);
    }

    public double getX1MajorGridStep() {
        return this.getGridStep(new IdentObj(281));
    }

    public void setX1MajorGridStep(double newValue) {
        this.setGridStep(new IdentObj(281), newValue);
    }

    public boolean getX1MajorGridStepAuto() {
        return this.getGridStepAuto(new IdentObj(281));
    }

    public void setX1MajorGridStepAuto(boolean newValue) {
        this.setGridStepAuto(new IdentObj(281), newValue);
    }

    public int getX1MajorGridStyle() {
        return this.getGridStyle(new IdentObj(281));
    }

    public void setX1MajorGridStyle(int newValue) {
        this.setGridStyle(new IdentObj(281), newValue);
    }

    public boolean getX1MinorGridDisplay() {
        return this.getDisplay(new IdentObj(282));
    }

    public void setX1MinorGridDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(282), newValue);
    }

    public double getX1MinorGridStep() {
        return this.getGridStep(new IdentObj(282));
    }

    public void setX1MinorGridStep(double newValue) {
        this.setGridStep(new IdentObj(282), newValue);
    }

    public boolean getX1MinorGridStepAuto() {
        return this.getGridStepAuto(new IdentObj(282));
    }

    public void setX1MinorGridStepAuto(boolean newValue) {
        this.setGridStepAuto(new IdentObj(282), newValue);
    }

    public int getX1MinorGridStyle() {
        return this.getGridStyle(new IdentObj(282));
    }

    public void setX1MinorGridStyle(int newValue) {
        this.setGridStyle(new IdentObj(282), newValue);
    }

    public boolean getX1MustIncludeZero() {
        if (this.getX1LogScale()) {
            return false;
        }
        return this.getScaleMustIncludeZero(new IdentObj(2003));
    }

    public void setX1MustIncludeZero(boolean newValue) {
        this.setScaleMustIncludeZero(new IdentObj(2003), newValue);
    }

    public double getX1ScaleMax() {
        return this.getScaleMax(new IdentObj(2003));
    }

    public void setX1ScaleMax(double newValue) {
        this.setScaleMax(new IdentObj(2003), newValue);
    }

    public boolean getX1ScaleMaxAuto() {
        return this.getScaleMaxAuto(new IdentObj(2003));
    }

    public void setX1ScaleMaxAuto(boolean newValue) {
        this.setScaleMaxAuto(new IdentObj(2003), newValue);
    }

    public double getX1ScaleMin() {
        return this.getScaleMin(new IdentObj(2003));
    }

    public void setX1ScaleMin(double newValue) {
        this.setScaleMin(new IdentObj(2003), newValue);
    }

    public boolean getX1ScaleMinAuto() {
        return this.getScaleMinAuto(new IdentObj(2003));
    }

    public void setX1ScaleMinAuto(boolean newValue) {
        this.setScaleMinAuto(new IdentObj(2003), newValue);
    }

    public Double getX1ScaleZoomMax() {
        return this.getScaleZoomMax(new IdentObj(2003));
    }

    public void setX1ScaleZoomMax(double newValue) {
        this.setScaleZoomMax(new IdentObj(2003), new Double(newValue));
    }

    public Double getX1ScaleZoomMin() {
        return this.getScaleZoomMin(new IdentObj(2003));
    }

    public void setX1ScaleZoomMin(double newValue) {
        this.setScaleZoomMin(new IdentObj(2003), new Double(newValue));
    }

    public boolean getX1TitleAutofit() {
        return this.getAutofit(new IdentObj(10));
    }

    public void setX1TitleAutofit(boolean newValue) {
        this.setAutofit(new IdentObj(10), newValue);
    }

    public boolean getX1TitleDisplay() {
        return this.getDisplay(new IdentObj(10));
    }

    public void setX1TitleDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(10), newValue);
    }

    public String getX1TitleString() {
        return this.getTextString(new IdentObj(10));
    }

    public void setX1TitleString(String newValue) {
        this.setTextString(new IdentObj(10), newValue);
    }

    public boolean getX1ZeroLineDisplay() {
        return this.getDisplay(new IdentObj(291));
    }

    public void setX1ZeroLineDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(291), newValue);
    }

    public boolean getY1AxisDescending() {
        return this.getAxisDescending(new IdentObj(2004));
    }

    public void setY1AxisDescending(boolean newValue) {
        this.setAxisDescending(new IdentObj(2004), newValue);
    }

    public int getY1AxisSide() {
        return this.getAxisSide(new IdentObj(2004));
    }

    public void setY1AxisSide(int newValue) {
        this.setAxisSide(new IdentObj(2004), newValue);
    }

    public boolean getY1OffScaleDisplay() {
        return this.getDisplayOffScale(new IdentObj(2004));
    }

    public void setY1OffScaleDisplay(boolean newValue) {
        this.setDisplayOffScale(new IdentObj(2004), newValue);
    }

    public boolean getY1ExcludeMaxLabel() {
        return this.getExcludeMaxLabel(new IdentObj(284));
    }

    public void setY1ExcludeMaxLabel(boolean newValue) {
        this.setExcludeMaxLabel(new IdentObj(284), newValue);
    }

    public int getO1LabelAutoSkip() {
        return this.getAutoSkip(this.getO1Label());
    }

    public void setO1LabelAutoSkip(int newValue) {
        this.setAutoSkip(this.getO1Label(), newValue);
    }

    public int getO1LabelSkipCount() {
        return this.getSkipCount(this.getO1Label());
    }

    public void setO1LabelSkipCount(int newValue) {
        this.setSkipCount(this.getO1Label(), newValue);
    }

    public int getO1LabelSkipBegin() {
        return this.getSkipBegin(this.getO1Label());
    }

    public void setO1LabelSkipBegin(int newValue) {
        this.setSkipBegin(this.getO1Label(), newValue);
    }

    public int getAutoSkip() {
        Integer m_Obj = (Integer)this.getFromLook(Attr.AutoSkip);
        return m_Obj;
    }

    public int getAutoSkip(IdentObj id) {
        Integer m_Obj = (Integer)this.getAutoSkipObj(id);
        return m_Obj;
    }

    public Object getAutoSkipObj(IdentObj id) {
        return this.getFromLook(id, Attr.AutoSkip);
    }

    public int getAutoSkip(int objectID) {
        return this.getAutoSkip(new IdentObj(objectID));
    }

    public void setAutoSkip(int newValue) {
        this.putToLookAndRepaint(Attr.AutoSkip, new Integer(newValue));
    }

    public void setAutoSkip(IdentObj id, int newValue) {
        this.putToLookAndRepaint(id, Attr.AutoSkip, new Integer(newValue));
    }

    public void setAutoSkip(int objectID, int newValue) {
        this.setAutoSkip(new IdentObj(objectID), newValue);
    }

    public int getSkipBegin() {
        Integer m_Obj = (Integer)this.getFromLook(Attr.SkipBegin);
        return m_Obj;
    }

    public int getSkipBegin(IdentObj id) {
        Integer m_Obj = (Integer)this.getSkipBeginObj(id);
        return m_Obj;
    }

    public Object getSkipBeginObj(IdentObj id) {
        return this.getFromLook(id, Attr.SkipBegin);
    }

    public int getSkipBegin(int objectID) {
        return this.getSkipBegin(new IdentObj(objectID));
    }

    public void setSkipBegin(int newValue) {
        this.putToLookAndRepaint(Attr.SkipBegin, new Integer(newValue));
    }

    public void setSkipBegin(IdentObj id, int newValue) {
        this.putToLookAndRepaint(id, Attr.SkipBegin, new Integer(newValue));
    }

    public void setSkipBegin(int objectID, int newValue) {
        this.setSkipBegin(new IdentObj(objectID), newValue);
    }

    public int getSkipCount() {
        Integer m_Obj = (Integer)this.getFromLook(Attr.SkipCount);
        return m_Obj;
    }

    public int getSkipCount(IdentObj id) {
        Integer m_Obj = (Integer)this.getSkipCountObj(id);
        return m_Obj;
    }

    public Object getSkipCountObj(IdentObj id) {
        return this.getFromLook(id, Attr.SkipCount);
    }

    public int getSkipCount(int objectID) {
        return this.getSkipCount(new IdentObj(objectID));
    }

    public void setSkipCount(int newValue) {
        this.putToLookAndRepaint(Attr.SkipCount, new Integer(newValue));
    }

    public void setSkipCount(IdentObj id, int newValue) {
        this.putToLookAndRepaint(id, Attr.SkipCount, new Integer(newValue));
    }

    public void setSkipCount(int objectID, int newValue) {
        this.setSkipCount(new IdentObj(objectID), newValue);
    }

    public boolean getExactColorByHeight() {
        Boolean m_Obj = (Boolean)this.getFromLookSimple(s_identObjGlobal, Attr.ExactColorByHeight);
        return m_Obj;
    }

    public void setExactColorByHeight(boolean newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.ExactColorByHeight, newValue);
    }

    public int getViewableSeries() {
        Integer m_Obj = (Integer)this.getObjProp(Attr.ViewableSeries);
        return m_Obj;
    }

    public void setViewableSeries(int newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.ViewableSeries, new Integer(newValue));
    }

    public int getViewableGroups() {
        Integer m_Obj = (Integer)this.getObjProp(Attr.ViewableGroups);
        return m_Obj;
    }

    public void setViewableGroups(int newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.ViewableGroups, new Integer(newValue));
    }

    public int getViewableSeriesStock() {
        Integer m_Obj = (Integer)this.getFromLookSimple(s_identObjGlobal, Attr.ViewableSeriesStock);
        return m_Obj;
    }

    public void setViewableSeriesStock(int newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.ViewableSeriesStock, new Integer(newValue));
    }

    public int getViewableGroupsStock() {
        Integer m_Obj = (Integer)this.getFromLookSimple(s_identObjGlobal, Attr.ViewableGroupsStock);
        return m_Obj;
    }

    public void setViewableGroupsStock(int newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.ViewableGroupsStock, new Integer(newValue));
    }

    public int getScrollOffsetSeries() {
        Integer m_Obj = (Integer)this.getObjProp(Attr.ScrollOffsetSeries);
        return m_Obj;
    }

    public void setScrollOffsetSeries(int newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.ScrollOffsetSeries, new Integer(newValue));
    }

    public int getScrollOffsetGroup() {
        Integer m_Obj = (Integer)this.getObjProp(Attr.ScrollOffsetGroup);
        return m_Obj;
    }

    public void setScrollOffsetGroup(int newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.ScrollOffsetGroup, new Integer(newValue));
    }

    public int getSeriesLooping() {
        if (this.m_cachedSeriesLooping <= 0) {
            Integer m_Obj = (Integer)this.getObjProp(Attr.SeriesLooping);
            this.m_cachedSeriesLooping = m_Obj != null ? m_Obj.intValue() : ((Integer)Attr.SeriesLooping.getDefault()).intValue();
        }
        return this.m_cachedSeriesLooping;
    }

    public void setSeriesLooping(int newValue) {
        int i;
        int[] oldEffect;
        if (newValue > this.m_seriesGradientEffect.length) {
            oldEffect = this.m_seriesGradientEffect;
            this.m_seriesGradientEffect = new int[newValue];
            System.arraycopy(oldEffect, 0, this.m_seriesGradientEffect, 0, oldEffect.length);
            for (i = oldEffect.length; i < this.m_seriesGradientEffect.length; ++i) {
                this.m_seriesGradientEffect[i] = 0;
            }
        }
        if (newValue > this.m_seriesPatternEffect.length) {
            oldEffect = this.m_seriesPatternEffect;
            this.m_seriesPatternEffect = new int[newValue];
            System.arraycopy(oldEffect, 0, this.m_seriesPatternEffect, 0, oldEffect.length);
            for (i = oldEffect.length; i < this.m_seriesPatternEffect.length; ++i) {
                this.m_seriesPatternEffect[i] = 0;
            }
        }
        this.putToLookAndRepaint(s_identObjGlobal, Attr.SeriesLooping, new Integer(newValue));
        this.m_cachedSeriesLooping = -1;
    }

    public double getZoomPercentage() {
        Double m_Obj = (Double)this.getFromLookSimple(s_identObjGlobal, Attr.ZoomPercentage);
        return m_Obj;
    }

    public void setZoomPercentage(double newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.ZoomPercentage, new Double(newValue));
    }

    public int getRiserBorderMode() {
        Integer m_Obj = (Integer)this.getFromLookSimple(s_identObjGlobal, Attr.RiserBorderMode);
        return m_Obj;
    }

    public void setRiserBorderMode(int newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.RiserBorderMode, new Integer(newValue));
    }

    public boolean getOtherSeries() {
        Boolean m_Obj = (Boolean)this.getFromLookSimple(s_identObjGlobal, Attr.OtherSeries);
        return m_Obj;
    }

    public void setOtherSeries(boolean newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.OtherSeries, newValue);
    }

    public double getOtherPercentage() {
        Double m_Obj = (Double)this.getFromLookSimple(s_identObjGlobal, Attr.OtherPercentage);
        return m_Obj;
    }

    public void setOtherPercentage(double newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.OtherPercentage, new Double(newValue));
    }

    public int getCubeRiserInterpolation() {
        Integer m_Obj = (Integer)this.getFromLookSimple(s_identObjGlobal, Attr.CubeRiserInterpolation);
        return m_Obj;
    }

    public void setCubeRiserInterpolation(int newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.CubeRiserInterpolation, new Integer(newValue));
    }

    public boolean getOverdrawSkip() {
        Boolean m_Obj = (Boolean)this.getFromLookSimple(s_identObjGlobal, Attr.OverdrawSkip);
        return m_Obj;
    }

    public void setOverdrawSkip(boolean newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.OverdrawSkip, newValue);
    }

    public boolean getInterpretAsHLOC() {
        Boolean m_Obj = (Boolean)this.getFromLookSimple(s_identObjGlobal, Attr.InterpretAsHLOC);
        return m_Obj;
    }

    public void setInterpretAsHLOC(boolean newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.InterpretAsHLOC, newValue);
    }

    public boolean getUseSeriesBorderDefaults() {
        Boolean m_Obj = (Boolean)this.getFromLookSimple(s_identObjGlobal, Attr.UseSeriesBorderDefaults);
        if (m_Obj != null) {
            return m_Obj;
        }
        m_Obj = (Boolean)Attr.UseSeriesBorderDefaults.getDefault();
        return m_Obj;
    }

    public void setUseSeriesBorderDefaults(boolean newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.UseSeriesBorderDefaults, newValue);
    }

    public Color getSeriesDefaultBorderColor() {
        Color m_Obj = (Color)this.getFromLookSimple(s_identObjGlobal, Attr.SeriesDefaultBorderColor);
        return m_Obj;
    }

    public void setSeriesDefaultBorderColor(Color newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.SeriesDefaultBorderColor, newValue);
    }

    public boolean getSeriesDefaultTransparentBorderColor() {
        Boolean m_Obj = (Boolean)this.getSeriesDefaultTransparentBorderColorObj();
        return m_Obj;
    }

    public Object getSeriesDefaultTransparentBorderColorObj() {
        return this.getFromLookSimple(s_identObjGlobal, Attr.SeriesDefaultTransparentBorderColor);
    }

    public void setSeriesDefaultTransparentBorderColor(boolean newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.SeriesDefaultTransparentBorderColor, newValue);
    }

    public boolean getStackedDataValueSum() {
        Boolean m_Obj = (Boolean)this.getFromLookSimple(s_identObjGlobal, Attr.StackedDataValueSum);
        return m_Obj;
    }

    public void setStackedDataValueSum(boolean newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.StackedDataValueSum, newValue);
    }

    public int getValidGroupsMin() {
        Integer m_Obj = (Integer)this.getFromLookSimple(s_identObjGlobal, Attr.ValidGroupsMin);
        return m_Obj;
    }

    public void setValidGroupsMin(int newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.ValidGroupsMin, new Integer(newValue));
    }

    public int getValidSeriesMin() {
        Integer m_Obj = (Integer)this.getFromLookSimple(s_identObjGlobal, Attr.ValidSeriesMin);
        return m_Obj;
    }

    public void setValidSeriesMin(int newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.ValidSeriesMin, new Integer(newValue));
    }

    public int getCurveFitType() {
        Integer m_Obj = (Integer)this.getFromLook(Attr.CurveFitType, 1);
        return m_Obj;
    }

    public int getCurveFitType(IdentObj id) {
        Integer m_Obj = (Integer)this.getCurveFitTypeObj(id);
        return m_Obj;
    }

    public Object getCurveFitTypeObj(IdentObj id) {
        return this.getFromLook(id, Attr.CurveFitType);
    }

    public int getCurveFitType(int seriesID) {
        IdentObj id = new IdentObj(-3, seriesID, -3);
        return this.getCurveFitType(id);
    }

    public void setCurveFitType(int newValue) {
        this.putToLookAndRepaint(Attr.CurveFitType, new Integer(newValue), 1);
    }

    public void setCurveFitType(IdentObj id, int newValue) {
        this.putToLookAndRepaint(id, Attr.CurveFitType, new Integer(newValue));
    }

    public void setCurveFitType(int seriesID, int newValue) {
        IdentObj id = new IdentObj(-3, seriesID, -3);
        this.setCurveFitType(id, newValue);
    }

    public int getCurveFitPolynomialOrder() {
        Integer m_Obj = (Integer)this.getFromLook(Attr.CurveFitPolynomialOrder, 1);
        return m_Obj;
    }

    public int getCurveFitPolynomialOrder(IdentObj id) {
        Integer m_Obj = (Integer)this.getFromLook(id, Attr.CurveFitPolynomialOrder);
        return m_Obj;
    }

    public int getCurveFitPolynomialOrder(int seriesID) {
        IdentObj id = new IdentObj(-3, seriesID, -3);
        return this.getCurveFitPolynomialOrder(id);
    }

    public void setCurveFitPolynomialOrder(int newValue) {
        this.putToLookAndRepaint(Attr.CurveFitPolynomialOrder, new Integer(newValue), 1);
    }

    public void setCurveFitPolynomialOrder(IdentObj id, int newValue) {
        this.putToLookAndRepaint(id, Attr.CurveFitPolynomialOrder, new Integer(newValue));
    }

    public void setCurveFitPolynomialOrder(int seriesID, int newValue) {
        IdentObj id = new IdentObj(-3, seriesID, -3);
        this.setCurveFitPolynomialOrder(id, newValue);
    }

    public int getCurveFitNumSegments() {
        Integer m_Obj = (Integer)this.getFromLookSimple(s_identObjGlobal, Attr.CurveFitNumSegments);
        return m_Obj;
    }

    public void setCurveFitNumSegments(int newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.CurveFitNumSegments, new Integer(newValue));
    }

    public boolean getCurveFitEquationDisplay() {
        return this.getDisplay(new IdentObj(42));
    }

    public void setCurveFitEquationDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(42), newValue);
    }

    public boolean getCurveFitHighOrderFirst() {
        Boolean m_Obj = (Boolean)this.getFromLookSimple(s_identObjGlobal, Attr.CurveFitHighOrderFirst);
        return m_Obj;
    }

    public void setCurveFitHighOrderFirst(boolean newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.CurveFitHighOrderFirst, newValue);
    }

    public int getDeadZonePercent() {
        Integer m_Obj = (Integer)this.getFromLookSimple(s_identObjGlobal, Attr.DeadZonePercent);
        return m_Obj;
    }

    public void setDeadZonePercent(int newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.DeadZonePercent, new Integer(newValue));
    }

    public boolean getDisplaySystemConsoleMessages() {
        return this.getDisplay(s_identObjGlobal);
    }

    public void setDisplaySystemConsoleMessages(boolean newValue) {
        this.setDisplay(s_identObjGlobal, newValue);
    }

    public int getFillMissingData() {
        Integer m_Obj = (Integer)this.getFromLookSimple(s_identObjGlobal, Attr.FillMissingData);
        return m_Obj;
    }

    public void setFillMissingData(int newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.FillMissingData, new Integer(newValue));
    }

    public int getNumMissingDataSegments() {
        Integer m_Obj = (Integer)this.getFromLookSimple(s_identObjGlobal, Attr.NumMissingDataSegments);
        return m_Obj;
    }

    public void setNumMissingDataSegments(int newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.NumMissingDataSegments, new Integer(newValue));
    }

    public boolean getFontSizeAbsolute() {
        Boolean m_Obj = (Boolean)this.getFromLook(Attr.FontSizeAbsolute);
        return m_Obj;
    }

    public boolean getFontSizeAbsolute(IdentObj id) {
        Boolean m_Obj = (Boolean)this.getFontSizeAbsoluteObj(id);
        return m_Obj;
    }

    public Object getFontSizeAbsoluteObj(IdentObj id) {
        return this.getFromLook(id, Attr.FontSizeAbsolute);
    }

    public boolean getFontSizeAbsolute(int objectID) {
        return this.getFontSizeAbsolute(new IdentObj(objectID));
    }

    public void setFontSizeAbsolute(boolean newValue) {
        this.putToLookAndRepaint(Attr.FontSizeAbsolute, newValue);
    }

    public void setFontSizeAbsolute(IdentObj id, boolean newValue) {
        this.putToLookAndRepaint(id, Attr.FontSizeAbsolute, newValue);
    }

    public void setFontSizeAbsolute(int objectID, boolean newValue) {
        this.setFontSizeAbsolute(new IdentObj(objectID), newValue);
    }

    public int getLegendSeriesStart() {
        Integer m_Obj = (Integer)this.getObjProp(Attr.LegendSeriesStart);
        return m_Obj;
    }

    public void setLegendSeriesStart(int newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.LegendSeriesStart, new Integer(newValue));
    }

    public int getLegendSeriesCount() {
        Integer m_Obj = (Integer)this.getObjProp(Attr.LegendSeriesCount);
        return m_Obj;
    }

    public void setLegendSeriesCount(int newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.LegendSeriesCount, new Integer(newValue));
    }

    public int getLegendMarkerSize() {
        Integer m_Obj = (Integer)this.getFromLookSimple(s_identObjGlobal, Attr.LegendMarkerSize);
        return m_Obj;
    }

    public void setLegendMarkerSize(int newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.LegendMarkerSize, new Integer(newValue));
    }

    public int getLegendMarkerSizeMax() {
        return 1000;
    }

    public void setLegendMarkerSizeMax(int newValue) {
    }

    public int getO1LabelAutoAngle() {
        Integer m_Obj = (Integer)this.getFromLookSimple(s_identObjGlobal, Attr.O1LabelAutoAngle);
        return m_Obj;
    }

    public void setO1LabelAutoAngle(int newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.O1LabelAutoAngle, new Integer(newValue));
    }

    public int getLegendScroll() {
        Integer m_Obj = (Integer)this.getObjProp(Attr.LegendScroll);
        return m_Obj;
    }

    public void setLegendScroll(int newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.LegendScroll, new Integer(newValue));
    }

    public int getO2LabelAutoSkip() {
        return this.getAutoSkip(this.getO2Label());
    }

    public void setO2LabelAutoSkip(int newValue) {
        this.setAutoSkip(this.getO2Label(), newValue);
    }

    public int getO2LabelSkipCount() {
        return this.getSkipCount(this.getO2Label());
    }

    public void setO2LabelSkipCount(int newValue) {
        this.setSkipCount(this.getO2Label(), newValue);
    }

    public int getO2LabelSkipBegin() {
        return this.getSkipBegin(this.getO2Label());
    }

    public void setO2LabelSkipBegin(int newValue) {
        this.setSkipBegin(this.getO2Label(), newValue);
    }

    public boolean getY1ExcludeMinLabel() {
        return this.getExcludeMinLabel(new IdentObj(284));
    }

    public void setY1ExcludeMinLabel(boolean newValue) {
        this.setExcludeMinLabel(new IdentObj(284), newValue);
    }

    public boolean getY1LabelAutofit() {
        return this.getAutofit(new IdentObj(284));
    }

    public void setY1LabelAutofit(boolean newValue) {
        this.setAutofit(new IdentObj(284), newValue);
    }

    public boolean getY1LabelDisplay() {
        return this.getDisplay(new IdentObj(284));
    }

    public void setY1LabelDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(284), newValue);
    }

    public int getY1LabelFormat() {
        return this.getTextFormatPreset(new IdentObj(284));
    }

    public void setY1LabelFormat(int newValue) {
        this.setTextFormatPreset(new IdentObj(284), newValue);
    }

    public boolean getY1LabelStagger() {
        return this.getLabelStagger(new IdentObj(284));
    }

    public void setY1LabelStagger(boolean newValue) {
        this.setLabelStagger(new IdentObj(284), newValue);
    }

    public boolean getY1LogScale() {
        return this.getLogScale(new IdentObj(2004));
    }

    public void setY1LogScale(boolean newValue) {
        this.setLogScale(new IdentObj(2004), newValue);
    }

    public boolean getY1MajorGridDisplay() {
        return this.getDisplay(new IdentObj(285));
    }

    public void setY1MajorGridDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(285), newValue);
    }

    public double getY1MajorGridStep() {
        return this.getGridStep(new IdentObj(285));
    }

    public void setY1MajorGridStep(double newValue) {
        this.setGridStep(new IdentObj(285), newValue);
    }

    public boolean getY1MajorGridStepAuto() {
        return this.getGridStepAuto(new IdentObj(285));
    }

    public void setY1MajorGridStepAuto(boolean newValue) {
        this.setGridStepAuto(new IdentObj(285), newValue);
    }

    public int getY1MajorGridStyle() {
        return this.getGridStyle(new IdentObj(285));
    }

    public void setY1MajorGridStyle(int newValue) {
        this.setGridStyle(new IdentObj(285), newValue);
    }

    public boolean getY1MinorGridDisplay() {
        return this.getDisplay(new IdentObj(286));
    }

    public void setY1MinorGridDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(286), newValue);
    }

    public double getY1MinorGridStep() {
        return this.getGridStep(new IdentObj(286));
    }

    public void setY1MinorGridStep(double newValue) {
        this.setGridStep(new IdentObj(286), newValue);
    }

    public boolean getY1MinorGridStepAuto() {
        return this.getGridStepAuto(new IdentObj(286));
    }

    public void setY1MinorGridStepAuto(boolean newValue) {
        this.setGridStepAuto(new IdentObj(286), newValue);
    }

    public int getY1MinorGridStyle() {
        return this.getGridStyle(new IdentObj(286));
    }

    public void setY1MinorGridStyle(int newValue) {
        this.setGridStyle(new IdentObj(286), newValue);
    }

    public boolean getY1MustIncludeZero() {
        if (this.getY1LogScale()) {
            return false;
        }
        return this.getScaleMustIncludeZero(new IdentObj(2004));
    }

    public void setY1MustIncludeZero(boolean newValue) {
        this.setScaleMustIncludeZero(new IdentObj(2004), newValue);
    }

    public double getY1ScaleMax() {
        return this.getScaleMax(new IdentObj(2004));
    }

    public void setY1ScaleMax(double newValue) {
        this.setScaleMax(new IdentObj(2004), newValue);
    }

    public boolean getY1ScaleMaxAuto() {
        return this.getScaleMaxAuto(new IdentObj(2004));
    }

    public void setY1ScaleMaxAuto(boolean newValue) {
        this.setScaleMaxAuto(new IdentObj(2004), newValue);
    }

    public double getY1ScaleMin() {
        return this.getScaleMin(new IdentObj(2004));
    }

    public void setY1ScaleMin(double newValue) {
        this.setScaleMin(new IdentObj(2004), newValue);
    }

    public boolean getY1ScaleMinAuto() {
        return this.getScaleMinAuto(new IdentObj(2004));
    }

    public void setY1ScaleMinAuto(boolean newValue) {
        this.setScaleMinAuto(new IdentObj(2004), newValue);
    }

    public Double getY1ScaleZoomMax() {
        return this.getScaleZoomMax(new IdentObj(2004));
    }

    public void setY1ScaleZoomMax(double newValue) {
        this.setScaleZoomMax(new IdentObj(2004), new Double(newValue));
    }

    public Double getY1ScaleZoomMin() {
        return this.getScaleZoomMin(new IdentObj(2004));
    }

    public void setY1ScaleZoomMin(double newValue) {
        this.setScaleZoomMin(new IdentObj(2004), new Double(newValue));
    }

    public boolean getY1TitleAutofit() {
        return this.getAutofit(new IdentObj(6));
    }

    public void setY1TitleAutofit(boolean newValue) {
        this.setAutofit(new IdentObj(6), newValue);
    }

    public boolean getY1TitleDisplay() {
        return this.getDisplay(new IdentObj(6));
    }

    public void setY1TitleDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(6), newValue);
    }

    public String getY1TitleString() {
        return this.getTextString(new IdentObj(6));
    }

    public void setY1TitleString(String newValue) {
        this.setTextString(new IdentObj(6), newValue);
    }

    public boolean getY1ZeroLineDisplay() {
        return this.getDisplay(new IdentObj(292));
    }

    public void setY1ZeroLineDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(292), newValue);
    }

    public boolean getY2AxisDescending() {
        return this.getAxisDescending(new IdentObj(2005));
    }

    public void setY2AxisDescending(boolean newValue) {
        this.setAxisDescending(new IdentObj(2005), newValue);
    }

    public int getY2AxisSide() {
        return this.getAxisSide(new IdentObj(2005));
    }

    public void setY2AxisSide(int newValue) {
        this.setAxisSide(new IdentObj(2005), newValue);
    }

    public boolean getY2OffScaleDisplay() {
        return this.getDisplayOffScale(new IdentObj(2005));
    }

    public void setY2OffScaleDisplay(boolean newValue) {
        this.setDisplayOffScale(new IdentObj(2005), newValue);
    }

    public boolean getY2ExcludeMaxLabel() {
        return this.getExcludeMaxLabel(new IdentObj(288));
    }

    public void setY2ExcludeMaxLabel(boolean newValue) {
        this.setExcludeMaxLabel(new IdentObj(288), newValue);
    }

    public boolean getY2ExcludeMinLabel() {
        return this.getExcludeMinLabel(new IdentObj(288));
    }

    public void setY2ExcludeMinLabel(boolean newValue) {
        this.setExcludeMinLabel(new IdentObj(288), newValue);
    }

    public boolean getY2LabelAutofit() {
        return this.getAutofit(new IdentObj(288));
    }

    public void setY2LabelAutofit(boolean newValue) {
        this.setAutofit(new IdentObj(288), newValue);
    }

    public boolean getY2LabelDisplay() {
        return this.getDisplay(new IdentObj(288));
    }

    public void setY2LabelDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(288), newValue);
    }

    public int getY2LabelFormat() {
        return this.getTextFormatPreset(new IdentObj(288));
    }

    public void setY2LabelFormat(int newValue) {
        this.setTextFormatPreset(new IdentObj(288), newValue);
    }

    public boolean getY2LabelStagger() {
        return this.getLabelStagger(new IdentObj(288));
    }

    public void setY2LabelStagger(boolean newValue) {
        this.setLabelStagger(new IdentObj(288), newValue);
    }

    public boolean getY2LogScale() {
        return this.getLogScale(new IdentObj(2005));
    }

    public void setY2LogScale(boolean newValue) {
        this.setLogScale(new IdentObj(2005), newValue);
    }

    public boolean getY2MajorGridDisplay() {
        return this.getDisplay(new IdentObj(289));
    }

    public void setY2MajorGridDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(289), newValue);
    }

    public double getY2MajorGridStep() {
        return this.getGridStep(new IdentObj(289));
    }

    public void setY2MajorGridStep(double newValue) {
        this.setGridStep(new IdentObj(289), newValue);
    }

    public boolean getY2MajorGridStepAuto() {
        return this.getGridStepAuto(new IdentObj(289));
    }

    public void setY2MajorGridStepAuto(boolean newValue) {
        this.setGridStepAuto(new IdentObj(289), newValue);
    }

    public int getY2MajorGridStyle() {
        return this.getGridStyle(new IdentObj(289));
    }

    public void setY2MajorGridStyle(int newValue) {
        this.setGridStyle(new IdentObj(289), newValue);
    }

    public boolean getY2MinorGridDisplay() {
        return this.getDisplay(new IdentObj(290));
    }

    public void setY2MinorGridDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(290), newValue);
    }

    public double getY2MinorGridStep() {
        return this.getGridStep(new IdentObj(290));
    }

    public void setY2MinorGridStep(double newValue) {
        this.setGridStep(new IdentObj(290), newValue);
    }

    public boolean getY2MinorGridStepAuto() {
        return this.getGridStepAuto(new IdentObj(290));
    }

    public void setY2MinorGridStepAuto(boolean newValue) {
        this.setGridStepAuto(new IdentObj(290), newValue);
    }

    public int getY2MinorGridStyle() {
        return this.getGridStyle(new IdentObj(290));
    }

    public void setY2MinorGridStyle(int newValue) {
        this.setGridStyle(new IdentObj(290), newValue);
    }

    public boolean getY2MustIncludeZero() {
        if (this.getY2LogScale()) {
            return false;
        }
        return this.getScaleMustIncludeZero(new IdentObj(2005));
    }

    public void setY2MustIncludeZero(boolean newValue) {
        this.setScaleMustIncludeZero(new IdentObj(2005), newValue);
    }

    public double getY2ScaleMax() {
        return this.getScaleMax(new IdentObj(2005));
    }

    public void setY2ScaleMax(double newValue) {
        this.setScaleMax(new IdentObj(2005), newValue);
    }

    public boolean getY2ScaleMaxAuto() {
        return this.getScaleMaxAuto(new IdentObj(2005));
    }

    public void setY2ScaleMaxAuto(boolean newValue) {
        this.setScaleMaxAuto(new IdentObj(2005), newValue);
    }

    public double getY2ScaleMin() {
        return this.getScaleMin(new IdentObj(2005));
    }

    public void setY2ScaleMin(double newValue) {
        this.setScaleMin(new IdentObj(2005), newValue);
    }

    public boolean getY2ScaleMinAuto() {
        return this.getScaleMinAuto(new IdentObj(2005));
    }

    public void setY2ScaleMinAuto(boolean newValue) {
        this.setScaleMinAuto(new IdentObj(2005), newValue);
    }

    public Double getY2ScaleZoomMax() {
        return this.getScaleZoomMax(new IdentObj(2005));
    }

    public void setY2ScaleZoomMax(double newValue) {
        this.setScaleZoomMax(new IdentObj(2005), new Double(newValue));
    }

    public Double getY2ScaleZoomMin() {
        return this.getScaleZoomMin(new IdentObj(2005));
    }

    public void setY2ScaleZoomMin(double newValue) {
        this.setScaleZoomMin(new IdentObj(2005), new Double(newValue));
    }

    public boolean getY2TitleAutofit() {
        return this.getAutofit(new IdentObj(7));
    }

    public void setY2TitleAutofit(boolean newValue) {
        this.setAutofit(new IdentObj(7), newValue);
    }

    public int getAxisAssignment() {
        Integer m_Obj = (Integer)this.getFromLook(Attr.AxisAssignment, 1);
        return m_Obj;
    }

    public int getAxisAssignment(IdentObj id) {
        Integer m_Obj = (Integer)this.getAxisAssignmentObj(id);
        return m_Obj;
    }

    public Object getAxisAssignmentObj(IdentObj id) {
        int series = this.getEffectiveSeriesIndex(id.getSeriesID());
        Attr a = Attr.AxisAssignment;
        if (id.getObjectID() == -3 && series == 1) {
            a = Attr.AxisAssignmentY2;
        }
        return this.getFromLook(id, a);
    }

    public int getAxisAssignment(int seriesID) {
        IdentObj id = new IdentObj(-3, seriesID, -3);
        return this.getAxisAssignment(id);
    }

    public void setAxisAssignment(int newValue) {
        this.putToLookAndRepaint(Attr.AxisAssignment, new Integer(newValue), 1);
    }

    public void setAxisAssignment(IdentObj id, int newValue) {
        Attr a = Attr.AxisAssignment;
        if (id.getObjectID() == -3 && id.getSeriesID() == 1) {
            a = Attr.AxisAssignmentY2;
        }
        this.putToLookAndRepaint(id, a, new Integer(newValue));
    }

    public void setAxisAssignment(int seriesID, int newValue) {
        IdentObj id = new IdentObj(-3, seriesID, -3);
        this.setAxisAssignment(id, newValue);
    }

    public boolean getAutofit() {
        Boolean m_Obj = (Boolean)this.getFromLook(Attr.Autofit);
        return m_Obj;
    }

    public boolean getAutofit(IdentObj id) {
        Boolean m_Obj = (Boolean)this.getAutofitObj(id);
        if (m_Obj != null) {
            return m_Obj;
        }
        Attr a = Attr.Autofit;
        if (id.getObjectID() == 297) {
            a = Attr.PieRingLabelAutofit;
        }
        return (Boolean)a.getDefault();
    }

    public Object getAutofitObj(IdentObj id) {
        Attr a = Attr.Autofit;
        if (id.getObjectID() == 297) {
            a = Attr.PieRingLabelAutofit;
        }
        return this.getFromLook(id, a);
    }

    public boolean getAutofit(int objectID) {
        return this.getAutofit(new IdentObj(objectID));
    }

    public void setAutofit(boolean newValue) {
        this.putToLookAndRepaint(Attr.Autofit, newValue);
    }

    public void setAutofit(IdentObj id, boolean newValue) {
        Attr a = Attr.Autofit;
        if (id.getObjectID() == 297) {
            a = Attr.PieRingLabelAutofit;
        }
        this.putToLookAndRepaint(id, a, newValue);
    }

    public void setAutofit(int objectID, boolean newValue) {
        this.setAutofit(new IdentObj(objectID), newValue);
    }

    public int getO1MinorGridCount() {
        return this.getGridCount(new IdentObj(272));
    }

    public void setO1MinorGridCount(int newValue) {
        this.setGridCount(new IdentObj(272), newValue);
    }

    public int getDataTextPosition() {
        Integer m_Obj = (Integer)this.getFromLookSimple(s_identObjGlobal, Attr.DataTextPosition);
        return m_Obj;
    }

    public void setDataTextPosition(int newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.DataTextPosition, new Integer(newValue));
    }

    public int getPieRingTotalFormat() {
        return this.getTextFormatPreset(new IdentObj(297));
    }

    public void setPieRingTotalFormat(int newValue) {
        this.setTextFormatPreset(new IdentObj(297), newValue);
    }

    public boolean getX1AxisLineDisplay() {
        return this.getDisplay(new IdentObj(279));
    }

    public void setX1AxisLineDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(279), newValue);
    }

    public boolean getY1AxisLineDisplay() {
        return this.getDisplay(new IdentObj(283));
    }

    public void setY1AxisLineDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(283), newValue);
    }

    public boolean getY2AxisLineDisplay() {
        return this.getDisplay(new IdentObj(287));
    }

    public void setY2AxisLineDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(287), newValue);
    }

    public boolean getO1AxisLineDisplay() {
        return this.getDisplay(new IdentObj(269));
    }

    public void setO1AxisLineDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(269), newValue);
    }

    public boolean getDualAxisLineDisplay() {
        return this.getDisplay(new IdentObj(17));
    }

    public void setDualAxisLineDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(17), newValue);
    }

    public double getStock52WeekLowValue() {
        Double m_Obj = (Double)this.getFromLookSimple(s_identObjGlobal, Attr.Stock52WeekLowValue);
        return m_Obj;
    }

    public void setStock52WeekLowValue(double newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.Stock52WeekLowValue, new Double(newValue));
    }

    public double getNumPieArcSegmentsPerPixel() {
        Double m_Obj = (Double)this.getFromLookSimple(s_identObjGlobal, Attr.NumPieArcSegmentsPerPixel);
        return m_Obj;
    }

    public void setNumPieArcSegmentsPerPixel(double newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.NumPieArcSegmentsPerPixel, new Double(newValue));
    }

    public boolean getAxisDescending() {
        Boolean m_Obj = (Boolean)this.getFromLook(Attr.AxisDescending);
        return m_Obj;
    }

    public boolean getAxisDescending(IdentObj id) {
        Boolean m_Obj = (Boolean)this.getAxisDescendingObj(id);
        return m_Obj;
    }

    public Object getAxisDescendingObj(IdentObj id) {
        return this.getFromLook(id, Attr.AxisDescending);
    }

    public boolean getAxisDescending(int objectID) {
        return this.getAxisDescending(new IdentObj(objectID));
    }

    public void setAxisDescending(boolean newValue) {
        this.putToLookAndRepaint(Attr.AxisDescending, newValue);
    }

    public void setAxisDescending(IdentObj id, boolean newValue) {
        this.putToLookAndRepaint(id, Attr.AxisDescending, newValue);
    }

    public void setAxisDescending(int objectID, boolean newValue) {
        this.setAxisDescending(new IdentObj(objectID), newValue);
    }

    public int getAxisSide() {
        Integer m_Obj = (Integer)this.getFromLook(Attr.AxisSide);
        return m_Obj;
    }

    public int getAxisSide(IdentObj id) {
        Integer m_Obj = (Integer)this.getAxisSideObj(id);
        return m_Obj;
    }

    public Object getAxisSideObj(IdentObj id) {
        Attr a = Attr.AxisSide;
        if (id.getObjectID() == 2005 || id.getObjectID() == 2013) {
            a = Attr.Y2AxisSide;
        }
        return this.getFromLook(id, a);
    }

    public int getAxisSide(int objectID) {
        return this.getAxisSide(new IdentObj(objectID));
    }

    public void setAxisSide(int newValue) {
        this.putToLookAndRepaint(Attr.AxisSide, new Integer(newValue));
    }

    public void setAxisSide(IdentObj id, int newValue) {
        Attr a = Attr.AxisSide;
        if (id.getObjectID() == 2005 || id.getObjectID() == 2013) {
            a = Attr.Y2AxisSide;
        }
        this.putToLookAndRepaint(id, a, new Integer(newValue));
    }

    public void setAxisSide(int objectID, int newValue) {
        this.setAxisSide(new IdentObj(objectID), newValue);
    }

    public int getDataTextAngle() {
        Integer m_Obj = (Integer)this.getFromLook(Attr.DataTextAngle, 3);
        return m_Obj;
    }

    public int getDataTextAngle(IdentObj id) {
        Integer m_Obj = (Integer)this.getFromLook(id, Attr.DataTextAngle);
        return m_Obj;
    }

    public int getDataTextAngle(int seriesID) {
        IdentObj id = new IdentObj(-3, seriesID, -3);
        Integer m_Obj = (Integer)this.getFromLook(id, Attr.DataTextAngle, false);
        if (m_Obj != null) {
            return m_Obj;
        }
        return this.getDataTextAngleDefault();
    }

    public int getDataTextAngle(int seriesID, int groupID) {
        IdentObj id = new IdentObj(-3, seriesID, groupID);
        Integer m_Obj = (Integer)this.getFromLook(id, Attr.DataTextAngle, false);
        if (m_Obj != null) {
            return m_Obj;
        }
        return this.getDataTextAngle(seriesID);
    }

    public void setDataTextAngle(int newValue) {
        this.putToLookAndRepaint(Attr.DataTextAngle, new Integer(newValue), 3);
    }

    public void setDataTextAngle(IdentObj id, int newValue) {
        this.putToLookAndRepaint(id, Attr.DataTextAngle, new Integer(newValue));
    }

    public void setDataTextAngle(int seriesID, int newValue) {
        IdentObj id = new IdentObj(-3, seriesID, -3);
        this.setDataTextAngle(id, newValue);
    }

    public void setDataTextAngle(int seriesID, int groupID, int newValue) {
        IdentObj id = new IdentObj(-3, seriesID, groupID);
        this.setDataTextAngle(id, newValue);
    }

    public int getDataTextRadius() {
        Integer m_Obj = (Integer)this.getFromLook(Attr.DataTextRadius, 3);
        return m_Obj;
    }

    public int getDataTextRadius(IdentObj id) {
        Integer m_Obj = (Integer)this.getFromLook(id, Attr.DataTextRadius);
        return m_Obj;
    }

    public int getDataTextRadius(int seriesID) {
        IdentObj id = new IdentObj(-3, seriesID, -3);
        Integer m_Obj = (Integer)this.getFromLook(id, Attr.DataTextRadius, false);
        if (m_Obj != null) {
            return m_Obj;
        }
        return this.getDataTextRadiusDefault();
    }

    public int getDataTextRadius(int seriesID, int groupID) {
        IdentObj id = new IdentObj(-3, seriesID, groupID);
        Integer m_Obj = (Integer)this.getFromLook(id, Attr.DataTextRadius, false);
        if (m_Obj != null) {
            return m_Obj;
        }
        return this.getDataTextRadius(seriesID);
    }

    public void setDataTextRadius(int newValue) {
        this.putToLookAndRepaint(Attr.DataTextRadius, new Integer(newValue), 3);
    }

    public void setDataTextRadius(IdentObj id, int newValue) {
        this.putToLookAndRepaint(id, Attr.DataTextRadius, new Integer(newValue));
    }

    public void setDataTextRadius(int seriesID, int newValue) {
        IdentObj id = new IdentObj(-3, seriesID, -3);
        this.setDataTextRadius(id, newValue);
    }

    public void setDataTextRadius(int seriesID, int groupID, int newValue) {
        IdentObj id = new IdentObj(-3, seriesID, groupID);
        this.setDataTextRadius(id, newValue);
    }

    public boolean getDisplay() {
        Boolean m_Obj = (Boolean)this.getFromLook(Attr.Display);
        return m_Obj;
    }

    public boolean getDisplay(IdentObj id) {
        Boolean m_Obj = (Boolean)this.getDisplayObj(id);
        return m_Obj;
    }

    public Object getDisplayObj(IdentObj id) {
        Attr a = Attr.Display;
        switch (id.getObjectID()) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 40: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 74: 
            case 230: 
            case 231: 
            case 232: 
            case 233: 
            case 235: 
            case 260: 
            case 271: 
            case 272: 
            case 276: 
            case 291: 
            case 292: 
            case 293: 
            case 304: 
            case 305: 
            case 309: 
            case 329: 
            case 503: 
            case 607: 
            case 608: 
            case 609: 
            case 614: 
            case 615: 
            case 616: 
            case 617: 
            case 618: 
            case 619: {
                a = Attr.NoDisplay;
                break;
            }
            case 306: {
                a = Attr.StockCloseSplitDisplay;
            }
        }
        return this.getFromLook(id, a);
    }

    public boolean getDisplay(int objectID) {
        return this.getDisplay(new IdentObj(objectID));
    }

    public void setDisplay(boolean newValue) {
        this.putToLookAndRepaint(Attr.Display, newValue);
    }

    public void setDisplay(IdentObj id, boolean newValue) {
        Attr a = Attr.Display;
        switch (id.getObjectID()) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 40: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 74: 
            case 230: 
            case 231: 
            case 232: 
            case 233: 
            case 235: 
            case 260: 
            case 271: 
            case 272: 
            case 276: 
            case 282: 
            case 286: 
            case 290: 
            case 291: 
            case 292: 
            case 293: 
            case 304: 
            case 305: 
            case 309: 
            case 329: 
            case 503: 
            case 607: 
            case 608: 
            case 609: 
            case 614: 
            case 615: 
            case 616: 
            case 617: 
            case 618: 
            case 619: {
                a = Attr.NoDisplay;
                break;
            }
            case 306: {
                a = Attr.StockCloseSplitDisplay;
            }
        }
        this.putToLookAndRepaint(id, a, newValue);
    }

    public void setDisplay(int objectID, boolean newValue) {
        this.setDisplay(new IdentObj(objectID), newValue);
    }

    public boolean getDisplayOffScale() {
        Boolean m_Obj = (Boolean)this.getFromLook(Attr.DisplayOffScale);
        return m_Obj;
    }

    public boolean getDisplayOffScale(IdentObj id) {
        Boolean m_Obj = (Boolean)this.getFromLook(id, Attr.DisplayOffScale);
        return m_Obj;
    }

    public boolean getDisplayOffScale(int objectID) {
        return this.getDisplayOffScale(new IdentObj(objectID));
    }

    public void setDisplayOffScale(boolean newValue) {
        this.putToLookAndRepaint(Attr.DisplayOffScale, newValue);
    }

    public void setDisplayOffScale(IdentObj id, boolean newValue) {
        this.putToLookAndRepaint(id, Attr.DisplayOffScale, newValue);
    }

    public void setDisplayOffScale(int objectID, boolean newValue) {
        this.setDisplayOffScale(new IdentObj(objectID), newValue);
    }

    public boolean getExcludeMaxLabel() {
        Boolean m_Obj = (Boolean)this.getFromLook(Attr.ExcludeMaxLabel);
        return m_Obj;
    }

    public boolean getExcludeMaxLabel(IdentObj id) {
        Boolean m_Obj = (Boolean)this.getExcludeMaxLabelObj(id);
        return m_Obj;
    }

    public Object getExcludeMaxLabelObj(IdentObj id) {
        return this.getFromLook(id, Attr.ExcludeMaxLabel);
    }

    public boolean getExcludeMaxLabel(int objectID) {
        return this.getExcludeMaxLabel(new IdentObj(objectID));
    }

    public void setExcludeMaxLabel(boolean newValue) {
        this.putToLookAndRepaint(Attr.ExcludeMaxLabel, newValue);
    }

    public void setExcludeMaxLabel(IdentObj id, boolean newValue) {
        this.putToLookAndRepaint(id, Attr.ExcludeMaxLabel, newValue);
    }

    public void setExcludeMaxLabel(int objectID, boolean newValue) {
        this.setExcludeMaxLabel(new IdentObj(objectID), newValue);
    }

    public boolean getExcludeMinLabel() {
        Boolean m_Obj = (Boolean)this.getFromLook(Attr.ExcludeMinLabel);
        return m_Obj;
    }

    public boolean getExcludeMinLabel(IdentObj id) {
        Boolean m_Obj = (Boolean)this.getExcludeMinLabelObj(id);
        return m_Obj;
    }

    public Object getExcludeMinLabelObj(IdentObj id) {
        return this.getFromLook(id, Attr.ExcludeMinLabel);
    }

    public boolean getExcludeMinLabel(int objectID) {
        return this.getExcludeMinLabel(new IdentObj(objectID));
    }

    public void setExcludeMinLabel(boolean newValue) {
        this.putToLookAndRepaint(Attr.ExcludeMinLabel, newValue);
    }

    public void setExcludeMinLabel(IdentObj id, boolean newValue) {
        this.putToLookAndRepaint(id, Attr.ExcludeMinLabel, newValue);
    }

    public void setExcludeMinLabel(int objectID, boolean newValue) {
        this.setExcludeMinLabel(new IdentObj(objectID), newValue);
    }

    public String getFontName() {
        String m_Obj = (String)this.getFromLook(Attr.FontName);
        return m_Obj;
    }

    public String getFontName(IdentObj id, boolean useDefault) {
        Attr a = Attr.FontName;
        switch (id.getObjectID()) {
            case 4: 
            case 5: {
                a = Attr.TitleFontName;
            }
        }
        if (useDefault) {
            return (String)this.getFromLook(id, a);
        }
        return (String)this.getFromLook2(id, a);
    }

    public String getFontName(IdentObj id) {
        return this.getFontName(id, true);
    }

    public String getFontName(int objectID) {
        return this.getFontName(new IdentObj(objectID));
    }

    public void setFontName(String newValue) {
        this.putToLookAndRepaint(Attr.FontName, newValue);
    }

    public void setFontName(IdentObj id, String newValue) {
        Attr a = Attr.FontName;
        switch (id.getObjectID()) {
            case 4: 
            case 5: {
                a = Attr.TitleFontName;
            }
        }
        this.putToLookAndRepaint(id, a, newValue);
    }

    public void setFontName(int objectID, String newValue) {
        this.setFontName(new IdentObj(objectID), newValue);
    }

    public int getFontSizeVC() {
        Integer m_Obj = (Integer)this.getFromLook(Attr.FontSizeVC);
        return m_Obj;
    }

    public int getFontSizeVC(IdentObj id) {
        Integer m_Obj = (Integer)this.getFontSizeVCObj(id);
        return m_Obj;
    }

    public Object getFontSizeVCObj(IdentObj id) {
        Attr a = Attr.FontSizeVC;
        switch (id.getObjectID()) {
            case 3: 
            case 4: 
            case 14: 
            case 74: 
            case 235: 
            case 270: 
            case 274: 
            case 280: 
            case 284: 
            case 288: 
            case 295: 
            case 296: 
            case 356: 
            case 441: 
            case 446: 
            case 451: 
            case 622: {
                a = Attr.LabelFontSizeVC;
                break;
            }
            case 5: 
            case 297: {
                a = Attr.TitleFontSizeVC;
            }
        }
        return this.getFromLook(id, a);
    }

    public int getFontSizeVC(int objectID) {
        return this.getFontSizeVC(new IdentObj(objectID));
    }

    public void setFontSizeVC(int newValue) {
        this.putToLookAndRepaint(Attr.FontSizeVC, new Integer(newValue));
    }

    public void setFontSizeVC(IdentObj id, int newValue) {
        Attr a = Attr.FontSizeVC;
        switch (id.getObjectID()) {
            case 3: 
            case 4: 
            case 14: 
            case 74: 
            case 235: 
            case 270: 
            case 274: 
            case 280: 
            case 284: 
            case 288: 
            case 295: 
            case 296: 
            case 356: 
            case 441: 
            case 446: 
            case 451: 
            case 622: {
                a = Attr.LabelFontSizeVC;
                break;
            }
            case 5: 
            case 297: {
                a = Attr.TitleFontSizeVC;
            }
        }
        this.putToLookAndRepaint(id, a, new Integer(newValue));
    }

    public void setFontSizeVC(int objectID, int newValue) {
        this.setFontSizeVC(new IdentObj(objectID), newValue);
    }

    public int getFontStyle() {
        Integer m_Obj = (Integer)this.getFromLook(Attr.FontStyle);
        return m_Obj;
    }

    public int getFontStyle(IdentObj id) {
        Integer m_Obj = (Integer)this.getFontStyleObj(id);
        if (m_Obj != null) {
            return m_Obj;
        }
        Attr a = Attr.FontStyle;
        switch (id.getObjectID()) {
            case 4: 
            case 5: {
                a = Attr.TitleFontStyle;
                break;
            }
            case 232: 
            case 233: 
            case 235: {
                a = Attr.DrillLabelFontStyle;
            }
        }
        return (Integer)a.getDefault();
    }

    public Object getFontStyleObj(IdentObj id, boolean useDefault) {
        Attr a = Attr.FontStyle;
        switch (id.getObjectID()) {
            case 4: 
            case 5: {
                a = Attr.TitleFontStyle;
                break;
            }
            case 232: 
            case 233: 
            case 235: {
                a = Attr.DrillLabelFontStyle;
            }
        }
        if (useDefault) {
            return this.getFromLook(id, a);
        }
        return this.getFromLook2(id, a);
    }

    public Object getFontStyleObj(IdentObj id) {
        return this.getFontStyleObj(id, true);
    }

    public int getFontStyle(int objectID) {
        return this.getFontStyle(new IdentObj(objectID));
    }

    public void setFontStyle(int newValue) {
        this.putToLookAndRepaint(Attr.FontStyle, new Integer(newValue));
    }

    public void setFontStyle(IdentObj id, int newValue) {
        Attr a = Attr.FontStyle;
        switch (id.getObjectID()) {
            case 4: 
            case 5: {
                a = Attr.TitleFontStyle;
                break;
            }
            case 232: 
            case 233: 
            case 235: {
                a = Attr.DrillLabelFontStyle;
            }
        }
        this.putToLookAndRepaint(id, a, new Integer(newValue));
    }

    public void setFontStyle(int objectID, int newValue) {
        this.setFontStyle(new IdentObj(objectID), newValue);
    }

    public double getMinAutoGridStep() {
        Double m_Obj = (Double)this.getFromLook(Attr.MinAutoGridStep);
        return m_Obj;
    }

    public double getMinAutoGridStep(IdentObj id) {
        Double m_Obj = (Double)this.getMinAutoGridStepObj(id);
        if (m_Obj != null) {
            return m_Obj;
        }
        return (Double)Attr.MinAutoGridStep.getDefault();
    }

    public Object getMinAutoGridStepObj(IdentObj id) {
        return this.getFromLook(id, Attr.MinAutoGridStep);
    }

    public double getMinAutoGridStep(int objectID) {
        return this.getMinAutoGridStep(new IdentObj(objectID));
    }

    public void setMinAutoGridStep(double newValue) {
        this.putToLookAndRepaint(Attr.MinAutoGridStep, new Double(newValue));
    }

    public void setMinAutoGridStep(IdentObj id, double newValue) {
        this.putToLookAndRepaint(id, Attr.MinAutoGridStep, new Double(newValue));
    }

    public void setMinAutoGridStep(int objectID, double newValue) {
        this.setMinAutoGridStep(new IdentObj(objectID), newValue);
    }

    public double getGridStep() {
        Double m_Obj = (Double)this.getFromLook(Attr.GridStep);
        return m_Obj;
    }

    public double getGridStep(IdentObj id) {
        Double m_Obj = (Double)this.getGridStepObj(id);
        return m_Obj;
    }

    public Object getGridStepObj(IdentObj id) {
        Attr a = Attr.GridStep;
        switch (id.getObjectID()) {
            case 281: {
                a = Attr.X1MajorGridStep;
                break;
            }
            case 285: {
                a = Attr.Y1MajorGridStep;
                break;
            }
            case 289: {
                a = Attr.Y2MajorGridStep;
                break;
            }
            case 282: 
            case 286: 
            case 290: {
                a = Attr.MinorGridStep;
            }
        }
        return this.getFromLook(id, a);
    }

    public double getGridStep(int objectID) {
        return this.getGridStep(new IdentObj(objectID));
    }

    public void setGridStep(double newValue) {
        this.putToLookAndRepaint(Attr.GridStep, new Double(newValue));
    }

    public void setGridStep(IdentObj id, double newValue) {
        Attr a = Attr.GridStep;
        switch (id.getObjectID()) {
            case 281: {
                a = Attr.X1MajorGridStep;
                break;
            }
            case 285: {
                a = Attr.Y1MajorGridStep;
                break;
            }
            case 289: {
                a = Attr.Y2MajorGridStep;
                break;
            }
            case 282: 
            case 286: 
            case 290: {
                a = Attr.MinorGridStep;
            }
        }
        this.putToLookAndRepaint(id, a, new Double(newValue));
    }

    public void setGridStep(int objectID, double newValue) {
        this.setGridStep(new IdentObj(objectID), newValue);
    }

    public GraphConstants.MinorGridStepType getMinorGridStepType(IdentObj id) {
        return (GraphConstants.MinorGridStepType)((Object)this.getFromLook(id, Attr.MinorGridStepType));
    }

    public Object getMinorGridStepTypeObj(IdentObj id) {
        return this.getFromLook2(id, Attr.MinorGridStepType);
    }

    public void setMinorGridStepType(IdentObj id, GraphConstants.MinorGridStepType newType) {
        this.putToLookAndRepaint(id, Attr.MinorGridStepType, (Object)newType);
    }

    public boolean getGridStepAuto() {
        Boolean m_Obj = (Boolean)this.getFromLook(Attr.GridStepAuto);
        return m_Obj;
    }

    public boolean getGridStepAuto(IdentObj id) {
        Boolean m_Obj = (Boolean)this.getFromLook(id, Attr.GridStepAuto);
        if (m_Obj != null) {
            return m_Obj;
        }
        return (Boolean)Attr.GridStepAuto.getDefault();
    }

    public Object getGridStepAutoObj(IdentObj id) {
        return this.getFromLook(id, Attr.GridStepAuto);
    }

    public boolean getGridStepAuto(int objectID) {
        return this.getGridStepAuto(new IdentObj(objectID));
    }

    public void setGridStepAuto(boolean newValue) {
        this.putToLookAndRepaint(Attr.GridStepAuto, newValue);
    }

    public void setGridStepAuto(IdentObj id, boolean newValue) {
        this.putToLookAndRepaint(id, Attr.GridStepAuto, newValue);
    }

    public void setGridStepAuto(int objectID, boolean newValue) {
        this.setGridStepAuto(new IdentObj(objectID), newValue);
    }

    public int getGridStyle() {
        Integer m_Obj = (Integer)this.getFromLook(Attr.GridStyle);
        return m_Obj;
    }

    public int getGridStyle(IdentObj id) {
        Attr a = Attr.GridStyle;
        switch (id.getObjectID()) {
            case 271: {
                a = Attr.O1MajorGridStyle;
                break;
            }
            case 282: 
            case 286: 
            case 290: {
                a = Attr.MinorGridStyle;
            }
        }
        return (Integer)this.getFromLook(id, a);
    }

    public Object getGridStyleObj(IdentObj id) {
        Attr a = Attr.GridStyle;
        switch (id.getObjectID()) {
            case 271: {
                a = Attr.O1MajorGridStyle;
                break;
            }
            case 282: 
            case 286: 
            case 290: {
                a = Attr.MinorGridStyle;
            }
        }
        return this.getFromLook2(id, a);
    }

    public int getGridStyle(int objectID) {
        return this.getGridStyle(new IdentObj(objectID));
    }

    public void setGridStyle(int newValue) {
        this.putToLookAndRepaint(Attr.GridStyle, new Integer(newValue));
    }

    public void setGridStyle(IdentObj id, int newValue) {
        Attr a = Attr.GridStyle;
        switch (id.getObjectID()) {
            case 271: {
                a = Attr.O1MajorGridStyle;
                break;
            }
            case 282: 
            case 286: 
            case 290: {
                a = Attr.MinorGridStyle;
            }
        }
        this.putToLookAndRepaint(id, a, new Integer(newValue));
    }

    public void setGridStyle(int objectID, int newValue) {
        this.setGridStyle(new IdentObj(objectID), newValue);
    }

    public String getGroupLabel(int groupID) {
        String ret = null;
        if (this.getNestedLabels()) {
            List labels = this.getO1LabelCallBack().getAllLabels(0);
            if (labels.size() > groupID) {
                ret = (String)labels.get(groupID);
            }
            return ret;
        }
        if (this.m_groupLabels.size() > groupID) {
            Object obj = this.m_groupLabels.get(groupID);
            if (obj instanceof String) {
                ret = (String)obj;
            } else if (obj != null) {
                ret = obj.toString();
            }
        }
        return ret;
    }

    public void setGroupLabel(int groupID, Object newValue) {
        if (groupID >= this.m_groupLabels.size()) {
            this.m_groupLabels.add(newValue);
        } else {
            this.m_groupLabels.set(groupID, newValue);
        }
    }

    public List getGroupLabels() {
        return this.m_groupLabels;
    }

    public boolean getLabelStagger() {
        Boolean m_Obj = (Boolean)this.getFromLook(Attr.LabelStagger);
        return m_Obj;
    }

    public boolean getLabelStagger(IdentObj id) {
        Boolean m_Obj = (Boolean)this.getLabelStaggerObj(id);
        return m_Obj;
    }

    public Object getLabelStaggerObj(IdentObj id) {
        return this.getFromLook(id, Attr.LabelStagger);
    }

    public boolean getLabelStagger(int objectID) {
        return this.getLabelStagger(new IdentObj(objectID));
    }

    public void setLabelStagger(boolean newValue) {
        this.putToLookAndRepaint(Attr.LabelStagger, newValue);
    }

    public void setLabelStagger(IdentObj id, boolean newValue) {
        this.putToLookAndRepaint(id, Attr.LabelStagger, newValue);
    }

    public void setLabelStagger(int objectID, boolean newValue) {
        this.setLabelStagger(new IdentObj(objectID), newValue);
    }

    public boolean getLogScale() {
        Boolean m_Obj = (Boolean)this.getFromLook(Attr.LogScale);
        return m_Obj;
    }

    public boolean getLogScale(IdentObj id) {
        Boolean m_Obj = (Boolean)this.getLogScaleObj(id);
        if (m_Obj != null) {
            return m_Obj;
        }
        return (Boolean)Attr.LogScale.getDefault();
    }

    public Object getLogScaleObj(IdentObj id) {
        return this.getFromLook(id, Attr.LogScale);
    }

    public boolean getLogScale(int objectID) {
        return this.getLogScale(new IdentObj(objectID));
    }

    public void setLogScale(boolean newValue) {
        this.putToLookAndRepaint(Attr.LogScale, newValue);
    }

    public void setLogScale(IdentObj id, boolean newValue) {
        this.putToLookAndRepaint(id, Attr.LogScale, newValue);
    }

    public void setLogScale(int objectID, boolean newValue) {
        this.setLogScale(new IdentObj(objectID), newValue);
    }

    public int getMarkerSize() {
        Integer m_Obj = (Integer)this.getFromLook(Attr.MarkerSize, 3);
        return m_Obj;
    }

    public int getMarkerSize(int seriesID) {
        IdentObj id;
        Integer m_Obj;
        if (this.m_markerSizeUniqueness >= 1 && (m_Obj = (Integer)this.getFromLookSimple(id = this.getIdentObj(-3, seriesID), Attr.MarkerSize, false)) != null) {
            return m_Obj;
        }
        return this.getMarkerSizeDefault();
    }

    public int getMarkerSize(int seriesID, int groupID) {
        IdentObj id;
        Integer m_Obj;
        if (this.m_markerSizeUniqueness >= 2 && (m_Obj = (Integer)this.getFromLook(id = this.getIdentObj(-3, seriesID, groupID), Attr.MarkerSize, false)) != null) {
            return m_Obj;
        }
        return this.getMarkerSize(seriesID);
    }

    public void setMarkerSize(int newValue) {
        this.putToLookAndRepaint(Attr.MarkerSize, new Integer(newValue), 3);
        this.m_markerSizeUniqueness = 2;
    }

    private void setMarkerSize(IdentObj id, int newValue) {
        this.putToLookAndRepaint(id, Attr.MarkerSize, new Integer(newValue));
    }

    public void setMarkerSize(int seriesID, int newValue) {
        IdentObj id = new IdentObj(-3, seriesID);
        this.setMarkerSize(id, newValue);
        if (this.m_markerSizeUniqueness < 1) {
            this.m_markerSizeUniqueness = 1;
        }
    }

    public void setMarkerSize(int seriesID, int groupID, int newValue) {
        IdentObj id = new IdentObj(-3, seriesID, groupID);
        this.setMarkerSize(id, newValue);
        this.m_markerSizeUniqueness = 2;
    }

    public boolean getPieSliceDelete() {
        Boolean m_Obj = (Boolean)this.getFromLook(Attr.PieSliceDelete, 3);
        return m_Obj;
    }

    public boolean getPieSliceDelete(IdentObj id) {
        Boolean m_Obj = (Boolean)this.getFromLook(id, Attr.PieSliceDelete);
        return m_Obj;
    }

    public boolean getPieSliceDelete(int seriesID) {
        IdentObj id = new IdentObj(-3, seriesID, -3);
        return this.getPieSliceDelete(id);
    }

    public boolean getPieSliceDelete(int seriesID, int groupID) {
        IdentObj id = new IdentObj(-3, seriesID, groupID);
        return this.getPieSliceDelete(id);
    }

    public void setPieSliceDelete(boolean newValue) {
        this.putToLookAndRepaint(Attr.PieSliceDelete, newValue, 3);
    }

    public void setPieSliceDelete(IdentObj id, boolean newValue) {
        this.putToLookAndRepaint(id, Attr.PieSliceDelete, newValue);
    }

    public void setPieSliceDelete(int seriesID, boolean newValue) {
        IdentObj id = new IdentObj(-3, seriesID, -3);
        this.setPieSliceDelete(id, newValue);
    }

    public void setPieSliceDelete(int seriesID, int groupID, boolean newValue) {
        IdentObj id = new IdentObj(-3, seriesID, groupID);
        this.setPieSliceDelete(id, newValue);
    }

    public int getPieSliceDetach() {
        Integer m_Obj = (Integer)this.getFromLook(Attr.PieSliceDetach, 3);
        return m_Obj;
    }

    public int getPieSliceDetach(IdentObj id) {
        Integer m_Obj = (Integer)this.getPieSliceDetachObj(id);
        return m_Obj;
    }

    public Object getPieSliceDetachObj(IdentObj id) {
        return this.getFromLook(id, Attr.PieSliceDetach);
    }

    public int getPieSliceDetach(int seriesID) {
        IdentObj id = new IdentObj(-3, seriesID, -3);
        return this.getPieSliceDetach(id);
    }

    public int getPieSliceDetach(int seriesID, int groupID) {
        IdentObj id = new IdentObj(-3, seriesID, groupID);
        return this.getPieSliceDetach(id);
    }

    public void setPieSliceDetach(int newValue) {
        this.putToLookAndRepaint(Attr.PieSliceDetach, new Integer(newValue), 3);
    }

    public void setPieSliceDetach(IdentObj id, int newValue) {
        this.putToLookAndRepaint(id, Attr.PieSliceDetach, new Integer(newValue));
    }

    public void setPieSliceDetach(int seriesID, int newValue) {
        IdentObj id = new IdentObj(-3, seriesID, -3);
        this.setPieSliceDetach(id, newValue);
    }

    public void setPieSliceDetach(int seriesID, int groupID, int newValue) {
        IdentObj id = new IdentObj(-3, seriesID, groupID);
        this.setPieSliceDetach(id, newValue);
    }

    public Rectangle getRect() {
        Rectangle m_Obj = (Rectangle)this.getFromLook(Attr.Rect);
        return m_Obj;
    }

    public Rectangle getRect(IdentObj id) {
        Attr a = Attr.Rect;
        switch (id.getObjectID()) {
            case 1: {
                a = Attr.ChartBackgroundRect;
                break;
            }
            case 42: {
                a = Attr.CurveFitEquationTextRect;
                break;
            }
            case 3: {
                a = Attr.FootnoteRect;
                break;
            }
            case 2: {
                a = Attr.FrameRect;
                break;
            }
            case 12: {
                a = Attr.LegendAreaRect;
                break;
            }
            case 302: {
                a = Attr.PieFrameRect;
                break;
            }
            case 620: {
                a = Attr.FunnelFrameRect;
                break;
            }
            case 4: {
                a = Attr.SubtitleRect;
                break;
            }
            case 5: {
                a = Attr.TitleRect;
                break;
            }
            case 7: {
                a = Attr.Y2TitleRect;
            }
        }
        Rectangle m_Obj = (Rectangle)this.getFromLook(id, a);
        return m_Obj;
    }

    public Rectangle getRect(int objectID) {
        return this.getRect(new IdentObj(objectID));
    }

    public void setRect(Rectangle newValue) {
        this.putToLookAndRepaint(Attr.Rect, newValue);
    }

    public void setRect(IdentObj id, Rectangle newValue) {
        Attr a = Attr.Rect;
        switch (id.getObjectID()) {
            case 1: {
                a = Attr.ChartBackgroundRect;
                break;
            }
            case 42: {
                a = Attr.CurveFitEquationTextRect;
                break;
            }
            case 3: {
                a = Attr.FootnoteRect;
                break;
            }
            case 2: {
                a = Attr.FrameRect;
                break;
            }
            case 12: {
                a = Attr.LegendAreaRect;
                break;
            }
            case 302: {
                a = Attr.PieFrameRect;
                break;
            }
            case 620: {
                a = Attr.FunnelFrameRect;
                break;
            }
            case 4: {
                a = Attr.SubtitleRect;
                break;
            }
            case 5: {
                a = Attr.TitleRect;
                break;
            }
            case 7: {
                a = Attr.Y2TitleRect;
            }
        }
        this.putToLookAndRepaint(id, a, newValue);
    }

    public void setRect(int objectID, Rectangle newValue) {
        this.setRect(new IdentObj(objectID), newValue);
    }

    public double getScaleMax() {
        Double m_Obj = (Double)this.getFromLook(Attr.ScaleMax);
        return m_Obj;
    }

    public double getScaleMax(IdentObj id) {
        Attr a = Attr.ScaleMax;
        switch (id.getObjectID()) {
            case 2003: {
                a = Attr.X1ScaleMax;
                break;
            }
            case 2004: {
                a = Attr.Y1ScaleMax;
                break;
            }
            case 2005: {
                a = Attr.Y2ScaleMax;
            }
        }
        Double m_Obj = (Double)this.getFromLook(id, a);
        return m_Obj;
    }

    public double getScaleMax(int objectID) {
        return this.getScaleMax(new IdentObj(objectID));
    }

    public void setScaleMax(double newValue) {
        this.putToLookAndRepaint(Attr.ScaleMax, new Double(newValue));
    }

    public void setScaleMax(IdentObj id, double newValue) {
        Attr a = Attr.ScaleMax;
        switch (id.getObjectID()) {
            case 2003: {
                a = Attr.X1ScaleMax;
                break;
            }
            case 2004: {
                a = Attr.Y1ScaleMax;
                break;
            }
            case 2005: {
                a = Attr.Y2ScaleMax;
            }
        }
        this.putToLookAndRepaint(id, a, new Double(newValue));
    }

    public void setScaleMax(int objectID, double newValue) {
        this.setScaleMax(new IdentObj(objectID), newValue);
    }

    public boolean getScaleMaxAuto() {
        Boolean m_Obj = (Boolean)this.getFromLook(Attr.ScaleMaxAuto);
        return m_Obj;
    }

    public boolean getScaleMaxAuto(IdentObj id) {
        Boolean m_Obj = (Boolean)this.getScaleMaxAutoObj(id);
        if (m_Obj != null) {
            return m_Obj;
        }
        return (Boolean)Attr.ScaleMinAuto.getDefault();
    }

    public Object getScaleMaxAutoObj(IdentObj id) {
        return this.getFromLook(id, Attr.ScaleMaxAuto);
    }

    public boolean getScaleMaxAuto(int objectID) {
        return this.getScaleMaxAuto(new IdentObj(objectID));
    }

    public void setScaleMaxAuto(boolean newValue) {
        this.putToLookAndRepaint(Attr.ScaleMaxAuto, newValue);
    }

    public void setScaleMaxAuto(IdentObj id, boolean newValue) {
        this.putToLookAndRepaint(id, Attr.ScaleMaxAuto, newValue);
    }

    public void setScaleMaxAuto(int objectID, boolean newValue) {
        this.setScaleMaxAuto(new IdentObj(objectID), newValue);
    }

    public double getScaleMin() {
        Double m_Obj = (Double)this.getFromLook(Attr.ScaleMin);
        return m_Obj;
    }

    public double getScaleMin(IdentObj id) {
        Attr a = Attr.ScaleMin;
        switch (id.getObjectID()) {
            case 2005: {
                a = Attr.Y2ScaleMin;
            }
        }
        Double m_Obj = (Double)this.getFromLook(id, a);
        if (m_Obj != null) {
            return m_Obj;
        }
        return (Double)a.getDefault();
    }

    public double getScaleMin(int objectID) {
        return this.getScaleMin(new IdentObj(objectID));
    }

    public void setScaleMin(double newValue) {
        this.putToLookAndRepaint(Attr.ScaleMin, new Double(newValue));
    }

    public void setScaleMin(IdentObj id, double newValue) {
        Attr a = Attr.ScaleMin;
        switch (id.getObjectID()) {
            case 2005: {
                a = Attr.Y2ScaleMin;
            }
        }
        this.putToLookAndRepaint(id, a, new Double(newValue));
    }

    public void setScaleMin(int objectID, double newValue) {
        this.setScaleMin(new IdentObj(objectID), newValue);
    }

    public Double getScaleZoomMin(IdentObj id) {
        Attr a = Attr.ScaleZoomMin;
        return (Double)this.getFromLook(id, a, false);
    }

    public void setScaleZoomMin(IdentObj id, Double newValue) {
        Attr a = Attr.ScaleZoomMin;
        this.putToLookAndRepaint(id, a, newValue);
    }

    public Double getScaleZoomMax(IdentObj id) {
        Attr a = Attr.ScaleZoomMax;
        return (Double)this.getFromLook(id, a, false);
    }

    public void setScaleZoomMax(IdentObj id, Double newValue) {
        Attr a = Attr.ScaleZoomMax;
        this.putToLookAndRepaint(id, a, newValue);
    }

    public boolean getScaleMinAuto() {
        Boolean m_Obj = (Boolean)this.getFromLook(Attr.ScaleMinAuto);
        return m_Obj;
    }

    public boolean getScaleMinAuto(IdentObj id) {
        Boolean m_Obj = (Boolean)this.getScaleMinAutoObj(id);
        if (m_Obj != null) {
            return m_Obj;
        }
        return (Boolean)Attr.ScaleMinAuto.getDefault();
    }

    public Object getScaleMinAutoObj(IdentObj id) {
        return this.getFromLook(id, Attr.ScaleMinAuto);
    }

    public boolean getScaleMinAuto(int objectID) {
        return this.getScaleMinAuto(new IdentObj(objectID));
    }

    public void setScaleMinAuto(boolean newValue) {
        this.putToLookAndRepaint(Attr.ScaleMinAuto, newValue);
    }

    public void setScaleMinAuto(IdentObj id, boolean newValue) {
        this.putToLookAndRepaint(id, Attr.ScaleMinAuto, newValue);
    }

    public void setScaleMinAuto(int objectID, boolean newValue) {
        this.setScaleMinAuto(new IdentObj(objectID), newValue);
    }

    public boolean getScaleMustIncludeZero() {
        Boolean m_Obj = (Boolean)this.getFromLook(Attr.ScaleMustIncludeZero);
        return m_Obj;
    }

    public boolean getScaleMustIncludeZero(IdentObj id) {
        Boolean m_Obj = (Boolean)this.getFromLook(id, Attr.ScaleMustIncludeZero);
        return m_Obj;
    }

    public Object getScaleMustIncludeZeroObj(IdentObj id) {
        Boolean m_Obj = (Boolean)this.getFromLook(id, Attr.ScaleMustIncludeZero);
        if (m_Obj == null) {
            return null;
        }
        if (this.getLogScale()) {
            return false;
        }
        return m_Obj;
    }

    public boolean getScaleMustIncludeZero(int objectID) {
        return this.getScaleMustIncludeZero(new IdentObj(objectID));
    }

    public void setScaleMustIncludeZero(boolean newValue) {
        this.putToLookAndRepaint(Attr.ScaleMustIncludeZero, newValue);
    }

    public void setScaleMustIncludeZero(IdentObj id, boolean newValue) {
        this.putToLookAndRepaint(id, Attr.ScaleMustIncludeZero, newValue);
    }

    public void setScaleMustIncludeZero(int objectID, boolean newValue) {
        this.setScaleMustIncludeZero(new IdentObj(objectID), newValue);
    }

    public String getSeriesLabel(int seriesID) {
        String ret = null;
        if (this.m_seriesLabels.size() > seriesID) {
            ret = (String)this.m_seriesLabels.get(seriesID);
        }
        return ret;
    }

    public void setSeriesLabel(int seriesID, Object newValue) {
        if (seriesID >= this.m_seriesLabels.size()) {
            this.m_seriesLabels.add(newValue);
        }
        this.m_seriesLabels.set(seriesID, newValue);
    }

    public boolean getShadowDisplay() {
        Boolean m_Obj = (Boolean)this.getFromLook(Attr.ShadowDisplay);
        return m_Obj;
    }

    public boolean getShadowDisplay(IdentObj id) {
        Boolean m_Obj = (Boolean)this.getFromLook(id, Attr.ShadowDisplay);
        return m_Obj;
    }

    public boolean getShadowDisplay(int objectID) {
        return this.getShadowDisplay(new IdentObj(objectID));
    }

    public void setShadowDisplay(boolean newValue) {
        this.putToLookAndRepaint(Attr.ShadowDisplay, newValue);
    }

    public void setShadowDisplay(IdentObj id, boolean newValue) {
        this.putToLookAndRepaint(id, Attr.ShadowDisplay, newValue);
    }

    public void setShadowDisplay(int objectID, boolean newValue) {
        this.setShadowDisplay(new IdentObj(objectID), newValue);
    }

    public int getShadowXOffset() {
        Integer m_Obj = (Integer)this.getFromLook(Attr.ShadowXOffset);
        return m_Obj;
    }

    public int getShadowXOffset(IdentObj id) {
        Integer m_Obj = (Integer)this.getFromLook(id, Attr.ShadowXOffset);
        return m_Obj;
    }

    public int getShadowXOffset(int objectID) {
        return this.getShadowXOffset(new IdentObj(objectID));
    }

    public void setShadowXOffset(int newValue) {
        this.putToLookAndRepaint(Attr.ShadowXOffset, new Integer(newValue));
    }

    public void setShadowXOffset(IdentObj id, int newValue) {
        this.putToLookAndRepaint(id, Attr.ShadowXOffset, new Integer(newValue));
    }

    public void setShadowXOffset(int objectID, int newValue) {
        this.setShadowXOffset(new IdentObj(objectID), newValue);
    }

    public int getShadowYOffset() {
        Integer m_Obj = (Integer)this.getFromLook(Attr.ShadowYOffset);
        return m_Obj;
    }

    public int getShadowYOffset(IdentObj id) {
        Integer m_Obj = (Integer)this.getFromLook(id, Attr.ShadowYOffset);
        return m_Obj;
    }

    public int getShadowYOffset(int objectID) {
        return this.getShadowYOffset(new IdentObj(objectID));
    }

    public void setShadowYOffset(int newValue) {
        this.putToLookAndRepaint(Attr.ShadowYOffset, new Integer(newValue));
    }

    public void setShadowYOffset(IdentObj id, int newValue) {
        this.putToLookAndRepaint(id, Attr.ShadowYOffset, new Integer(newValue));
    }

    public void setShadowYOffset(int objectID, int newValue) {
        this.setShadowYOffset(new IdentObj(objectID), newValue);
    }

    public int getTextFormatPreset() {
        Integer m_Obj = (Integer)this.getFromLook(Attr.TextFormatPreset);
        return m_Obj;
    }

    public int getTextFormatPreset(IdentObj id) {
        Attr a = Attr.TextFormatPreset;
        if (id.getObjectID() == 295 || id.getObjectID() == 622) {
            a = Attr.SliceLabelTextFormatPreset;
        }
        Integer m_Obj = (Integer)this.getFromLook(id, a);
        return m_Obj;
    }

    public int getTextFormatPreset(int objectID) {
        return this.getTextFormatPreset(new IdentObj(objectID));
    }

    public void setTextFormatPreset(int newValue) {
        this.putToLookAndRepaint(Attr.TextFormatPreset, new Integer(newValue));
    }

    public void setTextFormatPreset(IdentObj id, int newValue) {
        Attr a = Attr.TextFormatPreset;
        if (id.getObjectID() == 295 || id.getObjectID() == 622) {
            a = Attr.SliceLabelTextFormatPreset;
        }
        this.putToLookAndRepaint(id, a, new Integer(newValue));
    }

    public void setTextFormatPreset(int objectID, int newValue) {
        this.setTextFormatPreset(new IdentObj(objectID), newValue);
    }

    public int getTextJustHoriz() {
        Integer m_Obj = (Integer)this.getFromLook(Attr.TextJustHoriz);
        return m_Obj;
    }

    public int getTextJustHoriz(IdentObj id) {
        Integer m_Obj = (Integer)this.getTextJustHorizObj(id);
        return m_Obj;
    }

    public Object getTextJustHorizObj(IdentObj id, boolean useDefault) {
        Attr a = Attr.TextJustHoriz;
        switch (id.getObjectID()) {
            case 274: 
            case 284: 
            case 288: {
                a = Attr.RightTextJustHoriz;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 14: 
            case 235: 
            case 356: 
            case 514: {
                a = Attr.LeftTextJustHoriz;
            }
        }
        if (useDefault) {
            return this.getFromLook(id, a);
        }
        return this.getFromLook2(id, a);
    }

    public Object getTextJustHorizObj(IdentObj id) {
        return this.getTextJustHorizObj(id, true);
    }

    public int getTextJustHoriz(int objectID) {
        return this.getTextJustHoriz(new IdentObj(objectID));
    }

    public void setTextJustHoriz(int newValue) {
        this.putToLookAndRepaint(Attr.TextJustHoriz, new Integer(newValue));
    }

    public void setTextJustHoriz(IdentObj id, int newValue) {
        Attr a = Attr.TextJustHoriz;
        switch (id.getObjectID()) {
            case 260: 
            case 274: 
            case 284: 
            case 288: {
                a = Attr.RightTextJustHoriz;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 14: 
            case 235: 
            case 356: 
            case 514: {
                a = Attr.LeftTextJustHoriz;
            }
        }
        this.putToLookAndRepaint(id, a, new Integer(newValue));
    }

    public void setTextJustHoriz(int objectID, int newValue) {
        this.setTextJustHoriz(new IdentObj(objectID), newValue);
    }

    public int getTextJustVert() {
        Integer m_Obj = (Integer)this.getFromLook(Attr.TextJustVert);
        return m_Obj;
    }

    public int getTextJustVert(IdentObj id) {
        Integer m_Obj = (Integer)this.getTextJustVertObj(id);
        return m_Obj;
    }

    public Object getTextJustVertObj(IdentObj id) {
        Attr a = Attr.TextJustVert;
        if (id.getObjectID() == 270) {
            a = Attr.TopTextJustVert;
        }
        return this.getFromLook(id, a);
    }

    public int getTextJustVert(int objectID) {
        return this.getTextJustVert(new IdentObj(objectID));
    }

    public void setTextJustVert(int newValue) {
        this.putToLookAndRepaint(Attr.TextJustVert, new Integer(newValue));
    }

    public void setTextJustVert(IdentObj id, int newValue) {
        Attr a = Attr.TextJustVert;
        if (id.getObjectID() == 270) {
            a = Attr.TopTextJustVert;
        }
        this.putToLookAndRepaint(id, a, new Integer(newValue));
    }

    public void setTextJustVert(int objectID, int newValue) {
        this.setTextJustVert(new IdentObj(objectID), newValue);
    }

    public int getTextRotation() {
        Integer m_Obj = (Integer)this.getFromLook(Attr.TextRotation);
        return m_Obj;
    }

    public int getTextRotation(IdentObj id) {
        Integer m_Obj = (Integer)this.getTextRotationObj(id);
        return m_Obj;
    }

    public Object getTextRotationObj(IdentObj id) {
        Attr a = Attr.TextRotation;
        switch (id.getObjectID()) {
            case 6: {
                a = Attr.Y1TextRotation;
                break;
            }
            case 7: {
                a = Attr.Y2TextRotation;
                break;
            }
            case 622: {
                a = Attr.SliceLabelTextRotationAngle;
                break;
            }
            case 270: {
                if (!(this.m_chart instanceof JChart_2D_Funnel)) break;
                a = Attr.StageLabelTextRotationAngle;
            }
        }
        return this.getFromLook(id, a);
    }

    public int getTextRotation(int objectID) {
        return this.getTextRotation(new IdentObj(objectID));
    }

    public void setTextRotation(int newValue) {
        this.putToLookAndRepaint(Attr.TextRotation, new Integer(newValue));
    }

    public void setTextRotation(IdentObj id, int newValue) {
        Attr a = Attr.TextRotation;
        switch (id.getObjectID()) {
            case 6: {
                a = Attr.Y1TextRotation;
                break;
            }
            case 7: {
                a = Attr.Y2TextRotation;
                break;
            }
            case 622: {
                a = Attr.SliceLabelTextRotationAngle;
                break;
            }
            case 270: {
                if (!(this.m_chart instanceof JChart_2D_Funnel)) break;
                a = Attr.StageLabelTextRotationAngle;
            }
        }
        this.putToLookAndRepaint(id, a, new Integer(newValue));
    }

    public void setTextRotation(int objectID, int newValue) {
        this.setTextRotation(new IdentObj(objectID), newValue);
    }

    public String getTextString() {
        String m_Obj = (String)this.getFromLook(Attr.TextString);
        return m_Obj;
    }

    public String getTextString(IdentObj id) {
        Attr a = Attr.TextString;
        String m_Obj = (String)this.getFromLook(id, a);
        return m_Obj;
    }

    public String getTextString(int objectID) {
        return this.getTextString(new IdentObj(objectID));
    }

    public void setTextString(String newValue) {
        this.putToLookAndRepaint(Attr.TextString, newValue);
    }

    public void setTextString(IdentObj id, String newValue) {
        Attr a = Attr.TextString;
        this.putToLookAndRepaint(id, a, newValue);
    }

    public void setTextString(int objectID, String newValue) {
        this.setTextString(new IdentObj(objectID), newValue);
    }

    public boolean getTextWrap() {
        Boolean m_Obj = (Boolean)this.getFromLook(Attr.TextWrap);
        return m_Obj;
    }

    public boolean getTextWrap(IdentObj id) {
        Boolean m_Obj = (Boolean)this.getTextWrapObj(id);
        return m_Obj;
    }

    public Object getTextWrapObj(IdentObj id) {
        Attr a = Attr.TextWrap;
        switch (id.getObjectID()) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 232: 
            case 233: 
            case 260: 
            case 356: {
                a = Attr.TitleTextWrap;
            }
        }
        return this.getFromLook(id, a);
    }

    public boolean getTextWrap(int objectID) {
        return this.getTextWrap(new IdentObj(objectID));
    }

    public void setTextWrap(boolean newValue) {
        this.putToLookAndRepaint(Attr.TextWrap, newValue);
    }

    public void setTextWrap(IdentObj id, boolean newValue) {
        Attr a = Attr.TextWrap;
        switch (id.getObjectID()) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 232: 
            case 233: 
            case 260: 
            case 356: {
                a = Attr.TitleTextWrap;
            }
        }
        this.putToLookAndRepaint(id, a, newValue);
    }

    public void setTextWrap(int objectID, boolean newValue) {
        this.setTextWrap(new IdentObj(objectID), newValue);
    }

    public Object getMinLengthObj(IdentObj id) {
        Attr a = Attr.MinLength;
        return this.getFromLook(id, a);
    }

    public int getMinLength(IdentObj id) {
        Integer m_Obj = (Integer)this.getMinLengthObj(id);
        return m_Obj;
    }

    public void setMinLength(IdentObj id, int length) {
        Attr a = Attr.MinLength;
        this.putToLookAndRepaint(id, a, new Integer(length));
    }

    public int getSeriesType() {
        Integer m_Obj = (Integer)this.getFromLook(Attr.SeriesType, 1);
        return m_Obj;
    }

    public int getSeriesType(IdentObj id) {
        Integer m_Obj = (Integer)this.getSeriesTypeObj(id);
        return m_Obj;
    }

    public Object getSeriesTypeObj(IdentObj id) {
        return this.getFromLook(id, Attr.SeriesType);
    }

    public int getSeriesType(int seriesID) {
        IdentObj id = this.getIdentObj(-3, seriesID);
        return this.getSeriesType(id);
    }

    public void setSeriesType(int newValue) {
        this.putToLookAndRepaint(Attr.SeriesType, new Integer(newValue), 1);
    }

    public void setSeriesType(IdentObj id, int newValue) {
        this.putToLookAndRepaint(id, Attr.SeriesType, new Integer(newValue));
    }

    public void setSeriesType(int seriesID, int newValue) {
        IdentObj id = new IdentObj(-3, seriesID, -3);
        this.setSeriesType(id, newValue);
    }

    public int getDataLineThickness() {
        Integer m_Obj = (Integer)this.getFromLookSimple(s_identObjGlobal, Attr.DataLineThickness);
        return m_Obj;
    }

    public void setDataLineThickness(int newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.DataLineThickness, new Integer(newValue));
    }

    public boolean getLegendReverse() {
        Boolean m_Obj = (Boolean)this.getFromLookSimple(s_identObjGlobal, Attr.LegendReverse);
        return m_Obj;
    }

    public void setLegendReverse(boolean newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.LegendReverse, newValue);
    }

    public String getY2TitleString() {
        return this.getTextString(new IdentObj(7));
    }

    public void setY2TitleString(String newValue) {
        this.setTextString(new IdentObj(7), newValue);
    }

    public boolean getDisplayBarAsPictograph() {
        Boolean m_Obj = (Boolean)this.getFromLookSimple(s_identObjGlobal, Attr.DisplayBarAsPictograph);
        return m_Obj;
    }

    public void setDisplayBarAsPictograph(boolean newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.DisplayBarAsPictograph, newValue);
    }

    public String getDataTextTemplateHiLo() {
        String m_Obj = (String)this.getFromLookSimple(s_identObjGlobal, Attr.DataTextTemplateHiLo);
        return m_Obj;
    }

    public void setDataTextTemplateHiLo(String newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.DataTextTemplateHiLo, newValue);
    }

    public String getTextFormatPattern() {
        String m_Obj = (String)this.getFromLook(Attr.TextFormatPattern);
        return m_Obj;
    }

    public String getTextFormatPattern(IdentObj id) {
        String m_Obj = (String)this.getFromLook(id, Attr.TextFormatPattern);
        return m_Obj;
    }

    public String getTextFormatPattern(int objectID) {
        return this.getTextFormatPattern(new IdentObj(objectID));
    }

    public void setTextFormatPattern(String newValue) {
        this.putToLookAndRepaint(Attr.TextFormatPattern, newValue);
    }

    public void setTextFormatPattern(IdentObj id, String newValue) {
        this.putToLookAndRepaint(id, Attr.TextFormatPattern, newValue);
    }

    public void setTextFormatPattern(int objectID, String newValue) {
        this.setTextFormatPattern(new IdentObj(objectID), newValue);
    }

    public String getDataTextFormatPattern() {
        return this.getTextFormatPattern(s_identObjGlobal);
    }

    public void setDataTextFormatPattern(String newValue) {
        this.setTextFormatPattern(s_identObjGlobal, newValue);
    }

    public int getTextureDisplayMode() {
        Integer m_Obj = (Integer)this.getFromLookSimple(s_identObjGlobal, Attr.TextureDisplayMode);
        return m_Obj;
    }

    public void setTextureDisplayMode(int newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.TextureDisplayMode, new Integer(newValue));
    }

    public double getCubeLightSourceX() {
        Double m_Obj = (Double)this.getFromLookSimple(s_identObjGlobal, Attr.CubeLightSourceX);
        return m_Obj;
    }

    public void setCubeLightSourceX(double newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.CubeLightSourceX, new Double(newValue));
    }

    public double getCubeLightSourceY() {
        Double m_Obj = (Double)this.getFromLookSimple(s_identObjGlobal, Attr.CubeLightSourceY);
        return m_Obj;
    }

    public void setCubeLightSourceY(double newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.CubeLightSourceY, new Double(newValue));
    }

    public String getPieFeelerTextFormatPattern() {
        return this.getTextFormatPattern(new IdentObj(295));
    }

    public void setPieFeelerTextFormatPattern(String newValue) {
        this.setTextFormatPattern(new IdentObj(295), newValue);
    }

    public String getPieRingTotalFormatPattern() {
        return this.getTextFormatPattern(new IdentObj(297));
    }

    public void setPieRingTotalFormatPattern(String newValue) {
        this.setTextFormatPattern(new IdentObj(297), newValue);
    }

    public String getX1LabelFormatPattern() {
        return this.getTextFormatPattern(new IdentObj(280));
    }

    public void setX1LabelFormatPattern(String newValue) {
        this.setTextFormatPattern(new IdentObj(280), newValue);
    }

    public int getQuadrantLineCountX() {
        Integer m_Obj = (Integer)this.getFromLookSimple(s_identObjGlobal, Attr.QuadrantLineCountX);
        if (m_Obj != null) {
            return m_Obj;
        }
        return (Integer)Attr.QuadrantLineCountX.getDefault();
    }

    public void setQuadrantLineCountX(int newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.QuadrantLineCountX, new Integer(newValue));
    }

    public int getO1LabelRotate() {
        return this.getTextRotation(this.getO1Label());
    }

    public void setO1LabelRotate(int newValue) {
        this.setTextRotation(this.getO1Label(), newValue);
    }

    public int getO2LabelRotate() {
        return this.getTextRotation(this.getO2Label());
    }

    public void setO2LabelRotate(int newValue) {
        this.setTextRotation(this.getO2Label(), newValue);
    }

    public int getY1LabelRotate() {
        return this.getTextRotation(new IdentObj(284));
    }

    public void setY1LabelRotate(int newValue) {
        this.setTextRotation(new IdentObj(284), newValue);
    }

    public int getY2LabelRotate() {
        return this.getTextRotation(new IdentObj(288));
    }

    public void setY2LabelRotate(int newValue) {
        this.setTextRotation(new IdentObj(288), newValue);
    }

    public int getX1LabelRotate() {
        return this.getTextRotation(new IdentObj(280));
    }

    public void setX1LabelRotate(int newValue) {
        this.setTextRotation(new IdentObj(280), newValue);
    }

    public String getToolTipCustomString() {
        String m_Obj = (String)this.getFromLook(Attr.ToolTipCustomString, 3);
        return m_Obj;
    }

    public String getToolTipCustomString(IdentObj id) {
        String m_Obj = (String)this.getFromLook(id, Attr.ToolTipCustomString);
        return m_Obj;
    }

    public String getToolTipCustomString(int seriesID) {
        IdentObj id = new IdentObj(-3, seriesID, -3);
        return this.getToolTipCustomString(id);
    }

    public String getToolTipCustomString(int seriesID, int groupID) {
        IdentObj id = new IdentObj(-3, seriesID, groupID);
        return this.getToolTipCustomString(id);
    }

    public void setToolTipCustomString(String newValue) {
        this.putToLookAndRepaint(Attr.ToolTipCustomString, newValue, 3);
    }

    public void setToolTipCustomString(IdentObj id, String newValue) {
        this.putToLookAndRepaint(id, Attr.ToolTipCustomString, newValue);
    }

    public void setToolTipCustomString(int seriesID, String newValue) {
        IdentObj id = new IdentObj(-3, seriesID, -3);
        this.setToolTipCustomString(id, newValue);
    }

    public void setToolTipCustomString(int seriesID, int groupID, String newValue) {
        IdentObj id = new IdentObj(-3, seriesID, groupID);
        this.setToolTipCustomString(id, newValue);
    }

    public double getCubeLightSourceZ() {
        Double m_Obj = (Double)this.getFromLookSimple(s_identObjGlobal, Attr.CubeLightSourceZ);
        return m_Obj;
    }

    public void setCubeLightSourceZ(double newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.CubeLightSourceZ, new Double(newValue));
    }

    public String getY1LabelFormatPattern() {
        return this.getTextFormatPattern(new IdentObj(284));
    }

    public void setY1LabelFormatPattern(String newValue) {
        this.setTextFormatPattern(new IdentObj(284), newValue);
    }

    public String getY2LabelFormatPattern() {
        return this.getTextFormatPattern(new IdentObj(288));
    }

    public void setY2LabelFormatPattern(String newValue) {
        this.setTextFormatPattern(new IdentObj(288), newValue);
    }

    public int getTextAutofitMin() {
        Integer m_Obj = (Integer)this.getFromLookSimple(s_identObjGlobal, Attr.TextAutofitMin);
        return m_Obj;
    }

    public void setTextAutofitMin(int newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.TextAutofitMin, new Integer(newValue));
    }

    public int getTextAutofitMax() {
        Integer m_Obj = (Integer)this.getFromLookSimple(s_identObjGlobal, Attr.TextAutofitMax);
        return m_Obj;
    }

    public void setTextAutofitMax(int newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.TextAutofitMax, new Integer(newValue));
    }

    public int getQuadrantLineCountY() {
        Integer m_Obj = (Integer)this.getFromLookSimple(s_identObjGlobal, Attr.QuadrantLineCountY);
        if (m_Obj != null) {
            return m_Obj;
        }
        return (Integer)Attr.QuadrantLineCountY.getDefault();
    }

    public void setQuadrantLineCountY(int newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.QuadrantLineCountY, new Integer(newValue));
    }

    public int getZoomDirection() {
        Integer m_Obj = (Integer)this.getObjProp(Attr.ZoomDirection);
        return m_Obj;
    }

    public void setZoomDirection(int newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.ZoomDirection, new Integer(newValue));
    }

    public void setIntegerProp(int newValue, Attr attr) {
        this.putToLookAndRepaint(s_identObjGlobal, attr, new Integer(newValue));
    }

    public int getIntegerProp(Attr attr) {
        Integer m_Obj = (Integer)this.getObjProp(attr);
        if (m_Obj != null) {
            return m_Obj;
        }
        return (Integer)attr.getDefault();
    }

    public void setLongProp(long newValue, Attr attr) {
        this.putToLookAndRepaint(s_identObjGlobal, attr, new Long(newValue));
    }

    public long getLongProp(Attr attr) {
        Long m_Obj = (Long)this.getObjProp(attr);
        if (m_Obj != null) {
            return m_Obj;
        }
        return (Long)attr.getDefault();
    }

    public void setDoubleProp(double newValue, Attr attr) {
        this.putToLookAndRepaint(s_identObjGlobal, attr, new Double(newValue));
    }

    public double getDoubleProp(Attr attr) {
        Double m_Obj = (Double)this.getObjProp(attr);
        if (m_Obj != null) {
            return m_Obj;
        }
        return (Double)attr.getDefault();
    }

    public void setBooleanProp(boolean newValue, Attr attr) {
        this.putToLookAndRepaint(s_identObjGlobal, attr, newValue);
    }

    public boolean getBooleanProp(Attr attr) {
        Boolean m_Obj = (Boolean)this.getObjProp(attr);
        if (m_Obj != null) {
            return m_Obj;
        }
        return (Boolean)attr.getDefault();
    }

    public void setObjProp(Object obj, Attr attr) {
        this.putToLookAndRepaint(s_identObjGlobal, attr, obj);
    }

    public Object getObjProp(Attr attr) {
        return this.getFromLookSimple(s_identObjGlobal, attr);
    }

    public void setObjProp(Object obj, Attr attr, IdentObj ident) {
        this.putToLookAndRepaint(ident, attr, obj);
    }

    public Object getObjProp(Attr attr, IdentObj ident) {
        return this.getFromLook(ident, attr);
    }

    public boolean getIgnoreSeries() {
        Boolean m_Obj = (Boolean)this.getFromLook(Attr.IgnoreSeries, 1);
        return m_Obj;
    }

    public boolean getIgnoreSeries(int seriesID) {
        IdentObj id = this.getIdentObj(-3, seriesID);
        Boolean m_Obj = (Boolean)this.getFromLookSimple(id, Attr.IgnoreSeries);
        return m_Obj;
    }

    public void setIgnoreSeries(boolean newValue) {
        this.putToLookAndRepaint(Attr.IgnoreSeries, newValue, 1);
    }

    public void setIgnoreSeries(int seriesID, boolean newValue) {
        IdentObj id = new IdentObj(-3, seriesID);
        this.putToLookAndRepaint(id, Attr.IgnoreSeries, newValue);
    }

    public int getDataScrollerPresenceGroups() {
        if (this.isUseRangeSlider() || !(this.m_chart instanceof JChart_2D_BLA) && !(this.m_chart instanceof JChart_2D_Scat)) {
            return 0;
        }
        Integer m_Obj = (Integer)this.getObjProp(Attr.DataScrollerPresenceGroups);
        return m_Obj;
    }

    public void setDataScrollerPresenceGroups(int newValue) {
        newValue = this.setButtonPresenceFromScrollPresence(newValue);
        this.putToLookAndRepaint(s_identObjGlobal, Attr.DataScrollerPresenceGroups, new Integer(newValue));
    }

    public int getDataScrollerPresenceX1() {
        if (this.isUseRangeSlider() || !(this.m_chart instanceof JChart_2D_BLA) && !(this.m_chart instanceof JChart_2D_Scat)) {
            return 0;
        }
        Integer m_Obj = (Integer)this.getObjProp(Attr.DataScrollerPresenceX1);
        return m_Obj;
    }

    public void setDataScrollerPresenceX1(int newValue) {
        newValue = this.setButtonPresenceFromScrollPresence(newValue);
        this.putToLookAndRepaint(s_identObjGlobal, Attr.DataScrollerPresenceX1, new Integer(newValue));
    }

    public int getDataScrollerPresenceY1() {
        if (this.isUseRangeSlider() || !(this.m_chart instanceof JChart_2D_BLA) && !(this.m_chart instanceof JChart_2D_Scat)) {
            return 0;
        }
        Integer m_Obj = (Integer)this.getObjProp(Attr.DataScrollerPresenceY1);
        return m_Obj;
    }

    public void setDataScrollerPresenceY1(int newValue) {
        newValue = this.setButtonPresenceFromScrollPresence(newValue);
        this.putToLookAndRepaint(s_identObjGlobal, Attr.DataScrollerPresenceY1, new Integer(newValue));
    }

    public int getDataScrollerPresenceY2() {
        if (this.isUseRangeSlider() || !(this.m_chart instanceof JChart_2D_BLA) && !(this.m_chart instanceof JChart_2D_Scat)) {
            return 0;
        }
        Integer m_Obj = (Integer)this.getObjProp(Attr.DataScrollerPresenceY2);
        return m_Obj;
    }

    public void setDataScrollerPresenceY2(int newValue) {
        newValue = this.setButtonPresenceFromScrollPresence(newValue);
        this.putToLookAndRepaint(s_identObjGlobal, Attr.DataScrollerPresenceY2, new Integer(newValue));
    }

    private int setButtonPresenceFromScrollPresence(int newValue) {
        if (newValue == 4) {
            this.setZoomButtonPresence(1);
            return 2;
        }
        return newValue;
    }

    public int getZoomButtonPresence() {
        Integer m_Obj = (Integer)this.getObjProp(Attr.ZoomButtonPresence);
        return m_Obj;
    }

    public void setZoomButtonPresence(int newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.ZoomButtonPresence, new Integer(newValue));
    }

    public int getPieBarSeries() {
        Integer m_Obj = (Integer)this.getObjProp(Attr.PieBarSeries);
        return m_Obj;
    }

    public void setPieBarSeries(int newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.PieBarSeries, new Integer(newValue));
    }

    public int getO1LabelMargin() {
        return this.getLabelMargin(this.getO1Label());
    }

    public void setO1LabelMargin(int newValue) {
        this.setLabelMargin(this.getO1Label(), newValue);
    }

    public int getLabelMargin() {
        Integer m_Obj = (Integer)this.getFromLook(Attr.LabelMargin);
        return m_Obj;
    }

    public int getLabelMargin(IdentObj id) {
        Integer m_Obj = (Integer)this.getFromLook(id, Attr.LabelMargin);
        return m_Obj;
    }

    public int getLabelMargin(int objectID) {
        return this.getLabelMargin(new IdentObj(objectID));
    }

    public void setLabelMargin(int newValue) {
        this.putToLookAndRepaint(Attr.LabelMargin, new Integer(newValue));
    }

    public void setLabelMargin(IdentObj id, int newValue) {
        this.putToLookAndRepaint(id, Attr.LabelMargin, new Integer(newValue));
    }

    public void setLabelMargin(int objectID, int newValue) {
        this.setLabelMargin(new IdentObj(objectID), newValue);
    }

    public int getDataScrollerPresenceSeries() {
        Integer m_Obj = (Integer)this.getObjProp(Attr.DataScrollerPresenceSeries);
        return m_Obj;
    }

    public void setDataScrollerPresenceSeries(int newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.DataScrollerPresenceSeries, new Integer(newValue));
    }

    public boolean getBiDirectional() {
        Boolean m_Obj = (Boolean)this.getFromLookSimple(s_identObjGlobal, Attr.BiDirectional);
        return m_Obj;
    }

    public void setBiDirectional(boolean newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.BiDirectional, newValue);
    }

    public int getAxisTextAutofitMax() {
        Integer m_Obj = (Integer)this.getObjProp(Attr.AxisTextAutofitMax);
        return m_Obj;
    }

    public Object getAxisTextAutofitMaxObj() {
        return this.getFromLookSimple(s_identObjGlobal, Attr.AxisTextAutofitMax);
    }

    public void setAxisTextAutofitMax(int newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.AxisTextAutofitMax, new Integer(newValue));
    }

    public int getAxisTextAutofitMin() {
        Integer m_Obj = (Integer)this.getObjProp(Attr.AxisTextAutofitMin);
        return m_Obj;
    }

    public void setAxisTextAutofitMin(int newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.AxisTextAutofitMin, new Integer(newValue));
    }

    public int getAxisTextAutofitMode() {
        Integer m_Obj = (Integer)this.getFromLookSimple(s_identObjGlobal, Attr.AxisTextAutofitMode);
        return m_Obj;
    }

    public void setAxisTextAutofitMode(int newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.AxisTextAutofitMode, new Integer(newValue));
    }

    public int getAxisTextAutofitPercent() {
        Integer m_Obj = (Integer)this.getFromLookSimple(s_identObjGlobal, Attr.AxisTextAutofitPercent);
        return m_Obj;
    }

    public void setAxisTextAutofitPercent(int newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.AxisTextAutofitPercent, new Integer(newValue));
    }

    public boolean getNestedLabels() {
        Boolean m_Obj = (Boolean)this.getFromLookSimple(s_identObjGlobal, Attr.NestedLabels);
        return m_Obj;
    }

    public void setNestedLabels(boolean newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.NestedLabels, newValue);
    }

    public boolean getNestedLabelsUniformStyle() {
        Boolean m_Obj = (Boolean)this.getFromLookSimple(s_identObjGlobal, Attr.NestedLabelsUniformStyle);
        return m_Obj;
    }

    public void setNestedLabelsUniformStyle(boolean newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.NestedLabelsUniformStyle, newValue);
    }

    public String getDataTextTemplateScatter() {
        String m_Obj = (String)this.getFromLookSimple(s_identObjGlobal, Attr.DataTextTemplateScatter);
        return m_Obj;
    }

    public void setDataTextTemplateScatter(String newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.DataTextTemplateScatter, newValue);
    }

    public String getDataTextTemplateBubble() {
        String m_Obj = (String)this.getFromLookSimple(s_identObjGlobal, Attr.DataTextTemplateBubble);
        return m_Obj;
    }

    public void setDataTextTemplateBubble(String newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.DataTextTemplateBubble, newValue);
    }

    public int getFontSize() {
        Integer m_Obj = (Integer)this.getFromLook(Attr.FontSize);
        return m_Obj;
    }

    public int getFontSize(IdentObj id) {
        Integer m_Obj = (Integer)this.getFontSizeObj(id);
        if (m_Obj != null) {
            return m_Obj;
        }
        Attr a = Attr.FontSize;
        switch (id.getObjectID()) {
            case 22: 
            case 23: 
            case 24: 
            case 28: 
            case 29: 
            case 30: {
                a = Attr.ScrollerFontSize;
                break;
            }
            case 5: {
                a = Attr.TitleFontSize;
                break;
            }
            case 4: {
                a = Attr.SubtitleFontSize;
                break;
            }
            case 3: {
                a = Attr.FootnoteFontSize;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 67: 
            case 69: 
            case 71: 
            case 232: 
            case 233: {
                a = Attr.AxisTitleFontSize;
                break;
            }
            case 514: {
                a = Attr.ToolTipFontSize;
            }
        }
        return (Integer)a.getDefault();
    }

    public Object getFontSizeObj(IdentObj id, boolean useDefault) {
        Attr a = Attr.FontSize;
        switch (id.getObjectID()) {
            case 22: 
            case 23: 
            case 24: 
            case 28: 
            case 29: 
            case 30: {
                a = Attr.ScrollerFontSize;
                break;
            }
            case 5: {
                a = Attr.TitleFontSize;
                break;
            }
            case 4: {
                a = Attr.SubtitleFontSize;
                break;
            }
            case 3: {
                a = Attr.FootnoteFontSize;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 67: 
            case 69: 
            case 71: 
            case 232: 
            case 233: {
                a = Attr.AxisTitleFontSize;
                break;
            }
            case 514: {
                a = Attr.ToolTipFontSize;
            }
        }
        if (useDefault) {
            return this.getFromLook(id, a);
        }
        return this.getFromLook2(id, a);
    }

    public Object getFontSizeObj(IdentObj id) {
        return this.getFontSizeObj(id, true);
    }

    public int getFontSize(int objectID) {
        return this.getFontSize(new IdentObj(objectID));
    }

    public void setFontSize(int newValue) {
        this.putToLookAndRepaint(Attr.FontSize, new Integer(newValue));
    }

    public void setFontSize(IdentObj id, int newValue) {
        Attr a = Attr.FontSize;
        switch (id.getObjectID()) {
            case 22: 
            case 23: 
            case 24: 
            case 28: 
            case 29: 
            case 30: {
                a = Attr.ScrollerFontSize;
                break;
            }
            case 5: {
                a = Attr.TitleFontSize;
                break;
            }
            case 4: {
                a = Attr.SubtitleFontSize;
                break;
            }
            case 3: {
                a = Attr.FootnoteFontSize;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 67: 
            case 69: 
            case 71: 
            case 232: 
            case 233: {
                a = Attr.AxisTitleFontSize;
                break;
            }
            case 514: {
                a = Attr.ToolTipFontSize;
            }
        }
        this.putToLookAndRepaint(id, a, new Integer(newValue));
    }

    public void setFontSize(int objectID, int newValue) {
        this.setFontSize(new IdentObj(objectID), newValue);
    }

    public int getLegendMarkersPerRow() {
        Integer m_Obj = (Integer)this.getFromLookSimple(s_identObjGlobal, Attr.LegendMarkersPerRow);
        return m_Obj;
    }

    public void setLegendMarkersPerRow(int newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.LegendMarkersPerRow, new Integer(newValue));
    }

    public int getLegendOrient() {
        Integer m_Obj = (Integer)this.getFromLookSimple(s_identObjGlobal, Attr.LegendOrient);
        return m_Obj;
    }

    public void setLegendOrient(int newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.LegendOrient, new Integer(newValue));
    }

    public int getTextDirection() {
        Integer m_Obj = (Integer)this.getFromLookSimple(s_identObjGlobal, Attr.TextDirection);
        return m_Obj;
    }

    public void setTextDirection(int newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.TextDirection, new Integer(newValue));
    }

    public double getLogScaleBase() {
        Double m_Obj = (Double)this.getFromLook(Attr.LogScaleBase);
        return m_Obj;
    }

    public double getLogScaleBase(IdentObj id) {
        Double m_Obj = (Double)this.getLogScaleBaseObj(id);
        return m_Obj;
    }

    public Object getLogScaleBaseObj(IdentObj id) {
        return this.getFromLook(id, Attr.LogScaleBase);
    }

    public double getLogScaleBase(int objectID) {
        return this.getLogScaleBase(new IdentObj(objectID));
    }

    public void setLogScaleBase(double newValue) {
        this.putToLookAndRepaint(Attr.LogScaleBase, new Double(newValue));
    }

    public void setLogScaleBase(IdentObj id, double newValue) {
        this.putToLookAndRepaint(id, Attr.LogScaleBase, new Double(newValue));
    }

    public void setLogScaleBase(int objectID, double newValue) {
        this.setLogScaleBase(new IdentObj(objectID), newValue);
    }

    public boolean getMoveAxisTitles() {
        Boolean m_Obj = (Boolean)this.getFromLookSimple(s_identObjGlobal, Attr.MoveAxisTitles);
        return m_Obj;
    }

    public void setMoveAxisTitles(boolean newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.MoveAxisTitles, newValue);
    }

    public String getPieBarLabelString() {
        return this.getTextString(new IdentObj(355));
    }

    public void setPieBarLabelString(String newValue) {
        this.setTextString(new IdentObj(355), newValue);
    }

    public boolean getPieBarLabelDisplay() {
        return this.getDisplay(new IdentObj(355));
    }

    public void setPieBarLabelDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(355), newValue);
    }

    public int getTextureFlipMode() {
        Integer m_Obj = (Integer)this.getFromLookSimple(s_identObjGlobal, Attr.TextureFlipMode);
        return m_Obj;
    }

    public void setTextureFlipMode(int newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.TextureFlipMode, new Integer(newValue));
    }

    public boolean getExtendToFrameEdge() {
        Boolean m_Obj = (Boolean)this.getFromLookSimple(s_identObjGlobal, Attr.ExtendToFrameEdge);
        return m_Obj;
    }

    public void setExtendToFrameEdge(boolean newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.ExtendToFrameEdge, newValue);
    }

    public int getDisplayParetoSeries() {
        Integer m_Obj = (Integer)this.getFromLookSimple(s_identObjGlobal, Attr.DisplayParetoSeries);
        if (m_Obj != null) {
            return m_Obj;
        }
        return (Integer)Attr.DisplayParetoSeries.getDefault();
    }

    public void setDisplayParetoSeries(int newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.DisplayParetoSeries, new Integer(newValue));
    }

    public boolean getConnectParetoBars() {
        Boolean m_Obj = (Boolean)this.getObjProp(Attr.ConnectParetoBars);
        return m_Obj;
    }

    public void setConnectParetoBars(boolean newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.ConnectParetoBars, newValue);
    }

    public double getParetoY2MajorGridStep() {
        Double m_Obj = (Double)this.getFromLookSimple(s_identObjGlobal, Attr.ParetoY2MajorGridStep);
        return m_Obj;
    }

    public void setParetoY2MajorGridStep(double newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.ParetoY2MajorGridStep, new Double(newValue));
    }

    public int getAxisSize() {
        Integer m_Obj = (Integer)this.getFromLook(Attr.AxisSize);
        return m_Obj;
    }

    public int getAxisSize(IdentObj id) {
        Integer m_Obj = (Integer)this.getFromLook(id, Attr.AxisSize);
        return m_Obj;
    }

    public int getAxisSize(int objectID) {
        return this.getAxisSize(new IdentObj(objectID));
    }

    public void setAxisSize(int newValue) {
        this.putToLookAndRepaint(Attr.AxisSize, new Integer(newValue));
    }

    public void setAxisSize(IdentObj id, int newValue) {
        this.putToLookAndRepaint(id, Attr.AxisSize, new Integer(newValue));
    }

    public void setAxisSize(int objectID, int newValue) {
        this.setAxisSize(new IdentObj(objectID), newValue);
    }

    public int getAxisOffset() {
        Integer m_Obj = (Integer)this.getFromLook(Attr.AxisOffset);
        return m_Obj;
    }

    public int getAxisOffset(IdentObj id) {
        Integer m_Obj = (Integer)this.getFromLook(id, Attr.AxisOffset);
        return m_Obj;
    }

    public int getAxisOffset(int objectID) {
        return this.getAxisOffset(new IdentObj(objectID));
    }

    public void setAxisOffset(int newValue) {
        this.putToLookAndRepaint(Attr.AxisOffset, new Integer(newValue));
    }

    public void setAxisOffset(IdentObj id, int newValue) {
        this.putToLookAndRepaint(id, Attr.AxisOffset, new Integer(newValue));
    }

    public void setAxisOffset(int objectID, int newValue) {
        this.setAxisOffset(new IdentObj(objectID), newValue);
    }

    public boolean getPrimitiveAntialiasing() {
        Boolean m_Obj = (Boolean)this.getObjProp(Attr.PrimitiveAntialiasing);
        return m_Obj;
    }

    public void setPrimitiveAntialiasing(boolean newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.PrimitiveAntialiasing, newValue);
    }

    public boolean getTextAntialiasing() {
        Boolean m_Obj = (Boolean)this.getObjProp(Attr.TextAntialiasing);
        return m_Obj;
    }

    public void setTextAntialiasing(boolean newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.TextAntialiasing, newValue);
    }

    public boolean getTextTruncate() {
        Boolean m_Obj = (Boolean)this.getFromLook(Attr.TextTruncate);
        return m_Obj;
    }

    public boolean getTextTruncate(IdentObj id) {
        Boolean m_Obj = (Boolean)this.getFromLook(id, Attr.TextTruncate);
        return m_Obj;
    }

    public boolean getTextTruncate(int objectID) {
        return this.getTextTruncate(new IdentObj(objectID));
    }

    public void setTextTruncate(boolean newValue) {
        this.putToLookAndRepaint(Attr.TextTruncate, newValue);
    }

    public void setTextTruncate(IdentObj id, boolean newValue) {
        this.putToLookAndRepaint(id, Attr.TextTruncate, newValue);
    }

    public void setTextTruncate(int objectID, boolean newValue) {
        this.setTextTruncate(new IdentObj(objectID), newValue);
    }

    public int getParetoDisplayThreshold() {
        Integer m_Obj = (Integer)this.getFromLookSimple(s_identObjGlobal, Attr.ParetoDisplayThreshold);
        return m_Obj;
    }

    public void setParetoDisplayThreshold(int newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.ParetoDisplayThreshold, new Integer(newValue));
    }

    public boolean getNonZeroBaseline() {
        Boolean m_Obj = (Boolean)this.getFromLook(Attr.NonZeroBaseline);
        return m_Obj;
    }

    public boolean getNonZeroBaseline(IdentObj id) {
        Boolean m_Obj = (Boolean)this.getFromLook(id, Attr.NonZeroBaseline);
        return m_Obj;
    }

    public boolean getNonZeroBaseline(int objectID) {
        return this.getNonZeroBaseline(new IdentObj(objectID));
    }

    public void setNonZeroBaseline(boolean newValue) {
        this.putToLookAndRepaint(Attr.NonZeroBaseline, newValue);
    }

    public void setNonZeroBaseline(IdentObj id, boolean newValue) {
        this.putToLookAndRepaint(id, Attr.NonZeroBaseline, newValue);
    }

    public void setNonZeroBaseline(int objectID, boolean newValue) {
        this.setNonZeroBaseline(new IdentObj(objectID), newValue);
    }

    public boolean getTransparentMarkers() {
        Boolean m_Obj = (Boolean)this.getFromLookSimple(s_identObjGlobal, Attr.TransparentMarkers);
        return m_Obj;
    }

    public void setTransparentMarkers(boolean newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.TransparentMarkers, newValue);
    }

    public int getTransparentMarkerSize() {
        Integer m_Obj = (Integer)this.getFromLookSimple(s_identObjGlobal, Attr.TransparentMarkerSize);
        return m_Obj;
    }

    public void setTransparentMarkerSize(int newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.TransparentMarkerSize, new Integer(newValue));
    }

    public int getSeriesLineWidthDefault() {
        Integer m_Obj = (Integer)this.getFromLookSimple(s_identObjGlobal, Attr.SeriesLineWidthDefault);
        return m_Obj;
    }

    public void setSeriesLineWidthDefault(int newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.SeriesLineWidthDefault, new Integer(newValue));
    }

    public boolean getIgnoreGridSkip() {
        Boolean m_Obj = (Boolean)this.getFromLookSimple(s_identObjGlobal, Attr.IgnoreGridSkip);
        return m_Obj;
    }

    public void setIgnoreGridSkip(boolean newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.IgnoreGridSkip, newValue);
    }

    public boolean getToolTipTimeOutEnabled() {
        Boolean m_Obj = (Boolean)this.getFromLookSimple(s_identObjGlobal, Attr.ToolTipTimeOutEnabled);
        return m_Obj;
    }

    public void setToolTipTimeOutEnabled(boolean newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.ToolTipTimeOutEnabled, newValue);
    }

    public boolean getToolTipDisplayTimeOut() {
        Boolean m_Obj = (Boolean)this.getFromLookSimple(s_identObjGlobal, Attr.ToolTipDisplayTimeOut);
        return m_Obj;
    }

    public void setToolTipDisplayTimeOut(boolean newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.ToolTipDisplayTimeOut, newValue);
    }

    public boolean getUseDefaultBubbleMarker(IdentObj id) {
        if (id != null) {
            Boolean m_Obj = (Boolean)this.getFromLookSimple(id, Attr.UseDefaultBubbleMarker);
            return m_Obj;
        }
        return true;
    }

    public boolean getUseDefaultBubbleMarker() {
        Boolean m_Obj = (Boolean)this.getFromLookSimple(s_identObjGlobal, Attr.UseDefaultBubbleMarker);
        return m_Obj;
    }

    public void setUseDefaultBubbleMarker(boolean newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.UseDefaultBubbleMarker, newValue);
    }

    public void setUseDefaultBubbleMarker(IdentObj id, boolean newValue) {
        if (id != null) {
            this.putToLookAndRepaint(id, Attr.UseDefaultBubbleMarker, newValue);
        }
    }

    public boolean getSizeToContainer() {
        Boolean m_Obj = (Boolean)this.getFromLookSimple(s_identObjGlobal, Attr.SizeToContainer);
        return m_Obj;
    }

    public void setSizeToContainer(boolean newValue) {
        this.putToLookAndRepaint(s_identObjGlobal, Attr.SizeToContainer, newValue);
    }

    public IdentObj getIdentObj(int objectId) {
        this.m_identObj.init(objectId);
        return this.m_identObj;
    }

    public IdentObj getIdentObj(int objectId, int seriesId) {
        this.m_identObj.init(objectId, seriesId);
        return this.m_identObj;
    }

    public IdentObj getIdentObj(int objectId, int seriesId, int groupId) {
        this.m_identObj.init(objectId, seriesId, groupId);
        return this.m_identObj;
    }

    public IdentObj getChartBackground() {
        return new IdentObj(1);
    }

    public IdentObj getFrame() {
        return new IdentObj(2);
    }

    public IdentObj getNoDataErrorText() {
        return new IdentObj(346);
    }

    public IdentObj getFootnote() {
        return new IdentObj(3);
    }

    public IdentObj getSubtitle() {
        return new IdentObj(4);
    }

    public IdentObj getTitle() {
        return new IdentObj(5);
    }

    public IdentObj getToolTip() {
        return new IdentObj(514);
    }

    public IdentObj getToolTipFrame() {
        return new IdentObj(515);
    }

    public IdentObj getY1Title() {
        return new IdentObj(6);
    }

    public IdentObj getY2Title() {
        return new IdentObj(7);
    }

    public IdentObj getY3Title() {
        return new IdentObj(67);
    }

    public IdentObj getY4Title() {
        return new IdentObj(69);
    }

    public IdentObj getY5Title() {
        return new IdentObj(71);
    }

    public IdentObj getO1Title() {
        return new IdentObj(8);
    }

    public IdentObj getO2Title() {
        return new IdentObj(9);
    }

    public IdentObj getX1Title() {
        return new IdentObj(10);
    }

    public IdentObj getO1DrillLabel() {
        return new IdentObj(232);
    }

    public IdentObj getO2DrillLabel() {
        return new IdentObj(233);
    }

    public IdentObj getDrillMarker() {
        return new IdentObj(234);
    }

    public IdentObj getDrillText() {
        return new IdentObj(235);
    }

    public IdentObj getLegendArea() {
        return new IdentObj(12);
    }

    public IdentObj getLegendMarker() {
        return new IdentObj(13);
    }

    public IdentObj getLegendText() {
        return new IdentObj(14);
    }

    public IdentObj getFrameSide() {
        return new IdentObj(15);
    }

    public IdentObj getFrameBottom() {
        return new IdentObj(16);
    }

    public IdentObj getFrameSeparator() {
        return new IdentObj(17);
    }

    public IdentObj getSpectralLegendMarker() {
        return new IdentObj(18);
    }

    public IdentObj getGroupScroller() {
        return new IdentObj(19);
    }

    public IdentObj getGroupScrollerThumb() {
        return new IdentObj(20);
    }

    public IdentObj getGroupScrollerEditBox() {
        return new IdentObj(21);
    }

    public IdentObj getGroupScrollerEditLeft() {
        return new IdentObj(22);
    }

    public IdentObj getGroupScrollerEditThumb() {
        return new IdentObj(23);
    }

    public IdentObj getGroupScrollerEditRight() {
        return new IdentObj(24);
    }

    public IdentObj getSeriesScroller() {
        return new IdentObj(25);
    }

    public IdentObj getSeriesScrollerThumb() {
        return new IdentObj(26);
    }

    public IdentObj getSeriesScrollerEditBox() {
        return new IdentObj(27);
    }

    public IdentObj getSeriesScrollerEditLeft() {
        return new IdentObj(28);
    }

    public IdentObj getSeriesScrollerEditThumb() {
        return new IdentObj(29);
    }

    public IdentObj getSeriesScrollerEditRight() {
        return new IdentObj(30);
    }

    public IdentObj getNestedO1Label0() {
        return new IdentObj(31);
    }

    public IdentObj getNestedO1Label1() {
        return new IdentObj(32);
    }

    public IdentObj getNestedO1Label2() {
        return new IdentObj(33);
    }

    public IdentObj getNestedO1Label3() {
        return new IdentObj(34);
    }

    public IdentObj getNestedO1Label4() {
        return new IdentObj(35);
    }

    public IdentObj getNestedO1Label5() {
        return new IdentObj(36);
    }

    public IdentObj getNestedO1Label6() {
        return new IdentObj(37);
    }

    public IdentObj getNestedO1Label7() {
        return new IdentObj(38);
    }

    public IdentObj getNestedO1Label8() {
        return new IdentObj(39);
    }

    public IdentObj getNestedO1LabelLine() {
        return new IdentObj(40);
    }

    public IdentObj getCurveFitLineRiser() {
        return new IdentObj(41);
    }

    public IdentObj getCurveFitEquationText() {
        return new IdentObj(42);
    }

    public IdentObj getCurveFitCorrelationText() {
        return new IdentObj(43);
    }

    public IdentObj getFootnoteBox() {
        return new IdentObj(44);
    }

    public IdentObj getSubtitleBox() {
        return new IdentObj(45);
    }

    public IdentObj getTitleBox() {
        return new IdentObj(46);
    }

    public IdentObj getO1TitleBox() {
        return new IdentObj(49);
    }

    public IdentObj getO2TitleBox() {
        return new IdentObj(50);
    }

    public IdentObj getX1TitleBox() {
        return new IdentObj(51);
    }

    public IdentObj getY1TitleBox() {
        return new IdentObj(47);
    }

    public IdentObj getY2TitleBox() {
        return new IdentObj(48);
    }

    public IdentObj getZ1TitleBox() {
        return new IdentObj(52);
    }

    public IdentObj getO1DrillLabelBox() {
        return new IdentObj(230);
    }

    public IdentObj getO2DrillLabelBox() {
        return new IdentObj(231);
    }

    public IdentObj getLegendTextBox() {
        return new IdentObj(53);
    }

    public IdentObj getNestedO1Label0Box() {
        return new IdentObj(54);
    }

    public IdentObj getNestedO1Label1Box() {
        return new IdentObj(55);
    }

    public IdentObj getNestedO1Label2Box() {
        return new IdentObj(56);
    }

    public IdentObj getNestedO1Label3Box() {
        return new IdentObj(57);
    }

    public IdentObj getNestedO1Label4Box() {
        return new IdentObj(58);
    }

    public IdentObj getNestedO1Label5Box() {
        return new IdentObj(59);
    }

    public IdentObj getNestedO1Label6Box() {
        return new IdentObj(60);
    }

    public IdentObj getNestedO1Label7Box() {
        return new IdentObj(61);
    }

    public IdentObj getNestedO1Label8Box() {
        return new IdentObj(62);
    }

    public IdentObj getCurveFitEquationTextBox() {
        return new IdentObj(63);
    }

    public IdentObj getCurveFitCorrelationTextBox() {
        return new IdentObj(64);
    }

    public IdentObj getAreaRiser() {
        return new IdentObj(256);
    }

    public IdentObj getLineRiser() {
        return new IdentObj(258);
    }

    public IdentObj getLineMarker() {
        return new IdentObj(259);
    }

    public IdentObj getDataText() {
        return new IdentObj(260);
    }

    public IdentObj getO1AxisLine() {
        return new IdentObj(269);
    }

    public IdentObj getO1Label() {
        return new IdentObj(270, -3, 0);
    }

    public IdentObj getO1MajorGrid() {
        return new IdentObj(271, true);
    }

    public IdentObj getO1MinorGrid() {
        return new IdentObj(272, true);
    }

    public IdentObj getO2AxisLine() {
        return new IdentObj(273);
    }

    public IdentObj getO2Label() {
        return new IdentObj(274, 0, -3);
    }

    public IdentObj getO2MajorGrid() {
        return new IdentObj(275, true);
    }

    public IdentObj getO2MinorGrid() {
        return new IdentObj(276, true);
    }

    public IdentObj getBarRiser() {
        return new IdentObj(277);
    }

    public IdentObj getX1AxisLine() {
        return new IdentObj(279);
    }

    public IdentObj getX1Label() {
        return new IdentObj(280);
    }

    public IdentObj getX1MajorGrid() {
        return new IdentObj(281, true);
    }

    public IdentObj getX1MinorGrid() {
        return new IdentObj(282, true);
    }

    public IdentObj getY1AxisLine() {
        return new IdentObj(283);
    }

    public IdentObj getY1Label() {
        return new IdentObj(284);
    }

    public IdentObj getY1MajorGrid() {
        return new IdentObj(285, true);
    }

    public IdentObj getY1MinorGrid() {
        return new IdentObj(286, true);
    }

    public IdentObj getY2AxisLine() {
        return new IdentObj(287);
    }

    public IdentObj getY2Label() {
        return new IdentObj(288);
    }

    public IdentObj getY2MajorGrid() {
        return new IdentObj(289, true);
    }

    public IdentObj getY2MinorGrid() {
        return new IdentObj(290, true);
    }

    public IdentObj getX1ZeroLine() {
        return new IdentObj(291);
    }

    public IdentObj getY1ZeroLine() {
        return new IdentObj(292);
    }

    public IdentObj getY2ZeroLine() {
        return new IdentObj(293);
    }

    public IdentObj getPieFeelerLine() {
        return new IdentObj(294);
    }

    public IdentObj getPieSliceLabel() {
        return new IdentObj(295);
    }

    public IdentObj getPieLabel() {
        return new IdentObj(296);
    }

    public IdentObj getPieRingLabel() {
        return new IdentObj(297);
    }

    public IdentObj getSlice() {
        return new IdentObj(298);
    }

    public IdentObj getPieBarSlice() {
        return new IdentObj(332);
    }

    public IdentObj getSliceCrust() {
        return new IdentObj(299);
    }

    public IdentObj getPieBarSliceCrust() {
        return new IdentObj(333);
    }

    public IdentObj getSliceRing() {
        return new IdentObj(300);
    }

    public IdentObj getPieBarConnectLines() {
        return new IdentObj(301);
    }

    public IdentObj getPieFrame() {
        return new IdentObj(302);
    }

    public IdentObj getStockRiser() {
        return new IdentObj(303);
    }

    public IdentObj getStock52WeekHighLine() {
        return new IdentObj(304);
    }

    public IdentObj getStock52WeekLowLine() {
        return new IdentObj(305);
    }

    public IdentObj getStockLowerRiser() {
        return new IdentObj(306);
    }

    public IdentObj getStockCloseTick() {
        return new IdentObj(307);
    }

    public IdentObj getStockOpenTick() {
        return new IdentObj(308);
    }

    public IdentObj getStockMALine() {
        return new IdentObj(309);
    }

    public IdentObj getStockVolumeRiser() {
        return new IdentObj(310);
    }

    public IdentObj getStockRisingRiser() {
        return new IdentObj(319);
    }

    public IdentObj getStockFallingRiser() {
        return new IdentObj(320);
    }

    public IdentObj getStockHighLine() {
        return new IdentObj(321);
    }

    public IdentObj getStockLowLine() {
        return new IdentObj(322);
    }

    public IdentObj getHistogramRiser() {
        return new IdentObj(311);
    }

    public IdentObj getBarRiserSide() {
        return new IdentObj(312);
    }

    public IdentObj getBarRiserBottom() {
        return new IdentObj(313);
    }

    public IdentObj getAreaRiserTop() {
        return new IdentObj(314);
    }

    public IdentObj getAreaRiserBottom() {
        return new IdentObj(316);
    }

    public IdentObj getLineRiserSide() {
        return new IdentObj(317);
    }

    public IdentObj getLineRiserTop() {
        return new IdentObj(318);
    }

    public IdentObj getQuadrantLine() {
        return new IdentObj(328);
    }

    public IdentObj getScatterQuadrantLine() {
        return new IdentObj(329);
    }

    public IdentObj getSpectralMarker() {
        return new IdentObj(330);
    }

    public IdentObj getPieBarRiser() {
        return new IdentObj(331);
    }

    public IdentObj getPieBarRiserSide() {
        return new IdentObj(334);
    }

    public IdentObj getPieBarRiserTop() {
        return new IdentObj(335);
    }

    public IdentObj getPieBarLabel() {
        return new IdentObj(355);
    }

    public IdentObj getWaterfallLine() {
        return new IdentObj(439);
    }

    public IdentObj getY3AxisLine() {
        return new IdentObj(440);
    }

    public IdentObj getY3Label() {
        return new IdentObj(441);
    }

    public IdentObj getY3MajorGrid() {
        return new IdentObj(442);
    }

    public IdentObj getY3MinorGrid() {
        return new IdentObj(443);
    }

    public IdentObj getY3ZeroLine() {
        return new IdentObj(444);
    }

    public IdentObj getY4AxisLine() {
        return new IdentObj(445);
    }

    public IdentObj getY4Label() {
        return new IdentObj(446);
    }

    public IdentObj getY4MajorGrid() {
        return new IdentObj(447);
    }

    public IdentObj getY4MinorGrid() {
        return new IdentObj(448);
    }

    public IdentObj getY4ZeroLine() {
        return new IdentObj(449);
    }

    public IdentObj getY5AxisLine() {
        return new IdentObj(450);
    }

    public IdentObj getY5Label() {
        return new IdentObj(451);
    }

    public IdentObj getY5MajorGrid() {
        return new IdentObj(452);
    }

    public IdentObj getY5MinorGrid() {
        return new IdentObj(453);
    }

    public IdentObj getY5ZeroLine() {
        return new IdentObj(454);
    }

    public IdentObj getBreakevenLossArea() {
        return new IdentObj(367);
    }

    public IdentObj getBreakevenProfitArea() {
        return new IdentObj(368);
    }

    public IdentObj getBreakevenLossLabel() {
        return new IdentObj(369);
    }

    public IdentObj getBreakevenProfitLabel() {
        return new IdentObj(370);
    }

    public IdentObj getBreakevenSummaryLabel() {
        return new IdentObj(371);
    }

    public IdentObj getCubeFloor() {
        return new IdentObj(603);
    }

    public IdentObj getCubeLeftWall() {
        return new IdentObj(604);
    }

    public IdentObj getCubeRightWall() {
        return new IdentObj(605);
    }

    public IdentObj getCubeRiserFace() {
        return new IdentObj(606);
    }

    public IdentObj getCubeRiserGridX() {
        return new IdentObj(607);
    }

    public IdentObj getCubeRiserGridY() {
        return new IdentObj(608);
    }

    public IdentObj getCubeRiserGridZ() {
        return new IdentObj(609);
    }

    public IdentObj getCubeFloorGridX() {
        return new IdentObj(614);
    }

    public IdentObj getCubeFloorGridZ() {
        return new IdentObj(615);
    }

    public IdentObj getCubeLeftWallGridY() {
        return new IdentObj(616);
    }

    public IdentObj getCubeLeftWallGridZ() {
        return new IdentObj(617);
    }

    public IdentObj getCubeRightWallGridX() {
        return new IdentObj(618);
    }

    public IdentObj getCubeRightWallGridY() {
        return new IdentObj(619);
    }

    public IdentObj getO1Axis() {
        return new IdentObj(2001);
    }

    public IdentObj getO2Axis() {
        return new IdentObj(2002);
    }

    public IdentObj getX1Axis() {
        return new IdentObj(2003);
    }

    public IdentObj getY1Axis() {
        return new IdentObj(2004);
    }

    public IdentObj getY2Axis() {
        return new IdentObj(2005);
    }

    public IdentObj getY3Axis() {
        return new IdentObj(2012);
    }

    public IdentObj getY4Axis() {
        return new IdentObj(2013);
    }

    public IdentObj getY5Axis() {
        return new IdentObj(2014);
    }

    public IdentObj getColorByHeight() {
        return new IdentObj(2007);
    }

    public IdentObj getSeries(int nSeries) {
        return new IdentObj(-3, nSeries);
    }

    public IdentObj getGroup(int nGroup) {
        return new IdentObj(-3, -3, nGroup);
    }

    public IdentObj getSeriesGroup(int nSeries, int nGroup) {
        return new IdentObj(-3, nSeries, nGroup);
    }

    public IdentObj getGlobal() {
        return s_identObjGlobal;
    }

    public IdentObj getAreaRiser(int s, int g) {
        return new IdentObj(256, s, g);
    }

    public IdentObj getBarRiser(int s, int g) {
        return new IdentObj(277, s, g);
    }

    public IdentObj getCurveFitEquationText(int s) {
        return new IdentObj(42, s);
    }

    public IdentObj getCurveFitLineRiser(int s) {
        return new IdentObj(41, s);
    }

    public IdentObj getDataText(int s, int g) {
        return new IdentObj(260, s, g);
    }

    public IdentObj getLegendMarker(int s) {
        return new IdentObj(13, s);
    }

    public IdentObj getLegendText(int s) {
        return new IdentObj(14, s);
    }

    public IdentObj getLineMarker(int s, int g) {
        return new IdentObj(259, s, g);
    }

    public IdentObj getLineRiser(int s, int g) {
        return new IdentObj(258, s, g);
    }

    public IdentObj getO1Label(int g) {
        return new IdentObj(270, -3, g);
    }

    public IdentObj getPieBarConnectLineBottom() {
        IdentObj id = new IdentObj(301);
        id.setMiscID(400);
        return id;
    }

    public IdentObj getPieBarConnectLineTop() {
        IdentObj id = new IdentObj(301);
        id.setMiscID(300);
        return id;
    }

    public IdentObj getPieBarSlice(int s, int g) {
        IdentObj id = new IdentObj(332, s, g);
        id.setMiscID(1000);
        return id;
    }

    public IdentObj getPieFeelerLine(int s, int g) {
        IdentObj id = new IdentObj(294, s, g);
        id.setMiscID(200);
        return id;
    }

    public IdentObj getPieSliceLabel(int s, int g) {
        return new IdentObj(295, s, g);
    }

    public IdentObj getPieLabel(int g) {
        return new IdentObj(296, -3, g);
    }

    public IdentObj getPieRingLabel(int g) {
        return new IdentObj(297, -3, g);
    }

    public IdentObj getSlice(int s, int g) {
        IdentObj id = new IdentObj(298, s, g);
        id.setMiscID(1000);
        return id;
    }

    public IdentObj getSpectralLegendMarker(int i) {
        IdentObj id = new IdentObj(18);
        id.setMiscID(i);
        return id;
    }

    public IdentObj getStockMALine(int s, int g) {
        return new IdentObj(309, s, g);
    }

    public IdentObj getStockVolumeRiser(int g) {
        return new IdentObj(310, 1, g);
    }

    public IdentObj getStockCloseTick(int s, int g) {
        return new IdentObj(307, s, g);
    }

    public IdentObj getStockOpenTick(int s, int g) {
        return new IdentObj(308, s, g);
    }

    public IdentObj getStockRisingRiser(int s, int g) {
        return new IdentObj(319, s, g);
    }

    public IdentObj getStockFallingRiser(int s, int g) {
        return new IdentObj(320, s, g);
    }

    public IdentObj getLegendScroller() {
        return new IdentObj(65);
    }

    public IdentObj getLegendScrollerThumb() {
        return new IdentObj(66);
    }

    public IdentObj getReferenceLineLegendText() {
        return new IdentObj(503);
    }

    public String getAlertLabel() {
        String m_Obj = (String)this.getFromLook(Attr.AlertLabel, 1);
        return m_Obj;
    }

    public String getAlertLabel(IdentObj id) {
        String m_Obj = (String)this.getFromLook(id, Attr.AlertLabel);
        return m_Obj;
    }

    public String getAlertLabel(int seriesID) {
        IdentObj id = new IdentObj(-3, seriesID, -3);
        return this.getAlertLabel(id);
    }

    public void setAlertLabel(String newValue) {
        this.putToLookAndRepaint(Attr.AlertLabel, newValue, 1);
    }

    public void setAlertLabel(IdentObj id, String newValue) {
        this.putToLookAndRepaint(id, Attr.AlertLabel, newValue);
    }

    public void setAlertLabel(int seriesID, String newValue) {
        IdentObj id = new IdentObj(-3, seriesID, -3);
        this.setAlertLabel(id, newValue);
    }

    public void setY3LogScale(boolean newValue) {
        this.setLogScale(this.getY3Axis(), newValue);
    }

    public boolean getY3LogScale() {
        return this.getLogScale(this.getY3Axis());
    }

    public void setY4LogScale(boolean newValue) {
        this.setLogScale(this.getY4Axis(), newValue);
    }

    public boolean getY4LogScale() {
        return this.getLogScale(this.getY4Axis());
    }

    public void setY5LogScale(boolean newValue) {
        this.setLogScale(this.getY5Axis(), newValue);
    }

    public boolean getY5LogScale() {
        return this.getLogScale(this.getY5Axis());
    }

    public boolean getY3AxisDescending() {
        return this.getAxisDescending(this.getY3Axis());
    }

    public void setY3AxisDescending(boolean newValue) {
        this.setAxisDescending(this.getY3Axis(), newValue);
    }

    public boolean getY4AxisDescending() {
        return this.getAxisDescending(this.getY4Axis());
    }

    public void setY4AxisDescending(boolean newValue) {
        this.setAxisDescending(this.getY4Axis(), newValue);
    }

    public boolean getY5AxisDescending() {
        return this.getAxisDescending(this.getY5Axis());
    }

    public void setY5AxisDescending(boolean newValue) {
        this.setAxisDescending(this.getY5Axis(), newValue);
    }

    public int getEffectiveSeriesIndex(int index) {
        return index;
    }

    public void resetStyleCache() {
        this.m_stylesLook = null;
    }

    public void restoreDefaults() {
        this.m_userLook.clear();
        this.m_cssLook = null;
        this.m_stylesLook = null;
        this.m_userLookNoXML = null;
    }

    private Object _getFromMap(HashMap map, Object key) {
        if (map != null) {
            return map.get(key);
        }
        return null;
    }

    private Object _removeFromMap(HashMap map, Object key) {
        if (map != null) {
            return map.remove(key);
        }
        return null;
    }

    public void setUseRangeSlider(boolean useRangeSlider) {
        this.m_bUseRangeSlider = useRangeSlider;
    }

    public boolean isUseRangeSlider() {
        return this.m_bUseRangeSlider;
    }
}

