/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.awt.Point;

public class Line {
    double x0;
    double y0;
    double x1;
    double y1;

    Line(double x0, double y0, double x1, double y1) {
        this.x0 = x0;
        this.y0 = y0;
        this.x1 = x1;
        this.y1 = y1;
    }

    Line(Point point0, Point point1) {
        this.x0 = point0.x;
        this.y0 = point0.y;
        this.x1 = point1.x;
        this.y1 = point1.y;
    }

    double slope() {
        if (this.x1 - this.x0 == 0.0) {
            return 1.0;
        }
        return (this.y1 - this.y0) / (this.x1 - this.x0);
    }

    public static boolean linesIntersect(double X1, double Y1, double X2, double Y2, double X3, double Y3, double X4, double Y4) {
        return Line.relativeCCW(X1, Y1, X2, Y2, X3, Y3) * Line.relativeCCW(X1, Y1, X2, Y2, X4, Y4) <= 0 && Line.relativeCCW(X3, Y3, X4, Y4, X1, Y1) * Line.relativeCCW(X3, Y3, X4, Y4, X2, Y2) <= 0;
    }

    public boolean intersects(Line line) {
        return Line.linesIntersect(line.x0, line.y0, line.x1, line.y1, this.x0, this.y0, this.x1, this.y1);
    }

    public static int relativeCCW(double X1, double Y1, double X2, double Y2, double PX, double PY) {
        double ccw = (PX -= X1) * (Y2 -= Y1) - (PY -= Y1) * (X2 -= X1);
        if (ccw == 0.0 && (ccw = PX * X2 + PY * Y2) > 0.0 && (ccw = (PX -= X2) * X2 + (PY -= Y2) * Y2) < 0.0) {
            ccw = 0.0;
        }
        return ccw < 0.0 ? -1 : (ccw > 0.0 ? 1 : 0);
    }

    Point intersection(Line line) {
        if (this.slope() == line.slope()) {
            return null;
        }
        double x = (this.b() - line.b()) / (line.slope() - this.slope());
        double y = this.slope() * x + this.b();
        return new Point((int)x, (int)y);
    }

    double intersectionX(Line line) {
        if (this.slope() == line.slope()) {
            boolean bSlopesAreEqual = true;
        }
        double x = (this.b() - line.b()) / (line.slope() - this.slope());
        return x;
    }

    double intersectionY(Line line) {
        if (this.slope() == line.slope()) {
            boolean bSlopesAreEqual = true;
        }
        double x = (this.b() - line.b()) / (line.slope() - this.slope());
        double y = this.slope() * x + this.b();
        return y;
    }

    Point midpoint() {
        double x = this.x0 + (this.x1 - this.x0) / 2.0;
        double y = this.y0 + (this.y1 - this.y0) / 2.0;
        return new Point((int)x, (int)y);
    }

    Point fractionalPoint(int nNumerator, int nDenominator) {
        double x = this.x0 + (double)nNumerator * ((this.x1 - this.x0) / (double)nDenominator);
        double y = this.y0 + (double)nNumerator * ((this.y1 - this.y0) / (double)nDenominator);
        return new Point((int)x, (int)y);
    }

    Point startPoint() {
        return new Point((int)this.x0, (int)this.y0);
    }

    Point endPoint() {
        return new Point((int)this.x1, (int)this.y1);
    }

    double b() {
        return this.y0 - this.x0 * this.slope();
    }

    double length() {
        double a = this.x1 - this.x0;
        double b = this.y1 - this.y0;
        return Math.sqrt(Math.pow(a, 2.0) + Math.pow(b, 2.0));
    }

    double xAtY(double y) {
        return (y - this.b()) / this.slope();
    }

    double yAtX(double x) {
        return this.slope() * x + this.b();
    }

    public String toString() {
        return "(" + this.x0 + "," + this.y0 + ") , (" + this.x1 + "," + this.y1 + ")";
    }
}

