/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import oracle.dss.graph.pfj.Perspective;

public class DataTextPosition {
    int m_nDataTextPosition;
    int m_nGraphType;
    Point m_ptTwoHalfDOffset;
    int m_nBaseCoord;
    Point m_ptCenterTop;
    Dimension m_dimLabel;
    boolean m_bHoriz;
    double m_fDataValue;
    boolean m_bIsAxisAscending;
    double m_fStackedCumVal;
    double m_fPercentCumVal;
    double m_fAngle;
    double m_fDist;
    boolean m_bIsCombo;
    int m_nPrevCoord;
    boolean m_bPrevCoordValid;
    boolean m_bBaseLine;
    int m_baseLineYCoord;
    double m_fBaseLineVal;
    Perspective m_Perspective;

    public DataTextPosition(int nDataTextPosition, int nGraphType, Point ptTwoHalfDOffset, int nBaseCoord, Point ptCenterTop, Dimension dimLabel, double fDataValue, double fStackedCumVal, double fPercentCumVal, boolean bHoriz, boolean bIsAxisAscending, double fAngle, double fDist, boolean bIsCombo, int nPrevCoord, boolean bPrevCoordValid, boolean bBaseline, int baseLineYCoord, double baseLineVal, Perspective perspective) {
        this.m_nDataTextPosition = nDataTextPosition;
        this.m_nGraphType = nGraphType;
        this.m_ptTwoHalfDOffset = ptTwoHalfDOffset;
        this.m_nBaseCoord = nBaseCoord;
        this.m_ptCenterTop = ptCenterTop;
        this.m_dimLabel = dimLabel;
        this.m_fDataValue = fDataValue;
        this.m_fStackedCumVal = fStackedCumVal;
        this.m_fPercentCumVal = fPercentCumVal;
        this.m_bHoriz = bHoriz;
        this.m_bIsAxisAscending = bIsAxisAscending;
        this.m_fAngle = fAngle;
        this.m_fDist = fDist;
        this.m_bIsCombo = bIsCombo;
        this.m_nPrevCoord = nPrevCoord;
        this.m_bPrevCoordValid = bPrevCoordValid;
        this.m_bBaseLine = bBaseline;
        this.m_baseLineYCoord = baseLineYCoord;
        this.m_fBaseLineVal = baseLineVal;
        this.m_Perspective = perspective;
    }

    protected Rectangle calcPosition() {
        Rectangle rPos;
        int nDataTextPosition = this.restrictPosition();
        switch (nDataTextPosition) {
            case 0: {
                rPos = this.calcPositionCustom();
                break;
            }
            default: {
                rPos = this.calcPositionAbove();
                break;
            }
            case 2: {
                rPos = this.calcPositionCenterTop();
                break;
            }
            case 3: {
                rPos = this.calcPositionBelow();
                break;
            }
            case 4: {
                rPos = this.calcPositionCenter();
                break;
            }
            case 5: {
                rPos = this.calcPositionBase();
                break;
            }
            case 7: {
                rPos = this.calcPositionBubble();
            }
        }
        if (this.m_ptTwoHalfDOffset != null) {
            rPos.x -= this.m_ptTwoHalfDOffset.x;
            rPos.y -= this.m_ptTwoHalfDOffset.y;
        }
        return rPos;
    }

    protected Rectangle calcPositionCenterTop() {
        Rectangle rPos = new Rectangle(this.m_ptCenterTop.x - this.m_dimLabel.width / 2, this.m_ptCenterTop.y - this.m_dimLabel.height / 2, this.m_dimLabel.width, this.m_dimLabel.height);
        return rPos;
    }

    protected Rectangle calcPositionCustom() {
        Rectangle rPos = this.calcPositionCenterTop();
        if (this.m_bHoriz) {
            this.m_fAngle -= 90.0;
        }
        if (this.m_fDataValue > 0.0) {
            rPos.x += (int)(Math.cos(this.m_fAngle * (Math.PI / 180)) * this.m_fDist * 40.0);
            rPos.y += (int)(Math.sin(this.m_fAngle * (Math.PI / 180)) * this.m_fDist * 40.0);
        } else {
            rPos.x -= (int)(Math.cos(this.m_fAngle * (Math.PI / 180)) * this.m_fDist * 40.0);
            rPos.y -= (int)(Math.sin(this.m_fAngle * (Math.PI / 180)) * this.m_fDist * 40.0);
        }
        return rPos;
    }

    protected Rectangle calcPositionAbove() {
        Rectangle rPos = this.calcPositionCenterTop();
        double baseVal = 0.0;
        if (this.m_bBaseLine) {
            baseVal = this.m_fBaseLineVal;
        }
        if (this.m_bHoriz) {
            rPos.x = this.m_bIsAxisAscending && this.m_fDataValue >= baseVal ? (rPos.x += this.m_dimLabel.width / 2 + this.m_Perspective.getVC().destToVirtWidth(3)) : (rPos.x -= this.m_dimLabel.width / 2 + this.m_Perspective.getVC().destToVirtWidth(1));
        } else {
            rPos.y = this.m_bIsAxisAscending && this.m_fDataValue >= baseVal ? (rPos.y += this.m_dimLabel.height / 2) : (rPos.y -= this.m_dimLabel.height / 2);
        }
        return rPos;
    }

    protected Rectangle calcPositionBubble() {
        Rectangle rPos = this.calcPositionCenterTop();
        double baseVal = 0.0;
        if (this.m_bBaseLine) {
            baseVal = this.m_fBaseLineVal;
        }
        if (this.m_bHoriz) {
            rPos.x = this.m_bIsAxisAscending ? (rPos.x += this.m_dimLabel.width / 2) : (rPos.x -= this.m_dimLabel.width / 2);
            rPos.y = this.m_bIsAxisAscending ? (rPos.y += this.m_dimLabel.height / 2) : (rPos.y -= this.m_dimLabel.height / 2);
        }
        return rPos;
    }

    protected Rectangle calcPositionBelow() {
        Rectangle rPos = this.calcPositionCenterTop();
        double baseVal = 0.0;
        if (this.m_bBaseLine) {
            baseVal = this.m_fBaseLineVal;
        }
        if (this.m_bHoriz) {
            rPos.x = this.m_bIsAxisAscending ? (rPos.x -= this.m_dimLabel.width / 2) : (rPos.x += this.m_dimLabel.width / 2);
            if (this.m_fDataValue < baseVal) {
                rPos.x += this.m_dimLabel.width;
            }
        } else {
            rPos.y = this.m_bIsAxisAscending && this.m_fDataValue > baseVal ? (rPos.y -= this.m_dimLabel.height / 2) : (rPos.y += this.m_dimLabel.height / 2);
        }
        return rPos;
    }

    protected Rectangle calcPositionCenter() {
        Rectangle rPos = this.calcPositionCenterTop();
        if (this.m_bHoriz) {
            switch (this.m_nGraphType) {
                case 30: {
                    if (this.m_bPrevCoordValid) {
                        rPos.x = Math.min(this.m_ptCenterTop.x, this.m_nPrevCoord) + (Math.abs(this.m_ptCenterTop.x - this.m_nPrevCoord) - this.m_dimLabel.width) / 2;
                        break;
                    }
                    rPos.x = Math.min(this.m_ptCenterTop.x, this.m_nBaseCoord) + (Math.abs(this.m_ptCenterTop.x - this.m_nBaseCoord) - this.m_dimLabel.width) / 2;
                    break;
                }
                case 25: 
                case 27: 
                case 29: 
                case 37: {
                    double fRatio = this.m_fDataValue / this.m_fStackedCumVal;
                    int nRiserTop = this.m_ptCenterTop.x;
                    int nRiserBase = this.m_nBaseCoord;
                    int nRiserHeight = nRiserTop - nRiserBase;
                    int nTrueRiserBase = (int)(fRatio * (double)nRiserHeight);
                    int nTrueRiserBottom = nRiserTop - nTrueRiserBase;
                    int nTrueRiserHeight = nRiserTop - nTrueRiserBottom;
                    rPos.x = nTrueRiserBottom + nTrueRiserHeight / 2;
                    rPos.x -= this.m_dimLabel.width / 2;
                    break;
                }
                default: {
                    int baseCoord = this.m_nBaseCoord;
                    if (this.m_bBaseLine) {
                        baseCoord = this.m_baseLineYCoord;
                    }
                    rPos.x = Math.min(this.m_ptCenterTop.x, baseCoord) + (Math.abs(this.m_ptCenterTop.x - baseCoord) - this.m_dimLabel.width) / 2;
                    break;
                }
            }
        } else {
            switch (this.m_nGraphType) {
                case 23: {
                    if (this.m_bPrevCoordValid) {
                        rPos.y = Math.min(this.m_ptCenterTop.y, this.m_nPrevCoord) + (Math.abs(this.m_ptCenterTop.y - this.m_nPrevCoord) - this.m_dimLabel.height) / 2;
                        break;
                    }
                    rPos.y = Math.min(this.m_ptCenterTop.y, this.m_nBaseCoord) + (Math.abs(this.m_ptCenterTop.y - this.m_nBaseCoord) - this.m_dimLabel.height) / 2;
                    break;
                }
                case 18: 
                case 20: 
                case 22: 
                case 32: {
                    double fRatio = this.m_fDataValue / this.m_fStackedCumVal;
                    int nRiserTop = this.m_ptCenterTop.y;
                    int nRiserBase = this.m_nBaseCoord;
                    int nRiserHeight = nRiserTop - nRiserBase;
                    int nTrueRiserBase = (int)(fRatio * (double)nRiserHeight);
                    int nTrueRiserBottom = nRiserTop - nTrueRiserBase;
                    int nTrueRiserHeight = nRiserTop - nTrueRiserBottom;
                    rPos.y = nTrueRiserBottom + nTrueRiserHeight / 2;
                    rPos.y -= this.m_dimLabel.height / 2;
                    break;
                }
                default: {
                    int baseCoord = this.m_nBaseCoord;
                    if (this.m_bBaseLine) {
                        baseCoord = this.m_baseLineYCoord;
                    }
                    rPos.y = Math.min(this.m_ptCenterTop.y, baseCoord) + (Math.abs(this.m_ptCenterTop.y - baseCoord) - this.m_dimLabel.height) / 2;
                }
            }
        }
        return rPos;
    }

    protected Rectangle calcPositionBase() {
        double baseVal = 0.0;
        int baseCoord = this.m_nBaseCoord;
        if (this.m_bBaseLine) {
            baseVal = this.m_fBaseLineVal;
            baseCoord = this.m_baseLineYCoord;
        }
        Rectangle rPos = this.calcPositionCenterTop();
        if (this.m_bHoriz) {
            switch (this.m_nGraphType) {
                case 30: {
                    if (this.m_bPrevCoordValid) {
                        rPos.x = Math.min(this.m_ptCenterTop.x, this.m_nPrevCoord);
                        break;
                    }
                    rPos.x = Math.min(this.m_ptCenterTop.x, this.m_nBaseCoord);
                    break;
                }
                case 25: 
                case 27: 
                case 29: 
                case 37: {
                    int nTrueRiserBottom;
                    double fRatio = this.m_fDataValue / this.m_fStackedCumVal;
                    int nRiserTop = this.m_ptCenterTop.x;
                    int nRiserBase = this.m_nBaseCoord;
                    int nRiserHeight = nRiserTop - nRiserBase;
                    int nTrueRiserBase = (int)(fRatio * (double)nRiserHeight);
                    rPos.x = nTrueRiserBottom = nRiserTop - nTrueRiserBase;
                    break;
                }
                default: {
                    rPos.x = baseCoord;
                }
            }
            if (this.m_fDataValue < baseVal) {
                rPos.x -= this.m_dimLabel.width;
            }
        } else {
            switch (this.m_nGraphType) {
                case 23: {
                    if (this.m_bPrevCoordValid) {
                        rPos.y = Math.min(this.m_ptCenterTop.y, this.m_nPrevCoord);
                        break;
                    }
                    rPos.y = Math.min(this.m_ptCenterTop.y, this.m_nBaseCoord);
                    break;
                }
                case 18: 
                case 20: 
                case 22: 
                case 32: {
                    int nTrueRiserBottom;
                    double fRatio = this.m_fDataValue / this.m_fStackedCumVal;
                    int nRiserTop = this.m_ptCenterTop.y;
                    int nRiserBase = this.m_nBaseCoord;
                    int nRiserHeight = nRiserTop - nRiserBase;
                    int nTrueRiserBase = (int)(fRatio * (double)nRiserHeight);
                    rPos.y = nTrueRiserBottom = nRiserTop - nTrueRiserBase;
                    break;
                }
                default: {
                    rPos.y = baseCoord;
                }
            }
            if (this.m_fDataValue < baseVal) {
                rPos.y -= this.m_dimLabel.height;
            }
        }
        return rPos;
    }

    protected int restrictPosition() {
        int nNewDataTextPosition = this.m_nDataTextPosition;
        switch (this.m_nGraphType) {
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 61: 
            case 62: 
            case 63: 
            case 64: {
                if (this.m_nDataTextPosition < 4 || this.m_nDataTextPosition > 6) break;
                nNewDataTextPosition = 1;
                break;
            }
            case 89: 
            case 90: 
            case 91: 
            case 92: {
                if (this.m_nDataTextPosition == 6 || this.m_nDataTextPosition == 0) break;
                nNewDataTextPosition = 7;
            }
        }
        if (this.m_nDataTextPosition >= 4 && this.m_nDataTextPosition <= 6 && this.m_bIsCombo) {
            nNewDataTextPosition = 1;
        }
        return nNewDataTextPosition;
    }
}

