/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import oracle.dss.graph.GraphConstants;
import oracle.dss.graph.pfj.DataRange;
import oracle.dss.graph.pfj.DataScroller;
import oracle.dss.graph.pfj.JChart_2D_Standard;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.RelativeAxisObj;
import oracle.dss.graph.pfj.VC;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.BlackBoxObj;
import oracle.dss.graph.pfj.draw.DetLabel;
import oracle.dss.graph.pfj.draw.DetPolygon;
import oracle.dss.graph.pfj.draw.DetRect;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.graph.pfj.draw.TextStyleObj;

public class Annotations
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Perspective m_Perspective;
    private JChart_2D_Standard m_chart;
    private int MAX_WIDTH = 10000;
    private int defaultDistance = 600;
    private boolean[] m_isCalced = null;
    private boolean[] m_isReveresed = null;
    private Rectangle m_pRect;
    private GraphConstants.AnnotationLocation m_location;

    protected Annotations(Perspective perspective, GraphConstants.AnnotationLocation location) {
        this.m_Perspective = perspective;
        this.m_location = location;
        this.m_pRect = this.m_Perspective.getRect(new IdentObj(2));
    }

    public void calc() {
        int i;
        if (!(this.m_Perspective.m_chart instanceof JChart_2D_Standard)) {
            return;
        }
        this.m_chart = (JChart_2D_Standard)this.m_Perspective.m_chart;
        int numGroups = this.m_Perspective.getAccess().getNumTotalGroups();
        int numSeries = this.m_Perspective.getAccess().getNumTotalSeries();
        int count = 0;
        if (this.m_Perspective.getAnnotations() != null) {
            count = this.m_Perspective.getAnnotations().size();
        }
        this.m_isCalced = new boolean[count];
        this.m_isReveresed = new boolean[count];
        for (i = 0; i < count; ++i) {
            this.m_isCalced[i] = false;
            this.m_isReveresed[i] = false;
        }
        for (i = 0; i < count; ++i) {
            IdentObj id;
            GraphConstants.AnnotationLocation location;
            if (this.m_isCalced[i] || (location = this.m_Perspective.getAnnotationLocation(id = (IdentObj)this.m_Perspective.getAnnotations().get(i))) != this.m_location) continue;
            this.m_isCalced[i] = true;
            if (id.getSeriesID() >= numSeries || id.getGroupID() >= numGroups || !this.m_Perspective.getDisplay(id)) continue;
            GraphConstants.AnnotationPosition position = this.m_Perspective.getAnnotationPosition(id);
            if (position == GraphConstants.AnnotationPosition.DATA_VALUE) {
                ArrayList<IdentObj> idList = new ArrayList<IdentObj>();
                idList.add(id);
                for (int j = i + 1; j < count; ++j) {
                    IdentObj id1 = (IdentObj)this.m_Perspective.getAnnotations().get(j);
                    GraphConstants.AnnotationLocation loc = this.m_Perspective.getAnnotationLocation(id1);
                    if (loc != this.m_location || id.getSeriesID() != id1.getSeriesID() || id.getGroupID() != id1.getGroupID()) continue;
                    if (!this.m_Perspective.getDisplay(id1)) {
                        this.m_isCalced[j] = true;
                        continue;
                    }
                    if (this.m_Perspective.getAnnotationPosition(id1) != GraphConstants.AnnotationPosition.DATA_VALUE) continue;
                    idList.add(id1);
                    this.m_isCalced[j] = true;
                }
                if (idList.size() > 1) {
                    if (this.isOutOfViewableDataRange(id)) continue;
                    this.calcMultiple(idList);
                    continue;
                }
            }
            this.calcOne(id);
        }
    }

    private void calcMultiple(List idList) {
        int count = idList.size();
        IdentObj[] idBox = new IdentObj[count];
        TextStyleObj[] textStyleObj = new TextStyleObj[count];
        Dimension[] dimensions = new Dimension[count];
        for (int i = 0; i < count; ++i) {
            IdentObj id = (IdentObj)idList.get(i);
            idBox[i] = this.m_Perspective.getAnnotationBox(id);
            textStyleObj[i] = new TextStyleObj(this.m_Perspective.m_fontCache, this.m_Perspective.getFontName(id), this.m_Perspective.getFontStyle(id), true, this.m_Perspective.getFontSize(id), this.m_Perspective.getFontSizeVC(id), this.m_Perspective.getTextRotation(id), 0, 0, this.m_Perspective.getAutofit(id), false, this.m_Perspective.getTextWrap(id));
            textStyleObj[i].setTextTruncate(true, -1, 2);
            dimensions[i] = this.calcDim(id, textStyleObj[i]).getDimension();
        }
        IdentObj id = (IdentObj)idList.get(0);
        Point valueCoord = this.m_chart.getCoords(id.getSeriesID(), id.getGroupID());
        Dimension d = this.calcMultiDim(dimensions);
        Point start = this.calcAnnotationStartPoint(d, valueCoord, id);
        boolean pointerOnTop = valueCoord.y > start.y;
        Rectangle[] rect = this.calcMultiRect(start, dimensions);
        for (int i = 0; i < count; ++i) {
            id = (IdentObj)idList.get(i);
            String text = this.m_Perspective.getTextString(id);
            if (text == null && text.equals("")) continue;
            BlackBoxObj bbText = new BlackBoxObj(this.m_Perspective, id);
            BlackBoxObj bbBox = new BlackBoxObj(this.m_Perspective, idBox[i]);
            if (i == 0 && !pointerOnTop || i == count - 1 && pointerOnTop) {
                if (this.m_Perspective.isExportingToXML()) {
                    new DetPolygon(this.m_Perspective.getDetectiv(), idBox[i], this.calcPolyWithPointer(rect[i], valueCoord, pointerOnTop), (BlackBoxIF)bbBox, 1.0);
                } else {
                    new DetPolygon(this.m_Perspective.getDetectiv(), idBox[i], this.calcPolyWithPointer(rect[i], valueCoord, pointerOnTop), (BlackBoxIF)bbBox, this.m_pRect);
                }
            } else if (this.m_Perspective.isExportingToXML()) {
                new DetRect(this.m_Perspective.getDetectiv(), idBox[i], rect[i].x, rect[i].y, rect[i].width, rect[i].height, bbBox);
            } else {
                new DetRect(this.m_Perspective.getDetectiv(), idBox[i], rect[i].x, rect[i].y, rect[i].width, rect[i].height, bbBox, this.m_pRect, false, true, false);
            }
            new DetLabel(this.m_Perspective.getDetectiv(), id, text, rect[i], textStyleObj[i], bbText, true);
        }
    }

    private Dimension calcMultiDim(Dimension[] dimensions) {
        int count = dimensions.length;
        int width = dimensions[0].width;
        int height = dimensions[0].height;
        for (int i = 1; i < count; ++i) {
            if (dimensions[i].width > width) {
                width = dimensions[i].width;
            }
            height += dimensions[i].height;
        }
        return new Dimension(width, height);
    }

    private Rectangle[] calcMultiRect(Point start, Dimension[] dimensions) {
        int count = dimensions.length;
        Rectangle[] rect = new Rectangle[count];
        int newY = start.y;
        for (int i = 0; i < count; ++i) {
            rect[i] = new Rectangle(start.x, newY, dimensions[i].width, dimensions[i].height);
            newY += dimensions[i].height;
        }
        return rect;
    }

    private void calcOne(IdentObj id) {
        if (!(this.m_chart instanceof JChart_2D_Standard)) {
            return;
        }
        IdentObj idBox = this.m_Perspective.getAnnotationBox(id);
        String text = this.m_Perspective.getTextString(id);
        if (text == null || text.equals("")) {
            return;
        }
        BlackBoxObj bbText = new BlackBoxObj(this.m_Perspective, id);
        BlackBoxObj bbBox = new BlackBoxObj(this.m_Perspective, idBox);
        TextStyleObj textStyleObj = new TextStyleObj(this.m_Perspective.m_fontCache, this.m_Perspective.getFontName(id), this.m_Perspective.getFontStyle(id), true, this.m_Perspective.getFontSize(id), this.m_Perspective.getFontSizeVC(id), this.m_Perspective.getTextRotation(id), 0, 0, this.m_Perspective.getAutofit(id), false, this.m_Perspective.getTextWrap(id));
        textStyleObj.setTextTruncate(true, -1, 2);
        AnnotationBox annotationBox = this.calcDim(id, textStyleObj);
        Dimension d = annotationBox.getDimension();
        int fontHeight = annotationBox.getFontHeight();
        GraphConstants.AnnotationPosition position = this.m_Perspective.getAnnotationPosition(id);
        if (position == GraphConstants.AnnotationPosition.DATA_VALUE) {
            Point valueCoord = this.m_chart.getCoords(id.getSeriesID(), id.getGroupID());
            Point start = this.calcAnnotationStartPoint(d, valueCoord, id);
            if (this.m_Perspective.isExportingToXML()) {
                Rectangle bounds = new Rectangle(start.x, start.y, d.width, d.height);
                new DetPolygon(this.m_Perspective.getDetectiv(), idBox, this.calcPoly(bounds, valueCoord), (BlackBoxIF)bbBox, 1.0);
                new DetLabel(this.m_Perspective.getDetectiv(), id, text, bounds, textStyleObj, bbText, true);
            } else if (!this.isOutOfViewableDataRange(id)) {
                Rectangle bounds = new Rectangle(start.x, start.y, d.width, d.height);
                new DetPolygon(this.m_Perspective.getDetectiv(), idBox, this.calcPoly(bounds, valueCoord), (BlackBoxIF)bbBox, this.m_pRect);
                new DetLabel(this.m_Perspective.getDetectiv(), id, text, bounds, textStyleObj, bbText, true);
            }
        } else {
            Point2D coords = this.calcXYCoords(id, position);
            if (coords == null) {
                return;
            }
            double x = coords.getX();
            double y = coords.getY();
            int horzAlign = this.m_Perspective.getTextJustHoriz(id);
            int vertAlign = this.m_Perspective.getTextJustVert(id);
            if (horzAlign == 10 && this.m_Perspective.isBIDILocale()) {
                horzAlign = 4;
            }
            switch (horzAlign) {
                case 2: 
                case 10: {
                    break;
                }
                case 0: {
                    x -= (double)d.width / 2.0;
                    break;
                }
                case 4: {
                    x -= (double)d.width;
                }
            }
            switch (vertAlign) {
                case 3: {
                    break;
                }
                case 0: {
                    y -= (double)d.height / 2.0;
                    break;
                }
                case 1: {
                    y -= (double)d.height;
                }
            }
            Rectangle bounds = new Rectangle((int)x, (int)y, d.width, d.height);
            if (this.m_Perspective.isExportingToXML()) {
                new DetRect(this.m_Perspective.getDetectiv(), idBox, bounds.x, bounds.y, bounds.width, bounds.height, bbBox);
                new DetLabel(this.m_Perspective.getDetectiv(), id, text, bounds, textStyleObj, bbText, true);
            } else {
                boolean isClipped;
                boolean truncateWidthRight = (double)(this.m_pRect.x + this.m_pRect.width) - x < (double)d.width;
                boolean truncateHeightBottom = (double)(this.m_pRect.y + this.m_pRect.height) - y < (double)d.height;
                boolean truncateWidthLeft = x < (double)this.m_pRect.x;
                boolean truncateHeightTop = y < (double)this.m_pRect.y;
                double visibleWidth = d.width;
                double visibleHeight = d.height;
                boolean showLabel = true;
                double textX = x;
                double textY = y;
                boolean bl = isClipped = truncateWidthRight || truncateHeightBottom || truncateWidthLeft || truncateHeightTop;
                if (isClipped) {
                    int numLines;
                    if (truncateWidthRight) {
                        visibleWidth = (double)(this.m_pRect.x + this.m_pRect.width) - x;
                    }
                    if (truncateHeightBottom) {
                        visibleHeight = (double)(this.m_pRect.y + this.m_pRect.height) - y;
                    }
                    if (truncateWidthLeft) {
                        visibleWidth = x + (double)d.width - (double)this.m_pRect.x;
                    }
                    if (truncateHeightTop) {
                        visibleHeight = y + (double)d.height - (double)this.m_pRect.y;
                    }
                    if ((numLines = (int)Math.floor(visibleHeight / (double)fontHeight) - 1) < 1) {
                        showLabel = false;
                    }
                    textStyleObj.setTextTruncate(true, numLines, 0);
                    if (truncateWidthLeft) {
                        textX = x + ((double)d.width - visibleWidth);
                    }
                    if (truncateHeightBottom) {
                        textStyleObj.setVertAlign(3);
                        textY += (double)fontHeight * 0.5;
                    }
                    if (truncateHeightTop) {
                        textStyleObj.setVertAlign(1);
                        textY -= (double)fontHeight * 0.5;
                    }
                }
                Rectangle textBounds = new Rectangle((int)textX, (int)textY, (int)visibleWidth, d.height);
                new DetRect(this.m_Perspective.getDetectiv(), idBox, bounds.x, bounds.y, bounds.width, bounds.height, bbBox, this.m_pRect, false, true, false);
                if (showLabel) {
                    new DetLabel(this.m_Perspective.getDetectiv(), id, text, textBounds, textStyleObj, bbText, true);
                }
            }
        }
    }

    private boolean isOutOfViewableDataRange(IdentObj id) {
        boolean outOfViewableRange = false;
        if (!this.m_Perspective.isExportingToXML()) {
            DataRange dataRange = this.m_Perspective.getAccess().getViewableDataRange();
            outOfViewableRange = id.getSeriesID() < dataRange.getRowStart() || id.getSeriesID() > dataRange.getRowStop() || id.getGroupID() < dataRange.getColStart() || id.getGroupID() > dataRange.getColStop();
        }
        return outOfViewableRange;
    }

    private Point2D calcXYCoords(IdentObj id, GraphConstants.AnnotationPosition position) {
        Double xValue = this.m_Perspective.getAnnotationXValue(id);
        Double yValue = this.m_Perspective.getAnnotationYValue(id);
        if (xValue == null || yValue == null) {
            return null;
        }
        if (position == GraphConstants.AnnotationPosition.ABSOLUTE && this.m_Perspective.isX1AxisPresent() && this.m_Perspective.isY1AxisPresent()) {
            RelativeAxisObj x1Axis = this.m_chart.getX1Axis();
            RelativeAxisObj y1Axis = this.m_chart.getY1Axis();
            if (y1Axis != null && x1Axis != null) {
                double x = x1Axis.getValueCoord(xValue);
                double y = y1Axis.getValueCoord(yValue);
                if (!this.m_Perspective.isExportingToXML()) {
                    x = x1Axis.getValueCoord(xValue, false);
                    y = y1Axis.getValueCoord(yValue, false);
                }
                return new Point2D.Double(x, y);
            }
            return null;
        }
        if (position == GraphConstants.AnnotationPosition.PERCENTAGE) {
            double x = xValue;
            double y = yValue;
            if (x >= 0.0 && x <= 100.0 && y >= 0.0 && y <= 100.0) {
                DataScroller ds;
                if (this.m_Perspective.isExportingToXML()) {
                    x = x * (double)(this.m_pRect.width / 100) + (double)this.m_pRect.x;
                    y = y * (double)(this.m_pRect.height / 100) + (double)this.m_pRect.y;
                    return new Point2D.Double(x, y);
                }
                if (this.m_Perspective.isO1AxisPresent()) {
                    RelativeAxisObj o1Axis = this.m_chart.getO1Axis();
                    int numGroups = this.m_Perspective.getAccess().getNumTotalGroups();
                    int startGroup = this.m_chart.getResetGroupsEnumerator().getFirstGroup();
                    double endX = o1Axis.getCenterCoord(numGroups - 1);
                    double firstViewableGroupX = o1Axis.getCenterCoord(startGroup);
                    double startX = o1Axis.getCenterCoord(0);
                    double startOffset = startX - (firstViewableGroupX - startX);
                    double length = Math.abs(endX - startX);
                    x = length * (x / 100.0) + startOffset;
                } else if (this.m_Perspective.isX1AxisPresent()) {
                    RelativeAxisObj x1Axis = this.m_chart.getX1Axis();
                    double[] x1Bounds = x1Axis.getAutoMinMaxArray();
                    double x1Min = x1Axis.getMinValue();
                    double x1Max = x1Axis.getMaxValue();
                    ds = this.m_Perspective.getGraphFrameObj().getDataScrollerByAxis("X1");
                    if (this.m_Perspective.getDataScrollerPresenceX1() != 0 && ds != null && ds.hasScrollThumb()) {
                        x1Min = this.m_Perspective.getX1ScaleZoomMin() != null ? this.m_Perspective.getX1ScaleZoomMin() : x1Bounds[0];
                        x1Max = this.m_Perspective.getX1ScaleZoomMax() != null ? this.m_Perspective.getX1ScaleZoomMax() : x1Bounds[1];
                    }
                    double realXValue = (x1Max - x1Min) * (x / 100.0) + x1Min;
                    x = x1Axis.getValueCoord(realXValue, false);
                }
                if (this.m_Perspective.isY1AxisPresent()) {
                    RelativeAxisObj y1Axis = this.m_chart.getY1Axis();
                    double[] y1Bounds = y1Axis.getAutoMinMaxArray();
                    double y1Min = y1Axis.getMinValue();
                    double y1Max = y1Axis.getMaxValue();
                    ds = this.m_Perspective.getGraphFrameObj().getDataScrollerByAxis("Y1");
                    if (this.m_Perspective.getDataScrollerPresenceY1() != 0 && ds != null && ds.hasScrollThumb()) {
                        y1Min = this.m_Perspective.getY1ScaleZoomMin() != null ? this.m_Perspective.getY1ScaleZoomMin() : y1Bounds[0];
                        y1Max = this.m_Perspective.getY1ScaleZoomMax() != null ? this.m_Perspective.getY1ScaleZoomMax() : y1Bounds[1];
                    }
                    double realYValue = (y1Max - y1Min) * (y / 100.0) + y1Min;
                    y = y1Axis.getValueCoord(realYValue, false);
                }
                return new Point2D.Double(x, y);
            }
            return null;
        }
        return null;
    }

    private AnnotationBox calcDim(IdentObj id, TextStyleObj textStyleObj) {
        VC vc = this.m_Perspective.getVC();
        if (this.m_Perspective.getZoomAndScroll() == 0) {
            vc = this.m_Perspective.getRangeSliderVC();
        }
        int availableWidth = this.MAX_WIDTH;
        if (!this.m_Perspective.getDisplay(id)) {
            return new AnnotationBox(new Dimension(0, 0), 0);
        }
        String text = this.m_Perspective.getTextString(id);
        int fontSize = !this.m_Perspective.getFontSizeAbsolute(id) ? vc.virtToDestHeight(this.m_Perspective.getFontSizeVC(id)) : this.m_Perspective.getFontSize(id);
        int fontStyle = this.m_Perspective.getFontStyle(id);
        String fontName = this.m_Perspective.getFontName(id);
        Font font = new Font(fontName, fontStyle, fontSize);
        FontMetrics fm = this.m_Perspective.getGraphicsContext().getFontMetrics(font);
        int fontHeight = TextStyleObj.getFontHeight(fm, this.m_Perspective.getFontMetricsResolver());
        int fontHeightVc = this.m_Perspective.getVC().destToVirtHeight(fontHeight);
        Vector strs = new Vector();
        int numWrappedLines = textStyleObj.extractLinesWordWrap(text, strs, vc.virtToDestWidth(availableWidth), fm, this.m_Perspective.getFontMetricsResolver());
        int height = fontHeightVc * (numWrappedLines + 1);
        int width = availableWidth;
        if (numWrappedLines == 1) {
            width = vc.destToVirtWidth(fm.stringWidth(text));
        }
        return new AnnotationBox(new Dimension(width += vc.destToVirtWidth(fm.stringWidth("W")), height), fontHeightVc);
    }

    private Point calcAnnotationStartPoint(Dimension d, Point valueCoord, IdentObj id) {
        int y;
        int x;
        block16: {
            int x_middle = valueCoord.x - d.width / 2;
            int x_left = valueCoord.x - d.width;
            int x_right = valueCoord.x;
            int y_top = valueCoord.y + this.defaultDistance;
            int y_bottom = valueCoord.y - (this.defaultDistance + d.height);
            x = x_middle;
            y = y_top;
            if (this.m_Perspective.isChartLine()) {
                int sID = id.getSeriesID();
                int gID = id.getGroupID();
                Point leftCoord = gID - 1 >= 0 ? ((JChart_2D_Standard)this.m_Perspective.m_chart).getCoords(sID, gID - 1) : valueCoord;
                Point rightCoord = gID + 1 < this.m_Perspective.m_chart.getResetGroupsEnumerator().getNumGroups() ? ((JChart_2D_Standard)this.m_Perspective.m_chart).getCoords(sID, gID + 1) : valueCoord;
                if (leftCoord.y <= valueCoord.y) {
                    if (rightCoord.y > valueCoord.y) {
                        x = x_left;
                        if (x_left < this.m_pRect.x && x_right <= this.m_pRect.x + this.m_pRect.width) {
                            x = x_right;
                            y = y_bottom;
                        }
                    }
                } else if (rightCoord.y >= valueCoord.y) {
                    y = y_bottom;
                } else {
                    x = x_right;
                    if (x_right > this.m_pRect.x + this.m_pRect.width && x_left >= this.m_pRect.x) {
                        x = x_left;
                        y = y_bottom;
                    }
                }
            }
            Rectangle rect = new Rectangle(x, y, d.width, d.height);
            while (true) {
                if (this.m_pRect.x >= x) {
                    x = this.m_pRect.x + d.width / 16;
                }
                if (this.m_pRect.x + this.m_pRect.width <= x + d.width) {
                    x = this.m_pRect.x + this.m_pRect.width - (d.width + d.width / 16);
                }
                if (y + d.height >= this.m_pRect.y + this.m_pRect.height) {
                    y = this.m_pRect.y + this.m_pRect.height - (d.height + d.height / 12);
                }
                if (y < this.m_pRect.y) {
                    y = this.m_pRect.y + d.height / 12;
                }
                if (!(rect = new Rectangle(x, y, d.width, d.height)).contains(valueCoord)) break block16;
                if (y + d.height > this.m_pRect.y && y - d.height / 4 >= this.m_pRect.y) {
                    y -= d.height / 4;
                    continue;
                }
                if (x - d.width >= this.m_pRect.x) break;
                x += d.width / 4;
            }
            if (y + d.height == valueCoord.y) {
                y -= d.height / 10;
            }
            if (x - d.width == valueCoord.x) {
                x += d.width / 16;
            }
            rect = this.calcPoly(rect, valueCoord).getBounds();
            x = rect.x;
            y = rect.y;
        }
        return new Point(x, y);
    }

    private Polygon calcPoly(Rectangle rect, Point valueCoord) {
        int xPointerEnd;
        Polygon p = new Polygon();
        if (rect.contains(valueCoord) || rect.y <= valueCoord.y && valueCoord.y <= rect.y + rect.height) {
            p.addPoint(rect.x, rect.y);
            p.addPoint(rect.x + rect.width, rect.y);
            p.addPoint(rect.x + rect.width, rect.y + rect.height);
            p.addPoint(rect.x, rect.y + rect.height);
            return p;
        }
        boolean isReveresed = valueCoord.y > rect.y;
        boolean pointTowardsEnd = rect.x + rect.width / 2 < valueCoord.x;
        int xPointerBegin = pointTowardsEnd ? rect.x + rect.width - rect.width / 10 : rect.x + rect.width / 5;
        int n = xPointerEnd = pointTowardsEnd ? rect.x + rect.width - rect.width / 5 : rect.x + rect.width / 10;
        if (isReveresed) {
            p.addPoint(rect.x, rect.y);
            p.addPoint(rect.x + rect.width, rect.y);
            p.addPoint(rect.x + rect.width, rect.y + rect.height);
            p.addPoint(xPointerBegin, rect.y + rect.height);
            p.addPoint(valueCoord.x, valueCoord.y);
            p.addPoint(xPointerEnd, rect.y + rect.height);
            p.addPoint(rect.x, rect.y + rect.height);
        } else {
            p.addPoint(rect.x, rect.y);
            p.addPoint(xPointerEnd, rect.y);
            p.addPoint(valueCoord.x, valueCoord.y);
            p.addPoint(xPointerBegin, rect.y);
            p.addPoint(rect.x + rect.width, rect.y);
            p.addPoint(rect.x + rect.width, rect.y + rect.height);
            p.addPoint(rect.x, rect.y + rect.height);
        }
        return p;
    }

    private Polygon calcPolyWithPointer(Rectangle rect, Point valueCoord, boolean pointerOnTop) {
        boolean pointToSide;
        Polygon p = new Polygon();
        if (rect.contains(valueCoord) || rect.y <= valueCoord.y && valueCoord.y <= rect.y + rect.height) {
            p.addPoint(rect.x, rect.y);
            p.addPoint(rect.x + rect.width, rect.y);
            p.addPoint(rect.x + rect.width, rect.y + rect.height);
            p.addPoint(rect.x, rect.y + rect.height);
            return p;
        }
        boolean bl = pointToSide = rect.y > valueCoord.y && rect.x > valueCoord.x;
        if (pointToSide) {
            int yPointerBegin = rect.y + rect.height * 4 / 10;
            int yPointerEnd = rect.y + rect.height * 3 / 10;
            p.addPoint(rect.x, rect.y);
            p.addPoint(rect.x + rect.width, rect.y);
            p.addPoint(rect.x + rect.width, rect.y + rect.height);
            p.addPoint(rect.x, rect.y + rect.height);
            p.addPoint(rect.x, yPointerBegin);
            p.addPoint(valueCoord.x, valueCoord.y);
            p.addPoint(rect.x, yPointerEnd);
        } else {
            boolean pointTowardsEnd = rect.x + rect.width / 2 < valueCoord.x;
            int xPointerBegin = rect.x + rect.width / 5;
            int xPointerEnd = rect.x + rect.width / 10;
            if (pointTowardsEnd) {
                boolean pointCloserToCenter;
                boolean bl2 = pointCloserToCenter = rect.x + rect.width / 4 < valueCoord.x;
                if (pointCloserToCenter) {
                    xPointerBegin = rect.x + rect.width - rect.width / 10;
                    xPointerEnd = rect.x + rect.width - rect.width / 5;
                } else {
                    xPointerBegin = rect.x + rect.width - rect.width * 3 / 10;
                    xPointerEnd = rect.x + rect.width - rect.width * 4 / 10;
                }
            } else {
                boolean pointCloserToCenter;
                boolean bl3 = pointCloserToCenter = rect.x + rect.width - rect.width / 4 > valueCoord.x;
                if (pointCloserToCenter && !pointerOnTop) {
                    xPointerBegin = rect.x + rect.width * 4 / 10;
                    xPointerEnd = rect.x + rect.width * 3 / 10;
                }
            }
            if (pointerOnTop) {
                p.addPoint(rect.x, rect.y);
                p.addPoint(rect.x + rect.width, rect.y);
                p.addPoint(rect.x + rect.width, rect.y + rect.height);
                p.addPoint(xPointerBegin, rect.y + rect.height);
                p.addPoint(valueCoord.x, valueCoord.y);
                p.addPoint(xPointerEnd, rect.y + rect.height);
                p.addPoint(rect.x, rect.y + rect.height);
            } else {
                p.addPoint(rect.x, rect.y);
                p.addPoint(xPointerEnd, rect.y);
                p.addPoint(valueCoord.x, valueCoord.y);
                p.addPoint(xPointerBegin, rect.y);
                p.addPoint(rect.x + rect.width, rect.y);
                p.addPoint(rect.x + rect.width, rect.y + rect.height);
                p.addPoint(rect.x, rect.y + rect.height);
            }
        }
        return p;
    }

    private static class AnnotationBox {
        private Dimension dimension;
        private int fontHeight;

        public AnnotationBox(Dimension dimension, int fontHeight) {
            this.dimension = dimension;
            this.fontHeight = fontHeight;
        }

        public Dimension getDimension() {
            return this.dimension;
        }

        public int getFontHeight() {
            return this.fontHeight;
        }
    }
}

