/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.io.Serializable;
import oracle.dss.graph.pfj.AssertionException;
import oracle.dss.graph.pfj.DataFormat;
import oracle.dss.graph.pfj.DataItem;
import oracle.dss.graph.pfj.DataRange;
import oracle.dss.graph.pfj.DataStorage;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.PfjAssert;
import oracle.dss.graph.pfj.SeriesEnumerator;
import oracle.dss.graph.pfj.ZoomState;

public class Access
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final boolean DEBUG_ACCESS = false;
    Perspective m_Perspective;
    DataStorage m_DataStorage;
    DataRange m_DataRange;
    DataRange m_ViewableDataRange;
    DataFormat m_DataFormat;
    boolean m_bSeriesAreRows;
    boolean m_bItemsAlongSeries;
    boolean m_bItemsAlongRows;
    boolean m_bReverseSeries;
    boolean m_bReverseGroups;
    boolean m_bZoomingArmed;
    ZoomState m_zoomState;
    int m_nonIgnoredSeries;
    int m_nonIgnoredNonHiddenSeries;

    public Access(Perspective perspective, DataStorage ds, DataRange dr, DataFormat df) {
        this.m_Perspective = perspective;
        this.m_DataStorage = ds;
        this.m_DataRange = dr;
        this.m_DataFormat = df;
        this.m_bSeriesAreRows = perspective.getSeriesAreRows();
        this.m_bItemsAlongSeries = perspective.getDataItemsAlongSeries();
        this.m_bItemsAlongRows = this.m_bSeriesAreRows == this.m_bItemsAlongSeries;
        this.m_bReverseSeries = perspective.getReverseSeries();
        this.m_bReverseGroups = perspective.getReverseGroups();
        this.m_bZoomingArmed = perspective.isZoomingArmed();
        this.m_zoomState = this.m_bZoomingArmed ? perspective.getZoomList().getZoomState() : null;
        this.setViewableDataRange(perspective);
        SeriesEnumerator sEnum = new SeriesEnumerator(perspective, this, true);
        this.m_nonIgnoredSeries = sEnum.getNumSeries();
        sEnum = new SeriesEnumerator(perspective, this, true, true);
        this.m_nonIgnoredNonHiddenSeries = sEnum.getNumSeries();
    }

    protected int getCol(int s, int g) {
        return this.getCol(s, g, false);
    }

    public double getDataAsDouble(int s, int g, DataItem item, boolean ignoreDataRange) {
        int r = this.getRow(s, g, ignoreDataRange);
        int c = this.getCol(s, g, ignoreDataRange);
        double fValue = this.m_DataStorage.getDataAsDouble(r += item.getRowOffset(this.m_bItemsAlongRows), c += item.getColOffset(this.m_bItemsAlongRows));
        return fValue;
    }

    public double getDataAsDouble(int s, int g, DataItem item) {
        return this.getDataAsDouble(s, g, item, false);
    }

    public String getDataAsString(int s, int g, DataItem item, boolean ignoreDataRange) {
        String str;
        int r = this.getRow(s, g, ignoreDataRange);
        int c = this.getCol(s, g, ignoreDataRange);
        r += item.getRowOffset(this.m_bItemsAlongRows);
        c += item.getColOffset(this.m_bItemsAlongRows);
        try {
            str = this.m_DataStorage.getDataAsString(r, c);
        }
        catch (AssertionException e) {
            if (item.isRequired()) {
                throw e;
            }
            str = "";
        }
        return str;
    }

    public String getDataAsString(int s, int g, DataItem item) {
        return this.getDataAsString(s, g, item, false);
    }

    public DataFormat getDataFormat() {
        return this.m_DataFormat;
    }

    public int getNumGroups() {
        int nGroups;
        int nPerNode;
        int n = nPerNode = this.m_bItemsAlongSeries ? this.m_DataFormat.getColsPerNode() : this.m_DataFormat.getRowsPerNode();
        if (this.m_bSeriesAreRows) {
            int nCols = this.m_ViewableDataRange.getNumCols();
            nGroups = nCols / nPerNode;
        } else {
            int nRows = this.m_ViewableDataRange.getNumRows();
            nGroups = nRows / nPerNode;
        }
        return nGroups;
    }

    public int getNumNonIgnoredSeries() {
        return this.m_nonIgnoredSeries;
    }

    public int getNumNonIgnoredNonHiddenSeries() {
        return this.m_nonIgnoredNonHiddenSeries;
    }

    public int getNumSeries() {
        int nSeries;
        int nPerNode;
        int n = nPerNode = this.m_bItemsAlongSeries ? this.m_DataFormat.getRowsPerNode() : this.m_DataFormat.getColsPerNode();
        if (this.m_bSeriesAreRows) {
            int nRows = this.m_ViewableDataRange.getNumRows();
            nSeries = nRows / nPerNode;
        } else {
            int nCols = this.m_ViewableDataRange.getNumCols();
            nSeries = nCols / nPerNode;
        }
        return nSeries;
    }

    public int getNumTotalGroups() {
        int nGroups;
        int nPerNode;
        int n = nPerNode = this.m_bItemsAlongSeries ? this.m_DataFormat.getColsPerNode() : this.m_DataFormat.getRowsPerNode();
        if (this.m_bSeriesAreRows) {
            int nCols = this.m_DataRange.getNumCols();
            nGroups = nCols / nPerNode;
        } else {
            int nRows = this.m_DataRange.getNumRows();
            nGroups = nRows / nPerNode;
        }
        return nGroups;
    }

    public int getNumTotalSeries() {
        int nSeries;
        int nPerNode;
        int n = nPerNode = this.m_bItemsAlongSeries ? this.m_DataFormat.getRowsPerNode() : this.m_DataFormat.getColsPerNode();
        if (this.m_bSeriesAreRows) {
            int nRows = this.m_DataRange.getNumRows();
            nSeries = nRows / nPerNode;
        } else {
            int nCols = this.m_DataRange.getNumCols();
            nSeries = nCols / nPerNode;
        }
        return nSeries;
    }

    protected int getRow(int s, int g) {
        return this.getRow(s, g, false);
    }

    public boolean isCellNumeric(int s, int g) {
        return this.isCellNumeric(s, g, DataItem.DI_GENERAL);
    }

    public boolean isCellNumeric(int s, int g, DataItem item) {
        int row = this.getRow(s, g) + item.getRowOffset(this.m_bItemsAlongRows);
        int col = this.getCol(s, g) + item.getColOffset(this.m_bItemsAlongRows);
        return this.m_DataStorage.isCellNumeric(row, col);
    }

    public DataRange getViewableDataRange() {
        return this.m_ViewableDataRange;
    }

    public DataRange getViewableDataRangeSG(Perspective perspective) {
        int nSeries = this.getNumTotalSeries();
        int nGroups = this.getNumTotalGroups();
        int nViewSeriesStart = 0;
        int nViewGroupStart = 0;
        int nViewSeriesStop = nSeries - 1;
        int nViewGroupStop = nGroups - 1;
        int nViewableSeries = perspective.getEffectiveViewableSeries(nSeries);
        int nViewableGroups = perspective.getEffectiveViewableGroups(nGroups);
        if (nViewableSeries != 0 && nSeries > nViewableSeries) {
            nViewSeriesStart = perspective.getEffectiveSeriesOffset();
            if (nViewSeriesStart + nViewableSeries > nSeries) {
                nViewSeriesStart = nSeries - nViewableSeries;
            }
            if ((nViewSeriesStop = nViewSeriesStart + nViewableSeries - 1) >= nSeries) {
                PfjAssert.pfjAssert(nViewSeriesStop < nSeries, "nViewSeriesStop = " + nViewSeriesStop);
            }
        }
        if (nViewableGroups != 0 && nGroups > nViewableGroups) {
            nViewGroupStart = perspective.getEffectiveGroupOffset();
            if (nViewGroupStart + nViewableGroups > nGroups) {
                nViewGroupStart = nGroups - nViewableGroups;
            }
            if ((nViewGroupStop = nViewGroupStart + nViewableGroups - 1) >= nGroups) {
                PfjAssert.pfjAssert(nViewGroupStop < nGroups, "nViewGroupStop = " + nViewGroupStop + " nGroups = " + nGroups);
            }
        }
        return new DataRange(nViewSeriesStart, nViewGroupStart, nViewSeriesStop, nViewGroupStop);
    }

    public void releaseReferences() {
        this.m_Perspective = null;
    }

    public void setDataAsDouble(int s, int g, DataItem item, double fValue, boolean ignoreDataRange) {
        int r = this.getRow(s, g, ignoreDataRange);
        int c = this.getCol(s, g, ignoreDataRange);
        this.m_DataStorage.setData(r += item.getRowOffset(this.m_bItemsAlongRows), c += item.getColOffset(this.m_bItemsAlongRows), fValue);
    }

    public void setDataAsDouble(int s, int g, DataItem item, double fValue) {
        this.setDataAsDouble(s, g, item, fValue, false);
    }

    public void setDataAsString(int s, int g, DataItem item, String val, boolean ignoreDataRange) {
        int r = this.getRow(s, g, ignoreDataRange);
        int c = this.getCol(s, g, ignoreDataRange);
        this.m_DataStorage.setData(r += item.getRowOffset(this.m_bItemsAlongRows), c += item.getColOffset(this.m_bItemsAlongRows), val);
    }

    public void setDataAsString(int s, int g, DataItem item, String val) {
        this.setDataAsString(s, g, item, val, false);
    }

    protected int getCol(int s, int g, boolean ignoreDataRange) {
        int c = 0;
        if (!ignoreDataRange) {
            c = this.m_DataRange.getColStart();
        }
        if (this.m_bSeriesAreRows) {
            if (this.m_bReverseGroups) {
                g = this.getNumTotalGroups() - 1 - g;
            }
            c = this.m_bItemsAlongSeries ? (c += this.m_DataFormat.getColsPerNode() * g) : (c += this.m_DataFormat.getRowsPerNode() * g);
        } else {
            if (this.m_bReverseSeries) {
                s = this.getNumTotalSeries() - 1 - s;
            }
            c = this.m_bItemsAlongSeries ? (c += this.m_DataFormat.getRowsPerNode() * s) : (c += this.m_DataFormat.getColsPerNode() * s);
        }
        return c;
    }

    protected int getRow(int s, int g, boolean ignoreDataRange) {
        int r = 0;
        if (!ignoreDataRange) {
            r = this.m_DataRange.getRowStart();
        }
        if (this.m_bSeriesAreRows) {
            if (this.m_bReverseSeries) {
                s = this.getNumTotalSeries() - 1 - s;
            }
            r = this.m_bItemsAlongSeries ? (r += this.m_DataFormat.getRowsPerNode() * s) : (r += this.m_DataFormat.getColsPerNode() * s);
        } else {
            if (this.m_bReverseGroups) {
                g = this.getNumTotalGroups() - 1 - g;
            }
            r = this.m_bItemsAlongSeries ? (r += this.m_DataFormat.getColsPerNode() * g) : (r += this.m_DataFormat.getRowsPerNode() * g);
        }
        return r;
    }

    public void deleteSeries(int series) {
        if (this.m_bSeriesAreRows) {
            int startRow;
            int endRow = startRow = this.getRow(series, 0, true);
            if (!this.m_bItemsAlongSeries) {
                endRow += this.m_DataFormat.getNumDataItems() - 1;
            }
            for (int r = startRow; r <= endRow; ++r) {
                this.m_DataStorage.deleteRow(r);
            }
            int rowsToShrink = 1;
            if (!this.m_bItemsAlongSeries) {
                rowsToShrink = this.m_DataFormat.getNumDataItems();
            }
            this.m_DataRange.shrinkTo(this.m_DataRange.getRowStart(), this.m_DataRange.getColStart(), this.m_DataRange.getRowStop() - rowsToShrink, this.m_DataRange.getColStop());
        } else {
            int startCol;
            int endCol = startCol = this.getCol(series, 0, true);
            if (!this.m_bItemsAlongSeries) {
                endCol += this.m_DataFormat.getNumDataItems() - 1;
            }
            for (int c = startCol; c <= endCol; ++c) {
                this.m_DataStorage.deleteCol(c);
            }
            int colsToShrink = 1;
            if (!this.m_bItemsAlongSeries) {
                colsToShrink = this.m_DataFormat.getNumDataItems();
            }
            this.m_DataRange.shrinkTo(this.m_DataRange.getRowStart(), this.m_DataRange.getColStart(), this.m_DataRange.getRowStop(), this.m_DataRange.getColStop() - colsToShrink);
        }
    }

    public void deleteGroup(int group) {
        if (this.m_bSeriesAreRows) {
            int startCol;
            int endCol = startCol = this.getCol(0, group, true);
            if (this.m_bItemsAlongSeries) {
                endCol += this.m_DataFormat.getNumDataItems() - 1;
            }
            for (int c = startCol; c <= endCol; ++c) {
                this.m_DataStorage.deleteCol(c);
            }
            int colsToShrink = 1;
            if (this.m_bItemsAlongSeries) {
                colsToShrink = this.m_DataFormat.getNumDataItems();
            }
            this.m_DataRange.shrinkTo(this.m_DataRange.getRowStart(), this.m_DataRange.getColStart(), this.m_DataRange.getRowStop(), this.m_DataRange.getColStop() - colsToShrink);
        } else {
            int startRow;
            int endRow = startRow = this.getRow(0, group, true);
            if (this.m_bItemsAlongSeries) {
                endRow += this.m_DataFormat.getNumDataItems() - 1;
            }
            for (int r = startRow; r <= endRow; ++r) {
                this.m_DataStorage.deleteRow(r);
            }
            int rowsToShrink = 1;
            if (this.m_bItemsAlongSeries) {
                rowsToShrink = this.m_DataFormat.getNumDataItems();
            }
            this.m_DataRange.shrinkTo(this.m_DataRange.getRowStart(), this.m_DataRange.getColStart(), this.m_DataRange.getRowStop() - rowsToShrink, this.m_DataRange.getColStop());
        }
    }

    protected void setViewableDataRange(Perspective perspective) {
        int nColsPerNode;
        int nRowsPerNode;
        DataRange drViewable = this.getViewableDataRangeSG(perspective);
        int nViewableSeries = drViewable.getNumRows();
        int nViewableGroups = drViewable.getNumCols();
        int nViewSeriesStart = drViewable.getRowStart();
        int nViewGroupStart = drViewable.getColStart();
        int nViewSeriesStop = drViewable.getRowStop();
        int nViewGroupStop = drViewable.getColStop();
        boolean bSaveReverseSeries = this.m_bReverseSeries;
        boolean bSaveReverseGroups = this.m_bReverseGroups;
        this.m_bReverseGroups = false;
        this.m_bReverseSeries = false;
        if (this.m_bItemsAlongRows) {
            nRowsPerNode = this.m_DataFormat.getRowsPerNode();
            nColsPerNode = this.m_DataFormat.getColsPerNode();
        } else {
            nRowsPerNode = this.m_DataFormat.getColsPerNode();
            nColsPerNode = this.m_DataFormat.getRowsPerNode();
        }
        int nViewRowStart = this.getRow(nViewSeriesStart, nViewGroupStart);
        int nViewColStart = this.getCol(nViewSeriesStart, nViewGroupStart);
        int nViewRowStop = this.getRow(nViewSeriesStop, nViewGroupStop) + nRowsPerNode - 1;
        int nViewColStop = this.getCol(nViewSeriesStop, nViewGroupStop) + nColsPerNode - 1;
        this.m_bReverseSeries = bSaveReverseSeries;
        this.m_bReverseGroups = bSaveReverseGroups;
        if (nViewRowStop > this.m_DataRange.getRowStop()) {
            nViewRowStop = this.m_DataRange.getRowStop();
        }
        if (nViewColStop > this.m_DataRange.getColStop()) {
            nViewColStop = this.m_DataRange.getColStop();
        }
        this.m_ViewableDataRange = new DataRange(nViewRowStart, nViewColStart, nViewRowStop, nViewColStop);
    }
}

