/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.managers;

import java.awt.Color;
import java.io.Serializable;
import java.util.BitSet;
import oracle.dss.dataView.DataviewUtils;
import oracle.dss.graph.CommonGraph;
import oracle.dss.graph.Series;
import oracle.dss.rules.Mergeable;
import oracle.dss.rules.MergeableXML;
import oracle.dss.util.ErrorHandler;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public class GraphStyle
implements MergeableXML,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    protected CommonGraph m_graph;
    protected ErrorHandler m_eh = null;
    protected Color m_fillColor = null;
    protected boolean m_markerVisible;
    protected int m_markerShape = -3;
    protected BitSet m_propertyUsedFlags;
    private static BitSet NoBitsSet = new BitSet();
    private static final int FillColorPropertyBit = 0;
    private static final int MarkerVisiblePropertyBit = 1;
    private static final int MarkerShapePropertyBit = 2;
    protected static int NumberOfPropertyBits = 3;
    protected static final String a_fillColor = "fillColor";
    protected static final String a_markerVisible = "markerVisible";
    protected static final String a_markerShape = "markerShape";
    protected static final String a_fillColorUsed = "fillColorUsed";
    protected static final String a_markerVisibleUsed = "markerVisibleUsed";
    protected static final String a_markerShapeUsed = "markerShapeUsed";
    protected static final String GRAPH_STYLE_NAME = "GraphStyle";

    public GraphStyle() {
        for (int i = 0; i < NumberOfPropertyBits; ++i) {
            NoBitsSet.clear(i);
        }
        this.m_propertyUsedFlags = new BitSet(NumberOfPropertyBits);
    }

    public GraphStyle(CommonGraph graph) {
        this();
        this.m_graph = graph;
    }

    public void setFillColor(Color color) {
        if (color == null && this.m_fillColor != null) {
            if (this._getErrorHandler() != null) {
                this._getErrorHandler().log("invalid fill color", this.getClass().toString(), "setFillColor");
            }
            return;
        }
        this.m_fillColor = color;
        this.setFillColorUsed(true);
    }

    public Color getFillColor() {
        return this.m_fillColor;
    }

    public void setMarkerVisible(boolean visible) {
        this.m_markerVisible = visible;
        this.setMarkerVisibleUsed(true);
    }

    public boolean isMarkerVisible() {
        return this.m_markerVisible;
    }

    public void setMarkerShape(int shape) {
        this.m_markerShape = shape;
        this.setMarkerShapeUsed(true);
    }

    public int getMarkerShape() {
        return this.m_markerShape;
    }

    public boolean isAnythingOverridden() {
        return !this.m_propertyUsedFlags.equals(NoBitsSet);
    }

    public void merge(Mergeable style) {
        GraphStyle gs = null;
        if (!(style instanceof GraphStyle)) {
            if (this.getErrorHandler() != null) {
                this.getErrorHandler().log("incompatible type Mergeable", this.getClass().getName(), "merge");
            }
            return;
        }
        gs = (GraphStyle)style;
        if (gs.isFillColorUsed()) {
            this.setFillColor(gs.getFillColor());
        }
        if (gs.isMarkerVisibleUsed()) {
            this.setMarkerVisible(gs.isMarkerVisible());
        }
        if (gs.isMarkerShapeUsed()) {
            this.setMarkerShape(gs.getMarkerShape());
        }
    }

    public Object clone() {
        GraphStyle clone = new GraphStyle();
        clone.setCommonGraph(this.m_graph);
        clone.setFillColor(this.m_fillColor);
        clone.setMarkerVisible(this.m_markerVisible);
        clone.setMarkerShape(this.m_markerShape);
        clone.setFillColorUsed(this.isFillColorUsed());
        clone.setMarkerVisibleUsed(this.isMarkerVisibleUsed());
        clone.setMarkerShapeUsed(this.isMarkerShapeUsed());
        return clone;
    }

    public ObjectNode getXML(boolean allProperties, boolean emptyElement) {
        ObjectNode node = new ObjectNode(GRAPH_STYLE_NAME);
        boolean nodeExists = false;
        if (allProperties || this.isFillColorUsed()) {
            if (this.getFillColor() == null) {
                node.addProperty(a_fillColor, "");
            } else {
                node.addProperty(a_fillColor, DataviewUtils.toHexString(this.getFillColor().getRGB()));
            }
            nodeExists = true;
        }
        if (allProperties || this.isMarkerVisibleUsed()) {
            node.addProperty(a_markerVisible, this.isMarkerVisible());
            nodeExists = true;
        }
        if (allProperties || this.isMarkerShapeUsed()) {
            node.addProperty(a_markerShape, Series.convertMarkerShapeToString(this.getMarkerShape()));
            nodeExists = true;
        }
        if (allProperties || this.isFillColorUsed()) {
            node.addProperty(a_fillColorUsed, this.isFillColorUsed());
            nodeExists = true;
        }
        if (allProperties || this.isMarkerVisibleUsed()) {
            node.addProperty(a_markerVisibleUsed, this.isMarkerVisibleUsed());
            nodeExists = true;
        }
        if (allProperties || this.isMarkerShapeUsed()) {
            node.addProperty(a_markerShapeUsed, this.isMarkerShapeUsed());
            nodeExists = true;
        }
        if (nodeExists) {
            return node;
        }
        return null;
    }

    public boolean setXML(ObjectNode node, String version, int reset) {
        PropertyNode pNode = node.getProperty(a_fillColor);
        if (pNode != null) {
            String val = pNode.getValueAsString();
            if (val.equals("")) {
                this.setFillColor(null);
            } else {
                this.setFillColor(new Color(DataviewUtils.hexStringToInt(val)));
            }
        }
        if ((pNode = node.getProperty(a_markerVisible)) != null) {
            this.setMarkerVisible(pNode.getValueAsBoolean());
        }
        if ((pNode = node.getProperty(a_markerShape)) != null) {
            this.setMarkerShape(Series.convertMarkerShapeToInt(pNode.getValueAsString()));
        }
        if ((pNode = node.getProperty(a_fillColorUsed)) != null) {
            this.setFillColorUsed(pNode.getValueAsBoolean());
        }
        if ((pNode = node.getProperty(a_markerVisibleUsed)) != null) {
            this.setMarkerVisibleUsed(pNode.getValueAsBoolean());
        }
        if ((pNode = node.getProperty(a_markerShapeUsed)) != null) {
            this.setMarkerShapeUsed(pNode.getValueAsBoolean());
        }
        return true;
    }

    public void setMarkerShapeUsed(boolean used) {
        if (used) {
            this.m_propertyUsedFlags.set(2);
        } else {
            this.m_propertyUsedFlags.clear(2);
        }
    }

    public boolean isMarkerShapeUsed() {
        return this.m_propertyUsedFlags.get(2);
    }

    public void setMarkerVisibleUsed(boolean used) {
        if (used) {
            this.m_propertyUsedFlags.set(1);
        } else {
            this.m_propertyUsedFlags.clear(1);
        }
    }

    public boolean isMarkerVisibleUsed() {
        return this.m_propertyUsedFlags.get(1);
    }

    public void setFillColorUsed(boolean used) {
        if (used) {
            this.m_propertyUsedFlags.set(0);
        } else {
            this.m_propertyUsedFlags.clear(0);
        }
    }

    public boolean isFillColorUsed() {
        return this.m_propertyUsedFlags.get(0);
    }

    public BitSet getPropertyUsedFlags() {
        return this.m_propertyUsedFlags;
    }

    public void setPropertyUsedFlags(BitSet bs) {
        this.m_propertyUsedFlags = (BitSet)bs.clone();
    }

    public CommonGraph getCommonGraph() {
        return this.m_graph;
    }

    public void setCommonGraph(CommonGraph graph) {
        this.m_graph = graph;
        if (this.m_graph != null) {
            this.setErrorHandler(null);
        }
    }

    private ErrorHandler _getErrorHandler() {
        if (this.m_eh != null) {
            return this.m_eh;
        }
        if (this.m_graph != null && this.m_graph.getErrorHandler() != null) {
            return this.m_graph.getErrorHandler();
        }
        return null;
    }

    public void setErrorHandler(ErrorHandler eh) {
        this.m_eh = eh;
    }

    public ErrorHandler getErrorHandler() {
        return this.m_eh;
    }
}

