/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.gui;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class StyleListEntry {
    protected String m_styleName;
    protected String m_key;
    protected String m_stylePath;
    protected Locale m_locale = null;
    protected ResourceBundle m_bundle = null;
    private boolean _isStandard = false;

    public StyleListEntry() {
        this(null, null);
    }

    public StyleListEntry(String stylePath, String styleName) {
        this(stylePath, styleName, null);
    }

    public StyleListEntry(String stylePath, String resourceKey, boolean isStandard) {
        this(stylePath, null, resourceKey);
        this._isStandard = isStandard;
    }

    public StyleListEntry(String stylePath, String styleName, String resourceKey) {
        this.m_key = resourceKey;
        this.m_stylePath = stylePath;
        this.m_styleName = styleName;
    }

    public boolean equals(Object o) {
        if (o instanceof StyleListEntry) {
            StyleListEntry entry = (StyleListEntry)o;
            if (this == entry) {
                return true;
            }
            String dStylePath = entry.getStylePath();
            String sStylePath = this.getStylePath();
            if (dStylePath != null && sStylePath != null && sStylePath.equals(dStylePath)) {
                return true;
            }
        }
        return false;
    }

    public String getStylePath() {
        return this.m_stylePath;
    }

    public String getStyleName() {
        if (this.m_key != null && this.m_bundle != null) {
            this.m_styleName = this.m_bundle.getString(this.m_key);
        }
        return this.m_styleName;
    }

    public void setLocale(Locale locale) {
        this.m_locale = locale;
        this.updateResourceBundle();
    }

    protected void setResourceBundle(ResourceBundle bundle) {
        this.m_bundle = bundle;
    }

    protected void updateResourceBundle() {
        try {
            this.m_bundle = this.m_locale != null ? ResourceBundle.getBundle("oracle.dss.graph.gui.resource.GraphGUIBundle", this.m_locale) : ResourceBundle.getBundle("oracle.dss.graph.gui.resource.GraphGUIBundle");
        }
        catch (MissingResourceException e) {
            this.m_bundle = null;
        }
    }

    public boolean isStandardStyle() {
        return this._isStandard;
    }
}

