/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.border.GrayPane;
import oracle.bali.ewt.button.DialogButtonBar;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.help.HelpProvider;
import oracle.bali.ewt.help.HelpUnavailableException;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.olaf.BrowserLookAndFeel;
import oracle.bali.ewt.olaf.ColorScheme;
import oracle.bali.ewt.olaf.OracleLookAndFeel;
import oracle.bali.ewt.spinBox.NumericSpinBox;
import oracle.bali.share.nls.StringUtils;
import oracle.dss.graph.Graph;
import oracle.dss.graph.gui.BaseAxis;
import oracle.dss.graph.gui.GraphGUINames;
import oracle.dss.graph.gui.TimeAxis;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.gui.BIColorChoice;
import oracle.dss.util.gui.FontButton;
import oracle.dss.util.help.HelpContext;

public class GroupAxis
extends BaseAxis
implements ChangeListener,
HelpContext,
ActionListener {
    private static final long serialVersionUID = 1L;
    protected JPanel m_subPanel0;
    protected JPanel m_subPanel1;
    protected JPanel m_subPanel2;
    protected JPanel m_showFewSeparatorPanel;
    protected JPanel m_subPanel0SeparatorPanel;
    protected JPanel m_subPanel1SeparatorPanel;
    protected JPanel m_subPanel2SeparatorPanel;
    protected JRadioButton m_showAll;
    protected JRadioButton m_showAutomatic;
    protected JRadioButton m_showFew;
    protected NumericSpinBox m_startItem;
    protected NumericSpinBox m_interval;
    protected JRadioButton m_startItemLabel;
    protected JLabel m_intervalLabel;
    protected FontButton m_labelFontButton;
    protected JButton m_timeAxisButton;
    protected int m_oldStartItem;
    protected int m_oldInterval;
    protected boolean m_bHelpEnabled;
    protected HelpProvider m_helpProvider;
    protected String m_strHelpContextID;
    protected int m_oldSkipMode;
    protected int m_newSkipMode;
    protected boolean m_bTickLabelSkipModeChanged = false;
    protected TimeAxis m_timeAxis = null;
    public static final String PROPERTY_TICKLABEL_SKIPMODE = "TickLabelSkipMode";
    public static final String PROPERTY_TICKLABEL_SKIPFIRST = "TickLabelSkipFirst";
    public static final String PROPERTY_TICKLABEL_SKIPCOUNT = "TickLabelSkipCount";
    private JPanel showAllPanel = null;
    private JPanel showFewPanel = null;
    private JPanel labelFontPanel = null;

    public GroupAxis(Graph graph) {
        super(graph);
        this.updateResourceBundle(graph.getLocale());
        this.setTitleText(this.rBundle.getString("X-Axis options"));
        this.m_showAxis.setText(StringUtils.stripMnemonic((String)this.rBundle.getString("Show X-Axis Title")));
        this.m_showAxis.setMnemonic(StringUtils.getMnemonicKeyCode((String)this.rBundle.getString("Show X-Axis Title")));
        this.m_lineLabel.setText(this.rBundle.getString("X-Axis line options"));
        this.m_optionsLabel.setText(this.rBundle.getString("X-Axis labels"));
        this.m_fontButton.setText(StringUtils.stripMnemonic((String)this.rBundle.getString("X-Title Font")));
        this.m_fontButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)this.rBundle.getString("X-Title Font")));
        this.m_fontButton.setDialogTitle(this.rBundle.getString("X-Title Font For FontButton"));
        this.m_showAutomatic = new JRadioButton(StringUtils.stripMnemonic((String)this.rBundle.getString("Auto axis labels")));
        this.m_showAutomatic.setMnemonic(StringUtils.getMnemonicKeyCode((String)this.rBundle.getString("Auto axis labels")));
        this.m_showAutomatic.setName(GraphGUINames.AXISSHOWLABLESAUTO_RADIOBUTTON);
        this.m_showAll = new JRadioButton(StringUtils.stripMnemonic((String)this.rBundle.getString("Show axis labels")));
        this.m_showAll.setMnemonic(StringUtils.getMnemonicKeyCode((String)this.rBundle.getString("Show axis labels")));
        this.m_showAll.setName(GraphGUINames.AXISSHOWLABLESALL_RADIOBUTTON);
        this.m_showFew = new JRadioButton(StringUtils.stripMnemonic((String)this.rBundle.getString("Axis Show labels")));
        this.m_showFew.setMnemonic(StringUtils.getMnemonicKeyCode((String)this.rBundle.getString("Axis Show labels")));
        this.m_showFew.setName(GraphGUINames.AXISSHOWLABLESFEW_RADIOBUTTON);
        this.showAllPanel = new JPanel();
        this.showAllPanel.setLayout(new BoxLayout(this.showAllPanel, 0));
        this.showAllPanel.add(this.m_showAll);
        this.showFewPanel = new JPanel();
        this.showFewPanel.setLayout(new BoxLayout(this.showFewPanel, 0));
        this.m_showFewSeparatorPanel = new JPanel();
        this.m_showFewSeparatorPanel.setLayout(new BoxLayout(this.m_showFewSeparatorPanel, 1));
        this.m_showFewSeparatorPanel.add(Box.createVerticalStrut(5));
        this.showFewPanel.add(this.m_showFew);
        ButtonGroup group = new ButtonGroup();
        group.add(this.m_showAll);
        group.add(this.m_showFew);
        this.m_subPanel0 = new JPanel();
        this.m_subPanel0.setLayout(new BoxLayout(this.m_subPanel0, 0));
        this.m_subPanel0SeparatorPanel = new JPanel();
        this.m_subPanel0SeparatorPanel.setLayout(new BoxLayout(this.m_subPanel0SeparatorPanel, 1));
        this.m_subPanel0SeparatorPanel.add(Box.createVerticalStrut(5));
        this.m_subPanel0.add(Box.createHorizontalStrut(24));
        this.m_subPanel0.add(this.m_showAutomatic);
        this.m_subPanel1 = new JPanel();
        this.m_subPanel1.setLayout(new BoxLayout(this.m_subPanel1, 0));
        this.m_subPanel1SeparatorPanel = new JPanel();
        this.m_subPanel1SeparatorPanel.setLayout(new BoxLayout(this.m_subPanel1SeparatorPanel, 1));
        this.m_subPanel1SeparatorPanel.add(Box.createVerticalStrut(5));
        this.m_subPanel1.add(Box.createHorizontalStrut(24));
        int columnCount = 0;
        try {
            columnCount = this.m_graph.isDataRowShownAsASeries() ? this.m_graph.getColumnCount() : this.m_graph.getRowCount();
        }
        catch (EdgeOutOfRangeException e) {
            // empty catch block
        }
        if (columnCount == 0) {
            columnCount = 1;
        }
        this.m_startItemLabel = new JRadioButton(StringUtils.stripMnemonic((String)this.rBundle.getString("Starting with")));
        this.m_startItemLabel.setMnemonic(StringUtils.getMnemonicKeyCode((String)this.rBundle.getString("Starting with")));
        this.m_startItemLabel.setName(GraphGUINames.AXISSTARTSHOWWITH_RADIOBUTTON);
        this.m_subPanel1.add(this.m_startItemLabel);
        this.m_startItem = new NumericSpinBox(1, columnCount);
        this.m_startItem.setName(GraphGUINames.AXISSTARTTICKMARK_NUMSPINBOX);
        this.m_subPanel1.add(Box.createHorizontalStrut(12));
        this.m_subPanel1.add((Component)this.m_startItem);
        this.m_labelFontButton = new FontButton(StringUtils.stripMnemonic((String)this.rBundle.getString("X-Axis Label")));
        this.m_labelFontButton.setName(GraphGUINames.AXISLABELFONT_BUTTON);
        this.m_labelFontButton.setCustomColorsEnabled(graph.isCustomColorsEnabled());
        this.m_labelFontButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)this.rBundle.getString("X-Axis Label")));
        this.m_labelFontButton.setDialogTitle(this.rBundle.getString("X-Axis Label For FontButton"));
        this.m_labelFontButton.setPaneLocale(graph.getLocale());
        this.labelFontPanel = new JPanel(new FlowLayout(2, 0, 0));
        if (this.isTimeAxis()) {
            this.m_timeAxisButton = new JButton(StringUtils.stripMnemonic((String)this.rBundle.getString("TimeAxisButton")));
            this.m_timeAxisButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)this.rBundle.getString("TimeAxisButton")));
            this.m_timeAxisButton.addActionListener(this);
            this.labelFontPanel.add(this.m_timeAxisButton);
            this.labelFontPanel.add(Box.createHorizontalStrut(10));
        }
        this.labelFontPanel.add((Component)this.m_labelFontButton);
        this.initFontButton(this.m_labelFontButton);
        this.m_subPanel2 = new JPanel();
        this.m_subPanel2.setLayout(new BoxLayout(this.m_subPanel2, 0));
        this.m_intervalLabel = new JLabel(StringUtils.stripMnemonic((String)this.rBundle.getString("Ticks to skip")));
        this.m_intervalLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)this.rBundle.getString("Ticks to skip")));
        this.m_subPanel2SeparatorPanel = new JPanel();
        this.m_subPanel2SeparatorPanel.setLayout(new BoxLayout(this.m_subPanel2SeparatorPanel, 1));
        this.m_subPanel2SeparatorPanel.add(Box.createVerticalStrut(5));
        this.m_subPanel2.add(Box.createHorizontalStrut(41));
        this.m_subPanel2.add(this.m_intervalLabel);
        this.m_interval = new NumericSpinBox(0, columnCount - 1);
        this.m_interval.setName(GraphGUINames.AXISSKIPTICKMARKS_NUMSPINBOX);
        this.m_intervalLabel.setLabelFor((Component)this.m_interval);
        this.m_subPanel2.add(Box.createHorizontalStrut(12));
        this.m_subPanel2.add((Component)this.m_interval);
        this.m_showAutomatic.setForeground(this.m_label.getForeground());
        this.m_showAll.setForeground(this.m_label.getForeground());
        this.m_showFew.setForeground(this.m_label.getForeground());
        this.m_labelFontButton.setForeground(this.m_label.getForeground());
        ButtonGroup showFew = new ButtonGroup();
        showFew.add(this.m_showAutomatic);
        showFew.add(this.m_startItemLabel);
        this.m_mainPanel.add(this.showAllPanel);
        this.m_mainPanel.add(this.m_showFewSeparatorPanel);
        this.m_mainPanel.add(this.showFewPanel);
        this.m_mainPanel.add(this.m_subPanel0SeparatorPanel);
        this.m_mainPanel.add(this.m_subPanel0);
        this.m_mainPanel.add(this.m_subPanel1SeparatorPanel);
        this.m_mainPanel.add(this.m_subPanel1);
        this.m_mainPanel.add(this.m_subPanel2SeparatorPanel);
        this.m_mainPanel.add(this.m_subPanel2);
        this.m_mainPanel.add(Box.createVerticalStrut(15));
        this.m_mainPanel.add(this.labelFontPanel);
        this.calculatePanelSizes();
        this.calculatePreferredSize();
        this.m_mainPanel.add(Box.createGlue());
        this.m_subPanel0.setAlignmentX(0.0f);
        this.m_showAll.setAlignmentX(0.0f);
        this.showAllPanel.setAlignmentX(0.0f);
        this.m_showFew.setAlignmentX(0.0f);
        this.showFewPanel.setAlignmentX(0.0f);
        this.m_subPanel1.setAlignmentX(0.0f);
        this.m_subPanel2.setAlignmentX(0.0f);
        this.labelFontPanel.setAlignmentX(0.0f);
        this.m_showAutomatic.addItemListener(this);
        this.m_showAll.addItemListener(this);
        this.m_showFew.addItemListener(this);
        this.m_showAutomatic.addItemListener(this);
        this.m_startItemLabel.addItemListener(this);
        this._init();
        this.m_labelFontButton.addPropertyChangeListener((PropertyChangeListener)this);
        this.m_interval.addChangeListener((ChangeListener)this);
        this.m_startItem.addChangeListener((ChangeListener)this);
    }

    @Override
    public void setGraph(Graph graph) {
        super.setGraph(graph);
        this.initFontButton(this.m_labelFontButton);
        this._init();
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
    }

    @Override
    public void setColorPalette(Color[][] colors) {
        super.setColorPalette(colors);
        this.m_labelFontButton.setColorPalette(this.m_colorPalette);
    }

    private void _init() {
        this.m_font = this.m_graph.getO1Title().getFont();
        this.m_oldAxisColor = this.m_graph.getO1Axis().getLineColor();
        this.m_oldAxisTitle = this.m_token.getTokenString(this.m_graph.getO1Title().getUnParseText());
        this.m_oldLineWidth = this.m_graph.getO1Axis().getLineWidth();
        this.m_oldStartItem = this.m_graph.getO1TickLabel().getTickLabelSkipFirst();
        this.m_oldInterval = this.m_graph.getO1TickLabel().getTickLabelSkipCount();
        this.m_newSkipMode = this.m_graph.getO1TickLabel().getTickLabelSkipMode();
        this.m_axisTitle.setText(this.m_token.getTokenString(this.m_graph.getO1Title().getUnParseText()));
        if (this.m_axisTitle.getText() != null) {
            this.m_axisTitle.setCaretPosition(this.m_axisTitle.getText().length());
        }
        this.m_showAxis.setSelected(this.m_graph.getO1Title().isVisible());
        this.m_axisTitle.setHorizontalAlignment(this.m_graph.getO1Title().getHorizontalAlignment());
        this.m_fontButton.setComponentFont(this.m_graph.getO1Title().getFont());
        if (this.m_graph.getO1Title().getGraphFont().getGraphFontStyle() >= 4) {
            this.m_fontButton.setUnderlineStyle(true);
            this.m_axisTitle.setUnderline(true);
        } else {
            this.m_fontButton.setUnderlineStyle(false);
            this.m_axisTitle.setUnderline(false);
        }
        this.m_fontButton.setPaneHorizontalAlignment(this.m_graph.getO1Title().getHorizontalAlignment());
        this.m_fontButton.setComponentForeground(this.m_graph.getO1Title().getGraphFont().getGraphFontColor());
        int rotation = this.convertToFontButtonConstants(this.m_graph.getO1Title().getTextRotation());
        if (rotation == 1 && this.m_graph.isHorizontal()) {
            rotation = 2;
        }
        this.m_fontButton.setTextRotation(rotation);
        this.m_axisTitle.setForeground(this.m_fontButton.getComponentForeground());
        Font f = this.m_fontButton.getComponentFont();
        this.m_axisTitle.setFont(new Font(f.getName(), f.getStyle(), this.m_axisTitle.getFont().getSize()));
        Color color = this.m_graph.getO1Axis().getLineColor();
        if (!this.m_bColorPaletteSet) {
            if (!BIColorChoice.isColorInPalette((TwoDModel)this.m_colorButton.getColorPalette(), (Color)color)) {
                this.m_colorButton.setColorPalette(FontButton.getNewColorPalette((TwoDModel)this.m_colorButton.getColorPalette(), (Color)color, (boolean)this.m_bColorPaletteSet));
            }
            this.m_colorButton.setSelectedColor(color);
        } else {
            this.m_colorButton.setSelectedColor(this.m_colorButton.getClosestColor(color));
        }
        this.m_lColor = color;
        this.m_lineWidth.setCellColor(this.m_colorButton.getSelectedColor());
        this.m_lineWidth.setLineWidth(this.m_graph.getO1Axis().getLineWidth());
        boolean timeAxis = this.isTimeAxis();
        if (timeAxis) {
            this.showAllPanel.setVisible(false);
            this.showFewPanel.setVisible(false);
            this.m_subPanel0.setVisible(false);
            this.m_subPanel1.setVisible(false);
            this.m_subPanel2.setVisible(false);
            this.m_optionsLabelPanel.setVisible(false);
            this.m_showFewSeparatorPanel.setVisible(false);
            this.m_subPanel0SeparatorPanel.setVisible(false);
            this.m_subPanel1SeparatorPanel.setVisible(false);
            this.m_subPanel2SeparatorPanel.setVisible(false);
            this.m_optionSeparatorPanel.setVisible(false);
            this.m_timeAxis = new TimeAxis(this.m_graph);
        }
        if (!timeAxis) {
            if (this.m_graph.getO1TickLabel().getTickLabelSkipMode() == 1) {
                this.m_showFew.setSelected(true);
                this.m_showAutomatic.setSelected(true);
            } else if (this.m_graph.getO1TickLabel().getTickLabelSkipMode() == 0) {
                this.m_showAll.setSelected(true);
                this.m_showFew.setSelected(false);
            } else {
                this.m_showFew.setSelected(true);
                this.m_startItemLabel.setSelected(true);
            }
            int columnCount = 0;
            try {
                columnCount = this.m_graph.isDataRowShownAsASeries() ? this.m_graph.getColumnCount() : this.m_graph.getRowCount();
            }
            catch (EdgeOutOfRangeException e) {
                // empty catch block
            }
            if (columnCount == 0) {
                columnCount = 1;
            }
            this.m_interval.setMaximum(columnCount);
            this.m_startItem.setMaximum(columnCount);
            int skipFirst = this.m_graph.getO1TickLabel().getTickLabelSkipFirst() + 1;
            if (skipFirst > columnCount) {
                skipFirst = columnCount;
            }
            this.m_startItem.setIntValue(skipFirst);
            int skipCount = this.m_graph.getO1TickLabel().getTickLabelSkipCount();
            if (skipCount > columnCount) {
                skipCount = columnCount;
            }
            this.m_interval.setIntValue(skipCount);
        }
        this.m_labelFontButton.setComponentFont(this.m_graph.getO1TickLabel().getFont());
        if (this.m_graph.getO1TickLabel().getGraphFont().getGraphFontStyle() >= 4) {
            this.m_labelFontButton.setUnderlineStyle(true);
        } else {
            this.m_labelFontButton.setUnderlineStyle(false);
        }
        this.m_labelFontButton.setComponentForeground(this.m_graph.getO1TickLabel().getGraphFont().getGraphFontColor());
        int autoRotation = this.m_graph.getO1TickLabel().getAutomaticRotation();
        if (!(this.isGraphHorizontal() || autoRotation != 1 && autoRotation != 2)) {
            this.m_labelFontButton.setTextRotation(0);
        } else {
            this.m_labelFontButton.setTextRotation(this.convertToFontButtonConstants(this.m_graph.getO1TickLabel().getTextRotation()));
        }
        if (this.m_graph.getGraphType() >= 67 && this.m_graph.getGraphType() <= 69) {
            this.m_axisLineSeparatorPanel.setVisible(false);
            this.m_axisTitlePanel.setVisible(false);
            this.m_lineWidthPanel.setVisible(false);
        } else if (this.m_graph.getGraphType() >= 0 && this.m_graph.getGraphType() <= 14) {
            this.m_axisLinePanel.setVisible(false);
            this.m_axisLineSeparatorPanel.setVisible(false);
        } else {
            this.m_axisTitlePanel.setVisible(true);
            this.m_lineWidthPanel.setVisible(true);
            this.m_axisLineSeparatorPanel.setVisible(true);
            this.m_axisLinePanel.setVisible(true);
        }
        this.m_bLineWidthChanged = false;
        this.m_bLineColorChanged = false;
        this.m_bTickLabelSkipModeChanged = false;
        this.m_bTitleTextChanged = false;
        this.m_bTitleVisibleChanged = false;
    }

    private void calculatePanelSizes() {
        int pWidth = Math.max(this.m_lineLabel.getPreferredSize().width, this.axisLinePanel.getPreferredSize().width);
        int pHeight = this.m_lineLabel.getPreferredSize().height + 5 + this.axisLinePanel.getPreferredSize().height;
        this.m_axisLinePanel.setPreferredSize(new Dimension(pWidth, pHeight));
        this.m_axisLinePanel.setMinimumSize(this.m_axisLinePanel.getPreferredSize());
        this.m_axisLinePanel.setMaximumSize(this.m_axisLinePanel.getPreferredSize());
        pWidth = this.m_optionsLabel.getPreferredSize().width;
        pHeight = this.m_optionsLabel.getPreferredSize().height + 5;
        this.m_optionsLabelPanel.setPreferredSize(new Dimension(pWidth, pHeight));
        this.m_optionsLabelPanel.setMinimumSize(this.m_optionsLabelPanel.getPreferredSize());
        this.m_optionsLabelPanel.setMaximumSize(this.m_optionsLabelPanel.getPreferredSize());
        int showAutoLabel = this.m_showAutomatic.getFontMetrics(this.m_showAutomatic.getFont()).stringWidth(this.m_showAutomatic.getText());
        int startLabel = this.m_startItemLabel.getFontMetrics(this.m_startItemLabel.getFont()).stringWidth(this.m_startItemLabel.getText());
        int intervalLabel = this.m_intervalLabel.getFontMetrics(this.m_intervalLabel.getFont()).stringWidth(this.m_intervalLabel.getText());
        int width = Math.max(showAutoLabel, Math.max(startLabel, intervalLabel));
        this.m_startItemLabel.setPreferredSize(new Dimension(width + 17, this.m_startItemLabel.getPreferredSize().height));
        this.m_startItemLabel.setMinimumSize(this.m_startItemLabel.getPreferredSize());
        this.m_startItemLabel.setMaximumSize(this.m_startItemLabel.getPreferredSize());
        this.m_intervalLabel.setPreferredSize(new Dimension(width, this.m_startItemLabel.getPreferredSize().height));
        this.m_intervalLabel.setMinimumSize(this.m_intervalLabel.getPreferredSize());
        this.m_intervalLabel.setMaximumSize(this.m_intervalLabel.getPreferredSize());
        pWidth = this.m_showAll.getPreferredSize().width;
        pHeight = this.m_showAll.getPreferredSize().height;
        this.showAllPanel.setPreferredSize(new Dimension(pWidth, pHeight));
        this.showAllPanel.setMinimumSize(this.showAllPanel.getPreferredSize());
        this.showAllPanel.setMaximumSize(this.showAllPanel.getPreferredSize());
        pWidth = this.m_showFew.getPreferredSize().width;
        pHeight = this.m_showFew.getPreferredSize().height;
        this.showFewPanel.setPreferredSize(new Dimension(pWidth, pHeight));
        this.showFewPanel.setMinimumSize(this.showFewPanel.getPreferredSize());
        this.showFewPanel.setMaximumSize(this.showFewPanel.getPreferredSize());
        pWidth = 24 + this.m_showAutomatic.getPreferredSize().width;
        pHeight = this.m_showAutomatic.getPreferredSize().height;
        this.m_subPanel0.setPreferredSize(new Dimension(pWidth, pHeight));
        this.m_subPanel0.setMinimumSize(this.m_subPanel0.getPreferredSize());
        this.m_subPanel0.setMaximumSize(this.m_subPanel0.getPreferredSize());
        pWidth = 24 + this.m_startItemLabel.getPreferredSize().width + 12 + this.m_startItem.getPreferredSize().width;
        pHeight = Math.max(this.m_startItemLabel.getPreferredSize().height, this.m_startItem.getPreferredSize().height);
        this.m_subPanel1.setPreferredSize(new Dimension(pWidth, pHeight));
        this.m_subPanel1.setMinimumSize(this.m_subPanel1.getPreferredSize());
        this.m_subPanel1.setMaximumSize(this.m_subPanel1.getPreferredSize());
        pWidth = 41 + this.m_intervalLabel.getPreferredSize().width + 12 + this.m_interval.getPreferredSize().width;
        pHeight = Math.max(this.m_intervalLabel.getPreferredSize().height, this.m_interval.getPreferredSize().height);
        this.m_subPanel2.setPreferredSize(new Dimension(pWidth, pHeight));
        this.m_subPanel2.setMinimumSize(this.m_subPanel2.getPreferredSize());
        this.m_subPanel2.setMaximumSize(this.m_subPanel2.getPreferredSize());
    }

    private void calculatePreferredSize() {
        int maxWidth = 0;
        int pWidth = this.m_axisTitlePanel.getPreferredSize().width;
        if (maxWidth < pWidth) {
            maxWidth = pWidth;
        }
        if (maxWidth < (pWidth = this.m_axisLinePanel.getPreferredSize().width)) {
            maxWidth = pWidth;
        }
        if (maxWidth < (pWidth = this.m_optionsLabelPanel.getPreferredSize().width)) {
            maxWidth = pWidth;
        }
        if (maxWidth < (pWidth = this.showAllPanel.getPreferredSize().width)) {
            maxWidth = pWidth;
        }
        if (maxWidth < (pWidth = this.showFewPanel.getPreferredSize().width)) {
            maxWidth = pWidth;
        }
        if (maxWidth < (pWidth = this.m_subPanel0.getPreferredSize().width)) {
            maxWidth = pWidth;
        }
        if (maxWidth < (pWidth = this.m_subPanel1.getPreferredSize().width)) {
            maxWidth = pWidth;
        }
        if (maxWidth < (pWidth = this.m_subPanel2.getPreferredSize().width)) {
            maxWidth = pWidth;
        }
        if (maxWidth < (pWidth = this.labelFontPanel.getPreferredSize().width)) {
            maxWidth = pWidth;
        }
        pWidth = maxWidth + 10 + 10;
        int pHeight = 10 + this.m_label.getPreferredSize().height + 15 + this.m_axisTitlePanel.getPreferredSize().height + 15 + this.m_axisLinePanel.getPreferredSize().height + 15 + this.m_optionsLabelPanel.getPreferredSize().height + this.showAllPanel.getPreferredSize().height + 5 + this.showFewPanel.getPreferredSize().height + 5 + this.m_subPanel0.getPreferredSize().height + 5 + this.m_subPanel1.getPreferredSize().height + 5 + this.m_subPanel2.getPreferredSize().height + 15 + this.labelFontPanel.getPreferredSize().height + 10;
        if (this.isTimeAxis()) {
            pHeight -= 15 + this.m_optionsLabelPanel.getPreferredSize().height + this.showAllPanel.getPreferredSize().height + 5 + this.showFewPanel.getPreferredSize().height + 5 + this.m_subPanel0.getPreferredSize().height + 5 + this.m_subPanel1.getPreferredSize().height + 5 + this.m_subPanel2.getPreferredSize().height;
        }
        if (this.m_graph.getGraphType() >= 67 && this.m_graph.getGraphType() <= 69) {
            pHeight -= this.m_axisTitlePanel.getPreferredSize().height + 15;
        } else if (this.m_graph.getGraphType() >= 0 && this.m_graph.getGraphType() <= 14) {
            pHeight -= 15 + this.m_axisLinePanel.getPreferredSize().height;
        }
        this.prefSize = new Dimension(pWidth, pHeight);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.prefSize;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.m_startItem) {
            int newStartItem = this.m_startItem.getIntValue() - 1;
            this.firePropertyChange(PROPERTY_TICKLABEL_SKIPFIRST, this.m_oldStartItem, newStartItem);
            this.m_oldStartItem = newStartItem;
        } else if (e.getSource() == this.m_interval) {
            int newInterval = this.m_interval.getIntValue();
            this.firePropertyChange(PROPERTY_TICKLABEL_SKIPCOUNT, this.m_oldInterval, newInterval);
            this.m_oldInterval = newInterval;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        if (e.getSource() == this.m_timeAxisButton) {
            TimeAxisDialog d = this.createTimeAxisDialog(this.rBundle.getString("TimeAxisTitle"), true, this.m_timeAxis, this.isHelpEnabled());
            d.show();
            d.dispose();
            Object var2_2 = null;
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        super.itemStateChanged(e);
        if (e.getSource() == this.m_showAll || e.getSource() == this.m_showFew || e.getSource() == this.m_showAutomatic) {
            this.m_bTickLabelSkipModeChanged = true;
        }
        if (e.getStateChange() == 1) {
            if (e.getSource() == this.m_showAll) {
                this.m_showAutomatic.setEnabled(false);
                this.m_startItem.setEnabled(false);
                this.m_startItemLabel.setEnabled(false);
                this.m_interval.setEnabled(false);
                this.m_intervalLabel.setEnabled(false);
                this.m_oldSkipMode = this.m_newSkipMode;
                this.m_newSkipMode = 0;
                this.firePropertyChange(PROPERTY_TICKLABEL_SKIPMODE, this.m_oldSkipMode, this.m_newSkipMode);
            } else if (e.getSource() == this.m_showFew) {
                this.m_showAutomatic.setEnabled(true);
                this.m_startItem.setEnabled(true);
                this.m_startItemLabel.setEnabled(true);
                this.m_interval.setEnabled(true);
                this.m_intervalLabel.setEnabled(true);
                this.m_showAutomatic.setSelected(true);
                this.m_oldSkipMode = this.m_newSkipMode;
                this.m_newSkipMode = 1;
                this.firePropertyChange(PROPERTY_TICKLABEL_SKIPMODE, this.m_oldSkipMode, this.m_newSkipMode);
            }
            if (e.getSource() == this.m_showAutomatic) {
                this.m_startItem.setEnabled(false);
                this.m_interval.setEnabled(false);
                this.m_oldSkipMode = this.m_newSkipMode;
                this.m_newSkipMode = 1;
                this.firePropertyChange(PROPERTY_TICKLABEL_SKIPMODE, this.m_oldSkipMode, this.m_newSkipMode);
            }
            if (e.getSource() == this.m_startItemLabel) {
                this.m_startItem.setEnabled(true);
                this.m_interval.setEnabled(true);
                this.m_oldSkipMode = this.m_newSkipMode;
                this.m_newSkipMode = 2;
                this.firePropertyChange(PROPERTY_TICKLABEL_SKIPMODE, this.m_oldSkipMode, this.m_newSkipMode);
            }
        }
    }

    @Override
    public void apply() {
        this.applyAfterCheck();
    }

    public boolean applyAfterCheck() {
        if (!this.checkForBadInput()) {
            return false;
        }
        if (this.m_graph.getGraphType() < 67 || this.m_graph.getGraphType() > 69) {
            int rotation;
            if (this.m_bTitleTextChanged) {
                this.m_graph.getO1Title().setText(this.m_token.getKeyString(this.m_axisTitle.getText()));
            }
            if (this.m_bTitleVisibleChanged) {
                this.m_graph.getO1Title().setVisible(this.m_showAxis.isSelected());
            }
            if (this.m_bTitleFontNameChanged) {
                this.m_graph.getO1Title().getGraphFont().setGraphFontTypeface(this.m_fontButton.getComponentFont().getName());
            }
            if (this.m_bTitleFontSizeChanged) {
                this.m_graph.getO1Title().getGraphFont().setGraphFontSize(this.m_fontButton.getComponentFont().getSize());
            }
            if (this.m_bTitleFontBoldChanged) {
                this.m_graph.getO1Title().getGraphFont().setFontBold(this.m_fontButton.getComponentFont().isBold());
            }
            if (this.m_bTitleFontItalicChanged) {
                this.m_graph.getO1Title().getGraphFont().setFontItalic(this.m_fontButton.getComponentFont().isItalic());
            }
            if (this.m_bTitleFontUnderlineChanged) {
                this.m_graph.getO1Title().getGraphFont().setUnderline(this.m_fontButton.isUnderlineStyle());
            }
            if (this.m_bTitleAlignmentChanged) {
                this.m_graph.getO1Title().setHorizontalAlignment(this.m_fontButton.getPaneHorizontalAlignment());
            }
            if (this.m_bTitleFontColorChanged) {
                this.m_graph.getO1Title().getGraphFont().setGraphFontColor(this.m_fontButton.getComponentForeground());
            }
            if (this.m_bTitleRotationChanged && (rotation = this.convertFromFontButtonConstants(this.m_fontButton.getTextRotation())) != -1) {
                this.m_graph.getO1Title().setTextRotation(rotation);
            }
            if (this.m_bLineWidthChanged) {
                this.m_graph.getO1Axis().setLineWidth(this.m_lineWidth.getLineWidth());
            }
        }
        if (this.m_bLineColorChanged) {
            this.m_graph.getO1Axis().setLineColor(this.m_colorButton.getSelectedColor());
        }
        if (this.m_startItemLabel.isSelected()) {
            this.m_graph.getO1TickLabel().setTickLabelSkipCount(this.m_interval.getIntValue());
            this.m_graph.getO1TickLabel().setTickLabelSkipFirst(this.m_startItem.getIntValue() - 1);
        }
        if (this.m_bTickLabelSkipModeChanged) {
            if (this.m_showAll.isSelected()) {
                this.m_graph.getO1TickLabel().setTickLabelSkipMode(0);
            } else if (this.m_showAutomatic.isSelected()) {
                this.m_graph.getO1TickLabel().setTickLabelSkipMode(1);
            } else {
                this.m_graph.getO1TickLabel().setTickLabelSkipMode(2);
            }
        }
        if (this.m_bLabelFontNameChanged) {
            this.m_graph.getO1TickLabel().getGraphFont().setGraphFontTypeface(this.m_labelFontButton.getComponentFont().getName());
        }
        if (this.m_bLabelFontSizeChanged) {
            this.m_graph.getO1TickLabel().getGraphFont().setGraphFontSize(this.m_labelFontButton.getComponentFont().getSize());
        }
        if (this.m_bLabelFontBoldChanged) {
            this.m_graph.getO1TickLabel().getGraphFont().setFontBold(this.m_labelFontButton.getComponentFont().isBold());
        }
        if (this.m_bLabelFontItalicChanged) {
            this.m_graph.getO1TickLabel().getGraphFont().setFontItalic(this.m_labelFontButton.getComponentFont().isItalic());
        }
        if (this.m_bLabelFontUnderlineChanged) {
            this.m_graph.getO1TickLabel().getGraphFont().setUnderline(this.m_labelFontButton.isUnderlineStyle());
        }
        if (this.m_bLabelFontColorChanged) {
            this.m_graph.getO1TickLabel().getGraphFont().setGraphFontColor(this.m_labelFontButton.getComponentForeground());
        }
        if (this.m_bLabelRotationChanged) {
            int tickRotation = this.convertFromFontButtonConstants(this.m_labelFontButton.getTextRotation());
            if (tickRotation == -1) {
                this.m_graph.getO1TickLabel().setTextRotation(0);
                this.m_graph.getO1TickLabel().setAutomaticRotation(2);
            } else {
                this.m_graph.getO1TickLabel().setAutomaticRotation(0);
                this.m_graph.getO1TickLabel().setTextRotation(tickRotation);
            }
        }
        if (this.m_timeAxis != null) {
            this.m_timeAxis.apply();
        }
        return true;
    }

    public String getHelpContextID() {
        if (this.isTimeAxis()) {
            return this.getClass().getName() + "_Time";
        }
        return this.getClass().getName() + "_Ordinal";
    }

    public void setHelpContextID(String strHelpContextID) {
        this.m_strHelpContextID = strHelpContextID;
    }

    public void setHelpProvider(HelpProvider helpProvider) {
        this.m_helpProvider = helpProvider;
        this.m_labelFontButton.setHelpProvider(helpProvider);
        this.m_fontButton.setHelpProvider(helpProvider);
    }

    public HelpProvider getHelpProvider() {
        return this.m_helpProvider;
    }

    public void setHelpEnabled(boolean bValue) {
        this.m_bHelpEnabled = bValue;
    }

    public boolean isHelpEnabled() {
        return this.m_bHelpEnabled;
    }

    @Override
    protected void initTitleFontButton(FontButton f) {
        super.initTitleFontButton(f);
        if (this.isGraphHorizontal()) {
            int rbutton = 12;
            f.setRotationButtonMask(rbutton);
        } else {
            f.setRotationButtonMask(0);
        }
    }

    protected void initFontButton(FontButton f) {
        boolean drillingEnabled = this.m_graph.isDrillingEnabled();
        int sbutton = 3;
        if (!drillingEnabled) {
            sbutton |= 4;
        }
        int cbutton = 1;
        int rbutton = 14;
        f.setStyleButtonMask(sbutton);
        f.setAlignmentButtonMask(0);
        f.setColorComponentMask(cbutton);
        if (!this.isGraphHorizontal()) {
            rbutton = 15;
        }
        if (this.isTimeAxis()) {
            rbutton = 0;
        }
        f.setRotationButtonMask(rbutton);
    }

    protected boolean checkForBadInput() {
        if (this.isTimeAxis()) {
            return true;
        }
        if (this.m_showFew.isSelected() && this.m_startItemLabel.isSelected() && this.m_startItem.getIntValue() > this.m_interval.getIntValue() + 1) {
            if (this.m_errorTypes == 65535) {
                Object[] args = new String[]{Integer.toString(this.m_interval.getIntValue()), Integer.toString(this.m_interval.getIntValue() + 1)};
                String errorMsg = MessageFormat.format(this.rBundle.getString("Large starting tick mark"), args);
                JOptionPane jpane = new JOptionPane(errorMsg, 0, -1, new ImageIcon(ImageUtils.getImageResource(GroupAxis.class, (String)"images/stop.gif")));
                jpane.getAccessibleContext().setAccessibleName(errorMsg);
                JDialog tmpDialog = jpane.createDialog(this, this.m_applicationName);
                tmpDialog.show();
                return false;
            }
            if (this.m_eh != null) {
                this.m_eh.log("Starting tick mark is greater than the number of tick marks to skip + 1", this.getClass().getName(), "checkForBadInput");
            }
        }
        return true;
    }

    private boolean isTimeAxis() {
        if (this.m_graph instanceof Graph) {
            return this.m_graph.getPFJ().isTimeAxis();
        }
        return false;
    }

    private TimeAxisDialog createTimeAxisDialog(String title, boolean modal, JPanel p, boolean bHelpEnabled) {
        TimeAxisDialog d = null;
        Container owner = this;
        while (owner != null) {
            if (owner instanceof Dialog) {
                d = new TimeAxisDialog((Dialog)owner, title, modal, p, bHelpEnabled);
                break;
            }
            if (owner instanceof Frame) {
                d = new TimeAxisDialog((Frame)owner, title, modal, p, bHelpEnabled);
                break;
            }
            owner = SwingUtilities.getWindowAncestor(owner);
        }
        if (owner == null) {
            d = new TimeAxisDialog((Frame)null, title, modal, p, bHelpEnabled);
        }
        return d;
    }

    class TimeAxisDialog
    extends JDialog
    implements ActionListener,
    HelpContext {
        private static final long serialVersionUID = 1L;
        protected JPanel m_panel;
        protected String m_strHelpContextID;
        private boolean m_bHelpEnabled;
        private JButton okButton;
        private JButton cancelButton;
        private JButton helpButton;
        private int[] m_index;
        private int m_initialWidth;
        private int m_initialHeight;
        private final Border _sBorder;
        private final Border _sBorderButtons;

        public TimeAxisDialog(Frame parentFrame, String title, boolean modal, JPanel p, boolean bHelpEnabled) {
            super(parentFrame);
            this.m_bHelpEnabled = true;
            this.m_index = new int[4];
            this._sBorder = new EmptyBorder(6, 6, 8, 5);
            this._sBorderButtons = new EmptyBorder(8, 10, 0, 10);
            this._initDialog(title, modal, p, bHelpEnabled);
        }

        public TimeAxisDialog(Dialog parentFrame, String title, boolean modal, JPanel p, boolean bHelpEnabled) {
            super(parentFrame);
            this.m_bHelpEnabled = true;
            this.m_index = new int[4];
            this._sBorder = new EmptyBorder(6, 6, 8, 5);
            this._sBorderButtons = new EmptyBorder(8, 10, 0, 10);
            this._initDialog(title, modal, p, bHelpEnabled);
        }

        private void _initDialog(String title, boolean modal, JPanel p, boolean bHelpEnabled) {
            this.m_bHelpEnabled = bHelpEnabled;
            this.setTitle(title);
            this.setModal(modal);
            this.m_panel = p;
            this.m_index[0] = GroupAxis.this.m_timeAxis.m_yearComboBox.getSelectedIndex();
            this.m_index[1] = GroupAxis.this.m_timeAxis.m_monthComboBox.getSelectedIndex();
            this.m_index[2] = GroupAxis.this.m_timeAxis.m_dayComboBox.getSelectedIndex();
            this.m_index[3] = GroupAxis.this.m_timeAxis.m_timeComboBox.getSelectedIndex();
            this.init();
            this.pack();
            Dimension screenSize = this.getToolkit().getScreenSize();
            Dimension frameSize = this.getSize();
            if (frameSize.height > screenSize.height) {
                frameSize.height = screenSize.height;
            }
            if (frameSize.width > screenSize.width) {
                frameSize.width = screenSize.width;
            }
            this.m_initialWidth = this.getWidth();
            this.m_initialHeight = this.getHeight();
            this.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent we) {
                    TimeAxisDialog.this.resetValues();
                }
            });
            p = null;
        }

        public String getHelpContextID() {
            return this.getClass().getName();
        }

        public void setHelpContextID(String strHelpContextID) {
            this.m_strHelpContextID = strHelpContextID;
        }

        public void setHelpEnabled(boolean bValue) {
            this.m_bHelpEnabled = bValue;
        }

        public boolean isHelpEnabled() {
            return this.m_bHelpEnabled;
        }

        private void init() {
            this.m_initialWidth = -1;
            this.m_initialHeight = -1;
            JComponent content = (JComponent)this.getContentPane();
            content.setLayout(new BoxLayout(content, 1));
            content.setBorder(this._sBorder);
            if (UIManager.getLookAndFeel() instanceof BrowserLookAndFeel) {
                content.setBackground(UIManager.getColor("MenuBar.background"));
            } else if (UIManager.getLookAndFeel() instanceof OracleLookAndFeel) {
                content.setBackground(UIManager.getColor(ColorScheme.DARK_LOOK));
            }
            GrayPane gp = new GrayPane((Component)this.m_panel);
            content.add((Component)gp);
            DialogButtonBar buttonPanel = new DialogButtonBar();
            buttonPanel.setBorder(this._sBorderButtons);
            if (this.m_bHelpEnabled) {
                String translatedText = GroupAxis.this.rBundle.getString("Help");
                this.helpButton = new JButton(StringUtils.stripMnemonic((String)translatedText));
                this.helpButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
                buttonPanel.add((Component)this.helpButton, DialogButtonBar.CONSTRAINT_HELP);
                this.helpButton.addActionListener(this);
                this.helpButton.registerKeyboardAction(this, KeyStroke.getKeyStroke(112, 0), 2);
            }
            JPanel buttonPanel_east = new JPanel();
            this.okButton = new JButton(GroupAxis.this.rBundle.getString("OK"));
            buttonPanel.add((Component)this.okButton, DialogButtonBar.CONSTRAINT_YES);
            this.okButton.addActionListener(this);
            this.getRootPane().setDefaultButton(this.okButton);
            this.cancelButton = new JButton(GroupAxis.this.rBundle.getString("Cancel"));
            buttonPanel.add((Component)this.cancelButton, DialogButtonBar.CONSTRAINT_CANCEL);
            this.cancelButton.addActionListener(this);
            this.cancelButton.registerKeyboardAction(this, KeyStroke.getKeyStroke(27, 0), 2);
            this.getContentPane().add((Component)buttonPanel);
            this.setResizable(true);
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    int originalHeight;
                    int originalWidth;
                    int width = originalWidth = TimeAxisDialog.this.getWidth();
                    int height = originalHeight = TimeAxisDialog.this.getHeight();
                    if (TimeAxisDialog.this.m_initialWidth != -1) {
                        width = Math.max(TimeAxisDialog.this.m_initialWidth, width);
                    }
                    if (TimeAxisDialog.this.m_initialHeight != -1) {
                        height = Math.max(TimeAxisDialog.this.m_initialHeight, height);
                    }
                    if (originalWidth != width || originalHeight != height) {
                        TimeAxisDialog.this.setSize(width, height);
                    }
                    TimeAxisDialog.this.validate();
                }
            });
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.cancelButton) {
                this.setVisible(false);
                this.resetValues();
            } else if (e.getSource() == this.okButton) {
                this.setVisible(false);
            } else if (e.getSource() == this.helpButton) {
                try {
                    if (GroupAxis.this.getHelpProvider() != null) {
                        GroupAxis.this.getHelpProvider().showHelp((Component)this);
                    } else if (HelpUtils.getDefaultHelpProvider() != null) {
                        HelpUtils.getDefaultHelpProvider().showHelp((Component)this);
                    }
                }
                catch (HelpUnavailableException helpUnavailableException) {
                    // empty catch block
                }
            }
        }

        public void resetValues() {
            GroupAxis.this.m_timeAxis.m_yearComboBox.setSelectedIndex(this.m_index[0]);
            GroupAxis.this.m_timeAxis.m_monthComboBox.setSelectedIndex(this.m_index[1]);
            GroupAxis.this.m_timeAxis.m_dayComboBox.setSelectedIndex(this.m_index[2]);
            GroupAxis.this.m_timeAxis.m_timeComboBox.setSelectedIndex(this.m_index[3]);
        }
    }
}

