/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.gui;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.olaf.OracleLookAndFeel;
import oracle.dss.dataView.ControllerEvent;
import oracle.dss.dataView.UIView;
import oracle.dss.dataView.gui.DataviewTool;
import oracle.dss.dataView.gui.DataviewToolbarRollover;
import oracle.dss.dataView.gui.ToolBar;
import oracle.dss.graph.Graph;

public class GridLineTool
extends JToggleButton
implements DataviewToolbarRollover,
DataviewTool,
ActionListener {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_GRIDLINE_VISIBLE = "GridLineVisible";
    protected Object m_currentDataView = null;
    protected boolean m_bRolloverIconEnabled = false;
    private static final Insets insets0 = new Insets(0, 0, 0, 0);
    private ResourceBundle rBundle = null;
    protected boolean m_enable = true;
    private MouseListener m_mouseListener;
    private static final int HORIZ_VERT_BOTH = 0;
    private static final int HORIZ_ONLY = 1;
    private static final int VERT_ONLY = 2;
    private int gridlineState = 0;

    public GridLineTool() {
        this.setEnabled(false);
        this.setIcon(this.makeImage("images/s_grid_18t.gif"));
        this.setDisabledIcon(new ImageIcon(ImageUtils.createDisabledImage((Image)((ImageIcon)this.getIcon()).getImage())));
        this.addActionListener(this);
        this.setBorderPainted(false);
        this.updateResourceBundle(Locale.getDefault());
        this.setToolTipText(this.rBundle.getString("ShowGridLine"));
        if (!(UIManager.getLookAndFeel() instanceof OracleLookAndFeel)) {
            this.setPreferredSize(new Dimension(24, 24));
            this.setMinimumSize(this.getPreferredSize());
            this.setMaximumSize(this.getPreferredSize());
            this.m_mouseListener = new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    if (!GridLineTool.this.isRolloverIconEnabled()) {
                        GridLineTool.this.setBorderPainted(true);
                    }
                    if (!GridLineTool.this.isEnabled()) {
                        GridLineTool.this.setBorderPainted(GridLineTool.this.isSelected());
                    }
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    if (!GridLineTool.this.isRolloverIconEnabled()) {
                        GridLineTool.this.setBorderPainted(GridLineTool.this.isSelected());
                    }
                }
            };
            this.addMouseListener(this.m_mouseListener);
        }
    }

    @Override
    public void setLocale(Locale loc) {
        super.setLocale(loc);
        this.updateResourceBundle(loc);
        this.setToolTipText(this.rBundle.getString("ShowGridLine"));
    }

    @Override
    public void selectedAction(ControllerEvent e, UIView currentDataView, ToolBar toolBar) {
        this.m_enable = false;
        if (currentDataView instanceof Graph) {
            boolean b2;
            this.m_currentDataView = currentDataView;
            int m_currentType = ((Graph)currentDataView).getGraphType();
            boolean bl = b2 = ((Graph)currentDataView).getY1MajorTick().isVisible() || ((Graph)currentDataView).getY2MajorTick().isVisible();
            if (!this._isO1AxisSupported()) {
                boolean b1 = ((Graph)currentDataView).getX1MajorTick().isVisible();
                this.setSelected(b1 || b2);
            } else {
                this.setSelected(b2);
            }
            this.setBorderPainted(this.isSelected());
            this.setEnabled(this._isGridLineSupport(currentDataView));
        } else {
            this.m_currentDataView = null;
        }
        this.m_enable = true;
    }

    private boolean _isGridLineSupport(UIView currentDataView) {
        if (!(currentDataView instanceof Graph)) {
            return false;
        }
        Graph graph = (Graph)currentDataView;
        switch (graph.getGraphType()) {
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 35: 
            case 40: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 93: 
            case 94: {
                return false;
            }
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e == null || !this.m_enable) {
            return;
        }
        if (e.getSource() == this) {
            if (!(this._isO1AxisSupported() || this.gridlineState != 2 && this.gridlineState != 0)) {
                ((Graph)this.m_currentDataView).getX1MajorTick().setVisible(this.isSelected());
            }
            if (this.gridlineState == 1 || this.gridlineState == 0) {
                ((Graph)this.m_currentDataView).getY1MajorTick().setVisible(this.isSelected());
                ((Graph)this.m_currentDataView).getY2MajorTick().setVisible(this.isSelected());
            }
            this.setBorderPainted(this.isSelected());
            this.firePropertyChange(PROPERTY_GRIDLINE_VISIBLE, !this.isSelected(), this.isSelected());
        }
    }

    @Override
    public void update() {
        boolean b2;
        if (this.m_currentDataView == null) {
            return;
        }
        int graphType = ((Graph)this.m_currentDataView).getGraphType();
        if (graphType >= 55 && graphType <= 60 || graphType == 93 || graphType == 94 || graphType >= 0 && graphType <= 14 || graphType == 35 || graphType == 40) {
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
        }
        boolean b1 = false;
        boolean bl = b2 = ((Graph)this.m_currentDataView).getY1MajorTick().isVisible() || ((Graph)this.m_currentDataView).getY2MajorTick().isVisible();
        if (!this._isO1AxisSupported()) {
            b1 = ((Graph)this.m_currentDataView).getX1MajorTick().isVisible();
            this.setSelected(b1 || b2);
        } else {
            this.setSelected(b2);
        }
        this.gridlineState = !this._isO1AxisSupported() ? (this.isSelected() == b1 && this.isSelected() == b2 ? 0 : (this.isSelected() == b1 ? 2 : 1)) : 1;
    }

    private ImageIcon makeImage(String fileName) {
        return new ImageIcon(ImageUtils.getImageResource(GridLineTool.class, (String)fileName));
    }

    private void updateResourceBundle(Locale loc) {
        this.rBundle = loc != null ? ResourceBundle.getBundle("oracle.dss.graph.gui.resource.GraphGUIBundle", loc) : ResourceBundle.getBundle("oracle.dss.graph.gui.resource.GraphGUIBundle");
    }

    private boolean _isO1AxisSupported() {
        int graphType = ((Graph)this.m_currentDataView).getGraphType();
        return !(graphType >= 55 && graphType <= 66 || graphType >= 85 && graphType <= 87) && (graphType < 89 || graphType > 94);
    }

    @Override
    public void cleanUp() {
        this.removeMouseListener(this.m_mouseListener);
        this.removeActionListener(this);
    }

    @Override
    public void setRolloverIconEnabled(boolean bEnabled) {
        this.m_bRolloverIconEnabled = bEnabled;
        if (bEnabled) {
            this.setIcon(this.makeImage("images/s_grid.gif"));
            this.setRolloverIcon(this.makeImage("images/l_grid.gif"));
            this.setRolloverSelectedIcon(this.makeImage("images/l_grid.gif"));
        } else {
            this.setIcon(this.makeImage("images/s_grid_18t.gif"));
            this.setRolloverIcon(null);
            this.setRolloverSelectedIcon(null);
        }
        this.setDisabledIcon(new ImageIcon(ImageUtils.createDisabledImage((Image)((ImageIcon)this.getIcon()).getImage())));
    }

    @Override
    public boolean isRolloverIconEnabled() {
        return this.m_bRolloverIconEnabled;
    }
}

