/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.gui;

import java.awt.event.ActionEvent;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JCheckBox;
import javax.swing.event.ListSelectionEvent;
import oracle.bali.share.nls.StringUtils;
import oracle.dss.dataView.gui.NumberFormatPanel;
import oracle.dss.dataView.managers.ViewFormat;

public class GraphNumberFormatPanel
extends NumberFormatPanel {
    private static final long serialVersionUID = 1L;
    protected boolean m_init;
    protected JCheckBox m_decimalCheckBox;
    protected ResourceBundle rGraphBundle = null;

    public GraphNumberFormatPanel(ViewFormat viewFormat) {
        super(viewFormat);
    }

    @Override
    public void setFormatType(int formatType) {
        switch (formatType) {
            case 2: {
                this.m_typeList.setSelectedIndex(0);
                break;
            }
            case 3: {
                this.m_typeList.setSelectedIndex(1);
                break;
            }
            case 4: {
                this.m_typeList.setSelectedIndex(2);
                break;
            }
            case 5: {
                this.m_typeList.setSelectedIndex(3);
                break;
            }
            default: {
                this.m_typeList.setSelectedIndex(0);
            }
        }
    }

    @Override
    protected void initialize(ViewFormat viewFormat) {
        super.initialize(viewFormat);
        this.m_decimalCheckBox = new JCheckBox(this.rGraphBundle.getString("Automatic"));
        this.m_decimalPanel.add(this.m_decimalCheckBox);
        this.typeList.remove(0);
        this.typeList.remove(0);
        this.typeList.remove(0);
        this.m_scaleVector.insertElementAt(this.rGraphBundle.getString("None"), 0);
        this.m_decimalCheckBox.addActionListener(this);
        this.graphInit(viewFormat);
    }

    @Override
    public int getFormatType() {
        switch (this.m_typeList.getSelectedIndex()) {
            case 1: {
                return 3;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 5;
            }
            case 0: {
                return 2;
            }
        }
        return 2;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getSource() == this.m_typeList) {
            this.processCategory(this.m_typeList.getSelectionModel().getLeadSelectionIndex() + 3);
        } else {
            super.valueChanged(e);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.m_decimalCheckBox) {
            this.m_decimalSpinBox.setEnabled(!this.m_decimalCheckBox.isSelected());
            this.m_decimalLabel.setEnabled(!this.m_decimalCheckBox.isSelected());
        } else if (e.getSource() == this.m_defaultScaleMarkCheckBox) {
            if (this.m_sentPropertyChangeEvent) {
                this.firePropertyChange("ScaleSign", !this.m_defaultScaleMarkCheckBox.isSelected(), this.m_defaultScaleMarkCheckBox.isSelected());
            }
        } else if (e.getSource() == this.m_scaleComboBox) {
            String string = this.getScaleMarkString(this.m_scaleComboBox.getSelectedIndex());
            this.m_defaultScaleMarkCheckBox.setText(StringUtils.stripMnemonic((String)string));
            this.m_defaultScaleMarkCheckBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
            if (!this.m_init) {
                this.m_defaultScaleMarkCheckBox.setEnabled(this.m_scaleComboBox.getSelectedIndex() != 0);
                if (this.m_scaleComboBox.getSelectedIndex() != 0) {
                    this.m_defaultScaleMarkCheckBox.setSelected(true);
                }
                this.m_scaleCheckBox.setSelected(true);
            }
            if (this.m_sentPropertyChangeEvent) {
                this.firePropertyChange("ScaleFactor", -1, this.m_scaleComboBox.getSelectedIndex());
            }
        } else if (e.getSource() == this.m_scaleCheckBox) {
            if (!this.m_init) {
                if (this.m_scaleComboBox.getSelectedIndex() == 0) {
                    this.m_defaultScaleMarkCheckBox.setSelected(!this.m_scaleCheckBox.isSelected());
                }
                this.m_defaultScaleMarkCheckBox.setEnabled(this.m_scaleComboBox.getSelectedIndex() != 0);
            }
            if (this.m_sentPropertyChangeEvent) {
                this.firePropertyChange("Scale", !this.m_scaleCheckBox.isSelected(), this.m_scaleCheckBox.isSelected());
            }
        } else {
            super.actionPerformed(e);
        }
    }

    @Override
    protected String getScaleMarkString(int index) {
        if (index == 0) {
            return "Scale automatically";
        }
        return super.getScaleMarkString(index);
    }

    @Override
    protected void updateResourceBundle(Locale loc) {
        super.updateResourceBundle(loc);
        this.rGraphBundle = loc != null ? ResourceBundle.getBundle("oracle.dss.graph.gui.resource.GraphGUIBundle", loc) : ResourceBundle.getBundle("oracle.dss.graph.gui.resource.GraphGUIBundle");
    }

    @Override
    protected ViewFormat createViewFormat() {
        ViewFormat viewFormat = super.createViewFormat();
        if (this.m_scaleComboBox.getSelectedIndex() == 0 && this.m_decimalCheckBox.isSelected()) {
            viewFormat.setDecimalDigitUsed(false);
        }
        return viewFormat;
    }

    @Override
    public void setScaleFactor(int factor) {
        this.m_scaleComboBox.setSelectedIndex(factor - 1);
    }

    @Override
    protected void setScaleFactor(ViewFormat viewFormat, int index) {
        super.setScaleFactor(viewFormat, index);
    }

    @Override
    protected void setDecimalDigit(ViewFormat viewFormat) {
        if (viewFormat == null) {
            return;
        }
        if (this.m_decimalCheckBox.isSelected()) {
            viewFormat.setDecimalDigitUsed(false);
        } else if (viewFormat.getDecimalDigit() != this.m_decimalSpinBox.getIntValue()) {
            viewFormat.setDecimalDigit(this.m_decimalSpinBox.getIntValue());
        }
    }

    protected void graphInit(ViewFormat viewFormat) {
        this.m_init = true;
        if (!viewFormat.isScaleFactorUsed()) {
            this.m_defaultScaleMarkCheckBox.setEnabled(false);
            this.m_scaleComboBox.setEnabled(true);
            this.m_scaleCheckBox.setSelected(false);
            this.m_defaultScaleMarkCheckBox.setSelected(true);
            this.m_scaleComboBox.setSelectedIndex(0);
        } else {
            this.m_scaleCheckBox.setSelected(true);
            this.m_scaleComboBox.setSelectedIndex(viewFormat.getScaleFactor());
        }
        if (!viewFormat.isDecimalDigitUsed()) {
            this.m_decimalCheckBox.setSelected(true);
            this.m_decimalSpinBox.setEnabled(false);
            this.m_decimalLabel.setEnabled(false);
        } else {
            this.m_decimalCheckBox.setSelected(false);
            this.m_decimalSpinBox.setEnabled(true);
            this.m_decimalLabel.setEnabled(true);
        }
        if (this.m_scaleComboBox.getSelectedIndex() == 0) {
            this.m_defaultScaleMarkCheckBox.setEnabled(false);
        }
        this.m_init = false;
    }
}

