/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import oracle.bali.ewt.button.DialogButtonBar;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.help.HelpProvider;
import oracle.bali.ewt.help.HelpUnavailableException;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.ewt.olaf.ColorScheme;
import oracle.bali.ewt.olaf.OracleLookAndFeel;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.share.nls.StringUtils;
import oracle.dss.dataView.gui.BaseConditionalFormatPanel;
import oracle.dss.graph.Graph;
import oracle.dss.graph.managers.GraphRuleStyles;
import oracle.dss.graph.managers.GraphStyle;
import oracle.dss.rules.DiscriminatorRule;
import oracle.dss.rules.Mergeable;
import oracle.dss.rules.Rule;
import oracle.dss.rules.RuleBundle;
import oracle.dss.rules.discriminator.CompositeDiscriminator;
import oracle.dss.rules.discriminator.Discriminator;
import oracle.dss.util.gui.BIColorChoice;
import oracle.dss.util.help.HelpContext;

public class GraphConditionalFormatPanel
extends BaseConditionalFormatPanel {
    private static final long serialVersionUID = 1L;
    protected GraphStyle m_style = null;
    protected Graph m_graph = null;
    protected BIColorChoice m_markerColor;
    protected JComboBox m_marker;
    protected ImageIcon[] m_icons;
    private final Border _sBorder = new EmptyBorder(6, 6, 8, 5);

    public GraphConditionalFormatPanel(Graph graph) {
        this(graph, null, null);
    }

    public GraphConditionalFormatPanel(Graph graph, Discriminator disc, GraphStyle style) {
        super(graph);
        this.m_graph = (Graph)this.m_view;
        if (style != null && disc != null) {
            this.initFromDisc(disc, null);
            this.m_style = style;
        } else {
            this.setDefaultConditions();
        }
        this.constructPanel();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        if (e.getSource() == this.m_editFormat) {
            PanelDialog d = this.createPanelDialog("Format Graph", true, new EditPanel(), 1, this.getHelpProvider());
            d.show();
            if (d.isOK()) {
                this.m_style = this.getStyle();
            }
        }
    }

    public void applyFormat() {
        if (this.m_style == null) {
            return;
        }
        Discriminator discriminator = this.getDiscriminator();
        DiscriminatorRule rule = new DiscriminatorRule();
        if (this.m_valueDisc != null) {
            CompositeDiscriminator disc = new CompositeDiscriminator(discriminator, this.m_valueDisc, 0);
            rule.setDiscriminator((Discriminator)disc);
        } else {
            rule.setDiscriminator(discriminator);
        }
        rule.setFixedMergeable((Mergeable)this.m_style);
        RuleBundle rb = new RuleBundle();
        rb.addRule((Rule)rule);
        Vector<RuleBundle> rbVector = new Vector<RuleBundle>();
        rbVector.addElement(rb);
        GraphRuleStyles grs = (GraphRuleStyles)this.m_graph.getGraphModel().getGraphStyleManager();
        Vector bundles = grs.getBundles();
        if (bundles == null) {
            grs.setBundles(this.m_graph, rbVector);
        } else {
            bundles.addElement(rb);
            grs.setBundles(this.m_graph, bundles);
        }
    }

    private ImageIcon _getImageIcon(String imageName) {
        return new ImageIcon(ImageUtils.getImageResource(GraphConditionalFormatPanel.class, (String)imageName));
    }

    public GraphStyle getStyle() {
        GraphStyle style = new GraphStyle();
        style.setFillColor(this.m_markerColor.getSelectedColor());
        if (this.m_marker.getSelectedIndex() > 0) {
            style.setMarkerVisible(true);
        }
        style.setMarkerShape(this.m_marker.getSelectedIndex());
        return style;
    }

    private PanelDialog createPanelDialog(String title, boolean modal, JPanel p, int action, HelpProvider helpProvider) {
        boolean bHelpEnabled = false;
        Container owner = this;
        while (owner != null) {
            if (owner instanceof Dialog) {
                return new PanelDialog((Dialog)owner, title, modal, p, bHelpEnabled, action, helpProvider);
            }
            if (owner instanceof Frame) {
                return new PanelDialog((Frame)owner, title, modal, p, bHelpEnabled, action, helpProvider);
            }
            owner = SwingUtilities.getWindowAncestor(owner);
        }
        if (owner == null) {
            return new PanelDialog((Frame)null, title, modal, p, bHelpEnabled, action, helpProvider);
        }
        return null;
    }

    protected class PanelDialog
    extends JDialog
    implements ActionListener,
    HelpContext {
        private static final long serialVersionUID = 1L;
        private ResourceBundle rBundle;
        protected boolean m_ok;
        private int m_initialWidth;
        private int m_initialHeight;
        private boolean m_bHelpEnabled;
        protected HelpProvider m_helpProvider;
        private String m_strHelpContextID;
        private JButton okButton;
        private JButton cancelButton;
        private JButton helpButton;
        protected JPanel m_panel;
        protected int m_action;
        private final Border _sBorderButtons;

        public PanelDialog(Frame parentFrame, String title, boolean modal, JPanel p, boolean bHelpEnabled, int action, HelpProvider helpProvider) {
            super(parentFrame);
            this.rBundle = null;
            this.m_ok = false;
            this.m_initialWidth = -1;
            this.m_initialHeight = -1;
            this.m_bHelpEnabled = true;
            this._sBorderButtons = new EmptyBorder(8, 10, 0, 10);
            this._initDialog(title, modal, p, bHelpEnabled, action, helpProvider);
        }

        public PanelDialog(Dialog owner, String title, boolean modal, JPanel p, boolean bHelpEnabled, int action, HelpProvider helpProvider) {
            super(owner);
            this.rBundle = null;
            this.m_ok = false;
            this.m_initialWidth = -1;
            this.m_initialHeight = -1;
            this.m_bHelpEnabled = true;
            this._sBorderButtons = new EmptyBorder(8, 10, 0, 10);
            this._initDialog(title, modal, p, bHelpEnabled, action, helpProvider);
        }

        protected void updateResourceBundle(Locale loc) {
            this.rBundle = loc != null ? ResourceBundle.getBundle("oracle.dss.gridView.gui.resource.GridviewGUIBundle", loc) : ResourceBundle.getBundle("oracle.dss.gridView.gui.resource.GridviewGUIBundle");
        }

        private void _initDialog(String title, boolean modal, JPanel p, boolean bHelpEnabled, int action, HelpProvider helpProvider) {
            this.updateResourceBundle(null);
            this.m_bHelpEnabled = bHelpEnabled;
            this.setHelpProvider(helpProvider);
            this.setTitle(title);
            this.setModal(modal);
            this.m_panel = p;
            this.m_action = action;
            this.setHelpEnabled(true);
            this.init();
            this.pack();
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension frameSize = this.getSize();
            if (frameSize.height > screenSize.height) {
                frameSize.height = screenSize.height;
            }
            if (frameSize.width > screenSize.width) {
                frameSize.width = screenSize.width;
            }
            this.setLocation((screenSize.width - frameSize.height) / 2, (screenSize.height - frameSize.width) / 2);
            this.m_initialWidth = this.getWidth();
            this.m_initialHeight = this.getHeight();
        }

        public String getHelpContextID() {
            return "";
        }

        public void cleanUp() {
            this.getContentPane().remove(this.m_panel);
            this.m_panel.removeAll();
            this.m_panel = null;
        }

        public void setHelpContextID(String strHelpContextID) {
            this.m_strHelpContextID = strHelpContextID;
        }

        public void setHelpProvider(HelpProvider helpProvider) {
            this.m_helpProvider = helpProvider;
        }

        public HelpProvider getHelpProvider() {
            return this.m_helpProvider;
        }

        public void setHelpEnabled(boolean bValue) {
            this.m_bHelpEnabled = bValue;
        }

        public boolean isHelpEnabled() {
            return this.m_bHelpEnabled;
        }

        private void init() {
            this.m_initialWidth = -1;
            this.m_initialHeight = -1;
            JComponent content = (JComponent)this.getContentPane();
            content.setLayout(new BoxLayout(content, 1));
            content.setBorder(GraphConditionalFormatPanel.this._sBorder);
            content.add(this.m_panel);
            if (UIManager.getLookAndFeel() instanceof OracleLookAndFeel) {
                content.setBackground(UIManager.getColor(ColorScheme.DARK_LOOK));
            }
            DialogButtonBar buttonPanel = new DialogButtonBar();
            buttonPanel.setBorder(this._sBorderButtons);
            if (this.m_bHelpEnabled) {
                String translatedText = this.rBundle.getString("Help");
                this.helpButton = new JButton(StringUtils.stripMnemonic((String)translatedText));
                this.helpButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
                buttonPanel.add((Component)this.helpButton, DialogButtonBar.CONSTRAINT_HELP);
                this.helpButton.addActionListener(this);
                this.helpButton.registerKeyboardAction(this, KeyStroke.getKeyStroke(112, 0), 2);
            }
            JPanel buttonPanel_east = new JPanel();
            String translatedText = this.rBundle.getString("OK");
            this.okButton = new JButton(StringUtils.stripMnemonic((String)translatedText));
            this.okButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
            buttonPanel.add((Component)this.okButton, DialogButtonBar.CONSTRAINT_YES);
            this.okButton.addActionListener(this);
            this.getRootPane().setDefaultButton(this.okButton);
            translatedText = this.rBundle.getString("Cancel");
            this.cancelButton = new JButton(StringUtils.stripMnemonic((String)translatedText));
            this.cancelButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
            buttonPanel.add((Component)this.cancelButton, DialogButtonBar.CONSTRAINT_CANCEL);
            this.cancelButton.addActionListener(this);
            this.cancelButton.registerKeyboardAction(this, KeyStroke.getKeyStroke(27, 0), 2);
            this.getContentPane().add((Component)buttonPanel);
            this.setResizable(true);
            this.m_panel.setAlignmentX(0.0f);
            buttonPanel.setAlignmentX(0.0f);
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    int originalHeight;
                    int originalWidth;
                    int width = originalWidth = PanelDialog.this.getWidth();
                    int height = originalHeight = PanelDialog.this.getHeight();
                    if (PanelDialog.this.m_initialWidth != -1) {
                        width = Math.max(PanelDialog.this.m_initialWidth, width);
                    }
                    if (PanelDialog.this.m_initialHeight != -1) {
                        height = Math.max(PanelDialog.this.m_initialHeight, height);
                    }
                    if (originalWidth != width || originalHeight != height) {
                        PanelDialog.this.setSize(width, height);
                    }
                    PanelDialog.this.validate();
                }
            });
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.cancelButton) {
                this.setVisible(false);
                this.dispose();
                this.getParent().repaint();
                this.m_ok = false;
            } else if (e.getSource() == this.okButton) {
                boolean ret = true;
                if (ret) {
                    this.m_ok = true;
                    this.setVisible(false);
                    this.dispose();
                } else {
                    this.m_ok = false;
                }
            } else if (e.getSource() == this.helpButton) {
                try {
                    if (this.getHelpProvider() != null) {
                        this.getHelpProvider().showHelp((Component)this);
                    } else if (HelpUtils.getDefaultHelpProvider() != null) {
                        HelpUtils.getDefaultHelpProvider().showHelp((Component)this);
                    }
                }
                catch (HelpUnavailableException helpUnavailableException) {
                    // empty catch block
                }
            }
        }

        public boolean isOK() {
            return this.m_ok;
        }
    }

    class MarkerShapeRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final long serialVersionUID = 1L;
        Border unselectedBorder = null;
        Border selectedBorder = null;
        boolean isBordered = true;

        public MarkerShapeRenderer(boolean isBordered) {
            this.isBordered = isBordered;
            this.setBackground(Color.white);
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (this.isBordered) {
                if (isSelected) {
                    if (this.selectedBorder == null) {
                        this.selectedBorder = BorderFactory.createMatteBorder(2, 2, 2, 2, Color.black);
                    }
                    this.setBorder(this.selectedBorder);
                } else {
                    if (this.unselectedBorder == null) {
                        this.unselectedBorder = BorderFactory.createMatteBorder(2, 2, 2, 2, list.getBackground());
                    }
                    this.setBorder(this.unselectedBorder);
                }
            }
            if (value == null || value == "") {
                this.setText("");
                this.setIcon(null);
                this.setBackground(Color.white);
                return this;
            }
            int shape = new Integer(value.toString());
            if (shape == 0) {
                this.setText(GraphConditionalFormatPanel.this.rBundle.getString("None"));
                this.setIcon(null);
            } else {
                this.setText("");
                this.setIcon(GraphConditionalFormatPanel.this.m_icons[shape - 1]);
            }
            return this;
        }
    }

    protected class EditPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;

        public EditPanel() {
            this.setLayout(new BoxLayout(this, 1));
            JPanel main_panel = new JPanel();
            main_panel.setBorder(GraphConditionalFormatPanel.this._sBorder);
            main_panel.setLayout(new BoxLayout(main_panel, 1));
            MultiLineLabel description = new MultiLineLabel("Specify graph formatting for data meeting the condition.");
            description.setTextWrapper(WordWrapper.getTextWrapper());
            JPanel colorPanel = new JPanel();
            colorPanel.setLayout(new BoxLayout(colorPanel, 0));
            JLabel label = new JLabel("Color");
            GraphConditionalFormatPanel.this.m_markerColor = new BIColorChoice();
            colorPanel.add(label);
            colorPanel.add(Box.createRigidArea(new Dimension(10, 0)));
            colorPanel.add((Component)GraphConditionalFormatPanel.this.m_markerColor);
            JPanel shapePanel = new JPanel();
            shapePanel.setLayout(new BoxLayout(shapePanel, 0));
            JLabel slabel = new JLabel("Shape");
            Integer[] array = new Integer[7];
            for (int i = 0; i < 7; ++i) {
                array[i] = new Integer(i);
            }
            GraphConditionalFormatPanel.this.m_marker = new JComboBox<Integer>(array);
            GraphConditionalFormatPanel.this.m_icons = new ImageIcon[]{GraphConditionalFormatPanel.this._getImageIcon("images/Square.gif"), GraphConditionalFormatPanel.this._getImageIcon("images/Circle.gif"), GraphConditionalFormatPanel.this._getImageIcon("images/Diamond.gif"), GraphConditionalFormatPanel.this._getImageIcon("images/Plus.gif"), GraphConditionalFormatPanel.this._getImageIcon("images/TriangleDown.gif"), GraphConditionalFormatPanel.this._getImageIcon("images/TriangleUp.gif")};
            MarkerShapeRenderer renderer = new MarkerShapeRenderer(true);
            GraphConditionalFormatPanel.this.m_marker.setRenderer(renderer);
            int length = this.getToolkit().getFontMetrics(GraphConditionalFormatPanel.this.m_marker.getFont()).stringWidth(GraphConditionalFormatPanel.this.rBundle.getString("None"));
            GraphConditionalFormatPanel.this.m_marker.setPreferredSize(new Dimension(length + 30, GraphConditionalFormatPanel.this.m_marker.getPreferredSize().height));
            GraphConditionalFormatPanel.this.m_marker.setMinimumSize(GraphConditionalFormatPanel.this.m_marker.getPreferredSize());
            GraphConditionalFormatPanel.this.m_marker.setMaximumSize(GraphConditionalFormatPanel.this.m_marker.getPreferredSize());
            shapePanel.add(slabel);
            shapePanel.add(Box.createRigidArea(new Dimension(10, 0)));
            shapePanel.add(GraphConditionalFormatPanel.this.m_marker);
            main_panel.add((Component)description);
            main_panel.add(colorPanel);
            main_panel.add(Box.createRigidArea(new Dimension(0, 5)));
            main_panel.add(shapePanel);
            description.setAlignmentX(0.0f);
            colorPanel.setAlignmentX(0.0f);
            shapePanel.setAlignmentX(0.0f);
            this.add(main_panel);
            this.add(Box.createVerticalGlue());
            if (GraphConditionalFormatPanel.this.m_style != null) {
                GraphConditionalFormatPanel.this.m_markerColor.setSelectedColor(GraphConditionalFormatPanel.this.m_style.getFillColor());
                if (!GraphConditionalFormatPanel.this.m_style.isMarkerVisible()) {
                    GraphConditionalFormatPanel.this.m_marker.setSelectedIndex(0);
                } else {
                    GraphConditionalFormatPanel.this.m_marker.setSelectedIndex(GraphConditionalFormatPanel.this.m_style.getMarkerShape());
                }
            }
        }
    }
}

