/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.gui;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.olaf.OracleLookAndFeel;
import oracle.dss.dataView.ControllerEvent;
import oracle.dss.dataView.UIView;
import oracle.dss.dataView.gui.DataviewTool;
import oracle.dss.dataView.gui.DataviewToolbarRollover;
import oracle.dss.dataView.gui.ToolBar;
import oracle.dss.graph.Graph;
import oracle.dss.graph.GraphUtils;
import oracle.dss.graph.gui.LegendTool;

public class GradientTool
extends JToggleButton
implements DataviewToolbarRollover,
DataviewTool,
ActionListener {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_GRADIENT_EFFECT = "GradientEffect";
    protected Object m_currentDataView = null;
    private static final Insets insets0 = new Insets(0, 0, 0, 0);
    private ResourceBundle rBundle = null;
    private boolean m_enable = true;
    private MouseListener m_mouseListener;
    protected boolean m_bRolloverIconEnabled = false;

    public GradientTool() {
        this.setMargin(insets0);
        this.setEnabled(false);
        this.setIcon(this.makeImage("images/s_gradient_18t.gif"));
        this.setDisabledIcon(new ImageIcon(ImageUtils.createDisabledImage((Image)((ImageIcon)this.getIcon()).getImage())));
        this.addActionListener(this);
        this.setBorderPainted(false);
        this.updateResourceBundle(Locale.getDefault());
        this.setToolTipText(this.rBundle.getString("ShowGradient"));
        if (!(UIManager.getLookAndFeel() instanceof OracleLookAndFeel)) {
            this.setPreferredSize(new Dimension(24, 24));
            this.setMinimumSize(this.getPreferredSize());
            this.setMaximumSize(this.getPreferredSize());
            this.m_mouseListener = new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    if (!GradientTool.this.isRolloverIconEnabled()) {
                        GradientTool.this.setBorderPainted(true);
                    }
                    if (!GradientTool.this.isEnabled()) {
                        GradientTool.this.setBorderPainted(GradientTool.this.isSelected());
                    }
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    if (!GradientTool.this.isRolloverIconEnabled()) {
                        GradientTool.this.setBorderPainted(GradientTool.this.isSelected());
                    }
                }
            };
            this.addMouseListener(this.m_mouseListener);
        }
    }

    @Override
    public void setLocale(Locale loc) {
        super.setLocale(loc);
        this.updateResourceBundle(loc);
        this.setToolTipText(this.rBundle.getString("ShowGradient"));
    }

    @Override
    public void selectedAction(ControllerEvent e, UIView currentDataView, ToolBar toolBar) {
        this.m_enable = false;
        if (currentDataView instanceof Graph) {
            this.setEnabled(!GraphUtils.isGradientDisabled((Graph)currentDataView));
            if (((Graph)currentDataView).getSeriesEffect() == 0 || !this.isEnabled()) {
                this.setSelected(false);
            } else {
                this.setSelected(true);
            }
            this.setBorderPainted(this.isSelected());
            this.m_currentDataView = currentDataView;
        } else {
            this.m_currentDataView = null;
            this.setEnabled(false);
        }
        this.m_enable = true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e == null || !this.m_enable) {
            return;
        }
        if (e.getSource() == this) {
            if (this.isSelected()) {
                ((Graph)this.m_currentDataView).setSeriesEffect(2);
            } else {
                ((Graph)this.m_currentDataView).setSeriesEffect(0);
            }
            this.setBorderPainted(this.isSelected());
            this.firePropertyChange(PROPERTY_GRADIENT_EFFECT, !this.isSelected(), this.isSelected());
        }
    }

    @Override
    public void update() {
        if (this.m_currentDataView == null) {
            return;
        }
    }

    private ImageIcon makeImage(String fileName) {
        return new ImageIcon(ImageUtils.getImageResource(LegendTool.class, (String)fileName));
    }

    private void updateResourceBundle(Locale loc) {
        this.rBundle = loc != null ? ResourceBundle.getBundle("oracle.dss.graph.gui.resource.GraphGUIBundle", loc) : ResourceBundle.getBundle("oracle.dss.graph.gui.resource.GraphGUIBundle");
    }

    @Override
    public void cleanUp() {
        this.removeMouseListener(this.m_mouseListener);
        this.removeActionListener(this);
    }

    @Override
    public void setRolloverIconEnabled(boolean bEnabled) {
        this.m_bRolloverIconEnabled = bEnabled;
    }

    @Override
    public boolean isRolloverIconEnabled() {
        return this.m_bRolloverIconEnabled;
    }
}

