/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.MessageFormat;
import java.util.AbstractMap;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import oracle.dss.dataView.AttributeFormatUtils;
import oracle.dss.dataView.DataviewUtils;
import oracle.dss.dataView.managers.ViewFormat;
import oracle.dss.graph.CommonGraph;
import oracle.dss.graph.CustomToolTipCallback;
import oracle.dss.graph.DataCallback;
import oracle.dss.graph.GraphFormatManager;
import oracle.dss.graph.GraphNumberFormatCallback;
import oracle.dss.graph.PFJ;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.TDGMouseState;
import oracle.dss.graph.pfj.VC;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.graph.pfj.draw.TextStyleObj;
import oracle.dss.graph.pfj.draw.ToolTips;
import oracle.dss.util.DataAccess;
import oracle.dss.util.DataComponentInfo;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.LayerOutOfRangeException;
import oracle.dss.util.QDR;
import oracle.dss.util.SeriesOutOfRangeException;

public class ToolTipTextCallback {
    static final String OBJ_NAME = "[ON]";
    static final String OBJ_DESC = "[OD]";
    static final String OBJ_ID = "[OID]";
    static final String OBJ_INST = "[OIN]";
    static final String SERIES_LBL = "[SL]";
    static final String GROUP_LBL = "[GL]";
    protected boolean m_GraphIsOpenAndClose = false;
    protected boolean m_AxisLabelTipDisplayed = true;
    protected boolean m_GraphIsPieBar = false;
    protected boolean m_GraphIsSingleY = false;
    protected boolean m_GraphIsStacked = false;
    protected boolean m_MarkerTipDisplayed = true;
    protected boolean m_SeriesAreRows = true;
    protected boolean m_ShowColDimName = false;
    protected boolean m_ShowRowDimName = false;
    protected boolean m_ShowGroupLabels = true;
    protected boolean m_ShowSeriesLabels = true;
    protected boolean m_CumValTip = false;
    protected boolean m_PercentTip = false;
    protected boolean m_TextTip = true;
    protected boolean m_ValueTip = true;
    protected int m_ObjectID;
    protected int m_GroupID;
    protected int m_SeriesID;
    protected int m_ColID;
    protected int m_RowID;
    protected int m_MarkerTipType = 9;
    protected int m_TipGroupLabelType = 1;
    protected int m_TipSeriesLabelType = 1;
    protected int m_ValuesPerGroup = 0;
    protected int m_DataValuesPerMarker = 0;
    private String m_txtCl;
    private String m_txtHi;
    private String m_txtLo;
    private String m_txtOp;
    private String m_txtVo;
    private String m_txtX;
    private String m_txtY;
    private String m_txtZ;
    private String m_txtGr;
    private String m_txtSe;
    private String m_txtCu;
    private String m_txtPe;
    private String m_txtVa;
    private String m_txtBV;
    private String m_txtStart;
    private String m_txtEnd;
    private String m_txtTarget;
    private String m_txtActual;
    private String m_txtCuVa;
    private String m_txtCuPe;
    protected String m_DimNameType = "dimShortName";
    protected String m_DimMemberNameType = "shortName";
    protected boolean m_excelOrDeskTop = false;
    protected CommonGraph m_commonGraph = null;
    protected DataAccess m_dataAccess = null;
    protected GraphFormatManager m_fmtMgr = null;
    protected GraphNumberFormatCallback m_numFormatCallback = null;
    protected CustomToolTipCallback m_customToolTipCallback = null;
    protected String m_markerTooltipTemplate = null;
    protected ResourceBundle rBundle = null;
    protected String m_measureDim = "";
    private AbstractMap.SimpleEntry m_ampmCache = new AbstractMap.SimpleEntry<Object, Object>(null, null);
    private HashMap m_formatStrCache = new HashMap();
    private static final String m_method_getFormattedValue = "public String getFormattedValue(double dVal, int axis, boolean isPercent, boolean isPieSlice)";

    public ToolTipTextCallback(CommonGraph graph, GraphNumberFormatCallback numFormatCallback) {
        this.m_commonGraph = graph;
        this.m_numFormatCallback = numFormatCallback;
        this.m_fmtMgr = this.m_commonGraph.getGraphFormatManager();
        this.m_SeriesAreRows = this.m_commonGraph.isDataRowShownAsASeries();
        this.setGraphType(graph.getGraphType());
        this.updateResourceBundle();
        this.updateAllResource(true);
    }

    public void getDataAccess() {
        this.m_dataAccess = this.m_commonGraph.getDataAccess();
    }

    protected void addSliceLabelInfoToTooltip() {
        if (this.m_commonGraph.getSliceLabel().isVisible()) {
            int textType = this.m_commonGraph.getSliceLabel().getTextType();
            boolean sliceLabelText = textType == 2 || textType == 3;
            boolean sliceLabelPercent = textType == 1 || textType == 3;
            boolean sliceLabelValue = textType == 0;
            this.m_TextTip = this.m_TextTip || sliceLabelText;
            this.m_ValueTip = this.m_ValueTip || sliceLabelValue;
            this.m_PercentTip = this.m_PercentTip || sliceLabelPercent;
            this.m_MarkerTipDisplayed = this.m_MarkerTipDisplayed || this.m_TextTip || this.m_ValueTip || this.m_PercentTip;
        }
    }

    /*
     * Unable to fully structure code
     */
    public String getDynamicToolTip(TDGMouseState aMouseState, boolean UserOrDeveloper) {
        tooltipBuilder = DataviewUtils.getSharedStringBuilder();
        this.m_ObjectID = aMouseState.getElementObjectID();
        this.m_SeriesID = aMouseState.getElementSeriesID();
        this.m_GroupID = aMouseState.getElementGroupID();
        this.m_excelOrDeskTop = this.m_commonGraph.isExcelOrDeskTop();
        if (this.m_commonGraph.getPFJ().isMixedFreqTimeAxis()) {
            this.m_ValuesPerGroup = 2;
            this.m_DataValuesPerMarker = 2;
        }
        if (this.m_commonGraph.getPFJ().isTimeAxis() && (missingGroups = this.m_commonGraph.getPFJ().getMissingGroups()) != null) {
            for (k = 0; k < missingGroups.length; ++k) {
                if (this.m_GroupID <= missingGroups[k]) continue;
                this.m_GroupID -= k + 1;
                break;
            }
        }
        this.updateAllResource(false);
        try {
            if (this.m_SeriesAreRows) {
                this.m_RowID = this.m_SeriesID;
                this.m_ColID = this.m_GroupID * this.m_ValuesPerGroup;
            } else {
                this.m_RowID = this.m_GroupID * this.m_ValuesPerGroup;
                this.m_ColID = this.m_SeriesID;
            }
            block1 : switch (this.m_ObjectID) {
                case 259: 
                case 277: 
                case 312: 
                case 313: 
                case 330: 
                case 331: 
                case 334: 
                case 335: 
                case 474: 
                case 602: 
                case 606: 
                case 607: 
                case 608: 
                case 609: {
                    if (this.m_MarkerTipDisplayed) {
                        if (this.m_TextTip) {
                            if (this.m_ShowSeriesLabels) {
                                if (this.m_SeriesAreRows) {
                                    tooltipBuilder.append(this.getRowLabels(this.m_RowID, this.m_ColID));
                                } else {
                                    tooltipBuilder.append(this.getColumnLabels(this.m_RowID, this.m_ColID));
                                }
                            }
                            if (this.m_ShowGroupLabels && !this.m_commonGraph.getPFJ().isMixedFreqTimeAxis()) {
                                if (this.m_SeriesAreRows) {
                                    tooltipBuilder.append(this.getColumnLabels(this.m_RowID, this.m_ColID));
                                } else {
                                    tooltipBuilder.append(this.getRowLabels(this.m_RowID, this.m_ColID));
                                }
                            }
                        }
                        if (this.m_ValueTip) {
                            switch (this.m_DataValuesPerMarker) {
                                case 1: {
                                    yValueLabel = this.getValueLabel(this.m_RowID, this.m_ColID, 0);
                                    if (yValueLabel == null) {
                                        yValueLabel = this.m_ObjectID == 474 ? this.m_txtCuVa : this.m_txtVa;
                                    }
                                    if (this.m_ObjectID == 474) {
                                        tooltipBuilder.append(MessageFormat.format(yValueLabel, new Object[]{"[CUMSTKV]"})).append("[R]");
                                        break;
                                    }
                                    tooltipBuilder.append(MessageFormat.format(yValueLabel, new Object[]{"[YV]"})).append("[R]");
                                    break;
                                }
                                case 2: {
                                    xValueLabel = this.getValueLabel(this.m_RowID, this.m_ColID, 0);
                                    if (xValueLabel == null) {
                                        xValueLabel = this.m_txtX;
                                    }
                                    if ((yValueLabel = this.getValueLabel(this.m_RowID, this.m_ColID, 1)) == null) {
                                        yValueLabel = this.m_txtY;
                                    }
                                    tooltipBuilder.append(MessageFormat.format(xValueLabel, new Object[]{"[XV]"})).append("[R]").append(MessageFormat.format(yValueLabel, new Object[]{"[YV]"})).append("[R]");
                                    break;
                                }
                                case 3: {
                                    xValueLabel = this.getValueLabel(this.m_RowID, this.m_ColID, 0);
                                    if (xValueLabel == null) {
                                        xValueLabel = this.m_txtX;
                                    }
                                    if ((yValueLabel = this.getValueLabel(this.m_RowID, this.m_ColID, 1)) == null) {
                                        yValueLabel = this.m_txtY;
                                    }
                                    if ((zValueLabel = this.getValueLabel(this.m_RowID, this.m_ColID, 2)) == null) {
                                        zValueLabel = this.m_txtZ;
                                    }
                                    tooltipBuilder.append(MessageFormat.format(xValueLabel, new Object[]{"[XV]"})).append("[R]").append(MessageFormat.format(yValueLabel, new Object[]{"[YV]"})).append("[R]").append(MessageFormat.format(zValueLabel, new Object[]{"[ZV]"})).append("[R]");
                                    break;
                                }
                            }
                        }
                        if (this.m_GraphIsStacked && this.m_CumValTip) {
                            switch (this.m_commonGraph.getGraphType()) {
                                case 23: 
                                case 30: 
                                case 35: 
                                case 40: 
                                case 47: 
                                case 54: {
                                    dCumVal = 0.0;
                                    if (this.m_SeriesAreRows && !this.m_GraphIsPieBar || !this.m_SeriesAreRows && this.m_GraphIsPieBar) {
                                        bY2 = this.isAssignedToY2(this.m_RowID);
                                        for (i = 0; i <= this.m_RowID; ++i) {
                                            if (bY2 != this.isAssignedToY2(i) && !this.m_GraphIsSingleY) continue;
                                            dCumVal += this.getValue(i, this.m_ColID);
                                        }
                                    } else {
                                        bY2 = this.isAssignedToY2(this.m_ColID);
                                        for (i = 0; i <= this.m_ColID; ++i) {
                                            if (bY2 != this.isAssignedToY2(i) && !this.m_GraphIsSingleY) continue;
                                            dCumVal += this.getValue(this.m_RowID, i);
                                        }
                                    }
                                    yValue = this.m_GraphIsSingleY != false ? 76 : (bY2 != false ? 77 : 76);
                                    tooltipBuilder.append(MessageFormat.format(this.m_txtCu, new Object[]{this.getFormattedValue(dCumVal, yValue, false, false)}));
                                    ** break;
                                }
                                default: {
                                    tooltipBuilder.append(MessageFormat.format(this.m_txtCu, new Object[]{"[CUMSTKV]"}));
                                    ** break;
                                }
                            }
                        }
lbl98:
                        // 4 sources

                    } else {
                        return null;
                    }
                    if (!this.m_PercentTip) break;
                    switch (this.m_commonGraph.getGraphType()) {
                        case 23: 
                        case 30: 
                        case 35: 
                        case 40: 
                        case 47: 
                        case 54: {
                            columnTotal = 0.0;
                            if (this.m_SeriesAreRows) {
                                for (i = 0; i < this.m_commonGraph.getRowCount(); ++i) {
                                    columnTotal += Math.abs(this.getValue(i, this.m_ColID));
                                }
                            } else {
                                for (i = 0; i < this.m_commonGraph.getColumnCount(); ++i) {
                                    columnTotal += Math.abs(this.getValue(this.m_RowID, i));
                                }
                            }
                            percent = Math.abs(this.getValue(this.m_RowID, this.m_ColID)) / columnTotal;
                            yValue = 76;
                            tooltipBuilder.append(MessageFormat.format(this.m_txtPe, new Object[]{this.getFormattedValue(percent, yValue, true, false)}));
                            break block1;
                        }
                        case 96: {
                            if (this.m_ObjectID != 474) break;
                            tooltipBuilder.append(MessageFormat.format(this.m_txtCuPe, new Object[]{"[CUMPCTV]"})).append("[R]");
                        }
                    }
                    break;
                }
                case 298: 
                case 299: 
                case 300: 
                case 332: 
                case 333: {
                    if (this.m_MarkerTipDisplayed) {
                        if (this.m_TextTip) {
                            if (this.m_ShowSeriesLabels) {
                                if (this.m_SeriesAreRows) {
                                    tooltipBuilder.append(this.getRowLabels(this.m_RowID, this.m_ColID));
                                } else {
                                    tooltipBuilder.append(this.getColumnLabels(this.m_RowID, this.m_ColID));
                                }
                            }
                            if (this.m_ShowGroupLabels && !this.m_GraphIsPieBar) {
                                if (this.m_SeriesAreRows) {
                                    tooltipBuilder.append(this.getColumnLabels(this.m_RowID, this.m_ColID));
                                } else {
                                    tooltipBuilder.append(this.getRowLabels(this.m_RowID, this.m_ColID));
                                }
                            }
                        }
                        if (this.m_ValueTip) {
                            valueLabel = null;
                            valueLabel = this.getValueLabel(this.m_RowID, this.m_ColID, 0);
                            if (valueLabel == null) {
                                valueLabel = this.m_txtVa;
                            }
                            tooltipBuilder.append(MessageFormat.format(valueLabel, new Object[]{"[YV]"})).append("[R]");
                        }
                        if (!this.m_PercentTip) break;
                        percentStrings = this.m_commonGraph.getPFJ().getPercentSign();
                        tooltipBuilder.append(MessageFormat.format(this.m_txtPe, new Object[]{"[PIEPCTV]"}));
                        break;
                    }
                    return null;
                }
                case 621: {
                    if (this.m_MarkerTipDisplayed) {
                        if (this.m_TextTip && this.m_ShowGroupLabels) {
                            if (this.m_SeriesAreRows) {
                                tooltipBuilder.append(this.getColumnLabels(this.m_RowID, this.m_ColID));
                            } else {
                                tooltipBuilder.append(this.getRowLabels(this.m_RowID, this.m_ColID));
                            }
                        }
                        if (this.m_ValueTip) {
                            actualValueLabel = this.getValueLabel(this.m_RowID, this.m_ColID, 0);
                            if (actualValueLabel == null) {
                                actualValueLabel = this.m_txtActual;
                            }
                            if ((targetValueLabel = this.getValueLabel(this.m_RowID, this.m_ColID, 1)) == null) {
                                targetValueLabel = this.m_txtTarget;
                            }
                            tooltipBuilder.append(MessageFormat.format(actualValueLabel, new Object[]{"[AV]"}) + "[R]" + MessageFormat.format(targetValueLabel, new Object[]{"[TV]"}));
                        }
                        if (!this.m_PercentTip) break;
                        tooltipBuilder.append("[R]");
                        tooltipBuilder.append(MessageFormat.format(this.m_txtPe, new Object[]{"[PIEPCTV]"}));
                        break;
                    }
                    return null;
                }
                case 310: {
                    if (this.m_MarkerTipDisplayed) {
                        if (this.m_TextTip) {
                            if (this.m_ShowSeriesLabels) {
                                if (this.m_SeriesAreRows) {
                                    tooltipBuilder.append(this.getRowLabels(this.m_RowID - 1, this.m_ColID));
                                } else {
                                    tooltipBuilder.append(this.getColumnLabels(this.m_RowID, this.m_ColID));
                                }
                            }
                            if (this.m_ShowGroupLabels) {
                                if (this.m_SeriesAreRows) {
                                    tooltipBuilder.append(this.getColumnLabels(this.m_RowID, this.m_ColID));
                                } else {
                                    tooltipBuilder.append(this.getRowLabels(this.m_RowID, this.m_ColID));
                                }
                            }
                        }
                        if (!this.m_ValueTip) break;
                        tooltipBuilder.append(MessageFormat.format(this.m_txtVo, new Object[]{"[VV]"})).append("[R]");
                        break;
                    }
                    return null;
                }
                case 303: 
                case 306: 
                case 307: 
                case 308: 
                case 319: 
                case 320: {
                    if (this.m_MarkerTipDisplayed) {
                        if (this.m_TextTip) {
                            if (this.m_ShowSeriesLabels) {
                                if (this.m_SeriesAreRows) {
                                    tooltipBuilder.append(this.getRowLabels(this.m_RowID, this.m_ColID));
                                } else {
                                    tooltipBuilder.append(this.getColumnLabels(this.m_RowID, this.m_ColID));
                                }
                            }
                            if (this.m_ShowGroupLabels) {
                                if (this.m_SeriesAreRows) {
                                    tooltipBuilder.append(this.getColumnLabels(this.m_RowID, this.m_ColID));
                                } else {
                                    tooltipBuilder.append(this.getRowLabels(this.m_RowID, this.m_ColID));
                                }
                            }
                        }
                        if (!this.m_ValueTip) break;
                        switch (this.m_DataValuesPerMarker) {
                            case 2: {
                                if (this.m_GraphIsOpenAndClose) {
                                    oValueLabel = this.getValueLabel(this.m_RowID, this.m_ColID, 0);
                                    if (oValueLabel == null) {
                                        oValueLabel = this.m_txtOp;
                                    }
                                    if ((cValueLabel = this.getValueLabel(this.m_RowID, this.m_ColID, 1)) == null) {
                                        cValueLabel = this.m_txtCl;
                                    }
                                    tooltipBuilder.append(MessageFormat.format(oValueLabel, new Object[]{"[OV]"})).append("[R]").append(MessageFormat.format(cValueLabel, new Object[]{"[CV]"}));
                                    break block1;
                                }
                                hValueLabel = this.getValueLabel(this.m_RowID, this.m_ColID, 0);
                                if (hValueLabel == null) {
                                    hValueLabel = this.m_txtHi;
                                }
                                if ((lValueLabel = this.getValueLabel(this.m_RowID, this.m_ColID, 1)) == null) {
                                    lValueLabel = this.m_txtLo;
                                }
                                tooltipBuilder.append(MessageFormat.format(hValueLabel, new Object[]{"[HV]"})).append("[R]").append(MessageFormat.format(lValueLabel, new Object[]{"[LV]"}));
                                break block1;
                            }
                            case 3: {
                                hValueLabel = this.getValueLabel(this.m_RowID, this.m_ColID, 0);
                                if (hValueLabel == null) {
                                    hValueLabel = this.m_txtHi;
                                }
                                if ((lValueLabel = this.getValueLabel(this.m_RowID, this.m_ColID, 1)) == null) {
                                    lValueLabel = this.m_txtLo;
                                }
                                if ((cValueLabel = this.getValueLabel(this.m_RowID, this.m_ColID, 2)) == null) {
                                    cValueLabel = this.m_txtCl;
                                }
                                tooltipBuilder.append(MessageFormat.format(hValueLabel, new Object[]{"[HV]"})).append("[R]").append(MessageFormat.format(lValueLabel, new Object[]{"[LV]"})).append("[R]").append(MessageFormat.format(cValueLabel, new Object[]{"[CV]"}));
                                break block1;
                            }
                            case 4: {
                                oValueLabel = this.getValueLabel(this.m_RowID, this.m_ColID, 0);
                                if (oValueLabel == null) {
                                    oValueLabel = this.m_txtOp;
                                }
                                if ((hValueLabel = this.getValueLabel(this.m_RowID, this.m_ColID, 1)) == null) {
                                    hValueLabel = this.m_txtHi;
                                }
                                if ((lValueLabel = this.getValueLabel(this.m_RowID, this.m_ColID, 2)) == null) {
                                    lValueLabel = this.m_txtLo;
                                }
                                if ((cValueLabel = this.getValueLabel(this.m_RowID, this.m_ColID, 3)) == null) {
                                    cValueLabel = this.m_txtCl;
                                }
                                tooltipBuilder.append(MessageFormat.format(oValueLabel, new Object[]{"[OV]"})).append("[R]").append(MessageFormat.format(hValueLabel, new Object[]{"[HV]"})).append("[R]").append(MessageFormat.format(lValueLabel, new Object[]{"[LV]"})).append("[R]").append(MessageFormat.format(cValueLabel, new Object[]{"[CV]"}));
                                break block1;
                            }
                        }
                        break;
                    }
                    return null;
                }
                case 13: 
                case 14: {
                    if (!this.m_commonGraph.getPFJ().isLegendLabelsTruncated()) break;
                    if (this.m_commonGraph.getGraphType() <= 14) ** GOTO lbl274
                    if (this.m_commonGraph.getGraphType() == 100) {
                        labels = this.m_commonGraph.getPFJ().getLegendObj().getMarkersLabels().getLabels();
                        if (labels != null) {
                            tooltipBuilder.append(labels.get(this.m_SeriesID));
                        }
                    } else {
                        tooltipBuilder.append(this.getWrappedText(this.m_commonGraph.getPFJ().getSeriesLabel(this.m_SeriesID)));
                        break;
lbl274:
                        // 1 sources

                        labels = this.m_commonGraph.getPFJ().getLegendObj().getMarkersLabels().getLabels();
                        if (labels != null) {
                            tooltipBuilder.append(labels.get(this.m_SeriesID));
                        }
                    }
                    break;
                }
                case 18: {
                    if (!this.m_commonGraph.getPFJ().isLegendLabelsTruncated()) break;
                    labels = this.m_commonGraph.getPFJ().getLegendObj().getMarkersLabels().getLabels();
                    if (labels != null) {
                        tooltipBuilder.append(labels.get(aMouseState.getIdentObj().getMiscID()));
                    }
                    break;
                }
                case 73: {
                    if (!this.m_commonGraph.getPFJ().isLegendLabelsTruncated()) break;
                    labels = this.m_commonGraph.getPFJ().getLegendObj().getMarkersLabels().getLabels();
                    if (labels != null) {
                        tooltipBuilder.append(labels.get(aMouseState.getIdentObj().getMiscID()));
                    }
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    if (!this.m_commonGraph.getPFJ().isAxisTitleTruncated(this.m_ObjectID)) break;
                    tooltipBuilder.append(this.getWrappedText(this.m_commonGraph.getPFJ().getTextString(this.m_ObjectID)));
                    break;
                }
                case 5: {
                    if (!this.m_commonGraph.getPFJ().isTitleTruncated(this.m_ObjectID)) break;
                    tooltipBuilder.append(this.getWrappedText(this.m_commonGraph.getPFJ().getTitleString()));
                    break;
                }
                case 4: {
                    if (!this.m_commonGraph.getPFJ().isTitleTruncated(this.m_ObjectID)) break;
                    tooltipBuilder.append(this.getWrappedText(this.m_commonGraph.getPFJ().getSubtitleString()));
                    break;
                }
                case 3: {
                    if (!this.m_commonGraph.getPFJ().isTitleTruncated(this.m_ObjectID)) break;
                    tooltipBuilder.append(this.getWrappedText(this.m_commonGraph.getPFJ().getFootnoteString()));
                    break;
                }
                case 296: {
                    if (!this.m_commonGraph.getPFJ().isTitleTruncated(this.m_ObjectID)) break;
                    tooltipBuilder.append(this.getWrappedText(this.m_commonGraph.getPFJ().getTextString(aMouseState.getIdentObj())));
                    break;
                }
                case 270: 
                case 280: {
                    if ((this.m_commonGraph.getGraphType() < 65 || this.m_commonGraph.getGraphType() > 68) && this.m_commonGraph.getGraphType() != 100 || !this.m_commonGraph.getPFJ().isO1LabelsTruncated()) break;
                    tooltipBuilder.append(this.getWrappedText(this.m_commonGraph.getPFJ().getGroupLabel(this.m_GroupID)));
                    break;
                }
                case 356: {
                    annotation = this.m_commonGraph.getAnnotation(this.m_SeriesID, this.m_GroupID, aMouseState.getIdentObj().getMiscID());
                    tooltipBuilder.append(this.getWrappedText(annotation.getText()));
                    break;
                }
                case 390: {
                    index = aMouseState.getIdentObj().getMiscID();
                    alert = this.m_commonGraph.getAlert(index - 1);
                    tooltipBuilder.append(this.getWrappedText(alert.getText()));
                    break;
                }
                case 357: {
                    label = "";
                    miscID = aMouseState.getIdentObj().getMiscID();
                    ro = this.m_commonGraph.getReferenceObject(miscID);
                    if (ro == null) break;
                    tooltipBuilder.append(this.getReferenceObjectShortDesc(aMouseState.getIdentObj()));
                    break;
                }
                case 503: 
                case 504: {
                    label = "";
                    miscID = aMouseState.getIdentObj().getMiscID();
                    if (this.m_commonGraph.getReferenceObject(miscID) == null || !this.m_commonGraph.getPFJ().isLegendLabelsTruncated()) break;
                    label = this.m_commonGraph.getReferenceObject(miscID).getText();
                    tooltipBuilder.append(this.getWrappedText(label));
                    break;
                }
                case 234: 
                case 235: {
                    if (!this.m_commonGraph.getPFJ().isLegendLabelsTruncated()) break;
                    label = this.m_commonGraph.getPFJ().getDrillCallback().getDrillUpLabel(14);
                    tooltipBuilder.append(this.getWrappedText(label));
                    break;
                }
                case 508: {
                    value = 0.0;
                    switch (this.m_SeriesID) {
                        case 283: {
                            value = this.m_commonGraph.getY1BaseLine().getValue();
                            break;
                        }
                        case 287: {
                            value = this.m_commonGraph.getY2BaseLine().getValue();
                        }
                    }
                    tooltipBuilder.append(this.m_txtBV + value);
                    break;
                }
                case 295: 
                case 622: {
                    if (!this.m_commonGraph.getPFJ().isSliceLabelsTruncated()) break;
                    tooltipBuilder.append(this.getWrappedText(aMouseState.getElementText()));
                    break;
                }
                case 511: {
                    if (this.m_SeriesID == 0) {
                        tooltipBuilder.append(MessageFormat.format(this.m_txtX, new Object[]{this.getFormattedValue(this.m_commonGraph.getPFJ().m_lineFixedValueX, 75, false, false)})).append("[R]").append(MessageFormat.format(this.m_txtY, new Object[]{this.getFormattedValue(this.m_commonGraph.getPFJ().m_lineFixedValueY, 76, false, false)})).append("[R]");
                        break;
                    }
                    tooltipBuilder.append(MessageFormat.format(this.m_txtX, new Object[]{this.getFormattedValue(this.m_commonGraph.getPFJ().m_lineSelectValueX, 75, false, false)})).append("[R]").append(MessageFormat.format(this.m_txtY, new Object[]{this.getFormattedValue(this.m_commonGraph.getPFJ().m_lineSelectValueY, 76, false, false)})).append("[R]");
                    break;
                }
                case 513: {
                    if (this.m_commonGraph.getTimeSelector().getMode() != 1) break;
                    startDate = this.m_commonGraph.getTimeSelector().getExplicitStart();
                    endDate = this.m_commonGraph.getTimeSelector().getExplicitEnd();
                    startDateFreq = this.calcDateFreq(startDate);
                    endDateFreq = this.calcDateFreq(endDate);
                    dateFreq = startDateFreq;
                    dateFreq = startDateFreq == 6 || endDateFreq == 6 ? 6 : (startDateFreq == 5 || endDateFreq == 5 ? 5 : (startDateFreq == 4 || endDateFreq == 4 ? 4 : (startDateFreq == 2 || endDateFreq == 2 ? 2 : (startDateFreq == 1 || endDateFreq == 1 ? 1 : 0))));
                    tooltipBuilder.append(MessageFormat.format(this.m_txtStart, new Object[]{this.formatDate(startDate, dateFreq)})).append("[R]").append(MessageFormat.format(this.m_txtEnd, new Object[]{this.formatDate(endDate, dateFreq)})).append("[R]");
                    break;
                }
            }
        }
        catch (Exception e) {
            this.m_commonGraph.getErrorHandler().error((Throwable)e, this.getClass().getName(), "getDynamicToolTip");
        }
        toolTipText = tooltipBuilder.toString();
        if (this.m_customToolTipCallback != null) {
            toolTipText = this.m_customToolTipCallback.getToolTipText(toolTipText, this.m_commonGraph.getGraphComponentHandle(aMouseState));
            toolTipText = ToolTips.convertMarkerTooltipTemplate(toolTipText);
        } else if (this.m_markerTooltipTemplate != null && ToolTips.useMarkerTooltipTemplate(this.m_ObjectID, this.m_commonGraph.getGraphType())) {
            toolTipText = this.m_markerTooltipTemplate;
        }
        return toolTipText;
    }

    protected String getReferenceObjectShortDesc(IdentObj id) {
        boolean isTimeAxis;
        String label = this.m_commonGraph.getPFJ().getReferenceObjectTextString(id);
        String shortDesc = this.m_commonGraph.getPFJ().getShortDesc(id);
        StringBuilder tooltipBuilderTemp = new StringBuilder();
        int axisID = this.m_commonGraph.getPFJ().getReferenceAssociation(id);
        int type = this.m_commonGraph.getPFJ().getReferenceObjectType(id);
        boolean bl = isTimeAxis = axisID == 41 && (this.m_commonGraph.getPFJ().isTimeAxis() || this.m_commonGraph.getPFJ().isContinuousTimeAxis());
        if (shortDesc == null) {
            if (type == 0) {
                String lineVal = null;
                Double lineValue = this.m_commonGraph.getPFJ().getReferenceLineValue(id);
                lineVal = !isTimeAxis ? this.getFormattedValue(lineValue, axisID, false, false) : this.convertDateToString(new Date(lineValue.longValue()));
                String tooltip = MessageFormat.format(this.m_txtVa, lineVal);
                tooltipBuilderTemp.append(this.getWrappedText(label + "[R]" + tooltip));
            } else {
                String lowVal = null;
                Double lowValue = this.m_commonGraph.getPFJ().getReferenceAreaLowValue(id);
                lowVal = !isTimeAxis ? this.getFormattedValue(lowValue, axisID, false, false) : this.convertDateToString(new Date(lowValue.longValue()));
                String lowValTooltip = MessageFormat.format(this.m_txtLo, lowVal);
                String highVal = null;
                Double highValue = this.m_commonGraph.getPFJ().getReferenceAreaHighValue(id);
                highVal = !isTimeAxis ? this.getFormattedValue(highValue, axisID, false, false) : this.convertDateToString(new Date(highValue.longValue()));
                String highValTooltip = MessageFormat.format(this.m_txtHi, highVal);
                tooltipBuilderTemp.append(label + "[R]" + lowValTooltip + "[R]" + highValTooltip);
            }
        } else {
            tooltipBuilderTemp.append(shortDesc);
        }
        return tooltipBuilderTemp.toString();
    }

    public String getFormattedValue(double dVal, int axis, boolean isPercent, boolean isPieSlice) {
        ViewFormat viewFormat = null;
        QDR qdr = null;
        qdr = new DataComponentInfo(this.m_RowID, this.m_ColID).getQDR(this.m_dataAccess, 1);
        if (isPieSlice) {
            viewFormat = this.m_commonGraph.getSliceLabel().getViewFormat();
            return this.m_fmtMgr.formatPieValue(dVal, viewFormat, isPercent, qdr, true);
        }
        viewFormat = this.m_numFormatCallback.getMarkerTextViewFormat(this.m_SeriesID, this.m_GroupID);
        return this.m_fmtMgr.formatDataValue(dVal, viewFormat, axis, this.m_ColID, this.m_RowID, isPercent, qdr, true);
    }

    public int getDataValuesPerMarker() {
        return this.m_DataValuesPerMarker;
    }

    private String getValueLabel(int row, int col, int offset) {
        String label = this.getValueMember(row, col, offset);
        if (label == null) {
            return null;
        }
        if (label.length() > 0) {
            return label + ": {0}";
        }
        return "{0}";
    }

    public String getValueMember(int row, int col, int offset) {
        block32: {
            if (row < 0 || col < 0) {
                return null;
            }
            DataCallback dcb = (DataCallback)this.m_commonGraph.getDataFilter();
            QDR myQDR = null;
            try {
                int groupEdge = 0;
                if (this.m_ValuesPerGroup > 1) {
                    int slice = 0;
                    if (!this.m_excelOrDeskTop) {
                        if (this.m_SeriesAreRows) {
                            groupEdge = 0;
                            slice = dcb.getDataAccessColumn(col + offset);
                        } else {
                            groupEdge = 1;
                            slice = dcb.getDataAccessRow(row + offset);
                        }
                    } else if (this.m_SeriesAreRows) {
                        groupEdge = 1;
                        slice = dcb.getDataAccessRow(row, col + offset);
                    } else {
                        groupEdge = 0;
                        slice = dcb.getDataAccessColumn(row + offset, col);
                    }
                    int layerCount = this.m_dataAccess.getLayerCount(groupEdge);
                    if (layerCount > 1) {
                        Object dimensionValue = AttributeFormatUtils.getAttributeFormattedMemberMetadataValue(this.m_commonGraph, groupEdge, slice, layerCount - 1);
                        if (dimensionValue == null) {
                            dimensionValue = this.m_dataAccess.getMemberMetadata(groupEdge, layerCount - 1, slice, this.m_commonGraph.getMemberMetadataLabelType(groupEdge));
                        }
                        if (dimensionValue != null) {
                            return dimensionValue.toString();
                        }
                    }
                }
                if ((myQDR = this.m_dataAccess.getValueQDR(dcb.getDataAccessRow(row, col), dcb.getDataAccessColumn(row, col), 1)) != null) {
                    this.m_measureDim = myQDR.getMeasureDim();
                    for (int edge = 0; edge < this.m_dataAccess.getEdgeCount(); ++edge) {
                        int slice = -1;
                        if (edge == 2) {
                            slice = this.m_dataAccess.getEdgeCurrentSlice(edge);
                        } else if (edge == 0) {
                            if (this.m_excelOrDeskTop) {
                                slice = row + offset;
                                slice = dcb.getDataAccessColumn(slice, col);
                            } else {
                                slice = col + offset;
                                slice = dcb.getDataAccessColumn(row, slice);
                            }
                        } else if (this.m_excelOrDeskTop) {
                            slice = col + offset;
                            slice = dcb.getDataAccessRow(row, slice);
                        } else {
                            slice = row + offset;
                            slice = dcb.getDataAccessRow(slice, col);
                        }
                        for (int layer = 0; layer < this.m_dataAccess.getLayerCount(edge); ++layer) {
                            String layerName = null;
                            Object obj = null;
                            try {
                                obj = this.m_dataAccess.getLayerMetadata(edge, layer, "layerName");
                                if (obj != null) {
                                    layerName = obj.toString();
                                }
                            }
                            catch (LayerOutOfRangeException e) {
                                layerName = null;
                            }
                            if ((this.m_ValuesPerGroup <= 1 || this.m_measureDim.equals("") || edge != groupEdge || layer != this.m_dataAccess.getLayerCount(edge) - 1) && (this.m_ValuesPerGroup > 1 || layerName == null || !layerName.equals(this.m_measureDim))) continue;
                            Object dimensionValue = AttributeFormatUtils.getAttributeFormattedMemberMetadataValue(this.m_commonGraph, edge, slice, layer);
                            if (dimensionValue == null) {
                                dimensionValue = this.m_dataAccess.getMemberMetadata(edge, layer, slice, this.m_commonGraph.getMemberMetadataLabelType(edge));
                            }
                            if (dimensionValue != null) {
                                if (this.m_commonGraph.getPFJ().isMixedFreqTimeAxis() && offset == 0) {
                                    int dateEdge = this.m_SeriesAreRows ? 0 : 1;
                                    String label = (String)this.m_dataAccess.getLayerMetadata(dateEdge, 0, "layerLabel");
                                    if (label != null && label.length() > 0) {
                                        return label;
                                    }
                                    return "";
                                }
                                String dimensionValueStr = dimensionValue.toString();
                                if (dimensionValueStr != null && dimensionValueStr.length() > 0) {
                                    return dimensionValueStr;
                                }
                                return "";
                            }
                            return null;
                        }
                    }
                    break block32;
                }
                return null;
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    private String getValueLabelTemplate(int row, int col, int offset, String macro) {
        String label = this.getValueMember(row, col, offset);
        if (label == null) {
            return null;
        }
        if (label.length() > 0) {
            return macro + ": {0}";
        }
        return "{0}";
    }

    public String getColumnLabels(int row, int col) {
        return this.getWrappedText(this.getLabels(row, col, 0, this.m_ShowColDimName, this.m_SeriesAreRows));
    }

    public String getRowLabels(int row, int col) {
        return this.getWrappedText(this.getLabels(row, col, 1, this.m_ShowRowDimName, !this.m_SeriesAreRows));
    }

    protected String getLabels(int row, int col, int edge, boolean showDimName, boolean series) {
        int i;
        Vector singleQDRDimValuePairs;
        String layerLabelType;
        int modelEdge = edge;
        DataCallback dcb = (DataCallback)this.m_commonGraph.getDataFilter();
        if (this.m_excelOrDeskTop) {
            int n = modelEdge = edge == 0 ? 1 : 0;
        }
        if (!this.m_commonGraph.isLayerMetadataLabelTypeSupported(layerLabelType = this.m_commonGraph.getLayerMetadataLabelType(modelEdge)) || col < 0 || row < 0) {
            return this.getDefaultLabels(row, col, edge, showDimName, series);
        }
        boolean timeAxis = false;
        if ((this.m_commonGraph.getPFJ().isTimeAxis() || this.m_commonGraph.getPFJ().isIrregularTimeAxis()) && (edge == 0 && this.m_SeriesAreRows || edge == 1 && !this.m_SeriesAreRows)) {
            timeAxis = true;
        }
        String label = "";
        Vector<QDR> myQDRs = new Vector<QDR>();
        int max = edge == 0 && series || edge == 1 && series ? this.m_DataValuesPerMarker : 1;
        boolean isColumn = edge == 0;
        for (int i2 = 0; i2 < max; ++i2) {
            try {
                int cr = 0;
                cr = isColumn ? (this.m_excelOrDeskTop ? dcb.getDataAccessRow(row, col + i2) : dcb.getDataAccessColumn(row, col + i2)) : (this.m_excelOrDeskTop ? dcb.getDataAccessColumn(row + i2, col) : dcb.getDataAccessRow(row + i2, col));
                QDR edgeQDR = this.m_dataAccess.getSliceQDR(modelEdge, cr, 1);
                if (edgeQDR == null) continue;
                myQDRs.addElement(edgeQDR);
                continue;
            }
            catch (Exception e) {
                this.m_commonGraph.getErrorHandler().error((Throwable)e, this.getClass().getName(), "getLabels");
            }
        }
        this.m_measureDim = "";
        int groupEdge = 0;
        groupEdge = !this.m_excelOrDeskTop ? (this.m_SeriesAreRows ? 0 : 1) : (this.m_SeriesAreRows ? 1 : 0);
        if (this.m_ValuesPerGroup > 1) {
            int slice = 0;
            try {
                Object obj;
                slice = !this.m_excelOrDeskTop ? (this.m_SeriesAreRows ? dcb.getDataAccessColumn(row, col) : dcb.getDataAccessRow(row, col)) : (this.m_SeriesAreRows ? dcb.getDataAccessRow(row, col) : dcb.getDataAccessColumn(row, col));
                int layerCount = this.m_dataAccess.getLayerCount(groupEdge);
                if (layerCount > 1 && (obj = this.m_dataAccess.getLayerMetadata(groupEdge, layerCount - 1, "layerName")) != null) {
                    this.m_measureDim = obj.toString();
                }
            }
            catch (Exception e) {
                this.m_commonGraph.getErrorHandler().error((Throwable)e, this.getClass().getName(), "getLabels");
            }
        }
        if (this.m_measureDim.equals("")) {
            if (this.m_excelOrDeskTop) {
                this.getDefaultLabels(row, col, edge, showDimName, series);
            }
            if (myQDRs.size() == 0) {
                return this.getDefaultLabels(row, col, edge, showDimName, series);
            }
            this.m_measureDim = ((QDR)myQDRs.elementAt(0)).getMeasureDim();
        }
        if (this.m_measureDim.equals("")) {
            return this.getDefaultLabels(row, col, edge, showDimName, series);
        }
        Vector<Vector> QDRDimValuePairs = new Vector<Vector>(myQDRs.size());
        for (int i3 = 0; i3 < myQDRs.size(); ++i3) {
            Enumeration dimensionIDs = ((QDR)myQDRs.elementAt(i3)).getDimensions();
            singleQDRDimValuePairs = new Vector();
            while (dimensionIDs.hasMoreElements()) {
                String dim = (String)dimensionIDs.nextElement();
                try {
                    for (int layer = 0; layer < this.m_dataAccess.getLayerCount(modelEdge); ++layer) {
                        int depth;
                        if ((this.m_ValuesPerGroup <= 1 || edge == groupEdge && layer == this.m_dataAccess.getLayerCount(modelEdge) - 1) && (this.m_ValuesPerGroup > 1 || dim == null || dim.equals(this.m_measureDim))) continue;
                        String layerName = null;
                        String dimensionValue = null;
                        Object obj = null;
                        try {
                            obj = this.m_dataAccess.getLayerMetadata(modelEdge, layer, "layerName");
                            if (obj != null) {
                                layerName = obj.toString();
                            }
                        }
                        catch (LayerOutOfRangeException e) {
                            layerName = null;
                        }
                        int cr1 = 0;
                        cr1 = isColumn ? (this.m_excelOrDeskTop ? dcb.getDataAccessRow(row, col + i3) : dcb.getDataAccessColumn(row, col)) : (this.m_excelOrDeskTop ? dcb.getDataAccessColumn(row + i3, col) : dcb.getDataAccessRow(row, col));
                        if (layerName != null && layerName.equals(dim)) {
                            if (timeAxis) {
                                obj = null;
                                if (this.m_commonGraph.isMetadataDateSupported()) {
                                    obj = this.m_dataAccess.getMemberMetadata(modelEdge, layer, cr1, "date");
                                }
                                if (obj == null) {
                                    obj = this.m_dataAccess.getMemberMetadata(modelEdge, layer, cr1, "value");
                                }
                                if (obj == null || !(obj instanceof Date)) {
                                    obj = AttributeFormatUtils.getAttributeFormattedMemberMetadataValue(this.m_commonGraph, modelEdge, cr1, layer);
                                }
                                if (obj != null) {
                                    obj = this.convertDateToString(obj);
                                }
                            } else {
                                obj = AttributeFormatUtils.getAttributeFormattedMemberMetadataValue(this.m_commonGraph, modelEdge, cr1, layer);
                                if (obj == null) {
                                    obj = this.m_dataAccess.getMemberMetadata(modelEdge, layer, cr1, this.m_commonGraph.getMemberMetadataLabelType(edge));
                                }
                            }
                            if (obj != null) {
                                dimensionValue = obj.toString();
                            }
                            if (dimensionValue != null) {
                                obj = this.m_dataAccess.getLayerMetadata(modelEdge, layer, layerLabelType);
                                String layerLongName = null;
                                if (obj != null) {
                                    layerLongName = obj.toString();
                                }
                                singleQDRDimValuePairs.addElement(new DimValuePairs(layerLongName, dimensionValue));
                            }
                        }
                        if ((depth = this.m_dataAccess.getMemberDepth(modelEdge, layer, cr1)) <= 1) continue;
                        layer += depth - 1;
                    }
                }
                catch (Exception e) {
                    this.m_commonGraph.getErrorHandler().error((Throwable)e, this.getClass().getName(), "getLabels");
                    this.getDefaultLabels(row, col, edge, showDimName, series);
                }
            }
            QDRDimValuePairs.addElement(singleQDRDimValuePairs);
        }
        Vector commonDimValuePairs = this.getCommonDimensionsWithNoDuplicats(QDRDimValuePairs);
        for (i = 0; i < commonDimValuePairs.size(); ++i) {
            if (commonDimValuePairs.elementAt(i) == null) continue;
            String dim = ((DimValuePairs)commonDimValuePairs.elementAt((int)i)).dim;
            String value = ((DimValuePairs)commonDimValuePairs.elementAt((int)i)).value;
            if (dim == null || dim.length() <= 0 || value == null || value.length() <= 0) continue;
            label = label + dim + ": " + value + "[R]";
        }
        for (i = 0; i < QDRDimValuePairs.size(); ++i) {
            singleQDRDimValuePairs = (Vector)QDRDimValuePairs.elementAt(i);
            for (int j = 0; j < singleQDRDimValuePairs.size(); ++j) {
                if (this.hasSameValues(commonDimValuePairs, (DimValuePairs)singleQDRDimValuePairs.elementAt(j))) continue;
                String dim = ((DimValuePairs)singleQDRDimValuePairs.elementAt((int)j)).dim;
                String value = ((DimValuePairs)singleQDRDimValuePairs.elementAt((int)j)).value;
                if (dim == null || dim.length() <= 0 || value == null || value.length() <= 0) continue;
                label = label + dim + ": " + value + "[R]";
            }
        }
        return label.trim() + "[R]";
    }

    private boolean hasSameValues(Vector commonDimValuePairs, DimValuePairs dvp) {
        for (int i = 0; i < commonDimValuePairs.size(); ++i) {
            if (commonDimValuePairs.elementAt(i) == null || !dvp.equals((DimValuePairs)commonDimValuePairs.elementAt(i))) continue;
            return true;
        }
        return false;
    }

    protected Vector getCommonDimensionsWithNoDuplicats(Vector QDRDimValuePairs) {
        Object a = QDRDimValuePairs.elementAt(0);
        Vector v = (Vector)a;
        Vector commonDims = (Vector)v.clone();
        for (int i = 0; i < commonDims.size(); ++i) {
            String testDimName = ((DimValuePairs)commonDims.elementAt((int)i)).dim;
            String testValueName = ((DimValuePairs)commonDims.elementAt((int)i)).value;
            for (int qdr = 1; qdr < QDRDimValuePairs.size(); ++qdr) {
                Vector curQDRDimValuePairs = (Vector)QDRDimValuePairs.elementAt(qdr);
                boolean hasDimFlag = false;
                for (int dim = 0; dim < curQDRDimValuePairs.size(); ++dim) {
                    if (!testDimName.equals(((DimValuePairs)curQDRDimValuePairs.elementAt((int)dim)).dim)) continue;
                    hasDimFlag = true;
                    String val = ((DimValuePairs)curQDRDimValuePairs.elementAt((int)dim)).value;
                    if (testValueName.equals(val)) continue;
                    commonDims.setElementAt(null, i);
                }
                if (hasDimFlag) continue;
                commonDims.setElementAt(null, i);
            }
        }
        return commonDims;
    }

    protected String getDefaultLabels(int row, int col, int edge, boolean showDimName, boolean series) {
        this.m_DimNameType = this.m_commonGraph.getLayerMetadataLabelType(edge);
        this.m_DimMemberNameType = this.m_commonGraph.getMemberMetadataLabelType(edge);
        DataCallback dcb = (DataCallback)this.m_commonGraph.getDataFilter();
        int cr = 0;
        cr = edge == 0 ? dcb.getDataAccessColumn(row, col) : dcb.getDataAccessRow(row, col);
        String label = "";
        int dims = 0;
        try {
            dims = this.m_dataAccess.getLayerCount(edge);
        }
        catch (EdgeOutOfRangeException e) {
            this.m_commonGraph.getErrorHandler().error((Throwable)e, this.getClass().getName(), "getDefaultLabels");
        }
        boolean timeAxis = false;
        if ((this.m_commonGraph.getPFJ().isTimeAxis() || this.m_commonGraph.getPFJ().isIrregularTimeAxis()) && (edge == 0 && this.m_SeriesAreRows || edge == 1 && !this.m_SeriesAreRows)) {
            timeAxis = true;
        }
        if (this.m_commonGraph.isLayerMetadataLabelTypeSupported(this.m_DimNameType) || this.m_commonGraph.isMemberMetadataLabelTypeSupported(this.m_DimMemberNameType)) {
            try {
                Object obj = null;
                Object str = null;
                for (int i = 0; i < dims; ++i) {
                    if (showDimName) {
                        label = this.m_commonGraph.isLayerMetadataLabelTypeSupported(this.m_DimNameType) ? ((obj = this.m_dataAccess.getLayerMetadata(edge, i, this.m_DimNameType)) != null ? label + obj.toString() + ":" : label + ":") : label + ":";
                    }
                    if (this.m_commonGraph.isMemberMetadataLabelTypeSupported(this.m_DimMemberNameType)) {
                        if (timeAxis) {
                            obj = null;
                            if (this.m_commonGraph.isMetadataDateSupported()) {
                                obj = this.m_dataAccess.getMemberMetadata(edge, i, cr, "date");
                            }
                            if (obj == null) {
                                obj = this.m_dataAccess.getMemberMetadata(edge, i, cr, "value");
                            }
                            if (obj == null || !(obj instanceof Date)) {
                                obj = AttributeFormatUtils.getAttributeFormattedMemberMetadataValue(this.m_commonGraph, edge, cr, i);
                            }
                            if (obj == null) {
                                obj = this.m_dataAccess.getMemberMetadata(edge, i, cr, this.m_DimMemberNameType);
                            }
                            if (obj != null) {
                                obj = this.convertDateToString(obj);
                            }
                        } else if (this.m_excelOrDeskTop) {
                            obj = this.m_SeriesAreRows ? (edge == 1 ? dcb.rowLabel(row) : dcb.columnLabel(this.m_GroupID)) : (edge == 1 ? dcb.rowLabel(this.m_GroupID) : dcb.columnLabel(col));
                        } else {
                            obj = AttributeFormatUtils.getAttributeFormattedMemberMetadataValue(this.m_commonGraph, edge, cr, i);
                            if (obj == null) {
                                obj = this.m_dataAccess.getMemberMetadata(edge, i, cr, this.m_DimMemberNameType);
                            }
                        }
                        if (obj != null) {
                            label = label + obj.toString() + " ";
                            continue;
                        }
                        label = label + " ";
                        continue;
                    }
                    label = label + " ";
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (showDimName) {
            return label.trim() + "[R]";
        }
        if (series) {
            return MessageFormat.format(this.m_txtGr, label.trim()) + "[R]";
        }
        return MessageFormat.format(this.m_txtSe, label.trim()) + "[R]";
    }

    public double getValue(int row, int col) {
        Object value = ((DataCallback)this.m_commonGraph.getDataFilter()).getValue(row, col);
        if (value != null && value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        return 0.0;
    }

    public boolean isAssignedToY2(int seriesID) {
        boolean bY2 = false;
        try {
            bY2 = this.m_commonGraph.getSeries().isAssignedToY2(seriesID);
        }
        catch (SeriesOutOfRangeException seriesOutOfRangeException) {
            // empty catch block
        }
        return bY2;
    }

    private String getIntlString(String key) {
        return this.rBundle.getString(key);
    }

    private void updateAllResource(boolean overwrite) {
        if (this.m_txtGr == null || overwrite) {
            this.m_txtGr = this.getIntlString("af_dvt_graph.LABEL_GROUP");
        }
        if (this.m_txtSe == null || overwrite) {
            this.m_txtSe = this.getIntlString("af_dvt_graph.LABEL_SERIES");
        }
        if (this.m_txtCu == null || overwrite) {
            this.m_txtCu = this.getIntlString("af_dvt_graph.LABEL_CUMULATIVE");
        }
        if (this.m_txtPe == null || overwrite) {
            this.m_txtPe = this.getIntlString("af_dvt_graph.LABEL_PERCENT");
        }
        if (this.m_txtVa == null || overwrite) {
            this.m_txtVa = this.getIntlString("af_dvt_graph.LABEL_VALUE");
        }
        if (this.m_txtOp == null || overwrite) {
            this.m_txtOp = this.getIntlString("af_dvt_graph.LABEL_OPEN");
        }
        if (this.m_txtHi == null || overwrite) {
            this.m_txtHi = this.getIntlString("af_dvt_graph.LABEL_HIGH");
        }
        if (this.m_txtLo == null || overwrite) {
            this.m_txtLo = this.getIntlString("af_dvt_graph.LABEL_LOW");
        }
        if (this.m_txtCl == null || overwrite) {
            this.m_txtCl = this.getIntlString("af_dvt_graph.LABEL_CLOSE");
        }
        if (this.m_txtVo == null || overwrite) {
            this.m_txtVo = this.getIntlString("af_dvt_graph.LABEL_VOLUME");
        }
        if (this.m_txtX == null || overwrite) {
            this.m_txtX = this.getIntlString("af_dvt_graph.LABEL_X");
        }
        if (this.m_txtY == null || overwrite) {
            this.m_txtY = this.getIntlString("af_dvt_graph.LABEL_Y");
        }
        if (this.m_txtZ == null || overwrite) {
            this.m_txtZ = this.getIntlString("af_dvt_graph.LABEL_Z");
        }
        if (this.m_txtBV == null || overwrite) {
            this.m_txtBV = this.getIntlString("af_dvt_graph.LABEL_BASE_LINE_VALUE");
        }
        if (this.m_txtStart == null || overwrite) {
            this.m_txtStart = this.getIntlString("af_dvt_graph.LABEL_START");
        }
        if (this.m_txtEnd == null || overwrite) {
            this.m_txtEnd = this.getIntlString("af_dvt_graph.LABEL_END");
        }
        if (this.m_txtTarget == null || overwrite) {
            this.m_txtTarget = this.getIntlString("af_dvt_graph.LABEL_TARGET");
        }
        if (this.m_txtActual == null || overwrite) {
            this.m_txtActual = this.getIntlString("af_dvt_graph.LABEL_ACTUAL");
        }
        if (this.m_txtCuVa == null || overwrite) {
            this.m_txtCuVa = this.getIntlString("af_dvt_graph.LABEL_CUMULATIVE_VALUE");
        }
        if (this.m_txtCuPe == null || overwrite) {
            this.m_txtCuPe = this.getIntlString("af_dvt_graph.LABEL_CUMULATIVE_PERCENTAGE");
        }
    }

    public void updateResourceBundle() {
        this.rBundle = CommonGraph.getGraphResourceBundle(this.m_commonGraph.getLocale());
        this.m_txtGr = null;
        this.m_txtSe = null;
        this.m_txtCu = null;
        this.m_txtPe = null;
        this.m_txtVa = null;
        this.m_txtOp = null;
        this.m_txtHi = null;
        this.m_txtLo = null;
        this.m_txtCl = null;
        this.m_txtVo = null;
        this.m_txtX = null;
        this.m_txtY = null;
        this.m_txtZ = null;
        this.m_txtBV = null;
        this.m_txtStart = null;
        this.m_txtEnd = null;
        this.m_txtTarget = null;
        this.m_txtActual = null;
        this.m_txtCuVa = null;
        this.m_txtCuPe = null;
    }

    public void setAxisLabelTipDisplayed(boolean yesNo) {
        this.m_AxisLabelTipDisplayed = yesNo;
    }

    @Deprecated
    public void setDataRowShownAsASeries(boolean yesNo) {
        if (this.m_SeriesAreRows != yesNo) {
            boolean temp = this.m_ShowColDimName;
            this.m_ShowColDimName = this.m_ShowRowDimName;
            this.m_ShowRowDimName = temp;
            this.m_SeriesAreRows = yesNo;
        }
    }

    public void setGraphFormatManager(GraphFormatManager m) {
        this.m_fmtMgr = m;
    }

    public void setGraphType(int type) {
        this.m_GraphIsPieBar = false;
        this.m_GraphIsSingleY = true;
        switch (type) {
            case 20: 
            case 22: 
            case 27: 
            case 29: 
            case 34: 
            case 39: 
            case 44: 
            case 46: 
            case 51: 
            case 53: 
            case 98: {
                this.m_GraphIsSingleY = false;
            }
            case 18: 
            case 23: 
            case 25: 
            case 30: 
            case 32: 
            case 35: 
            case 37: 
            case 40: 
            case 42: 
            case 47: 
            case 49: 
            case 54: 
            case 95: 
            case 97: {
                this.m_GraphIsStacked = true;
                this.m_ValuesPerGroup = 1;
                this.m_DataValuesPerMarker = 1;
                break;
            }
            case 96: {
                this.m_GraphIsStacked = true;
                this.m_ValuesPerGroup = 1;
                this.m_DataValuesPerMarker = 1;
                this.m_PercentTip = true;
                break;
            }
            case 93: 
            case 94: {
                this.m_GraphIsPieBar = true;
                this.m_GraphIsStacked = true;
                this.m_ValuesPerGroup = 1;
                this.m_DataValuesPerMarker = 1;
                break;
            }
            case 19: 
            case 21: 
            case 26: 
            case 28: 
            case 33: 
            case 38: 
            case 43: 
            case 45: 
            case 50: 
            case 52: 
            case 69: {
                this.m_GraphIsSingleY = false;
            }
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 24: 
            case 31: 
            case 36: 
            case 41: 
            case 48: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 67: 
            case 68: 
            case 87: 
            case 100: {
                this.m_GraphIsStacked = false;
                this.m_ValuesPerGroup = 1;
                this.m_DataValuesPerMarker = 1;
                break;
            }
            case 62: 
            case 66: 
            case 74: 
            case 75: {
                this.m_GraphIsSingleY = false;
            }
            case 61: 
            case 65: 
            case 73: 
            case 99: {
                this.m_GraphIsOpenAndClose = false;
                this.m_GraphIsStacked = false;
                this.m_ValuesPerGroup = 2;
                this.m_DataValuesPerMarker = 2;
                break;
            }
            case 72: {
                this.m_GraphIsOpenAndClose = true;
                this.m_GraphIsStacked = false;
                this.m_ValuesPerGroup = 2;
                this.m_DataValuesPerMarker = 2;
                break;
            }
            case 64: {
                this.m_GraphIsSingleY = false;
            }
            case 63: 
            case 82: {
                this.m_GraphIsStacked = false;
                this.m_ValuesPerGroup = 3;
                this.m_DataValuesPerMarker = 2;
                break;
            }
            case 84: {
                this.m_GraphIsOpenAndClose = true;
                this.m_GraphIsStacked = false;
                this.m_ValuesPerGroup = 3;
                this.m_DataValuesPerMarker = 2;
                break;
            }
            case 77: 
            case 78: 
            case 91: {
                this.m_GraphIsSingleY = false;
            }
            case 76: 
            case 89: {
                this.m_GraphIsStacked = false;
                this.m_ValuesPerGroup = 3;
                this.m_DataValuesPerMarker = 3;
                break;
            }
            case 92: {
                this.m_GraphIsSingleY = false;
            }
            case 88: 
            case 90: {
                this.m_GraphIsStacked = false;
                this.m_ValuesPerGroup = 4;
                this.m_DataValuesPerMarker = 3;
                break;
            }
            case 80: 
            case 81: {
                this.m_GraphIsSingleY = false;
            }
            case 70: 
            case 79: {
                this.m_GraphIsStacked = false;
                this.m_ValuesPerGroup = 4;
                this.m_DataValuesPerMarker = 4;
                break;
            }
            case 71: 
            case 83: {
                this.m_GraphIsStacked = false;
                this.m_ValuesPerGroup = 5;
                this.m_DataValuesPerMarker = 4;
                break;
            }
            default: {
                this.m_GraphIsStacked = false;
                this.m_ValuesPerGroup = 0;
                this.m_DataValuesPerMarker = 0;
                this.m_commonGraph.getErrorHandler().log("invalid graph type", "oracle.dss.graph.ToolTipTextCallback", "setGraphType(int type)");
            }
        }
    }

    public int getRowID(int series, int group) {
        this._calcRowAndColID(series, group);
        return this.m_RowID;
    }

    public int getColID(int series, int group) {
        this._calcRowAndColID(series, group);
        return this.m_ColID;
    }

    private void _calcRowAndColID(int series, int group) {
        this.m_SeriesID = series;
        this.m_GroupID = group;
        if (this.m_commonGraph.getPFJ().isMixedFreqTimeAxis()) {
            this.m_ValuesPerGroup = 2;
            this.m_DataValuesPerMarker = 2;
        }
        if (this.m_SeriesAreRows) {
            this.m_RowID = this.m_SeriesID;
            this.m_ColID = this.m_GroupID * this.m_ValuesPerGroup;
        } else {
            this.m_RowID = this.m_GroupID * this.m_ValuesPerGroup;
            this.m_ColID = this.m_SeriesID;
        }
    }

    protected void setMarkerTooltipTemplate(String template) {
        this.m_markerTooltipTemplate = ToolTips.convertMarkerTooltipTemplate(template);
    }

    public int getGroupTooltipLabelType() {
        return this.m_TipGroupLabelType;
    }

    public void setGroupTooltipLabelType(int type) {
        if (type < 0 || type > 2) {
            this.m_commonGraph.getErrorHandler().log("invalid tooltip type", "oracle.dss.graph.ToolTipTextCallback", "setGroupTooltipLabelType (int type)");
            return;
        }
        this.m_TipGroupLabelType = type;
        this.m_ShowGroupLabels = type != 0;
        if (this.m_SeriesAreRows) {
            this.m_ShowColDimName = type == 2;
        } else {
            this.m_ShowRowDimName = type == 2;
        }
    }

    public int getMarkerTooltipType() {
        return this.m_MarkerTipType;
    }

    public void setMarkerTooltipType(int type) {
        if (type < 0 || type >= 16) {
            this.m_commonGraph.getErrorHandler().log("invalid tool tip type", "oracle.dss.graph.ToolTipTextCallback", "setMarkerTooltipType(int type)");
            return;
        }
        this.m_MarkerTipType = type;
        this.m_MarkerTipDisplayed = type != 0;
        this.m_TextTip = (type & 8) == 8;
        this.m_ValueTip = (type & 1) == 1;
        this.m_CumValTip = (type & 2) == 2;
        this.m_PercentTip = (type & 4) == 4;
    }

    public int getSeriesTooltipLabelType() {
        return this.m_TipSeriesLabelType;
    }

    public void setSeriesTooltipLabelType(int type) {
        if (type < 0 || type > 2) {
            this.m_commonGraph.getErrorHandler().log("invalid tooltip type", "oracle.dss.graph.ToolTipTextCallback", "setSeriesTooltipLabelType (int type)");
            return;
        }
        this.m_TipSeriesLabelType = type;
        this.m_ShowSeriesLabels = type != 0;
        if (this.m_SeriesAreRows) {
            this.m_ShowRowDimName = type == 2;
        } else {
            this.m_ShowColDimName = type == 2;
        }
    }

    protected int calcDateFreq(Date date) {
        GregorianCalendar calendar = new GregorianCalendar(this.m_commonGraph.getLocale());
        calendar.setTime(date);
        int dateFreq = -1;
        dateFreq = calendar.get(14) > 0 ? 6 : (calendar.get(13) > 0 ? 6 : (calendar.get(12) > 0 ? 5 : (calendar.get(11) > 0 ? 4 : (calendar.get(5) > 1 ? 2 : (calendar.get(2) > 0 ? 1 : 0)))));
        return dateFreq;
    }

    public String convertDateToString(Object obj) {
        if (obj instanceof Date) {
            Date date = (Date)obj;
            PFJ pfj = this.m_commonGraph.getPFJ();
            int dateFreq = pfj.getDateFrequency();
            return this.formatDate(date, dateFreq);
        }
        return obj.toString();
    }

    private static boolean is12HFormat(Locale locale) {
        if (locale == null) {
            return true;
        }
        Date testDate = new Date(1030155120000L);
        DateFormat format = DateFormat.getTimeInstance(3, locale);
        String testStr = format.format(testDate);
        DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(locale);
        String[] ampmString = dateFormatSymbols.getAmPmStrings();
        return testStr.contains(ampmString[1]);
    }

    protected String formatDate(Date date, int dateFreq) {
        String yearFormat;
        String monthFormat;
        String language;
        String dmyOrder;
        PFJ pfj;
        block64: {
            String yearFormat2;
            String dayFormat;
            block63: {
                pfj = this.m_commonGraph.getPFJ();
                dmyOrder = pfj.getDMYOrder(pfj.getLocale());
                Locale locale = this.m_commonGraph.getPFJ().getLocale();
                language = "";
                if (locale != null) {
                    language = locale.getLanguage();
                }
                if (pfj.isContinuousTimeAxis()) {
                    if (dateFreq == 0) {
                        dateFreq = 1;
                    } else if (dateFreq == 1) {
                        dateFreq = 2;
                    } else if (dateFreq == 2) {
                        dateFreq = 4;
                    } else if (dateFreq == 4) {
                        dateFreq = 5;
                    } else if (dateFreq == 5) {
                        dateFreq = 6;
                    }
                }
                if (dateFreq == 0) {
                    String yearFormat3 = this.m_commonGraph.getTimeAxisDateFormat(0);
                    if (yearFormat3.equals("AUTO") || yearFormat3.equals("NONE")) {
                        yearFormat3 = "YYYY";
                    }
                    return pfj.formatDate(date, 0, yearFormat3);
                }
                if (dateFreq == 1) {
                    String monthFormat2 = this.m_commonGraph.getTimeAxisDateFormat(1);
                    if (monthFormat2.equals("AUTO") || monthFormat2.equals("NONE")) {
                        monthFormat2 = "Month";
                    }
                    String str = pfj.formatDate(date, 1, monthFormat2);
                    String yearFormat4 = this.m_commonGraph.getTimeAxisDateFormat(0);
                    if (yearFormat4.equals("NONE")) {
                        yearFormat4 = null;
                    } else if (yearFormat4.equals("AUTO")) {
                        yearFormat4 = "YYYY";
                    }
                    if (yearFormat4 != null) {
                        str = pfj.isYearLast(dmyOrder) ? str + " " + pfj.formatDate(date, 0, yearFormat4) : pfj.formatDate(date, 0, yearFormat4) + " " + str;
                    }
                    return str;
                }
                if (dateFreq == 7) {
                    String quarterFormat = this.m_commonGraph.getTimeAxisDateFormat(4);
                    if (quarterFormat.equals("AUTO") || quarterFormat.equals("NONE")) {
                        quarterFormat = "Q";
                    }
                    return pfj.formatDate(date, 4, quarterFormat);
                }
                if (dateFreq == 2) break block63;
                if (dateFreq != 3) break block64;
            }
            if ((dayFormat = this.m_commonGraph.getTimeAxisDateFormat(2)).equals("AUTO") || dayFormat.equals("NONE")) {
                String checkMonthFormat = this.m_commonGraph.getTimeAxisDateFormat(1);
                dayFormat = !(!language.equals("zh") && !language.equals("ja") && !language.equals("ko") || !checkMonthFormat.equals("AUTO") && !checkMonthFormat.equals("Month") && !checkMonthFormat.equals("Mon")) ? "DDTC" : "DD";
            }
            String str = pfj.formatDate(date, 2, dayFormat);
            String monthFormat3 = this.m_commonGraph.getTimeAxisDateFormat(1);
            if (monthFormat3.equals("NONE")) {
                monthFormat3 = null;
            } else if (monthFormat3.equals("AUTO")) {
                monthFormat3 = "Month";
            }
            if (monthFormat3 != null) {
                str = pfj.isDayMonth(dmyOrder) ? str + " " + pfj.formatDate(date, 1, monthFormat3) : pfj.formatDate(date, 1, monthFormat3) + " " + str;
            }
            if ((yearFormat2 = this.m_commonGraph.getTimeAxisDateFormat(0)).equals("NONE")) {
                yearFormat2 = null;
            } else if (yearFormat2.equals("AUTO")) {
                yearFormat2 = "YYYY";
            }
            if (yearFormat2 != null) {
                str = pfj.isYearLast(dmyOrder) ? str + " " + pfj.formatDate(date, 0, yearFormat2) : pfj.formatDate(date, 0, yearFormat2) + " " + str;
            }
            return str;
        }
        boolean ampm = ToolTipTextCallback.is12HFormat(this.m_commonGraph.getLocale());
        String str = "";
        String dayFormat = this.m_commonGraph.getTimeAxisDateFormat(2);
        if (dayFormat.equals("NONE")) {
            dayFormat = null;
        } else if (dayFormat.equals("AUTO")) {
            String checkMonthFormat = this.m_commonGraph.getTimeAxisDateFormat(1);
            dayFormat = !(!language.equals("zh") && !language.equals("ja") && !language.equals("ko") || !checkMonthFormat.equals("AUTO") && !checkMonthFormat.equals("Month") && !checkMonthFormat.equals("Mon")) ? "DDTC" : "DD";
        }
        if (dayFormat != null) {
            str = this.getCachedFormatStr(date, 2, dayFormat, pfj);
        }
        if ((monthFormat = this.m_commonGraph.getTimeAxisDateFormat(1)).equals("NONE")) {
            monthFormat = null;
        } else if (monthFormat.equals("AUTO")) {
            monthFormat = "Month";
        }
        if (monthFormat != null) {
            String monthStr = this.getCachedFormatStr(date, 1, monthFormat, pfj);
            str = pfj.isDayMonth(dmyOrder) ? str + " " + monthStr : monthStr + " " + str;
        }
        if ((yearFormat = this.m_commonGraph.getTimeAxisDateFormat(0)).equals("NONE")) {
            yearFormat = null;
        } else if (yearFormat.equals("AUTO")) {
            yearFormat = "YYYY";
        }
        if (yearFormat != null) {
            String yearStr = this.getCachedFormatStr(date, 0, yearFormat, pfj);
            str = pfj.isYearLast(dmyOrder) ? str + " " + yearStr : yearStr + " " + str;
        }
        boolean bAutoTime = false;
        String timeFormat = this.m_commonGraph.getTimeAxisDateFormat(3);
        if (dateFreq == 4) {
            if (timeFormat.equals("AUTO") || timeFormat.equals("NONE")) {
                bAutoTime = true;
                timeFormat = ampm ? "HH:MI" : "HH24:MI";
            }
        } else if (dateFreq == 5) {
            if (timeFormat.equals("AUTO") || timeFormat.equals("NONE")) {
                bAutoTime = true;
                timeFormat = ampm ? "HH:MI" : "HH24:MI";
            } else if (timeFormat.equals("HH")) {
                timeFormat = "HH:MI";
            } else if (timeFormat.equals("HH24")) {
                timeFormat = "HH24:MI";
            }
        } else if (dateFreq == 6) {
            if (timeFormat.equals("AUTO") || timeFormat.equals("NONE")) {
                bAutoTime = true;
                timeFormat = ampm ? "HH:MI:SS" : "HH24:MI:SS";
            } else if (timeFormat.equals("HH") || timeFormat.equals("HH:MI")) {
                timeFormat = "HH:MI:SS";
            } else if (timeFormat.equals("HH24") || timeFormat.equals("HH24:MI")) {
                timeFormat = "HH24:MI:SS";
            }
        }
        if (bAutoTime && ampm || !bAutoTime && (timeFormat.equals("HH") || timeFormat.equals("HH:MI") || timeFormat.equals("HH:MI:SS"))) {
            timeFormat = this.m_commonGraph.getPFJ().combineCJKAMPMTime(timeFormat, "AM");
        }
        str = str + " " + this.getCachedFormatStr(date, 3, timeFormat, pfj);
        return str;
    }

    private String getCachedFormatStr(Date date, int element, String format, Perspective pfj) {
        String key = "";
        switch (element) {
            case 2: {
                if (format == "DD" || format == "DDTC" || format != null && (format.equals("DD") || format.equals("DDTC"))) {
                    key = String.valueOf(date.getDate()) + format;
                    break;
                }
                key = String.valueOf(date.getDay()) + format;
                break;
            }
            case 1: {
                key = String.valueOf(date.getMonth()) + format;
                break;
            }
            case 0: {
                key = String.valueOf(date.getYear()) + format;
                break;
            }
            case 3: {
                key = String.valueOf(date.getTime()) + format;
                break;
            }
            default: {
                return pfj.formatDate(date, element, format);
            }
        }
        if (this.m_formatStrCache.containsKey(key)) {
            return (String)this.m_formatStrCache.get(key);
        }
        String str = pfj.formatDate(date, element, format);
        this.m_formatStrCache.put(key, str);
        return str;
    }

    public CustomToolTipCallback getCustomToolTipCallback() {
        return this.m_customToolTipCallback;
    }

    protected void setCustomToolTipCallback(CustomToolTipCallback callback) {
        this.m_customToolTipCallback = callback;
    }

    protected String getWrappedText(String obj) {
        if (obj == null) {
            return obj;
        }
        Graphics gc = this.m_commonGraph.getPFJ().getGraphicsContext();
        if (gc == null) {
            return obj;
        }
        String wrappedString = "";
        Font font = new Font("SansSerif", 0, 10);
        FontMetrics fm = gc.getFontMetrics(font);
        VC vc = this.m_commonGraph.getPFJ().getVC();
        Vector subStrings = new Vector();
        TextStyleObj tsObj = new TextStyleObj(null, null, 0, false, 0, 0, 0, 0, 0, false, false, false);
        tsObj.extractLinesWordWrap(obj.toString(), subStrings, vc.virtToDestWidth(32000 - vc.destToVirtWidth(20)), fm, this.m_commonGraph.getPFJ().getFontMetricsResolver());
        for (int i = 0; i < subStrings.size(); ++i) {
            wrappedString = wrappedString + (String)subStrings.elementAt(i) + "[R]";
        }
        return wrappedString;
    }

    public String getToolTipTemplate() {
        StringBuilder tt = DataviewUtils.getSharedStringBuilder();
        this.m_SeriesID = 0;
        this.m_GroupID = 0;
        this.m_excelOrDeskTop = this.m_commonGraph.isExcelOrDeskTop();
        if (this.m_excelOrDeskTop) {
            return null;
        }
        this._calcRowAndColID(this.m_SeriesID, this.m_GroupID);
        this.updateAllResource(false);
        if (this.m_markerTooltipTemplate != null) {
            return this.m_markerTooltipTemplate;
        }
        try {
            if (this.m_commonGraph.getPFJ().isChartBLAType() || this.m_commonGraph.getPFJ().isChartScatter() || this.m_commonGraph.getPFJ().isChartBubble() || this.m_commonGraph.getPFJ().getJGraphType().isPolar() || this.m_commonGraph.getPFJ().getJGraphType().isRadarType()) {
                if (this.m_MarkerTipDisplayed) {
                    if (this.m_TextTip) {
                        if (this.m_ShowSeriesLabels) {
                            tt.append("[S][R]");
                        }
                        if (this.m_ShowGroupLabels && !this.m_commonGraph.getPFJ().isMixedFreqTimeAxis()) {
                            tt.append("[G][R]");
                        }
                    }
                    if (this.m_ValueTip) {
                        switch (this.m_DataValuesPerMarker) {
                            case 1: {
                                String yValueLabel = this.getValueLabelTemplate(this.m_RowID, this.m_ColID, 0, "[YM]");
                                if (yValueLabel == null) {
                                    yValueLabel = this.m_txtVa;
                                }
                                tt.append(MessageFormat.format(yValueLabel, "[Y]")).append("[R]");
                                break;
                            }
                            case 2: {
                                String yValueLabel;
                                String xValueLabel = this.getValueLabelTemplate(this.m_RowID, this.m_ColID, 0, "[XM]");
                                if (xValueLabel == null) {
                                    xValueLabel = this.m_txtX;
                                }
                                if ((yValueLabel = this.getValueLabelTemplate(this.m_RowID, this.m_ColID, 1, "[YM]")) == null) {
                                    yValueLabel = this.m_txtY;
                                }
                                tt.append(MessageFormat.format(xValueLabel, "[X]")).append("[R]").append(MessageFormat.format(yValueLabel, "[Y]")).append("[R]");
                                break;
                            }
                            case 3: {
                                String zValueLabel;
                                String yValueLabel;
                                String xValueLabel = this.getValueLabelTemplate(this.m_RowID, this.m_ColID, 0, "[XM]");
                                if (xValueLabel == null) {
                                    xValueLabel = this.m_txtX;
                                }
                                if ((yValueLabel = this.getValueLabelTemplate(this.m_RowID, this.m_ColID, 1, "[YM]")) == null) {
                                    yValueLabel = this.m_txtY;
                                }
                                if ((zValueLabel = this.getValueLabelTemplate(this.m_RowID, this.m_ColID, 2, "[ZM]")) == null) {
                                    zValueLabel = this.m_txtZ;
                                }
                                tt.append(MessageFormat.format(xValueLabel, "[X]")).append("[R]").append(MessageFormat.format(yValueLabel, "[Y]")).append("[R]").append(MessageFormat.format(zValueLabel, "[Z]")).append("[R]");
                                break;
                            }
                        }
                    }
                    if (this.m_GraphIsStacked && this.m_CumValTip) {
                        switch (this.m_commonGraph.getGraphType()) {
                            case 23: 
                            case 30: 
                            case 35: 
                            case 40: 
                            case 47: 
                            case 54: {
                                return null;
                            }
                        }
                        tt.append(MessageFormat.format(this.m_txtCu, "[CUMSTKV]"));
                    }
                } else {
                    return null;
                }
                if (this.m_PercentTip) {
                    return null;
                }
            } else if (this.m_commonGraph.getPFJ().isChartPieType() && this.m_MarkerTipDisplayed) {
                if (this.m_TextTip) {
                    if (this.m_ShowSeriesLabels) {
                        tt.append("[S][R]");
                    }
                    if (this.m_ShowGroupLabels && !this.m_GraphIsPieBar) {
                        tt.append("[G][R]");
                    }
                }
                if (this.m_ValueTip) {
                    String valueLabel = this.getValueLabelTemplate(this.m_RowID, this.m_ColID, 0, "[YM]");
                    if (valueLabel == null) {
                        valueLabel = this.m_txtVa;
                    }
                    tt.append(MessageFormat.format(valueLabel, "[Y]")).append("[R]");
                }
                if (this.m_PercentTip) {
                    String[] percentStrings = this.m_commonGraph.getPFJ().getPercentSign();
                    tt.append(MessageFormat.format(this.m_txtPe, "[PIEPCTV]"));
                }
            } else if (this.m_commonGraph.getPFJ().isChartFunnelType() && this.m_MarkerTipDisplayed) {
                if (this.m_TextTip && this.m_ShowGroupLabels) {
                    tt.append("[G][R]");
                }
                if (this.m_ValueTip) {
                    String yValueLabel;
                    String xValueLabel = this.getValueLabelTemplate(this.m_RowID, this.m_ColID, 0, "[XM]");
                    if (xValueLabel == null) {
                        xValueLabel = this.m_txtActual;
                    }
                    if ((yValueLabel = this.getValueLabelTemplate(this.m_RowID, this.m_ColID, 1, "[YM]")) == null) {
                        yValueLabel = this.m_txtTarget;
                    }
                    tt.append(MessageFormat.format(xValueLabel, "[AV]") + "[R]" + MessageFormat.format(yValueLabel, "[TV]"));
                }
                if (this.m_PercentTip) {
                    String[] percentStrings = this.m_commonGraph.getPFJ().getPercentSign();
                    tt.append("[R]");
                    tt.append(MessageFormat.format(this.m_txtPe, "[PIEPCTV]"));
                }
            } else if (this.m_commonGraph.getPFJ().isChartStockType() && this.m_MarkerTipDisplayed && this.m_MarkerTipDisplayed) {
                if (this.m_TextTip) {
                    if (this.m_ShowSeriesLabels) {
                        tt.append("[S][R]");
                    }
                    if (this.m_ShowGroupLabels) {
                        tt.append("[G][R]");
                    }
                }
                if (this.m_ValueTip) {
                    switch (this.m_DataValuesPerMarker) {
                        case 2: {
                            String lValueLabel;
                            if (this.m_GraphIsOpenAndClose) {
                                String cValueLabel;
                                String oValueLabel = this.getValueLabelTemplate(this.m_RowID, this.m_ColID, 0, "[OM]");
                                if (oValueLabel == null) {
                                    oValueLabel = this.m_txtOp;
                                }
                                if ((cValueLabel = this.getValueLabelTemplate(this.m_RowID, this.m_ColID, 1, "[CM]")) == null) {
                                    cValueLabel = this.m_txtCl;
                                }
                                tt.append(MessageFormat.format(oValueLabel, "[OV]")).append("[R]").append(MessageFormat.format(cValueLabel, "[CV]"));
                                break;
                            }
                            String hValueLabel = this.getValueLabelTemplate(this.m_RowID, this.m_ColID, 0, "[HM]");
                            if (hValueLabel == null) {
                                hValueLabel = this.m_txtHi;
                            }
                            if ((lValueLabel = this.getValueLabelTemplate(this.m_RowID, this.m_ColID, 1, "[LM]")) == null) {
                                lValueLabel = this.m_txtLo;
                            }
                            tt.append(MessageFormat.format(hValueLabel, "[HV]")).append("[R]").append(MessageFormat.format(lValueLabel, "[LV]"));
                            break;
                        }
                        case 3: {
                            String cValueLabel;
                            String lValueLabel;
                            String hValueLabel = this.getValueLabelTemplate(this.m_RowID, this.m_ColID, 0, "[HM]");
                            if (hValueLabel == null) {
                                hValueLabel = this.m_txtHi;
                            }
                            if ((lValueLabel = this.getValueLabelTemplate(this.m_RowID, this.m_ColID, 1, "[LM]")) == null) {
                                lValueLabel = this.m_txtLo;
                            }
                            if ((cValueLabel = this.getValueLabelTemplate(this.m_RowID, this.m_ColID, 2, "[CM]")) == null) {
                                cValueLabel = this.m_txtCl;
                            }
                            tt.append(MessageFormat.format(hValueLabel, "[HV]")).append("[R]").append(MessageFormat.format(lValueLabel, "[LV]")).append("[R]").append(MessageFormat.format(cValueLabel, "[CV]"));
                            break;
                        }
                        case 4: {
                            String cValueLabel;
                            String lValueLabel;
                            String hValueLabel;
                            String oValueLabel = this.getValueLabelTemplate(this.m_RowID, this.m_ColID, 0, "[OM]");
                            if (oValueLabel == null) {
                                oValueLabel = this.m_txtOp;
                            }
                            if ((hValueLabel = this.getValueLabelTemplate(this.m_RowID, this.m_ColID, 1, "[HM]")) == null) {
                                hValueLabel = this.m_txtHi;
                            }
                            if ((lValueLabel = this.getValueLabelTemplate(this.m_RowID, this.m_ColID, 2, "[LM]")) == null) {
                                lValueLabel = this.m_txtLo;
                            }
                            if ((cValueLabel = this.getValueLabelTemplate(this.m_RowID, this.m_ColID, 3, "[CM]")) == null) {
                                cValueLabel = this.m_txtCl;
                            }
                            tt.append(MessageFormat.format(oValueLabel, "[OV]")).append("[R]").append(MessageFormat.format(hValueLabel, "[HV]")).append("[R]").append(MessageFormat.format(lValueLabel, "[LV]")).append("[R]").append(MessageFormat.format(cValueLabel, "[CV]"));
                            break;
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            this.m_commonGraph.getErrorHandler().error((Throwable)e, this.getClass().getName(), "getToolTipTemplate");
        }
        return tt.toString();
    }

    protected class DimValuePairs {
        public String dim;
        public String value;

        public DimValuePairs() {
            this.dim = null;
            this.value = null;
        }

        public DimValuePairs(String inDim, String inValue) {
            this.dim = inDim;
            this.value = inValue;
        }

        public boolean equals(DimValuePairs dvp) {
            return this.dim.equals(dvp.dim) && this.value.equals(dvp.value);
        }
    }
}

