/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import java.awt.Color;
import java.util.Date;
import java.util.HashMap;
import oracle.dss.dataView.Fill;
import oracle.dss.graph.BaseGraphComponent;
import oracle.dss.graph.CommonGraph;
import oracle.dss.graph.SFX;
import oracle.dss.graph.pfj.Attr;
import oracle.dss.util.xml.ContainerNode;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public class TimeSelector
extends BaseGraphComponent
implements Fill {
    protected SFX m_sfx;

    public TimeSelector(CommonGraph graph) {
        super(graph);
        this.m_identObj = this.m_pfj.getTimeSelector();
    }

    public SFX getSFX() {
        if (this.m_sfx == null) {
            this.m_sfx = new SFX(this.m_commonGraph, this.m_identObj);
        }
        return this.m_sfx;
    }

    @Override
    public boolean selectObject(int series, int group) {
        this.m_pfj.setSelection(this.m_identObj);
        return this.m_identObj.equals(this.m_pfj.getSelectionID());
    }

    public void setMode(int mode) {
        if (mode < 0 || mode > 1) {
            this.m_commonGraph.getErrorHandler().log("invalid mode", this.getClass().getName(), "setMode(int mode)");
            return;
        }
        this.m_pfj.setIntegerProp(mode, Attr.TimeSelectorMode);
    }

    public int getMode() {
        return this.m_pfj.getIntegerProp(Attr.TimeSelectorMode);
    }

    public void setExplicitStart(Date date) {
        this.m_pfj.setObjProp(date, Attr.ExplicitTimeSelectorStart);
    }

    public Date getExplicitStart() {
        return (Date)this.m_pfj.getObjProp(Attr.ExplicitTimeSelectorStart);
    }

    public void setExplicitEnd(Date date) {
        this.m_pfj.setObjProp(date, Attr.ExplicitTimeSelectorEnd);
    }

    public Date getExplicitEnd() {
        return (Date)this.m_pfj.getObjProp(Attr.ExplicitTimeSelectorEnd);
    }

    @Override
    public Color getFillColor() {
        return this.m_pfj.getFillColor(this.m_identObj);
    }

    @Override
    public void setFillColor(Color newColor) {
        if (newColor == null) {
            this.m_commonGraph.getErrorHandler().log("invalid Color value", this.getClass().toString(), "setFillColor( Color newColor)");
            return;
        }
        this.m_pfj.setFillColor(this.m_identObj, newColor);
    }

    public Color getBorderColor() {
        return this.m_pfj.getBorderColor(this.m_identObj);
    }

    public void setBorderColor(Color newColor) {
        if (newColor == null) {
            this.m_commonGraph.getErrorHandler().log("invalid Color value", this.getClass().toString(), "setBorderColor( Color newColor)");
            return;
        }
        this.m_pfj.setBorderColor(this.m_identObj, newColor);
    }

    @Override
    public boolean isFillTransparent() {
        return this.m_pfj.getTransparentFillColor(this.m_identObj);
    }

    @Override
    public void setFillTransparent(boolean yesNo) {
        this.m_pfj.setTransparentFillColor(this.m_identObj, yesNo);
    }

    public boolean isBorderTransparent() {
        return this.m_pfj.getTransparentBorderColor(this.m_identObj);
    }

    public void setBorderTransparent(boolean yesNo) {
        this.m_pfj.setTransparentBorderColor(this.m_identObj, yesNo);
    }

    @Override
    protected String getComponentName() {
        return "TimeSelector";
    }

    protected ObjectNode getXML(boolean allProperties, boolean allOverriddenProperties) {
        boolean nodeExists = false;
        ObjectNode node = this.getStyleXML(allProperties, allOverriddenProperties);
        if (node == null) {
            node = new ObjectNode(this.getComponentName());
        } else {
            nodeExists = true;
        }
        return (nodeExists |= this.getNonstyleXML(allProperties, node)) ? node : null;
    }

    @Override
    public boolean getNonstyleXML(boolean allProperties, ObjectNode node) {
        boolean nodeExists = super.getNonstyleXML(allProperties, node);
        Object val = this.m_pfj.getObjProp(Attr.TimeSelectorMode);
        if (val != null) {
            int tmp = (Integer)val;
            if (tmp == 0) {
                node.addProperty("mode", "TSM_OFF");
                nodeExists = true;
            } else if (tmp == 1) {
                node.addProperty("mode", "TSM_EXPLICIT");
                nodeExists = true;
            }
        }
        if ((val = this.m_pfj.getObjProp(Attr.ExplicitTimeSelectorStart)) != null) {
            node.addProperty("explicitStart", ((Date)val).getTime());
            nodeExists = true;
        }
        if ((val = this.m_pfj.getObjProp(Attr.ExplicitTimeSelectorEnd)) != null) {
            node.addProperty("explicitEnd", ((Date)val).getTime());
            nodeExists = true;
        }
        return nodeExists;
    }

    protected ObjectNode getStyleXML(boolean allProperties, boolean allOverriddenProperties) {
        ContainerNode sfxNode;
        ObjectNode node = new ObjectNode(this.getComponentName());
        boolean nodeExists = false;
        Object val = this.getFillColor();
        if (val != null) {
            node.addProperty("fillColor", TimeSelector.toHexString(((Color)val).getRGB()));
            nodeExists = true;
        }
        if ((val = this.m_pfj.getTransparentFillColorObj(this.m_identObj)) != null) {
            node.addProperty("fillTransparent", ((Boolean)val).booleanValue());
            nodeExists = true;
        }
        if ((val = this.getBorderColor()) != null) {
            node.addProperty("borderColor", TimeSelector.toHexString(((Color)val).getRGB()));
            nodeExists = true;
        }
        if ((val = this.m_pfj.getTransparentBorderColorObj(this.m_identObj)) != null) {
            node.addProperty("borderTransparent", ((Boolean)val).booleanValue());
            nodeExists = true;
        }
        if ((sfxNode = this.getSFX().getXML(allProperties, allOverriddenProperties)) != null) {
            node.addContainer(sfxNode);
            nodeExists = true;
        }
        return nodeExists ? node : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setXML(ObjectNode node, boolean allProperties, HashMap map) {
        this.m_jsfHashMap = map;
        try {
            this.setXML(node, allProperties);
        }
        finally {
            this.m_jsfHashMap = null;
        }
    }

    protected void setXML(ObjectNode node, boolean allProperties) {
        this.setNonStyleXML(node);
        this.setStyleXML(node, allProperties);
    }

    protected void setNonStyleXML(ObjectNode node) {
        PropertyNode pNode = node.getProperty("mode");
        if (pNode != null) {
            String tmp = pNode.getValueAsString();
            int tsm = 0;
            if (tmp.equals("TSM_EXPLICIT")) {
                tsm = 1;
            }
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("mode", new Integer(tsm));
            } else {
                this.setMode(tsm);
            }
        }
        if ((pNode = node.getProperty("explicitStart")) != null) {
            long val = pNode.getValueAsLong();
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("explicitStart", new Date(val));
            } else {
                this.setExplicitStart(new Date(val));
            }
        }
        if ((pNode = node.getProperty("explicitEnd")) != null) {
            long val = pNode.getValueAsLong();
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("explicitEnd", new Date(val));
            } else {
                this.setExplicitEnd(new Date(val));
            }
        }
    }

    protected void setStyleXML(ObjectNode node, boolean allProperties) {
        ContainerNode sfx;
        Color c;
        PropertyNode pNode = node.getProperty("fillColor");
        if (pNode != null) {
            c = new Color(BaseGraphComponent.hexStringToInt(pNode.getValueAsString()), true);
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("fillColor", c);
            } else {
                this.setFillColor(c);
            }
        }
        if ((pNode = node.getProperty("borderColor")) != null) {
            c = new Color(BaseGraphComponent.hexStringToInt(pNode.getValueAsString()), true);
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("borderColor", c);
            } else {
                this.setBorderColor(c);
            }
        }
        if ((sfx = node.getContainer("SFX")) != null) {
            this.getSFX().setXML(sfx, allProperties);
        }
        if ((pNode = node.getProperty("fillTransparent")) != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("fillTransparent", new Boolean(pNode.getValueAsBoolean()));
            } else {
                this.setFillTransparent(pNode.getValueAsBoolean());
            }
        }
        if ((pNode = node.getProperty("borderTransparent")) != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("borderTransparent", new Boolean(pNode.getValueAsBoolean()));
            } else {
                this.setBorderTransparent(pNode.getValueAsBoolean());
            }
        }
    }

    protected void resetToDefault() {
    }

    protected void resetStyle() {
        this.setFillColor((Color)Attr.TimeSelectorFillColor.getDefault());
        this.setBorderColor((Color)Attr.TimeSelectorBorderColor.getDefault());
        this.setFillTransparent(false);
        this.setBorderTransparent(false);
        if (this.m_sfx != null) {
            this.getSFX().resetStyle();
        }
    }
}

