/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import java.util.HashMap;
import oracle.dss.dataView.managers.ViewFormat;
import oracle.dss.dataView.managers.ViewFormatCallback;
import oracle.dss.graph.BaseText;
import oracle.dss.graph.CommonGraph;
import oracle.dss.graph.pfj.Attr;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public class MarkerText
extends BaseText
implements ViewFormatCallback {
    protected static final String ViewFormat_Name = "ViewFormat";
    public static final String X1ViewFormat_Name = "X1ViewFormat";
    public static final String Y1ViewFormat_Name = "Y1ViewFormat";
    public static final String Y2ViewFormat_Name = "Y2ViewFormat";
    public static final String ZViewFormat_Name = "ZViewFormat";
    public static final String StockVolumeViewFormat_Name = "StockVolumeViewFormat";
    protected ViewFormat m_viewFormatX1;
    protected ViewFormat m_viewFormatY1;
    protected ViewFormat m_viewFormatY2;
    protected ViewFormat m_viewFormatZ;
    protected ViewFormat m_viewFormatStockVolume;
    private static final String m_method_setViewFormat = "setViewFormat(ViewFormat viewFormat)";

    public MarkerText(CommonGraph graph) {
        super(graph);
        this.m_identObj = this.m_pfj.getDataText();
        this.init();
    }

    public void resetToDefault() {
        this.init();
    }

    @Override
    public boolean selectObject(int series, int group) {
        if (series >= 0 && group >= 0) {
            IdentObj identObj = new IdentObj(this.m_identObj);
            identObj.setSeriesID(series);
            identObj.setGroupID(group);
            this.m_pfj.setSelection(identObj);
            if (identObj.equals(this.m_pfj.getSelectionID())) {
                return true;
            }
        }
        return false;
    }

    public int getMarkerTextAngleDefault() {
        return this.m_pfj.getDataTextAngleDefault();
    }

    public void setMarkerTextAngleDefault(int angle) {
        if (angle < 0 || angle > 360) {
            this.m_commonGraph.getErrorHandler().log("invalid value for MarkerTextAngleDefault", this.getClass().getName(), "setMarkerTextAngleDefault(int angle)");
        } else {
            this.m_pfj.setDataTextAngleDefault(angle);
        }
    }

    public int getMarkerTextPlace() {
        return this.m_pfj.getDataTextPosition();
    }

    public void setMarkerTextPlace(int place) {
        if (place < 0 || place > 6) {
            this.m_commonGraph.getErrorHandler().log("invalid placement", "oracle.dss.graph.MarkerText", "setMarkerTextPlace(int place)");
        } else {
            this.m_pfj.setDataTextPosition(place);
        }
    }

    public int getMarkerTextRadiusDefault() {
        return this.m_pfj.getDataTextRadiusDefault();
    }

    public void setMarkerTextRadiusDefault(int dist) {
        if (dist < 0 || dist > 100) {
            this.m_commonGraph.getErrorHandler().log("invalid value for MarkerTextRadiusDefault", this.getClass().getName(), "setMarkerTextRadiusDefault(int dist)");
        } else {
            this.m_pfj.setDataTextRadiusDefault(dist);
        }
    }

    public ViewFormat getViewFormat(int value) {
        switch (value) {
            case 0: {
                return this.m_viewFormatX1;
            }
            case 1: {
                return this.m_viewFormatY1;
            }
            case 2: {
                return this.m_viewFormatY2;
            }
            case 3: {
                return this.m_viewFormatZ;
            }
            case 4: {
                return this.m_viewFormatStockVolume;
            }
        }
        return null;
    }

    public void setViewFormat(ViewFormat viewFormat, int value) {
        if (viewFormat == null) {
            this.m_commonGraph.getErrorHandler().log("invalid ViewFormat", this.getClass().getName(), m_method_setViewFormat);
            return;
        }
        switch (value) {
            case 0: {
                this.m_viewFormatX1 = (ViewFormat)((Object)viewFormat.clone());
                this.m_viewFormatX1.setViewFormatCallback(this);
                this.m_viewFormatX1.setView(this.m_commonGraph);
                break;
            }
            case 1: {
                this.m_viewFormatY1 = (ViewFormat)((Object)viewFormat.clone());
                this.m_viewFormatY1.setViewFormatCallback(this);
                this.m_viewFormatY1.setView(this.m_commonGraph);
                break;
            }
            case 2: {
                this.m_viewFormatY2 = (ViewFormat)((Object)viewFormat.clone());
                this.m_viewFormatY2.setViewFormatCallback(this);
                this.m_viewFormatY2.setView(this.m_commonGraph);
                break;
            }
            case 3: {
                this.m_viewFormatZ = (ViewFormat)((Object)viewFormat.clone());
                this.m_viewFormatZ.setViewFormatCallback(this);
                this.m_viewFormatZ.setView(this.m_commonGraph);
                break;
            }
            case 4: {
                this.m_viewFormatStockVolume = (ViewFormat)((Object)viewFormat.clone());
                this.m_viewFormatStockVolume.setViewFormatCallback(this);
                this.m_viewFormatStockVolume.setView(this.m_commonGraph);
                break;
            }
            default: {
                this.m_commonGraph.getErrorHandler().log("invalid value", "oracle.dss.graph.MarkerText", "setViewFormat(ViewFormat viewFormat, int value)");
            }
        }
        this.m_pfj.needRecalc();
    }

    public void formatChanged(int attributeId, String attributeName, Object oldValue, Object newValue) {
        this.m_pfj.needRecalc();
    }

    public boolean isVisible() {
        return this.m_pfj.getDisplay(this.m_identObj);
    }

    public void setVisible(boolean yesNo) {
        this.m_pfj.setDisplay(this.m_identObj, yesNo);
    }

    protected String convertMarkerTextPlaceToString(int textPlace) {
        String str = "";
        switch (textPlace) {
            case 0: {
                str = "MTP_CUSTOM";
                break;
            }
            case 1: {
                str = "MTP_OUTSIDE_MAX";
                break;
            }
            case 2: {
                str = "MTP_ON_MAXEDGE";
                break;
            }
            case 3: {
                str = "MTP_INSIDE_MAX";
                break;
            }
            case 4: {
                str = "MTP_CENTER";
                break;
            }
            case 5: {
                str = "MTP_INSIDE_MIN";
                break;
            }
            case 6: {
                str = "MTP_UNDER_MARKER";
            }
        }
        return str;
    }

    public static int convertMarkerTextPlaceToInt(String str) {
        int textPlace = 0;
        if (str.equals("MTP_CUSTOM")) {
            textPlace = 0;
        } else if (str.equals("MTP_OUTSIDE_MAX")) {
            textPlace = 1;
        } else if (str.equals("MTP_ON_MAXEDGE")) {
            textPlace = 2;
        } else if (str.equals("MTP_INSIDE_MAX")) {
            textPlace = 3;
        } else if (str.equals("MTP_CENTER")) {
            textPlace = 4;
        } else if (str.equals("MTP_INSIDE_MIN")) {
            textPlace = 5;
        } else if (str.equals("MTP_UNDER_MARKER")) {
            textPlace = 6;
        }
        return textPlace;
    }

    protected ObjectNode getX1ViewFormatXML(boolean allProperties) {
        ObjectNode node = new ObjectNode(X1ViewFormat_Name);
        boolean nodeExists = false;
        if ((allProperties || this.getViewFormat(0) != null) && this.getViewFormat(0).getXML(allProperties) != null) {
            node.addProperty(this.getViewFormat(0).getXML(allProperties));
            nodeExists = true;
        }
        if (nodeExists) {
            return node;
        }
        return null;
    }

    protected ObjectNode getY1ViewFormatXML(boolean allProperties) {
        ObjectNode node = new ObjectNode(Y1ViewFormat_Name);
        boolean nodeExists = false;
        if ((allProperties || this.getViewFormat(1) != null) && this.getViewFormat(1).getXML(allProperties) != null) {
            node.addProperty(this.getViewFormat(1).getXML(allProperties));
            nodeExists = true;
        }
        if (nodeExists) {
            return node;
        }
        return null;
    }

    protected ObjectNode getZViewFormatXML(boolean allProperties) {
        ObjectNode node = new ObjectNode(ZViewFormat_Name);
        boolean nodeExists = false;
        if ((allProperties || this.getViewFormat(3) != null) && this.getViewFormat(3).getXML(allProperties) != null) {
            node.addProperty(this.getViewFormat(3).getXML(allProperties));
            nodeExists = true;
        }
        if (nodeExists) {
            return node;
        }
        return null;
    }

    protected ObjectNode getY2ViewFormatXML(boolean allProperties) {
        ObjectNode node = new ObjectNode(Y2ViewFormat_Name);
        boolean nodeExists = false;
        if ((allProperties || this.getViewFormat(2) != null) && this.getViewFormat(2).getXML(allProperties) != null) {
            node.addProperty(this.getViewFormat(2).getXML(allProperties));
            nodeExists = true;
        }
        if (nodeExists) {
            return node;
        }
        return null;
    }

    protected ObjectNode getStockVolumeViewFormatXML(boolean allProperties) {
        ObjectNode node = new ObjectNode(StockVolumeViewFormat_Name);
        boolean nodeExists = false;
        if ((allProperties || this.getViewFormat(4) != null) && this.getViewFormat(4).getXML(allProperties) != null) {
            node.addProperty(this.getViewFormat(4).getXML(allProperties));
            nodeExists = true;
        }
        if (nodeExists) {
            return node;
        }
        return null;
    }

    @Override
    protected String getComponentName() {
        return "MarkerText";
    }

    @Override
    public boolean getNonstyleXML(boolean allProperties, ObjectNode node) {
        ObjectNode StockVolumeXML;
        ObjectNode ZXML;
        ObjectNode Y2XML;
        ObjectNode Y1XML;
        boolean nodeExists = super.getNonstyleXML(allProperties, node);
        ObjectNode X1XML = this.getX1ViewFormatXML(allProperties);
        if (X1XML != null) {
            node.addProperty(X1XML);
            nodeExists = true;
        }
        if ((Y1XML = this.getY1ViewFormatXML(allProperties)) != null) {
            node.addProperty(Y1XML);
            nodeExists = true;
        }
        if ((Y2XML = this.getY2ViewFormatXML(allProperties)) != null) {
            node.addProperty(Y2XML);
            nodeExists = true;
        }
        if ((ZXML = this.getZViewFormatXML(allProperties)) != null) {
            node.addProperty(ZXML);
            nodeExists = true;
        }
        if ((StockVolumeXML = this.getStockVolumeViewFormatXML(allProperties)) != null) {
            node.addProperty(StockVolumeXML);
            nodeExists = true;
        }
        return nodeExists;
    }

    @Override
    public boolean getStyleXML(boolean allProperties, ObjectNode node) {
        boolean nodeExists = super.getStyleXML(allProperties, node);
        Object val = this.m_pfj.getDisplayObj(this.m_identObj);
        if (val != null) {
            node.addProperty("visible", ((Boolean)val).booleanValue());
            nodeExists = true;
        }
        if ((val = this.m_pfj.getObjProp(Attr.DataTextPosition)) != null) {
            node.addProperty("markerTextPlace", this.convertMarkerTextPlaceToString((Integer)val));
            nodeExists = true;
        }
        if ((val = this.m_pfj.getObjProp(Attr.DataTextAngle)) != null) {
            node.addProperty("markerTextAngleDefault", ((Integer)val).intValue());
            nodeExists = true;
        }
        if ((val = this.m_pfj.getObjProp(Attr.DataTextRadius)) != null) {
            node.addProperty("markerTextRadiusDefault", ((Integer)val).intValue());
            nodeExists = true;
        }
        return nodeExists;
    }

    @Override
    public void setNonstyleXML(ObjectNode node, String version, int reset) {
        ObjectNode stockVolumeXML;
        ObjectNode zXML;
        ObjectNode y2XML;
        ObjectNode y1XML;
        super.setNonstyleXML(node);
        ObjectNode x1XML = node.getPropertyValueAsObjectNode(X1ViewFormat_Name, true);
        if (x1XML != null && x1XML.getPropertyValueAsObjectNode(ViewFormat_Name, true) != null) {
            if (this.m_jsfHashMap != null) {
                HashMap map = new HashMap();
                this.m_jsfHashMap.put(X1ViewFormat_Name, map);
                this.getViewFormat(0).setXML(x1XML.getPropertyValueAsObjectNode(ViewFormat_Name, true), version, reset, map);
            } else {
                this.getViewFormat(0).setXML(x1XML.getPropertyValueAsObjectNode(ViewFormat_Name, true), version, reset);
            }
        }
        if ((y1XML = node.getPropertyValueAsObjectNode(Y1ViewFormat_Name, true)) != null && y1XML.getPropertyValueAsObjectNode(ViewFormat_Name, true) != null) {
            if (this.m_jsfHashMap != null) {
                HashMap map = new HashMap();
                this.m_jsfHashMap.put(Y1ViewFormat_Name, map);
                this.getViewFormat(1).setXML(y1XML.getPropertyValueAsObjectNode(ViewFormat_Name, true), version, reset, map);
            } else {
                this.getViewFormat(1).setXML(y1XML.getPropertyValueAsObjectNode(ViewFormat_Name, true), version, reset);
            }
        }
        if ((y2XML = node.getPropertyValueAsObjectNode(Y2ViewFormat_Name, true)) != null && y2XML.getPropertyValueAsObjectNode(ViewFormat_Name, true) != null) {
            if (this.m_jsfHashMap != null) {
                HashMap map = new HashMap();
                this.m_jsfHashMap.put(Y2ViewFormat_Name, map);
                this.getViewFormat(2).setXML(y2XML.getPropertyValueAsObjectNode(ViewFormat_Name, true), version, reset, map);
            } else {
                this.getViewFormat(2).setXML(y2XML.getPropertyValueAsObjectNode(ViewFormat_Name, true), version, reset);
            }
        }
        if ((zXML = node.getPropertyValueAsObjectNode(ZViewFormat_Name, true)) != null && zXML.getPropertyValueAsObjectNode(ViewFormat_Name, true) != null) {
            if (this.m_jsfHashMap != null) {
                HashMap map = new HashMap();
                this.m_jsfHashMap.put(ZViewFormat_Name, map);
                this.getViewFormat(3).setXML(zXML.getPropertyValueAsObjectNode(ViewFormat_Name, true), version, reset, map);
            } else {
                this.getViewFormat(3).setXML(zXML.getPropertyValueAsObjectNode(ViewFormat_Name, true), version, reset);
            }
        }
        if ((stockVolumeXML = node.getPropertyValueAsObjectNode(StockVolumeViewFormat_Name, true)) != null && stockVolumeXML.getPropertyValueAsObjectNode(ViewFormat_Name, true) != null) {
            if (this.m_jsfHashMap != null) {
                HashMap map = new HashMap();
                this.m_jsfHashMap.put(StockVolumeViewFormat_Name, map);
                this.getViewFormat(4).setXML(stockVolumeXML.getPropertyValueAsObjectNode(ViewFormat_Name, true), version, reset, map);
            } else {
                this.getViewFormat(4).setXML(stockVolumeXML.getPropertyValueAsObjectNode(ViewFormat_Name, true), version, reset);
            }
        }
    }

    @Override
    public void setStyleXML(ObjectNode node) {
        super.setStyleXML(node);
        PropertyNode pNode = node.getProperty("visible");
        if (pNode != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("rendered", new Boolean(pNode.getValueAsBoolean()));
            } else {
                this.setVisible(pNode.getValueAsBoolean());
            }
        }
        if ((pNode = node.getProperty("rendered")) != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("rendered", new Boolean(pNode.getValueAsBoolean()));
            } else {
                this.setVisible(pNode.getValueAsBoolean());
            }
        }
        if ((pNode = node.getProperty("markerTextPlace")) != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("markerTextPlace", new Integer(MarkerText.convertMarkerTextPlaceToInt(pNode.getValueAsString())));
            } else {
                this.setMarkerTextPlace(MarkerText.convertMarkerTextPlaceToInt(pNode.getValueAsString()));
            }
        }
        if ((pNode = node.getProperty("markerTextAngleDefault")) != null) {
            this.setMarkerTextAngleDefault(pNode.getValueAsInteger());
        }
        if ((pNode = node.getProperty("markerTextRadiusDefault")) != null) {
            this.setMarkerTextRadiusDefault(pNode.getValueAsInteger());
        }
    }

    private void init() {
        this.m_viewFormatX1 = new ViewFormat();
        this.m_viewFormatY1 = new ViewFormat();
        this.m_viewFormatY2 = new ViewFormat();
        this.m_viewFormatZ = new ViewFormat();
        this.m_viewFormatStockVolume = new ViewFormat();
        this.m_viewFormatX1.setViewFormatCallback(this);
        this.m_viewFormatY1.setViewFormatCallback(this);
        this.m_viewFormatY2.setViewFormatCallback(this);
        this.m_viewFormatZ.setViewFormatCallback(this);
        this.m_viewFormatStockVolume.setViewFormatCallback(this);
        this.m_viewFormatX1.setView(this.m_commonGraph);
        this.m_viewFormatY1.setView(this.m_commonGraph);
        this.m_viewFormatY2.setView(this.m_commonGraph);
        this.m_viewFormatZ.setView(this.m_commonGraph);
        this.m_viewFormatStockVolume.setView(this.m_commonGraph);
    }

    @Override
    protected void resetStyle() {
        this.setVisible(true);
        this.setMarkerTextPlace(4);
        this.setMarkerTextAngleDefault(0);
        this.setMarkerTextRadiusDefault(0);
        super.resetStyle();
    }
}

