/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.HashMap;
import oracle.dss.graph.BaseGraphComponent;
import oracle.dss.graph.CommonGraph;
import oracle.dss.graph.Rect;
import oracle.dss.graph.SFX;
import oracle.dss.graph.ThickGraph;
import oracle.dss.graph.pfj.Attr;
import oracle.dss.util.Utility;
import oracle.dss.util.xml.ContainerNode;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public class LegendArea
extends BaseGraphComponent
implements Rect {
    protected SFX m_sfx;
    private int m_automaticPosition;
    private boolean m_bThreeDSurfaceGraph = false;
    private boolean m_bStandardRectDefault = true;
    private boolean m_bThreeDSurfaceRectDefault = true;
    private static final String a_threeDSurfacePosition = "threeDSurfacePosition";
    public static final String a_alongGraphEdge = "alongGraphEdge";
    public static final String a_automaticPlacement = "automaticPlacement";
    private static final String NAME_THREEDSURFACERECT = "ThreeDSurfaceRect";
    protected static final int rect_Height = 2063;
    protected static final int rect_Width = 25072;
    protected static final int rect_X = -14180;
    protected static final int rect_Y = -11537;

    public LegendArea(CommonGraph graph) {
        super(graph);
        this.m_identObj = this.m_pfj.getLegendArea();
    }

    public SFX getSFX() {
        if (this.m_sfx == null) {
            this.m_sfx = new SFX(this.m_commonGraph, this.m_identObj);
        }
        return this.m_sfx;
    }

    @Override
    public boolean selectObject(int series, int group) {
        this.m_pfj.setSelection(this.m_identObj);
        return this.m_identObj.equals(this.m_pfj.getSelectionID());
    }

    public Color getBorderColor() {
        return this.m_pfj.getBorderColor(this.m_identObj);
    }

    public void setBorderColor(Color newColor) {
        if (newColor == null) {
            this.m_commonGraph.getErrorHandler().log("invalid Color value", this.getClass().toString(), "setBorderColor( Color newColor)");
            return;
        }
        this.m_pfj.setBorderColor(this.m_identObj, newColor);
    }

    public boolean isBorderTransparent() {
        return this.m_pfj.getTransparentBorderColor(this.m_identObj);
    }

    public void setBorderTransparent(boolean yesNo) {
        this.m_pfj.setTransparentBorderColor(this.m_identObj, yesNo);
    }

    public Color getFillColor() {
        return this.m_pfj.getFillColor(this.m_identObj);
    }

    public void setFillColor(Color newColor) {
        if (newColor == null) {
            this.setFillTransparent(true);
            return;
        }
        this.m_pfj.setFillColor(this.m_identObj, newColor);
    }

    public boolean isFillTransparent() {
        return this.m_pfj.getTransparentFillColor(this.m_identObj);
    }

    public void setFillTransparent(boolean yesNo) {
        this.m_pfj.setTransparentFillColor(this.m_identObj, yesNo);
    }

    public boolean isMarkersPerRowAutomatic() {
        return this.m_pfj.getLegendAutomatic();
    }

    public void setMarkersPerRowAutomatic(boolean yesNo) {
        this.m_pfj.setLegendAutomatic(yesNo);
    }

    public int getLegendMarkersPerRow() {
        return this.m_pfj.getLegendMarkersPerRow();
    }

    public void setLegendMarkersPerRow(int count) {
        if (count < 0 || count > 9999) {
            this.m_commonGraph.getErrorHandler().log("invalid number of legend markers", this.getClass().getName(), "setLegendMarkersPerRow(int count)");
        } else {
            this.m_pfj.setLegendMarkersPerRow(count);
        }
    }

    public int getLegendTextPosition() {
        return this.m_pfj.getLegendMarkerPosition();
    }

    public void setLegendTextPosition(int mode) {
        if (mode > 4 || mode < 0) {
            this.m_commonGraph.getErrorHandler().log("Invalid parameter", this.getClass().getName(), "setLegendTextPosition");
            return;
        }
        this.m_pfj.setLegendMarkerPosition(mode);
    }

    public int getLegendOrientation() {
        return this.m_pfj.getLegendOrient();
    }

    public void setLegendOrientation(int orient) {
        if (orient > 2 || orient < 0) {
            this.m_commonGraph.getErrorHandler().log("Invalid parameter", this.getClass().getName(), "setLegendOrientation");
            return;
        }
        this.m_pfj.setLegendOrient(orient);
    }

    public int getPosition() {
        return this.m_pfj.getIntegerProp(Attr.LegendPosition);
    }

    public void setPosition(int position) {
        switch (position) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.m_pfj.setIntegerProp(position, Attr.LegendPosition);
                this.setAutomaticPosition(position, true);
                this.setRectDefault(true);
                this.m_pfj.setIntegerProp(0, Attr.AutomaticPlacement);
                break;
            }
            default: {
                this.m_commonGraph.getErrorHandler().log("invalid position", this.getClass().getName(), "setPosition(int position)");
                return;
            }
        }
    }

    public void setAlongGraphEdge(boolean alongEdge) {
        this.m_pfj.setBooleanProp(alongEdge, Attr.AlongGraphEdge);
        this.setAutomaticPosition(this.getAutomaticPosition(), true);
        this.setRectDefault(true);
        this.m_pfj.setObjProp(this.getDefaultPFJRect(this.m_pfj.getIntegerProp(Attr.LegendAlternatePosition), this.m_pfj.getBooleanProp(Attr.AlongGraphEdge)), Attr.LegendAlternateRect);
        this._setStandardRectDefault(true);
        this._setThreeDSurfaceRectDefault(true);
        if (!alongEdge) {
            this.m_commonGraph.adjustTitlesForLegendAlongEdge(this.getAutomaticPosition(), alongEdge);
        }
    }

    public boolean isAlongGraphEdge() {
        return this.m_pfj.getBooleanProp(Attr.AlongGraphEdge);
    }

    public void setAutomaticPlacement(int placement) {
        if (placement < 0 || placement > 1) {
            this.m_commonGraph.getErrorHandler().log("invalid value for AutomaticPlacement", this.getClass().getName(), "public void setAutomaticPlacement(int placement)");
            return;
        }
        this.m_pfj.setIntegerProp(placement, Attr.AutomaticPlacement);
        this.m_automaticPosition = this.getPosition();
        this.m_pfj.needRecalc();
    }

    public int getAutomaticPlacement() {
        return this.m_pfj.getIntegerProp(Attr.AutomaticPlacement);
    }

    @Override
    public Rectangle getRect() {
        Rectangle pfjRect = this.m_pfj.getRect(this.m_identObj);
        if (pfjRect != null) {
            Rectangle rect = new Rectangle(pfjRect);
            rect.y += rect.height;
            return rect;
        }
        return null;
    }

    @Override
    public void setRect(Rectangle loc) {
        Rectangle rect = new Rectangle(loc);
        rect.y -= rect.height;
        this.m_pfj.setRect(this.m_identObj, rect);
        this.setPositionForRect();
        this.m_commonGraph.setFrameSizeAutomatic(false);
        this.setRectDefault(false);
    }

    public boolean isVisible() {
        return this.m_pfj.getDisplay(this.m_identObj);
    }

    public void setVisible(boolean yesNo) {
        this.m_pfj.setDisplay(this.m_identObj, yesNo);
    }

    private void setRectXML(ObjectNode node, boolean bThreeDSurfaceRect) {
        Rectangle rect = null;
        rect = bThreeDSurfaceRect ? this._getThreeDSurfaceRect() : this._getStandardRect();
        PropertyNode pNode = node.getProperty("height");
        if (pNode != null) {
            rect.height = pNode.getValueAsInteger();
        }
        if ((pNode = node.getProperty("width")) != null) {
            rect.width = pNode.getValueAsInteger();
        }
        if ((pNode = node.getProperty("x")) != null) {
            rect.x = pNode.getValueAsInteger();
        }
        if ((pNode = node.getProperty("y")) != null) {
            rect.y = pNode.getValueAsInteger();
        }
        if (bThreeDSurfaceRect) {
            this._setThreeDSurfaceRect(rect);
        } else {
            this._setStandardRect(rect);
        }
    }

    private ObjectNode getRectXML(boolean allProperties, boolean bThreeDSurfaceRect) {
        boolean nodeExists = false;
        Rectangle rect = null;
        boolean bRectDefault = true;
        ObjectNode node = new ObjectNode("Rect");
        if (bThreeDSurfaceRect) {
            rect = this._getThreeDSurfaceRect();
            bRectDefault = this._isThreeDSurfaceRectDefault();
        } else {
            rect = this._getStandardRect();
            bRectDefault = this._isStandardRectDefault();
        }
        if (rect != null && (allProperties || !bRectDefault)) {
            node.addProperty("height", rect.height);
            node.addProperty("width", rect.width);
            node.addProperty("x", rect.x);
            node.addProperty("y", rect.y);
            nodeExists = true;
        }
        if (nodeExists) {
            return node;
        }
        return null;
    }

    private ObjectNode getThreeDSurfaceRectXML(boolean allProperties) {
        ObjectNode node = new ObjectNode(NAME_THREEDSURFACERECT);
        boolean nodeExists = false;
        ObjectNode rectNode = this.getRectXML(allProperties, true);
        if (allProperties || rectNode != null) {
            node.addProperty(rectNode);
            nodeExists = true;
        }
        if (nodeExists) {
            return node;
        }
        return null;
    }

    protected String convertLegendAreaPositionToString(int value) {
        String lAPosition = "LAP_BOTTOM";
        switch (value) {
            case 0: {
                lAPosition = "LAP_TOP";
                break;
            }
            case 1: {
                lAPosition = "LAP_BOTTOM";
                break;
            }
            case 2: {
                lAPosition = "LAP_RIGHT";
                break;
            }
            case 3: {
                lAPosition = "LAP_LEFT";
            }
        }
        return lAPosition;
    }

    public static int convertLegendAreaPositionToInt(String string) {
        if (string.equals("LAP_TOP")) {
            return 0;
        }
        if (string.equals("LAP_BOTTOM")) {
            return 1;
        }
        if (string.equals("LAP_RIGHT")) {
            return 2;
        }
        if (string.equals("LAP_LEFT")) {
            return 3;
        }
        return -1;
    }

    private String _convertAutomaticPlacementToString(int placement) {
        switch (placement) {
            case 0: {
                return "AP_NEVER";
            }
        }
        return "AP_ALWAYS";
    }

    public static int convertAutomaticPlacementToInt(String placement) {
        if (placement.equals("AP_NEVER")) {
            return 0;
        }
        if (placement.equals("AP_ALWAYS")) {
            return 1;
        }
        return -1;
    }

    protected void resetToDefault() {
        this.m_automaticPosition = 2;
        this.m_bThreeDSurfaceGraph = false;
        this.m_bStandardRectDefault = true;
        this.m_bThreeDSurfaceRectDefault = true;
    }

    protected void graphTypeChanged(int oldType, int newType) {
        boolean bOldThreeD = this._isThreeDSurfaceGraph(oldType);
        boolean bNewThreeD = this._isThreeDSurfaceGraph(newType);
        if (bOldThreeD && !bNewThreeD || !bOldThreeD && bNewThreeD) {
            int tmpPos = this.m_pfj.getIntegerProp(Attr.LegendAlternatePosition);
            this.m_pfj.setIntegerProp(this.getPosition(), Attr.LegendAlternatePosition);
            this.m_pfj.setIntegerProp(tmpPos, Attr.LegendPosition);
            this.m_automaticPosition = tmpPos;
            Rectangle tempRect = new Rectangle(this.m_pfj.getRect(this.m_identObj));
            this.m_pfj.setRect(this.m_identObj, (Rectangle)this.m_pfj.getObjProp(Attr.LegendAlternateRect));
            this.m_pfj.setObjProp(tempRect, Attr.LegendAlternateRect);
        }
        this.m_bThreeDSurfaceGraph = bNewThreeD;
    }

    protected void setRectDefault(boolean bDefault) {
        if (this.m_bThreeDSurfaceGraph) {
            this._setThreeDSurfaceRectDefault(bDefault);
        } else {
            this._setStandardRectDefault(bDefault);
        }
    }

    Rectangle getDefaultPFJRect(int position, boolean bAlongGraphEdge) {
        switch (position) {
            case 2: {
                if (bAlongGraphEdge) {
                    return new Rectangle(10465, -16000, 5535, 32000);
                }
                return new Rectangle(10141, -13239, 5535, 25051);
            }
            case 1: {
                if (bAlongGraphEdge) {
                    return new Rectangle(-16000, -16000, 32000, 2063);
                }
                return new Rectangle(-12540, -13966, 25072, 2063);
            }
            case 3: {
                if (bAlongGraphEdge) {
                    return new Rectangle(-16000, -16000, 5535, 32000);
                }
                return new Rectangle(-15405, -13255, 5535, 25051);
            }
            case 0: {
                if (bAlongGraphEdge) {
                    return new Rectangle(-16000, 13937, 32000, 2063);
                }
                return new Rectangle(-12432, 10394, 25072, 2063);
            }
        }
        this.m_commonGraph.getErrorHandler().log("invalid position", this.getClass().getName(), "_getDefaultRectForPosition(int position)");
        return null;
    }

    void setAutomaticPosition(int position, boolean reset) {
        switch (position) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.m_pfj.putToLookNoCalc(this.m_pfj.getLegendArea(), Attr.LegendAreaRect, this.getDefaultPFJRect(position, this.isAlongGraphEdge()), !reset);
                break;
            }
            default: {
                this.m_commonGraph.getErrorHandler().log("invalid position", this.getClass().getName(), "void setAutomaticPosition(int position)");
                return;
            }
        }
        this.m_automaticPosition = position;
        if (!this.m_commonGraph.isFrameSizeAutomatic()) {
            this.m_commonGraph.setFrameSizeAutomatic(true);
        }
        this.m_commonGraph.setFrameSize(this.m_commonGraph.getGraphType());
        if (this.isAlongGraphEdge()) {
            this.m_commonGraph.adjustTitlesForLegendAlongEdge(this.getAutomaticPosition(), this.isAlongGraphEdge());
        }
    }

    public int getAutomaticPosition() {
        if (this.m_automaticPosition == 2 && this.m_pfj.isBIDILocale()) {
            return 3;
        }
        return this.m_automaticPosition;
    }

    int calcAutomaticPosition() {
        if (this._isThreeDSurfaceGraph(this.m_commonGraph.getGraphType())) {
            return 1;
        }
        return this._calcAutomaticPosition();
    }

    private int _calcAutomaticPosition() {
        int graphType;
        Dimension imageSize = null;
        imageSize = this.m_commonGraph.isShowing() ? ((ThickGraph)this.m_commonGraph.getThickDataview()).getThickPFJ().getSize() : this.m_commonGraph.getImageSize();
        double availableWidth = imageSize.width;
        double availableHeight = imageSize.height;
        if (this.m_commonGraph.getTitle().isVisible()) {
            Rectangle titleRect = null;
            titleRect = this.m_pfj.getRect(this.m_pfj.getTitle());
            availableHeight -= (double)this.m_pfj.getVC().virtToDestHeight(titleRect.height);
        }
        if (this.m_commonGraph.getSubtitle().isVisible()) {
            Rectangle subtitleRect = null;
            subtitleRect = this.m_pfj.getRect(this.m_pfj.getSubtitle());
            availableHeight -= (double)this.m_pfj.getVC().virtToDestHeight(subtitleRect.height);
        }
        if (this.m_commonGraph.getFootnote().isVisible()) {
            Rectangle footnoteRect = null;
            footnoteRect = this.m_pfj.getRect(this.m_pfj.getFootnote());
            availableHeight -= (double)this.m_pfj.getVC().virtToDestHeight(footnoteRect.height);
        }
        if (this.m_commonGraph.isO1AxisSupported() && this.m_commonGraph.getO1Axis().isVisible()) {
            if (this.m_commonGraph.isHorizontal()) {
                availableWidth *= 0.8;
            } else {
                int textRotation = this.m_commonGraph.getO1TickLabel().getTextRotation();
                if (textRotation == 90 || textRotation == 270) {
                    availableHeight *= 0.8;
                }
            }
        }
        if (this._isDualY(graphType = this.m_commonGraph.getGraphType()) && this.m_commonGraph.getY1Axis().isVisible() && this.m_commonGraph.getY2Axis().isVisible()) {
            if (this.m_commonGraph.isHorizontal()) {
                availableHeight *= 0.9;
            } else {
                availableWidth *= 0.9;
            }
        }
        if (this._isPie(graphType) && this.m_commonGraph.getSliceLabel().isVisible()) {
            availableWidth *= 0.9;
        }
        if (graphType == 93 || graphType == 94) {
            availableWidth *= 0.9;
        }
        if (graphType == 67 || graphType == 68) {
            if (availableWidth > availableHeight * 1.4) {
                return 2;
            }
            return 1;
        }
        if (graphType == 65 || graphType == 66) {
            if (availableWidth > availableHeight * 1.2) {
                return 2;
            }
            return 1;
        }
        if (availableHeight > availableWidth) {
            return 1;
        }
        return 2;
    }

    boolean isSupported(int graphType) {
        switch (graphType) {
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 70: 
            case 71: 
            case 72: 
            case 76: 
            case 84: 
            case 85: 
            case 86: 
            case 96: {
                return false;
            }
        }
        return true;
    }

    void setPositionForRect() {
        Rectangle rect = this.m_pfj.getRect(this.m_identObj);
        this.m_pfj.setIntegerProp(0, Attr.AutomaticPlacement);
        int centerX = rect.x + rect.width / 2;
        int centerY = rect.y + rect.height / 2;
        if (centerY > 0) {
            if (centerX < 0) {
                if (Math.abs(centerY) > Math.abs(centerX)) {
                    this.m_pfj.setIntegerProp(0, Attr.LegendPosition);
                    this.m_automaticPosition = 0;
                } else {
                    this.m_pfj.setIntegerProp(3, Attr.LegendPosition);
                    this.m_automaticPosition = 3;
                }
            } else if (Math.abs(centerY) > Math.abs(centerX)) {
                this.m_pfj.setIntegerProp(0, Attr.LegendPosition);
                this.m_automaticPosition = 0;
            } else {
                this.m_pfj.setIntegerProp(2, Attr.LegendPosition);
                this.m_automaticPosition = 2;
            }
        } else if (centerX < 0) {
            if (Math.abs(centerY) < Math.abs(centerX)) {
                this.m_pfj.setIntegerProp(3, Attr.LegendPosition);
                this.m_automaticPosition = 3;
            } else {
                this.m_pfj.setIntegerProp(1, Attr.LegendPosition);
                this.m_automaticPosition = 1;
            }
        } else if (Math.abs(centerY) < Math.abs(centerX)) {
            this.m_pfj.setIntegerProp(2, Attr.LegendPosition);
            this.m_automaticPosition = 2;
        } else {
            this.m_pfj.setIntegerProp(1, Attr.LegendPosition);
            this.m_automaticPosition = 1;
        }
        this.m_pfj.setBooleanProp(false, Attr.AlongGraphEdge);
    }

    private boolean _isDualY(int graphType) {
        switch (graphType) {
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 33: 
            case 34: 
            case 38: 
            case 39: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 62: 
            case 64: 
            case 71: 
            case 74: 
            case 75: 
            case 77: 
            case 78: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 88: 
            case 91: 
            case 92: 
            case 98: {
                return true;
            }
        }
        return false;
    }

    private boolean _isPie(int graphType) {
        switch (graphType) {
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 93: 
            case 94: {
                return true;
            }
        }
        return false;
    }

    private boolean _isThreeDSurfaceGraph(int type) {
        return type == 12 || type == 13 || type == 14;
    }

    private Rectangle _getThreeDSurfaceRect() {
        return this._getLegendRect(true);
    }

    private void _setThreeDSurfaceRect(Rectangle rect) {
        this._setLegendRect(rect, true);
    }

    private Object _getThreeDSurfacePosition() {
        return this._getLegendPosition(true);
    }

    private void _setThreeDSurfacePosition(int position) {
        this._setLegendPosition(position, true);
    }

    private boolean _isThreeDSurfaceRectDefault() {
        return this.m_bThreeDSurfaceRectDefault;
    }

    private void _setThreeDSurfaceRectDefault(boolean b) {
        this.m_bThreeDSurfaceRectDefault = b;
    }

    private Rectangle _getStandardRect() {
        return this._getLegendRect(false);
    }

    private void _setStandardRect(Rectangle rect) {
        this._setLegendRect(rect, false);
    }

    private Object _getStandardPosition() {
        return this._getLegendPosition(false);
    }

    private void _setStandardPosition(int position) {
        this._setLegendPosition(position, false);
    }

    private boolean _isStandardRectDefault() {
        return this.m_bStandardRectDefault;
    }

    private void _setStandardRectDefault(boolean b) {
        this.m_bStandardRectDefault = b;
    }

    private Rectangle _getLegendRect(boolean bThreeDSurface) {
        if (bThreeDSurface && this.m_bThreeDSurfaceGraph || !bThreeDSurface && !this.m_bThreeDSurfaceGraph) {
            return this.getRect();
        }
        Rectangle pfjRect = (Rectangle)this.m_pfj.getObjProp(Attr.LegendAlternateRect);
        if (pfjRect != null) {
            Rectangle rect = new Rectangle(pfjRect);
            rect.y += rect.height;
            return rect;
        }
        return null;
    }

    private void _setLegendRect(Rectangle rect, boolean bThreeDSurface) {
        if (bThreeDSurface && this.m_bThreeDSurfaceGraph || !bThreeDSurface && !this.m_bThreeDSurfaceGraph) {
            this.setRect(rect);
        } else {
            Rectangle r = new Rectangle(rect);
            r.y -= r.height;
            this.m_pfj.setObjProp(r, Attr.LegendAlternateRect);
        }
    }

    private Object _getLegendPosition(boolean bThreeDSurface) {
        if (bThreeDSurface && this.m_bThreeDSurfaceGraph || !bThreeDSurface && !this.m_bThreeDSurfaceGraph) {
            return this.m_pfj.getObjProp(Attr.LegendPosition);
        }
        return this.m_pfj.getObjProp(Attr.LegendAlternatePosition);
    }

    private void _setLegendPosition(int position, boolean bThreeDSurface) {
        if (bThreeDSurface && this.m_bThreeDSurfaceGraph || !bThreeDSurface && !this.m_bThreeDSurfaceGraph) {
            this.setPosition(position);
        } else {
            this.m_pfj.setIntegerProp(position, Attr.LegendAlternatePosition);
            this.m_pfj.setObjProp(this.getDefaultPFJRect(this.m_pfj.getIntegerProp(Attr.LegendAlternatePosition), this.isAlongGraphEdge()), Attr.LegendAlternateRect);
        }
    }

    protected void resetStyle() {
        this.setBorderColor(Color.black);
        this.setBorderTransparent(false);
        this.setFillColor(Color.black);
        this.setFillTransparent(false);
        this.setMarkersPerRowAutomatic(true);
        this.setLegendMarkersPerRow(1);
        this.setLegendTextPosition(4);
        this.setLegendOrientation(1);
        this.setPosition(1);
        this.setAutomaticPlacement(1);
        this.setAlongGraphEdge(false);
        if (this.m_sfx != null) {
            this.getSFX().resetStyle();
        }
    }

    @Override
    protected String getComponentName() {
        return "LegendArea";
    }

    protected ObjectNode getXML(boolean allProperties, boolean allOverriddenProperties) {
        boolean nodeExists = false;
        ObjectNode node = this.getStyleXML(allProperties, allOverriddenProperties);
        if (node == null) {
            node = new ObjectNode(this.getComponentName());
        } else {
            nodeExists = true;
        }
        return (nodeExists |= this.getNonstyleXML(allProperties, node)) ? node : null;
    }

    @Override
    public boolean getNonstyleXML(boolean allProperties, ObjectNode node) {
        boolean nodeExists = super.getNonstyleXML(allProperties, node);
        Object val = this.m_pfj.getDisplayObj(this.m_identObj);
        if (val != null) {
            node.addProperty("visible", ((Boolean)val).booleanValue());
            nodeExists = true;
        }
        return nodeExists;
    }

    protected ObjectNode getStyleXML(boolean allProperties, boolean allOverriddenProperties) {
        ContainerNode sfxNode;
        ObjectNode threeDSurfaceRectXML;
        ObjectNode rectXML;
        int tmp;
        ObjectNode node = new ObjectNode(this.getComponentName());
        boolean nodeExists = false;
        Object val = this.m_pfj.getObjProp(Attr.AlongGraphEdge);
        if (val != null) {
            node.addProperty(a_alongGraphEdge, ((Boolean)val).booleanValue());
            nodeExists = true;
        }
        if ((val = this.m_pfj.getObjProp(Attr.AutomaticPlacement)) != null) {
            node.addProperty(a_automaticPlacement, this._convertAutomaticPlacementToString((Integer)val));
            nodeExists = true;
        }
        if ((val = this._getStandardPosition()) != null) {
            node.addProperty("position", this.convertLegendAreaPositionToString((Integer)val));
            nodeExists = true;
        }
        if ((val = this._getThreeDSurfacePosition()) != null) {
            node.addProperty(a_threeDSurfacePosition, this.convertLegendAreaPositionToString((Integer)val));
            nodeExists = true;
        }
        if ((val = this.getBorderColor()) != null) {
            node.addProperty("borderColor", LegendArea.toHexString(((Color)val).getRGB()));
            nodeExists = true;
        }
        if ((val = this.getFillColor()) != null) {
            node.addProperty("fillColor", LegendArea.toHexString(((Color)val).getRGB()));
            nodeExists = true;
        }
        if ((val = this.m_pfj.getTransparentBorderColorObj(this.m_identObj)) != null) {
            node.addProperty("borderTransparent", ((Boolean)val).booleanValue());
            nodeExists = true;
        }
        if ((val = this.m_pfj.getTransparentFillColorObj(this.m_identObj)) != null) {
            node.addProperty("fillTransparent", ((Boolean)val).booleanValue());
            nodeExists = true;
        }
        if ((val = this.m_pfj.getObjProp(Attr.LegendAutomatic)) != null) {
            node.addProperty("markersPerRowAutomatic", ((Boolean)val).booleanValue());
            nodeExists = true;
        }
        if ((val = this.m_pfj.getObjProp(Attr.LegendMarkersPerRow)) != null) {
            node.addProperty("legendMarkersPerRow", ((Integer)val).intValue());
            nodeExists = true;
        }
        if ((val = this.m_pfj.getObjProp(Attr.LegendMarkerPosition)) != null) {
            tmp = (Integer)val;
            if (tmp == 0) {
                node.addProperty("legendTextPosition", "LTP_ON_RIGHT");
            } else if (tmp == 1) {
                node.addProperty("legendTextPosition", "LTP_ON_LEFT");
            } else if (tmp == 2) {
                node.addProperty("legendTextPosition", "LTP_BELOW");
            } else if (tmp == 3) {
                node.addProperty("legendTextPosition", "LTP_ABOVE");
            } else if (tmp == 4) {
                node.addProperty("legendTextPosition", "LTP_ON_MWRKER");
            }
            nodeExists = true;
        }
        if ((val = this.m_pfj.getObjProp(Attr.LegendOrient)) != null) {
            tmp = (Integer)val;
            if (tmp == 2) {
                node.addProperty("legendOrientation", "LO_AUTOMATIC");
            } else if (tmp == 1) {
                node.addProperty("legendOrientation", "LO_HORIZONTAL");
            } else if (tmp == 0) {
                node.addProperty("legendOrientation", "LO_VERTICAL");
            }
            nodeExists = true;
        }
        if ((rectXML = this.getRectXML(allProperties, false)) != null) {
            node.addProperty(rectXML);
            nodeExists = true;
        }
        if ((threeDSurfaceRectXML = this.getThreeDSurfaceRectXML(allProperties)) != null) {
            node.addProperty(threeDSurfaceRectXML);
            nodeExists = true;
        }
        if ((sfxNode = this.getSFX().getXML(allProperties, allOverriddenProperties)) != null) {
            node.addContainer(sfxNode);
            nodeExists = true;
        }
        return nodeExists ? node : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setXML(ObjectNode node, boolean allProperties, HashMap map) {
        this.m_jsfHashMap = map;
        try {
            this.setXML(node, allProperties);
        }
        finally {
            this.m_jsfHashMap = null;
        }
    }

    protected void setXML(ObjectNode node, boolean allProperties) {
        this.setNonStyleXML(node);
        this.setStyleXML(node, allProperties);
    }

    protected void setNonStyleXML(ObjectNode node) {
        PropertyNode pNode = node.getProperty("visible");
        if (pNode != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("rendered", new Boolean(pNode.getValueAsBoolean()));
            } else {
                this.setVisible(pNode.getValueAsBoolean());
            }
        }
        if ((pNode = node.getProperty("rendered")) != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("rendered", new Boolean(pNode.getValueAsBoolean()));
            } else {
                this.setVisible(pNode.getValueAsBoolean());
            }
        }
    }

    protected void setStyleXML(ObjectNode node, boolean allProperties) {
        String tmp;
        ContainerNode sfx;
        PropertyNode pNode = node.getProperty("position");
        if (pNode != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("position", new Integer(LegendArea.convertLegendAreaPositionToInt(pNode.getValueAsString())));
            } else {
                this._setStandardPosition(LegendArea.convertLegendAreaPositionToInt(pNode.getValueAsString()));
            }
        }
        if ((pNode = node.getProperty(a_threeDSurfacePosition)) != null) {
            this._setThreeDSurfacePosition(LegendArea.convertLegendAreaPositionToInt(pNode.getValueAsString()));
        }
        pNode = node.getProperty(a_alongGraphEdge);
        boolean alongGraphEdge = this.isAlongGraphEdge();
        if (pNode != null) {
            alongGraphEdge = pNode.getValueAsBoolean();
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put(a_alongGraphEdge, new Boolean(alongGraphEdge));
            } else {
                this.setAlongGraphEdge(alongGraphEdge);
            }
        }
        if (!alongGraphEdge) {
            ObjectNode rectNode;
            ObjectNode threeDSurfaceRectXML;
            ObjectNode rectXML = node.getPropertyValueAsObjectNode("Rect", true);
            if (rectXML != null) {
                this.setRectXML(rectXML, false);
            }
            if ((threeDSurfaceRectXML = node.getPropertyValueAsObjectNode(NAME_THREEDSURFACERECT, true)) != null && (rectNode = threeDSurfaceRectXML.getPropertyValueAsObjectNode("Rect", true)) != null) {
                this.setRectXML(rectNode, true);
            }
        }
        if ((pNode = node.getProperty(a_automaticPlacement)) != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put(a_automaticPlacement, new Integer(LegendArea.convertAutomaticPlacementToInt(pNode.getValueAsString())));
            } else {
                this.setAutomaticPlacement(LegendArea.convertAutomaticPlacementToInt(pNode.getValueAsString()));
            }
        }
        if ((pNode = node.getProperty("borderColor")) != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("borderColor", new Color(LegendArea.hexStringToInt(pNode.getValueAsString()), true));
            } else {
                this.setBorderColor(new Color(LegendArea.hexStringToInt(pNode.getValueAsString()), true));
            }
        }
        pNode = node.getProperty("fillColor");
        boolean fillColorSet = false;
        if (pNode != null) {
            fillColorSet = true;
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("fillColor", new Color(LegendArea.hexStringToInt(pNode.getValueAsString()), true));
            } else {
                this.setFillColor(new Color(LegendArea.hexStringToInt(pNode.getValueAsString()), true));
            }
        }
        if ((sfx = node.getContainer("SFX")) != null) {
            this.getSFX().setXML(sfx, allProperties);
        }
        if ((pNode = node.getProperty("borderTransparent")) != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("borderTransparent", new Boolean(pNode.getValueAsBoolean()));
            } else {
                this.setBorderTransparent(pNode.getValueAsBoolean());
            }
        }
        if ((pNode = node.getProperty("fillTransparent")) != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("fillTransparent", new Boolean(pNode.getValueAsBoolean()));
            } else {
                this.setFillTransparent(pNode.getValueAsBoolean());
            }
        } else if (fillColorSet && Utility.compareXMLVersions((String)this.m_commonGraph.m_passedInXMLVersion, (String)this.m_commonGraph.getVersion()) < 0) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("fillTransparent", new Boolean(false));
            } else {
                this.setFillTransparent(false);
            }
        }
        pNode = node.getProperty("markersPerRowAutomatic");
        if (pNode != null) {
            this.setMarkersPerRowAutomatic(pNode.getValueAsBoolean());
        }
        if ((pNode = node.getProperty("legendMarkersPerRow")) != null) {
            this.setLegendMarkersPerRow(pNode.getValueAsInteger());
        }
        if ((pNode = node.getProperty("legendTextPosition")) != null) {
            tmp = pNode.getValueAsString();
            if (tmp.equals("LTP_ON_RIGHT")) {
                this.setLegendTextPosition(0);
            } else if (tmp.equals("LTP_ON_LEFT")) {
                this.setLegendTextPosition(1);
            } else if (tmp.equals("LTP_ABOVE")) {
                this.setLegendTextPosition(3);
            } else if (tmp.equals("LTP_BELOW")) {
                this.setLegendTextPosition(2);
            } else if (tmp.equals("LTP_ON_MWRKER")) {
                this.setLegendTextPosition(4);
            }
        }
        if ((pNode = node.getProperty("legendOrientation")) != null) {
            tmp = pNode.getValueAsString();
            if (tmp.equals("LO_AUTOMATIC")) {
                this.setLegendOrientation(2);
            } else if (tmp.equals("LO_HORIZONTAL")) {
                this.setLegendOrientation(1);
            } else if (tmp.equals("LO_VERTICAL")) {
                this.setLegendOrientation(0);
            }
        }
    }
}

