/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import java.awt.Color;
import java.awt.Font;
import java.util.HashMap;
import oracle.dss.dataView.BaseComponentXML;
import oracle.dss.dataView.DataviewFont;
import oracle.dss.dataView.FontAttribute;
import oracle.dss.graph.BaseGraphComponent;
import oracle.dss.graph.CommonGraph;
import oracle.dss.graph.PFJ;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public class GraphFont
extends BaseComponentXML
implements FontAttribute,
DataviewFont {
    protected String fontTypeface;
    protected int fontStyle;
    protected int fontSize;
    protected Color fontColor;
    protected int graphProportionalFontSize;
    protected CommonGraph m_commonGraph;
    protected PFJ m_pfj;
    protected IdentObj m_identObj;
    protected IdentObj m_identObj2;
    protected static final String a_style = "style";
    protected static final String a_graphProportionalFontSize = "graphProportionalFontSize";

    public GraphFont(CommonGraph graph, IdentObj identObj) {
        this.m_commonGraph = graph;
        this.m_pfj = graph.getPFJ();
        this.m_identObj = identObj;
        this.m_identObj2 = identObj.getObjectID() == 270 ? this.m_pfj.getO1DrillLabel() : (identObj.getObjectID() == 274 ? this.m_pfj.getO2DrillLabel() : null);
    }

    @Override
    public Color getGraphFontColor() {
        return this.m_pfj.getFillColor(this.m_identObj);
    }

    @Override
    public void setGraphFontColor(Color newColor) {
        if (newColor == null) {
            this.m_commonGraph.getErrorHandler().log("invalid Color value", this.getClass().toString(), "setGraphFontColor( Color newColor )");
            return;
        }
        this.m_pfj.setFillColor(this.m_identObj, newColor);
        if (this.m_identObj2 != null) {
            this.m_pfj.setFillColor(this.m_identObj2, newColor);
        }
    }

    public int getGraphFontSize() {
        return this.m_pfj.getFontSize(this.m_identObj);
    }

    public int getGraphProportionalFontSize() {
        return this.m_pfj.getFontSizeVC(this.m_identObj);
    }

    public void setGraphFontSize(int size) {
        if (size < 1) {
            this.m_commonGraph.getErrorHandler().log("invalid graph font size", this.getClass().getName(), "setGraphFontSize(int size)");
        } else {
            this.m_pfj.setFontSize(this.m_identObj, size);
            if (this.m_identObj2 != null) {
                this.m_pfj.setFontSize(this.m_identObj2, size);
            }
        }
    }

    public void setGraphProportionalFontSize(int size) {
        this.m_pfj.setFontSizeVC(this.m_identObj, size);
        if (this.m_identObj2 != null) {
            this.m_pfj.setFontSizeVC(this.m_identObj2, size);
        }
    }

    @Override
    public int getGraphFontStyle() {
        return this.m_pfj.getFontStyle(this.m_identObj);
    }

    @Override
    public void setGraphFontStyle(int style) {
        if (style < 0 || style > 7) {
            this.m_commonGraph.getErrorHandler().log("invalid graph font size", this.getClass().getName(), "setGraphFontStyle( int style )");
        }
        this.m_pfj.setFontStyle(this.m_identObj, style);
        if (this.m_identObj2 != null) {
            this.m_pfj.setFontStyle(this.m_identObj2, style |= 4);
        }
    }

    public boolean isFontBold() {
        return (this.m_pfj.getFontStyle(this.m_identObj) & 2) != 0;
    }

    public boolean isFontItalic() {
        return (this.m_pfj.getFontStyle(this.m_identObj) & 1) != 0;
    }

    public boolean isUnderline() {
        return (this.m_pfj.getFontStyle(this.m_identObj) & 4) != 0;
    }

    public void setFontBold(boolean bold) {
        int style = this.m_pfj.getFontStyle(this.m_identObj);
        style = bold ? (style |= 2) : (style &= 0xFFFFFFFD);
        this.m_pfj.setFontStyle(this.m_identObj, style);
        if (this.m_identObj2 != null) {
            int drillStyle = this.m_pfj.getFontStyle(this.m_identObj2);
            style = bold ? (style |= 2) : (style &= 0xFFFFFFFD);
            this.m_pfj.setFontStyle(this.m_identObj2, drillStyle);
        }
    }

    public void setFontItalic(boolean isItalic) {
        int style = this.m_pfj.getFontStyle(this.m_identObj);
        style = isItalic ? (style |= 1) : (style &= 0xFFFFFFFE);
        this.m_pfj.setFontStyle(this.m_identObj, style);
        if (this.m_identObj2 != null) {
            int drillStyle = this.m_pfj.getFontStyle(this.m_identObj2);
            drillStyle = isItalic ? (drillStyle |= 1) : (drillStyle &= 0xFFFFFFFE);
            this.m_pfj.setFontStyle(this.m_identObj2, drillStyle);
        }
    }

    public void setUnderline(boolean underline) {
        int style = this.m_pfj.getFontStyle(this.m_identObj);
        style = underline ? (style |= 4) : (style &= 0xFFFFFFFB);
        this.m_pfj.setFontStyle(this.m_identObj, style);
    }

    public String getGraphFontTypeface() {
        return this.m_pfj.getFontName(this.m_identObj);
    }

    public void setGraphFontTypeface(String name) {
        if (name == null) {
            this.m_commonGraph.getErrorHandler().log("invalid font name", this.getClass().toString(), "setGraphFontTypeface");
            return;
        }
        this.m_pfj.setFontName(this.m_identObj, name);
        if (this.m_identObj2 != null) {
            this.m_pfj.setFontName(this.m_identObj2, name);
        }
    }

    @Override
    public void setFont(Font f) {
        if (f == null) {
            this.m_commonGraph.getErrorHandler().log("invalid font", this.getClass().toString(), "setFont(Font f)");
            return;
        }
        int style = 0;
        switch (f.getStyle()) {
            case 0: {
                style = 0;
                break;
            }
            case 1: {
                style = 2;
                break;
            }
            case 2: {
                style = 1;
                break;
            }
            case 3: {
                style = 3;
                break;
            }
        }
        int newStyle = this.getGraphFontStyle() & 4 | style;
        this.m_pfj.setFontName(this.m_identObj, f.getName());
        if (this.m_identObj2 != null) {
            this.m_pfj.setFontName(this.m_identObj2, f.getName());
        }
        this.m_pfj.setFontStyle(this.m_identObj, newStyle);
        if (this.m_identObj2 != null) {
            newStyle = this.m_pfj.getFontStyle(this.m_identObj2) & 4 | style;
            this.m_pfj.setFontStyle(this.m_identObj2, newStyle);
        }
        this.setGraphFontSize(f.getSize());
    }

    @Override
    public Font getFont() {
        int style = 0;
        switch (this.m_pfj.getFontStyle(this.m_identObj)) {
            case 0: 
            case 4: {
                style = 0;
                break;
            }
            case 2: 
            case 6: {
                style = 1;
                break;
            }
            case 1: 
            case 5: {
                style = 2;
                break;
            }
            case 3: 
            case 7: {
                style = 3;
                break;
            }
        }
        return new Font(this.m_pfj.getFontName(this.m_identObj), style, this.m_pfj.getFontSize(this.m_identObj));
    }

    protected int convertStyleToInt(String str) {
        int style = 0;
        if (str.equals("FS_PLAIN")) {
            style = 0;
        } else if (str.equals("FS_ITALIC")) {
            style = 1;
        } else if (str.equals("FS_BOLD")) {
            style = 2;
        } else if (str.equals("FS_ITALIC_BOLD")) {
            style = 3;
        } else if (str.equals("FS_UNDERLINE")) {
            style = 4;
        } else if (str.equals("FS_ITALIC_UNDERLINE")) {
            style = 5;
        } else if (str.equals("FS_BOLD_UNDERLINE")) {
            style = 6;
        } else if (str.equals("FS_BOLD_ITALIC_UNDERLINE")) {
            style = 7;
        }
        return style;
    }

    @Override
    protected String getComponentName() {
        return "GraphFont";
    }

    protected void setObjectId(IdentObj id) {
        this.m_identObj = id;
    }

    @Override
    public boolean getStyleXML(boolean allProperties, ObjectNode node) {
        boolean styleOverridden = false;
        Object val = this.m_pfj.getFontName(this.m_identObj);
        if (val != null) {
            node.addProperty("name", (String)val);
            styleOverridden = true;
        }
        if ((val = this.m_pfj.getFontSizeObj(this.m_identObj)) != null) {
            node.addProperty("size", ((Integer)val).intValue());
            styleOverridden = true;
        }
        if ((val = this.getGraphFontColor()) != null) {
            node.addProperty("fontColor", BaseGraphComponent.toHexString(((Color)val).getRGB()));
            styleOverridden = true;
        }
        if ((val = this.m_pfj.getFontSizeVCObj(this.m_identObj)) != null) {
            node.addProperty(a_graphProportionalFontSize, ((Integer)val).intValue());
            styleOverridden = true;
        }
        if ((val = this.m_pfj.getFontStyleObj(this.m_identObj)) != null) {
            int style = (Integer)val;
            node.addProperty("bold", (style & 2) != 0);
            node.addProperty("italic", (style & 1) != 0);
            node.addProperty("underline", (style & 4) != 0);
            styleOverridden = true;
        }
        return styleOverridden;
    }

    @Override
    public void setNonstyleXML(ObjectNode node) {
        PropertyNode pNode = node.getProperty(a_style);
        if (pNode != null) {
            this.setGraphFontStyle(this.convertStyleToInt(pNode.getValueAsString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStyleXML(ObjectNode node, HashMap map) {
        this.m_jsfHashMap = map;
        try {
            this.setStyleXML(node);
        }
        finally {
            this.m_jsfHashMap = null;
        }
    }

    @Override
    public void setStyleXML(ObjectNode node) {
        PropertyNode pNode = node.getProperty("name");
        if (pNode != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("name", pNode.getValueAsString());
            } else {
                this.setGraphFontTypeface(pNode.getValueAsString());
            }
        }
        if ((pNode = node.getProperty("size")) != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("size", new Integer(pNode.getValueAsInteger()));
            } else {
                this.setGraphFontSize(pNode.getValueAsInteger());
            }
        }
        if ((pNode = node.getProperty(a_graphProportionalFontSize)) != null) {
            this.setGraphProportionalFontSize(pNode.getValueAsInteger());
        }
        if ((pNode = node.getProperty("fontColor")) != null) {
            Color c = new Color(BaseGraphComponent.hexStringToInt(pNode.getValueAsString()), true);
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("fontColor", c);
            } else {
                this.setGraphFontColor(c);
            }
        }
        if ((pNode = node.getProperty("bold")) != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("bold", pNode.getValueAsBoolean());
            } else {
                this.setFontBold(pNode.getValueAsBoolean());
            }
        }
        if ((pNode = node.getProperty("italic")) != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("italic", pNode.getValueAsBoolean());
            } else {
                this.setFontItalic(pNode.getValueAsBoolean());
            }
        }
        if ((pNode = node.getProperty("underline")) != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("underline", pNode.getValueAsBoolean());
            } else {
                this.setUnderline(pNode.getValueAsBoolean());
            }
        }
    }

    protected void resetStyle() {
        this.m_pfj.setFontName(this.m_identObj, "Sanserif");
        this.m_pfj.setFontStyle(this.m_identObj, 2);
        this.m_pfj.setFontSize(this.m_identObj, 12);
        this.m_pfj.setFillColor(this.m_identObj, Color.black);
        this.m_pfj.setFontSizeVC(this.m_identObj, 1000);
    }
}

