/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.gauge;

import oracle.dss.dataView.managers.ViewFormat;
import oracle.dss.gauge.BaseText;
import oracle.dss.gauge.CommonGauge;
import oracle.dss.gauge.GaugeDefaultValues;

public class TickLabel
extends BaseText {
    public static final String name = "TickLabel";
    protected static final String tc_none = "TC_NONE";
    protected static final String tc_minmax = "TC_MIN_MAX";
    protected static final String tc_increments = "TC_INCREMENTS";
    protected static final String tc_threshold = "TC_THRESHOLD";
    protected static final String tc_metric = "TC_METRIC";
    protected static final String tlp_interior = "TLP_INTERIOR";
    protected static final String tlp_exterior = "TLP_EXTERIOR";

    public TickLabel(CommonGauge gauge) {
        super(gauge, 12);
    }

    public int getContent() {
        Object obj = this.m_commonGauge.getAttribute("TickLabelContent");
        if (obj == null) {
            return GaugeDefaultValues.getTickLabelContent();
        }
        return (Integer)obj;
    }

    public void setContent(int content) {
        if (content < 0 || content > 63) {
            this.m_commonGauge.getErrorHandler().log("invalid content value", this.getClass().getName(), "TickLabel.setContent");
            return;
        }
        this.m_commonGauge.setAttribute("TickLabelContent", new Integer(content));
    }

    public static int convertTickContentToInt(String string) {
        if (string.contains(tc_none)) {
            return 0;
        }
        int content = 0;
        if (string.indexOf(tc_minmax) != -1) {
            content |= 3;
        }
        if (string.indexOf(tc_increments) != -1) {
            content |= 4;
        }
        if (string.indexOf(tc_threshold) != -1) {
            content |= 8;
        }
        if (string.indexOf(tc_metric) != -1) {
            content |= 0x10;
        }
        if (content == 0) {
            return -1;
        }
        return content;
    }

    public int getPosition() {
        Object obj = this.m_commonGauge.getAttribute("TickLabelPosition");
        if (obj == null) {
            return GaugeDefaultValues.getTickLabelPosition();
        }
        return (Integer)obj;
    }

    public void setPosition(int position) {
        if (position < 0 || position > 1) {
            this.m_commonGauge.getErrorHandler().log("invalid position value", this.getClass().getName(), "TickLabel.setPosition");
            return;
        }
        this.m_commonGauge.setAttribute("TickLabelPosition", new Integer(position));
    }

    public static int convertTickLabelPositionToInt(String string) {
        if (string.equals(tlp_interior)) {
            return 0;
        }
        if (string.equals(tlp_exterior)) {
            return 1;
        }
        return GaugeDefaultValues.getTickLabelPosition();
    }

    public ViewFormat getViewFormat() {
        ViewFormat vf = (ViewFormat)((Object)this.m_commonGauge.getAttribute("TickLabelViewFormat"));
        if (vf == null) {
            vf = new ViewFormat();
            this.m_commonGauge.setAttribute("TickLabelViewFormat", (Object)vf);
        }
        return vf;
    }

    public void setViewFormat(ViewFormat viewFormat) {
        if (viewFormat == null) {
            this.m_commonGauge.getErrorHandler().log("invalid ViewFormat", this.getClass().getName(), "TickLabel.setViewFormat");
            return;
        }
        this.m_commonGauge.setAttribute("TickLabelViewFormat", (Object)((ViewFormat)((Object)viewFormat.clone())));
    }

    public int getNumberType() {
        Object obj = this.m_commonGauge.getAttribute("TickLabelNumberType");
        if (obj == null) {
            obj = new Integer(GaugeDefaultValues.getNumberType());
        }
        return (Integer)obj;
    }

    public void setNumberType(int type) {
        if (type < 0 || type > 1) {
            this.m_commonGauge.getErrorHandler().log("invalid number type", this.getClass().getName(), "setNumberType");
            return;
        }
        this.m_commonGauge.setAttribute("TickLabelNumberType", new Integer(type));
    }
}

