/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.gauge;

import java.awt.Dimension;
import oracle.dss.gauge.GaugeDefaultValues;

public class GaugeLayout {
    protected static final int GENERIC_HORIZONTAL_GAP = 5;
    protected static final int GENERIC_VERTICAL_GAP = 3;
    protected static final int GENERIC_GAUGESET_GAP = 5;
    protected static final int GAP_GAUGESET_LEFT = 10;
    protected static final int GAP_GAUGESET_RIGHT = 10;
    protected static final int GAP_GAUGESET_TOP = 3;
    protected static final int GAP_GAUGESET_BOTTOM = 6;
    protected static final int GAP_TOPLABEL_TITLESEPARATOR = 3;
    protected static final int GAP_TITLESEPARATOR_GAUGEFRAME = 10;
    protected static final int GAP_GAUGEFRAME_LOWERLABELFRAME = 5;
    protected static final int DIAL_MIN_GAP_PLOTAREA_GAUGEFRAME = 5;
    protected static final int DIAL_HEIGHT = 40;
    protected static final int MAX_STATUSMETER_SIZE = 25;
    protected static final int MIN_STATUSMETER_SIZE = 12;
    protected static final int MIN_VERTICAL_STATUSMETER_LENGTH = 40;
    protected static final int LED_SIZE = 20;
    protected static final double STATUSMETER_INDICATOR_HEIGHT_RATIO = 0.4;
    protected static final int STATUSMETER_MIN_ROUNDED_SIZE = 10;
    private static final int DEFAULT_IMAGE_WIDTH = GaugeDefaultValues.getImageWidth();
    private static final int DEFAULT_IMAGE_HEIGHT = GaugeDefaultValues.getImageHeight();
    private static final int MIN_GAP_SIZE = 1;
    private final int m_imageWidth;
    private final int m_imageHeight;
    private boolean m_bUseScaling;

    protected GaugeLayout(Dimension imageSize) {
        this.m_imageWidth = imageSize.width;
        this.m_imageHeight = imageSize.height;
        this.m_bUseScaling = false;
    }

    protected void setScalingUsed(boolean useScaling) {
        this.m_bUseScaling = useScaling;
    }

    protected boolean isScalingUsed() {
        return this.m_bUseScaling;
    }

    protected int getGapWidth(int defaultGapSize) {
        if (!this.m_bUseScaling || this.m_imageWidth >= DEFAULT_IMAGE_WIDTH) {
            return defaultGapSize;
        }
        return Math.max(defaultGapSize * this.m_imageWidth / DEFAULT_IMAGE_WIDTH, 1);
    }

    protected int getGapHeight(int defaultGapSize) {
        if (!this.m_bUseScaling || this.m_imageHeight >= DEFAULT_IMAGE_HEIGHT) {
            return defaultGapSize;
        }
        return Math.max(defaultGapSize * this.m_imageHeight / DEFAULT_IMAGE_HEIGHT, 1);
    }

    protected int getGapSize(int defaultGapSize) {
        return Math.min(this.getGapWidth(defaultGapSize), this.getGapHeight(defaultGapSize));
    }

    protected static int getStatusmeterIndicatorSize(int statusmeterSize) {
        int indicatorSize = (int)Math.ceil((double)statusmeterSize * 0.4);
        if ((statusmeterSize - indicatorSize) % 2 != 0) {
            ++indicatorSize;
        }
        return indicatorSize;
    }
}

