/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PrinterJob;
import java.io.PrintWriter;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.help.HelpProvider;
import oracle.bali.ewt.util.WindowUtils;
import oracle.bali.share.nls.StringUtils;
import oracle.dss.dataView.ViewPrinter;
import oracle.dss.dataView.gui.PageSelectionPanel;
import oracle.dss.dataView.gui.PageSetupDialog;
import oracle.dss.dataView.gui.PreviewDialogProvider;
import oracle.dss.dataView.gui.PrintDialog;
import oracle.dss.dataView.gui.PrintDialogsAdapter;

public class PrintPanel
extends PageSelectionPanel {
    private static final long serialVersionUID = 1L;
    private ResourceBundle rBundle = null;
    private JLabel m_whereToExportLabel;
    private JLabel m_whatNameLabel;
    private PrintDialog m_printDialog;
    private PageSetupDialog pageSetup = null;
    private JButton pageBtn;
    protected JComboBox m_exportFormatComboBox;
    protected int m_exportFormatComboOffset;
    protected JPanel m_WhereToExportPanel;
    protected JTextField m_WhereToExportTextField;
    protected JTextField m_WhatNameTextField;
    protected JButton m_BrowseButton;
    protected int m_layer;
    protected String m_lastDir = "";
    protected boolean m_bLocalFileAccess = true;
    protected String m_strPath = "";
    protected String m_strFilename = "";
    protected boolean m_bViewIsCrosstab = true;
    protected PrintWriter m_printWriter = null;
    protected String m_strHelpContextID;
    protected boolean m_bHelpEnabled;
    protected HelpProvider m_helpProvider;
    protected Frame m_frame;
    protected ViewPrinter m_viewPrinter;
    protected PrinterJob m_printerJob;

    public PrintPanel(ViewPrinter printer) {
        this.m_viewPrinter = printer;
        this.updateResourceBundle(printer.getDataview().getLocale());
        this.m_dataAccess = this.m_viewPrinter.getDataview().getModel().getDataAccess();
        this.m_dataDirector = this.m_viewPrinter.getDataview().getModel().getDataDirector();
        this.constructPanel();
        this._init();
    }

    private void constructPanel() {
        super.constructPanel(0);
        String strInsert = "";
        this.m_applicationName = this.rBundle.getString("title");
        int iWidth = Integer.parseInt(this.rBundle.getString("PrintPanelWidth"));
        int iHeight = Integer.parseInt(this.rBundle.getString("PrintPanelHeight"));
        this.setPreferredSize(new Dimension(iWidth, iHeight));
        this.setMinimumSize(this.getPreferredSize());
        this.setMaximumSize(this.getPreferredSize());
        this.add(Box.createVerticalStrut(5));
        this.m_translatedText = this.rBundle.getString("pagesetup");
        this.pageBtn = new JButton(StringUtils.stripMnemonic((String)this.m_translatedText));
        this.pageBtn.setMnemonic(StringUtils.getMnemonicKeyCode((String)this.m_translatedText));
        JPanel pageSetupPanel = new JPanel(new FlowLayout(2));
        pageSetupPanel.setAlignmentX(0.0f);
        pageSetupPanel.add(this.pageBtn);
        this.add(pageSetupPanel);
        this.pageBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrintPanel.this.apply();
                if (PrintPanel.this.m_printerJob == null) {
                    PrintPanel.this.m_printerJob = PrinterJob.getPrinterJob();
                }
                ViewPrinter[] prns = new ViewPrinter[]{PrintPanel.this.m_viewPrinter};
                PrintDialogsAdapter pda = new PrintDialogsAdapter(PrintPanel.this.m_viewPrinter, PrintPanel.this.m_printDialog, PrintPanel.this.m_printerJob);
                pda.setHelpProvider(PrintPanel.this.getHelpProvider());
                PrintPanel.this.pageSetup = new PageSetupDialog(WindowUtils.parentFrame((Component)PrintPanel.this), PrintPanel.this.rBundle.getString("pgsetup"), true, prns, (PreviewDialogProvider)pda);
                PrintPanel.this.pageSetup.setHelpProvider(PrintPanel.this.getHelpProvider());
                PrintPanel.this.pageSetup.setLocationRelativeTo(PrintPanel.this.pageBtn);
                PrintPanel.this.pageSetup.setVisible(true);
            }
        });
        this.add(Box.createVerticalGlue());
    }

    @Override
    protected void _init() {
        super._init();
        if (this.m_layerCount == 0 || this.m_pageCount == 1L) {
            return;
        }
        if (this.m_viewPrinter.getRangeType() == 0) {
            this.m_CurrentSelectionsButton.setSelected(true);
        } else if (this.m_viewPrinter.getRangeType() == 1) {
            this.m_All28Button.setSelected(true);
        } else {
            this.m_SelectedCombinationsButton.setSelected(true);
        }
    }

    protected void setPrintDialog(PrintDialog dialog) {
        this.m_printDialog = dialog;
    }

    public String getHelpContextID() {
        return this.getClass().getName();
    }

    public void setHelpContextID(String strHelpContextID) {
        this.m_strHelpContextID = strHelpContextID;
    }

    public void setHelpEnabled(boolean bValue) {
        this.m_bHelpEnabled = bValue;
    }

    public boolean isHelpEnabled() {
        return this.m_bHelpEnabled;
    }

    public void setHelpProvider(HelpProvider helpProvider) {
        this.m_helpProvider = helpProvider;
    }

    public HelpProvider getHelpProvider() {
        return this.m_helpProvider;
    }

    public boolean apply() {
        boolean bCanPrint = true;
        int range = 0;
        if (this.m_CurrentSelectionsButton.isSelected()) {
            range = 0;
        } else if (this.m_All28Button.isSelected()) {
            range = 1;
        } else if (this.m_SelectedCombinationsButton.isSelected()) {
            range = 2;
            if (!this.isAllLayersSelected()) {
                return false;
            }
        }
        this.m_viewPrinter.setRangeType(range);
        try {
            if (range == 2) {
                Vector listPrintHPos = null;
                bCanPrint = this.buildExportVectorArray();
                if (bCanPrint) {
                    listPrintHPos = this.buildListExportHPos();
                    this.m_viewPrinter.setSelectedHPos(listPrintHPos);
                }
            }
            if (bCanPrint) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    @Override
    public void setLocale(Locale loc) {
        this.m_locale = loc;
        this.updateResourceBundle(loc);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.m_SelectAllButton) {
            this.selectAllMembers();
        } else if (e.getSource() == this.m_DeselectAllButton) {
            this.deselectAllMembers();
        }
    }

    void setPrinterJob(PrinterJob printerJob) {
        this.m_printerJob = printerJob;
    }

    private void displayErrorMessage(String strError) {
        JDialog tmpDialog = new JOptionPane(this.rBundle.getString(strError), 0, -1, new ImageIcon(ImageUtils.getImageResource(PrintPanel.class, (String)"images/stop.gif"))).createDialog(this, this.m_applicationName);
        tmpDialog.show();
    }

    @Override
    protected void updateResourceBundle(Locale loc) {
        super.updateResourceBundle(loc);
        this.rBundle = loc != null ? ResourceBundle.getBundle("oracle.dss.dataView.gui.resource.DataviewGUIBundle", loc) : ResourceBundle.getBundle("oracle.dss.dataView.gui.resource.DataviewGUIBundle");
    }
}

