/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView.gui;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.olaf.OracleLookAndFeel;
import oracle.dss.dataView.ComponentHandle;
import oracle.dss.dataView.ControllerEvent;
import oracle.dss.dataView.DataviewTitles;
import oracle.dss.dataView.GraphAttribute;
import oracle.dss.dataView.GridViewAttribute;
import oracle.dss.dataView.HorizontalAlignment;
import oracle.dss.dataView.UIView;
import oracle.dss.dataView.gui.DataviewTool;
import oracle.dss.dataView.gui.DataviewToolbarRollover;
import oracle.dss.dataView.gui.ToolBar;
import oracle.dss.dataView.managers.ViewStyle;
import oracle.dss.formattedTextArea.UIFormattedTextView;
import oracle.dss.pagingControl.PageItemComponentHandle;

public class HorizontalAlignmentTool
extends JToolBar
implements DataviewToolbarRollover,
DataviewTool,
ActionListener {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_FONT_ALIGNMENT = "FontAlignment";
    protected Object m_selectedObject = null;
    protected ComponentHandle m_selectedComponentHandle = null;
    protected UIView m_currentDataview = null;
    protected ToolBar m_toolBar = null;
    private static final Insets insets0 = new Insets(0, 0, 0, 0);
    protected JToggleButton m_alignLeft = null;
    protected JToggleButton m_alignCenter = null;
    protected JToggleButton m_alignRight = null;
    protected JToggleButton m_alignDefault = null;
    protected JToggleButton m_none = null;
    private ResourceBundle rBundle = null;
    private boolean m_enable = true;
    protected boolean m_bRolloverIconEnabled = false;
    private MouseListener m_mouseListener;
    private MouseListener m_mouseFocusListener = null;
    private boolean m_bSuperCalled = true;

    public HorizontalAlignmentTool() {
        this.updateResourceBundle(Locale.getDefault());
        this.setBorder(null);
        this.m_alignLeft = new JToggleButton(this.makeImage("images/left_18t.gif"));
        this.m_alignLeft.setDisabledIcon(new ImageIcon(ImageUtils.createDisabledImage((Image)((ImageIcon)this.m_alignLeft.getIcon()).getImage())));
        this.m_alignLeft.setMargin(insets0);
        this.m_alignLeft.setEnabled(false);
        this.m_alignLeft.addActionListener(this);
        this.m_alignLeft.setBorderPainted(false);
        this.m_alignCenter = new JToggleButton(this.makeImage("images/center_18t.gif"));
        this.m_alignCenter.setDisabledIcon(new ImageIcon(ImageUtils.createDisabledImage((Image)((ImageIcon)this.m_alignCenter.getIcon()).getImage())));
        this.m_alignCenter.setEnabled(false);
        this.m_alignCenter.setMargin(insets0);
        this.m_alignCenter.addActionListener(this);
        this.m_alignCenter.setBorderPainted(false);
        this.m_alignRight = new JToggleButton(this.makeImage("images/right_18t.gif"));
        this.m_alignRight.setDisabledIcon(new ImageIcon(ImageUtils.createDisabledImage((Image)((ImageIcon)this.m_alignRight.getIcon()).getImage())));
        this.m_alignRight.setEnabled(false);
        this.m_alignRight.setMargin(insets0);
        this.m_alignRight.addActionListener(this);
        this.m_alignRight.setBorderPainted(false);
        this.m_alignDefault = new JToggleButton(this.makeImage("images/start.gif"));
        this.m_alignDefault.setDisabledIcon(new ImageIcon(ImageUtils.createDisabledImage((Image)((ImageIcon)this.m_alignDefault.getIcon()).getImage())));
        this.m_alignDefault.setEnabled(false);
        this.m_alignDefault.setMargin(insets0);
        this.m_alignDefault.addActionListener(this);
        this.m_alignDefault.setBorderPainted(false);
        this.m_alignLeft.setToolTipText(this.rBundle.getString("AL_Left"));
        this.m_alignCenter.setToolTipText(this.rBundle.getString("AL_Center"));
        this.m_alignRight.setToolTipText(this.rBundle.getString("AL_Right"));
        this.m_alignDefault.setToolTipText(this.rBundle.getString("AL_Start"));
        this.add(this.m_alignLeft);
        this.add(this.m_alignCenter);
        this.add(this.m_alignRight);
        this.add(this.m_alignDefault);
        ButtonGroup group = new ButtonGroup();
        group.add(this.m_alignLeft);
        group.add(this.m_alignCenter);
        group.add(this.m_alignRight);
        group.add(this.m_alignDefault);
        this.m_none = new JToggleButton();
        group.add(this.m_none);
        if (!(UIManager.getLookAndFeel() instanceof OracleLookAndFeel)) {
            this.m_mouseListener = new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    if (!HorizontalAlignmentTool.this.isRolloverIconEnabled()) {
                        ((JToggleButton)e.getSource()).setBorderPainted(true);
                    }
                    if (!HorizontalAlignmentTool.this.m_alignCenter.isEnabled()) {
                        ((JToggleButton)e.getSource()).setBorderPainted(((JToggleButton)e.getSource()).isSelected());
                    }
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    if (!HorizontalAlignmentTool.this.isRolloverIconEnabled()) {
                        ((JToggleButton)e.getSource()).setBorderPainted(((JToggleButton)e.getSource()).isSelected());
                    }
                }
            };
            this.m_alignCenter.setPreferredSize(new Dimension(24, 24));
            this.m_alignCenter.setMinimumSize(this.m_alignCenter.getPreferredSize());
            this.m_alignCenter.setMaximumSize(this.m_alignCenter.getPreferredSize());
            this.m_alignCenter.addMouseListener(this.m_mouseListener);
            this.m_alignLeft.setPreferredSize(new Dimension(24, 24));
            this.m_alignLeft.setMinimumSize(this.m_alignLeft.getPreferredSize());
            this.m_alignLeft.setMaximumSize(this.m_alignLeft.getPreferredSize());
            this.m_alignLeft.addMouseListener(this.m_mouseListener);
            this.m_alignRight.setPreferredSize(new Dimension(24, 24));
            this.m_alignRight.setMinimumSize(this.m_alignRight.getPreferredSize());
            this.m_alignRight.setMaximumSize(this.m_alignRight.getPreferredSize());
            this.m_alignRight.addMouseListener(this.m_mouseListener);
            this.m_alignDefault.setPreferredSize(new Dimension(24, 24));
            this.m_alignDefault.setMinimumSize(this.m_alignDefault.getPreferredSize());
            this.m_alignDefault.setMaximumSize(this.m_alignDefault.getPreferredSize());
            this.m_alignDefault.addMouseListener(this.m_mouseListener);
        } else {
            MouseAdapter m_mouseFocusListener = new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getSource() == HorizontalAlignmentTool.this.m_alignLeft) {
                        HorizontalAlignmentTool.this.m_alignLeft.getParent().requestFocus();
                    } else if (e.getSource() == HorizontalAlignmentTool.this.m_alignCenter) {
                        HorizontalAlignmentTool.this.m_alignCenter.getParent().requestFocus();
                    } else if (e.getSource() == HorizontalAlignmentTool.this.m_alignRight) {
                        HorizontalAlignmentTool.this.m_alignRight.getParent().requestFocus();
                    } else if (e.getSource() == HorizontalAlignmentTool.this.m_alignDefault) {
                        HorizontalAlignmentTool.this.m_alignDefault.getParent().requestFocus();
                    }
                }
            };
            this.m_alignLeft.addMouseListener(m_mouseFocusListener);
            this.m_alignCenter.addMouseListener(m_mouseFocusListener);
            this.m_alignRight.addMouseListener(m_mouseFocusListener);
            this.m_alignDefault.addMouseListener(m_mouseFocusListener);
        }
    }

    @Override
    public void setLocale(Locale loc) {
        super.setLocale(loc);
        if (!this.m_bSuperCalled) {
            return;
        }
        this.updateResourceBundle(loc);
        this.m_alignLeft.setToolTipText(this.rBundle.getString("AL_Left"));
        this.m_alignCenter.setToolTipText(this.rBundle.getString("AL_Center"));
        this.m_alignRight.setToolTipText(this.rBundle.getString("AL_Right"));
        this.m_alignDefault.setToolTipText(this.rBundle.getString("AL_Start"));
    }

    @Override
    public void selectedAction(ControllerEvent e, UIView currentDataView, ToolBar toolBar) {
        if (currentDataView == null) {
            return;
        }
        this.m_currentDataview = currentDataView;
        this.m_toolBar = toolBar;
        if (e == null) {
            return;
        }
        if (e.getComponentHandle() == null || this.m_currentDataview instanceof GraphAttribute && e.getComponentHandle().getComponent() == null) {
            this.m_selectedObject = null;
            this.m_selectedComponentHandle = null;
            this.m_alignLeft.setEnabled(false);
            this.m_alignCenter.setEnabled(false);
            this.m_alignRight.setEnabled(false);
            this.m_alignDefault.setEnabled(false);
            return;
        }
        Object selectedObject = e.getComponentHandle().getComponent();
        this.m_enable = false;
        if (this.isEnabled(e.getComponentHandle())) {
            this.m_selectedObject = selectedObject;
            this.m_selectedComponentHandle = e.getComponentHandle();
            this.m_alignLeft.setEnabled(true);
            this.m_alignCenter.setEnabled(true);
            this.m_alignRight.setEnabled(true);
            this.m_alignDefault.setEnabled(true);
            switch (this.getHorizontalAlignment()) {
                case 2: {
                    this.m_alignLeft.setSelected(true);
                    break;
                }
                case 0: {
                    this.m_alignCenter.setSelected(true);
                    break;
                }
                case 10: {
                    this.m_alignDefault.setSelected(true);
                    break;
                }
                default: {
                    this.m_alignRight.setSelected(true);
                }
            }
            this.m_alignLeft.setBorderPainted(this.m_alignLeft.isSelected());
            this.m_alignRight.setBorderPainted(this.m_alignRight.isSelected());
            this.m_alignCenter.setBorderPainted(this.m_alignCenter.isSelected());
            this.m_alignDefault.setBorderPainted(this.m_alignDefault.isSelected());
        } else {
            this.m_alignLeft.setEnabled(false);
            this.m_alignCenter.setEnabled(false);
            this.m_alignRight.setEnabled(false);
            this.m_alignDefault.setEnabled(false);
            this.m_selectedObject = null;
        }
        this.m_enable = true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e == null || !this.m_enable) {
            return;
        }
        if (e.getSource() == this.m_alignCenter) {
            this.setHorizontalAlignment(0);
            this.m_alignCenter.setSelected(true);
        } else if (e.getSource() == this.m_alignRight) {
            this.setHorizontalAlignment(4);
            this.m_alignRight.setSelected(true);
        } else if (e.getSource() == this.m_alignLeft) {
            this.setHorizontalAlignment(2);
            this.m_alignLeft.setSelected(true);
        } else if (e.getSource() == this.m_alignDefault) {
            this.setHorizontalAlignment(10);
            this.m_alignDefault.setSelected(true);
        }
        this.m_alignLeft.setBorderPainted(this.m_alignLeft.isSelected());
        this.m_alignRight.setBorderPainted(this.m_alignRight.isSelected());
        this.m_alignCenter.setBorderPainted(this.m_alignCenter.isSelected());
        this.m_alignDefault.setBorderPainted(this.m_alignDefault.isSelected());
    }

    @Override
    public void update() {
        this.m_alignLeft.setEnabled(this.isEnabled());
        this.m_alignCenter.setEnabled(this.isEnabled());
        this.m_alignRight.setEnabled(this.isEnabled());
        this.m_alignDefault.setEnabled(this.isEnabled());
    }

    private ImageIcon makeImage(String fileName) {
        return new ImageIcon(ImageUtils.getImageResource(ToolBar.class, (String)fileName));
    }

    private void updateResourceBundle(Locale loc) {
        this.rBundle = loc != null ? ResourceBundle.getBundle("oracle.dss.dataView.gui.resource.DataviewGUIBundle", loc) : ResourceBundle.getBundle("oracle.dss.dataView.gui.resource.DataviewGUIBundle");
    }

    @Override
    public void cleanUp() {
        this.m_alignLeft.removeActionListener(this);
        this.m_alignCenter.removeActionListener(this);
        this.m_alignRight.removeActionListener(this);
        this.m_alignDefault.removeActionListener(this);
        this.m_alignLeft.removeMouseListener(this.m_mouseListener);
        this.m_alignCenter.removeMouseListener(this.m_mouseListener);
        this.m_alignRight.removeMouseListener(this.m_mouseListener);
        this.m_alignDefault.removeMouseListener(this.m_mouseListener);
        if (this.m_mouseFocusListener != null) {
            this.m_alignLeft.removeMouseListener(this.m_mouseFocusListener);
            this.m_alignCenter.removeMouseListener(this.m_mouseFocusListener);
            this.m_alignRight.removeMouseListener(this.m_mouseFocusListener);
            this.m_alignDefault.removeMouseListener(this.m_mouseFocusListener);
        }
    }

    @Override
    public void setRolloverIconEnabled(boolean bEnabled) {
        this.m_bRolloverIconEnabled = bEnabled;
        if (bEnabled) {
            this.m_alignLeft.setIcon(this.makeImage("images/left.gif"));
            this.m_alignCenter.setIcon(this.makeImage("images/center.gif"));
            this.m_alignRight.setIcon(this.makeImage("images/right.gif"));
            this.m_alignDefault.setIcon(this.makeImage("images/start.gif"));
            this.m_alignLeft.setRolloverIcon(this.makeImage("images/l_left.gif"));
            this.m_alignLeft.setRolloverSelectedIcon(this.makeImage("images/l_left.gif"));
            this.m_alignCenter.setRolloverIcon(this.makeImage("images/l_center.gif"));
            this.m_alignCenter.setRolloverSelectedIcon(this.makeImage("images/l_center.gif"));
            this.m_alignRight.setRolloverIcon(this.makeImage("images/l_right.gif"));
            this.m_alignRight.setRolloverSelectedIcon(this.makeImage("images/l_right.gif"));
            this.m_alignDefault.setRolloverIcon(this.makeImage("images/l_start.gif"));
            this.m_alignDefault.setRolloverSelectedIcon(this.makeImage("images/l_start.gif"));
        } else {
            this.m_alignLeft.setIcon(this.makeImage("images/left_18t.gif"));
            this.m_alignCenter.setIcon(this.makeImage("images/center_18t.gif"));
            this.m_alignRight.setIcon(this.makeImage("images/right_18t.gif"));
            this.m_alignDefault.setIcon(this.makeImage("images/start.gif"));
            this.m_alignLeft.setRolloverIcon(null);
            this.m_alignLeft.setRolloverSelectedIcon(null);
            this.m_alignCenter.setRolloverIcon(null);
            this.m_alignCenter.setRolloverSelectedIcon(null);
            this.m_alignRight.setRolloverIcon(null);
            this.m_alignRight.setRolloverSelectedIcon(null);
            this.m_alignDefault.setRolloverIcon(null);
            this.m_alignDefault.setRolloverSelectedIcon(null);
        }
        this.m_alignLeft.setDisabledIcon(new ImageIcon(ImageUtils.createDisabledImage((Image)((ImageIcon)this.m_alignLeft.getIcon()).getImage())));
        this.m_alignRight.setDisabledIcon(new ImageIcon(ImageUtils.createDisabledImage((Image)((ImageIcon)this.m_alignRight.getIcon()).getImage())));
        this.m_alignCenter.setDisabledIcon(new ImageIcon(ImageUtils.createDisabledImage((Image)((ImageIcon)this.m_alignCenter.getIcon()).getImage())));
        this.m_alignDefault.setDisabledIcon(new ImageIcon(ImageUtils.createDisabledImage((Image)((ImageIcon)this.m_alignDefault.getIcon()).getImage())));
    }

    @Override
    public boolean isRolloverIconEnabled() {
        return this.m_bRolloverIconEnabled;
    }

    private boolean isEnabled(ComponentHandle selectedComponentHandle) {
        if (this.m_currentDataview instanceof GridViewAttribute && ((GridViewAttribute)((Object)this.m_currentDataview)).getComponentViewStyle(selectedComponentHandle) != null) {
            return true;
        }
        if (this.m_currentDataview instanceof GraphAttribute && selectedComponentHandle instanceof PageItemComponentHandle && ((GraphAttribute)((Object)this.m_currentDataview)).getComponentViewStyle(selectedComponentHandle) != null) {
            return true;
        }
        if (selectedComponentHandle.getComponent() instanceof HorizontalAlignment && this.isEnabled()) {
            return true;
        }
        if (selectedComponentHandle.getComponent() instanceof UIFormattedTextView) {
            return ((UIFormattedTextView)selectedComponentHandle.getComponent()).isEditable();
        }
        return false;
    }

    private int getHorizontalAlignment() {
        ViewStyle viewStyle;
        UIFormattedTextView view;
        if (this.m_selectedObject instanceof UIFormattedTextView && (view = (UIFormattedTextView)this.m_selectedObject).isEditable() && !view.isCurrentAttributeChanging()) {
            return view.getHorizontalAlignment();
        }
        if (this.m_selectedComponentHandle.getID() == 6 || this.m_selectedComponentHandle.getID() == 7 || this.m_selectedComponentHandle.getID() == 8) {
            return ((DataviewTitles)this.m_selectedObject).getHorizontalAlignment();
        }
        if (this.m_currentDataview instanceof GridViewAttribute) {
            viewStyle = ((GridViewAttribute)((Object)this.m_currentDataview)).getComponentViewStyle(this.m_selectedComponentHandle);
            return viewStyle.getHorizontalAlignment();
        }
        if (this.m_currentDataview instanceof GraphAttribute && this.m_selectedComponentHandle instanceof PageItemComponentHandle && ((GraphAttribute)((Object)this.m_currentDataview)).getComponentViewStyle(this.m_selectedComponentHandle) != null) {
            viewStyle = ((GraphAttribute)((Object)this.m_currentDataview)).getComponentViewStyle(this.m_selectedComponentHandle);
            return viewStyle.getHorizontalAlignment();
        }
        if (this.m_selectedObject instanceof HorizontalAlignment) {
            return ((HorizontalAlignment)this.m_selectedObject).getHorizontalAlignment();
        }
        return 0;
    }

    private void setHorizontalAlignment(int alignment) {
        int oldAlign = this.getHorizontalAlignment();
        if (this.m_selectedComponentHandle.getID() == 6 || this.m_selectedComponentHandle.getID() == 7 || this.m_selectedComponentHandle.getID() == 8) {
            ((DataviewTitles)this.m_selectedObject).setHorizontalAlignment(alignment);
        } else if (this.m_currentDataview instanceof GridViewAttribute) {
            ViewStyle viewStyle = new ViewStyle();
            viewStyle.setHorizontalAlignment(alignment);
            ((GridViewAttribute)((Object)this.m_currentDataview)).applyViewStyle(this.m_selectedComponentHandle, viewStyle);
            if (!this.m_toolBar.hideAlertInFuture() && !((GridViewAttribute)((Object)this.m_currentDataview)).compareComponentViewStyle(this.m_selectedComponentHandle, viewStyle)) {
                this.m_toolBar.displayFormatAlert();
            }
        } else if (this.m_currentDataview instanceof GraphAttribute && this.m_selectedComponentHandle instanceof PageItemComponentHandle && ((GraphAttribute)((Object)this.m_currentDataview)).getComponentViewStyle(this.m_selectedComponentHandle) != null) {
            ViewStyle viewStyle = new ViewStyle();
            viewStyle.setHorizontalAlignment(alignment);
            ((GraphAttribute)((Object)this.m_currentDataview)).applyViewStyle(this.m_selectedComponentHandle, viewStyle);
        } else if (this.m_selectedObject instanceof HorizontalAlignment) {
            ((HorizontalAlignment)this.m_selectedObject).setHorizontalAlignment(alignment);
        } else if (this.m_selectedObject instanceof UIFormattedTextView) {
            ((UIFormattedTextView)this.m_selectedObject).setHorizontalAlignment(alignment);
        } else {
            return;
        }
        this.firePropertyChange(PROPERTY_FONT_ALIGNMENT, oldAlign, alignment);
    }
}

