/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView.gui;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.olaf.OracleLookAndFeel;
import oracle.dss.dataView.ColumnComponentHandle;
import oracle.dss.dataView.ColumnRangeComponentHandle;
import oracle.dss.dataView.ComponentHandle;
import oracle.dss.dataView.ControllerEvent;
import oracle.dss.dataView.DataComponentHandle;
import oracle.dss.dataView.DataRangeComponentHandle;
import oracle.dss.dataView.GraphAttribute;
import oracle.dss.dataView.GridViewAttribute;
import oracle.dss.dataView.NonDataComponentHandle;
import oracle.dss.dataView.RowComponentHandle;
import oracle.dss.dataView.RowRangeComponentHandle;
import oracle.dss.dataView.UIView;
import oracle.dss.dataView.gui.DataviewTool;
import oracle.dss.dataView.gui.DataviewToolbarRollover;
import oracle.dss.dataView.gui.ToolBar;
import oracle.dss.dataView.managers.ViewFormat;
import oracle.dss.util.ColumnComponentInfo;
import oracle.dss.util.DataAccess;
import oracle.dss.util.DataComponentInfo;
import oracle.dss.util.RowComponentInfo;

public class DecimalTool
extends JToolBar
implements DataviewToolbarRollover,
DataviewTool,
ActionListener {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_DECIMAL_DIGIT = "DecimalDigit";
    protected Object m_selectedObject = null;
    protected ComponentHandle m_selectedComponentHandle = null;
    protected UIView m_currentDataview = null;
    protected ToolBar m_toolBar = null;
    private static final Insets insets0 = new Insets(0, 0, 0, 0);
    protected JButton m_addDecimal = new JButton(this.makeImage("images/DecimalRight_18t.gif"));
    protected JButton m_delDecimal = null;
    private ResourceBundle rBundle = null;
    private boolean m_enable = true;
    protected boolean m_bRolloverIconEnabled = false;
    private MouseListener m_mouseListener;
    private boolean m_bSuperCalled = true;

    public DecimalTool() {
        this.m_addDecimal.setDisabledIcon(new ImageIcon(ImageUtils.createDisabledImage((Image)((ImageIcon)this.m_addDecimal.getIcon()).getImage())));
        this.m_addDecimal.setMargin(insets0);
        this.m_addDecimal.setEnabled(false);
        this.m_addDecimal.addActionListener(this);
        this.m_delDecimal = new JButton(this.makeImage("images/DecimalLeft_18t.gif"));
        this.m_delDecimal.setDisabledIcon(new ImageIcon(ImageUtils.createDisabledImage((Image)((ImageIcon)this.m_delDecimal.getIcon()).getImage())));
        this.m_delDecimal.setEnabled(false);
        this.m_delDecimal.setMargin(insets0);
        this.m_delDecimal.addActionListener(this);
        this.updateResourceBundle(Locale.getDefault());
        this.m_addDecimal.setToolTipText(this.rBundle.getString("AddDecimal"));
        this.m_delDecimal.setToolTipText(this.rBundle.getString("DelDecimal"));
        this.add(this.m_addDecimal);
        this.add(this.m_delDecimal);
        this.setBorder(null);
        this.m_addDecimal.setBorderPainted(false);
        this.m_delDecimal.setBorderPainted(false);
        if (!(UIManager.getLookAndFeel() instanceof OracleLookAndFeel)) {
            this.m_mouseListener = new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    if (!DecimalTool.this.isRolloverIconEnabled()) {
                        ((JButton)e.getSource()).setBorderPainted(true);
                    }
                    if (!((JButton)e.getSource()).isEnabled()) {
                        DecimalTool.this.setBorderPainted(((JButton)e.getSource()).isSelected());
                    }
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    if (!DecimalTool.this.isRolloverIconEnabled()) {
                        ((JButton)e.getSource()).setBorderPainted(((JButton)e.getSource()).isSelected());
                    }
                }
            };
            this.m_addDecimal.setPreferredSize(new Dimension(24, 24));
            this.m_addDecimal.setMinimumSize(this.m_addDecimal.getPreferredSize());
            this.m_addDecimal.setMaximumSize(this.m_addDecimal.getPreferredSize());
            this.m_addDecimal.addMouseListener(this.m_mouseListener);
            this.m_delDecimal.setPreferredSize(new Dimension(24, 24));
            this.m_delDecimal.setMinimumSize(this.m_delDecimal.getPreferredSize());
            this.m_delDecimal.setMaximumSize(this.m_delDecimal.getPreferredSize());
            this.m_delDecimal.addMouseListener(this.m_mouseListener);
        }
    }

    @Override
    public void setLocale(Locale loc) {
        super.setLocale(loc);
        if (!this.m_bSuperCalled) {
            return;
        }
        this.updateResourceBundle(loc);
        this.m_addDecimal.setToolTipText(this.rBundle.getString("AddDecimal"));
        this.m_delDecimal.setToolTipText(this.rBundle.getString("DelDecimal"));
    }

    @Override
    public void selectedAction(ControllerEvent e, UIView currentDataView, ToolBar toolBar) {
        if (currentDataView == null) {
            return;
        }
        this.m_currentDataview = currentDataView;
        this.m_toolBar = toolBar;
        if (e == null) {
            return;
        }
        if (e.getComponentHandle() == null) {
            this.m_selectedObject = null;
            this.m_selectedComponentHandle = null;
            this.m_addDecimal.setEnabled(false);
            this.m_delDecimal.setEnabled(false);
            return;
        }
        Object selectedObject = e.getComponentHandle().getComponent();
        this.m_enable = false;
        if (this.isEnabled(e.getComponentHandle())) {
            this.m_selectedObject = selectedObject;
            this.m_selectedComponentHandle = e.getComponentHandle();
            this.m_addDecimal.setEnabled(true);
            this.m_delDecimal.setEnabled(true);
            this.m_addDecimal.setEnabled(true);
            if (this.getDecimal() <= 0) {
                this.m_delDecimal.setEnabled(false);
            } else {
                this.m_delDecimal.setEnabled(true);
            }
        } else {
            this.m_addDecimal.setEnabled(false);
            this.m_delDecimal.setEnabled(false);
            this.m_selectedObject = null;
        }
        this.m_enable = true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e == null || !this.m_enable) {
            return;
        }
        if (e.getSource() == this.m_addDecimal) {
            this.addDecimal();
            return;
        }
        if (e.getSource() == this.m_delDecimal) {
            this.delDecimal();
            return;
        }
    }

    @Override
    public void setRolloverIconEnabled(boolean bEnabled) {
        this.m_bRolloverIconEnabled = bEnabled;
        if (bEnabled) {
            this.m_addDecimal.setIcon(this.makeImage("images/DecimalRight.gif"));
            this.m_delDecimal.setIcon(this.makeImage("images/DecimalLeft.gif"));
            this.m_addDecimal.setRolloverIcon(this.makeImage("images/l_DecimalRight.gif"));
            this.m_delDecimal.setRolloverIcon(this.makeImage("images/l_DecimalLeft.gif"));
        } else {
            this.m_addDecimal.setIcon(this.makeImage("images/DecimalRight_18t.gif"));
            this.m_delDecimal.setIcon(this.makeImage("images/DecimalLeft_18t.gif"));
            this.m_addDecimal.setRolloverIcon(null);
            this.m_delDecimal.setRolloverIcon(null);
        }
        this.m_addDecimal.setDisabledIcon(new ImageIcon(ImageUtils.createDisabledImage((Image)((ImageIcon)this.m_addDecimal.getIcon()).getImage())));
        this.m_delDecimal.setDisabledIcon(new ImageIcon(ImageUtils.createDisabledImage((Image)((ImageIcon)this.m_delDecimal.getIcon()).getImage())));
    }

    @Override
    public boolean isRolloverIconEnabled() {
        return this.m_bRolloverIconEnabled;
    }

    @Override
    public void update() {
    }

    private ImageIcon makeImage(String fileName) {
        return new ImageIcon(ImageUtils.getImageResource(DecimalTool.class, (String)fileName));
    }

    private void updateResourceBundle(Locale loc) {
        this.rBundle = loc != null ? ResourceBundle.getBundle("oracle.dss.dataView.gui.resource.DataviewGUIBundle", loc) : ResourceBundle.getBundle("oracle.dss.dataView.gui.resource.DataviewGUIBundle");
    }

    @Override
    public void cleanUp() {
        this.m_delDecimal.removeActionListener(this);
        this.m_addDecimal.removeActionListener(this);
        this.m_delDecimal.removeMouseListener(this.m_mouseListener);
        this.m_addDecimal.removeMouseListener(this.m_mouseListener);
    }

    private boolean isEnabled(ComponentHandle selectedComponentHandle) {
        block15: {
            if (this.m_currentDataview instanceof GridViewAttribute && ((GridViewAttribute)((Object)this.m_currentDataview)).getComponentViewFormat(selectedComponentHandle) != null) {
                DataAccess dataAccess = this.m_currentDataview.getModel().getDataAccess();
                if (dataAccess == null) {
                    return false;
                }
                try {
                    if (selectedComponentHandle instanceof DataComponentHandle) {
                        int column;
                        int row = ((DataComponentHandle)selectedComponentHandle).getRow();
                        return dataAccess.getValue(row, column = ((DataComponentHandle)selectedComponentHandle).getColumn(), "dataValue") instanceof Number;
                    }
                    if (selectedComponentHandle instanceof DataRangeComponentHandle) {
                        DataComponentInfo[] ci = ((DataRangeComponentHandle)selectedComponentHandle).getLocationList();
                        for (int i = 0; i < ci.length; ++i) {
                            int column;
                            int row = ci[i].getRow();
                            if (!(dataAccess.getValue(row, column = ci[i].getColumn(), "dataValue") instanceof Number)) continue;
                            return true;
                        }
                        return false;
                    }
                    if (selectedComponentHandle instanceof RowComponentHandle) {
                        int row = ((RowComponentHandle)selectedComponentHandle).getRow();
                        return dataAccess.getValue(row, 0, "dataValue") instanceof Number;
                    }
                    if (selectedComponentHandle instanceof RowRangeComponentHandle) {
                        RowComponentInfo[] ci = ((RowRangeComponentHandle)selectedComponentHandle).getLocationList();
                        for (int i = 0; i < ci.length; ++i) {
                            int row = ci[i].getRow();
                            if (!(dataAccess.getValue(row, 0, "dataValue") instanceof Number)) continue;
                            return true;
                        }
                        return false;
                    }
                    if (selectedComponentHandle instanceof ColumnComponentHandle) {
                        int column = ((ColumnComponentHandle)selectedComponentHandle).getColumn();
                        return dataAccess.getValue(0, column, "dataValue") instanceof Number;
                    }
                    if (selectedComponentHandle instanceof ColumnRangeComponentHandle) {
                        ColumnComponentInfo[] ci = ((ColumnRangeComponentHandle)selectedComponentHandle).getLocationList();
                        for (int i = 0; i < ci.length; ++i) {
                            int column = ci[i].getColumn();
                            if (!(dataAccess.getValue(0, column, "dataValue") instanceof Number)) continue;
                            return true;
                        }
                        return false;
                    }
                    if (selectedComponentHandle instanceof NonDataComponentHandle && selectedComponentHandle.getID() == 13) {
                        return true;
                    }
                    break block15;
                }
                catch (Exception e) {
                    return false;
                }
            }
            if (this.m_currentDataview instanceof GraphAttribute && ((GraphAttribute)((Object)this.m_currentDataview)).getComponentViewFormat(selectedComponentHandle) != null) {
                return true;
            }
        }
        return false;
    }

    private int getDecimal() {
        if (this.m_currentDataview instanceof GridViewAttribute) {
            ViewFormat viewFormat = ((GridViewAttribute)((Object)this.m_currentDataview)).getComponentViewFormat(this.m_selectedComponentHandle);
            return viewFormat.getDecimalDigit();
        }
        if (this.m_currentDataview instanceof GraphAttribute) {
            ViewFormat viewFormat = ((GraphAttribute)((Object)this.m_currentDataview)).getComponentViewFormat(this.m_selectedComponentHandle);
            return viewFormat.getDecimalDigit();
        }
        return -1;
    }

    private void addDecimal() {
        if (this.m_currentDataview instanceof GridViewAttribute || this.m_currentDataview instanceof GraphAttribute) {
            ViewFormat viewFormat = new ViewFormat();
            ViewFormat selectedViewFormat = this.m_currentDataview instanceof GridViewAttribute ? ((GridViewAttribute)((Object)this.m_currentDataview)).getComponentViewFormat(this.m_selectedComponentHandle) : ((GraphAttribute)((Object)this.m_currentDataview)).getComponentViewFormat(this.m_selectedComponentHandle);
            viewFormat.setDecimalDigit(selectedViewFormat.getDecimalDigit() + 1);
            if (!this.m_delDecimal.isEnabled()) {
                this.m_delDecimal.setEnabled(true);
            }
            if (this.m_currentDataview instanceof GridViewAttribute) {
                ((GridViewAttribute)((Object)this.m_currentDataview)).applyViewFormat(this.m_selectedComponentHandle, viewFormat);
                if (!this.m_toolBar.hideAlertInFuture() && !((GridViewAttribute)((Object)this.m_currentDataview)).compareComponentViewFormat(this.m_selectedComponentHandle, viewFormat)) {
                    this.m_toolBar.displayFormatAlert();
                }
            } else {
                ((GraphAttribute)((Object)this.m_currentDataview)).applyViewFormat(this.m_selectedComponentHandle, viewFormat);
            }
            this.firePropertyChange(PROPERTY_DECIMAL_DIGIT, selectedViewFormat.getDecimalDigit() - 1, selectedViewFormat.getDecimalDigit());
        }
    }

    private void delDecimal() {
        if (this.m_currentDataview instanceof GridViewAttribute || this.m_currentDataview instanceof GraphAttribute) {
            ViewFormat viewFormat = new ViewFormat();
            ViewFormat selectedViewFormat = this.m_currentDataview instanceof GridViewAttribute ? ((GridViewAttribute)((Object)this.m_currentDataview)).getComponentViewFormat(this.m_selectedComponentHandle) : ((GraphAttribute)((Object)this.m_currentDataview)).getComponentViewFormat(this.m_selectedComponentHandle);
            viewFormat.setDecimalDigit(selectedViewFormat.getDecimalDigit() - 1);
            if (viewFormat.getDecimalDigit() <= 0) {
                this.m_delDecimal.setEnabled(false);
            }
            if (this.m_currentDataview instanceof GridViewAttribute) {
                ((GridViewAttribute)((Object)this.m_currentDataview)).applyViewFormat(this.m_selectedComponentHandle, viewFormat);
            } else {
                ((GraphAttribute)((Object)this.m_currentDataview)).applyViewFormat(this.m_selectedComponentHandle, viewFormat);
            }
            this.firePropertyChange(PROPERTY_DECIMAL_DIGIT, selectedViewFormat.getDecimalDigit() + 1, selectedViewFormat.getDecimalDigit());
        }
    }
}

