/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView.datacache;

import java.util.Enumeration;
import oracle.dss.dataView.datacache.Map;
import oracle.dss.dataView.datacache.Metadata;
import oracle.dss.util.DataAccess;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.LayerOutOfRangeException;
import oracle.dss.util.xml.BaseObjectNode;
import oracle.dss.util.xml.ContainerNode;

public class Layer
extends Metadata {
    public static final String LAYER = "Layer";
    public static final String LAYERCOUNT = "layerCount";
    public static final String LAYERS = "Layers";
    private static final String[] INTEGER_LAYER_METADATA = new String[]{"dimDrillState"};

    public Layer() {
    }

    public Layer(BaseObjectNode layerNode, Map layerMap) {
        Enumeration types = layerMap.types();
        while (types.hasMoreElements()) {
            String type = (String)types.nextElement();
            Object value = layerMap.readDataFromXML(layerNode, type);
            if (value == null) continue;
            for (int i = 0; i < INTEGER_LAYER_METADATA.length; ++i) {
                if (!type.equals(INTEGER_LAYER_METADATA[i])) continue;
                value = Integer.valueOf(value.toString());
                break;
            }
            this.setMetadata(type, value);
        }
    }

    public Layer(DataAccess da, int edge, int layer, Map layerMap) {
        Enumeration types = layerMap.types();
        while (types.hasMoreElements()) {
            String type = (String)types.nextElement();
            try {
                Object value = da.getLayerMetadata(edge, layer, type);
                if (value == null) continue;
                this.setMetadata(type, value);
            }
            catch (EdgeOutOfRangeException e) {
            }
            catch (LayerOutOfRangeException e) {}
        }
    }

    public ContainerNode addLayerToXML(Map layerMap) {
        ContainerNode layer = new ContainerNode(LAYER);
        Enumeration types = layerMap.types();
        while (types.hasMoreElements()) {
            String type = (String)types.nextElement();
            Object value = this.getMetadata(type);
            layerMap.addDataToXML((BaseObjectNode)layer, type, value);
        }
        return layer;
    }
}

