/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView;

import oracle.dss.dataView.Attributes;
import oracle.dss.dataView.DataComponentHandle;

public class StockDataComponentHandle
extends DataComponentHandle {
    private static final long serialVersionUID = 1L;
    private int m_openIndex = -1;
    private int m_highIndex = -1;
    private int m_lowIndex = -1;
    private int m_closeIndex = -1;
    private int m_volumeIndex = -1;

    public StockDataComponentHandle(int id, String name, Object comp, int r, int c, int group, int series, int o, int h, int l, int cl, int v) {
        super(id, name, comp, r, c, group, series);
        this.m_openIndex = o;
        this.m_highIndex = h;
        this.m_lowIndex = l;
        this.m_closeIndex = cl;
        this.m_volumeIndex = v;
    }

    public Object getOpenValue(String attrName) {
        if (this.m_dataAccess != null && this.m_openIndex > -1) {
            try {
                if (this.m_seriesAreRows) {
                    return this.m_dataAccess.getValue(this.getRow(), this.getColumn() + this.m_openIndex, attrName);
                }
                return this.m_dataAccess.getValue(this.getRow() + this.m_openIndex, this.getColumn(), attrName);
            }
            catch (Exception exp) {
                return null;
            }
        }
        return null;
    }

    public Object getHighValue(String attrName) {
        if (this.m_dataAccess != null && this.m_highIndex > -1) {
            try {
                if (this.m_seriesAreRows) {
                    return this.m_dataAccess.getValue(this.getRow(), this.getColumn() + this.m_highIndex, attrName);
                }
                return this.m_dataAccess.getValue(this.getRow() + this.m_highIndex, this.getColumn(), attrName);
            }
            catch (Exception exp) {
                return null;
            }
        }
        return null;
    }

    public Object getLowValue(String attrName) {
        if (this.m_dataAccess != null && this.m_lowIndex > -1) {
            try {
                if (this.m_seriesAreRows) {
                    return this.m_dataAccess.getValue(this.getRow(), this.getColumn() + this.m_lowIndex, attrName);
                }
                return this.m_dataAccess.getValue(this.getRow() + this.m_lowIndex, this.getColumn(), attrName);
            }
            catch (Exception exp) {
                return null;
            }
        }
        return null;
    }

    public Object getCloseValue(String attrName) {
        if (this.m_dataAccess != null && this.m_closeIndex > -1) {
            try {
                if (this.m_seriesAreRows) {
                    return this.m_dataAccess.getValue(this.getRow(), this.getColumn() + this.m_closeIndex, attrName);
                }
                return this.m_dataAccess.getValue(this.getRow() + this.m_closeIndex, this.getColumn(), attrName);
            }
            catch (Exception exp) {
                return null;
            }
        }
        return null;
    }

    public Object getVolumeValue(String attrName) {
        if (this.m_dataAccess != null && this.m_closeIndex > -1) {
            try {
                if (this.m_seriesAreRows) {
                    return this.m_dataAccess.getValue(this.getRow(), this.getColumn() + this.m_volumeIndex, attrName);
                }
                return this.m_dataAccess.getValue(this.getRow() + this.m_volumeIndex, this.getColumn(), attrName);
            }
            catch (Exception exp) {
                return null;
            }
        }
        return null;
    }

    public Attributes[] getOpenAttributes() {
        if (this.m_openIndex == -1) {
            return null;
        }
        int edge = 1;
        int slice = this.getRow() + this.m_openIndex;
        if (this.m_seriesAreRows) {
            edge = 0;
            slice = this.getColumn() + this.m_openIndex;
        }
        try {
            int layers = this.m_dataAccess.getLayerCount(edge);
            Attributes[] attrs = new Attributes[layers];
            for (int i = 0; i < layers; ++i) {
                attrs[i] = new Attributes(this.m_dataAccess, i, slice, edge);
            }
            return attrs;
        }
        catch (Exception e) {
            return null;
        }
    }

    public Attributes[] getHighAttributes() {
        if (this.m_highIndex == -1) {
            return null;
        }
        int edge = 1;
        int slice = this.getRow() + this.m_highIndex;
        if (this.m_seriesAreRows) {
            edge = 0;
            slice = this.getColumn() + this.m_highIndex;
        }
        try {
            int layers = this.m_dataAccess.getLayerCount(edge);
            Attributes[] attrs = new Attributes[layers];
            for (int i = 0; i < layers; ++i) {
                attrs[i] = new Attributes(this.m_dataAccess, i, slice, edge);
            }
            return attrs;
        }
        catch (Exception e) {
            return null;
        }
    }

    public Attributes[] getLowAttributes() {
        if (this.m_lowIndex == -1) {
            return null;
        }
        int edge = 1;
        int slice = this.getRow() + this.m_lowIndex;
        if (this.m_seriesAreRows) {
            edge = 0;
            slice = this.getColumn() + this.m_lowIndex;
        }
        try {
            int layers = this.m_dataAccess.getLayerCount(edge);
            Attributes[] attrs = new Attributes[layers];
            for (int i = 0; i < layers; ++i) {
                attrs[i] = new Attributes(this.m_dataAccess, i, slice, edge);
            }
            return attrs;
        }
        catch (Exception e) {
            return null;
        }
    }

    public Attributes[] getCloseAttributes() {
        if (this.m_closeIndex == -1) {
            return null;
        }
        int edge = 1;
        int slice = this.getRow() + this.m_closeIndex;
        if (this.m_seriesAreRows) {
            edge = 0;
            slice = this.getColumn() + this.m_closeIndex;
        }
        try {
            int layers = this.m_dataAccess.getLayerCount(edge);
            Attributes[] attrs = new Attributes[layers];
            for (int i = 0; i < layers; ++i) {
                attrs[i] = new Attributes(this.m_dataAccess, i, slice, edge);
            }
            return attrs;
        }
        catch (Exception e) {
            return null;
        }
    }

    public Attributes[] getVolumeAttributes() {
        if (this.m_volumeIndex == -1) {
            return null;
        }
        int edge = 1;
        int slice = this.getRow() + this.m_volumeIndex;
        if (this.m_seriesAreRows) {
            edge = 0;
            slice = this.getColumn() + this.m_volumeIndex;
        }
        try {
            int layers = this.m_dataAccess.getLayerCount(edge);
            Attributes[] attrs = new Attributes[layers];
            for (int i = 0; i < layers; ++i) {
                attrs[i] = new Attributes(this.m_dataAccess, i, slice, edge);
            }
            return attrs;
        }
        catch (Exception e) {
            return null;
        }
    }
}

