/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.event.EventListenerList;
import javax.swing.undo.UndoManager;
import oracle.dss.dataView.BaseTitle;
import oracle.dss.dataView.CommonDataview;
import oracle.dss.dataView.ComponentHandle;
import oracle.dss.dataView.Controller;
import oracle.dss.dataView.ControllerListener;
import oracle.dss.dataView.DataListener;
import oracle.dss.dataView.DataviewAttributes;
import oracle.dss.dataView.DataviewCommon;
import oracle.dss.dataView.DataviewConstants;
import oracle.dss.dataView.DataviewDefaultValues;
import oracle.dss.dataView.DataviewEvent;
import oracle.dss.dataView.DataviewTitles;
import oracle.dss.dataView.DataviewXML;
import oracle.dss.dataView.FontList;
import oracle.dss.dataView.Footnote;
import oracle.dss.dataView.Model;
import oracle.dss.dataView.ModelListener;
import oracle.dss.dataView.PopupManager;
import oracle.dss.dataView.RolloverTextManager;
import oracle.dss.dataView.Subtitle;
import oracle.dss.dataView.Title;
import oracle.dss.dataView.TokenSubstitution;
import oracle.dss.dataView.UIDataview;
import oracle.dss.dataView.ViewComponent;
import oracle.dss.dataView.ViewFocusListener;
import oracle.dss.dataView.ViewKeyListener;
import oracle.dss.dataView.ViewListener;
import oracle.dss.dataView.ViewMouseListener;
import oracle.dss.dataView.ViewMouseMotionListener;
import oracle.dss.pagingControl.ViewPagingControl;
import oracle.dss.rules.ComponentTypeConverter;
import oracle.dss.util.DataAvailableEvent;
import oracle.dss.util.DataChangedEvent;
import oracle.dss.util.DataDirector;
import oracle.dss.util.DataSource;
import oracle.dss.util.ErrorHandler;
import oracle.dss.util.ErrorHandlerCallback;
import oracle.dss.util.WaitData;
import oracle.dss.util.WaitDataAvailableEvent;
import oracle.dss.util.persistence.AggregateInfo;
import oracle.dss.util.persistence.BIPersistenceException;
import oracle.dss.util.persistence.ObjectScope;
import oracle.dss.util.persistence.Persistable;
import oracle.dss.util.persistence.PersistableAttributes;
import oracle.dss.util.persistence.XMLContext;
import oracle.dss.util.xml.BIIOException;
import oracle.dss.util.xml.BIParseException;
import oracle.dss.util.xml.BISAXException;
import oracle.dss.util.xml.BaseObjectNode;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.XMLObjectWriter;

public abstract class Dataview
extends JPanel
implements ModelListener,
ErrorHandlerCallback,
ComponentTypeConverter,
Persistable,
DataviewCommon,
UIDataview,
DataviewAttributes,
DataviewConstants {
    private static final long serialVersionUID = 1L;
    private static final boolean DEBUG = false;
    protected transient PersistableAttributes m_attrs = null;
    protected boolean m_bSuperCalled = true;
    public static final String d_name = DataviewDefaultValues.getName();
    public static final String d_localName = DataviewDefaultValues.getLocalName();
    public static final String d_description = DataviewDefaultValues.getDescription();
    public static final boolean d_pagingControlVisible = DataviewDefaultValues.isPagingControlVisible();
    public static final boolean d_swapAllowed = true;
    public static final String a_name = "name";
    public static final String a_localName = "localName";
    public static final String a_description = "description";
    public static final String a_pagingControlVisible = "pagingControlVisible";
    public static final String a_swapAllowed = "swapAllowed";
    public static final String a_version = "version";
    public static final int MAX_TEXTFIELD_CHARS = 1024;
    protected EventListenerList listenerList = new EventListenerList();
    protected EventListenerList propertyChangeListenerList = new EventListenerList();
    protected EventListenerList vetoableChangeListenerList = new EventListenerList();
    private Model model = null;
    private Controller controller = null;
    protected transient PropertyChangeSupport boundSupport;
    protected transient VetoableChangeSupport vetoSupport;
    protected transient UndoManager undoSupport;
    protected Vector subcomponent = new Vector();
    protected ViewPagingControl pagingControl = null;
    protected TokenSubstitution m_tokenSubstitution;
    protected boolean m_stopRepaints = false;
    protected boolean m_customColorsEnabled = false;
    public static final String m_method_setViewStyle = "setViewStyle";
    protected static final String m_method_resetToDefault = "resetToDefault(int reset)";
    protected static final String m_method_readXML = "readXML(InputStream stream, int reset)";
    protected static final String m_method_setXML = "setXML(String xmlString, int reset)";
    protected static final String m_method_setpagingcontrolposition = "setPagingControlPosition (int loc)";
    protected DataviewTitles m_dataviewTitle = null;
    protected DataviewTitles m_dataviewSubtitle = null;
    protected DataviewTitles m_dataviewFootnote = null;
    protected CommonDataview m_commonDataview = null;
    protected boolean m_dataViewFormatSupported = false;
    protected JPanel titlePanel = null;
    protected JPanel footnotePanel = null;
    protected boolean printOrPreviewMode = false;
    private boolean m_bLoadingDataSourceFromPersistence = false;
    protected Hashtable m_context = null;
    public static final String above_title = "PAGING_CONTROL_ABOVE_TITLES";
    public static final String below_title = "PAGING_CONTROL_BELOW_TITLES";

    public Dataview() {
        super(new BorderLayout());
        this.boundSupport = new PropertyChangeSupport(this);
        this.vetoSupport = new VetoableChangeSupport(this);
        this.undoSupport = new UndoManager();
        this.m_commonDataview = new CommonDataview(this.getLocale());
    }

    public void setCommonDataview(CommonDataview commonDataview) {
        this.m_commonDataview = commonDataview;
    }

    @Override
    public void setPagingControlPosition(int loc) {
        if (loc != 0 && loc != 1 && loc != 2 && loc != 3 && loc != 4) {
            this.getErrorHandler().log("incorrect paging control position", this.getClass().getName(), m_method_setpagingcontrolposition);
            return;
        }
        this.m_commonDataview.setPagingControlPosition(loc);
        if (this.getTitlePanel() == null) {
            return;
        }
        boolean pagingControlAdded = false;
        if (loc == 0 || loc == 1) {
            Component[] components = this.getTitlePanel().getComponents();
            for (int i = 0; i < components.length; ++i) {
                if (!(components[i] instanceof ViewPagingControl)) continue;
                pagingControlAdded = true;
            }
            if (!pagingControlAdded) {
                Component[] c = this.getComponents();
                for (int i = 0; i < c.length; ++i) {
                    if (!(c[i] instanceof ViewPagingControl)) continue;
                    this.remove(c[i]);
                    this.add((Component)this.getTitlePanel(), "North");
                    pagingControlAdded = true;
                }
            }
            if (pagingControlAdded) {
                this.getTitlePanel().setVisible(false);
                this.getTitlePanel().removeAll();
                this.positionPagingControl(loc);
                this.getTitlePanel().setVisible(true);
            }
        } else if (loc == 3) {
            Component[] components = this.getFootnotePanel().getComponents();
            for (int i = 0; i < components.length; ++i) {
                if (!(components[i] instanceof ViewPagingControl)) continue;
                pagingControlAdded = true;
            }
            if (!pagingControlAdded) {
                Component[] c = this.getComponents();
                for (int i = 0; i < c.length; ++i) {
                    if (!(c[i] instanceof ViewPagingControl)) continue;
                    this.remove(c[i]);
                    this.add((Component)this.getFootnotePanel(), "North");
                    pagingControlAdded = true;
                }
            }
            if (pagingControlAdded) {
                this.getFootnotePanel().setVisible(false);
                this.getFootnotePanel().removeAll();
                this.positionPagingControl(loc);
                this.getFootnotePanel().setVisible(true);
            }
        } else {
            Component[] components = this.getComponents();
            for (int i = 0; i < components.length; ++i) {
                if (!(components[i] instanceof ViewPagingControl)) continue;
                pagingControlAdded = true;
            }
            if (pagingControlAdded) {
                this.positionPagingControl(loc);
            }
        }
    }

    @Override
    public int getPagingControlPosition() {
        return this.m_commonDataview.getPagingControlPosition();
    }

    @Override
    public void setTokenSubstitution(TokenSubstitution token) {
        this.m_commonDataview.setTokenSubstitution(token);
    }

    @Override
    public TokenSubstitution getTokenSubstitution() {
        return this.m_commonDataview.getTokenSubstitution();
    }

    @Override
    public void setDataSource(DataSource ds) {
        if (this.model != null) {
            DataSource oldDs = this.model.getDataSource();
            this.model.setDataSource(ds);
            this.firePropertyChange(this, "DataSource", oldDs, ds);
        }
        if (this.getPagingControl() != null) {
            this.getPagingControl().setDataSource(ds);
        }
    }

    @Override
    public DataSource getDataSource() {
        if (this.model != null) {
            return this.model.getDataSource();
        }
        return null;
    }

    @Override
    public DataviewTitles getDataviewTitle() {
        if (this.m_dataviewTitle == null) {
            this.createTitles();
        }
        return this.m_dataviewTitle;
    }

    @Override
    public DataviewTitles getDataviewSubtitle() {
        if (this.m_dataviewSubtitle == null) {
            this.createTitles();
        }
        return this.m_dataviewSubtitle;
    }

    @Override
    public DataviewTitles getDataviewFootnote() {
        if (this.m_dataviewFootnote == null) {
            this.createFootnote();
        }
        return this.m_dataviewFootnote;
    }

    public void setDataDirector(DataDirector dd) {
        if (this.model != null) {
            this.model.setDataDirector(dd);
        }
    }

    public DataDirector getDataDirector() {
        if (this.model != null) {
            return this.model.getDataDirector();
        }
        return null;
    }

    @Override
    public void addControllerListener(ControllerListener l) {
        if (this.controller != null) {
            this.controller.addControllerListener(l);
        }
    }

    @Override
    public void removeControllerListener(ControllerListener l) {
        if (this.controller != null) {
            this.controller.removeControllerListener(l);
        }
    }

    public void addDataListener(DataListener l) {
        if (this.model != null) {
            this.model.addDataListener(l);
        }
    }

    public void removeDataListener(DataListener l) {
        if (this.model != null) {
            this.model.removeDataListener(l);
        }
    }

    public void addErrorHandler(ErrorHandler eh) {
        this.m_commonDataview.addErrorHandler(eh);
    }

    public void removeErrorHandler() {
        this.m_commonDataview.removeErrorHandler();
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.m_commonDataview.getErrorHandler();
    }

    public void addViewMouseListener(ViewMouseListener l) {
        if (this.controller != null) {
            this.controller.addViewMouseListener(l);
        }
    }

    public void removeViewMouseListener(ViewMouseListener l) {
        if (this.controller != null) {
            this.controller.removeViewMouseListener(l);
        }
    }

    public void addViewMouseMotionListener(ViewMouseMotionListener l) {
        if (this.controller != null) {
            this.controller.addViewMouseMotionListener(l);
        }
    }

    public void removeViewMouseMotionListener(ViewMouseMotionListener l) {
        if (this.controller != null) {
            this.controller.removeViewMouseMotionListener(l);
        }
    }

    public void addViewKeyListener(ViewKeyListener l) {
        if (this.controller != null) {
            this.controller.addViewKeyListener(l);
        }
    }

    public void removeViewKeyListener(ViewKeyListener l) {
        if (this.controller != null) {
            this.controller.removeViewKeyListener(l);
        }
    }

    public void addViewFocusListener(ViewFocusListener l) {
        if (this.controller != null) {
            this.controller.addViewFocusListener(l);
        }
    }

    public void removeViewFocusListener(ViewFocusListener l) {
        if (this.controller != null) {
            this.controller.removeViewFocusListener(l);
        }
    }

    public void addViewListener(ViewListener l) {
        this.listenerList.add(ViewListener.class, l);
    }

    public void removeViewListener(ViewListener l) {
        this.listenerList.remove(ViewListener.class, l);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        if (this.propertyChangeListenerList != null && this.boundSupport != null) {
            this.propertyChangeListenerList.add(PropertyChangeListener.class, l);
            this.boundSupport.addPropertyChangeListener(l);
        } else {
            super.addPropertyChangeListener(l);
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        if (this.propertyChangeListenerList != null && this.boundSupport != null) {
            this.propertyChangeListenerList.remove(PropertyChangeListener.class, l);
            this.boundSupport.removePropertyChangeListener(l);
        } else {
            super.removePropertyChangeListener(l);
        }
    }

    @Override
    public void addVetoableChangeListener(VetoableChangeListener l) {
        if (this.vetoableChangeListenerList != null && this.vetoSupport != null) {
            this.vetoableChangeListenerList.add(VetoableChangeListener.class, l);
            this.vetoSupport.addVetoableChangeListener(l);
        } else {
            super.addVetoableChangeListener(l);
        }
    }

    @Override
    public void removeVetoableChangeListener(VetoableChangeListener l) {
        if (this.vetoableChangeListenerList != null && this.vetoSupport != null) {
            this.vetoableChangeListenerList.remove(VetoableChangeListener.class, l);
            this.vetoSupport.removeVetoableChangeListener(l);
        } else {
            super.removeVetoableChangeListener(l);
        }
    }

    public void setXMLValidated(boolean validate) {
        this.m_commonDataview.setXMLValidated(validate);
    }

    public boolean isXMLValidated() {
        return this.m_commonDataview.isXMLValidated();
    }

    protected void positionPagingControl(int location) {
        switch (location) {
            case 1: {
                this.getTitlePanel().add((Component)((Title)this.getDataviewTitle()), "North");
                this.getTitlePanel().add((Component)((Subtitle)this.getDataviewSubtitle()), "Center");
                this.getTitlePanel().add((Component)this.pagingControl, "South");
                break;
            }
            case 2: {
                this.pagingControl.setOrientation(1);
                this.add((Component)this.pagingControl, "East");
                break;
            }
            case 3: {
                this.pagingControl.setOrientation(0);
                this.getFootnotePanel().add((Component)((Footnote)this.m_dataviewFootnote), "North");
                this.getFootnotePanel().add((Component)this.pagingControl, "South");
                break;
            }
            case 4: {
                this.pagingControl.setOrientation(1);
                this.add((Component)this.pagingControl, "West");
                break;
            }
            default: {
                this.getTitlePanel().add((Component)this.pagingControl, "North");
                this.getTitlePanel().add((Component)((Title)this.getDataviewTitle()), "Center");
                this.getTitlePanel().add((Component)((Subtitle)this.getDataviewSubtitle()), "South");
            }
        }
    }

    protected void firePrintBegin(Object source) {
        DataviewEvent e = new DataviewEvent(source);
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ViewListener.class) continue;
            ((ViewListener)listeners[i + 1]).printBegin(e);
        }
    }

    protected void firePrintEnd(Object source) {
        DataviewEvent e = new DataviewEvent(source);
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ViewListener.class) continue;
            ((ViewListener)listeners[i + 1]).printEnd(e);
        }
    }

    protected void copyAdornment(BaseTitle to, BaseTitle from) {
    }

    protected Object getComponentFromID(int ID) {
        switch (ID) {
            case 6: {
                return this.getDataviewTitle();
            }
            case 7: {
                return this.getDataviewSubtitle();
            }
            case 8: {
                return this.getDataviewFootnote();
            }
        }
        return null;
    }

    protected String getNameFromID(int ID) {
        switch (ID) {
            case 6: {
                return "DataviewTitle";
            }
            case 7: {
                return "DataviewSubtitle";
            }
            case 8: {
                return "DataviewFootnote";
            }
            case 3: {
                return "PageHeader";
            }
            case 4: {
                return "PageItem";
            }
        }
        return null;
    }

    protected abstract void firePropertyChange(Object var1, String var2, Object var3, Object var4);

    public abstract boolean selectObject(ComponentHandle var1);

    @Override
    public abstract ComponentHandle getSelectedObject();

    public abstract int getPresentationHeight();

    public abstract int getPresentationWidth();

    @Override
    public final void setName(String n) {
        if (this.m_commonDataview != null) {
            String oldName = this.getName();
            this.m_commonDataview.setName(n);
            this.firePropertyChange(this, "Name", oldName, n);
        } else {
            super.setName(n);
        }
    }

    @Override
    public final String getName() {
        if (this.m_commonDataview != null) {
            return this.m_commonDataview.getName();
        }
        return super.getName();
    }

    @Override
    public final void setLocalName(String n) {
        String oldName = this.getLocalName();
        this.m_commonDataview.setLocalName(n);
        this.firePropertyChange(this, "LocalName", oldName, n);
    }

    @Override
    public final String getLocalName() {
        return this.m_commonDataview.getLocalName();
    }

    @Override
    public final void setDescription(String n) {
        String oldDesc = this.getDescription();
        this.m_commonDataview.setDescription(n);
        this.firePropertyChange(this, "Description", oldDesc, n);
    }

    @Override
    public final String getDescription() {
        return this.m_commonDataview.getDescription();
    }

    @Override
    public void setDrillingEnabled(boolean b) {
        if (this.model != null) {
            boolean oldEnable = this.model.isDrillingEnabled();
            this.model.setDrillingEnabled(b);
            this.repaint();
            this.firePropertyChange(this, "DrillingEnabled", new Boolean(oldEnable), new Boolean(b));
        }
    }

    @Override
    public final boolean isDrillingEnabled() {
        if (this.model != null) {
            return this.model.isDrillingEnabled();
        }
        return true;
    }

    @Override
    public boolean isDrillingSupported() {
        return false;
    }

    public void setPopupManager(PopupManager p) {
        if (this.controller == null) {
            return;
        }
        PopupManager oldPopupManager = this.controller.getPopupManager();
        this.controller.setPopupManager(p);
        this.firePropertyChange(this, "PopupManager", oldPopupManager, p);
    }

    public PopupManager getPopupManager() {
        if (this.controller == null) {
            return null;
        }
        return this.controller.getPopupManager();
    }

    public void setRolloverTextManager(RolloverTextManager rm) {
        if (this.controller == null) {
            return;
        }
        RolloverTextManager oldRolloverManager = this.controller.getRolloverTextManager();
        this.controller.setRolloverTextManager(rm);
        this.firePropertyChange(this, "RolloverTextManager", oldRolloverManager, rm);
    }

    public RolloverTextManager getRolloverTextManager() {
        if (this.controller == null) {
            return null;
        }
        return this.controller.getRolloverTextManager();
    }

    protected abstract void refreshData();

    public abstract boolean isPrintOrPreviewMode();

    @Override
    public void modelDataChanged(DataChangedEvent e) {
        this.model.setDataAccess(e.getDataAccess());
        this.refreshData();
    }

    @Override
    public void modelDataAvailable(DataAvailableEvent e) {
        this.model.setDataAccess(e.getDataAccess());
        this.refreshData();
    }

    @Override
    public void modelWaitDataAvailable(WaitDataAvailableEvent e) {
        this.clearWaitDataForAllRows();
        this.repaint();
    }

    @Override
    public void setWaitDataForRow(int row, WaitData waitData) {
        this.m_commonDataview.setWaitDataForRow(row, waitData);
    }

    @Override
    public WaitData getWaitDataForRow(int row) {
        return this.m_commonDataview.getWaitDataForRow(row);
    }

    public void clearWaitDataForAllRows() {
        this.m_commonDataview.clearWaitDataForAllRows();
    }

    protected WaitData[] getWaitData() {
        return this.m_commonDataview.getWaitData();
    }

    @Override
    public FontList getFontList() {
        return this.m_commonDataview.getFontList();
    }

    public Vector getPhysicalComponents() {
        return this.subcomponent;
    }

    @Override
    public String getIntlString(String key) {
        return this.m_commonDataview.getIntlString(key);
    }

    @Override
    public String getIntlString(String key, ResourceBundle rBundle) {
        return this.m_commonDataview.getIntlString(key, rBundle);
    }

    public void setModel(Model m) {
        if (this.model != null) {
            this.model.removeModelListener(this);
        }
        this.model = m;
        this.m_commonDataview.setModel(m);
        this.model.setErrorHandler(this.getErrorHandler());
        this.model.addModelListener(this);
    }

    @Override
    public Model getModel() {
        return this.model;
    }

    public void setController(Controller c) {
        this.controller = c;
    }

    public Controller getController() {
        return this.controller;
    }

    public void updatePagingControlStyles() {
        if (this.getPagingControl() != null) {
            this.getPagingControl().updatePageItemStyles();
        }
    }

    @Override
    public void metadataStyleChanged() {
        this.updatePagingControlStyles();
    }

    @Override
    public void dataStyleChanged() {
    }

    @Override
    public void dataFormatChanged() {
    }

    private void updateResourceBundle() {
        this.m_commonDataview.updateResourceBundle();
    }

    @Override
    public void setLocale(Locale loc) {
        super.setLocale(loc);
        if (!this.m_bSuperCalled) {
            return;
        }
        this.updateResourceBundle();
        if (this.m_tokenSubstitution != null) {
            this.m_tokenSubstitution.setLocale(loc);
        }
        if (this.getPagingControl() != null) {
            this.getPagingControl().setLocale(loc);
        }
        if (this.m_commonDataview != null) {
            this.m_commonDataview.setLocale(loc);
        }
    }

    @Override
    public Locale getLocale() {
        try {
            return super.getLocale();
        }
        catch (Exception e) {
            return Locale.getDefault();
        }
    }

    public String getXML(boolean allProperties) {
        XMLObjectWriter writer = new XMLObjectWriter();
        try {
            writer.setIndentMode(1);
            writer.writeObjectNode((BaseObjectNode)this.getObjectNode(allProperties));
            return writer.toString();
        }
        catch (BIIOException biioe) {
            this.getErrorHandler().log("oracle.dss.util.xml.BIIOException occured", this.getClass().getName(), "getXML(boolean allProperties)");
            return null;
        }
    }

    public void writeXML(OutputStream stream, boolean allProperties) {
        XMLObjectWriter writer = new XMLObjectWriter(stream);
        try {
            writer.setIndentMode(1);
            writer.writeObjectNode((BaseObjectNode)this.getObjectNode(allProperties));
        }
        catch (BIIOException biioe) {
            this.getErrorHandler().log("oracle.dss.util.xml.BIIOException occured", this.getClass().getName(), "writeXML(OutputStream stream, boolean allProperties)");
        }
    }

    protected void addSubcomponent(Object s) {
        this.subcomponent.addElement(s);
    }

    protected ViewComponent getSubcomponent(int id) {
        Enumeration e = this.subcomponent.elements();
        while (e.hasMoreElements()) {
            ViewComponent subcomp = (ViewComponent)e.nextElement();
            if (id != subcomp.getID()) continue;
            return subcomp;
        }
        return null;
    }

    protected ViewComponent getSubcomponent(String name) {
        Enumeration e = this.subcomponent.elements();
        while (e.hasMoreElements()) {
            ViewComponent subcomp = (ViewComponent)e.nextElement();
            if (!name.equals(subcomp.getComponentName())) continue;
            return subcomp;
        }
        return null;
    }

    public ViewPagingControl getPagingControl() {
        return this.pagingControl;
    }

    @Override
    public void setPagingControlVisible(boolean v) {
        if (this.getPagingControl() != null) {
            this.getPagingControl().setVisible(v);
        }
    }

    @Override
    public boolean isPagingControlVisible() {
        if (this.getPagingControl() == null) {
            return false;
        }
        return this.getPagingControl().isVisible();
    }

    @Override
    public abstract int getViewType();

    @Override
    public Font scaleFont(Font f, int zoomFactor) {
        return this.m_commonDataview.scaleFont(f, zoomFactor);
    }

    @Override
    public int getZoomFactor() {
        return this.m_commonDataview.getZoomFactor();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.pagingControl != null) {
            this.pagingControl.setEnabled(enabled);
        }
    }

    @Override
    public void setCustomColorsEnabled(boolean enabled) {
        this.m_customColorsEnabled = enabled;
    }

    @Override
    public boolean isCustomColorsEnabled() {
        return this.m_customColorsEnabled;
    }

    public int convertComponentTypeToInteger(String type) {
        return this.m_commonDataview.convertComponentTypeToInteger(type);
    }

    public String convertComponentTypeToString(int type) {
        return this.m_commonDataview.convertComponentTypeToString(type);
    }

    public void resetToDefault(int reset) {
        this.resetToDefault(reset, this.getVersion());
    }

    protected void resetToDefault(int reset, String version) {
        this.removeListeners(reset);
        if (reset < 0 || reset > 5) {
            this.getErrorHandler().log("invalid reset argument", this.getClass().getName(), m_method_resetToDefault);
            return;
        }
        if (reset == 0) {
            this.getErrorHandler().log("attempt to reset to default with argument of RESET_NONE", this.getClass().getName(), m_method_resetToDefault);
            return;
        }
        this.getViewXML().resetDataviewXML();
        if (this.getDataviewTitle() != null) {
            ((Title)this.getDataviewTitle()).resetToDefault(reset, version);
        }
        if (this.getDataviewSubtitle() != null) {
            ((Subtitle)this.getDataviewSubtitle()).resetToDefault(reset, version);
        }
        if (this.getDataviewFootnote() != null) {
            ((Footnote)this.getDataviewFootnote()).resetToDefault(reset, version);
        }
        if (this.getPagingControl() != null) {
            this.getPagingControl().resetToDefault(reset);
        }
    }

    protected void removeListeners(int reset) {
        if (reset == 2 || reset == 4) {
            int i;
            Object[] listeners;
            if (this.listenerList != null) {
                listeners = this.listenerList.getListenerList();
                for (i = listeners.length - 2; i >= 0; i -= 2) {
                    if (listeners[i] != ViewListener.class) continue;
                    this.removeViewListener((ViewListener)listeners[i + 1]);
                    listeners[i] = null;
                }
                this.listenerList = new EventListenerList();
            }
            if (this.propertyChangeListenerList != null) {
                listeners = this.propertyChangeListenerList.getListenerList();
                for (i = listeners.length - 2; i >= 0; i -= 2) {
                    if (listeners[i] != PropertyChangeListener.class) continue;
                    this.removePropertyChangeListener((PropertyChangeListener)listeners[i + 1]);
                    listeners[i] = null;
                }
                this.propertyChangeListenerList = new EventListenerList();
            }
            if (this.vetoableChangeListenerList != null) {
                listeners = this.vetoableChangeListenerList.getListenerList();
                for (i = listeners.length - 2; i >= 0; i -= 2) {
                    if (listeners[i] != VetoableChangeListener.class) continue;
                    this.removeVetoableChangeListener((VetoableChangeListener)listeners[i + 1]);
                    listeners[i] = null;
                }
                this.vetoableChangeListenerList = new EventListenerList();
            }
        }
    }

    public abstract String getVersion();

    public abstract boolean readXML(InputStream var1, int var2) throws BIIOException, BISAXException, BIParseException;

    public abstract boolean setXML(String var1, int var2) throws BIIOException, BISAXException, BIParseException;

    protected void setXML(ObjectNode node) {
        this.getViewXML().setXML(node);
    }

    protected void setStyleXML(ObjectNode node) {
        this.getViewXML().setStyleXML(node);
    }

    public abstract void setSwapAllowed(boolean var1);

    public abstract boolean isSwapAllowed();

    public void cleanUp() {
        this.removeErrorHandler();
    }

    public boolean isDataUnavailable() {
        return this.m_stopRepaints;
    }

    public void initialize(Hashtable env) {
        if (env != null && env.containsKey("persistence_errorhandler")) {
            this.addErrorHandler((ErrorHandler)env.get("persistence_errorhandler"));
        }
        if (env != null && env.containsKey("persistence_locale")) {
            this.setLocale((Locale)env.get("persistence_locale"));
        }
        if (env != null && env.containsKey("migration") && env.containsKey("full_path_to_guid_converter")) {
            this._setXMLContext(env.get("migration"), env.get("full_path_to_guid_converter"));
            this.setContext();
        }
    }

    private void _setXMLContext(Object migration, Object converter) {
        ObjectScope scope = new ObjectScope();
        scope.addObject("migration", migration);
        scope.addObject("full_path_to_guid_converter", converter);
        XMLContext xmlcontext = new XMLContext();
        xmlcontext.setScope(scope);
        if (this.m_context == null) {
            this.m_context = new Hashtable();
        }
        this.m_context.put("xml_context", xmlcontext);
        this.setContext();
    }

    protected abstract void setContext();

    public abstract PersistableAttributes getPersistableAttributes(PersistableAttributes var1);

    public void setPersistableAttributes(PersistableAttributes attrs) {
        this.m_attrs = attrs;
        this.m_commonDataview.setPersistableAttributes(attrs);
    }

    public abstract boolean setXMLAsString(String var1) throws BIPersistenceException;

    public AggregateInfo[] getPersistableComponents() {
        AggregateInfo[] aggregates = null;
        DataSource ds = this.getDataSource();
        if (ds != null && ds instanceof Persistable) {
            aggregates = new AggregateInfo[]{new AggregateInfo((Persistable)ds, 0)};
        }
        return aggregates;
    }

    public void setPersistableComponents(AggregateInfo[] persistables) {
        if (persistables != null) {
            for (int i = 0; i < persistables.length; ++i) {
                Persistable aggregate = persistables[i].getPersistable();
                if (!(aggregate instanceof DataSource)) continue;
                if (this.getViewType() == 0 || this.getViewType() == 2) {
                    this.setLoadingDataSourceFromPersistence(true);
                }
                this.setDataSource((DataSource)aggregate);
                break;
            }
        }
    }

    public String getXMLAsString() {
        return this.getXML(false);
    }

    protected void setLoadingDataSourceFromPersistence(boolean bLoading) {
        this.m_bLoadingDataSourceFromPersistence = bLoading;
    }

    protected boolean isLoadingDataSourceFromPersistence() {
        return this.m_bLoadingDataSourceFromPersistence;
    }

    protected void createTitles() {
        this.m_dataviewTitle = new Title(this);
        this.m_dataviewSubtitle = new Subtitle(this);
        this.addSubcomponent(this.m_dataviewTitle);
        this.addSubcomponent(this.m_dataviewSubtitle);
        if (this.isJavaComponent()) {
            this.titlePanel = new JPanel(new BorderLayout());
            this.add((Component)this.titlePanel, "North");
            this.titlePanel.add((Component)((Title)this.m_dataviewTitle), "North");
            this.titlePanel.add((Component)((Subtitle)this.m_dataviewSubtitle), "Center");
        }
    }

    protected void createFootnote() {
        this.m_dataviewFootnote = new Footnote(this);
        this.addSubcomponent(this.m_dataviewFootnote);
        if (this.isJavaComponent()) {
            this.footnotePanel = new JPanel(new BorderLayout());
            this.add((Component)this.footnotePanel, "South");
            this.footnotePanel.add((Component)((Footnote)this.m_dataviewFootnote), "North");
        }
    }

    protected ObjectNode getObjectNode(ObjectNode node, boolean allProperties) {
        return this.getViewXML().getObjectNode(node, allProperties);
    }

    protected boolean getStyleXML(boolean allProperties, ObjectNode node) {
        return this.getViewXML().getStyleXML(allProperties, node);
    }

    protected abstract ObjectNode getObjectNode(boolean var1);

    protected abstract DataviewXML getViewXML();

    protected void setDataUnformattedSupported(boolean supported) {
        this.m_commonDataview.setDataUnformattedSupported(supported);
    }

    @Override
    public boolean isDataUnformattedSupported() {
        return this.m_commonDataview.isDataUnformattedSupported();
    }

    @Override
    public boolean isDataViewFormatSupported() {
        return this.m_dataViewFormatSupported;
    }

    protected void setMetadataLongLabelSupported(boolean supported) {
        this.m_commonDataview.setMetadataLongLabelSupported(supported);
    }

    public boolean isMetadataLongLabelSupported() {
        return this.m_commonDataview.isMetadataLongLabelSupported();
    }

    protected void setMetadataMediumLabelSupported(boolean supported) {
        this.m_commonDataview.setMetadataMediumLabelSupported(supported);
    }

    public boolean isMetadataMediumLabelSupported() {
        return this.m_commonDataview.isMetadataMediumLabelSupported();
    }

    protected void setMetadataShortLabelSupported(boolean supported) {
        this.m_commonDataview.setMetadataShortLabelSupported(supported);
    }

    @Override
    public boolean isMetadataShortLabelSupported() {
        return this.m_commonDataview.isMetadataShortLabelSupported();
    }

    @Override
    public boolean isMetadataViewStyleSupported() {
        return this.m_commonDataview.isMetadataViewStyleSupported();
    }

    public void setMetadataViewStyleSupported(boolean supported) {
        this.m_commonDataview.setMetadataViewStyleSupported(supported);
    }

    protected void setMetadataValueSupported(boolean supported) {
        this.m_commonDataview.setMetadataValueSupported(supported);
    }

    public boolean isMetadataValueSupported() {
        return this.m_commonDataview.isMetadataValueSupported();
    }

    protected void setLayerMetaLongLabelSupported(boolean supported) {
        this.m_commonDataview.setLayerMetaLongLabelSupported(supported);
    }

    public boolean isLayerMetaLongLabelSupported() {
        return this.m_commonDataview.isLayerMetaLongLabelSupported();
    }

    protected void setLayerMetaMediumLabelSupported(boolean supported) {
        this.m_commonDataview.setLayerMetaMediumLabelSupported(supported);
    }

    public boolean isLayerMetaMediumLabelSupported() {
        return this.m_commonDataview.isLayerMetaMediumLabelSupported();
    }

    protected void setLayerMetaShortLabelSupported(boolean supported) {
        this.m_commonDataview.setLayerMetaShortLabelSupported(supported);
    }

    @Override
    public boolean isLayerMetaShortLabelSupported() {
        return this.m_commonDataview.isLayerMetaShortLabelSupported();
    }

    protected void setLayerMetaNameSupported(boolean supported) {
        this.m_commonDataview.setLayerMetaNameSupported(supported);
    }

    public boolean isLayerMetaNameSupported() {
        return this.m_commonDataview.isLayerMetaNameSupported();
    }

    public void setLayerMetaViewStyleSupported(boolean supported) {
        this.m_commonDataview.setLayerMetaViewStyleSupported(supported);
    }

    @Override
    public boolean isLayerMetaViewStyleSupported() {
        return this.m_commonDataview.isLayerMetaViewStyleSupported();
    }

    @Override
    public boolean isMemberMetadataLabelTypeSupported(String type) {
        return this.m_commonDataview.isMemberMetadataLabelTypeSupported(type);
    }

    @Override
    public boolean isLayerMetadataLabelTypeSupported(String type) {
        return this.m_commonDataview.isLayerMetadataLabelTypeSupported(type);
    }

    protected boolean isJavaComponent() {
        return true;
    }

    @Override
    public void setHTMLPagingControlAutosubmit(boolean autosubmit) {
        this.m_commonDataview.setHTMLPagingControlAutosubmit(autosubmit);
    }

    @Override
    public boolean isHTMLPagingControlAutosubmit() {
        return this.m_commonDataview.isHTMLPagingControlAutosubmit();
    }

    @Override
    public void setHTMLPagingControlWidth(int width) {
        this.m_commonDataview.setHTMLPagingControlWidth(width);
    }

    @Override
    public int getHTMLPagingControlWidth() {
        return this.m_commonDataview.getHTMLPagingControlWidth();
    }

    @Override
    public void setMemberMetadataLabelType(int edge, String type) {
        this.m_commonDataview.setMemberMetadataLabelType(edge, type);
        this.metadataLabelTypeChanged();
    }

    @Override
    public String getMemberMetadataLabelType(int edge) {
        return this.m_commonDataview.getMemberMetadataLabelType(edge);
    }

    @Override
    public void setLayerMetadataLabelType(int edge, String type) {
        this.m_commonDataview.setLayerMetadataLabelType(edge, type);
        this.metadataLabelTypeChanged();
    }

    @Override
    public String getLayerMetadataLabelType(int edge) {
        return this.m_commonDataview.getLayerMetadataLabelType(edge);
    }

    public void setMemberMetadataLabelType(String type) {
        this.m_commonDataview.setMemberMetadataLabelType(type);
        this.metadataLabelTypeChanged();
    }

    public String getMemberMetadataLabelType() {
        return this.m_commonDataview.getMemberMetadataLabelType();
    }

    public void setLayerMetadataLabelType(String type) {
        this.m_commonDataview.setLayerMetadataLabelType(type);
        this.metadataLabelTypeChanged();
    }

    protected void metadataLabelTypeChanged() {
        this.repaint();
    }

    public String getLayerMetadataLabelType() {
        return this.m_commonDataview.getLayerMetadataLabelType();
    }

    @Override
    public BitSet createPropertyOverrideFlags(int maxID) {
        return this.m_commonDataview.createPropertyOverrideFlags(maxID);
    }

    @Override
    public void setPropertyOverrideFlags(int attrID, BitSet userFlags, BitSet styleFlags) {
        this.m_commonDataview.setPropertyOverrideFlags(attrID, userFlags, styleFlags);
    }

    @Override
    public boolean isPropertyOverrideFlag(int attrID, BitSet overrideFlags) {
        return this.m_commonDataview.isPropertyOverrideFlag(attrID, overrideFlags);
    }

    public void clearPropertyOverrideFlag(int attrID, BitSet overrideFlags) {
        this.m_commonDataview.clearPropertyOverrideFlag(attrID, overrideFlags);
    }

    protected void setStyleOverrideMode(boolean flag) {
        this.m_commonDataview.setStyleOverrideMode(flag);
    }

    protected boolean isStyleOverrideMode() {
        return this.m_commonDataview.isStyleOverrideMode();
    }

    protected boolean isStyleModified() {
        return this.m_commonDataview.isStyleModified();
    }

    protected void clearStyleModified() {
        this.m_commonDataview.clearStyleModified();
    }

    protected void setUserOverrideMode(boolean flag) {
        this.m_commonDataview.setUserOverrideMode(flag);
    }

    protected boolean isUserOverrideMode() {
        return this.m_commonDataview.isUserOverrideMode();
    }

    private JPanel getTitlePanel() {
        if (this.titlePanel == null) {
            this.createTitles();
        }
        return this.titlePanel;
    }

    private JPanel getFootnotePanel() {
        if (this.footnotePanel == null) {
            this.createFootnote();
        }
        return this.footnotePanel;
    }
}

