/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView;

import java.awt.Color;
import java.awt.Font;
import java.beans.BeanInfo;
import java.util.BitSet;
import java.util.HashMap;
import oracle.dss.dataView.BaseTitleAttributes;
import oracle.dss.dataView.BaseTitleXML;
import oracle.dss.dataView.CommonDataview;
import oracle.dss.dataView.DataviewDefaultValues;
import oracle.dss.dataView.FootnoteXML;
import oracle.dss.dataView.SubtitleXML;
import oracle.dss.dataView.TitleXML;
import oracle.dss.dataView.TokenSubstitution;
import oracle.dss.dataView.ViewComponent;
import oracle.dss.dataView.managers.ViewStyle;
import oracle.dss.util.Utility;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public class CommonBaseTitle
implements ViewComponent,
BaseTitleAttributes {
    protected TitleState m_baseState = null;
    protected TitleState m_checkpointState = null;
    private static String s_text = "t";
    private static String s_visible = "v";
    protected BitSet _userOverrideFlags = null;
    protected BitSet _styleOverrideFlags = null;
    protected CommonDataview dataView = null;
    protected String m_text;
    protected boolean m_visible;
    protected Font m_font;
    protected boolean m_underline;
    protected int m_hAlign;
    protected Color m_background;
    protected Color m_foreground;
    protected static final String m_errorSetFont = "Font size is less or equal to 0";
    protected static final String m_method_setText = "setText";
    protected static final String m_method_setFont = "setFont";
    protected static final String m_errorMsg = "Text is null";
    protected BaseTitleXML _baseTitleXML;
    private int m_id;

    public CommonBaseTitle(String t, CommonDataview v, int id) {
        this.dataView = v;
        this.setText(t);
        this.setVisible(DataviewDefaultValues.isBaseTitleVisible());
        this.setUnderline(DataviewDefaultValues.isBaseTitleUnderline());
        this.setHorizontalAlignment(DataviewDefaultValues.getBaseTitleHorizontalAlignment());
        this.setForeground(ViewStyle.getDefaultForeground());
        this.setBackground(DataviewDefaultValues.getBaseTitleBackground());
        this.m_id = id;
        if (id == 6) {
            this.setFont(new Font(DataviewDefaultValues.getBaseTitleFontName(), ViewStyle.fontStyle(DataviewDefaultValues.isBaseTitleFontBold(), DataviewDefaultValues.isBaseTitleFontItalic()), DataviewDefaultValues.getTitleFontSize()));
            this._baseTitleXML = new TitleXML(this, v.getVersion());
        } else if (id == 7) {
            this.setFont(new Font(DataviewDefaultValues.getBaseTitleFontName(), ViewStyle.fontStyle(DataviewDefaultValues.isBaseTitleFontBold(), DataviewDefaultValues.isBaseTitleFontItalic()), DataviewDefaultValues.getSubtitleFontSize()));
            this._baseTitleXML = new SubtitleXML(this, v.getVersion());
        } else {
            this.setFont(new Font(DataviewDefaultValues.getBaseTitleFontName(), ViewStyle.fontStyle(DataviewDefaultValues.isBaseTitleFontBold(), DataviewDefaultValues.isBaseTitleFontItalic()), DataviewDefaultValues.getFootnoteFontSize()));
            this._baseTitleXML = new FootnoteXML(this, v.getVersion());
        }
        this.init();
    }

    @Override
    public void setVisible(boolean b) {
        this.m_visible = b;
    }

    @Override
    public int getID() {
        return this.m_id;
    }

    @Override
    public String getComponentName() {
        if (this.m_id == 6) {
            return "DataviewTitle";
        }
        if (this.m_id == 7) {
            return "DataviewSubtitle";
        }
        return "DataviewFootnote";
    }

    @Override
    public boolean isVisible() {
        return this.m_visible;
    }

    @Override
    public void setText(String t) {
        if (t == null) {
            if (this.dataView != null) {
                this.dataView.getErrorHandler().log(this.dataView.getIntlString(m_errorMsg), this.getClass().getName(), m_method_setText);
            }
            return;
        }
        this.m_text = t;
    }

    @Override
    public String getText() {
        TokenSubstitution vs = this.dataView.getTokenSubstitution();
        return vs.getParsedString(this.m_text);
    }

    @Override
    public String getUnParseText() {
        return this.m_text;
    }

    @Override
    public void setFont(Font f) {
        if (f.getSize() <= 0) {
            if (this.dataView != null) {
                this.dataView.getErrorHandler().log(m_errorSetFont, this.getClass().getName(), m_method_setFont);
            }
            return;
        }
        this.m_font = f;
        this.setPropertyOverrideFlags(0);
        this.setPropertyOverrideFlags(2);
        this.setPropertyOverrideFlags(3);
        this.setPropertyOverrideFlags(1);
    }

    @Override
    public Font getFont() {
        return this.m_font;
    }

    public int getFontSize() {
        return this.getFont().getSize();
    }

    public void setFontSize(int size) {
        Font f = this.getFont();
        this.m_font = new Font(f.getName(), f.getStyle(), size);
        this.setPropertyOverrideFlags(1);
    }

    public String getFontName() {
        return this.getFont().getName();
    }

    public void setFontName(String name) {
        Font f = this.getFont();
        this.m_font = new Font(name, f.getStyle(), f.getSize());
        this.setPropertyOverrideFlags(0);
    }

    public boolean isFontBold() {
        return this.getFont().isBold();
    }

    public void setFontBold(boolean bold) {
        Font f = this.getFont();
        int style = f.getStyle();
        style = bold ? (style |= 1) : (style &= 0xFFFFFFFE);
        this.m_font = new Font(f.getName(), style, f.getSize());
        this.setPropertyOverrideFlags(2);
    }

    public boolean isFontItalic() {
        return this.getFont().isItalic();
    }

    public void setFontItalic(boolean italic) {
        Font f = this.getFont();
        int style = f.getStyle();
        style = italic ? (style |= 2) : (style &= 0xFFFFFFFD);
        this.m_font = new Font(f.getName(), style, f.getSize());
        this.setPropertyOverrideFlags(3);
    }

    @Override
    public void setStyleProperty(int attrID, String value) {
        switch (attrID) {
            case 0: {
                this.setFontName(value);
                break;
            }
            case 1: {
                this.setFontSize(Integer.valueOf(value));
                break;
            }
            case 2: {
                this.setFontBold(Boolean.valueOf(value));
                break;
            }
            case 3: {
                this.setFontItalic(Boolean.valueOf(value));
                break;
            }
        }
    }

    @Override
    public void setUnderline(boolean underline) {
        this.m_underline = underline;
        this.setPropertyOverrideFlags(6);
    }

    @Override
    public boolean isUnderline() {
        return this.m_underline;
    }

    @Override
    public void setHorizontalAlignment(int horizontalAlignment) {
        this.m_hAlign = horizontalAlignment;
    }

    @Override
    public int getHorizontalAlignment() {
        return this.m_hAlign;
    }

    @Override
    public Color getBackground() {
        return this.m_background;
    }

    @Override
    public void setBackground(Color bg) {
        this.m_background = bg;
        this.setPropertyOverrideFlags(5);
    }

    @Override
    public Color getForeground() {
        return this.m_foreground;
    }

    @Override
    public void setForeground(Color fg) {
        this.m_foreground = fg;
        this.setPropertyOverrideFlags(4);
    }

    @Override
    public BeanInfo getBeanInfo() {
        return null;
    }

    public String toString() {
        return this.getClass().getName();
    }

    @Override
    public void setXML(ObjectNode node, String version, int reset) {
        this._baseTitleXML.setXML(node, version, reset);
    }

    @Override
    public void setXML(ObjectNode node, String version, int reset, HashMap map) {
        this._baseTitleXML.setXML(node, version, reset, map);
    }

    @Override
    public ObjectNode getXML(boolean allProperties) {
        return this._baseTitleXML.getXML(allProperties);
    }

    public void resetToDefault(int reset) {
        this._baseTitleXML.resetToDefault(reset);
        this.createPropertyOverrideFlags();
    }

    @Override
    public boolean isForegroundUsed() {
        return this.isUserOverrideFlag(4);
    }

    @Override
    public boolean isBackgroundUsed() {
        return this.isUserOverrideFlag(5);
    }

    @Override
    public void setStyleXML(ObjectNode node, String version, int reset) {
        this._baseTitleXML.setStyleXML(node);
    }

    @Override
    public ObjectNode getStyleXML(boolean allProperties) {
        return this._baseTitleXML.getStyleXML(allProperties);
    }

    public void createPropertyOverrideFlags() {
        if (this.dataView != null) {
            this._userOverrideFlags = this.dataView.createPropertyOverrideFlags(8);
            this._styleOverrideFlags = this.dataView.createPropertyOverrideFlags(8);
        }
    }

    private void setPropertyOverrideFlags(int attrID) {
        if (this.dataView != null) {
            this.dataView.setPropertyOverrideFlags(attrID, this._userOverrideFlags, this._styleOverrideFlags);
        }
    }

    @Override
    public boolean isUserOverrideFlag(int attrID) {
        if (this.dataView == null) {
            return false;
        }
        return this.dataView.isPropertyOverrideFlag(attrID, this._userOverrideFlags);
    }

    @Override
    public boolean isStyleOverrideFlag(int attrID) {
        if (this.dataView == null) {
            return false;
        }
        return this.dataView.isPropertyOverrideFlag(attrID, this._styleOverrideFlags);
    }

    public void resetStyle() {
        this._baseTitleXML.resetStyle();
        this.createPropertyOverrideFlags();
    }

    protected void init() {
        this.initState();
        this.createPropertyOverrideFlags();
    }

    protected void initState() {
        this.establishBaseState();
        this.establishCheckpointState();
    }

    public void establishBaseState() {
        this.m_baseState = this._getBaseState(this.m_baseState);
    }

    public void establishCheckpointState() {
        this.m_checkpointState = this._getBaseState(this.m_checkpointState);
    }

    private TitleState _getBaseState(TitleState baseTitle) {
        if (baseTitle == null) {
            baseTitle = new TitleState(this.m_text, this.m_visible);
        } else {
            baseTitle.setText(this.getText());
            baseTitle.setVisible(this.isVisible());
        }
        return baseTitle;
    }

    public void setStateAsObjectNode(ObjectNode node, boolean isCheckpoint) {
        PropertyNode pNode = null;
        TitleState baseState = isCheckpoint ? this.m_checkpointState : this.m_baseState;
        pNode = node == null ? null : node.getProperty(s_text);
        this.setText(pNode == null ? baseState.getText() : pNode.getValueAsString());
        pNode = node == null ? null : node.getProperty(s_visible);
        this.setVisible(pNode == null ? baseState.isVisible() : Utility.getValueAsBoolean((PropertyNode)pNode));
    }

    public ObjectNode getStateAsObjectNode(String nodeName, boolean isCheckpoint) {
        TitleState baseTitle;
        ObjectNode node = new ObjectNode(nodeName);
        boolean hasState = false;
        TitleState titleState = baseTitle = isCheckpoint ? this.m_checkpointState : this.m_baseState;
        if (!Utility.compareObj((Object)baseTitle.getText(), (Object)this.getText())) {
            node.addProperty(s_text, this.getText());
            hasState = true;
        }
        if (baseTitle.isVisible() != this.isVisible()) {
            node.addProperty(s_visible, Utility.getBooleanAsChar((boolean)this.isVisible()));
            hasState = true;
        }
        return hasState ? node : null;
    }

    class TitleState {
        private String m_baseText = DataviewDefaultValues.getBaseTitleText();
        private boolean m_baseVisible = DataviewDefaultValues.isBaseTitleVisible();

        public TitleState() {
        }

        public TitleState(String text, boolean visible) {
            this.m_baseText = text;
            this.m_baseVisible = visible;
        }

        protected String getText() {
            return this.m_baseText;
        }

        protected void setText(String text) {
            this.m_baseText = text;
        }

        protected boolean isVisible() {
            return this.m_baseVisible;
        }

        protected void setVisible(boolean visible) {
            this.m_baseVisible = visible;
        }
    }
}

