/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView;

import java.awt.Color;
import java.awt.Graphics;
import java.io.Serializable;
import java.util.Hashtable;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.painter.AbstractBorderPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.pivot.PivotHeader;
import oracle.bali.ewt.util.ImmInsets;
import oracle.dss.dataView.BorderPainter;
import oracle.dss.dataView.Dataview;
import oracle.dss.dataView.managers.ViewStyle;

public class CellBorderPainter
extends AbstractBorderPainter
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Color _color;
    private int _lineWidth;
    private int _top;
    private int _left;
    private int _bottom;
    private int _right;
    private static Hashtable _sTable = new Hashtable(50);
    private static Hashtable _sTable1 = new Hashtable(50);
    private ImmInsets _insets;
    private ImmInsets _hPageInsets;
    private int _topWidth = -1;
    private int _bottomWidth = -1;
    private int _leftWidth = -1;
    private int _rightWidth = -1;
    private Color _topColor = null;
    private Color _bottomColor = null;
    private Color _leftColor = null;
    private Color _rightColor = null;
    private boolean _borderSeparateSetting = false;

    public CellBorderPainter(Color color, int lineWidth, int top, int left, int bottom, int right) {
        this._color = color;
        this._topWidth = this._lineWidth = lineWidth;
        this._leftWidth = this._lineWidth;
        this._bottomWidth = this._lineWidth;
        this._rightWidth = this._lineWidth;
        this._top = top;
        this._left = left;
        this._bottom = bottom;
        this._right = right;
        this._clearInsets();
    }

    public static CellBorderPainter getPainter(Color color, int lineWidth, int top, int left, int bottom, int right, boolean separated) {
        long mask = 0L;
        long ltop = top;
        long lleft = left;
        long lbottom = bottom;
        long lright = right;
        long lhash = color.hashCode();
        long lwidth = lineWidth;
        CellBorderPainter painter = null;
        Long key = null;
        if (!separated) {
            mask = mask | lhash << 40 | ltop << 37 | lleft << 34 | lbottom << 31 | lright << 28 | lwidth & 0xFFFFFFL;
            key = new Long(mask);
            painter = (CellBorderPainter)_sTable.get(key);
        }
        if (painter == null || separated) {
            painter = new CellBorderPainter(color, lineWidth, top, left, bottom, right);
            if (_sTable.size() > 300) {
                _sTable = new Hashtable(50);
            }
            if (!separated) {
                _sTable.put(key, painter);
            }
        }
        painter.setBorderSeparateSetting(separated);
        return painter;
    }

    protected void paintBorder(PaintContext context, Graphics g, int x, int y, int width, int height) {
        if (context.getComponent() instanceof Header || context.getComponent().getParent() instanceof PivotHeader) {
            --width;
            --height;
        }
        try {
            ViewStyle style = (ViewStyle)context.getPaintData((Object)"Appearance");
            if (style.isHPageBreak() && !((Dataview)style.getView()).printOrPreviewMode) {
                BorderPainter.paintBorder(g, x, y, width, height, 1, Color.black, 7, 2, 7, 7);
                --height;
            }
        }
        catch (ClassCastException cce) {
            // empty catch block
        }
        if (this._borderSeparateSetting) {
            BorderPainter.paintBorder(g, x, y, width, height, this._lineWidth, this._color, this._top, this._bottom, this._left, this._right, this._topWidth, this._bottomWidth, this._leftWidth, this._rightWidth, this._topColor, this._bottomColor, this._leftColor, this._rightColor);
        } else {
            BorderPainter.paintBorder(g, x, y, width, height, this._lineWidth, this._color, this._top, this._bottom, this._left, this._right);
        }
    }

    public ImmInsets getOwnInsets(PaintContext context) {
        try {
            ViewStyle style = (ViewStyle)context.getPaintData((Object)"Appearance");
            if (style != null && style.isHPageBreak()) {
                return this._constructInsets(true);
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return this._constructInsets(false);
    }

    public void setBorderSeparateSetting(boolean trueOrFalse) {
        this._borderSeparateSetting = trueOrFalse;
    }

    public boolean getBorderSeparateSetting() {
        return this._borderSeparateSetting;
    }

    public void setBorderTopLineWidth(int width) {
        this._topWidth = width;
        this._clearInsets();
    }

    public void setBorderLeftLineWidth(int width) {
        this._leftWidth = width;
        this._clearInsets();
    }

    public void setBorderBottomLineWidth(int width) {
        this._bottomWidth = width;
        this._clearInsets();
    }

    public void setBorderRightLineWidth(int width) {
        this._rightWidth = width;
        this._clearInsets();
    }

    public int getBorderTopLineWidth() {
        return this._topWidth;
    }

    public int getBorderLeftLineWidth() {
        return this._leftWidth;
    }

    public int getBorderBottomLineWidth() {
        return this._bottomWidth;
    }

    public int getBorderRightLineWidth() {
        return this._rightWidth;
    }

    public void setBorderTopColor(Color color) {
        this._topColor = color;
    }

    public void setBorderLeftColor(Color color) {
        this._leftColor = color;
    }

    public void setBorderBottomColor(Color color) {
        this._bottomColor = color;
    }

    public void setBorderRightColor(Color color) {
        this._rightColor = color;
    }

    public Color getBorderTopColor() {
        return this._topColor;
    }

    public Color getBorderLeftColor() {
        return this._leftColor;
    }

    public Color getBorderBottomColor() {
        return this._bottomColor;
    }

    public Color getBorderRightColor() {
        return this._rightColor;
    }

    protected boolean isBorderTransparent(PaintContext context) {
        return true;
    }

    private boolean anyBorder(int _style) {
        return _style != 7 && _style != 0;
    }

    private void _clearInsets() {
        this._insets = null;
        this._hPageInsets = null;
    }

    private ImmInsets _constructInsets(boolean hPageBreak) {
        if (hPageBreak) {
            if (this._hPageInsets != null) {
                return this._hPageInsets;
            }
        } else if (this._insets != null) {
            return this._insets;
        }
        ImmInsets insets = null;
        int topWidth = 0;
        int leftWidth = 0;
        int bottomWidth = 0;
        int rightWidth = 0;
        if (this.anyBorder(this._top)) {
            topWidth = this._topWidth;
            if (topWidth < 0) {
                topWidth = 0;
            }
            if (this._top == 6 && topWidth > 0) {
                topWidth += topWidth + 1;
            }
        } else {
            topWidth = 0;
        }
        if (this.anyBorder(this._left)) {
            leftWidth = this._leftWidth;
            if (leftWidth < 0) {
                leftWidth = 0;
            }
            if (this._left == 6 && leftWidth > 0) {
                leftWidth += leftWidth + 1;
            }
        } else {
            leftWidth = 0;
        }
        if (this.anyBorder(this._right)) {
            rightWidth = this._rightWidth;
            if (rightWidth < 0) {
                rightWidth = 0;
            }
            if (this._right == 6 && rightWidth > 0) {
                rightWidth += rightWidth + 1;
            }
        } else {
            rightWidth = 0;
        }
        if (this.anyBorder(this._bottom)) {
            bottomWidth = this._bottomWidth;
            if (bottomWidth < 0) {
                bottomWidth = 0;
            }
            if (this._bottom == 6 && bottomWidth > 0) {
                bottomWidth += bottomWidth + 1;
            }
        } else {
            bottomWidth = 0;
        }
        if (hPageBreak) {
            this._hPageInsets = insets = new ImmInsets(topWidth, leftWidth, bottomWidth + 1, rightWidth);
        } else {
            this._insets = insets = new ImmInsets(topWidth, leftWidth, bottomWidth, rightWidth);
        }
        return insets;
    }
}

