/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView;

import oracle.dss.dataView.AttributeFormatter;
import oracle.dss.dataView.CommonDataview;
import oracle.dss.util.DataAccess;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.LayerOutOfRangeException;
import oracle.dss.util.SliceOutOfRangeException;

public class AttributeFormatUtils {
    public static Object getAttributeFormattedMemberMetadataValue(CommonDataview dataView, int edge, int slice, int layer) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        Object metadata = dataView.getDataAccess().getMemberMetadata(edge, layer, slice, "date");
        if (metadata == null) {
            metadata = dataView.getDataAccess().getMemberMetadata(edge, layer, slice, "dataValue");
        }
        return AttributeFormatUtils.getAttributeFormattedValue(dataView, edge, layer, metadata);
    }

    public static Object getAttributeFormattedSliceValue(CommonDataview dataView, int edge, int slice, String memberLabelType) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        DataAccess dataAccess = dataView.getDataAccess();
        String label = "";
        int max = dataAccess.getLayerCount(edge);
        for (int i = 0; i < max; i += dataAccess.getMemberDepth(edge, i, slice)) {
            try {
                Object currentValue = AttributeFormatUtils.getAttributeFormattedMemberMetadataValue(dataView, edge, slice, i);
                if (currentValue == null) {
                    currentValue = dataAccess.getMemberMetadata(edge, i, slice, memberLabelType);
                }
                if (currentValue == null) continue;
                label = label + currentValue + " ";
                continue;
            }
            catch (LayerOutOfRangeException e) {
                throw new SliceOutOfRangeException(e.getMessage(), (Exception)((Object)e));
            }
        }
        return label.trim();
    }

    public static Object getAttributeFormattedValue(CommonDataview dataView, int edge, int layer, Object value) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        Object layerLabel;
        String formattedValue = null;
        AttributeFormatter attributeFormatter = dataView.getAttributeFormatter();
        if (value != null && attributeFormatter.hasAttributeFormatter(layerLabel = dataView.getDataAccess().getLayerMetadata(edge, layer, "layerName"))) {
            formattedValue = attributeFormatter.formatAsString(layerLabel, value);
        }
        return formattedValue;
    }
}

