/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.crosstab;

import java.util.EventListener;
import oracle.dss.crosstab.ColHeaderData;
import oracle.dss.crosstab.ColumnHeaderPivotHandleData;
import oracle.dss.crosstab.Crosstab;
import oracle.dss.crosstab.CrosstabData;
import oracle.dss.crosstab.CrosstabDefaultValues;
import oracle.dss.crosstab.CrosstabModel;
import oracle.dss.crosstab.RowHeaderData;
import oracle.dss.crosstab.RowHeaderPivotHandleData;
import oracle.dss.dataView.DrillEvent;
import oracle.dss.gridView.GridViewModelAdapter;
import oracle.dss.util.DataDirector;
import oracle.dss.util.DataDirectorException;
import oracle.dss.util.DataMap;
import oracle.dss.util.DataSource;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.LayerMetadataMap;
import oracle.dss.util.LayerOutOfRangeException;
import oracle.dss.util.MetadataMap;
import oracle.dss.util.SliceOutOfRangeException;

public class CrosstabModelAdapter
extends GridViewModelAdapter
implements CrosstabModel,
Cloneable {
    private static final long serialVersionUID = 1L;
    protected RowHeaderData rowHeaderData = null;
    protected ColHeaderData colHeaderData = null;
    protected ColumnHeaderPivotHandleData colHandleData = null;
    protected RowHeaderPivotHandleData rowHandleData = null;
    protected boolean enableIndent = CrosstabDefaultValues.isIndentEnabled();
    protected int autoIndent = CrosstabDefaultValues.getAutoIndent();
    protected boolean ol = CrosstabDefaultValues.isOutline();
    protected CrosstabData dataSource = null;
    protected Crosstab crosstab = null;
    private static final String m_method_setautoindent = "setAutoIndent (int i)";
    private static final String m_method_setsupporteddatalayerflags = "setSupportedDataLayerFlags ()";

    public CrosstabModelAdapter(Crosstab crosstab) {
        super(crosstab);
        this.crosstab = crosstab;
    }

    @Override
    public void setDataSource(DataSource ds) {
        super.setDataSource(ds);
        if (this.dataDirectorFactory != null) {
            this.setDataDirector((DataDirector)this.dataDirectorFactory.createCubeDataDirector());
        }
    }

    @Override
    protected void setSupportedDataLayerFlags() {
        super.setSupportedDataLayerFlags();
        MetadataMap metaMap = this.getDataDirector().getSupportedMetadataMap();
        LayerMetadataMap layerMap = this.getDataDirector().getSupportedLayerMetadataMap();
        boolean typeSupported = false;
        typeSupported = metaMap != null ? metaMap.contains((Object)"indent") : false;
        this.crosstab.setMetadataIndentSupported(typeSupported);
        typeSupported = metaMap != null ? metaMap.contains((Object)"relIndent") : false;
        this.crosstab.setMetadataRelIndentSupported(typeSupported);
        typeSupported = metaMap != null ? metaMap.contains((Object)"isTotal") : false;
        this.crosstab.setMetadataIsTotalSupported(typeSupported);
        typeSupported = layerMap != null ? layerMap.contains((Object)"dimDrillState") : false;
        this.crosstab.setLayerMetaDrillStateSupported(typeSupported);
        typeSupported = layerMap != null ? layerMap.contains((Object)"dimIsMeasure") : false;
        this.crosstab.setLayerMetaMeasureSupported(typeSupported);
    }

    @Override
    public ColHeaderData getColumnDataSource() {
        return this.colHeaderData;
    }

    @Override
    public RowHeaderData getRowDataSource() {
        return this.rowHeaderData;
    }

    @Override
    public CrosstabData getCrosstabDataSource() {
        return this.dataSource;
    }

    @Override
    public RowHeaderPivotHandleData getRowHeaderHandleDataSource() {
        return this.rowHandleData;
    }

    @Override
    public ColumnHeaderPivotHandleData getColumnHeaderHandleDataSource() {
        return this.colHandleData;
    }

    @Override
    public void newRowPivotHandleDataSource() {
        try {
            this.rowHandleData = this.crosstab.getCrosstabModel().isRowHeaderVisible() ? new RowHeaderPivotHandleData(this, this.crosstab) : null;
        }
        catch (EdgeOutOfRangeException edgeOutOfRangeException) {
            // empty catch block
        }
    }

    @Override
    public void newColumnPivotHandleDataSource() {
        try {
            this.colHandleData = this.crosstab.getCrosstabModel().isColumnHeaderVisible() ? new ColumnHeaderPivotHandleData(this, this.crosstab) : null;
        }
        catch (EdgeOutOfRangeException edgeOutOfRangeException) {
            // empty catch block
        }
    }

    @Override
    public void newRowDataSource() {
        this.rowHeaderData = this.crosstab.getCrosstabModel().isRowHeaderVisible() ? new RowHeaderData(this.crosstab) : null;
    }

    @Override
    public void newColDataSource() {
        this.colHeaderData = this.crosstab.getCrosstabModel().isColumnHeaderVisible() ? new ColHeaderData(this.crosstab) : null;
    }

    @Override
    public void newDataSource() {
        this.dataSource = new CrosstabData(this, this.crosstab);
        super.setGridViewDataSource(this.dataSource);
    }

    @Override
    public void setIndentEnabled(boolean b) {
        if (this.enableIndent != b) {
            this.enableIndent = b;
            this.clearMetadataCache();
        }
    }

    @Override
    public boolean isIndentEnabled() {
        return this.enableIndent;
    }

    @Override
    public void setAutoIndent(int i) {
        if (i < 0) {
            this.getErrorHandler().log("invalid number of spaces", this.getClass().getName(), m_method_setautoindent);
        } else if (this.autoIndent != i) {
            this.autoIndent = i;
            this.clearMetadataCache();
        }
    }

    @Override
    public int getAutoIndent() {
        return this.autoIndent;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        CrosstabModelAdapter cma = new CrosstabModelAdapter(this.crosstab);
        Object[] o = this.listenerList.getListenerList();
        for (int l = 2; l < o.length; l += 2) {
            cma.listenerList.add((Class)o[l], (EventListener)o[l + 1]);
        }
        return cma;
    }

    @Override
    public boolean drillGestureHappened(Object source, int edge, int layer, int slice, int flags) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException, DataDirectorException {
        if (slice == -2) {
            DrillEvent e = new DrillEvent(source, edge, layer, slice, flags);
            this.fireviewDrillRequesting(e);
            if (e.isConsumed()) {
                return false;
            }
            this.fireviewDrillRequested(e);
            return true;
        }
        return super.drillGestureHappened(source, edge, layer, slice, flags);
    }

    @Override
    public boolean canDrill(Object source, int edge, int layer, int slice, int flags) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException, DataDirectorException {
        if (slice < 0) {
            return true;
        }
        return super.canDrill(source, edge, layer, slice, flags);
    }

    @Override
    public void setOutline(boolean outline) {
        this.ol = outline;
    }

    @Override
    public boolean isOutline() {
        return this.ol;
    }

    @Override
    public boolean isRowHeaderVisible() {
        try {
            return this.getDataAccess().getLayerCount(1) > 0 && this.getDataAccess().getEdgeExtent(1) > 0;
        }
        catch (EdgeOutOfRangeException e) {
            this.crosstab.getErrorHandler().error((Throwable)e, this.getClass().getName(), "isRowHeaderVisible");
            return false;
        }
    }

    @Override
    public boolean isColumnHeaderVisible() {
        try {
            return this.getDataAccess().getLayerCount(0) > 0 && this.getDataAccess().getEdgeExtent(0) > 0;
        }
        catch (EdgeOutOfRangeException e) {
            this.crosstab.getErrorHandler().error((Throwable)e, this.getClass().getName(), "isColumnHeaderVisible");
            return false;
        }
    }

    @Override
    public LayerMetadataMap getLayerMetadataMap(int edge) {
        String[] types = new String[]{"layerName", "layerLabel", "dimMediumName", "dimShortName", "dimDrillState", "dimIsMeasure", "viewStyle"};
        return new LayerMetadataMap(types);
    }

    @Override
    public MetadataMap getMetadataMap(int edge) {
        String[] types = new String[]{"value", "label", "mediumName", "shortName", "indent", "relIndent", "drillState", "viewStyle", "isTotal"};
        return new MetadataMap(types);
    }

    @Override
    public DataMap getDataMap() {
        String[] types = new String[]{"dataValue", "dataFormattedValue", "dataRatio", "dataViewFormat", "dataViewStyle", "dataAnnotation", "dataIsTotal", "dataType"};
        return new DataMap(types);
    }
}

