/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.crosstab;

import oracle.dss.crosstab.Crosstab;
import oracle.dss.crosstab.CrosstabModel;
import oracle.dss.gridView.HeaderCell;
import oracle.dss.util.DataException;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.LayerOutOfRangeException;
import oracle.dss.util.SliceOutOfRangeException;

public abstract class CrosstabHeaderCell
extends HeaderCell {
    private static final long serialVersionUID = 1L;
    protected CrosstabModel m_model = null;
    protected Crosstab m_crosstab = null;

    public CrosstabHeaderCell(Crosstab crosstab, int layer, int depth, int slice, int extent) {
        super(crosstab, layer, depth, slice, extent);
        this.m_crosstab = crosstab;
        this.m_model = crosstab.getCrosstabModel();
    }

    @Override
    public Object getData() {
        try {
            String memberLabelType;
            this.info.setEdgeDepthIndex(this.getEdge(), this.m_layer, this.m_slice);
            Object value = this.m_model.getMetadataCache().get(this.info);
            if (value == null && this.m_crosstab.isMemberMetadataLabelTypeSupported(memberLabelType = this.m_crosstab.getMemberMetadataLabelType(this.getEdge()))) {
                Object metadata = this.m_crosstab.getMetadataFromDataAccess(this.getEdge(), this.m_layer, this.m_slice, memberLabelType, this.m_model.getDataAccess());
                value = this.applyIndent(this.m_model.getGridViewFormatManager().formatMetadataValue(this.m_crosstab, metadata, this.getEdge(), this.m_layer, this.m_slice, null), this.getEdge(), this.m_layer, this.m_slice);
                this.m_model.getMetadataCache().put(this.info.clone(), value);
            }
            return value;
        }
        catch (DataException e) {
            this.m_model.getErrorHandler().error((Throwable)e, this.getClass().getName(), "getData");
            return null;
        }
    }

    public int getIndent() {
        return this.m_layer;
    }

    protected int getStartLayer() {
        return this.m_layer;
    }

    protected int getDepth() {
        return this.m_depth;
    }

    protected int getStartSlice() {
        return this.m_slice;
    }

    protected int getExtent() {
        return this.m_extent;
    }

    protected abstract String applyIndent(String var1, int var2, int var3, int var4) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException;
}

