/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.crosstab;

import java.io.FileNotFoundException;
import java.util.Locale;
import oracle.dss.crosstab.CrosstabCommon;
import oracle.dss.dataView.EdgeComponentHandle;
import oracle.dss.dataView.managers.ViewStyle;
import oracle.dss.gridView.CSSStyle;
import oracle.dss.gridView.GridViewExcelHTMLExport;
import oracle.dss.util.DataAccess;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.ErrorHandler;
import oracle.dss.util.LayerOutOfRangeException;
import oracle.dss.util.SliceOutOfRangeException;

public class CrosstabExcelHTMLExport
extends GridViewExcelHTMLExport {
    protected CrosstabCommon m_crosstab;
    private boolean m_bOutline = false;
    protected static final StringBuffer INDENT_UNIT = new StringBuffer("&nbsp;");

    public CrosstabExcelHTMLExport(Locale locale, ErrorHandler eh) {
        super(locale, eh);
    }

    public CrosstabExcelHTMLExport(CrosstabCommon crosstab) {
        super(crosstab);
        this.m_crosstab = crosstab;
    }

    @Override
    protected void init() throws EdgeOutOfRangeException, FileNotFoundException, Exception {
        super.init();
        if (this.m_gridView != null) {
            this.m_bOutline = this.m_gridView.getModel().getDataDirector().isOutline();
        }
    }

    protected boolean isOutline() {
        return this.m_bOutline;
    }

    @Override
    protected int getColumnHeaderRowCount() throws EdgeOutOfRangeException {
        int colHeaderRowCount = 0;
        DataAccess dataAccess = this.m_gridView.getModel().getDataAccess();
        colHeaderRowCount = dataAccess.getLayerCount(0);
        return colHeaderRowCount;
    }

    @Override
    protected int getRowHeaderColumnCount() throws EdgeOutOfRangeException {
        int rowHeaderColCount = 0;
        if (this.isOutline()) {
            rowHeaderColCount = 1;
        } else {
            DataAccess dataAccess = this.m_gridView.getModel().getDataAccess();
            rowHeaderColCount = dataAccess.getLayerCount(1);
        }
        return rowHeaderColCount;
    }

    @Override
    protected void exportColumnHeaderRow(int row, int startCol, int endCol) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        DataAccess dataAccess = this.m_gridView.getModel().getDataAccess();
        StringBuffer rowSB = new StringBuffer(2048);
        int col = startCol;
        while (col <= endCol) {
            String s;
            EdgeComponentHandle handle;
            CSSStyle style;
            ViewStyle initStyle;
            ViewStyle viewStyle;
            int startLayer = row;
            int startSlice = col;
            int memberDepth = 1;
            int memberExtent = 1;
            startLayer = dataAccess.getMemberStartLayer(0, row, col);
            startSlice = dataAccess.getMemberStartSlice(0, row, col);
            memberDepth = dataAccess.getMemberDepth(0, row, col);
            memberExtent = dataAccess.getMemberExtent(0, row, col);
            if (col == startCol && startSlice < col) {
                int sliceDiff = col - startSlice;
                startSlice = col;
                memberExtent -= sliceDiff;
            }
            if (row != startLayer || col != startSlice) {
                col = startSlice + memberExtent;
                continue;
            }
            int extent = memberExtent;
            if (startSlice + memberExtent > endCol + 1) {
                extent = endCol - startSlice + 1;
            }
            rowSB.append("    <td");
            rowSB.append(" class=\"" + this.getStyleClass("bibch") + "\"");
            if (extent > 1) {
                rowSB.append(" colspan=" + extent);
            }
            if (memberDepth > 1) {
                rowSB.append(" rowspan=" + memberDepth);
            }
            Object metadata = null;
            String memberLabelType = this.m_gridView.getMemberMetadataLabelType(0);
            if (this.m_gridView.isMemberMetadataLabelTypeSupported(memberLabelType)) {
                metadata = dataAccess.getMemberMetadata(0, row, col, memberLabelType);
            }
            if ((viewStyle = this.m_headerStyleMgr.getMetadataStyle(this.m_gridView, metadata, initStyle = this.getClearColumnHeaderViewStyle(), 0, row, col)) != null && viewStyle.isAnythingOverridden() && (style = this.convertViewStyleToCSSStyle(viewStyle, handle = new EdgeComponentHandle(10, "ColumnHeader", this.m_gridView, 0, row, col))) != null) {
                rowSB.append(" style='" + style.toInlineString() + "'");
            }
            rowSB.append(">");
            if (metadata != null && (s = metadata.toString()) != null) {
                if ((s = this.filterChars(s)).length() > CrosstabExcelHTMLExport.getMaxCellContentLength()) {
                    s = s.substring(0, CrosstabExcelHTMLExport.getMaxCellContentLength());
                    this.m_eh.log("maximum cell content length exceeded - truncating", this.getClass().getName(), "exportColumnHeaderRow");
                }
                rowSB.append(s);
            }
            rowSB.append("</td>\n");
            col += memberExtent;
        }
        this.out(rowSB.toString());
    }

    @Override
    protected void exportRowHeaderRow(int row, int startRow, int endRow, int rowHeaderColCount) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        DataAccess dataAccess = this.m_gridView.getModel().getDataAccess();
        StringBuffer rowSB = new StringBuffer();
        int col = 0;
        while (col < rowHeaderColCount) {
            String s;
            EdgeComponentHandle handle;
            CSSStyle style;
            ViewStyle initStyle;
            ViewStyle viewStyle;
            int startLayer = col;
            int startSlice = row;
            int memberDepth = 1;
            int memberExtent = 1;
            int sliceOutlineLayer = col;
            startLayer = dataAccess.getMemberStartLayer(1, col, row);
            startSlice = dataAccess.getMemberStartSlice(1, col, row);
            if (this.isOutline()) {
                memberDepth = 1;
                sliceOutlineLayer = dataAccess.getSliceOutlineLayer(1, row);
            } else {
                memberDepth = dataAccess.getMemberDepth(1, col, row);
            }
            memberExtent = dataAccess.getMemberExtent(1, col, row);
            if (row == startRow && startSlice < row) {
                int sliceDiff = row - startSlice;
                startSlice = row;
                memberExtent -= sliceDiff;
            }
            if (col != startLayer || row != startSlice) {
                col = startLayer + memberDepth;
                continue;
            }
            int extent = memberExtent;
            if (startSlice + memberExtent > endRow + 1) {
                extent = endRow - startSlice + 1;
            }
            rowSB.append("    <td");
            rowSB.append(" class=\"" + this.getStyleClass("bibrh") + "\"");
            if (memberDepth > 1) {
                rowSB.append(" colspan=");
                rowSB.append(memberDepth);
            }
            if (extent > 1) {
                rowSB.append(" rowspan=");
                rowSB.append(extent);
            }
            Object metadata = null;
            String memberLabelType = this.m_gridView.getMemberMetadataLabelType(1);
            if (this.m_gridView.isMemberMetadataLabelTypeSupported(memberLabelType)) {
                metadata = dataAccess.getMemberMetadata(1, sliceOutlineLayer, row, memberLabelType);
            }
            if ((viewStyle = this.m_headerStyleMgr.getMetadataStyle(this.m_gridView, metadata, initStyle = this.getClearRowHeaderViewStyle(), 1, sliceOutlineLayer, row)) != null && viewStyle.isAnythingOverridden() && (style = this.convertViewStyleToCSSStyle(viewStyle, handle = new EdgeComponentHandle(11, "RowHeader", this.m_gridView, 1, sliceOutlineLayer, row))) != null) {
                rowSB.append(" style='" + style.toInlineString() + "'");
            }
            rowSB.append(">");
            if (metadata != null && (s = metadata.toString()) != null) {
                s = this.filterChars(s);
                if (this.isOutline()) {
                    StringBuffer prefix = new StringBuffer();
                    int totalIndent = sliceOutlineLayer * this.m_crosstab.getAutoIndent();
                    for (int i = 0; i < totalIndent; ++i) {
                        prefix.append(INDENT_UNIT);
                    }
                    s = prefix + s;
                } else if (this.m_crosstab.isIndentEnabled()) {
                    Object levelObj = null;
                    if (this.m_crosstab.isMetadataRelIndentSupported()) {
                        levelObj = dataAccess.getMemberMetadata(1, col, row, "relIndent");
                    } else if (this.m_crosstab.isMetadataIndentSupported()) {
                        levelObj = dataAccess.getMemberMetadata(1, col, row, "indent");
                    }
                    if (levelObj != null && levelObj instanceof Integer) {
                        int level = (Integer)levelObj;
                        StringBuffer prefix = new StringBuffer();
                        int totalIndent = level * this.m_crosstab.getAutoIndent();
                        for (int i = 0; i < totalIndent; ++i) {
                            prefix.append(INDENT_UNIT);
                        }
                        s = prefix + s;
                    }
                }
                if (s.length() > CrosstabExcelHTMLExport.getMaxCellContentLength()) {
                    s = s.substring(0, CrosstabExcelHTMLExport.getMaxCellContentLength());
                    this.m_eh.log("maximum cell content length exceeded - truncating", this.getClass().getName(), "exportRowHeaderRow");
                }
                rowSB.append(s);
            }
            rowSB.append("</td>\n");
            col += memberDepth;
        }
        this.out(rowSB.toString());
    }
}

